
!Short: DBFOPEN()           Open a database file.                        logical

 ^BDBFOPEN()

 ^BPurpose:

    To open a database file for use.

 ^BSyntax:

    <logical>= DBFOPEN(<file>,[<alias>],[<exclusive>])

 ^BParameters:

    <file>            The name of the file to open.  The file name must be
                      passed.  If the file name contains a path it will be
                      used, otherwise, the value of gaDir[DIR_DBF] will be
                      added.

    <alias>           The alias to associate with the open database.  If this
                      parameter is omitted, the alias becomes the base part
                      of the file name; use ALIAS() to determine.

    <exclusive>       If specified allows for forced shared or exclusive use
                      of a file.  If not specified, it takes on the current
                      setting of SET EXCLUSIVE ON/off.  By default SET
                      EXCLUSIVE is ON.

 ^BReturn:

    <logical>         TRUE if the file was opened as specified,
                      FALSE if not.

 ^BUsage:

    PRIVATE llCont, lnArea

    llCont= .F.
    lnArea= SELECT()

    IF DBFOPEN("foo","foo",.t.)      && FOO.DBF     alias: FOO     exclusive
       IF DBFOPEN("bar","bar",.f.)   && BAR.DBF     alias: BAR     shared
          IF DBFOPEN("cookie",0,.t.) && COOKIE.DBF  alias: COOKIE  exclusive
             llCont= .t.             && all files opened with success
          ENDIF                      &&
       ENDIF                         &&
    ENDIF                            &&

    IF !llCont                       && When open was not successful,
       DBFCLOSE(lnArea)              && close any files open after lnArea.
    ENDIF                            &&

    RETURN llCont


 ^BHistory:

    Thu  02-14-1991   Initial documentation and creation.

!SeeAlso: DBFCLOSE() DBFINIT()

