*:*********************************************************************
*:
*:        Program: GET_USER.PRG
*:
*:         System: RELIV
*:         Author: Stephe Natham
*:      Copyright (c) 1990, SN CONSULTING
*:
*:
*:  Procs & Fncts: SECURE()
*:
*:      Called by:
*:
*:          Calls: SECURE()       (function  in GET_USER.PRG)
*:
*:           Uses: USER.DBF           Alias: USER
*:
*:        Indexes: U_NAME.IDX
*:
*:      Documented 10/01/90 at 17:46               FoxDoc  version 2.01
*:*********************************************************************
*PROCEDURE get_user
* security input window , returns "X" for all characters input

*The function CHRTRAN() is the key to this program. It works best on a machine
*that is faster than an XT, preferably a 386. The reason being that if you look
*very closely, you will see the actual letters being written, then re-written
*as the character "X". It was fun figuring this simple little procedure out. If
*you have a better solution, I'd love to see it... leave a message in the ADBUS
*FoxBASE(FoxPRO) conference to Stephe Nathan.



CLEAR

msg = " Press <ENTER> to exit code entry "
@ 22,39-LEN(msg)/2 SAY msg

SET COLOR OF SCHEME 1 TO GR+/N,GR+/N,GR/N,B/BG,G+/N,B+/N,W/B,N/B,BG+/B,G/B
DEFINE WINDOW open FROM 5,10 TO 20,65 SYSTEM COLOR SCHEME 1
ACTI WIND open
@ 5,6 SAY "Y O U R   C O M P A N Y   L O G O   H E R E"

DEFI WIND code IN WIND OPEN FROM 11,20 TO 13,32 SYSTEM COLOR SCHEME 17
ACTI WIND code

USE user

PUBLIC user_name

* Initialize global variables
user_name = SPACE(10)
num_letrs = 1

* Do a read for each letter of the user code... <ENTER> to exit loop
DO WHILE num_letrs <= 10

   * Initialize a blank variable for each loop (code_name is a 1 char field)
   SCATTER MEMVAR BLANK

   @ 0,num_letrs GET m->code_name PICTURE "@!" ;
      VALID secure(m->code_name,num_letrs)
   READ
   IF LASTKEY()=13
      EXIT
   ENDIF
   num_letrs = num_letrs+1
   LOOP
ENDDO

SET SAFETY OFF
INDE ON name TO u_name
SET SAFETY ON
USE user INDE u_name
DEACT WIND ALL
RELE WIND code
RELE WIND open

* Seek name in user file to verify admittance
SEEK m->user_name

* Take desired action

RETURN


*!*********************************************************************
*!
*!       Function: SECURE()
*!
*!      Called by: GET_USER.PRG                  
*!
*!*********************************************************************
FUNCTION secure
PARAMETERS mcode_name,num_letrs

* store user's name to a string to search on later
DO WHILE num_letrs <=10
   IF num_letrs = 1
      STORE m->mcode_name TO user_name
      EXIT
   ELSE
      user_name = user_name +m->mcode_name
      EXIT
   ENDIF
ENDDO


* Convert input to character 'X'
m->mcode_name = CHRTRAN(m->mcode_name,m->mcode_name,"X")
m->code_name = m->mcode_name

RETURN .T.
*: EOF: GET_USER.PRG



*   Structure for database : USERS.DBF       Alias: USERS
*   Number of data records :         1
*             Last updated : 10/01/90 at 17:07
*   Field  Field name  Type        Width    Dec    Start      End
*       1  NAME        Character      10               1       10
*       2  DATE        Date            8              11       18
*       3  PROD_CODE   Character      10              19       28
*       4  CODE_NAME   Character       1              29       29
*   * Total **                       30
*
*
*   This database appears to be associated with index file(s):
*          : U_NAME.IDX  (NAME)

  NAME is a field to hold the user code
  DATE holds the date user was assigned access (could be sold-to date)
  PROD_CODE is a code I use for non-duplication of my software (not smart-proof)
  CODE_NAME is the field CHRTRAN() operates on and is left blank

