*:*********************************************************************
*:
*: Procedure file: SCROLDBF.PRG
*:
*:         System: Scrolling record selection box UDF()
*:         Author: Ed Rauh
*:      Copyright (c) 1988, Ed Rauh
*:                20 Upper Commons
*:                Woodbury, CT  06798
*:
*:                FidoNet 1:141/491.100 (MicroNet Research)
*:                Latest version available for f/req from
*:                1:141/215 (203/782-9787, d/l after validation)
*:
*:  Last modified: 01/07/89     19:43
*:
*:  Procs & Fncts: PICKONE
*:               : PICKIT
*:               : HIDISP
*:               : DIS
*:               : DISPRECS
*:               : PSB_ERR
*:
*:      Documented 01/08/89 at 16:08                SNAP!  version 3.12e
*:*********************************************************************
*!*********************************************************************
*!
*!      Procedure: PICKONE
*!
*!      Called by: DEMO.PRG                      
*!
*!          Calls: PSB_ERR        (procedure in SCROLDBF.PRG)
*!               : DISPRECS       (procedure in SCROLDBF.PRG)
*!               : HIDISP         (procedure in SCROLDBF.PRG)
*!               : PICKIT         (procedure in SCROLDBF.PRG)
*!
*!*********************************************************************
procedure pickone
parameters disp_line,list_head,match_test,key_prefix,ul_row,ul_col,num_rows,kill_after
*
*  PickOne() - display and scroll through the database in the current working
*              area (CWA) in a variable positioned and sized screen region
*              of a pop-up window.  Allow preconditioning of user-entered
*              keys and prevent selection of any records not meeting the
*              specified matching condition.  Key for the active index must
*              be of type char
*
*   Returns:   .T. if choice was made.  CWA positioned on selection.
*              .F. if Esc was pressed.  CWA positioned as at entry.
*
*              Fatal errors suspend program, return .F. if resumed
*
*   Arguments:
*              disp_line  - <ExpC>, macro of detail line content.  Must be
*                           expanded to a fixed-length string
*
*                           Example: [LastName+" "+str(salary,9,2)+" "+title]
*
*              list_head  - <ExpC>, Title of pop-up box
*
*                           Example: [Sales Department Salaries]
*
*              match_test - <ExpC>, macro of selection criteria test for
*                           valid, selectable records.  Must expand to a
*                           logical expression. Use [.t.] for no test
*
*                           Example: [Department="SALES"]
*
*              key_prefix - <ExpC>, used as prefix on key lookup
*
*                           Example: []
*
*              ul_row     - <ExpN> Range (0..21) First box row
*
*                           Example: 8
*
*              ul_col     - <ExpN> Range (0..77) First box column
*
*                           Example: 4
*
*              num_rows   - <ExpN> Range (1..22-ul_row) Max records on
*                           screen in box at one time.
*
*                            Example: 8
*
*              kill_after - <ExpN> - Maximum time to wait for a user to
*                           press a key before killing the program.  Use
*                           -1 to wait forever.
*
*                            Example: 600  (e.g. 10 minutes)
*
*
********************************
*  Sample usage:
*
*
*   && Set up a box containing 8 records at a time anchored at 7,14.
*   && Show the user str_fld_1, date_fld_2 and num_fld_3 for each record.
*   && Label the box "This year's entries"
*   && Only allow the user undeleted records, where the date in date_fld_2
*   && falls in the current year
*   && If the user does nothing for 10 minutes, kill the program
*
*   showme = 'str_fld_1+[ ]+dtoc(date_fld_2)+[ ]+str(num_fld_3,6,2)'
*   box_title = "This year's entries"
*   must_be = '.not. deleted() .and. (year(date_fld_2) = year(date()) )'
*   top_row = 7
*   left_col = 14
*   recs_inbox = 8
*   quit_in = 600
*
*   SET PROCEDURE TO scroldbf
*
*   a= PickOne(showme,box_title,must_be,'',top_row,left_col,recs_inbox,quit_in)
********************************
*  Validity tests and error handling:
*
*       ul_col not in range         - UDF displays error message, program
*       ul_row not in range           is SUSPENDed
*       num_rows < 1
*       type(disp_line) # 'C'
*       type(match_test) # 'L'
*       type('key_prefix') # 'C'
*       type('ul_row') # 'N'
*       type('ul_col') # 'N'
*       type('num_rows') # 'N'
*       type('kill_after') # 'N'
*
*       type('list_head') # 'C'     - Box heading is not displayed
*
*       ul_row+num_rows > 22        - num_rows reduced to (22-ul_row)
*
*       ul_col+len(&disp_line) > 78 - left(&disp_line,78-ul_col) used in
*                                     place of &disp_line
*
*       len(list_head) > boxsize    - left(list_head,boxsize) displayed
********************************
*
*  Gadgetry:
*
*  I write for multiuser environments, where it can be quite damaging for
*  an end-user to just walk away from a console with their program running,
*  perhaps while holding an active Flock() or Rlock(), or worse, preventing
*  someone from making a backup of the open datafiles.  I use a simple
*  inkey(1) timing loop to knock down the program after some period of
*  inactivity in the scroll box, specified in the kill_after parameter.
*
*  I've also found it preferable to use the match_test argument instead of
*  setting a filter.  End users seem to prefer seeing lines they can't use
*  blocked out with asterisks to variable delays in scroll times that can
*  occur when you SET FILTER TO <whatever argument was passed as match_test>
*  It can also be used in conjunction with a filter set on the file...
*


private pop_screen

* pop_screen preserves the screen at entry to the UDF

save screen to pop_screen

do case                         && Test for fatal error conditions
   
case type(disp_line) # 'C'
   do psb_err with 'Display line argument must evaluate to a string',disp_line
   return .f.
case type(match_test) # 'L'
   do psb_err with 'Record match test must evaluate to a logical expression',match_line
   return .f.
case type('key_prefix') # 'C'
   do psb_err with 'Key prefix must be a character expression',key_prefix
   return .f.
case type('ul_row') # 'N'
   do psb_err with 'Upper left row argument must be numeric',ul_row
   return .f.
case type('ul_col') # 'N'
   do psb_err with 'Upper left column argument must be numeric',ul_col
   return .f.
case type('num_rows') # 'N'
   do psb_err with 'Number of rows argument must be numeric',num_rows
   return .f.
case type('kill_after') # 'N'
   do psb_err with 'Wait time between keys must be numeric',kill_after
   return .f.
case ul_col < 0 .or. ul_col > 77
   do psb_err with 'Upper left column argument out of range (0..77)',ul_col
   return .f.
case ul_row < 0 .or. ul_row > 21
   do psb_err with 'Upper left row argument out of range (0..21)',ul_row
   return .f.
endcase

private _up, _down, _left, _right, _bell_chr
private _pgup, _pgdn, _home, _end, _return, _esc, _f1

* The code makes more sense referring to a variable for keystrokes instead
* of the inkey() values or chr() arguments.

_up = 5
_down = 24
_left = 19
_right = 4
_bell_chr = chr(7)
_pgup = 18
_pgdn = 3
_home = 1
_end = 6
_return = 13
_esc = 27
_f1 = 28


private on_row,rows,boxbot,boxtop,first_col,boxsize,disp_arg,init_recno

* on_row is current display row
* rows is the max records that can be displayed at once
* boxbot is last display row
* boxtop is first display row
* first_col is the first column of the scrolling area
* boxsize is the width of the scroll area
* disp_arg is the content of the display line
* init_recno is the file position at entry to the routine

init_recno = Iif(.not. (bof() .or. eof()), recno(), 1)

* The iif() ensures that we return to a valid record if we abort out

rows = iif(num_rows+ul_row < 23, num_rows, 22 - ul_row)
boxbot = ul_row + rows
boxtop = ul_row + 1
first_col = ul_col + 1
disp_arg = disp_line
boxsize = len(&disp_arg)
if first_col + boxsize > 78
   boxsize = 78 - first_col
   disp_arg = 'left(' + disp_line + ',' + str(boxsize,2) + ')'
endif

set color to n/w
@ ul_row, ul_col clear to boxbot + 1, first_col + boxsize
@ ul_row, ul_col to boxbot + 1, first_col + boxsize double
@ ul_row, first_col say iif(len(list_head) > boxsize, left(list_head, boxsize), list_head)

on_row = 0
set color to
do disprecs

skip boxtop - on_row
on_row = boxtop
do hidisp

private xkey

* xkey will hold the keystroke that exits the selection loop in pickit

xkey = 0
do pickit
restore screen from pop_screen

if xkey = _esc
   goto init_recno
endif

return (xkey # _esc)


*!*********************************************************************
*!
*!      Procedure: PICKIT
*!
*!      Called by: PICKONE        (procedure in SCROLDBF.PRG)
*!
*!          Calls: DISPRECS       (procedure in SCROLDBF.PRG)
*!               : HIDISP         (procedure in SCROLDBF.PRG)
*!               : DIS            (procedure in SCROLDBF.PRG)
*!
*!*********************************************************************
procedure pickit
private pickscreen, skey, rsave, savrow, helpcnt

* pickscreen holds the scroll screen if pop-up help is used
* skey is the ASCII value of the last keystroke scanned
* rsave saves the record pointer before a seek or skip action
* savrow holds the highlighted row position before PgUp or PgDn
* helpcnt works as a countdown timer for some inkey() loops


set escape off
do while .t.
   helpcnt = int(kill_after)              &&  if kill_after < 0, wait forever
   xkey = 0
   do while (xkey = 0) .and. (helpcnt # 0)
      xkey = inkey(1)
      helpcnt = helpcnt - 1
      @ 24,70 say time()
   enddo
   if xkey = 0
      unlock all
      quit
   endif
   skey = iif(xkey > 0,upper(chr(xkey)),'')
   do case
   case xkey = _esc .or. ( xkey = _return .and. &match_test )
      exit
   case skey >='A' .and. skey <='Z'
      rsave = recno()
      seek key_prefix+skey
      if found()
         do disprecs
         skip boxtop - on_row
         on_row = boxtop
         do hidisp
      else
         ? _bell_chr
         goto rsave
      endif
   case skey >='0' .and. skey <='9'
      rsave = recno()
      seek key_prefix+skey
      if found()
         do disprecs
         skip boxtop - on_row
         on_row = boxtop
         do hidisp
      else
         ? _bell_chr
         goto rsave
      endif
   case xkey =  _up
      if on_row > boxtop
         do dis
         on_row = on_row - 1
         skip -1
         do hidisp
      else
         skip -1
         if bof()
            ? _bell_chr
            goto top
         else
            do disprecs
            skip boxtop - on_row
            on_row = boxtop
            do hidisp
         endif
      endif
   case xkey =  _down
      if on_row < boxbot
         skip
         if eof()
            skip -1
            ? _bell_chr
            do hidisp
         else
            skip -1
            do dis
            skip
            on_row = on_row + 1
            do hidisp
         endif
      else
         skip 2-rows
         do disprecs
         do hidisp
      endif
   case xkey =  _pgdn
      savrow = on_row
      skip boxbot - on_row + 1
      if eof()
         ? _bell_chr
         skip -1
      endif
      do disprecs
      if on_row > savrow
         skip savrow - on_row
         on_row = savrow
      endif
      do hidisp
   case xkey =  _pgup
      savrow = on_row
      skip boxtop - on_row - rows
      if bof()
         ? _bell_chr
         goto top
      endif
      do disprecs
      skip savrow - on_row
      on_row = savrow
      do hidisp
   case xkey =  _home
      goto top
      do disprecs
      goto top
      on_row = boxtop
      do hidisp
   case xkey =  _end
      goto bott
      skip 1-rows
      if bof()
         skip
      endif
      do disprecs
      do hidisp
   case xkey = _f1
      save screen to pickscreen
      set color to +w/n
      @ 07,07 clear to 19,71
      @ 07,07 to 19,71
      set color to n/w
      @ 08,08 clear to 18,70
      @ 09,11 say "PgUp and PgDn scroll the selection window a page at a time"
      @ 10,12 say ""+chr(24)+" and "+chr(25)+" scroll the selection window one entry at a time"
      @ 11,10 say "Home and End move to the first and last entries respectively"
      @ 13,10 say "A letter (A-Z) or number (0-9) will jump to the first entry"
      @ 14,15 say "whose search key begins with that letter or number"
      @ 16,10 say "Pressing Return or Enter will select the highlighted entry"
      @ 17,09 say "Entries made up entirely of asterisks (*) cannot be selected"
      @ 18,10 say "Pressing Esc aborts selections.  F1 displays this message."
      @ 07,28 say "Help for selection boxes"
      @ 19,21 say "This help box will clear in    seconds"
      set color to *n/w
      clear TYPEAHEAD
      helpcnt = 20
      do while inkey(1) = 0 .AND. helpcnt > 0
         @ 19,49 say helpcnt picture '99'
         helpcnt = helpcnt - 1
      enddo
      set color to
      restore screen from pickscreen
   endcase
enddo
return

*!*********************************************************************
*!
*!      Procedure: HIDISP
*!
*!      Called by: PICKONE        (procedure in SCROLDBF.PRG)
*!               : PICKIT         (procedure in SCROLDBF.PRG)
*!
*!          Calls: DIS            (procedure in SCROLDBF.PRG)
*!
*!*********************************************************************
procedure hidisp
set color to n/w
do dis
set color to
return

*!*********************************************************************
*!
*!      Procedure: DIS
*!
*!      Called by: PICKIT         (procedure in SCROLDBF.PRG)
*!               : HIDISP         (procedure in SCROLDBF.PRG)
*!               : DISPRECS       (procedure in SCROLDBF.PRG)
*!
*!*********************************************************************
procedure dis
@ on_row,first_col say iif(&match_test,&disp_arg,repl('*',boxsize))
return

*!*********************************************************************
*!
*!      Procedure: DISPRECS
*!
*!      Called by: PICKONE        (procedure in SCROLDBF.PRG)
*!               : PICKIT         (procedure in SCROLDBF.PRG)
*!
*!          Calls: DIS            (procedure in SCROLDBF.PRG)
*!
*!*********************************************************************
procedure disprecs
on_row = boxtop
set color to
@ boxtop,first_col clear to boxbot, first_col + boxsize - 1
do while .not. eof() .and. .not. on_row = boxbot + 1
   do dis
   skip
   on_row = on_row + 1
enddo
on_row = on_row - 1
skip -1
return

*!*********************************************************************
*!
*!      Procedure: PSB_ERR
*!
*!      Called by: PICKONE        (procedure in SCROLDBF.PRG)
*!
*!*********************************************************************
procedure psb_err
parameters error_msg, bad_var

set color to *n/w
@ 9,0 clear to 14,79
@ 10, 40 - (len(error_msg)+1)/2 say error_msg

set color to +w/n
@ 12, 31  say 'Value passed was:'
@ 14,0 say bad_var

suspend
restore screen from pop_screen
return
*: EOF: SCROLDBF.PRG
