*----------------------------------------------------------------------------
*
*   Program Name: MEMNONAS.PRG      Copyright: EDON Corporation                                         
*   Date Created: 02/25/91           Language: Clipper S'87                                             
*   Time Created: 17:39:02             Author: Ed Phillips                               
*    Description: Get NONASCII character function for Memscrn.prg
*----------------------------------------------------------------------------

FUNCTION NonASCII
   PARAMETERS mrow, mcol
   PRIVATE oldscrn, oldcolor, ret_val, key, r, c

   ret_val = ''
   oldscrn = Savescreen(1,0,24,79)
   oldcolor = Setcolor(c_mag)

   r = mrow
   c = mcol

   DO Nona_scrn
   @ mrow, mcol SAY ''

   DO WHILE .T.
      memrow = Row()
      memcol = Col()

      key = Inkey(0)

      IF key != esc
         IF key = enter
            cur_char = Savescreen(r,c,r,c)
            ret_val = Chr(Bin2w(cur_char))
            @ savrow,savcol SAY ''
            changed = .t.
            EXIT
         ELSEIF key < 32
            DO CtrlKey
         ELSEIF key >= 271
            DO AltKey
         ENDIF
      ELSE
         EXIT
      ENDIF                                      && IF key != esc
   ENDDO                                         && DO WHILE .T.
   Setcolor(oldcolor)
   Restscreen(1,0,24,79,oldscrn)
RETURN (ret_val)


PROCEDURE Nona_scrn
   Setcolor(c_field)
   Scroll(02,04,20,75,0)
   
   @ 02,04 SAY "Ŀ"
   @ 03,04 SAY "     Position with Cursor keys, <Enter> to Select, <Esc> to cancel    "
   @ 04,04 SAY "Ĵ"
   @ 05,04 SAY "                                                                      "
   @ 06,04 SAY "                                                     "
   @ 07,04 SAY "                                                                      "
   @ 08,04 SAY "                                                     "
   @ 09,04 SAY "                                                                      "
   @ 10,04 SAY "                                                             "
   @ 11,04 SAY "                                                                      "
   @ 12,04 SAY "                                                          "
   @ 13,04 SAY "                                                                      "
   @ 14,04 SAY "                                                      "
   @ 15,04 SAY "                                                                      "
    @ 16,04 SAY "                                                     "
   @ 17,04 SAY "                                                                      "
   @ 18,04 SAY "                                 "+Chr(26)+"               "
   @ 19,04 SAY "                                                                      "
   @ 20,04 SAY ""
RETURN
* EOF: Memnonas            
