*----------------------------------------------------------------------------
*
*   Program Name: MEMMOVE.PRG       Copyright: EDON Corporation                                         
*   Date Created: 02/23/91           Language: Clipper S'87                                             
*   Time Created: 10:06:59             Author: Ed Phillips                               
*    Description: Move Block function for Memscrn.prg
*----------------------------------------------------------------------------

PROCEDURE MoveBlock
   PRIVATE r, c, key, wcolor, winbuff, top, left, bottom, right, corner
   PRIVATE width, height, scrnbuff, wbuff

   scrnbuff = Savescreen(1,0,24,79)
   r = Row()
   c = Col()
   wcolor = Setcolor(c_statln1)

   oldshow = showgm
   IF ! oldshow
      showgm = .t.
      RestGets()
      RestMenu()
   ENDIF

*   @ 0,0 SAY 'MOVE Pending...'
   Setcolor(wcolor)
   corner = Savescreen(r,c,r,c)
   @ r,c SAY ''
   top = r
   left = c
   Gotoxy(r,c)

   BEGIN SEQUENCE
      DO WHILE .T.
         StatLine('MOVE Pending...')
         key = Inkey(0)
         IF key < 32
            IF key = 27                             && escape
               Restscreen(1,0,24,79,scrnbuff)
               @ top,left SAY ''
               BREAK
            ENDIF

            DO CtrlKey
         ELSEIF key >= 271
            DO AltKey
         ELSE
            IF Chr(key) $ 'Mm'

               bottom = Row()
               right = Col()

*               wcolor = Setcolor(c_statln1)
*               @ 0,0 SAY 'MOVE BLOCK...'
*               Setcolor(wcolor)

               @ bottom,right SAY ''
               Restscreen(top,left,top,left,corner)
               DO SwapChk
         
               winbuff = Savescreen(top,left,bottom,right)  && save block
               Scroll(top,left,bottom,right,0)   && clear block
               wbuff = Savescreen(1,0,24,79)     && save screen, less block
               Restscreen(top,left,bottom,right,winbuff)  && restore block
               r = top
               c = left
               width = right - left
               height = bottom - top
               @ r,c SAY ''
               DO WHILE .T.
                  StatLine('MOVE BLOCK...')
                  key = Inkey(0)

                  IF key < 32
                     IF key = 27
                        changed = .t.
                        EXIT
                     ENDIF                             && IF key = 27
                     DO CtrlKey
                  ELSEIF key >= 271
                     DO AltKey
                  ENDIF

                  Restscreen(1,0,24,79,wbuff)               && restore screen
                  Restscreen(r,c,r+height,c+width,winbuff)  && restore block
               ENDDO

               MoveGets()
               MoveMenu()
               EXIT
            ENDIF                                   && IF Chr(key) $ 'Mm'
         ENDIF                                      && IF key < 32
      ENDDO                                         && DO WHILE .T.
   END

   IF oldshow != showgm
      showgm = oldshow
      RestGets()
      RestMenu()
   ENDIF

RETURN

*----------------------------
*         Author: Ed Phillips
*   Date Created: 12/10/91
*----------------------------
FUNCTION MoveGets
   *------------
   * Update Gets
   *------------
   count = Chrcount(gchar,winbuff)
   IF count > 0
      SELECT ScrnGets
      SET ORDER TO 2
      dy = r - top
      dx = c - left
      width = width + 1
      FOR i = 1 TO count
         offset = Atnext(gchar,winbuff,i)
         wid2 = 2 * width
         x_row = (r + Int( offset / wid2 )) + dy*(-1)
         x_col = (c + Int( (offset % wid2) / 2 )) + dx*(-1)

         SEEK Scr_file->Scrn_name+Str(x_row,2)+Str(x_col,2)
         IF Found()
            REPL G_row WITH G_row + dy, G_col WITH G_col + dx
         ELSE
            Sayerr('Get not found')
            EXIT
         ENDIF                                      && IF Found()
      NEXT                                          && FOR i = 1 TO count
      SET ORDER TO 1
      SELECT Scr_file
   ENDIF                                            && IF count > 0

RETURN(.T.)

*----------------------------
*         Author: Ed Phillips
*   Date Created: 12/10/91
*----------------------------
FUNCTION MoveMenu
   *------------------
   * Update Menu Picks
   *------------------
   count = Chrcount(mchar,winbuff)
   IF count > 0
      SELECT ScrnMenu

      dy = r - top
      dx = c - left
      width = width + 1
      FOR i = 1 TO count
         offset = Atnext(mchar,winbuff,i)
         wid2 = 2 * width
         x_row = (r + Int( offset / wid2 )) + dy*(-1)
         x_col = (c + Int( (offset % wid2) / 2 )) + dx*(-1)

         SEEK Scr_file->Scrn_name+Str(x_row,2)+Str(x_col,2)
         IF Found()
            REPL M_row WITH M_row + dy, M_col WITH M_col + dx
         ELSE
            Sayerr('Menu Pick not found')
            EXIT
         ENDIF                                      && IF Found()
      NEXT                                          && FOR i = 1 TO count

      SELECT Scr_file
   ENDIF                                            && IF count > 0
RETURN(.T.)
* MEMMOVE.PRG

