* Program Name: blist.prg 
* Author: Ed Phillips 
* Copyright (c) 1990 by EDON Corporation 
*-----------------------------------------------------------------------------
* Created: 2/24/1990 at 9:54
* main = 
* Called From:
* --- Data Base Files ---   ----- Index Files -----   ----- Other Files ---- 
*
*
*
*.............................................................................
* Revision: 1.0 Last Revised: 2/24/1990 at 9:54
* Description: Routine to build and pick from a list.
*.............................................................................
*---------------------------- ALL RIGHTS RESERVED ----------------------------

*** Syntax: DO Blist WITH switch


PARA switch


*---------------------------
*   declare local variables
*---------------------------
PRIV oldcolor, listname, selection, trow, brow, lc, rc, getname, temp
PRIV menuwidth, tvar, mtitle, save_scr, hlpmsg
selection = 0
oldcolor = Setcolor(c_norm)

*-----------------------------------------------------------------------
*   determine which list to display by looking at the variable in memvar
*   then construct needed macro variables to get list selection with
*   achoice()
*-----------------------------------------------------------------------
DO CASE
   CASE switch == "DBFPRNT" .OR. switch == 'DBF_ADD'
      listname = "fi"                         && caller defines listname array
      getname = "finame"                      && caller defines getname
      mtitle = " Data Dictionary File List "
   OTHERWISE
      RETURN
ENDCASE

*-----------------------------------------------------------------------
*   build selection list window parameters and center title
*-----------------------------------------------------------------------
menuwidth = Len(&listname[1])                              && len of 1st array element
IF Len(mtitle) > menuwidth
   menuwidth = Len(mtitle)
ELSE                  && pad title for centering
   tlen = (menuwidth-Len(mtitle))/2
   mtitle = Space(tlen)+Trim(mtitle)+Space(tlen)
   IF Len(mtitle) != (Int(Len(mtitle)/2)*2)
      mtitle = mtitle+' '
   ENDIF
ENDIF
lc = 2                                                     && left col of window
rc = 2+menuwidth+2                                         && right col of window
trow = 2                                                   && top row of window

brow = trow + 4 + Len(&listname)                           && bottom row of window
IF brow > 22
   brow = 22
ENDIF

*-------------------------------------------------
*   save screen & build the window box, with title
*-------------------------------------------------
save screen to save_scr
Setcolor(c_mbord)
Scroll(trow,lc,brow,rc,0)

@ trow,lc TO brow,rc DOUBLE
Setcolor(c_mtitl) 
@ trow+1, lc + 2 say mtitle
Setcolor(c_mbord)
@ trow+2, lc say ''
FOR i = lc+1 TO menuwidth+3
   @ trow+2, i say ''
NEXT
@ trow+2, rc say ''
Setcolor(c_help)
hlpmsg = "Highlight Selection and Press <Enter> to Select, or Press <Esc> to Quit"
@ 23,Centr(hlpmsg,0) SAY hlpmsg

*---------------------------------------
*   pop-up selection menu and get choice
*---------------------------------------

   Setcolor(c_mtext)

   selection = Achoice(trow+4,lc+2,brow-1,rc-2,&listname)
   Setcolor(c_norm)
   IF selection > 0

      *----------------------------------------
      * Put selected value into return variable
      *----------------------------------------
      &getname = &listname[selection]
   ENDIF
   restore screen from save_scr
Setcolor(oldcolor)
RELE ALL
RETURN
* EOF: Blist.prg
