*.............................................................................
*
*   Program Name: MEMCTRL.PRG       Copyright: EDON Corporation
*   Date Created: 02/22/91           Language: Clipper S'87
*   Time Created: 13:07:57             Author: Ed Phillips
*           Desc: Control Key Handler for Memscrn.prg
*.............................................................................

PROCEDURE CtrlKey
   PRIVATE oldcolor, char, tchar, scrnbuff, width, height

   DO CASE
      CASE key = -15                             && Shift-F6
         DO CenterText

      CASE key = -17                             && Shift-F8 paste scrap
         IF (scr - scl + 1) * (scb - sct + 1) * 2 = Len(scrap)
            scrnbuff = Savescreen(1,0,24,79)
            r = sct
            c = scl
            width = scr - scl
            height = scb - sct

            wcolor = Setcolor(c_statln1)
            @ 0,0 SAY 'Position Block, <Esc> when done...'
            Setcolor(wcolor)

            @ r,c SAY ''
            Restscreen(r,c,r+height,c+width,scrap)
            DO WHILE .T.
               key = Inkey(0)
               IF key = 27
                  changed = .t.
                  EXIT
               ENDIF                             && IF key = 27
               IF key != -17
                  DO CtrlKey
               ENDIF                          && IF key != -17

               Restscreen(1,0,24,79,scrnbuff)
               Restscreen(r,c,r+height,c+width,scrap)
            ENDDO
         ENDIF

      CASE key = -9                              && <F10> display gets/menu
         showgm = If( showgm, .f., .t.)
         Restscreen(St,Sl,Sb,Sr,Screen)
         RestGets()
         RestMenu()

      CASE key = -8                              && <F9> box style
         single = If( single, .f., .t.)

      CASE key = -7                              && <F8> copy block to buffer
         IF is_scrap .AND. Type('winbuff') != 'U'
            scrap = winbuff
            sct = top
            scl = left
            scb = bottom
            scr = right
            BREAK
         ENDIF                                   && IF is_scrap
         is_scrap = .f.

      CASE key = 1                               && home
         r = 1
         c = 0
         @ r,c SAY ''

      CASE key = 2                               && Ctrl-rtarrow
         @ Row(),79 SAY ''
         c = 79

      CASE key = 3                               && page down
         r = 24
         c = 79
         @ r,c SAY ''

      CASE key = 4                               && rtarrow
         IF Col() < 79
            @ Row(),Col()+1 SAY ''
            r = Row()
            c = Col()
         ENDIF

      CASE key = 5                               && uparrow
         IF Row() > 1
            @ Row()-1,Col() SAY ''
            r = Row()
            c = Col()
         ENDIF

      CASE key = 6                               && end
         r = 24
         c = 0
         @ r,c SAY ''

      CASE key = 7                               && del GET

         oldshow = showgm
         IF ! oldshow
            showgm = .t.
            RestGets()
            RestMenu()
         ENDIF

         char = Savescreen(r,c,r,c)
         tchar = Chr(Bin2w(Subs(char,1,1)))

         IF tchar = gchar

            *-----------
            * Delete GET
            *-----------
            SELECT ScrnGets
            SET ORDER TO 2
            SEEK Scr_file->Scrn_name+Str(r,2)+Str(c,2)
            IF Found()
               oldcolor = Setcolor()
               DELETE
               DO ScrnAttrib
               @ r,c SAY ' '
               Alert()
               Setcolor(oldcolor)
            ENDIF                                && IF Found()
            SET ORDER TO 1
            SELECT Scr_file

         ELSEIF tchar = mchar

            *-----------------
            * Delete Menu Pick
            *-----------------
            SELECT ScrnMenu

            SEEK Scr_file->Scrn_name+Str(r,2)+Str(c,2)
            IF Found()
               oldcolor = Setcolor()
               DELETE
               DO ScrnAttrib
               @ r,c SAY ' '
               Alert()
               Setcolor(oldcolor)
            ENDIF                                && IF Found()

            SELECT Scr_file
         ENDIF                                   && IF tchar = gchar

         IF oldshow != showgm
            showgm = oldshow
            RestGets()
            RestMenu()
         ENDIF

      CASE key = 8                               && backspace
         IF c > 0
            c = c - 1
            @ r,c SAY Space(1)
            Gotoxy(r,c)
         ENDIF                                   && IF c > 0

      CASE key = 9                               && tab
         c = If(c+5 > 79, 79, c+5)
         @ r,c SAY ''

      CASE key = 18                              && page up
         r = 1
         c = 79
         @ r,c SAY ''

      CASE key = 19                              && ltarrow
         IF Col() > 0
            @ Row(),Col()-1 SAY ''
            r = Row()
            c = Col()
         ENDIF

      CASE key = 23                              && Ctrl-end
         @ 24,Col() SAY ''
         r = 24

      CASE key = 24                              && down arrow
         IF Row() < 24
            @ Row()+1,Col() SAY ''
            r = Row()
            c = Col()
         ENDIF
      CASE key = 26                              && Ctrl-ltarrow
         @ Row(),0 SAY ''
         c = 0

      CASE key = 29                              && Ctrl-home
         @ 1,Col() SAY ''
         r = 1

   ENDCASE
RETURN
* EOF: MEMCTRL.PRG
