*----------------------------------------------------------------------------
*
*   Program Name: MEMATTRI.PRG      Copyright: EDON Corporation                                         
*   Date Created: 02/24/91           Language: Clipper S'87                                             
*   Time Created: 08:39:13             Author: Ed Phillips                               
*    Description: Alt-A (Current Attribute) function for memscrn.prg
*----------------------------------------------------------------------------

PROCEDURE ScrnAttrib
   PRIVATE cur_char, colorstrng

   colorstrng = 'N  B  G  BG R  BR GR W  N+ B+ G+ BG+R+ BR+GR+W+ '

   cur_char = Savescreen(r,c,r,c)
   Setcolor(Color_n2s(Bin2w(Subs(cur_char,2,1)+Chr(0))))
RETURN



*----------------------------
*         Author: Ed Phillips
*   Date Created: 02/24/91
*   convert color number (0-127) to color string
*----------------------------
FUNCTION Color_n2s
   PARAM colorno
RETURN (Trim(Subs(colorstrng, (colorno % 16) * 3 + 1, 3)) + '/' + ;
        Trim(Subs(colorstrng, Int(colorno / 16) * 3 + 1, 3)))
* EOF: Memattri.prg
