*.............................................................................
*
*   Program Name: MEMALT.PRG        Copyright: EDON Corporation
*   Date Created: 02/24/91           Language: Clipper S'87
*   Time Created: 13:10:11             Author: Ed Phillips
*           Desc: ALT key handler for Memscrn.prg
*.............................................................................

PROCEDURE AltKey
   DO CASE
      CASE key = 271                             && Shift-TAB
         c = If(c-5 < 0, 0, c-5)
         @ r,c SAY ''

      CASE key = 273                             && Alt-W
         DO MakScrnCode                          && memsproc.prg

      CASE key = 274                             && Alt-E
         DO Memsedit

      CASE key = 275                             && Alt-R
         MemRpts()

      CASE key = 276                             && Alt-T
         DO Memtextw

      CASE key = 281                             && Alt-P
         DO PrintScreen

      CASE key = 286                             && Alt-A
         DO ScrnAttrib

      CASE key = 287                             && Alt-S
         DO SubScrn

      CASE key = 290                             && Alt-G, reorder gets
         DO Memgord

      CASE key = 294                             && Alt-L, list dbf structure
         DO Memstru

      CASE key = 304                             && Alt<B>, reorder menu
         MemMord()

      CASE key = 305                             && Alt-N, next record
         IF changed
            DO AskToSave
         ENDIF                                   && IF changed

         SKIP
         IF Eof()
            SKIP -1
            Sayerr('End of File')
         ENDIF

         oldcolor = Setcolor(c_default)
         Scroll(1,0,24,79,0)
         Setcolor(oldcolor)

         memscrn = Screen
         st = St
         sl = Sl
         sb = Sb
         sr = Sr
         Restscreen(M->st,M->sl,M->sb,M->sr,memscrn)
         RestGets()
         RestMenu()
*         KEYBOARD Chr(1)

      CASE key = 306                             && Alt<M>
         MeMenu()

      CASE key = 386                             && Alt<->, previous record
         IF changed
            DO AskToSave
         ENDIF                                   && IF changed

         SKIP -1
         IF Bof()
            Sayerr('Beginning of File')
            GO TOP
         ENDIF                                   && IF Bof()

         oldcolor = Setcolor(c_default)
         Scroll(1,0,24,79,0)
         Setcolor(oldcolor)

         memscrn = Screen
         st = St
         sl = Sl
         sb = Sb
         sr = Sr
         Restscreen(M->st,M->sl,M->sb,M->sr,memscrn)
         RestGets()
         RestMenu()
*         KEYBOARD Chr(1)

   ENDCASE                                       && DO CASE
RETURN
* EOF: MEMALT.PRG
