* Program Name: browze.prg 
* Author: Ed Phillips 
* Copyright (c) 1990 by EDON Corporation 
*-----------------------------------------------------------------------------
* Created: 4/10/1990 at 15:07
* main = 
* Called From:
* --- Data Base Files ---   ----- Index Files -----   ----- Other Files ---- 
*
*
*
*.............................................................................
* Revision: 1.0 Last Revised: 4/10/1990 at 15:07
* Description: Browse of a database which may be indexed, filtered, or have
*              set deleted on.
* Description: Original Creation.
*.............................................................................
*---------------------------- ALL RIGHTS RESERVED ----------------------------

FUNCTION Browze_dbf
   PARAMETERS expr, t, l, b, r, mode, bzbox

   IF Type('bzbox') = 'U'
      bzbox = .t.
   ENDIF                                         && IF Type('bzbox') = 'U'

   IF Type('mode') = 'U'
      mode = 'SEL'
   ENDIF

   PRIVATE num_disp_rows, floor, ceiling, key, highlight, width, up, bz_rec
   PRIVATE prom1, cur_disp_rows, srch, first, last, current, oldcolor, disp_name
*   PRIVATE bhelp_msg

   disp_name = 'BROWZE_DBF'
   oldcolor = Setcolor()
   up = .f.
   current = Recno()
   GO BOTTOM
   last = Recno()

   GO TOP
   first = Recno()
   GO current
   floor = current

   IF Eof()
      GO TOP
      floor = first
   ENDIF

   IF Eof()
      Sayerr('File is Empty')
      RETURN (0)
   ENDIF

   SET CURSOR OFF

   IF bzbox
      @ t, l TO b, r
   ENDIF                                         && IF bzbox

   num_disp_rows = b - t - 1
   width = r - l - 1
   highlight = 1
   cur_disp_rows = Fill_box(expr, t, l, b, r, floor)

   SKIP cur_disp_rows - 1
   ceiling = Recno()
   SKIP -(cur_disp_rows - 1)

   IF floor != first
      Setcolor(c_error)
      @ t, l SAY Chr(24)
      Setcolor(oldcolor)
   ENDIF

   IF ceiling != last
      Setcolor(c_error)
      @ b, l SAY Chr(25)
      Setcolor(oldcolor)
   ENDIF

   Bhlight()                                     && highlight active element

   IF Type('bhelp_msg') = 'U'
      IF Type('bz_find') != 'U'
         bhelp_msg = Chr(24)+Chr(25)+'<PgUp><PgDn>, <Enter> to select, <F2> to jump, <Esc> when done'
      ELSE
         bhelp_msg = Chr(24)+Chr(25)+'<PgUp><PgDn>, <Enter> to select, <Esc> when done'
      ENDIF                                         && IF Type('bz_find') != 'U'
   ENDIF                                         && IF Type('bhelp_msg') = 'U'

   Sayhelp(bhelp_msg)
   key = Inkey(0)
   DO WHILE key != esc

      *-------------------------------------
      * Remove highlight from active element
      *-------------------------------------
      SKIP highlight - 1
      @ t + highlight, l + 1 SAY Gaspad(&expr, width)
      SKIP -(highlight - 1)
      
      DO CASE
         CASE key = enter

            IF mode = 'SEL'
               SKIP highlight - 1
               recno = Recno()
               SKIP -(highlight - 1)
               GO recno
               EXIT
            ELSEIF mode = 'MARK'
               SKIP highlight - 1
               IF Rec_lock(5)
                  IF ! Empty(Marked)
                     REPL Marked WITH ' '
                  ELSE
                     REPL Marked WITH Chr(251)
                  ENDIF
                  UNLOCK
               ELSE
                  Alert()
               ENDIF                             && IF Rec_lock(5)
               SKIP -(highlight - 1)
               IF up
                  KEYBOARD Chr(uparrow)
               ELSE
                  KEYBOARD Chr(dnarrow)
               ENDIF

            ELSE
               SKIP highlight - 1
               DO &gen_get
               SKIP -(highlight - 1)
               IF up
                  KEYBOARD Chr(uparrow)
               ELSE
                  KEYBOARD Chr(dnarrow)
               ENDIF

            ENDIF
         CASE key = f2
            IF Type('bz_find') != 'U'
               SET CURSOR ON
               oldcolor = Setcolor(c_field)
               @ 24,0 CLEAR
               bz_rec = Recno()
               DO &bz_find
               Setcolor(oldcolor)
               IF bz_rec != Recno()
                  IF Eof()
                     GO BOTTOM
                  ENDIF                          && IF Eof()

                  highlight = 1
                  floor = Recno()
                  cur_disp_rows = fill_box(expr, t, l, b, r, floor)

                  SKIP cur_disp_rows - 1
                  ceiling = Recno()
                  SKIP -(cur_disp_rows - 1)
               ENDIF                             && IF bz_rec != Recno()

               SET CURSOR OFF
               Sayhelp(bhelp_msg)
            ENDIF
         CASE key = uparrow
            up = .t.
            IF highlight > 1
               highlight = highlight - 1
            ELSE
               IF floor != first
                  SKIP -1
                  floor = Recno()

                  Scroll(t + 1, l + 1, b - 1, r - 1, -1)

                  IF cur_disp_rows < num_disp_rows
                     cur_disp_rows = cur_disp_rows + 1
                  ENDIF

                  SKIP cur_disp_rows - 1
                  ceiling = Recno()
                  SKIP -(cur_disp_rows - 1)
               ENDIF
            ENDIF

         CASE key = dnarrow
            Bdnarrow()
         CASE key = pgup
            IF floor <> first
*            IF floor > first
               SKIP -num_disp_rows
               floor = Recno()

               cur_disp_rows = fill_box(expr, t, l, b, r, floor)

               SKIP cur_disp_rows - 1
               ceiling = Recno()
               SKIP -(cur_disp_rows - 1)
            ENDIF

         CASE key = pgdn
            IF ceiling != last
               SKIP num_disp_rows
               floor = Recno()

               cur_disp_rows = fill_box(expr, t, l, b, r, floor)

               SKIP cur_disp_rows - 1
               ceiling = Recno()
               SKIP -(cur_disp_rows - 1)
            ENDIF

         CASE key = home
            highlight = 1

         CASE key = end_key
            highlight = cur_disp_rows

         CASE key = ctrl_home
            highlight = 1
            GO TOP
            floor = Recno()

            cur_disp_rows = fill_box(expr, t, l, b, r, floor)

            SKIP cur_disp_rows - 1
            ceiling = Recno()
            SKIP -(cur_disp_rows - 1)

         CASE key = ctrl_end
            IF ceiling = last
               highlight = cur_disp_rows
            ELSE
               GO BOTTOM
               SKIP -(num_disp_rows - 1)
               floor = Recno()

               cur_disp_rows = fill_box(expr, t, l, b, r, floor)

               ceiling = last
               highlight = cur_disp_rows
            ENDIF
         CASE Isalpha(Chr(key)) .OR. Isdigit(Chr(key))
            IF Type('bz_1key') = 'L' .AND. Type('ikey') != 'U' .AND. Type('bz_seek') != 'U'
               btemp = Indexkey(ikey)

               highlight = highlight + 1
               brec = Recno()
               SKIP highlight - 1
               IF Upper(Chr(key)) = Subs(&btemp.,1,1)  && treat like DnArrow
                  highlight = highlight - 1
                  GO brec

                  Bdnarrow()
               ELSE                              && treat like first time in
                  DO &bz_seek
                  current = Recno()
                  floor = current
                  highlight = 1
                  cur_disp_rows = Fill_box(expr, t, l, b, r, floor)

                  SKIP cur_disp_rows - 1
                  ceiling = Recno()
                  SKIP -(cur_disp_rows - 1)

               ENDIF                             && IF btest = Subs(&btemp,1,1)
            ENDIF                                && IF Type('bz_1key') = 'L'
      ENDCASE

      Bhlight()                         && Highlight active element

      IF floor != first
         Setcolor(c_error)
         @ t, l SAY Chr(24)
         Setcolor(oldcolor)
      ELSE
         IF bzbox
            @ t, l SAY Chr(218)
         ELSE
            @ t, l SAY Space(1)
         ENDIF
      ENDIF
      IF ceiling != last
         Setcolor(c_error)
         @ b, l SAY Chr(25)
         Setcolor(oldcolor)
      ELSE
         IF bzbox
            @ b, l SAY Chr(192)
         ELSE
            @ b,l SAY Space(1)
         ENDIF                                   && IF bzbox

      ENDIF

      key = Inkey(0)

   ENDDO

   SET CURSOR ON
RETURN (.T.)


FUNCTION Fill_box
   PARAMETERS expr, t, l, b, r, floor
   
   PRIV num_disp, num_rows, i, width

   num_rows = b - t - 1
   width = r - l - 1

   num_disp = 0
   DO WHILE ! Eof() .AND. num_disp < num_rows
      @ t + num_disp + 1, l + 1 SAY Gaspad(&expr, width)
      SKIP
      num_disp = num_disp + 1
   ENDDO

   FOR i = num_disp + 1 TO num_rows
      @ t + i, l + 1 SAY Space(width)
   NEXT

   GO floor
RETURN (num_disp)


FUNCTION Gaspad
   PARAMETERS str, width

   IF Len(str) > width
      str = Subs(str, 1, width)
   ELSE
      str = str + Space(width - Len(str))
   ENDIF
RETURN (str + Space(width - Len(str)))

*----------------------------
*         Author: Ed Phillips
*   Date Created: 10/06/90
*----------------------------
PROCEDURE Bdnarrow
   up = .f.
   IF highlight < cur_disp_rows
      highlight = highlight + 1
   ELSE
      IF ceiling != last   && floor != first
         SKIP
         floor = Recno()

         Scroll(t + 1, l + 1, b - 1, r - 1, 1)

         SKIP cur_disp_rows - 1
         ceiling = Recno()
         SKIP -(cur_disp_rows - 1)
      ENDIF
   ENDIF
RETURN

*----------------------------
*         Author: Ed Phillips
*   Date Created: 10/06/90
*    Highlight active element
*----------------------------
PROCEDURE Bhlight
   Setcolor(c_help)
   SKIP highlight - 1
   @ t + highlight, l + 1 SAY Gaspad(&expr, width)
   SKIP -(highlight - 1)
   Setcolor(oldcolor)
RETURN


*         Author: Ed Phillips
*   Date Created: 10/11/90
*   Time Created: 09:27:39
*
FUNCTION Isdigit
   PARAMETERS dummy
RETURN(dummy $ '0123456789')
* EOF: Browze.prg
