*.............................................................................
*
*   Program Name: ALIST.PRG         Copyright: EDON Corporation                                        
*   Date Created: 10/03/90           Language: Clipper S'87                                             
*   Time Created: 07:07:44             Author: Ed Phillips                               
*
*.............................................................................

*** Syntax: Alist(listname, mtitle, menuwidth, top_row, left_corner)

PARA listname, mtitle, menuwidth, trow, lc

*---------------------------
*   declare local variables
*---------------------------
PRIV oldcolor, brow, rc, j
PRIV save_scr
selection = 0
oldcolor = Setcolor(c_norm)

*-----------------------------------------------------------------------
*   build selection list window parameters and center title
*-----------------------------------------------------------------------
tlen = (menuwidth-Len(mtitle))/2
mtitle = Space(tlen)+mtitle+Space(tlen)
IF Len(mtitle) % 2 != 0
   mtitle = mtitle+' '
ENDIF

rc = 2+menuwidth+2+lc
brow = trow + 4 + Len(&listname.)

IF brow > 22
   brow = 22
ENDIF

*-----------------------------------------------------------------------
*   save screen & build the window box, with title
*-----------------------------------------------------------------------

SAVE SCREEN TO save_scr
Setcolor(c_fielda) 
Scroll(trow,lc,brow,rc,0)
@ trow,lc TO brow,rc DOUBLE
Setcolor(c_list)
@ trow+1, lc + 2 say mtitle
Setcolor(c_fielda) 
@ trow+2, lc say ''

@ trow+2, lc+1 say Drawline(rc-lc)
@ trow+2, rc say ''

*-----------------------------------------------------------------------
*   pop-up selection menu and get choice
*-----------------------------------------------------------------------

Sayhelp('<F9> = Mark/Unmark All, <Enter> = Mark/Unmark Selection, <ESC> = done.')

STORE 1 TO oel, ore
selection = 0
num_mark = 0
DO WHILE .t.
   Setcolor(c_fielda)
   selection = Achoice(trow+4,lc+2,brow-1,rc-2,&listname,.t.,"getofield",oel,ore)
   DO CASE

      CASE Lastkey() = enter   && <enter>
         IF Chr(251) $ &listname[selection]      && toggle mark off
            &listname[selection] = ' '+Subs(&listname[selection],2)
            num_mark = num_mark-1
         ELSE                                    && toggle mark on
            &listname[selection] = Chr(251) + Subs(&listname[selection],2)
            num_mark = num_mark+1
         ENDIF   && chr 251, check mark

      CASE Lastkey() = f9
         IF Chr(251) $ &listname[selection]      && toggle mark off
            num_mark = 0
            FOR j = 1 TO Len(&listname.)
               &listname[j] = ' '+Subs(&listname[j],2)
            NEXT                                 && FOR j = 1 TO Len(&listname.)
         ELSE
            num_mark = Len(&listname.)
            FOR j = 1 TO num_mark
               &listname[j] = Chr(251) + Subs(&listname[j],2)
            NEXT                                    && FOR j = 1 TO num_mark
         ENDIF                                   && IF Chr(251) $ &listname[selection]      && toggle mark off

      CASE Lastkey() = esc   && <esc>
         EXIT
   ENDCASE
ENDDO
Setcolor(oldcolor)
RETURN

*         Author: Ed Phillips
*   Date Created: 10/03/90
*   Time Created: 07:23:48
*
FUNCTION Getofield
PARA mode,element,relative
   oel = element
   ore = relative
RETU (1)


FUNC PickList
   *** Syntax: PickList(listname, mtitle, menuwidth, top_row, left_corner)

   PARA listname, mtitle, menuwidth, trow, lc

   *---------------------------
   *   declare local variables
   *---------------------------
   PRIV brow, rc, j
   PRIV save_scr
   selection = 0

   *-----------------------------------------------------------------------
   *   build selection list window parameters and center title
   *-----------------------------------------------------------------------
   tlen = (menuwidth-Len(mtitle))/2
   mtitle = Space(tlen)+mtitle+Space(tlen)
   IF Len(mtitle) % 2 != 0
      mtitle = mtitle+' '
   ENDIF

   rc = 2+menuwidth+2+lc
   brow = trow + 4 + Len(&listname.)

   IF brow > 22
      brow = 22
   ENDIF

   *-----------------------------------------------------------------------
   *   save screen & build the window box, with title
   *-----------------------------------------------------------------------

   SAVE SCREEN TO save_scr
   Scroll(trow,lc,brow,rc,0)
   @ trow,lc TO brow,rc DOUBLE
   @ trow+1, lc + 2 say mtitle
   @ trow+2, lc say ''

   @ trow+2, lc+1 say Drawline(rc-lc)
   @ trow+2, rc say ''

   *-----------------------------------------------------------------------
   *   pop-up selection menu and get choice
   *-----------------------------------------------------------------------

   Sayhelp('<Enter> = Select, <ESC> = Cancel')

   selection = 0
   selection = Achoice(trow+4,lc+2,brow-1,rc-2,&listname,.t.)
   RESTORE SCREEN FROM save_scr
RETURN (selection)

* EOF: Alist.prg

