;     SCRLLOCK.ASM
;     Keven Miller    25 Mar 1993   70732,1340
;     For FOXPRO 2.x
;
;     ** FREEWARE **  Use as you see fit
;
;     Get/Set Scrolllock status
;
;     Pass in "t","T" to set scrolllock on, "f","F" to set off
;     or anything else to just get current status.
;     Always returns current status as "T" or "F"
;
;     LOAD scrllock
;     m.stat = "T"
;     CALL scrllock WITH m.stat
;     ? m.stat
;     RELEASE MODULE scrllock
;
;     To create SCRLLOCK.BIN:
;        MASM scrllock,,;
;        LINK scrllock/map;
;        EXE2BIN scrllock scrllock.bin
;
         ORG     0
PROGRAM SEGMENT
         ASSUME  CS:PROGRAM
MYPROC   PROC    FAR
START:
         OR      BX,BX           ; Test for parameter passed
         JZ      EXIT

         PUSH  AX
         PUSH  ES
         MOV   AX,40H
         MOV   ES,AX             ;Set ES to BIOS data area
         MOV   AL,ES:BYTE PTR [17H] ;Get current BIOS keyboard flag
         MOV   AH,'F'            ;Default is OFF/FALSE
         TEST  AL,10H            ;Test SCROLL bit 4
         JZ    SETSTAT
         MOV   AH,'T'            ;It was on!
SETSTAT:
         MOV   AL,BYTE PTR [BX]  ;Get T/F/no set value
         AND   AL,0DFH           ;Convert to uppercase
         CMP   AL,'T'
         JNE   NEXT
         OR    ES:BYTE PTR [17H],10H   ;Turn SCROLL on, bit 4
NEXT:
         CMP   AL,'F'
         JNE   RETURN
         AND   ES:BYTE PTR [17H],0EFH  ;Turn SCROLL off, bit 4
RETURN:
         MOV   BYTE PTR [BX],AH  ;Return original status as T/F
         POP   ES
         POP   AX
EXIT:
         RET
MYPROC   ENDP
PROGRAM  ENDS
         END
