PROCEDURE SCRLBOX

* Positions record pointer in current file area by moving a light-bar to
* one selection in a scrolling window.

* Written by:  Jerry Whittaker
*              6210 Constance Circle N.W.
*              Canton, Ohio 44718
*
*              216-494-8036

*  This procedure requires LITEBAR 4.2 by:  R. Russell Freeland
*                                           Synergy Corporation
*                                           1780 SW 43 Avenue
*                                           Ft. Lauderdale, FL 33317
*
*                                           Compuserve: 76146,371

*  LITEBAR 4.2 is a shareware/feeware product (not public domain) and
*  may be found on may bulletin boards - try it then buy it!

*  As written, this procedure will work with FoxBASE+ (2.0) and
*     dBASE III+ (It's really sloooow in dBASE III+)
*     For FoxBASE+, the internal save screen feature of FoxBASE+
*     is used; for dBASE III+ the save screen of Litebar 4.2 is used
*     For FoxBASE+ the Public memvar "FOX" must have been declared
*     before DOing SCRLBOX.  For dBASE III+, the 'IF FOX' statements
*     may be removed.  If running under FoxBASE+, you do not need
*     PROCEDURE TIMEOUT.

* 'ESCAPE' must be set OFF for SCRLBOX help screens to work properly

PARAMETERS ROW,COL,LINES,ESC,T1,T2,DAT_NAME

* parameter definitions:      ROW - Row number of upper left corner of box
*                                 - max value = 14
*                             COL - Column number of upper left corner of box
*                                 - max value = 54
*                           LINES - number of scrolling data lines in window
*                                 - max = 16
*                                 - min = 3
*                             ESC - logical - can user press escape and
*                                   not select a record?
*                              T1 - Window 1st title line (self centering)
*                                 - max length = 76
*                              T2 - Window 2nd title line (self centering)
*                                 - max length = 76
*                        DAT_NAME - Name of field(s) to be displayed in
*                                   the window - may contain fields from
*                                   related file
*                                 - Maximum combined length = 74


*------------------- initilization of memory variables --------------------

PRIVATE BAR_LINE,BOTT_LINE,BOTT_REC,BOX_WIDTH,CALL_STR,CNTR, ;
        COL,DAT_NAME,DOUBLE,ESC,FIRST_COL,FIRST_REC,FULL_SCR, ;
        KP,LAST_POS,LAST_REC,LINES,LITEBAR,LRC,LRR,MAX_LINES
PRIVATE MID_REC,MID_SW,PB,PT,ROW,SCROLLED,SEEK_STR,T1,T2,TOP_LINE, ;
        TOP_REC,TYPEAHEAD,ULC,ULR,W,X,ZERO

CNTR = 0                           && general purpose counter
TOP_LINE = ROW+4                   && top line where data is written
MAX_LINES = LINES                  && maximum line capicity of window
BAR_LINE  = TOP_LINE               && line of current lite bar in window
FIRST_COL = COL+2                  && left-most data column
BOTT_LINE = TOP_LINE+MAX_LINES-1   && last line where data is written
LAST_POS = MAX_LINES               && line of last data written in window
LAST_REC = 0                       && recno() of last record on screen
                                   && zero if scrolled off screen

SEEK_STR = ""                      && seek string
FIRST_REC = 0                      && recno() of first record on screen
                                   && zero if scrolled off screen
FULL_SCR = .T.                     && Did fillbox (SCRLBOX1) fill screen

TOP_REC = 0                        && first recno() in .DBF
BOTT_REC = 0                       && last recno() in .DBF

                 *--- binary search variables ----*

MID_REC = 0                        && middle record number
MID_SW = .T.                       && middle record switch (go to mid rec)
PT = 0                             && Previous TOP_REC
PB = 0                             && Previous BOTT_REC

*------------------- end of memvar initialization -------------------------

* minimum internal box width (inside the border is 24 - dynamically
*  established box width is len(&dat_name)+ 4 or length of T1+2 or T2+2
*  (whichever is greater)

BOX_WIDTH = 24
IF (LEN(&DAT_NAME)+4) > BOX_WIDTH
   BOX_WIDTH = LEN(&DAT_NAME)+4
ENDIF

IF LEN(T1) > BOX_WIDTH
   BOX_WIDTH = LEN(T1)+2
ENDIF

IF LEN(T2) > BOX_WIDTH
   BOX_WIDTH = LEN(T2)+2
ENDIF

              *------ set corners of scroll window -------

ULR = ROW + 4                      && upper left row of inside of box
ULC = COL + 1                      && upper left column of inside of box
LRR = ROW + MAX_LINES              && lower right row of inside of box
LRC = COL + BOX_WIDTH              && lower right columm of inside of box

* string used to call scroll routine - scroll 1 line at a time
CALL_STR = LTRIM(STR(ULR))+","+LTRIM(STR(ULC))+","+LTRIM(STR(LRR+3))+","+ ;
           LTRIM(STR(LRC))+",0"

* -------------------------- and now the clockworks -----------------------

IF FOX
   SAVE SCREEN TO SCR1
ELSE
   CALL LITEBAR WITH "S0"
ENDIF

CALL LITEBAR WITH "0"                        && turn cursor off
SET COLOR TO

* Build the box
@ ROW,ULC-1 CLEAR TO LRR+8,LRC+1             && clear box area
@ ROW,ULC-1 TO LRR+8,LRC+1 DOUBLE            && Full box outline
@ ROW+3,ULC TO ROW+3,LRC                     && Title divider
@ ROW+3,ULC-1 SAY CHR(199)
@ ROW+3,LRC+1 SAY CHR(182)
@ LRR+4,ULC TO LRR+4,LRC                     && Operation key divider
@ LRR+4,ULC-1 SAY CHR(199)
@ LRR+4,LRC+1 SAY CHR(182)
@ ROW+1,ULC+((BOX_WIDTH-LEN(T1))/2) SAY T1    && title line 1
@ ROW+2,ULC+((BOX_WIDTH-LEN(T2))/2) SAY T2    && title line 2


DO SCRLBOX2                            && Put directions in lower box

* fill the box with the data and set the bar to the first line

GO TOP
TOP_REC = RECNO()
DO SCRLBOX1

* if fewer records in file than a box full, disable certain functions
IF CNTR < MAX_LINES .OR. EOF()
   FULL_SCR=.F.
ENDIF

GO BOTTOM
BOTT_REC = RECNO()
DO SCRLBOX4 WITH TOP_REC,BOTT_REC    && Reset middle record to middle of file
GO TOP
BAR_LINE = TOP_LINE

DO WHILE .T.
   SET COLOR TO N/W
   * write the lite-bar selection in inverse with width to fill box
   @ BAR_LINE,FIRST_COL SAY LEFT(" "+&DAT_NAME+SPACE(BOX_WIDTH),BOX_WIDTH-2)
   SET COLOR TO

   * get a keypress from the user
   CLEAR TYPEAHEAD
   KP = 0
   DO WHILE KP = 0
      KP = INKEY()
   ENDDO

   DO CASE
      CASE KP = 13  && Return key pressed - record selected
           EXIT
      CASE KP = 24  && Down Arrow key pressed - move to down record
           * un-high-light the current selection
           @ BAR_LINE,FIRST_COL SAY LEFT(" "+&DAT_NAME+SPACE(BOX_WIDTH), ;
               BOX_WIDTH-2)
           * move file pointer to next record
           SKIP
           IF EOF()
              SKIP -1
           ELSE
              BAR_LINE = BAR_LINE + 1
              * check to see if at position of last record on screen
              IF BAR_LINE > BOTT_LINE
                 BAR_LINE  = BOTT_LINE
                 CALL LITEBAR WITH "U1,"+CALL_STR
                 LAST_REC = RECNO()
                 FIRST_REC = 0
              ENDIF
           ENDIF
      CASE KP =  5  && Up arrow key pressed - move up one record
           * un-high-light the current selection
           @ BAR_LINE,FIRST_COL SAY LEFT(" "+&DAT_NAME+SPACE(BOX_WIDTH), ;
               BOX_WIDTH-2)
           * move file pointer to next record
           SKIP -1
           IF BOF()
              GO TOP
           ELSE
              BAR_LINE = BAR_LINE - 1
              * check to see of at top line in the box
              IF BAR_LINE < TOP_LINE
                 BAR_LINE  = TOP_LINE
                 CALL LITEBAR WITH "D1,"+CALL_STR
                 FIRST_REC = RECNO()
                 LAST_REC = 0
                 IF LAST_POS+1 <= BOTT_LINE
                    LAST_POS = LAST_POS+1
                 ENDIF
              ENDIF
           ENDIF
      CASE KP =  3 .AND. LAST_REC <> BOTT_REC .AND. FULL_SCR
           *  Page down pressed
           * move file down one page
           * go to the last record shown on screen and skip downward
           @ BAR_LINE,FIRST_COL SAY LEFT(" "+&DAT_NAME+SPACE(BOX_WIDTH), ;
               BOX_WIDTH-2)
           IF LAST_REC <> 0
              GO LAST_REC
           ELSE
              GO FIRST_REC
              SKIP MAX_LINES -1
           ENDIF
           CNTR = 0
           DO WHILE .NOT. EOF() .AND. CNTR < MAX_LINES + 1
              IF CNTR = 1
                 FIRST_REC = RECNO()
              ENDIF
              CALL LITEBAR WITH "U1,"+CALL_STR
              @ BOTT_LINE,FIRST_COL SAY " "+&DAT_NAME+" "
              CNTR = CNTR + 1
              SKIP
           ENDDO
           SKIP -1
           LAST_POS = BOTT_LINE
           LAST_REC = RECNO()
           * not enough records to fill screen, fill bott with blanks
           DO WHILE CNTR < MAX_LINES +1
              CALL LITEBAR WITH "U1,"+CALL_STR
              CNTR = CNTR + 1
              LAST_POS = LAST_POS -1
           ENDDO
           BAR_LINE = TOP_LINE
           GO FIRST_REC
      CASE KP = 18 .AND. FULL_SCR  && Page up pressed - move file up one page
           * go to the first record shown on screen and skip upward
           @ BAR_LINE,FIRST_COL SAY LEFT(" "+&DAT_NAME+SPACE(BOX_WIDTH), ;
               BOX_WIDTH-2)
           IF FIRST_REC <> 0  && first rec has not been scrolled off
              GO FIRST_REC
           ELSE
              GO LAST_REC
              SKIP -MAX_LINES+1
           ENDIF
           SKIP -1
           LAST_REC = RECNO()
           CNTR = 0
           DO WHILE .NOT. BOF() .AND. CNTR < MAX_LINES
              FIRST_REC = RECNO()
              CALL LITEBAR WITH "D1,"+CALL_STR
              @ TOP_LINE,FIRST_COL SAY " "+&DAT_NAME+" "
              LAST_POS = LAST_POS +1
              CNTR = CNTR + 1
              SKIP -1
           ENDDO
           IF LAST_POS > BOTT_LINE
              LAST_REC = 0
              LAST_POS = BOTT_LINE
           ENDIF
           BAR_LINE = TOP_LINE
           GO FIRST_REC
      CASE KP =  1
           * Home key pressed - to first record on screen
           @ BAR_LINE,FIRST_COL SAY LEFT(" "+&DAT_NAME+SPACE(BOX_WIDTH), ;
               BOX_WIDTH-2)
           IF FIRST_REC <> 0  && first rec has not been scrolled off
              GO FIRST_REC
              BAR_LINE = TOP_LINE
           ELSE
              GO LAST_REC
              SKIP - MAX_LINES +1
              BAR_LINE = TOP_LINE
           ENDIF
      CASE KP =  6
           * End key pressed - go to last record on screen
           @ BAR_LINE,FIRST_COL SAY LEFT(" "+&DAT_NAME+SPACE(BOX_WIDTH), ;
               BOX_WIDTH-2)
           IF LAST_REC <> 0  && last rec has not been scrolled off
              GO LAST_REC
              BAR_LINE = LAST_POS
           ELSE
              GO FIRST_REC
              SKIP MAX_LINES -1
              IF EOF()
                 GO BOTTOM
              ENDIF
              BAR_LINE = LAST_POS
           ENDIF
      CASE KP = 83 .OR. KP = 115  && upper or lower case "s" - seek
           * is there an index used in the current area?
           IF "" = NDX(1)
              @ LRR+5,ULC CLEAR TO LRR+7,LRC
              SET COLOR TO N/W
              @ LRR+6,ULC+((BOX_WIDTH-22)/2) SAY " Search Not Available "
              SET COLOR TO
              IF FOX
                 X = INKEY(3)
              ELSE
                 DO TIMEOUT WITH 3
              ENDIF
              DO SCRLBOX2
              LOOP
           ENDIF
           * store current record pointer
           CNTR = RECNO()
           * clear the direction box
           @ LRR+5,ULC CLEAR TO LRR+7,LRC
           @ LRR+6,ULC+((BOX_WIDTH-19)/2) SAY "Enter search string"
           SEEK_STR = ""
           DO INKEY WITH LRR+7,ULC+((BOX_WIDTH-(LEN(&DAT_NAME)))/2), ;
                         LEN(&DAT_NAME)
           SEEK_STR = UPPER(SEEK_STR)  && assumes index on upper(&dat_name)
           * contineous seek until string is empty
           DO WHILE .T. .AND. LEN(SEEK_STR) <> 0
              SEEK SEEK_STR
              IF EOF()
                 SEEK_STR = LEFT(SEEK_STR,LEN(SEEK_STR)-1)
              ELSE
                 EXIT
              ENDIF
           ENDDO
           IF EOF()
              * clear the direction box
              @ LRR+5,ULC CLEAR TO LRR+7,LRC
              @ LRR+6,ULC+((BOX_WIDTH-17)/2) SAY "Record not found!"
              @ LRR+7,ULC+((BOX_WIDTH-21)/2) SAY "Press key to continue"
              SET CONSOLE OFF
              WAIT
              SET CONSOLE ON
              DO SCRLBOX2
              GO CNTR  && reset record pointer to previous location
           ELSE
              DO SCRLBOX2
              DO SCRLBOX1
              GO FIRST_REC
           ENDIF
      CASE KP = 4  .AND. FULL_SCR  &&  go to middle of lower half
           IF MID_SW        && if middle has not be selected before
              GO MID_REC
              MID_SW = .F.
           ELSE
              PT = MID_REC
              MID_REC = INT(((PB-PT)/2)+PT)
              GO MID_REC
           ENDIF
           DO WHILE DELETE() .AND. .NOT. EOF()
              SKIP
           ENDDO
           DO SCRLBOX1
           GO FIRST_REC
           BAR_LINE = TOP_LINE
      CASE KP = 19  .AND. FULL_SCR  &&  go to middle of upper half
           IF MID_SW        && if middle has not be selected before
              GO MID_REC
              MID_SW = .F.
           ELSE
              PB = MID_REC
              MID_REC = INT((PB-PT)/2)+PT
              GO MID_REC
           ENDIF
           DO WHILE DELETE() .AND. .NOT. EOF()
              SKIP
           ENDDO
           DO SCRLBOX1
           GO FIRST_REC
           BAR_LINE = TOP_LINE
      CASE KP = 29 .AND. FULL_SCR
           * Ctrl-Home key pressed - to to top of file
           * reset middle record for binary search
           DO SCRLBOX4 WITH TOP_REC,BOTT_REC
           GO TOP
           DO SCRLBOX1
           GO TOP
           BAR_LINE = TOP_LINE
      CASE KP =  23 .AND. FULL_SCR
           * Ctrl-End key pressed - go to bottom of file
           * reset middle record for binary search
           DO SCRLBOX4 WITH TOP_REC,BOTT_REC
           GO BOTTOM
           SKIP -MAX_LINES+1
           DO SCRLBOX1
           GO BOTTOM
           BAR_LINE = LAST_POS
      CASE KP >= 49 .AND. KP <= 57 .AND. FULL_SCR
           * 1 thur 9 (Jump in 10% increments)
           GO (VAL(CHR(KP)) * INT(BOTT_REC/10))
           DO WHILE DELETE() .AND. .NOT. EOF()
              SKIP
           ENDDO
           DO SCRLBOX1
           GO FIRST_REC
           BAR_LINE = TOP_LINE
           * limit binary search range to 10% above and below current record
           IF KP <> 49 .AND. KP <> 57   && not "1" or "9"
              PT = (VAL(CHR(KP-1)) * INT(BOTT_REC/10))
              PB = (VAL(CHR(KP+1)) * INT(BOTT_REC/10))
           ELSE
              IF KP = 49  && "1" key pressed
                 PT = TOP_REC
                 PB = (VAL(CHR(KP+1)) * INT(BOTT_REC/10))
              ELSE  && "9" key pressed
                 PT = (VAL(CHR(KP-1)) * INT(BOTT_REC/10))
                 PB = BOTT_REC
              ENDIF
           ENDIF
           MID_REC = INT((PB-PT)/2)+PT
           MID_SW = .F.  && Already at middle record of range
      CASE KP = 27 .AND. ESC  && escape key pressed
           GO BOTTOM
           SKIP    && file to EOF()
           EXIT
      CASE KP = 28  && F1 request for help
           DO SCRLBOX3
   ENDCASE
ENDDO

IF FOX
   RESTORE SCREEN FROM SCR1
ELSE
   CALL LITEBAR WITH "P0"
ENDIF

CALL LITEBAR WITH "1"

RETURN

*---------------------------------------------------------------------

PROCEDURE SCRLBOX1

* fill box from first record to eof() or box is full

@ ULR,ULC CLEAR TO LRR+3,LRC

* store record number of first record written to screen
FIRST_REC = RECNO()
CNTR = 0

DO WHILE .NOT. EOF() .AND. CNTR < MAX_LINES
   @ TOP_LINE+CNTR,FIRST_COL SAY " "+&DAT_NAME+" "
   * store record number of last record written to screen
   LAST_REC = RECNO()
   CNTR = CNTR + 1
   SKIP
ENDDO

* store relative line number of last record written on screen
LAST_POS = TOP_LINE + CNTR -1

RETURN

*-------------------------------------------------------------------------

PROCEDURE SCRLBOX2

* scroll box directions

@ LRR+5,ULC CLEAR TO LRR+7,LRC
IF ESC
   @ LRR+5,ULC+((BOX_WIDTH-19)/2) SAY CHR(24)+" "+CHR(25)+" Home End 1-9 Esc"
ELSE
   @ LRR+5,ULC+((BOX_WIDTH-16)/2) SAY CHR(24)+" "+CHR(25)+" Home End 1-9"
ENDIF
@ LRR+6,ULC+((BOX_WIDTH-20)/2) SAY "PgUp PgDn ^Home ^End"
@ LRR+7,ULC+((BOX_WIDTH-20)/2) SAY CHR(27)+" "+CHR(26)+" S-Search F1-Help"

RETURN

*-------------------------------------------------------------------------

PROCEDURE SCRLBOX3

* help screen for scroll box

IF FOX
   PRIVATE SCR1
   SAVE SCREEN TO SCR1
ELSE
   CALL LITEBAR WITH "S1"
ENDIF

CLEAR
TEXT

         H o w    T o   Q u i c k l y    L o c a t e   A   R e c o r d

                        Moving the Light-Bar and Records

    and   Move the light-bar up and down one record at a time.  When
            the window top or bottom are reached the records will scroll.

      Home  Moves the light-bar to the top record in the window.

       End  Moves the light-bar to the bottom record in the window.

     ^Home  (Ctrl-Home) Moves the light-bar to the first record in the file.

      ^End  (Ctrl-End) Move the light-bar to the last record in the file.

      PgUp  (Page Up and Page Down) scroll the records in the window up and
      PgDn       down a window-full of records at a time.

       Esc  (Escape key) Exit without selecting record (optionally available)

                   'ESC' to Quit - Any Other Key For More
ENDTEXT

@ 0,0 TO 24,79 DOUBLE

KP = 0
DO WHILE KP = 0
   KP = INKEY()
ENDDO

IF KP = 27
   IF FOX
      RESTORE SCREEN FROM SCR1
   ELSE
      CALL LITEBAR WITH "P1"
   ENDIF
   RETURN
ENDIF

CLEAR
TEXT

         H o w    T o   Q u i c k l y    L o c a t e   A   R e c o r d

                              Direct Record Location

         S  (Search) Permits direct entry of full or partial record
            content to be located directly - works only if file is indexed.

                             Relative Record Locaton

       1-9  (Numbers 1 through 9) Move to approximate 10%, 20% etc.
            position in the file - A '5' will be approximately the
            middle of the file.

                            Key Operated Binary Search

       A binary search works by repeatedly dividing a selected half
       of the records into two parts, selecting one of those halves and
       dividing it again and again until the desired record is located
       or nearly located.

                   'ESC' to Quit - Any Other Key For More
ENDTEXT

@ 0,0 TO 24,79 DOUBLE

KP = 0
DO WHILE KP = 0
   KP = INKEY()
ENDDO

IF KP = 27
   IF FOX
      RESTORE SCREEN FROM SCR1
   ELSE
      CALL LITEBAR WITH "P1"
   ENDIF
   RETURN
ENDIF

CLEAR
TEXT

         H o w    T o   Q u i c k l y    L o c a t e   A   R e c o r d


                    Key Operated Binary Search (continued)

      The <- and -> are used to initiate the binary search operation.
      When the search window first appears or after the execution of
      a ^Home or ^End the first time either key is touched the window
      will be positioned to the approximate middle record in the file.

      The Halving Procedure

      If the desired record is above the current window, press the <- key.
      If the desired record is below the current window, press the -> key.

      Repeat the halving procedure until the record is within the window or
      is nearby, then use the PgUp/PgDn or / keys to move to the record.


                   'ESC' to Quit - Any Other Key For More
ENDTEXT

@ 0,0 TO 24,79 DOUBLE

KP = 0
DO WHILE KP = 0
   KP = INKEY()
ENDDO

IF KP = 27
   IF FOX
      RESTORE SCREEN FROM SCR1
   ELSE
      CALL LITEBAR WITH "P1"
   ENDIF
   RETURN
ENDIF

CLEAR
TEXT

         H o w    T o   Q u i c k l y    L o c a t e   A   R e c o r d


                    Key Operated Binary Search (continued)

      Quick location in large files

      For large files, use the 1 through 9 keys to position the records
      as close as possible to the desired record.  This action will limit
      the binary search to the 10% of the file above and the 10% of the
      file below the current window.  Then use the halving procedure:

      If the desired record is above the current window, press the <- key.
      If the desired record is below the current window, press the -> key.

      Repeat the halving procedure until the record is within the window or
      is nearby, then use the PgUp/PgDn or / keys to move to the record.


                   - Press any Key to Return to the Window -
ENDTEXT

@ 0,0 TO 24,79 DOUBLE
SET CONSOLE OFF
WAIT
SET CONSOLE ON
IF FOX
   RESTORE SCREEN FROM SCR1
ELSE
   CALL LITEBAR WITH "P1"
ENDIF

RETURN

*-------------------------------------------------------------------------

PROCEDURE SCRLBOX4

* Reset Middle Record for binary search

PARAMETERS TR,BR
*  TR = top record limit for binary search
*  BR = bottom record limit for binary search

PRIVATE TR,BR

PT = TR
PB = BR
MID_REC = INT((PB-PT)/2)+PT
MID_SW = .T.

RETURN

*-------------------------------------------------------------------------

PROCEDURE TIMEOUT

* Time-out n seconds as specified in parameter DELAY_TIME or until keypress.
* If DELAY_TIME is defined in the calling program then the following values
* are returned in DELAY_TIME to the calling program:
*    Returns 0 if a full time-out specified in DELAY_TIME is reached.
*    Returns origional DELAY_TIME value if time-out is interrupted by keypress
*    Returns -1 if origional DELAY_TIME was zero

* Author: J. E. Whittaker
* Revision History:  05-02-87 Date Written
*                    05-08-87 Revised to return -1 for delay of less than 1

PARAMETERS DELAY_TIME
PRIVATE HOLD_TIME,TIME_CNTR,KEY

DELAY_TIME = ABS(DELAY_TIME)

IF DELAY_TIME < 1
   DELAY_TIME = -1
   RETURN
ENDIF

HOLD_TIME = TIME()
TIME_CNTR = 0

KEY = INKEY()
DO WHILE KEY = 0
   IF TIME() <> HOLD_TIME
      HOLD_TIME = TIME()
      TIME_CNTR = TIME_CNTR + 1
      IF TIME_CNTR = DELAY_TIME
         DELAY_TIME = 0
         EXIT
      ENDIF
   ENDIF
   KEY = INKEY()
ENDDO
RETURN

*-------------------------------------------------------------------------

PROCEDURE INKEY

* limited character input with inkey()

* Parameters are row,column,max length of input line

PARAMETERS ROW,COL,LL

PRIVATE ROW,COL,LL

SET COLOR TO N/W
@ ROW,COL SAY SPACE(LL)
@ ROW,COL SAY ""
CALL LITEBAR WITH "1"  && turn cursor on
DO WHILE .T.
   X=0
   DO WHILE X=0
      X = INKEY()
   ENDDO
   * Accept upper/lower case letters backspace and return key only
   IF X=13 .OR. ( X >= 32 .AND. X <= 127)
      DO CASE
         CASE X = 13   && return
            EXIT
         CASE X = 127 .AND. LEN(SEEK_STR)<> 0  && backspace
            SEEK_STR = SUBSTR(SEEK_STR,1,(LEN(SEEK_STR)-1))
         CASE X <> 127
            IF LEN(SEEK_STR)=LL
               SEEK_STR = SUBSTR(SEEK_STR,1,(LEN(SEEK_STR)-1))
               SEEK_STR = SEEK_STR+(CHR(X))
            ELSE
               SEEK_STR = SEEK_STR+(CHR(X))
            ENDIF
      ENDCASE
      SET COLOR TO N/W
      @ ROW,COL SAY SPACE(LL)
      @ ROW,COL SAY SEEK_STR
      IF LEN(SEEK_STR)=LL
         @ ROW,COL+LL-1 SAY ""
      ENDIF
      SET COLOR TO W/N
   ENDIF
   X=0
ENDDO
SET COLOR TO
CALL LITEBAR WITH "0"  && turn cursor off

RETURN

*-------------------------------------------------------------------------

PROCEDURE HELPPROC

* not part of SCRLBOX procedures
* This if for FoxBASE+ only!
* get the name and location of the current GET field and its screen
* location and force the choice from the scroll-box of the validation
* file

PRIVATE FLD_ROW,FLD_COL,FIELD_NM

FLD_ROW = ROW()
FLD_COL = COL()
FIELD_NM = SYS(18)

DO CASE
   CASE FIELD_NM = "MSTATE"
      SELECT STATES
      DO SCRLBOX WITH 5,40,10,.F.,"SELECT STATE","NAME","STATES->STATE"
      &FIELD_NM = STATES->ST
*   CASE && some other field
*   CASE && some other field
*   CASE && some other field
ENDCASE

* put the field back on the screen and move to the next field
SET COLOR TO N/W
@ FLD_ROW,FLD_COL SAY &FIELD_NM
SET COLOR TO
KEYBOARD CHR(13)    && force a carriage return at the end of the field

RETURN

*-------------------------------------------------------------------------
