/*  program name    screens.c
 *  description     put dBASE II "say y,x string" screens in a file
 *  programmer      Keith Mund
 *  installation    Mund Information Systems
 *  copyright (c)   Keith Mund 1985
 *  date written    12/1/85
 */

#include <stdio.h>
#define LINES 24
#define COLUMNS 80

main(argc,argv)
char **argv;
int argc;
{
    int first = TRUE;
    int i, y, x;
    char *head, *tail;
    char string[COLUMNS+1];
    char line[256];
    char filename[33];
    char screen[LINES][COLUMNS+1];
    char *trims();
    FILE infile, outfile;

    if (argc > 1) {
        if ((infile = open(argv[1], 0)) == ERR) {
            fputs("\nError on input open.", stderr);
            exit();
        } else {
            strcpy(filename, argv[1]);
        }
    } else {
        infile = stdin;
        strcpy(filename, "stdin");
    }
    if (argc > 2) {
        if ((outfile = creat(argv[2])) == ERR) {
            fputs("\nError on output open.", stderr);
            exit();
        }
    } else {
        outfile = stdout;
    }
    fputs("\nINPUT: ", outfile);
    fputs(filename, outfile);
    fputs("\n", outfile);
    clr_scr(screen);
    while (fgets(line, 255, infile)) {
        no_comment(line);
        if(str_index(line, "ERASE") != -1) {
            if(first)
                first = FALSE;
            else {
                fprnt_scr(screen, outfile);
                clr_scr(screen);
            }
        } else {
            if (sscanf(line, "@ %2d,%2d SAY \"%s\"", &y, &x, string) == 3) {
                head = index (line, '\"') + 1;
                tail = rindex(line, '\"') - 1;
                while (head <= tail != 0)
                    screen[y][x++] = *head++;
            }
        }
    }
    fprnt_scr(screen, outfile);
    close (infile);
    close (outfile);
}

str_index(string, substring)
char string[];
char substring[];
{
    int i, j, k;

    for (i=0; string[i] != NULL; i++)
        for (j=i, k=0; substring[k] == string[j]; k++, j++)
            if(substring[k+1] == NULL)
                return(i);

    return(-1);
}

clr_scr(screen)
char screen[LINES][COLUMNS+1];
{
    int y, x;

    for (y=0; y<LINES; y++) {
        for (x=0; x<COLUMNS; x++)
            screen[y][x] = ' ';
        screen[y][COLUMNS] = '\0';
    }
}

fprnt_scr(screen, outfile)
char screen[LINES][COLUMNS+1];
FILE outfile;
{
    int y;

    for (y=0; y<LINES; y++) {
        fputs("\n", outfile);
        trims(&screen[y][0]);
        fputs(&screen[y][0], outfile);
    }
}


char *trims(s)
char s[];
{
    int l, i=0;
    l = strlen(s);

    while (i++ < l && isspace(s[l-i]))
        s[l-i] = '\0';
    return (s);
}

no_comment(line)
char *line;
{
    while (*line) {
        if (*line == '*') {
            *line = '\0';
            break;
        }
        line++;
    }
}