****************************************
* Program Name..: SCATGATH.PRG
* Purpose.......: Emulates the Foxbase SCATTER and GATHER commands.
* Version.......: Clipper 5.0.
* Date..........: 10/02/90
*

* Pre-processor directives:
#command  SCATTER TO <x>     =>  <x> = scatter()
#command  GATHER FROM <x>    =>  gather( <x> )


* Sample program:
USE testdbf EXCL
SCATTER TO mvar
APPEND BLANK
GATHER FROM mvar
USE
RETURN


FUNCTION scatter
* Emulates the Foxbase SCATTER command.
* Returns an array containing the entire record.
LOCAL x,y,marray[FCOUNT()]
FOR x = 1 TO FCOUNT()
  y = FIELD(x)
  marray[x] = &y
NEXT
RETURN marray


FUNCTION gather(marray)
* Emulates the Foxbase GATHER command.
* Replaces fields with array contents.
LOCAL x,y,z
FOR x = 1 TO LEN(marray)
  y = FIELD(x)
  z = marray[x]
  REPLACE &y WITH z
NEXT
RETURN ''

*EOF
