
* rr2.prg, to be used with rr_mofst.dbf
* u/l'd to CIS 04.09.93, by the author - patrick ball: 71553,2372
* for FPW 2.5+

* this prg is intended to be used only to illustrate the problem of calculating real screen rows in FoxPro for Windows.  NO OTHER USE IS INTENDED BY THE AUTHOR.  NO COMMERCIAL USE WHATSOEVER IS PERMITTED.  And, furthermore, I accept no liability for whatever it does to your system.  It just defines windows and then fools with them, but if you don't know how to define windows and modify them, don't use it.  It is raw and crude -- a testing toy, NOT a commercial product.

* to view the comment text in this file, turn word wrap on.  since block comments were blown off by the Xbase standards group (bad call, I say), we're stuck with commenting that looks like this for a while.

* This file illustrates some of the work that I've been doing on how to calculate real row positions.  The basic problem is: what is the position of row() in a defined window in terms of the row() in the main FoxPro window?  Since the font of the window in which row was called may well be different from the font for the main FoxPro window, we need to figure out how to calculate the difference.

* I've included a bunch of routines in this file that illustrate some of my problems and solution ideas.  To run any one, un-comment its "do" statement in the list below and execute this prg.  For more information, see the relevant PROC -- they're all commented, more or less <g>.

* further notes.  Using a version of PROC gen_data, I made up about 240 combinations of screen and window fonts.  With that data, I tested different algorithms to calculate real row positions.  What I've settled on looks like this:
*
* rhtpx = some combination of font(1) though font(5), a measure of row height in pixels

* predicted row =  window wlrow() ;
*			+ window row() * (window rhtpx/screen rhtpx) ;
*			+ sysm(4)/screen rhtpx

* prediction error (PE) = real screen row - predicted row			

* from that I calculated descriptive stats on the following combinations of fontmetric k:1..5 as the bases of rhtpx; its pretty much a toss-up.

*                  max(PE)          std(PE)
*		avg(abs(PE))        min(PE)
* 1+2+3     0.625    3.507   -1.08   0.772
* sum(1:5)  0.667    3.78    -1.18   0.818
* 1+4+5     0.665    3.857   -1.38   0.857

* remember, these statistics are calculated in terms of screen rows.  we're talking about being off, in the worst case, by 3+ rows!  that's NOT acceptable.

* adjusting the algorithm slightly, I improved the fit, but I can't explain why.  the new algorithm is:

* fontratio = window rhtpx/screen rhtpx
* realrow = wlrow('window') - wlrow('screen') ;
*			+ ( (row() + N1) * (fontratio + N2) );
*			+ sysm(4)/scrht + sysm(9)/scrht

* where N1=0.4 and N2=0.1 (pure fishing, I don't know what those constants represent), I got:
 
*                  max(PE)          std(PE)
*		avg(abs(PE))        min(PE)
* best      0.599    2.605   -1.99   0.788


* using a technique by which the screen font is modified to be that of the calling window, I got my best results to date -- better by 1-2 orders of magnitude.  However, its still not perfect, partly by measurement error and partly by it not being quite right.  (see PROC t_pop2, below).  same table as before.

*                  max(PE)          std(PE)
*		avg(abs(PE))        min(PE)
* MSF       0.082    0.196   -0.050  0.056

* This is the right ballpark, but changing the screen font so frequently is going to have me rewriting every *&#! window definition in the system.  Think about it:  EVERY TIME you define a window, the FROM | AT clause will be dependent on what the screen font is...so you'd better set that screen font right before you define the window, 'cause you can't make those kind of assumptions.  This is a serious lack in FPW, I think, that we cannot define windows by absolute (iow, pixel) positions.

* feel free to contact me with ideas, feedback, or whatever.  thanks for looking this over.  


* do prob_1		&& illustrates the basic screen/window font conflict.

* do gen_data	&& a way to calculate real row positions vs. window positions for testing various algorithms.

* do anl_dat1	&& tests MODI WIND SCRE solution.

* do wndtest1	&& illustrates MODI WIND SCRE solution.
* do wndtest2	&& shows problem with @...GET...FONT <not wind font>

RETURN



PROC prob_1

* with f2, we'll try to put up a window (for lookups, information, whatever)
ON KEY LABEL f2 DO popper WITH ROW(),COL()

hide wind all
acti scre
MODI WIND SCREEN FONT 'FoxFont',9
clear
@0,0 say 'The screen font is '+str(font(1)+font(4)+font(5),3)+' pixels high.'
@1,0 say "Now click on each window and hit F2.  note the popup's location"

DEFINE WINDOW test1 FROM 10,0 TO 30,20 font 'ms sans serif',8
ACTIVATE WINDOW test1
@ 02,02 GET test1 DEFAULT SPACE(10)
@ 03,00 say str(font(1)+font(4)+font(5),3)+' pixels.'

DEFINE WINDOW test2 FROM 10,22 tO 30,42 font 'ms sans serif',12
ACTIVATE WINDOW test2
@ 02,02 GET test2 DEFAULT SPACE(10)
@ 03,00 say str(font(1)+font(4)+font(5),3)+' pixels.'

DEFINE WINDOW test3 FROM 10,44 TO 30,64 font 'ms sans serif',18
ACTIVATE WINDOW test3
@ 02,02 GET test3 DEFAULT SPACE(10)
@ 03,00 say str(font(1)+font(4)+font(5),3)+' pixels.'

READ

rele wind test1
rele wind test2
rele wind test3
clea wind all
RETURN


PROCEDURE popper
* this proc, called with prob_1, puts up a simple window
* for a lookup or something.  Note that it calculates real row
* as a simple wlrow()+mrow, where mrow=row() in calling screen.
PARAMETER mrow,mcol
DEFINE WINDOW testpop ;
	FROM WLROW()+mrow+1, WLCOL()+mcol+1 ;
	TO  WLROW()+mrow+20, WLCOL()+mcol+20  ;
	in screen
ACTIVATE WINDOW testpop
?
? "Press any key to continue..."
= INKEY(0)
RELEASE WINDOW testpop
RETURN


PROC gen_data
* the proc provides a way to generate a list of window row positions and real row positions against which calculations can be checked.  It puts up a couple of get fields and then activates the screen.  Mouse clicks are trapped with INKEY("M") which inserts a record into rr_mofst.  Using MROW(), real screen rows are recorded.

* note that a variation of this routine provides a way to check different combinations of screen and window fonts.  I included only this version because they are very similar.

* list of fonts
= afont(fontlist)
nfonts = alen(fontlist,1)

hide wind all
acti scre
clear

for i = 1 to nfonts
* with each font, get the error for that font with the *same*
* window font.  this means that as you click on the **top edge** of
* the get field, you create a record of the REAL ROW position in screen
* row terms.

	= afont(fontsize, fontlist[i])
	npts = alen(fontsize,1)
	for j = 1 to npts

		acti screen
		clear
		MODI WIND screen font fontlist[i], fontsize[j]
		m.scfnm = wfont(1)
		m.scfpt = wfont(2)

		DEFINE WINDOW twnd1 ;
			FROM 3,0 TO 30,40 ;
			font fontlist[i], fontsize[j]
			
		ACTIVATE WINDOW twnd1
		@ 02,02 say 'at r=2:' get x2 defa spac(10)
		@ 04,02 say 'at r=4:' get x1 defa spac(10)
		@ 06,02 say 'font #'+str(i,2)+' of '+str(nfonts,2)
		@ 07,02 say 'point #'+str(j,2)+' of '+str(npts,2)
		
		m.wnfnm = wfont(1)
		m.wnfpt = wfont(2)
		m.wnwlrow = wlrow()
		m.wnsys4 = sysm(4)
		m.wnsys9 = sysm(9)

		read when .f.
		
		acti scre
		
		do while .t.
			tkey = inkey(0,'M')
			if tkey=151
				m.realscrrow = mrow()
				insert into rr_mofst from memvar
				? 'mouse click trapped.'
			else
				if tkey=27
					RETURN to master
				else
					clea
					exit	
				endif	
			endif
		enddo
		release window twnd1
	endfor
endfor

clea wind all
RETURN



PROC wndtest1
* this proc tests the t_pop2 technique for calculating real row positions: issue a MODI WIND SCRE with the font of the currently defined window to avoid font ratio problems.

* wndtest1 runs with all the fonts currently available in order to show the universality of the solution process.  Pressing ESC a bunch of times will crash it if you get tired of running it.

* list of fonts
= afont(fontlist)
nfonts = alen(fontlist,1)

hide wind all
acti scre
clear
push key clear
on key label rightmouse do t_pop2 with row(),col(),wontop()

for i = 1 to nfonts
	= afont(fontsize, fontlist[i])
	npts = alen(fontsize,1)
	for j = 1 to npts
		acti screen
		clear
		DEFINE WINDOW twnd1 FROM 3,0 TO 30,40 ;
			title 'Test window: '+allt(fontlist[i])+', '+str(fontsize[j],3) ;
			font fontlist[i], fontsize[j]
		ACTIVATE WINDOW twnd1
		@ 02,02 say 'at r=2:' get x2 defa spac(10)
		@ 04,02 say 'at r=4:' get x1 defa spac(10)
		@ 06,02 say 'font #'+str(i,2)+' of '+str(nfonts,2)
		@ 07,02 say 'point #'+str(j,2)+' of '+str(npts,2)
		@ 08,02 say 'press ^W or ESC for next wind'
		read cycle

	endfor
endfor
pop key
RETURN


PROC wndtest2
* shows the problem of @...GET...FONT <other than window font>
* then all hope of a real row is lost, since the row() itself
* doesn't know where the GET var's baseline is.

hide wind all
acti scre
clear
push key clear
on key label rightmouse do t_pop2 with row(),col(),wontop()

DEFINE WINDOW twnd1 ;
	FROM 3,0 TO 30,40 ;
	title 'Test window: ' ;
	font 'ms sans serif', 10

ACTIVATE WINDOW twnd1
@ 02,02 say 'at r=2:' get x2 defa spac(10) font 'ms sans serif',14
@ 04,02 say 'at r=4:' get x1 defa spac(10) font 'ms sans serif',8
@ 08,02 say 'press rightmouse to show popup'
read cycle
clea wind all
pop key
RETURN



PROC t_pop2
* t_pop2 uses the MODI WIND SCRE FONT technique to define a popup window at the real row position of the current GET object.
para w_row, w_col, w_name
priv all like t_*
acti scre
* below is the actual solution:
* note that the screen's font is defined according to whatever the calling window's font and size are.
modi wind screen font wfont(1,w_name), wfont(2,w_name)
* remember that the main window itself is probably not at 0,0
m.mainwindrow = wlrow('')
acti wind (w_name) same

* sysm(9) and sysm(4) return in pixels.  they must be converted into the row metric in order to be included in the calculation.
t_ttlht = sysm(9)/font(1, wfont(1,w_name), wfont(2,w_name))
t_brdht = sysm(4)/font(1, wfont(1,w_name), wfont(2,w_name))

t_poprow = wlrow(w_name) + m.mainwindrow ;
			+ w_row ;
			+ IIF(empt(wtitle(w_name)), 0, m.t_ttlht ) ;
			+ m.bdrht ;
			+ 1
define window t_pop2 ;
	at t_poprow, w_col ;
	size 5,10 ;
	in screen
acti wind t_pop2
wait
= inkey(0)
deac wind t_pop2
rele wind t_pop2	
* t_pop2 **should** reset the screen font, else other calculations
* could be wildly, abominably trashed.
RETURN


PROC anl_dat1
* calculates real screen rows with the following algorithm:
* real_screen_row = wlrow('window') + wlrow('screen') 
*					+ row() + border height in screen rows
*
* the result is stored in rr_mofst.csr_err2
sele rr_mofst
set filter to !dele() and rr_mofst.scfnm=rr_mofst.wnfnm and rr_mofst.scfpt=rr_mofst.wnfpt

m.mainwindrow = -0.250		&& when main Fox wind is maximized ...

scan
* calculate a match:
	m.csr_err2 = rr_mofst.realscrrow - ( ;
					(rr_mofst.wnwlrow + m.mainwindrow ) ;
					+rr_mofst.wnrow2 ;
					+(rr_mofst.wnsys4/rr_mofst.scrht) )
					
	repl rr_mofst.csr_err2 with m.csr_err2

endscan
RETURN

