* PROCEDURE recempty
  *
  * Author : Steve Freides, Friday's Computer
  *
  * Usage  : ?recempty( <exp_N> | <exp_C> )
  *
  * Purpose: To determine if all fields in
  *          a database record _or_ all
  *          elements of an array are empty,
  *          according to FP's EMPTY().
  *
  * Notes  : If used on a database record,
  *          must be in the selected work area.
  *
  *          Also works under FoxBASE+ 2.1.
  *          An empty() function is included
  *          for FB users - it should be
  *          moved to a separate .prg or
  *          to a procedure file.  The empty()
  *          function will be ignored by FoxPro.


	PARAMETERS whatsinit

	SET TALK OFF

  PRIVATE ret_val,fcount,i
	ret_val = .T.
	fcount  = FCOUNT()
	i       = 1

  * No passed parameter, assume the current record
  IF ("FOXPRO" $ UPPER(VERS())) .AND. PARAMETERS()=0
		whatsinit=RECNO()
	ENDIF
	
	DO CASE
	CASE TYPE('whatsinit') = "N"
		* It's a recno
		IF RECNO()<>whatsinit
		  GO whatsinit
		ENDIF
		
		DO WHILE i < fcount
			fld_name = FIELD(i)
			IF TYPE('&fld_name')$"CLDF"
				IF !EMPTY(&fld_name)
				  ret_val=.F.
				ENDIF
			ENDIF
			i=i+1
		ENDDO

	CASE TYPE('whatsinit') = "C"
		* It's an array name
		i=1
		DO WHILE TYPE('&whatsinit(i)') <> "U"
		  IF TYPE('&whatsinit(i)') $ "CLDF"
		    IF !EMPTY(&whatsinit(i))
		    	ret_val=.F.
		    ENDIF
		  ENDIF
		  i=i+1
		ENDDO

	OTHERWISE
	  WAIT "<YOU> write this one, bozo!"

	ENDCASE
	
	SET TALK ON
	RETURN ret_val
********
PROCEDURE empty
	*
	*  Returns .T. if variable is empty.
	*
	*  Written for FoxBASE+ 2.1 by Steve Freides
	*
	PARAMETERS input_var
	PRIVATE ret_val
	ret_val = .F.   && Make it .T. if it's empty
	DO CASE
	CASE TYPE('input_var') = "C"         && Character type
    IF LEN(TRIM(input_var)) = 0
      ret_val = .T.
    ENDIF
	CASE TYPE('input_var') = "N"         && Numeric type
    IF input_var = 0
      ret_val = .T.
    ENDIF
	CASE TYPE('input_var') = "D"         && Date type
    IF input_var = CTOD("  /  /  ")
      ret_val = .T.
    ENDIF
	CASE TYPE('input_var') = "L"         && Logical type
		IF ! input_var
			ret_val = .T.
	  ENDIF
	OTHERWISE                            && Don't use Memo, please
    SAVE SCREEN TO empty_scr
    WAIT "Unexpected error in EMPTY() - please contact developer."
    RESTORE SCREEN FROM empty_scr
	ENDCASE
	RETURN ret_val
********
