
*===============================================================================
** Program : READEDIT.PRG
** Author  : Michael Zarzycki (BORBBS handle MIKEZ)
** Created : 12/02/1991 (Merry Christmas)
**
** Purpose :
** Using READ as an alternative to EDIT for one-by-one record editing.
** Fast because the unchanging @SAY's are restored from a screen memvar.
**
** Brief Narrative :
** This is furnished as is and is not real fancy, but it works. This package
** includes a zipped sample database with .MDX file and a small Help routine.
** This routine can be enhanced by configuring any SET FUNCTION press you'd
** like and stuffing the case code into the main READ loop.
**
** One of the easiest ways to set this up is to first create a screen form with
** the forms generator, then import the code into this routine from the
** resulting .FMT file. The UNCHANGING @SAY's would go in the construct saved to
** the screen memvar. The changing SAY's and the GET's would go later.
**
*===============================================================================

** CONFIGURE SETTINGS : These have probably already been configured elsewhere
set talk off
cSetCurs   =   set("cursor")
cSetScore  =   set("scoreboard")
cSetExact  =   set("exact")
cSetDelim  =   set("delimiters")
cSetStat   =   set("status")
set score off
set exact on
set delim off
set stat off

** INITIATE MEMVARS **
lScrBuilt = .F.
cTypeHelp = program()

** RECONFIGURE FUNCTION KEYS **
** (these can be anything you want)
on key label F1  do Help
on key label F10
on key label F8
on key label F3
** CHR(23) SENDS A CTRL-END
set function 10  to chr(23)
set function 8	 to chr(23)
set function 3	 to chr(23)

** DEFINE WINDOWS **
define window wEdit      from   0, 0  to  24,79  none    color /g
define window wGetNum    from  11,21  to  13,60  double  color b/w,gr+/n,b/w
define window wGetShad   from  12,22  to  14,61  176,176,176,176,176,176,176,;
   176  color ,,b/n
define window wHelp      from   4, 9  to  19,69  double  color n/w,,n/w
define window wHlpShad   from   5,10  to  20,70  176,176,176,176,176,176,176,;
   176  color ,,w/n
define window wError     from  13,10  to  19,70  205,205,186,186,33,33,173,173;
   color gr+/r,,gr+/r
define window wErrShad   from  14,11  to  20,71  176,176,176,176,176,176,176,;
   176  color ,,r/n

** OPEN DATABASE AND ASSIGN CRITICAL RECORD NUMBERS TO MEMVARS **
sele 1
use CARD order PART_NO excl
go bottom
nLRec = recno(1)
go top
nFRec = recno(1)
acti wind wEdit
set cursor on
 

** MAIN PROGRAM LOOP **
do while .T.
   ** DON'T REPAINT THESE IF THEY'VE ALREADY BEEN PAINTED ONCE **
   if .not. lScrBuilt
      @ 00,28 say "DATA CARD CHANGE SCREEN"               color w+/g
      @ 01,28 say ""               color w+/g
      @ 04,01 say "Part Number :"                         color b/g
      @ 06,01 say "Description :"                         color b/g
      @ 09,01 say "Material Type :"                       color b/g
      @ 12,01 say "Miscellaneous Comments :"              color b/g
      @ 24,00 say " F1-Help  F3-Exit Save  F8-Save Continue  F10-Jump to Part  Esc-Exit NoSave " color n/bg
      save screen to sReadEdit
      lScrBuilt = .T.
   else
      rest screen from sReadEdit
   endif

   ** SAVE THE CURRENT VALUE TO ASCERTAIN IF A CHANGE IS MADE
   cPart = PART_NO

   ** PART_NO IS THE INDEX KEY IN THIS DEMO. YOU COULD MAKE THIS A say INSTEAD
   @ 04,15  get PART_NO    pict "!!!!!!!!" color gr+/n,gr+/n
   @ 07,01  get PART_DESC  pict "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX" ;
      color gr+/n,gr+/n
   @ 10,01  get MAT_TYPE   pict "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX" ;
      color gr+/n,gr+/n
   @ 13,01  get COMMENTS   pict "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX" ;
      color gr+/n,gr+/n
   read

   ** RECONFIGURE POINTERS IF PART NUMBER WAS CHANGED (key field) **
   if PART_NO <> cPart
      go bottom
      nLRec = recno(1)
      go top
      nFRec = recno(1)
   endif

   do case

   ** JUMP TO A RECORD **
   case lastkey() = -9				&& F10
      do GetPart

   ** SAVE AND CONTINUE ON CURRENT RECORD **
   case lastkey() = -7                          && F8
      clear
      loop

   ** EXIT MAIN READ LOOP **
   case readkey() = 12 .or. readkey() = 270 .or. lastkey() = -2
      exit

   ** PROCESS "OTHER" KEYSTROKES **
   ** I DIDN'T USE EOF() BECAUSE IT'LL SHOW THE EOF() PHANTOM RECORD, AND I
   ** LIKED THE WAY IT WORKED, SO I HANDLE BOF() CHECKING THE SAME WAY. **
   case mod(readkey(),2) = 0
      if recno(1) <> nFRec
        skip -1
      else
	** POP UP A MESSAGE INSTEAD, IF YOU'D LIKE **
	?? chr(7)
      endif
   case .not. mod(readkey(),2) = 0
      if recno(1) <> nLRec
        skip +1
      else
	** POP UP A MESSAGE INSTEAD, IF YOU'D LIKE **
	 ?? chr(7)
      endif

   endcase
enddo
 
** EXITING STATEMENTS **
close data
deac wind wEdit
rele screen sReadEdit
on key label F10
on key label F8
on key label F3
set delim      &cSetDelim
set exact      &cSetExact
set status     &cSetStat
set scoreboard &cSetScore
set cursor     &cSetCurs
RETURN

** END OF MAIN PROGRAM
*===============================================================================
 
***********************
** PROCEDURE SECTION **
***********************

PROCEDURE GetPart
   ** STORE CURRENT RECORD BEFORE JUMP SO WE CAN RETURN IF PART NOT FOUND **
   nRec     = recno(1)
   cPartNum = space(08)
   acti wind wGetShad , wGetNum
   @ 0 , 1 say "Enter Part Number: " get cPartNum pict "@!"
   read
   cPartNum = trim(cPartNum)

   ** EXECUTE ONLY IF CPARTNUM IS NON-BLANK AND ESC WAS NOT PRESSED **
   if .not. (lastkey() = 27 .or. len(cPartNum) = 0)
      if .not. seek(cPartNum,"CARD")
         do ErrProc with "","Card Data for part " + cPartNum + " not found."
	 go nRec
      endif
   endif
   deac wind wGetShad , wGetNum
RETURN

*===============================================================================

PROCEDURE Help
*----------------------------------------------------------------------------
** Default Help screen parameters of 1 page. This routine will allow up to
** 3 pages of screen for one function key press. The logic may be a bit
** kludgey, but whadda you want for nothin', huh? What you do is set the
** value of nPages to 1, 2, or 3 within the case statement for page 1,
** depending on how many pages you're processing. Each page routine is
** processed only if the value of nPages warrants it. nPageNo keeps track of
** which page to display depending on the key pressed.
*----------------------------------------------------------------------------

store 1 to nPageNo , nPages
cCurs = set("cursor")
set cursor off
acti wind wHlpShad , wHelp

do while .T.
***********************************************************
************************* PAGE 1 **************************
***********************************************************
   do case
   case cTypeHelp = 'READEDIT' .and. nPageNo = 1
      nPages = 2
   text                                                   &&
 Key functionality:

   F1 - This help screen.
   F3 - Save to File and Exit.
   F8 - Save to File and Continue.
  F10 - Jump to another Part Number.
  Esc - Abort Edit and Exit.
 PgDn - Next record.
 PgUp - Previous record.

 * Next Page for Field Descriptions

Esc		       Page 1 of 2		 PgUp/PgDn
   endtext                                                &&
*---------------------------------------------------------
   otherwise
      @  6,20 say "Help not available."
      ?
   endcase
 
   * WAIT FOR USER KEYSTROKE, END OF PAGE 1
   do while nPageNo = 1
      n = inkey(0)
      do case
      ** PROCESS ESC  KEYPRESS **
      case n = 27
	 deac wind wHlpShad , wHelp
	 set cursor &cCurs
	 RETURN
      ** PROCESS PGDN KEYPRESS **
      case n = 3 .and. nPages > 1
	 nPageNo = 2
	 exit
      ** PROCESS PGUP KEYPRESS **
      case n = 18 .and. nPages > 1
	 nPageNo = iif(nPages = 2 , 2 , 3)
	 exit
      endcase
   enddo
 
***********************************************************
************************* PAGE 2 **************************
***********************************************************
   clear
   do case
   case cTypeHelp = 'READEDIT' .and. nPageNo = 2
   text                                                   &&

 * PART NUMBER : Eight character free form number

 * PART DESCRIPTION: Free form description.

 * MATERIAL TYPE: Description of the raw material for
   this part.

 * COMMENTS: Any comments up to 65 characters.
 
 * Previous Page for Key Functionality

Esc		       Page 2 of 2		 PgUp/PgDn
   endtext                                                &&
*---------------------------------------------------------
   endcase
 
   * WAIT FOR USER KEYSTROKE, END OF PAGE 2
   do while nPageNo = 2
      n = inkey(0)
      do case
      ** PROCESS ESC  KEYPRESS **
      case n = 27
	 deac wind wHlpShad , wHelp
	 set cursor &cCurs
	 RETURN
      ** PROCESS PGDN KEYPRESS **
      case n = 3
	 nPageNo = iif(nPages = 2 , 1 , 3)
	 exit
      ** PROCESS PGUP KEYPRESS **
      case n = 18
	 nPageNo = 1
	 exit
      endcase
   enddo
 
***********************************************************
************************* PAGE 3 **************************
***********************************************************
   clear
   do case
   endcase
 
   * WAIT FOR USER KEYSTROKE, END OF PAGE 3
   do while nPageNo = 3
      n = inkey(0)
      do case
      ** PROCESS ESC  KEYPRESS **
      case n = 27   &&Esc
	 deac wind wHlpShad , wHelp
	 set cursor &cCurs
	 RETURN
      ** PROCESS PGDN KEYPRESS **
      case n = 3
	 nPageNo = 1
	 exit
      ** PROCESS PGUP KEYPRESS **
      case n = 18
	 nPageNo = 2
	 exit
      endcase
   enddo
 
   clear
enddo     && of while .T.
RETURN

*===============================================================================

PROCEDURE ErrProc
parameters cErrMsg1 , cErrMsg2
cCurs = set("cursor")
acti wind wErrShad , wError
set cursor off
?? chr(7)
@  0,25 say 'E R R O R' color w+/r
@  1,(60-len(cErrMsg1))/2 say cErrMsg1
@  2,(60-len(cErrMsg2))/2 say cErrMsg2
@  4,19 say 'Press a key to continue.' color w+/r
nE = inkey(0)
deac wind wErrShad , wError
set cursor &cCurs
RETURN
 
** EOF READEDIT.PRG

