*-- PROGRAM: Radio
*--------------------------------------------------------------------
*-- Programmer: Ed Lafferty (GICHIN)
*-- Date      : 2/25/92
*-- Notes     : Routine to create and size a popup with radio buttons
*--             for choosing only one of up to five options.  Pressing
*--             the <Space Bar> on an option turns it on or off.
*--             Pressing <Enter> chooses the selected option and leaves
*--             the routine.
*-- Written for: dBase IV 1.1
*-- Rev. Hist.: None
*-- Calls     : Center, Shadow (if you want to put it in)
*-- Called by : Any
*-- Usage     : do Radio with 8, 15, nButton, "LPT1", "LPT2", "LPT3",;
*--             "", "", "Choose a printer port"
*-- Example   : && Place a value in nButton, either by
*--             && store 1 to nButton
*--             && or
*--             && restore from <memfile name>
*--             do Radio with 8, 15, nButton, "LPT1", "LPT2", "LPT3"';
*--             "", "", "Choose a printer port"
*-- Returns   : number of chosen button in nButton
*-- Parameters: nUlrow: upper left row of popup
*--             nUlcol: upper left column of popup
*--             nChoice: default chosen button
*--             cTxt1  : Text for 1st button
*--             cTxt2  :  "    "  2nd   "
*--             cTxt3  :  "    "  3rd   "
*--             cTxt4  :  "    "  4th   "
*--             cTxt5  :  "    "  5th   "
*--             cTxt0  : Text for the box title

*PROCEDURE Radio
para nUlrow, nUlcol, nChoice, cTxt1, cTxt2, cTxt3, cTxt4, cTxt5, cTxt0
clear
store 0 to nHeight, nKey, nCnt, nWidth
*store nChoice to nOrig

*-- Determine height and width of popup
do case
case len(cTxt5) > 0
   nHeight = 5
case len(cTxt4) > 0
   nHeight = 4
case len(cTxt3) > 0
   nHeight = 3
case len(cTxt2) > 0
   nHeight = 2
case len(cTxt1) > 0
   nHeight = 1
endcase

do while nCnt <=nHeight
   store "cTxt"+str(nCnt,1) to cStr
   if len(&cstr) > nWidth
      nWidth = len(&cStr)
   endif
   nCnt = nCnt + 1
enddo

*-- create popup
define window wradio from nUlrow, nUlcol to nUlrow+nHeight+5, nUlcol+nWidth+8
do center with 23,80,"","Press <Space> to select/de-select, <Enter> to quit"
activate window wradio
store 1 to nCnt
do center with 0, nWidth+8, "", cTxt0
do while nCnt <= nHeight
   store "cTxt"+str(nCnt,1) to cStr
   @ nCnt+1, 2 SAY "[ ] "+&cStr
   nCnt = nCnt + 1
enddo

*-- prepare for and get nChoice
if nChoice > 0
   store nChoice to nCnt
   @ nCnt+1,3 say ""
else
   store 1 to nCnt
endif
store .F. to ldone
do while .not. ldone
@ nCnt+1,3 say ""
nkey = inkey(0)
do case
case nkey = 27                                   && Press Esc to exit
   store nOrig to nChoice
   store .T. to ldone
case nkey = 13
   store .T. to ldone
case nkey = 32                    && Press Enter or Space
      set cursor off
      if nChoice = nCnt
         @ nCnt+1,3 say " "
         store 0 to nChoice
      else
         @ nChoice+1,3 say " "
         @ nCnt+1,3 say ""
         store nCnt to nChoice
      endif
      set cursor on
case nkey = 5                                    && Press up arrow
   if nCnt > 1
      nCnt = nCnt - 1
   else
      nCnt = nHeight
   endif
case nkey = 24                                   && Press down arrow
   if nCnt < nHeight
      nCnt = nCnt + 1
   else
      nCnt = 1
   endif
endcase
enddo
release window wradio
set message to
RETURN

