EXTERNAL ARRAY NCHOICE
EXTERNAL ARRAY N_SELECT

** what mark checks field picklists to see which fields were selected
** then place the selected fields in the appropriate popup
procedure what_mrk
parameters pre,not_done
priv fld_array,cnt_bar,i,m_len,flist,mflds,a_name,pre,pre_prompt
priv not_done

** pre parameter identifies the appropriate picklist and popup
flist=pre+'_flist'
mflds=pre+'_flds'
a_name=pre+'choice'

m_len=cntbar(flist)

** store existing popup bars in array
cnt_bar=cntbar(mflds)
if cnt_bar > 0
  dimension fld_array(cnt_bar)
  for i=1 to cnt_bar
    store PRMBAR(mflds,getbar(mflds,i)) to fld_array(i)
  endfor
endif  


release bar all of (mflds)
x=1

** redefine bars with bar numbers in order
** in case the user rearranged the popup bars
if cnt_bar > 0
  for n=1 to cnt_bar
   DEFINE BAR x OF (mflds) PROMPT fld_array(n) 
   x=x+1
  endfor
endif
release fld_array

pre_prompt=iif(pre='o','','')

for n=1 to m_len

    
    if mrkbar(flist,n) 
     
     ** a_name contains the name of picklist array
     ** if the 4th column is .t., then the field
     ** has already been selected
     
     ** add newly marked bars to Query popup menu
     ** if field not previously selected 
     if ! &a_name.(n,4)   && not already in Query popup menu     
       DEFINE BAR x OF (mflds) PROMPT pre_prompt + &a_name.(n,1)
       x=x+1 
       ** make sure that field is disabled in the picklist
       SET SKIP OF BAR n OF (flist) .t.
       store .t. to &a_name.(n,4)
     endif && ! &a_name.(n,4)
    else
      do case
      case inlist(upper(pre),'O','G') and &a_name.(n,3)=='M'
       ** make sure Memo field is skipped
       SET SKIP OF BAR n OF  (flist) .t.
      ** not in Query popup menu, so make available in picklist
      case ! &a_name.(n,4)  
       SET SKIP OF BAR n OF (flist) .f.
      otherwise
       SET MARK OF BAR n OF  (flist) TO .t.
       SET SKIP OF BAR n OF (flist) .t.
      endcase
    endif

endfor
if ! not_done               && finished with list
 do q_refresh with pre
endif 


** refresh screen procedure
procedure q_refresh
parameters pre
priv pre,rmflds,rget_name,m_no_dupes
rmflds=pre+'_flds'
rget_name=pre+'_arrange'

** resize popups in case they were enlarged 
** with Arrange/Remove option

do case
case rmflds='f_flds'
  size popup (rmflds) to 8,28
case rmflds='o_flds'
  size popup (rmflds) to 3,28
otherwise
  size popup (rmflds) to 2,28
endcase

 
if cntbar(rmflds) > 0 
  activate popup (rmflds) bar 1 nowait
  show get (rget_name) enable
  if pre='o'
    show get 'o_order' enable
  endif
else  
  show get (rget_name) disable
  if pre='o'
    show get 'o_order' disable
  endif
endif

if cntbar('f_flds') = 3    && allow cross tabulation
 show get q_xtab enable
else
 q_xtab=.f.
 show get q_xtab disable
endif

if cntbar('f_flds') = 0    && no fields selected for Query
 show gets disabled
 show get f_select enable
 show get m_cancel enable
 show get n_choice enable
 show get m_function enable
 show get m_do_query disable
 show get m_see_sql disable
 show get m_qbe_put disable
 show get m_sav_rest enable
 show get m_qbe_opt enable
else
 show get o_select enable
 show get g_select enable
 show get r_filter enable
 show get no_dupes enable
 show get n_choice enable
 show get m_function enable
 show get m_do_query enable
 show get m_see_sql enable
 show get m_qbe_put enable
 if empty(r_ex_name)
   show get r_ex_name disable
 else
   show get r_ex_name enable
 endif


 if cntbar('o_flds')<>0
   show get o_order enable
   show get o_arrange enable
 endif  
 if cntbar('g_flds')<>0
  show get g_arrange enable
  show get g_filter enable
  if empty(g_ex_name)
    show get g_ex_name disable
  else
    show get g_ex_name enable
  endif
 else
   show get g_filter disable
   show get g_ex_name disable
 endif  

endif
if !empty(m_function)
  show get m_put_func enable
else
  show get m_put_func disable
endif  

m_no_dupes=is_distinc()
if m_no_dupes
  no_dupes=.f.
  show get no_dupes disable
else
 if cntbar('f_flds') > 0    && no fields selected for Query  
   show get no_dupes enable
 endif  
endif
show gets



** removes bars from popups
procedure fld_remove
parameters pre
priv cnt_bar,x,i,n,flist,mflds,a_name,fld_array


flist=pre+'_flist'
mflds=pre+'_flds'
a_name=pre+'choice'

cnt_bar=cntbar(mflds)
x=1
if cnt_bar > 0
  ** if some bars exist, save them in array, but do it backwards
  dimension fld_array(cnt_bar)
  for i= cnt_bar to 1 step -1
    if mrkbar(mflds,getbar(mflds,i))
       if pre='o'       
         ** make sure prefix is '' so it will match picklist o_flist
         store ''+subs(PRMBAR(mflds,getbar(mflds,i)),2) to fld_array(x)
       else
         store PRMBAR(mflds,getbar(mflds,i)) to fld_array(x)
       endif
       
       release bar getbar(mflds,i) of (mflds)
      
      ** if bar exist, need to disable matching field in picklist
      for n=1 to cntbar(flist)
        if fld_array(x)=prmbar(flist,n)
          store .f. to &a_name.(n,4)
          SET SKIP OF BAR n OF (flist) .f.
          SET MARK OF BAR n OF (flist) TO .f.
          exit
        endif  
      endfor
      x=x+1
    endif
  endfor

  release fld_array

  ** save bars in array
  cnt_bar=cntbar(mflds)
  if cnt_bar > 0
    dimension fld_array(cnt_bar)
    for i=1 to cnt_bar
      store PRMBAR(mflds,getbar(mflds,i)) to fld_array(i)
    endfor
  endif  
  
  
  release bar all of (mflds)
  x=1
  
  ** redefine bars with new order...numbers in order
  if cnt_bar > 0
    for n=1 to cnt_bar
     DEFINE BAR x OF (mflds) PROMPT fld_array(n) 
     x=x+1
    endfor
  endif
  release fld_array

endif  

if lastkey() = 32     && space
 ** make highlight bar appear
 keyboard "{DNARROW}"
endif
return







** presents picklist to select from
procedure select_val
parameters pre
priv flist,mflds,get_name,n

** order by and group by picklist are disabled
** if no fields selected for query
if pre <> 'f'
  if cntbar('f_flds')=0
    return
  endif  
endif    


** make sure memo fields can't be selected
do case
case pre='o'               && order by
 for n=1 to alen(ochoice,1)
   if ochoice(n,3)='M'
     SET SKIP OF BAR n OF o_flist .t.
   endif
 endfor  

case pre='g'               && group  by
 for n=1 to alen(gchoice,1)
   if gchoice(n,3)='M'
     SET SKIP OF BAR n OF g_flist .t.
   endif
 endfor  

endcase


flist=pre+'_flist'
mflds=pre+'_flds'
get_name=pre+'_arrange'
push key clear
do set_func

do showMess with 0,.f., ;
   ' Click Mouse off selection list or press < Esc > when you are',;
   ' finished selecting fields to ';
    +iif(pre='f',"INCLUDE in Query.",iif(pre='o',"ORDER Query.","GROUP Query."))
show window showMess in window QBE
*wait ' Click Mouse off selection list or press < Esc > when Done.' window nowait
on selection popup (flist) do what_mrk with pre,.t.
activate popup (flist )

if wexist('SHOWMESS')
  release window showMess
endif  

do what_mrk with pre
pop key




** allows user to arrange or remove popup bars
** ...Field list,Order by,Group by
procedure arrangeval
parameters pre
priv flist,mflds,pre

flist=pre+'_flist'
mflds=pre+'_flds'

if cntbar(mflds)=0
  return
endif  
push key clear
do set_func
if mflds='f_flds'
 SIZE POPUP (mflds) TO 12,35 
else
   size popup (mflds) to 9,35
endif 

do showMess with 0,.f., ;
  '< Space > or Mouse to Remove Field. < Ctrl- >- Arrange. < Esc >- Done.'
*wait '< Space > or Mouse to Remove Field. < Ctrl- >- Arrange. < Esc >- Done.' window nowait
show window showMess in window QBE
on selection popup (mflds) do fld_remove with pre
activate popup (mflds)
if wexist('SHOWMESS')
  release window showMess
endif  
on selection popup f_flds do sel_f
on selection popup o_flds do sel_o
on selection popup g_flds do sel_g
do fld_remove with pre
do q_refresh with pre
pop key


** these 3 procedures remove fields, then refresh screen
procedure sel_f
do fld_remove with 'f'
do q_refresh with 'f'

procedure sel_o
do fld_remove with 'o'
do q_refresh with 'o'

procedure sel_g
do fld_remove with 'g'
do q_refresh with 'g'

**


** allows user to order by desc/asc
procedure order_set
if cntbar('f_flds')=0
  return
endif  
push key clear
do set_func
do showMess with 0,.f., ;
  ' < Space > or Mouse to reverse order of selected item. < Esc >- Done'
show window showMess in window QBE

*wait ' < Space > or Mouse to reverse order of selected item. ' window nowait
on selection popup o_flds do o_asc_desc
size popup o_flds to 9,35
activate popup o_flds
if wexist('SHOWMESS')
  release window showMess
endif  
on selection popup o_flds do sel_o
pop key
do q_refresh with 'o'



** called by order_set
procedure o_asc_desc
priv mbar,mprompt,i,n,fld_array,cnt_bar,save_bar,m_found
m_found=.f.
mprompt=subs(prmbar('o_flds',bar()),2)

push key clear
do set_func

cnt_bar=cntbar('o_flds')

** save popup prompts and order in array
dimension fld_array(cnt_bar)
for n=1 to cnt_bar
  store prmbar('o_flds',getbar('o_flds',n)) to fld_array(n)
endfor

** was bar marked
save_bar=0
for n=1 to cnt_bar
 if mrkbar('o_flds',getbar('o_flds',n))
   save_bar=n
   exit   
 endif
endfor

release bar all of o_flds


** store ascend/descend order in 5th column of ochoice array
for i=1 to cntbar('o_flist')
 if mprompt=ochoice(i,1)
  store ! ochoice(i,5) to ochoice(i,5)
  exit
  m_found=.t.
 endif
endfor


** redefine bars with arrows in correct direction
for n=1 to cnt_bar
 if n=save_bar and m_found
  define bar n of o_flds prompt iif(ochoice(i,5),'','')+ ;
  + subs(fld_array(n),2)
 else 
  if ! m_found and n=save_bar
   if left(fld_array(n),1)=''
     define bar n of o_flds prompt ''+subs(fld_array(n),2)
   else
     define bar n of o_flds prompt ''+subs(fld_array(n),2)       
   endif
  else
   define bar n of o_flds prompt fld_array(n)
  endif
 endif 
endfor

release fld_array
if lastkey() = 32     && space
 ** make highlight bar appear
 keyboard "{DNARROW}"
endif
pop key
return


procedure sel_func
if n_choice=9
  show get m_function
  deac popup n_flist
  return
endif
** put selected field in side function parentheses
store STUFF(n_select(n_choice), at(')',n_select(n_choice)),;
 	0, trim(nchoice(bar(),2))) to m_function
m_function= padr(m_function,254)
show get m_function
deac popup n_flist


** used to place function in popup lists...
** Fields,Order by,Group by
procedure put_func
parameters choice
priv pref,choice
if empty(m_function)
 return
endif

do case
case choice=1
 define bar cntbar('f_flds')+1 of f_flds prompt  upper(trim(m_function))
 activate popup f_flds nowait
 pref= 'f'
case choice=2
 if ! allowfunc()
   wait " Can't put Function in Order_by list unless in Field list. " window nowait
 else
  define bar cntbar('o_flds')+1 of o_flds prompt ''+trim(m_function)
  activate popup o_flds nowait
 endif
 pref= 'o'
case choice=3
 if ! allowfunc()
   wait " Can't put Function in Group_by lists unless in Field list. " window nowait
 else
   define bar cntbar('g_flds')+1 of g_flds prompt trim(m_function)
   activate popup g_flds nowait
 endif
 pref= 'g'
endcase
do q_refresh with pref



** check to see if function in Fields Selected popup
** if not, don't allow function in Order by,Group by lists
procedure allowfunc
priv ret_val
ret_val=.f.

for i=1 to cntbar('f_flds')
 if upper(alltrim(m_function))=upper(alltrim(PRMBAR('f_flds',getbar('f_flds',i)))) 
  ret_val=.t.
  exit
 endif
endfor
return ret_val





** see if query has the "DISTINCT" option in it
procedure is_distinc
priv ret_val
ret_val=.f.
for i=1 to cntbar('f_flds')
  ret_val=at('(DISTINCT', upper(prmbar('f_flds',getbar('f_flds',i)))) > 0 
  if ret_val
    return ret_val
  endif  
endfor
for i=1 to cntbar('o_flds')
  ret_val=at('(DISTINCT', upper(prmbar('o_flds',getbar('o_flds',i)))) > 0 
  if ret_val
    return ret_val
  endif  
endfor
for i=1 to cntbar('g_flds')
  ret_val=at('(DISTINCT', upper(prmbar('g_flds',getbar('g_flds',i)))) > 0 
  if ret_val
    return ret_val
  endif  
endfor
return ret_val


** this procedure creates the SQL code and runs it
** or shows it if SEE SQL chosen
procedure do_query
parameters m_see,sbq_un_bld,sbqun_expr
priv q_clause,mprompt,mprompt2,m_found,d_found,o_clause,g_clause
priv q_table,m_str,m.AllFields
priv q_dbfs,pre,save_prom,q_stop,m_area2,add_func
priv choice,m_dbfs,m_see,m_suff,m_sql_err
priv mmemowidth,xx,yy,i,m_set_text,m_text_del,m_safety,xtab_prg,n,z
priv qx,qxc,qxx,qu,quc,uu

** sbqun_expr=contains subquery or union clause
** sbq_un_bld=.t. if building subquery or union clause

add_func=''
m.AllFields=.f.

if type('sbqun_expr')='L'
 sbqun_expr=''
endif 


m_safety=set('SAFETY')
mmemowidth=set('MEMOWIDTH') 

push key clear
do set_func

if m_see    && see SQL
 m_suff=';'+chr(10)+chr(13)
else
 m_suff=''
endif

m_sql_err=.f.

save_prom=''
m_dbfs=''

mprompt=''
mprompt2=''
from_phra=''
d_found=0

store '' to o_clause,g_clause   && will hold order,group clauses if needed

if cntbar('f_flds') = 0
  wait ' No fields selected. Unable to do query. Press any key... ' window
  clear typeahead
  pop key
  return
endif

** look for all DBFs in picklist

dimension q_dbfs(25,2)
x=1
for n=1 to alen(fchoice,1)
      
 m_found=.f.

 for n=1 to alen(fchoice,1)
     mprompt=fchoice(n,2)
     ** look for field alias in array of DBFs
     d_found=ascan(q_dbfs,alltrim(upper(left(mprompt,at('.',mprompt)-1) )))
     if ! d_found > 0       && if alias not found add to DBF array
       store alltrim(upper(left(mprompt,at('.',mprompt)-1))) to q_dbfs(x,1)
       x=x+1
     endif

 endfor
endfor




q_clause=''
** process no_dupes 
if no_dupes
  q_clause='DISTINCT ' 
endif  

** process selected fields
for i=1 to cntbar('f_flds')

  m_found=.f.
  ** store popup bar to mprompt
  store PRMBAR('f_flds',getbar('f_flds',i)) to mprompt
  ** look for DBFs in Selected fields
  for n=1 to alen('fchoice',1)
    if mprompt=fchoice(n,1)     && if expression in field picklist
      ** can't have memo field in Cross Tabulation
      if fchoice(n,3)='M' and q_xtab   && memo
        pop key
        wait 'Memo fields not allowed in Cross Tabulation';
           window nowait
        return
      endif
      m_found=.t.
      mprompt=fchoice(n,2)   && store field name to mprompt
      ** look for field alias in array of DBFs
      d_found=asubscript(q_dbfs,ascan(q_dbfs,alltrim(upper(left(mprompt,at('.',mprompt)-1) ))),1)
      ** mark DBF to include in FROM clause
      if d_found > 0
        store .t. to q_dbfs(d_found,2)
      endif
      exit
    endif 
  endfor

  if ! m_found              && not in field picklist
    ** look for function
    if at('DISTINCT',upper(mprompt)) > 0

     ** extract field label from function
      mprompt2=strtran(alltrim(upper(subs(mprompt,at('(',;
      mprompt)+10))),')')

    else
     ** extract field label from function
     mprompt2=strtran(alltrim(upper(subs(mprompt,at('(',mprompt)+1))),')')
    endif

    m_found=.f.
    for n=1 to alen('fchoice',1)
     if mprompt2=alltrim(fchoice(n,2))  && if field label in field picklist
      m_found=.t.

      ** look for field alias in array of DBFs
      d_found=asubscript(q_dbfs,ascan(q_dbfs,alltrim(upper(left(mprompt2,at('.',mprompt2)-1) ))),1)
      
      ** mark DBF to include in FROM clause
      
      if d_found > 0
        store .t. to q_dbfs(d_found,2)
      endif 
      
      exit
     endif 
     
     ** look for field alias in possible Foxpro expression

      do FindAlias with PRMBAR('f_flds',getbar('f_flds',i))


    
    endfor


  endif  && ! m_found
  
  ** if "count(*)" or "*" the only item in query, make sure 
  ** all DBFs are included in FROM clause
  
  if (alltrim(mprompt2) == '*' or alltrim(mprompt) == '*') ;
       and cntbar('f_flds') = 1 
    m.AllFields=.t.      
    for n=1 to alen(q_dbfs,1)
      if ! empty(q_dbfs(n,1))
        store .t. to q_dbfs(n,2)
      endif      
    endfor
  endif


  if alltrim(mprompt) == '*'
     m.AllFields=.t.
  endif

  ** add AS clause if all fields "*" not selected
  do case
  case i=1 and alltrim(mprompt)=='*' and cntbar('f_flds') = 1 
     q_clause=q_clause+alltrim(mprompt)
     exit
  case i=1 and ! m_found
     q_clause=q_clause+alltrim(mprompt)
  case i=1 and m_found
    ** if no custom picklist and not a function
    if empty(q_file) and;
     at('(',alltrim(PRMBAR('f_flds',getbar('f_flds',i)))) =0 and;
     at('.',alltrim(PRMBAR('f_flds',getbar('f_flds',i)))) =0
     q_clause=q_clause+alltrim(mprompt)
    else
     q_clause=q_clause+alltrim(mprompt)+;
     iif(m_AS,' AS ' + strip_char(alltrim(PRMBAR('f_flds',getbar('f_flds',i)))),'')
    endif
  otherwise
   if ! m_found
    q_clause=q_clause+','+ alltrim(mprompt)
   else
    ** if no custom picklist and not a function    
    if empty(q_file) and;
     at('(',alltrim(PRMBAR('f_flds',getbar('f_flds',i)))) =0 and;
     at('.',alltrim(PRMBAR('f_flds',getbar('f_flds',i)))) =0
     q_clause=q_clause+','+alltrim(mprompt)
    else
     q_clause=q_clause+','+ alltrim(mprompt)+;
     iif(m_AS,' AS ' + strip_char(alltrim(PRMBAR('f_flds',getbar('f_flds',i)))),'')
    endif
   endif

  endcase

endfor

** see if all fields selected
** if so, exchange "*" for field names
x=0
for i=1 to cntbar('f_flist')
 if SKPBAR('f_flist',i)
  x=x+1
 endif
endfor
if cntbar('f_flist')  = x
  m.AllFields=.t.
  add_func=''
  if cntbar('f_flds') > cntbar('f_flist')  && functions in selected fields
    ** look for functions in selected fields
    ** this will support the syntax...
    **
    **   SELECT left(zip_code,5),* FROM ....
    
    for n=1 to cntbar('f_flds')
     if at('(',alltrim(PRMBAR('f_flds',getbar('f_flds',n)))) > 0 ;
       and ascan(fchoice,PRMBAR('f_flds',getbar('f_flds',n))) = 0
      add_func=add_func+alltrim(PRMBAR('f_flds',getbar('f_flds',n)))+','
     endif 
    endfor  

  endif
  
  add_func=iif(empty(add_func),add_func,add_func+' ')
  
  if no_dupes
    q_clause='DISTINCT '+add_func +'* ' 
  else
    q_clause=' '+add_func +'* '
  endif  
endif


** process Order by
for i=1 to cntbar('o_flds')

  m_found=.f.
  store PRMBAR('o_flds',getbar('o_flds',i)) to mprompt
  ** look for DBFs in Order by fields
  save_prom=mprompt
  for n=1 to alen('ochoice',1)
    if subs(mprompt,2)=ochoice(n,1)
      m_found=.t.
      mprompt=ochoice(n,2)
      ** look for field in array of DBFs
      d_found=asubscript(q_dbfs,ascan(q_dbfs,alltrim(upper(left(mprompt,at('.',mprompt)-1) ))),1)
      ** mark DBF to include in FROM clause
      if d_found > 0
        store .t. to q_dbfs(d_found,2)
      endif
      exit
    endif 
  endfor


  ** remove arrow prefix if present
  if left(mprompt,1)='' or left(mprompt,1)=''
    mprompt=subs(mprompt,2)  
  endif
  


  ** if Order By expression in Field list,reference by number
  ** look for expression in selected fields
  for n=1 to cntbar('f_flds')
     do case
     ** all fields selected, but list contains expressions too
     case m.AllFields and ! empty(add_func)
       if at(upper(mprompt),upper(add_func)) > 0
          mprompt=alltrim(str(occurs('),',left(add_func,;
          at(upper(mprompt),upper(add_func))))+1))
       endif 
      
     case upper(mprompt) = upper(PRMBAR('f_flds',getbar('f_flds',n)))
       mprompt=alltrim(str(n))
     endcase 
  endfor

  ** check to see if Order by item is a field
  if ascan(fchoice,mprompt) > 0
    d_found=asubscript(fchoice,ascan(fchoice,mprompt),1)
  else
    d_found=0
  endif    

  if d_found > 0                 && if a field
   mprompt2=fchoice(d_found,1)   && store field label to mprompt2
  ** if Order By field in Field list,reference by number
     for n=1 to cntbar('f_flds')  && look for label in selected fields
      if upper(mprompt2) = upper(PRMBAR('f_flds',getbar('f_flds',n)))
        mprompt=alltrim(str(n))
      endif 
     endfor
  endif && d_found > 0 


  if left(save_prom,1)=''
    mprompt=alltrim(mprompt)+' ASC ' 
  else
    mprompt=alltrim(mprompt)+' DESC '   
  endif
  

  if i=1 
     o_clause=' ORDER BY '+ mprompt
  else
     o_clause=o_clause+','+ mprompt
  endif

endfor


** process Group by
for i=1 to cntbar('g_flds')

  m_found=.f.
  store PRMBAR('g_flds',getbar('g_flds',i)) to mprompt
  ** look for DBFs in Group by fields
  for n=1 to alen('gchoice',1)
    if mprompt=gchoice(n,1)
      m_found=.t.
      mprompt=gchoice(n,2)
      ** look for field in array of DBFs
      d_found=asubscript(q_dbfs,ascan(q_dbfs,alltrim(upper(left(mprompt,at('.',mprompt)-1) ))),1)
      ** mark DBF to include in FROM clause
      if d_found > 0
        store .t. to q_dbfs(d_found,2)
      endif
      exit
    endif 
  endfor




**  endif

  ** if Group By expression in Field list,reference by number

  for n=1 to cntbar('f_flds')
     do case
     ** all fields selected, but list contains expressions too
     case m.AllFields and ! empty(add_func)
       if at(upper(mprompt),upper(add_func)) > 0
          mprompt=alltrim(str(occurs('),',left(add_func,;
          at(upper(mprompt),upper(add_func))))+1))
       endif 
      
     case upper(mprompt) = upper(PRMBAR('f_flds',getbar('f_flds',n)))
       mprompt=alltrim(str(n))
     endcase 



  endfor

 
  ** check to see if group by item is a field
  if ascan(fchoice,mprompt) > 0
    d_found=asubscript(fchoice,ascan(fchoice,mprompt),1)
  else
    d_found=0
  endif    


  if d_found > 0                  && if a field
   mprompt2=fchoice(d_found,1)    && store field label to mprompt2
   ** if Group By field in Field list,reference by number
     for n=1 to cntbar('f_flds')  && look for label in selected fields
      if upper(mprompt2) = upper(PRMBAR('f_flds',getbar('f_flds',n)))
        mprompt=alltrim(str(n))
      endif 
     endfor
  endif && d_found > 0 
  


  if i=1 
     g_clause=' GROUP BY '+ alltrim(mprompt)
  else
     g_clause=g_clause+','+ alltrim(mprompt)
  endif

endfor




** check filter expressions for DBFs
if r_filter
 do FindAlias with trim(r_expr)
endif
if g_filter
 do FindAlias with trim(g_expr)
endif




q_clause=q_clause+ m_suff + ' FROM'

** process DBFs included in Select
x=1
for n=1 to alen(q_dbfs,1)
  if q_dbfs(n,2)
    
    if x=1
     q_clause=q_clause+' '+alltrim(q_dbfs(n,1))
     m_dbfs=alltrim(q_dbfs(n,1))
    else
     q_clause=q_clause+','+alltrim(q_dbfs(n,1))
     m_dbfs=m_dbfs+','+alltrim(q_dbfs(n,1))
    endif
    x=x+1
    m_dbfs=trim(m_dbfs)
  endif
endfor


** WHERE JOIN clause
if x > 2
   do case
   **  program that returns the proper join expression
   case ! empty(JoinPrg) and mAutoJoin  
     do (JoinPrg)
   case BldJoin and mAutoJoin 
     w_expr=JoinExpr()   && build Join expression from environment
   case ! empty(q_file)
    push key clear
    do set_func
    wchoice='No'
    if !empty(w_expr)
    
    
*       wchoice=yes_no('Use Current JOIN CONDITION: "';
*        +alltrim(w_ex_name)+'"',10,0,20,79,.t. )
    
      wchoice=yes_no('Use Current JOIN CONDITION: "';
        +iif(empty(w_ex_name),alltrim(left(w_expr,42)) ;
        +iif(len(w_expr)  > 42,'...',''),alltrim(w_ex_name))+ ;
        '"',10,0,20,79,.t. )
    
    
    endif  && !empty(w_expr)
    if wchoice='No'
     ** try to limit expressions to just the JOIN expressions
     ** for current picklist by passing JOIN+part of picklist
     ** name.
     wait 'Select JOIN: '+m_dbfs window nowait
     if exprChoice='Simple'
       do qsimple.spr with w_expr,w_ex_name,'fchoice','ARRAY','JOIN'+left(q_file,4)
     else  
       GETEXPR 'Enter Databases Join expression... ' TO w_expr;
        DEFAULT w_expr
     endif
  
    endif  && wchoice='No'   
    pop key
   otherwise
     if exprChoice='Simple'

       push key clear
       do set_func
       wchoice='No'
       if !empty(w_expr)


*         wchoice=yes_no('Use Current JOIN CONDITION: "';
*         +alltrim(w_ex_name)+'"',10,0,20,79,.t. )

      wchoice=yes_no('Use Current JOIN CONDITION: "';
        +iif(empty(w_ex_name),alltrim(left(w_expr,42)) ;
        +iif(len(w_expr)  > 42,'...',''),alltrim(w_ex_name))+ ;
        '"',10,0,20,79,.t. )


       endif  && !empty(w_expr)
       if wchoice='No'
        ** try to limit expressions to just the JOIN expressions
        ** for current picklist by passing "JOIN" as picklist name
        wait 'Select JOIN: '+m_dbfs window nowait


        do qsimple.spr with w_expr,w_ex_name,'fchoice','ARRAY','JOIN'
 
       endif
       pop key

     else  
       GETEXPR 'Enter Databases Join expression... ' TO w_expr;
        DEFAULT w_expr
     endif
     w_expr=upper(alltrim(w_expr))

   endcase
   
   if empty(w_expr)
    store '' to w_expr,w_ex_name
    q_stop='No'
    if ! m_see
     q_stop=yes_no('Databases NOT JOINED. Results may be HUGE. Cancel Query?',;
     10,5,18,74,.t.)
    endif
    if q_stop='Yes'
      pop key
      return
    endif

   else
     if at('(',w_expr) = 0
      w_expr='('+w_expr+')'
     endif 
     
     q_clause=q_clause+ m_suff +' WHERE '+w_expr
   endif    

else
  store '' to w_expr,w_ex_name
endif && x > 1

** process record filter
if r_filter
 if at('WHERE',q_clause) > 0
   q_clause=q_clause+' AND '+alltrim(r_expr)
 else
   q_clause=q_clause+m_suff +' WHERE '+alltrim(r_expr)
 endif
endif

**   && subquery expression ! empty
if !empty(sbqun_expr) and opt_type='Subquery'
 if at('WHERE',q_clause) > 0

  do case
  case at('<AND>',sbqun_expr) > 0
  
   q_clause=q_clause+' AND '+ m_suff +subs(sbqun_expr,at('>',sbqun_expr)+1)

  case at('<OR>',sbqun_expr) > 0
  
   q_clause=q_clause+' OR '+m_suff + subs(sbqun_expr,at('>',sbqun_expr)+1)
  endcase

 else
   q_clause=q_clause+m_suff +' WHERE '+ ;
           subs(sbqun_expr,at('>',sbqun_expr)+1)
 endif
endif


** add Order by and Group by if applicable
if ! empty(o_clause)
 q_clause=q_clause+m_suff +o_clause
endif 
if ! empty(g_clause)
 q_clause=q_clause+m_suff +g_clause
endif 

** process group filter
if g_filter
   q_clause=q_clause+m_suff +' HAVING '+alltrim(g_expr)  
endif


** clear subquery clause/ leave if union
if !empty(sbqun_expr) and opt_type='Subquery'
  sbqun_expr='' 
endif




********************
** GENXTAB.PRG Note
**
** See QBE_HELP.DBF for details on modifying GENXTAB.PRG
*******************


** add FoxPro's directory to GENXTAB.PRG
xtab_prg=sys(2004)+"genxtab.prg"


** place q_clause and sbqun_expr in array 
** to avoid macro expansion limit of 255

dimension qx(8)
store '' to qx
qxc=q_clause
if len(q_clause) <= 255
 qx(1)=q_clause
else
 for qxx=1 to 8
  qx(qxx)=left(qxc,255)
  if len(qxc) <= 255
   exit
  endif 
  qxc=subs(qxc,256) 
 endfor
endif



dimension qu(8)
store '' to qu
quc=sbqun_expr
if len(sbqun_expr) <= 255
 qu(1)=sbqun_expr
else
 for uu=1 to 8
  qu(uu)=left(quc,255)
  if len(quc) <= 255
   exit
  endif 
  quc=subs(quc,256) 
 endfor
endif



do case
case sbq_un_bld      && building code for subquery or union
 if opt_type2='Subquery'
  pop key
  return '(Select '+q_clause+')'
 else   && Union
   pop key
   return 'Select '+q_clause
 endif 
case m_see           && viewing SQL code
* define window show_qbe from 4,2 to 23,77 color scheme 10
* activate wind show_qbe
* set memowidth to 70
* ?? 'Select '+q_clause+iif(empty(sbqun_expr),'',m_suff)+sbqun_expr
* wait window
* clear typeahead
* set memowidth to mmemowidth
* release window show_qbe

  define window show_qbe from 2,2 to 22,77 color scheme 10 ;
   close shadow  system ;
   title "< Query SQL Code >" footer " Press < Esc > when DONE "
  priv show_file
  show_file=sys(5)+curdir()+left(sys(2015),8)+'.TXT'
  set safety off
  SET TEXTMERGE TO (show_file) NOSHOW
  set textmerge on
  \\Select 
  \\<<q_clause+iif(empty(sbqun_expr),'',m_suff)+sbqun_expr>>
  set textmerge off
  set textmerge to
  modi file (show_file) noedit window show_qbe
  erase (show_file)
  release window show_qbe 
  set safety &m_safety
   

case proper(alltrim(m_qbe_put))= "Browse"
 on error m_sql_err=.t.
 set talk window
 set talk on
 set escape on
 on escape do QInterupt
 do showMess with 12,.t.,"Press < Esc > to Cancel"
  
 if q_xtab    && cross tab
  select &qx(1)&qx(2)&qx(3)&qx(4)&qx(5)&qx(6)&qx(7)&qx(8) ;
   into cursor sys(2015) ;
   &qu(1)&qu(2)&qu(3)&qu(4)&qu(5)&qu(6)&qu(7)&qu(8)
  do (xtab_prg) with 'Query'
 else
  select &qx(1)&qx(2)&qx(3)&qx(4)&qx(5)&qx(6)&qx(7)&qx(8) ;
   into cursor query ;
   &qu(1)&qu(2)&qu(3)&qu(4)&qu(5)&qu(6)&qu(7)&qu(8)
 endif
 
 set escape off
 on escape &OnEsc
 if wexist('ShowMess')
   release window ShowMess
 endif
 
 if m_sql_err
  set talk off
  if len(message()) < 68
   wait ' Error: '+message() window nowait
  else
   wait ' Error in Query. Query CANCELLED. ' window  nowait
  endif
  on error &old_error
  pop key
  select (m_area)
  return
 endif  
 on error &old_error
 
 m_area2=select(0)
 browse nomodify normal
 set talk off
 use in (m_area2)

case proper(alltrim(m_qbe_put))= "Printer"
 on error m_sql_err=.t.
 set talk window
 set talk on
 set escape on
 on escape do QInterupt
 do showMess with 12,.t.,"Press < Esc > to Cancel"
 
 if q_xtab    && cross tab
  select &qx(1)&qx(2)&qx(3)&qx(4)&qx(5)&qx(6)&qx(7)&qx(8) ;
   into cursor sys(2015) ;
   &qu(1)&qu(2)&qu(3)&qu(4)&qu(5)&qu(6)&qu(7)&qu(8)
  do (xtab_prg) with 'Query'
  LIST OFF TO PRINTER NOCONSOLE
  eject
 else
  select &qx(1)&qx(2)&qx(3)&qx(4)&qx(5)&qx(6)&qx(7)&qx(8) ;
   TO PRINTER NOCONSOLE ;
   &qu(1)&qu(2)&qu(3)&qu(4)&qu(5)&qu(6)&qu(7)&qu(8)
 endif 
 ** eject
 
 set escape off
 on escape &OnEsc
 if wexist('ShowMess')
   release window ShowMess
 endif
 
 if m_sql_err
  set talk off
  if len(message()) < 68
   wait ' Error: '+message() window nowait
  else
   wait ' Error in Query. Query CANCELLED. ' window  nowait
  endif
  on error &old_error 
  pop key
  select (m_area)
  return
 endif  
 on error &old_error 
 m_area2=select(0)
 set talk off
 if q_xtab
   use in (m_area2)
 endif  
   
case upper(alltrim(m_qbe_put))= "WORDPERFECT MERGE"
 
 if q_xtab    && cross tab
  wait 'Cross Tabulation not supported for WordPerfect Merge' window nowait
  pop key
  return

 else
  on error m_sql_err=.t.
  set talk window
  set talk on
  set escape on
  on escape do QInterupt
  do showMess with 12,.t.,"Press < Esc > to Cancel"

  select &qx(1)&qx(2)&qx(3)&qx(4)&qx(5)&qx(6)&qx(7)&qx(8) ;
   into cursor query ;
   &qu(1)&qu(2)&qu(3)&qu(4)&qu(5)&qu(6)&qu(7)&qu(8)
 endif
 
 set escape off
 on escape &OnEsc
 if wexist('ShowMess')
   release window ShowMess
 endif
  
 if m_sql_err
  set talk off
  if len(message()) < 68
   wait ' Error: '+message() window nowait
  else
   wait ' Error in Query. Query CANCELLED. ' window  nowait
  endif
  on error &old_error
  pop key
  select (m_area)
  return
 endif  
 on error &old_error
 dest_file=putfile('Enter name of Merge file... ','WP_Merge','TXT') 
 if ! empty(dest_file)
   if at('.',dest_file) > 0
    dest_file=left(dest_file,at('.',dest_file)-1)
   endif
   set safety on
   SET TEXTMERGE TO (dest_file) NOSHOW
   go top
   m_set_text=SET("TEXTMERGE")
   m_text_del=SET("TEXTMERGE",1)

   set textmerge on
   wait 'Writing '+dest_file+' merge file... ' window nowait
   set textmerge on
   scan
    for i=1 to fcount()
     xx=field(i)
     yy=&xx
     if type('yy')='C'
       yy=alltrim(yy)
     endif  
     \\<<yy>>
     \\<<chr(18)>>
    endfor 
    \\<<chr(5)>>
   endscan
   set textmerge off
   wait clear
 
   set safety &m_safety
   
   SET TEXTMERGE TO
   SET TEXTMERGE &m_set_text
   SET TEXTMERGE DELIMITERS TO &m_text_del

 endif && !empty(dest_file)
 m_area2=select(0)
 set talk off
 use in (m_area2)


case upper(alltrim(m_qbe_put))= "LOTUS 2.X"
 on error m_sql_err=.t.
 set talk window
 set talk on
 set escape on
 on escape do QInterupt
 do showMess with 12,.t.,"Press < Esc > to Cancel"
 
 if q_xtab    && cross tab
  select &qx(1)&qx(2)&qx(3)&qx(4)&qx(5)&qx(6)&qx(7)&qx(8) ;
   into cursor sys(2015) ;
   &qu(1)&qu(2)&qu(3)&qu(4)&qu(5)&qu(6)&qu(7)&qu(8)
  do (xtab_prg) with 'Query'
 else
  select &qx(1)&qx(2)&qx(3)&qx(4)&qx(5)&qx(6)&qx(7)&qx(8) ;
   into cursor query ;
   &qu(1)&qu(2)&qu(3)&qu(4)&qu(5)&qu(6)&qu(7)&qu(8)
 endif 

 set escape off
 on escape &OnEsc
 if wexist('ShowMess')
   release window ShowMess
 endif
 
 if m_sql_err
  set talk off
  if len(message()) < 68
   wait ' Error: '+message() window nowait
  else
   wait ' Error in Query. Query CANCELLED. ' window  nowait
  endif
  on error &old_error
  pop key
  select (m_area)
  return
 endif  
 on error &old_error
 dest_file=putfile('Enter Lotus file name... ','Q_Lotus','WK1') 
 if ! empty(dest_file)
   copy to (dest_file) type WK1
   set safety &m_safety
 endif && !empty(dest_file)
 m_area2=select(0)
 set talk off
 use in (m_area2)


case upper(alltrim(m_qbe_put))= "SYMPHONY 1.10"
 on error m_sql_err=.t.
 set talk window
 set talk on
 
 set escape on
 on escape do QInterupt
 do showMess with 12,.t.,"Press < Esc > to Cancel"
 
 if q_xtab    && cross tab
  select &qx(1)&qx(2)&qx(3)&qx(4)&qx(5)&qx(6)&qx(7)&qx(8) ;
   into cursor sys(2015) ;
   &qu(1)&qu(2)&qu(3)&qu(4)&qu(5)&qu(6)&qu(7)&qu(8)
  do (xtab_prg) with 'Query'
 else
  select &qx(1)&qx(2)&qx(3)&qx(4)&qx(5)&qx(6)&qx(7)&qx(8) ;
   into cursor query ;
   &qu(1)&qu(2)&qu(3)&qu(4)&qu(5)&qu(6)&qu(7)&qu(8)
 endif
 
 set escape off
 on escape &OnEsc
  if wexist('ShowMess')
   release window ShowMess
 endif

 if m_sql_err
  set talk off
  if len(message()) < 68
   wait ' Error: '+message() window nowait
  else
   wait ' Error in Query. Query CANCELLED. ' window  nowait
  endif
  on error &old_error
  pop key
  select (m_area)
  return
 endif  
 on error &old_error
 dest_file=putfile('Enter Symphony file name... ','QBE_Symp','WR1') 
 if ! empty(dest_file)
   copy to (dest_file) type WR1
   set safety &m_safety
 endif && !empty(dest_file)
 m_area2=select(0)
 set talk off
 use in (m_area2)

case upper(alltrim(m_qbe_put))= "FILE"
 dest_file=putfile('Enter File name... ','Query','TXT') 
 if empty(dest_file)
   pop key
   return
 endif && !empty(dest_file)

 on error m_sql_err=.t.
 set talk window
 set talk on
 set escape on
 on escape do QInterupt
 do showMess with 12,.t.,"Press < Esc > to Cancel"
 
 if q_xtab    && cross tab
  select &qx(1)&qx(2)&qx(3)&qx(4)&qx(5)&qx(6)&qx(7)&qx(8) ;
   into cursor sys(2015) ;
   &qu(1)&qu(2)&qu(3)&qu(4)&qu(5)&qu(6)&qu(7)&qu(8)
  do (xtab_prg) with 'Query'
  list to FILE &dest_file NOCONSOLE
 else
  select &qx(1)&qx(2)&qx(3)&qx(4)&qx(5)&qx(6)&qx(7)&qx(8) ;
   to FILE &dest_file NOCONSOLE ;
   &qu(1)&qu(2)&qu(3)&qu(4)&qu(5)&qu(6)&qu(7)&qu(8)
 endif
 
 set escape off
 on escape &OnEsc
 if wexist('ShowMess')
   release window ShowMess
 endif

 if m_sql_err
  set talk off
  if len(message()) < 68
   wait ' Error: '+message() window nowait
  else
   wait ' Error in Query. Query CANCELLED. ' window  nowait
  endif
  on error &old_error
  pop key
  select (m_area)
  return
 endif  
 on error &old_error
 set talk off
 m_area2=select(0)
 modi comm (dest_file) noedit in window qbe
 if q_xtab
   use in (m_area2)
 endif  
case upper(alltrim(m_qbe_put))= "DATABASE/TABLE"
 choice='Yes'
 if file(sys(5)+curdir()+'Q_QUERY.DBF')
   choice=yes_no(sys(5)+curdir()+'Q_QUERY.DBF already exist. Overwrite it?',;
   7,1,16,78,.f.)
 endif
 if choice='No'
  pop key
  return
 endif
 on error m_sql_err=.t.
 set talk window
 set talk on
 set safety off 
 set escape on
 on escape do QInterupt
 do showMess with 12,.t.,"Press < Esc > to Cancel"

 q_table=sys(2015)
 if q_xtab    && cross tab
  select &qx(1)&qx(2)&qx(3)&qx(4)&qx(5)&qx(6)&qx(7)&qx(8) ;
   into table (q_table) ;
   &qu(1)&qu(2)&qu(3)&qu(4)&qu(5)&qu(6)&qu(7)&qu(8)
  do (xtab_prg) with 'Q_Query'
  
  q_table=left(q_table,8)

 else
  select &qx(1)&qx(2)&qx(3)&qx(4)&qx(5)&qx(6)&qx(7)&qx(8) ;
   into table q_query.dbf ;
   &qu(1)&qu(2)&qu(3)&qu(4)&qu(5)&qu(6)&qu(7)&qu(8)
 endif
 set safety &m_safety

 set escape off
 on escape &OnEsc
 if wexist('ShowMess')
   release window ShowMess
 endif
 
 if m_sql_err
  set talk off
  if len(message()) < 68
   wait ' Error: '+message() window nowait
  else
   wait ' Error in Query. Query CANCELLED. ' window  nowait
  endif
  on error &old_error
  pop key
  if file(q_table+'.DBF') 
    erase (q_table+'.DBF')
  endif
  select (m_area)
  return
 endif  
 on error &old_error
 
 m_area2=select(0)
 browse nomodify normal
 set talk off
 use in (m_area2)
 if used(q_table)
  use in q_table
 endif 
 if file(q_table+'.DBF') 
   erase (q_table+'.DBF')
 endif
 if file(q_table+'.FPT') 
   erase (q_table+'.FPT')
 endif
 


case proper(alltrim(m_qbe_put))= "Report"
 on error m_sql_err=.t.
 set talk window
 set talk on
 set escape on
 on escape do QInterupt
 do showMess with 12,.t.,"Press < Esc > to Cancel"
 
 if q_xtab    && cross tab
  select &qx(1)&qx(2)&qx(3)&qx(4)&qx(5)&qx(6)&qx(7)&qx(8) ;
   into cursor sys(2015) ;
   &qu(1)&qu(2)&qu(3)&qu(4)&qu(5)&qu(6)&qu(7)&qu(8)
  do (xtab_prg) with 'Query'
 else
  select &qx(1)&qx(2)&qx(3)&qx(4)&qx(5)&qx(6)&qx(7)&qx(8) ;
   into cursor query ;
   &qu(1)&qu(2)&qu(3)&qu(4)&qu(5)&qu(6)&qu(7)&qu(8)
 endif
 
 set escape off
 on escape &OnEsc
 if wexist('ShowMess')
   release window ShowMess
 endif

 if m_sql_err
  set talk off
  if len(message()) < 68
   wait ' Error: '+message() window nowait
  else
   wait ' Error in Query. Query CANCELLED. ' window  nowait
  endif
  on error &old_error
  pop key
  select (m_area)
  return
 endif  
 on error &old_error

 m_area2=select(0)
 priv RdClear
 RdClear=.f.
 do whil ! RdClear
   RdClear=.t.     && set to false if QBE_REPO.SPR calls Printer Setup
   do qbe_repo.spr && to reduce read levels 
 enddo  

 set talk off
 use in (m_area2)

endcase
release q_dbfs
pop key
set talk nowindow
select (m_area)
return



procedure QInterupt

set talk off
on error &old_error
set escape off
on escape &OnEsc
if wexist('ShowMess')
  release window ShowMess
endif
pop key
pop key
wait window nowait "Query interrupted"
return to QBE.SPR





procedure strip_char
parameters m_string
** remove characters not allowed in AS clause of SQL-SELECT
priv m_string,s_len,i

** make sure starts with letter A-Z
m_string=alltrim(m_string)
if ! isalpha(m_string) or empty(m_string)
 m_string=''
 return m_string
endif


if at('(',m_string) > 0 and at(')',m_string) > 0

 do case
  case at('.',m_string) > 0 and at('(DISTINCT ',upper(m_string)) > 0
   m_string=left(m_string,at('(',m_string)+4) +'_'+ subs(m_string,at('.',m_string)+1) 
 case at('.',m_string) > 0
   m_string=left(m_string,at('(',m_string)) + subs(m_string,at('.',m_string)+1) 
 endcase

 m_string=strtran(m_string,'(DISTINCT ','(Dist ')
 m_string=strtran(m_string,'COUNT(','Cnt(')
 m_string=strtran(m_string,'*','ALL')
* m_string=strtran(m_string,')','')
endif
m_string=strtran(m_string,')','')
m_string=strtran(m_string,'(','_')
m_string=strtran(m_string,' ','_')
m_string=strtran(m_string,'/','_')


s_len=len(m_string)
** truncate when find unacceptable characters
for i=2 to s_len
  if ! isalpha(subs(m_string,i,1)) and ! isdigit(subs(m_string,i,1)) ;
    and '_' <> subs(m_string,i,1)
    m_string=subs(m_string,1,i-1)
  endif
endfor
return m_string




procedure yes_no
parameters yn_mess,wrw1,wcl1,wrw2,wcl2,def_ans
priv yn_mess,wrw,wcl,wrw2,wcl2,def_ans,ret_val,mchoice,prompt_row,prompt_col ,row_diff
* assumes all parameters are passed correctly
* def_ans is the default setting to yes or no. .t.=yes

CLEAR TYPEAHEAD

ret_val=''
prompt_row=5
row_diff=3
define window yes_no from wrw1,wcl1 to wrw2,wcl2 double shadow ;
       color scheme 7
activate window yes_no top
do case
case wcols() < 18
   wait 'Window must be at least 18 columns wide. Press any key... ' window 
   clear typeahead
   release window yes_no
   return 'No'
case wcols() < len(yn_mess)
   wait 'Message too long for window width. Press any key... ' window 
   clear typeahead
   release window yes_no
   return 'No'
case wrows() < 2
   wait 'Window too short. Must be at least 4 rows. Press any key... ' window 
   clear typeahead
   release window yes_no
   return 'No'
case wrows() < 4   
  prompt_row= 0
  row_diff=1   
case wrows() <  6
  prompt_row= 1
  row_diff=2   
otherwise
  store round(wrows()/3,0) to prompt_row,row_diff
endcase

@ prompt_row,0 say padc(yn_mess,wcols())

prompt_col=int((wcols()-18)/2)

if def_ans
	@ prompt_row+row_diff,prompt_col GET mchoice FUNCTION '*H \!\<Yes;\<No' ;
 		DEFAULT 'Yes' SIZE 1,8,2 color scheme 7
   READ CYCLE MODAL OBJECT 1
else
	@ prompt_row+row_diff,prompt_col GET mchoice FUNCTION '*H \<Yes;\!\<No' ;
 		DEFAULT 'No' SIZE 1,8,2 color scheme 7
   READ CYCLE MODAL OBJECT 2
endif

do case
case mchoice='Yes'
  ret_val='Yes'
case mchoice='No'
  ret_val='No'
endcase

release window yes_no
return ret_val

  


** used to save/restore query values to/from mem file
procedure sav_mem
parameters m_save,su_build
priv m_save,qqqqaf,qqqqao,qqqqag,qqqq,qqqqn
priv qqqqof,qqqqgf,qqqqf,qqqqo,qqqqg,qqqqoptf,;
   qqqqoptc,qqqqoptu,qqqqoptq,su_build
priv qqqqoptao,m_safety

m_safety = set('SAFETY') 

if m_save
 priv qqqq
 dime qqqq(35)
 qqqq(1)=no_dupes
 qqqq(2)=w_expr
 qqqq(3)=m_qbe_put
 qqqq(4)=_PDSETUP
 qqqq(5)=f_select
 qqqq(6)=f_arrange
 qqqq(7)=m_cancel
 qqqq(8)=o_select
 qqqq(9)=o_arrange
 qqqq(10)=m_alen
 qqqq(11)=g_select
 qqqq(12)=g_arrange
 qqqq(13)=o_order
 qqqq(14)=n_choice
 qqqq(15)=r_expr
 qqqq(16)=r_ex_name
 qqqq(17)=g_expr
 qqqq(18)=g_ex_name
 qqqq(19)=r_filter
 qqqq(20)=g_filter
 qqqq(21)=m_function
 qqqq(22)=w_ex_name
 qqqq(23)=opt_type
 qqqq(24)=m_qbe_opt
 qqqq(25)=q_xtab
 qqqq(26)=m_AS
 qqqq(27)=exprchoice
 qqqq(28)=qr_plain
 qqqq(29)=qr_summary
 qqqq(30)=qr_pdsetup
 qqqq(31)=qr_eject
 qqqq(32)=qr_format
 qqqq(33)=qr_width
 qqqq(34)=qr_heading
 qqqq(35)=mAutoJoin
 
 =acopy(fchoice,qqqqf)
 =acopy(ochoice,qqqqo)
 =acopy(gchoice,qqqqg)
 =acopy(nchoice,qqqqn)
 
 =acopy(opt_f,qqqqoptf)
 =acopy(opt_c,qqqqoptc)
 =acopy(opt_u,qqqqoptu)
 =acopy(opt_q,qqqqoptq)
 =acopy(opt_ao,qqqqoptao)

cnt_bar=cntbar('f_flds')
if cnt_bar > 0
  dimension qqqqaf(cnt_bar)
  for i=1 to cnt_bar
    store PRMBAR('f_flds',getbar('f_flds',i)) to qqqqaf(i)
  endfor
endif  


cnt_bar=cntbar('o_flds')
if cnt_bar > 0
  dimension qqqqao(cnt_bar)
  for i=1 to cnt_bar
    store PRMBAR('o_flds',getbar('o_flds',i)) to qqqqao(i)
  endfor
endif  

cnt_bar=cntbar('g_flds')
if cnt_bar > 0
  dimension qqqqag(cnt_bar)
  for i=1 to cnt_bar
    store PRMBAR('g_flds',getbar('g_flds',i)) to qqqqag(i)
  endfor
endif  

if ! empty(su_build)
 save all like qqqq* to (su_build)
else 
 save all like qqqq* to memo save_mem
 ** save report file if query output to report
 if file(sys(5)+curdir()+'Q_QUERY.FRX') and ;
    file(sys(5)+curdir()+'Q_QUERY.FRT') and ;
    m_qbe_put = 'Report'
   
   append memo save_frx from Q_QUERY.FRX overwrite
   append memo save_frt from Q_QUERY.FRT overwrite
 
 endif

endif 


 release qqqq,qqqqaf,qqqqof,qqqqgf,qqqqf,qqqqo,qqqqg,qqqqoptf,;
   qqqqoptc,qqqqoptu,qqqqoptq,qqqqoptao
    

else
 if ! empty(su_build)
  restore from (su_build) additive
 else 
  restore from memo save_mem additive
  ** restore saved report file if exists
  if ! empty(save_frx) and ! empty(save_frt)
    set safety off
    copy memo save_frx to Q_QUERY.FRX 
    copy memo save_frt to Q_QUERY.FRT
    set safety &m_safety
  endif  
 endif 
 no_dupes=qqqq(1)
 w_expr=qqqq(2)
 m_qbe_put=qqqq(3)
 _PDSETUP=qqqq(4)
 f_select=qqqq(5)
 f_arrange=qqqq(6)
 m_cancel=qqqq(7)
 o_select=qqqq(8)
 o_arrange=qqqq(9)
 m_alen=qqqq(10)
 g_select=qqqq(11)
 g_arrange=qqqq(12)
 o_order=qqqq(13)
 n_choice=qqqq(14)
 r_expr=qqqq(15)
 r_ex_name=qqqq(16)
 g_expr=qqqq(17)
 g_ex_name=qqqq(18)
 r_filter=qqqq(19)
 g_filter=qqqq(20)
 m_function=qqqq(21)
 w_ex_name=qqqq(22)
 opt_type=qqqq(23)
 m_qbe_opt=qqqq(24)
 q_xtab=qqqq(25)
 m_AS=qqqq(26)
 exprchoice=qqqq(27)
 qr_plain=qqqq(28)
 qr_summary=qqqq(29)
 qr_pdsetup=qqqq(30)
 qr_eject=qqqq(31)
 qr_format=qqqq(32)
 qr_width=qqqq(33)
 qr_heading=qqqq(34)
 mAutoJoin=qqqq(35)
 
 dimension fchoice(alen(qqqqf,1),5)
 dimension ochoice(alen(qqqqo,1),5)
 dimension gchoice(alen(qqqqg,1),5)
 dimension nchoice(alen(qqqqn,1),5)

 =acopy(qqqqf,fchoice)
 =acopy(qqqqo,ochoice)
 =acopy(qqqqg,gchoice)
 =acopy(qqqqn,nchoice)
 
 dimension opt_f(4)
 dimension opt_c(4)
 dimension opt_u(4)
 dimension opt_q(4)
 dimension opt_ao(4)

 =acopy(qqqqoptf,opt_f)
 =acopy(qqqqoptc,opt_c)
 =acopy(qqqqoptu,opt_u)
 =acopy(qqqqoptq,opt_q)
 =acopy(qqqqoptao,opt_ao)

 release bar all of F_FLDS
 release bar all of O_FLDS
 release bar all of G_FLDS
 release bar all of F_FLIST
 release bar all of O_FLIST
 release bar all of G_FLIST
 release bar all of n_flist

** redefine popups from restored arrays

if ! type('qqqqaf(1)')='U'
 for i=1 to alen(qqqqaf)
   DEFINE BAR i OF f_flds PROMPT qqqqaf(i);
  	 COLOR SCHEME 9
 endfor
endif

 
if ! type('qqqqao(1)')='U'
 for i=1 to alen(qqqqao)
   DEFINE BAR i OF o_flds PROMPT qqqqao(i);
  	 COLOR SCHEME 9
 endfor
endif
 
if ! type('qqqqag(1)')='U'
 for i=1 to alen(qqqqag)
   DEFINE BAR i OF g_flds PROMPT qqqqag(i);
  	 COLOR SCHEME 9
 endfor
endif 

for i=1 to alen(fchoice,1)
   DEFINE BAR i OF f_flist PROMPT fchoice(i,1);
  	 COLOR SCHEME 4
   if fchoice(i,4)
     set mark of bar i of f_flist .t.
     SET SKIP OF BAR i OF f_flist .t.
   endif
endfor

for i=1 to alen(ochoice,1)
   DEFINE BAR i OF o_flist PROMPT ''+ochoice(i,1);
    COLOR SCHEME 4
   if ochoice(i,4)
     set mark of bar i of o_flist .t.
     SET SKIP OF BAR i OF o_flist .t.
   endif
endfor

for i=1 to alen(gchoice,1)
   DEFINE BAR i OF g_flist PROMPT gchoice(i,1);
   COLOR SCHEME 4
   if gchoice(i,4)
     set mark of bar i of g_flist .t.
     SET SKIP OF BAR i OF g_flist .t.
   endif
endfor


for i=1 to alen(nchoice,1)
 DEFINE BAR i OF n_flist PROMPT nchoice(i,1);
	COLOR SCHEME 4
endfor


endif 





** used to load DBFs if QBE run without Custom Picklist

Procedure loadarray
priv m_dir,m_dbfs,a_len,old_default,m_stop,which_dbf

dimension which_dbf(25)
store '' to which_dbf

old_default=sys(5)+sys(2003)
push key clear
do set_func

m_stop=.f.

define window show_list from 2,8 to 21,72 double shadow
activate window show_list

priv mess_color
mess_color=scheme(1,4)
do whil ! m_stop
clear
@ 0,0 say padc('Press <F10>/Mouse when DONE selecting Databases for Query.',wcols())  color &mess_color

** load subdirectories of current dir
=ADIR(m_dir2,'','D')  
** load DBFs in current dir
=ADIR(m_dbfs,'*.DBF')

if type('m_dir2(1,1)')='U' and type('m_dbfs(1,1)')='U'
 release window show_list
 wait 'No databases available for Query. Press any key... ' window 
 exit 
endif

** list current drive directory at top of popup

if empty(subs(sys(5)+sys(2003),at('\',sys(5)+sys(2003))+1))
 @ 2,0 say padc(sys(5)+sys(2003),wcols())
else
 @ 2,0 say padc(sys(5)+sys(2003)+'\',wcols())
endif


if ! type('m_dbfs(1,1)')='U'
 =asort(m_dbfs)
endif 

if ! type('m_dir2(1,1)')='U'    && not root DIRECTORY without subdirectories
 release m_dir_dbfs
 =asort(m_dir2)
 ** remove "." from directories
 x=1
 if m_dir2(1,1)='.'
  dimension m_dir(alen(m_dir2,1)-1,5)
  for i=2 to alen(m_dir2,1)
    m_dir(x,1)=m_dir2(i,1)
    m_dir(x,2)=m_dir2(i,2)
    m_dir(x,3)=m_dir2(i,3)
    m_dir(x,4)=m_dir2(i,4)
    m_dir(x,5)=m_dir2(i,5)
    x=x+1
  endfor
 else
  =acopy(m_dir2,m_dir)
 endif
 release m_dir2

 m_len1=iif(! type('m_dir(1,1)')='U',alen(m_dir,1),0)
 m_len2=iif(! type('m_dbfs(1,1)')='U',alen(m_dbfs,1),0)
 a_len=m_len1+m_len2

 ** there's at least 1 subdirectory or DBF file listed in 
 ** current directory
 if a_len > 0
 dimension m_dir_dbfs(a_len,5)
   if m_len1 > 0
     for n=1 to m_len1
        m_dir_dbfs(n,1)='['+m_dir(n,1)+']'
        m_dir_dbfs(n,2)=m_dir(n,2)  
        m_dir_dbfs(n,3)=m_dir(n,3)  
        m_dir_dbfs(n,4)=m_dir(n,4)  
        m_dir_dbfs(n,5)=m_dir(n,5)  
     endfor
   endif
   if m_len2 > 0
     for n=1 to m_len2
        m_dir_dbfs(n+m_len1,1)=m_dbfs(n,1)  
        m_dir_dbfs(n+m_len1,2)=m_dbfs(n,2)  
        m_dir_dbfs(n+m_len1,3)=m_dbfs(n,3)  
        m_dir_dbfs(n+m_len1,4)=m_dbfs(n,4)  
        m_dir_dbfs(n+m_len1,5)=m_dbfs(n,5)  
     endfor
   endif
  endif a_len > 0

else  && type('m_dir2(1,1)')='U' && in the root directory
 
 a_len=alen(m_dbfs,1)

 =acopy(m_dbfs,m_dir_dbfs)

endif   && ! type('m_dir2(1,1)')='U'

 
 ** define popup listing directories or DBFs
 DEFINE POPUP dbf_list;
 	FROM 3, 15 TO 16, 47;
 	in window show_list;
	FOOTER ' < Shift-Space >- Select ' MARGIN;
	MULTISELECT MARK '';
	SCROLL SHADOW;
	TITLE ' Select Database File(s) ';
	COLOR SCHEME 4


 
 for i=1 to a_len
  DEFINE BAR i OF dbf_list PROMPT m_dir_dbfs(i,1);
	COLOR SCHEME 4
 endfor

 on key label F10 do esc_list
 on key label rightmouse do esc_list
 on selection popup dbf_list do dbf_pick
 activate popup dbf_list
 on key label F10 
 on key label rightmouse 
 release popup dbf_list
 release m_dir,m_dir2,m_dbfs
enddo
pop key
if wexist('show_list')
 release window show_list
endif 

set default to &old_default




** if directory selected remove [] and set default
procedure dbf_pick
priv mprompt
mprompt=prompt()
if at('[',mprompt) > 0
 mprompt=subs(mprompt,at('[',mprompt)+1)
 mprompt=left(mprompt,at(']',mprompt)-1)
 set default to &mprompt
 deac popup
endif


** when DBF picklist exited, create picklist from selected DBFs
procedure esc_list
priv m_alias,fchoice2
m_stop=.t.
store '' to which_dbf
x=1
for n=1 to cntbar('dbf_list')
 if x > 25   && maximum size of which_dbf()
   exit
 endif
 if mrkbar('dbf_list',n)      
   store prmbar('dbf_list',n) to which_dbf(x)
   x=x+1
 endif 
endfor

for n=1 to 25
 if empty(which_dbf(n))
   exit
 endif
 m_alias=left(which_dbf(n),at('.',which_dbf(n))-1)
 
 
 if n=9
  wait 'Maximun of EIGHT databases may be selected' window nowait
  exit 
 endif
 
 
 if used(m_alias)
  select (m_alias)
  =afields(dbf_stru)
 else
  select 0
  use (m_alias) AGAIN
  =afields(dbf_stru)
 endif  
 
 L1=alen(dbf_stru,1)
 L2=iif(type('fchoice2(1,1)')='U',0,alen(fchoice2,1))
 L3=L2+1  && starting position in array
 L4=L1+l2 && ending position in array  
 dimension fchoice2(L4,5)
 for i=0 to L1-1
  fchoice2(L3+i,1)=proper(alltrim(m_alias))+'_'+proper(dbf_stru(i+1,1))
  fchoice2(L3+i,2)=upper(alltrim(m_alias))+'.'+upper(dbf_stru(i+1,1))
  fchoice2(L3+i,3)=dbf_stru(i+1,2)
  fchoice2(L3+i,4)=.f.
  fchoice2(L3+i,5)=.t.
 endfor

 release dbf_stru

endfor

if ! empty(which_dbf(1))
 dimension QZQZQZQZQZ(alen(fchoice2,1),5)  
 =acopy(fchoice2,QZQZQZQZQZ)
endif
deac popup





** initialize new QBE variables,arrays,popups
procedure new_qbe
m.qbe_name=''
store .f. to r_filter,g_filter,no_dupes
store '' to r_expr,r_ex_name,g_expr,g_ex_name,w_expr,w_ex_name
m_distinct=.f.    
m_function=space(254)
m_put_func=1
_PDSETUP=old_PDSET
store 1 to f_select,f_arrange,o_select,o_arrange,m_cancel,g_select,g_arrange,o_order,n_choice
 
m_qbe_put='Browse'
mAutoJoin=iif(empty(JoinPrg) and ! BldJoin,.f.,.t.)
m_AS = iif(empty(q_file),.f.,.t.)      && .t. = include AS clause

store '' to opt_type      && Subquery or Union
m_qbe_opt=.f.
dimension opt_f(4)
dimension opt_c(4)
dimension opt_u(4)
dimension opt_q(4)

store '' to opt_f,opt_c,opt_u,opt_q

dimension fchoice(alen(newchoice,1),5)
dimension ochoice(alen(newchoice,1),5)
dimension gchoice(alen(newchoice,1),5)

= ACOPY(newchoice,fchoice)     
m_alen=alen(fchoice,1)

= ACOPY(fchoice, ochoice)     
= ACOPY(fchoice, gchoice)

** initialize function field picklist
dimension nchoice(1+alen(fchoice,1),5)

store '*' to nchoice(1,1),nchoice(1,2),nchoice(1,3)
store .f. to nchoice(1,4)
store .t. to nchoice(1,5)

= ACOPY(fchoice, nchoice,1,alen(fchoice),6)

release bar all of F_FLDS
release bar all of O_FLDS
release bar all of G_FLDS
release bar all of F_FLIST
release bar all of O_FLIST
release bar all of G_FLIST
release bar all of N_FLIST 

for n=1 to m_alen
 
 DEFINE BAR n OF f_flist PROMPT fchoice(n,1);
	COLOR SCHEME 4
 DEFINE BAR n OF o_flist PROMPT ''+ochoice(n,1);
	COLOR SCHEME 4
 DEFINE BAR n OF g_flist PROMPT gchoice(n,1);
	COLOR SCHEME 4

endfor

for n=1 to alen(nchoice,1)
 DEFINE BAR n OF n_flist PROMPT nchoice(n,1);
	COLOR SCHEME 4
endfor

** initialize report variables
store .f. to ;
 m.qr_plain,m.qr_summary,m.qr_o_write,m.qr_pdsetup,m.qr_eject,qr_modify
m.qr_format='Column'
m.qr_dest='Preview'
m.qr_width=80
m.qr_heading=space(200)
m.qr_done='Ok'





** code for options screen
** used for NEW query,Subquery,Unions
procedure q_options
*** m_qbe_opt
priv m.currarea
m.currarea = SELECT()
priv m_comp,mcompare,m_subunion,sub_union,opt_fields,optfields,opt_done,m_options
priv m_optquery,optqueries,m_opt_num,m_and_or

store 1 to opt_done,opt_fields,m_subunion,m_comp,m_options,m_optquery,m_opt_num,m_and_or

push key clear
do set_func
on key label F1 help

dimension optfields(alen(fchoice,1)+1,2)
store ' ' to optfields(1,1),optfields(1,2)
for i=1 to alen(fchoice,1)
 optfields(i+1,1) = fchoice(i,1)
 optfields(i+1,2) = fchoice(i,2)
endfor

dimension  mcompare(8)
store padc(' ',10) to mcompare(1)
store padc('=',10) to mcompare(2)
store padc('#',10) to mcompare(3)
store padc('==',10) to mcompare(4)
store padc('>',10) to mcompare(5)
store padc('>=',10) to mcompare(6)
store padc('<',10) to mcompare(7)
store padc('<=',10) to mcompare(8)

dimension sub_union(7)
store padc(' ',12) to sub_union(1)
store padc('ALL',12) to sub_union(2)
store padc('ANY',12) to sub_union(3)
store padc('IN',12) to sub_union(4)
store padc('NOT IN',12) to sub_union(5)
store padc('EXISTS',12) to sub_union(6)
store padc('NOT EXISTS',12) to sub_union(7)


** create array for popup of existing queries
priv temp
if file('QBE_SAVE.DBF')
 if empty(q_file)
  select qbe_name from qbe_save;
  where empty(qbe_file);
  into array temp
 else
  select qbe_name from qbe_save;
  where upper(alltrim(qbe_file))== upper(alltrim(q_file));
  into array temp
 endif
 if used('QBE_SAVE')
   use in qbe_save
 endif
endif

if ! type('temp(1,1)')='U'           && no existing queries
  dimension optqueries(alen(temp,1)+1)
  store space(30) to optqueries(1)
  for i=1 to alen(temp,1)
   optqueries(i+1) = temp(i)
  endfor
  release temp
else
   dimension optqueries(1)
  store space(30) to optqueries(1)
endif

m_options=iif(opt_type='Subquery',2,iif(opt_type='Union',3,1))
opt_fields=iif(ascan(optfields,opt_f(1))=0,1,;
   asubscript(optfields,ascan(optfields,opt_f(1)),1))
m_comp=iif(ascan(mcompare,opt_c(1))=0,1,ascan(mcompare,opt_c(1)))
m_subunion=iif(ascan(sub_union,opt_u(1))=0,1,ascan(sub_union,opt_u(1)))
m_optquery=iif(ascan(optqueries,opt_q(1))=0,1,ascan(optqueries,opt_q(1)))



** paint options screen

DEFINE WINDOW q_options ;
		FROM INT((SROW()-19)/2),INT((SCOL()-77)/2) ;
		TO INT((SROW()-19)/2)+19,INT((SCOL()-77)/2)+76 ;
		TITLE "< Options >" ;
		NOFLOAT ;
		NOCLOSE ;
		SHADOW ;
		DOUBLE ;
		COLOR SCHEME 8

ACTIVATE WINDOW q_options 
@ 1,51 SAY "Options:"
@ 2,50 GET m_options ;
	PICTURE "@^ New Query;Subquery;Union" ;
	VALID opt_show () ;
	SIZE 3,13 ;
	DEFAULT "New Query" ;
	COLOR SCHEME 1, 2

@ 3,64 say "No."
@ 2,67 GET m_opt_num ;
	PICTURE "@^ 1;2;3;4" ;
    VALID num_val() ;
	SIZE 3,5 ;
	DEFAULT 1 ;
	DISABLE


@ 6,52 GET m_and_or ;
    PICTURE "@*RH \<AND;\<OR" ;
	SIZE 1,8,2 ;
	DEFAULT 1 ;
	DISABLE


@ 1,5 SAY "Field:"
@ 2,4 GET opt_fields ;
	PICTURE "@^" ;
	FROM optfields ;
	VALID opt_f_val() ;
	SIZE 3,33 ;
	DEFAULT 1 ;
	DISABLE


@ 7,4 SAY "Comparison:"
@ 8,4 GET m_comp ;
	PICTURE "@^" ;
	FROM mcompare ;
	VALID opt_c_val() ;
	SIZE 3,12 ;
	DEFAULT 1 ;
    DISABLE
    
@ 6,20 SAY "Subquery/Union"
@ 7,20 SAY "Operator:"
@ 8,20 GET m_subunion ;
	PICTURE "@^" ;
	FROM sub_union ;
	VALID opt_u_val() ;
	SIZE 3,17 ;
	DEFAULT 1 ;
	DISABLE

@ 13,4 SAY "Subquery/Union:"
@ 14,4 GET m_optquery ;
	PICTURE "@^" ;
	FROM optqueries ;
	SIZE 3,34 ;
	DEFAULT 1 ;
	DISABLE

@ 8,49 GET opt_done ;
	PICTURE "@*VN \<Done;\?\<Cancel; \<Save Subquery/Union " ;
	VALID val_done() ;
	SIZE 1,23,1 ;
	DEFAULT 1

@ 14,46 say 'Filter expression builder:'
@ 15,48 get exprChoice  ; 
    picture '@*RH Si\<mple;\<FoxPro'

@ 16,42 get mAutoJoin ;
    PICTURE '@*C Automatic \<JOIN condition' ;
    DISABLE

@ 17,42 get m_AS ;
    PICTURE '@*C \<Include "AS" clause in Query' ;
    DISABLE

@ 0,46 TO 13,73


READ CYCLE MODAL when opt_show() 

RELEASE WINDOW q_options
SELECT (m.currarea)
pop key




procedure val_done
priv choice
choice='No'

do case
case opt_done=2   && cancel
 clear read
 m_qbe_opt=.f.
 do case
 case m_options=1   && new query
  if ! empty(opt_type)
   m_qbe_opt=.t.
  endif 
  return
 case opt_type='Subquery' 
   choice=yes_no('Cancel Subqueries?',5,15,15,65,.f.)
   if choice='Yes'
     opt_type=''
     for i=1 to 4
      store '' to opt_f(i),opt_c(i),opt_u(i),opt_q(i)
      store 'AND' to opt_ao(i)     
     endfor
   else
     m_qbe_opt=.t.
   endif

 case opt_type='Union' 
   choice=yes_no('Cancel Unions?',5,15,15,65,.f.)
   if choice='Yes'
     opt_type=''
     for i=1 to 4
      store '' to opt_f(i),opt_c(i),opt_u(i),opt_q(i)
      store 'AND' to opt_ao(i)     
     endfor
   else
     m_qbe_opt=.t.
   endif

 endcase
case opt_done=1           && done
 clear read
 do case
 case m_options=1  &&   "New Query"
   choice=yes_no('Create NEW query?',5,20,15,55,.t.)
   if choice='No'
    m_qbe_opt=.f.
    return 0
   else
    if cntbar('F_FLDS') > 0 
     choice=yes_no('Save current query?',5,20,15,55,.t.)
     if choice='Yes'
       do qbe_save.spr with .t.
     endif
    endif
    do new_qbe
    m_qbe_opt=.f.
    return .t.
   endif 
   case m_options=2  &&   "Subquery" 
    store 'Subquery' to opt_type      && Subquery or Union
    store  optfields(opt_fields,2) to opt_f(m_opt_num)
    store  mcompare(m_comp) to opt_c(m_opt_num)
    store  sub_union(m_subunion) to opt_u(m_opt_num)
    store  optqueries(m_optquery) to opt_q(m_opt_num)
    store  iif(m_and_or=2,'OR','AND') to opt_ao(m_opt_num)     
    m_qbe_opt=.t.
   case m_options=3  &&   "Union" 
    store 'Union' to opt_type      && Subquery or Union
    
    store  optfields(opt_fields,2) to opt_f(m_opt_num)
    store  mcompare(m_comp) to opt_c(m_opt_num)
    store  sub_union(m_subunion) to opt_u(m_opt_num)
    store  optqueries(m_optquery) to opt_q(m_opt_num)
    store  iif(m_and_or=2,'OR','AND') to opt_ao(m_opt_num)     
    m_qbe_opt=.t.
  endcase
case opt_done=3   && Save
  do case
   case m_options=1  &&   "New Query"  
    return
   case m_options=2  &&   "Subquery" 
    store 'Subquery' to opt_type      && Subquery 
   case m_options=3  &&   "Union" 
    store 'Union' to opt_type      && Subquery or Union
  endcase         
  store  optfields(opt_fields,2) to opt_f(m_opt_num)
  store  mcompare(m_comp) to opt_c(m_opt_num)
  store  sub_union(m_subunion) to opt_u(m_opt_num)
  store  optqueries(m_optquery) to opt_q(m_opt_num)
  store  iif(m_and_or=2,'OR','AND') to opt_ao(m_opt_num)     
endcase





** enable/disable valid/invalid popup options

procedure opt_show 


store padc(' ',12) to sub_union(1)
store padc('ALL',12) to sub_union(2)
store padc('ANY',12) to sub_union(3)
store padc('IN',12) to sub_union(4)
store padc('NOT IN',12) to sub_union(5)
store padc('EXISTS',12) to sub_union(6)
store padc('NOT EXISTS',12) to sub_union(7)
if empty(opt_type)
  store 1 to m_subunion,m_comp,opt_fields
endif  

show gets enable
if empty(q_file)
 show get m_AS disable
endif
if empty(JoinPrg) and ! BldJoin     && no automatic Join
  show get mAutoJoin DISABLE
else
  show get mAutoJoin ENABLE
endif    

do case
case m_options=1  &&   "New Query"
 m_optquery=0
 show get m_optquery disable
 show get m_subunion disable
 show get m_comp disable  
 show get opt_fields disable
 show get m_opt_num disable
 show get m_and_or disable
 show get opt_done,3 disable

case m_options=3  &&   "Union"
 if alen(optqueries) = 1 && no queries saved
  wait "Can't do UNION without Saved Queries." window nowait
  m_options=1
  show get m_optquery disable
  show get m_subunion disable
  show get m_comp disable  
  show get opt_fields disable
  show get m_opt_num disable
  show get m_and_or disable
  show get m_options
  show get opt_done,3 disable
  return
 else
  m_optquery =2
 endif

 store '\'+padc('ANY',12) to sub_union(3)
 store '\'+padc('IN',12) to sub_union(4)
 store '\'+padc('NOT IN',12) to sub_union(5)
 store '\'+padc('EXISTS',12) to sub_union(6)
 store '\'+padc('NOT EXISTS',12) to sub_union(7)
 do case
 case empty(opt_type)
  store 1 to m_subunion,m_comp,opt_fields
 case m_subunion > 2
  store 1 to m_subunion
 endcase
 show get m_optquery enable
 show get m_comp disable  
 show get opt_fields disable
 show get m_and_or disable
 show get opt_done,3 enable
otherwise     && Subquery
 if alen(optqueries) = 1 && no queries saved
  wait "Can't do SUBQUERY without Saved Queries." window nowait
  m_options=1
  show get m_optquery disable
  show get m_subunion disable
  show get m_comp disable  
  show get opt_fields disable
  show get m_opt_num disable
  show get m_and_or disable
  show get m_options
  show get opt_done,3 disable
  return
 else
  m_optquery=2
  show get opt_done,3 enable
  if m_opt_num > 1
    show get m_and_or enable
  else
    show get m_and_or disable
  endif  
 endif

 do case
 case opt_fields=1
  store 1 to m_comp
  store 6 to m_subunion
  store '\'+padc(' ',12) to sub_union(1)
  store '\'+padc('ALL',12) to sub_union(2)
  store '\'+padc('ANY',12) to sub_union(3)
  store '\'+padc('IN',12) to sub_union(4)
  store '\'+padc('NOT IN',12) to sub_union(5)
  store padc('EXISTS',12) to sub_union(6)
  store padc('NOT EXISTS',12) to sub_union(7)
 case opt_fields > 1 and m_comp > 1
  store '\'+padc(' ',12) to sub_union(1)
  store padc('ALL',12) to sub_union(2)
  store padc('ANY',12) to sub_union(3)
  store '\'+padc('IN',12) to sub_union(4)
  store '\'+padc('NOT IN',12) to sub_union(5)
  store '\'+padc('EXISTS',12) to sub_union(6)
  store '\'+padc('NOT EXISTS',12) to sub_union(7)
 case opt_fields > 1 and m_comp = 1
  store '\'+padc(' ',12) to sub_union(1)
  store '\'+padc('ALL',12) to sub_union(2)
  store '\'+padc('ANY',12) to sub_union(3)
  store padc('IN',12) to sub_union(4)
  store padc('NOT IN',12) to sub_union(5)
  store '\'+padc('EXISTS',12) to sub_union(6)
  store '\'+padc('NOT EXISTS',12) to sub_union(7)
 endcase
 
* show get m_and_or enable
 if empty(opt_type)
  show get m_comp disable  
 endif 
endcase

do optnumval

show get m_subunion
show gets



procedure opt_f_val   && valid for opt_fields

if opt_fields=1  && blank
 store '\'+padc(' ',12) to sub_union(1)
 store '\'+padc('ALL',12) to sub_union(2)
 store '\'+padc('ANY',12) to sub_union(3)
 store '\'+padc('IN',12) to sub_union(4)
 store '\'+padc('NOT IN',12) to sub_union(5)
 store padc('EXISTS',12) to sub_union(6)
 store padc('NOT EXISTS',12) to sub_union(7)
 store 1 to m_comp
 store 6 to m_subunion
 show get m_optquery enable
 show get m_subunion enable
 show get m_comp disable  
else
 show get m_optquery enable
 store '\'+padc(' ',12) to sub_union(1)
 store '\'+padc('ALL',12) to sub_union(2)
 store '\'+padc('ANY',12) to sub_union(3)
 store padc('IN',12) to sub_union(4)
 store padc('NOT IN',12) to sub_union(5)
 store '\'+padc('EXISTS',12) to sub_union(6)
 store '\'+padc('NOT EXISTS',12) to sub_union(7)
 if m_comp=1
   store 4 to m_subunion
 endif  
 show get m_subunion enable
 show get m_comp enable  

endif





procedure opt_c_val   && valid for m_comp

if m_comp=1  && blank
 store '\'+padc(' ',12) to sub_union(1)
 store '\'+padc('ALL',12) to sub_union(2)
 store '\'+padc('ANY',12) to sub_union(3)
 store padc('IN',12) to sub_union(4)
 store padc('NOT IN',12) to sub_union(5)
 if opt_fields = 1
  store padc('EXISTS',12) to sub_union(6)
  store padc('NOT EXISTS',12) to sub_union(7)
  store '\'+padc('IN',12) to sub_union(4)
  store '\'+padc('NOT IN',12) to sub_union(5)
  store 6 to m_subunion

 else 
  store '\'+padc('EXISTS',12) to sub_union(6)
  store '\'+padc('NOT EXISTS',12) to sub_union(7)
  store 4 to m_subunion
 endif
 show get m_optquery enable
 show get m_subunion enable

else
 show get m_optquery enable
 store 2 to m_subunion
 store '\'+padc(' ',12) to sub_union(1)
 store padc('ALL',12) to sub_union(2)
 store padc('ANY',12) to sub_union(3)
 store '\'+padc('IN',12) to sub_union(4)
 store '\'+padc('NOT IN',12) to sub_union(5)
 store '\'+padc('EXISTS',12) to sub_union(6)
 store '\'+padc('NOT EXISTS',12) to sub_union(7)
 show get m_subunion enable
 show get m_comp enable  

endif




procedure opt_u_val   && valid for m_subunion

if m_options=3  &&   "Union"
 return
endif
 
do case
case m_subunion=1  && blank
 store 1 to m_comp
 show get opt_fields enable
 show get m_comp enable
case m_subunion> 5  && exists/not exists
  store 1 to opt_fields,m_comp
  show get opt_fields 
  show get m_comp 
case m_subunion> 3  && in/ not in
 store 1 to m_comp
 show get m_comp 
otherwise
 show get opt_fields enable
endcase


** make sure popups show currently selected value
procedure optnumval

opt_fields=iif(ascan(optfields,opt_f(m_opt_num))=0,1,;
   asubscript(optfields,ascan(optfields,opt_f(m_opt_num)),1))
m_comp=iif(ascan(mcompare,opt_c(m_opt_num))=0,1,ascan(mcompare,opt_c(m_opt_num)))
m_subunion=iif(ascan(sub_union,opt_u(m_opt_num))=0,1,ascan(sub_union,opt_u(m_opt_num)))
m_optquery=iif(ascan(optqueries,opt_q(m_opt_num))=0,1,ascan(optqueries,opt_q(m_opt_num)))
m_and_or = iif(opt_ao(m_opt_num)='OR',2,1)

if opt_fields = 1 and m_options = 2    && Subquery
  m_subunion = 6
endif  
** if new subquery or union, position on 1st query in list
if opt_fields = 1 and m_comp = 1 and ;
    (m_options = 2 or m_options = 3)
  m_optquery = iif(m_optquery = 1,2,m_optquery)
endif    
show gets
show get m_subunion



procedure num_val
** need to call opt_show twice
do opt_show
do opt_show


** calls do_query with different parameters
** so do_query can be used to build subqueries/unions
procedure bld_query
parameters see_sql
priv x,i,m_area3,sq_clause,sq_expr,temp_save,see_sql,q_suff
push key clear
do set_func
** see_sql .t. if Viewing SQL code

sq_clause=''
sq_expr=''

m_area3=select(0)

** make SEE SQL option more readable by adding ";"+chr(10)+chr(13)
** to SQL code

if see_sql    && see SQL
 q_suff=';'+chr(10)+chr(13)
else
 q_suff=''
endif



** save original query
temp_save=sys(3)+'.mem'  
do sav_mem with .t.,temp_save 
priv opt_type2,opt_f2,opt_c2,opt_u2,opt_q2,opt_ao2 

opt_type2=opt_type

** copy arrays containing subquery/union values
=acopy(opt_f,opt_f2)
=acopy(opt_c,opt_c2)
=acopy(opt_u,opt_u2)
=acopy(opt_q,opt_q2)
=acopy(opt_ao,opt_ao2)

q=0
for qq=1 to 4
 if empty(opt_q2(qq))
  loop
 else 
  if used('QBE_SAVE')
   select qbe_save
  else
   select 0
   use qbe_save  
  endif
  set order to tag qbe_name
  if ! seek(upper(opt_q2(qq)))
   loop
  endif
  q=q+1
  ** make subquery/union current
  do sav_mem
  sq_expr=do_query(see_sql,.t.)  && .t.=building subquery code

  if !empty(sq_clause)
    sq_clause = sq_clause + q_suff
  endif 

  if opt_type2='Subquery'
   if q=1
    sq_clause='<'+opt_ao2(qq)+'>'
   else
    sq_clause=sq_clause+ ' '+opt_ao2(qq)+' '
   endif 

   sq_clause = sq_clause ;
              + iif(empty(opt_f2(qq)),'',alltrim(opt_f2(qq))+' ') ;
              + iif(empty(opt_c2(qq)),'',alltrim(opt_c2(qq))+' ') ;
              + alltrim(opt_u2(qq))+' '+q_suff+alltrim(sq_expr)
  else                            && Union
   sq_clause = sq_clause ;
              + 'UNION '+alltrim(opt_u2(qq))+' '+q_suff+alltrim(sq_expr)
  endif

 endif
endfor


release opt_type2,opt_f2,opt_c2,opt_u2,opt_q2

** restore original query
do sav_mem with .f.,temp_save
if file(temp_Save)
 erase (temp_save) 
endif 
if used('qbe_save')
 use in qbe_save
endif 

select (m_area3)

if see_sql
 do do_query with .t.,.f.,sq_clause
else
 do do_query with .f.,.f.,sq_clause
endif 

pop key





procedure qbehelp
push key clear
do set_func
help
pop key


procedure set_func
** disable function keys 
priv i,fkey
for i = 1 to FKMAX()
 fkey='F'+alltrim(str(i)) 
 on key label &fkey *
endfor




procedure FindAlias
parameter m_str
priv m_str,z,b_sub,e_sub,i,y,x_str,t_str

if empty(m_str)
    return
endif

b_sub=1
e_sub=0

** look for alias in string
if occurs('.',m_str) > 0         && alias present ???
  for z=1 to occurs('.',m_str)
    e_sub=at('.',m_str,z)-1
    t_Str=left(m_str,e_sub)  
    y=1
    for i=e_sub to 1 step -1
      
      ** exit when string has length of 11
      ** maximum alias length = 10
      if y > 11
        exit
      endif
      x_str=subs(t_str,i,1)
      ** see if x_str matches a character that would indicate the
      ** end of an alias
      if x_str $ "{%^-*/+ ,("
        b_sub=i+1 
        exit
      endif  
      y=y+1
    endfor
    do case
    case y > 11  && too long to be alias
      exit
    case e_sub - b_sub < 0
      exit
    endcase

    if ascan(q_dbfs,alltrim(upper(subs(m_str,b_sub,;
      (e_sub-b_sub)+1) ))) > 0

      d_found=asubscript(q_dbfs,ascan(q_dbfs,alltrim(upper(;
      subs(m_str,b_sub,(e_sub-b_sub)+1) ))),1)
 
      if d_found > 0
        store .t. to q_dbfs(d_found,2)
      endif
    endif
    
  endfor

endif
return







procedure rfilter
if ! r_filter and empty(r_expr)
  store '' to r_expr,r_ex_name
  show get r_ex_name disable
  return
else
 store .t. to r_filter
endif

push key clear
do set_func

if exprChoice='Simple'

  do qsimple.spr with r_expr,r_ex_name,'fchoice','ARRAY',MasterDBF
    
else

  GETEXPR 'Enter FoxPro Record Filter Expression... ' TO r_expr;
   DEFAULT r_expr
  
  r_ex_name=r_expr 
 
endif
 
r_expr=alltrim(r_expr)
 
pop key

if empty(r_expr)
 store .f. to r_filter
 store '' to r_ex_name
 show get r_ex_name disable
else
 show get r_ex_name enable
 store .t. to r_filter
endif
show get r_filter
return





procedure gfilter
if ! g_filter and empty(g_expr)
    store '' to g_expr,g_ex_name
    show get g_ex_name disable
    return
else
 store .t. to g_filter
endif

push key clear
do set_func

if exprChoice='Simple'
   do qsimple.spr with g_expr,g_ex_name,'fchoice','ARRAY',MasterDBF
else

  GETEXPR 'Enter FoxPro Group Filter Expression... ' TO g_expr;
    DEFAULT g_expr
  
  g_ex_name=g_expr
     
endif
     
g_expr=alltrim(g_expr)

pop key

if empty(g_expr)
 store .f. to g_filter
 store '' to g_ex_name
 show get g_ex_name disable
else
 show get g_ex_name enable
 store .t. to g_filter
endif
show get g_filter
return



procedure showMess
** used to show a message on the screen
** requires release of showMess window in calling PRG
** displays up to 4 message lines
parameters startRow,m.centerIt,l1,l2,l3,l4
priv numRows,n,m.startRow,m.l1,m.l2,m.l3,m.l4,m.startCol,m.wwidth
priv ms
if parameters() < 3
  return
endif  
numRows=4
m.wwidth=0

if type('startRow') <> "N"
  startRow=0         
endif  
if type('centerIt') <>  "L"
  centerIt=.f.
endif  
if type('m.l1') <> "C"
 m.l1=''
endif 
if type('m.l2') <> "C"
 m.l2=''
endif 
if type('m.l3') <> "C"
 m.l3=''
endif 
if type('m.l4') <> "C"
 m.l4=''
endif 

dimension ms(4)
ms(1)=l1
ms(2)=l2
ms(3)=l3
ms(4)=l4

n=4
for n=4 to 1 step -1
  if empty(ms(n))
    numRows=numRows-1
  endif
  llen=len(ms(n))
  m.wwidth=max(m.wwidth,len(ms(n)))
endfor
m.wwidth=m.wwidth+2  && make sure space on either side of message
if numRows=0 or m.wwidth > 80
  return
endif
startCol= (wcols()-m.wwidth)/2

define window showMess  from startRow,startCol ;
  to startRow+numRows-1,startCol+m.wwidth ;
  none color scheme 5 shadow   
activate window showMess noshow
if centerIt
  for n=0 to numRows-1
    @ n,0 say padc(ms(n+1),wcols())
  endfor
else  && left justify
  for n=0 to numRows-1
    @ n,1 say padr(ms(n+1),wcols())
  endfor
endif
show window showMess 
return




procedure JoinExpr
priv RelArray,n,x,y,z,RelExpr,CurArea
CurArea=select(0)
RelExpr=''
dimension RelArray(25,4)  && target,relation,key,parent alias
store '' to RelArray

x=0            && target counter

select (m_area)     && select master DBF

** assumes master DBF selected
** process target DBFs for master DBF
for n=1 to 25
  if empty(target(n))
    exit
  endif
  x=x+1
  store target(n) to RelArray(x,1)
  if at('.',relation(n)) > 0  OR ;
     at('()',relation(n)) > 0      && contains field alias or recno()      
    store relation(n) to RelArray(x,2)
  else
    if at('(',relation(n)) > 0 
        RelArray(x,2)=stuff(relation(n), ;
             at('(',relation(n))+1,0,alias()+'.')
    else
      store alias()+'.'+relation(n) to RelArray(x,2)
    endif  
  endif
  store alias() to RelArray(x,4)
  select (RelArray(x,1))
  store sys(22) to RelArray(x,3)     && master index key of target
  select (CurArea)
endfor

** if no relations, exit
if x=0
  return ''
endif

** process target DBFs for child DBFs
for z=1 to 25
  if empty(RelArray(z,1))
    exit
  endif
  select (RelArray(z,1))
  for n=1 to 25
    if empty(target(n))
      exit
    endif
    x=x+1
    store target(n) to RelArray(x,1)
    if at('.',relation(n)) > 0  OR ;
       at('()',relation(n)) > 0      && contains field alias
                                          && recno()
      store relation(n) to RelArray(x,2)
    else
      ** see if key is present as function,but not recno()
      if at('(',relation(n)) > 0 
        RelArray(x,2)=stuff(relation(n), ;
             at('(',relation(n))+1,0,alias()+'.')
      else
        store alias()+'.'+relation(n) to RelArray(x,2)
      endif  
    endif
    store alias() to RelArray(x,4)
    select (RelArray(x,1))
    store sys(22) to RelArray(x,3)     && master index key of target
    select (RelArray(z,1))
  endfor
endfor
select (CurArea)
y=1
for n=1 to x
  ** m_dbfs is string containing query DBFs
  ** make sure selected DBF and Target DBF in Query DBFs
  if RelArray(n,1)  $ m_dbfs and  RelArray(n,4) $ m_dbfs
    if y=1
      RelExpr=RelArray(n,2)+' == '+RelArray(n,1)+'.'+RelArray(n,3)
    else
      RelExpr=RelExpr+' AND '+ ;
              RelArray(n,2)+' == '+RelArray(n,1)+'.'+RelArray(n,3)
    endif
    y=y+1
  endif
endfor
return RelExpr



procedure bld_List
** used to build array picklist from environment when MakeList=.t.
priv dbfs,x,n,i,old_area,f_cnt,m_flds,fchoice2

if empty(alias())
  return  
endif

f_cnt=0

old_area=select(0)

** store master DBF and related DBFs in array dbfs

dimension dbfs(25)
store '' to m.dbfs
store alias() to dbfs(1)
x=2


for i=1 to 25
  if empty(dbfs(i))
    exit
  endif
  
  select (dbfs(i))
  for n=1 to 25
    if empty(target(n))
      exit
    endif
    dbfs(x)=target(n)
    x=x+1
  endfor
  
endfor  
  

** count total fields in DBFs
for i=1 to 25
 if empty(dbfs(i))
   exit
 endif
 f_cnt=f_cnt+fcount(dbfs(i)) 
endfor


dimension fchoice2(f_cnt,5)
x=1
for n=1 to 25
  if empty(dbfs(n))
    exit
  endif

  select (dbfs(n))
  dimension m_flds(fcount(dbfs(n)),2)
  =afields(m_flds)
  for i=1 to fcount((dbfs(n)))
    fchoice2(x,1)=trim(upper(alias()))+'_'+trim(upper(m_flds(i,1)))   
    fchoice2(x,2)=trim(upper(alias()))+'.'+trim(upper(m_flds(i,1)))   
    fchoice2(x,3)=trim(upper(m_flds(i,2)))   
    fchoice2(x,4)=.f.
    fchoice2(x,5)=.t.
    x=x+1
  endfor

endfor  


if ! empty(fchoice2(1))
 dimension QZQZQZQZQZ(alen(fchoice2,1),5)  
 =acopy(fchoice2,QZQZQZQZQZ)
endif

  
select (old_area)  
return


