** PickList
parameters ListFile

** To build a new picklist DBF file open the master/parent DBF 
** and related files and set the relations between the files.
** Then select the master DBF and "Do PickList".

** To modify an existing picklist, "Do PickList with <Picklist name/alias>
** Example: Do PickList with "QCLIENT"

priv oldTalk,ListFile,old_area,m.not_done
priv oldSafety
oldSafety=set('SAFETY')
m.not_done=.f.

old_area=select(0)

if type('ListFile') <> 'C'
   ListFile=''
endif

oldTalk=set('talk')
set talk off

if empty(ListFile)
  do BldPkLst
else
  if used(ListFile)
     select (ListFile)
   else
     select 0
     use (ListFile)
   endif  
endif

do while .t.

 m.not_done=.f. 

 define window brw_fld from 1,2 to 22,67 color scheme 10 ;
    system close shadow
 push key clear
 on key label F6 do q_upper
 on key label F4 keyboard chr(20)
 on key label F8 do q_order with ListFile
 browse fields fieldlabel, field_name/r, field_type/r ;
   title 'F4- Delete/Undelete  F6- Proper/UPPER   F8- Order  Esc- Done' ;
   window brw_fld
 release window brw_fld
 pop key
 if ! m.not_done
   exit
 endif  
enddo 
pack
use
select (old_area)
set safety &oldSafety
  
set talk on
return


procedure BldPkLst
** used to build custom picklist from environment 
priv dbfs,x,n,i,f_cnt,m_flds,fchoice2,ListName,mAlias
ListName=''
mAlias=''
set safety off

f_cnt=0


** store master DBF and related DBFs in array dbfs

dimension dbfs(25)
store '' to m.dbfs
store alias() to dbfs(1)
x=2


for i=1 to 25
  if empty(dbfs(i))
    exit
  endif
  
  select (dbfs(i))
  for n=1 to 25
    if empty(target(n))
      exit
    endif
    dbfs(x)=target(n)
    x=x+1
  endfor
  
endfor  
  

** count total fields in DBFs
for i=1 to 25
 if empty(dbfs(i))
   exit
 endif
 f_cnt=f_cnt+fcount(dbfs(i)) 
endfor


dimension fchoice2(f_cnt,3)
x=1
for n=1 to 25
  if empty(dbfs(n))
    exit
  endif

  select (dbfs(n))
  dimension m_flds(fcount(dbfs(n)),2)
  =afields(m_flds)
  for i=1 to fcount((dbfs(n)))
        
    fchoice2(x,1)=trim(upper(alias()))+'_'+trim(upper(m_flds(i,1)))   
    fchoice2(x,2)=trim(upper(alias()))+'.'+trim(upper(m_flds(i,1)))   
    fchoice2(x,3)=trim(upper(m_flds(i,2)))   
    x=x+1
  endfor

endfor  

select (old_area)

ListName=putfile('Enter name of Picklist file...', ;
         'Q'+left(trim(alias()),7)+'.DBF','DBF')

if ! empty(ListName)
   CREATE DBF (ListName) ;
     (fieldlabel C(30), field_name C(20), Field_type C(1) )

   INSERT INTO (ListName) ;
 	FROM ARRAY fchoice2 	

   mAlias=stripAlias(ListName)
   ListFile = mAlias
   select (mAlias)
   go top

endif 

return




procedure stripAlias
parameter mfile
priv mfile
if empty(mfile)
  return alltrim(mfile)
endif

if '.' $ mfile
  mfile=left(mfile,at('.',mfile)-1)
endif  
if '\' $ mfile
  mfile= right(mfile,len(mfile)-rat('\',mfile))  
endif  
return mfile


procedure q_upper
priv m_upper
define window w_upper from 8,34 to 10,44 none shadow
m_upper = 1    && tag number (character string)
activate window w_upper
@ 0,0 GET m_upper FUNCTION '^T Proper;Uppercase;Cancel'
READ cycle modal
do case
case str(readkey(),3) $' 12 268' or m_upper=3
 ** do nothing
case m_upper=1
 go top
 scan
  replace fieldlabel with  proper(fieldlabel)
  if at('_',fieldlabel) > 0
   for i=1 to occurs('_',fieldlabel)
    replace fieldlabel with ;
    left(fieldlabel,at('_',fieldlabel,i))+;
    proper(subs(fieldlabel,at('_',fieldlabel,i)+1))
   endfor
  endif
 endscan

case m_upper=2
 replace all fieldlabel with upper(fieldlabel)
endcase
release window w_upper
go top
return



procedure q_order
parameters mAlias
priv m_order,mAlias
if empty(mAlias)
  return
endif  
push key clear
define window w_order from 7,31 to 10,48 none shadow 
m_order=1
activate window w_order
@ 0,0 say padc(' Set Order  ',wcols(),'-')
@ 1,0 GET m_order FUNCTION '^T Alias.Field_Name;Field_label;Cancel'
READ modal
release window w_order
do case
case str(readkey(),3) $' 12 268' or m_order=3
  pop key 
  return
case m_order=1
  set safety off
  sort to arr_temp.dbf on field_name /A/C
  zap
  append from arr_temp
  if used('arr_temp')
    use in arr_temp
  endif  
  erase arr_temp.dbf 
  set safety &oldSafety
  m.not_done=.t.
case m_order=2
  set safety off
  sort to arr_temp.dbf on fieldlabel /A/C
  zap
  append from arr_temp
  if used('arr_temp')
    use in arr_temp
  endif  
  erase arr_temp.dbf 
  set safety &oldSafety
  m.not_done=.t.

endcase

go top
pop key

return

