** QBE_DEMO.PRG
priv m.oldSafety,m.oldTalk

m.oldTalk=set('Talk')
m.oldSafety=set('safety')

set talk off
close databases

do FileOpen

DO CASE
CASE file('QBE.APP')
  do qbe.app with 'QCLIENT','CLIENT',.t.
CASE file('QBE.SPR')
  do qbe.spr with 'QCLIENT','CLIENT',.t.
OTHERWISE
  wait window nowait ;
   "Can't find QBE.SPR or QBE.APP. You need to open QBE.PJX and BUILD it."
  close databases
ENDCASE
set talk &oldTalk




** opens and creates demo files if needed
procedure FileOpen
** create demo files if needed
if ! file(sys(5)+curdir()+'CLIENT.DBF')
  CREATE TABLE  Client ;
   (client_no C(4), title C(4), fname C(20), ;
    lname C(20), address C(25), city C(25), state C(2), zip C(10) )

  INSERT INTO Client (client_no , title, fname, ;
    lname, address, city, state, zip ) ;
  VALUES ('0001', 'Mr.', 'Fred', 'Smith', '123 Main St.',;
	   'Norfolk', 'VA', '23505')

  INSERT INTO Client (client_no , title, fname, ;
    lname, address, city, state, zip ) ;
  VALUES ('0002', 'Dr.', 'John', 'Lawrence', '333 W. South Ave.',;
	   'Chesapeake', 'VA', '23320')

  INSERT INTO Client (client_no , title, fname, ;
    lname, address, city, state, zip ) ;
  VALUES ('0003', 'Ms.', 'Sally', 'Jones', 'P.O. Box 21',;
	   'Virginia Beach', 'VA', '23456')

endif  

if ! file(sys(5)+curdir()+'Pledge.DBF')
  CREATE TABLE  Pledge ;
   (client_no C(4), year C(4), amount N(10), ;
    account_no C(3) )

  INSERT INTO Pledge (client_no, year, ; 
    amount, account_no );
  VALUES ('0001', '1990', 1000, '100' )

  INSERT INTO Pledge (client_no, year, ; 
    amount, account_no );
  VALUES ('0001', '1990', 200, '200' )

  INSERT INTO Pledge (client_no, year, ; 
    amount, account_no );
  VALUES ('0002', '1990', 1500, '100' )

  INSERT INTO Pledge (client_no, year, ; 
    amount, account_no );
  VALUES ('0003', '1990', 2000, '100' )

  INSERT INTO Pledge (client_no, year, ; 
    amount, account_no );
  VALUES ('0003', '1990', 1500, '200' )

  INSERT INTO Pledge (client_no, year, ; 
    amount, account_no );
  VALUES ('0001', '1991', 1000, '100' )

  INSERT INTO Pledge (client_no, year, ; 
    amount, account_no );
  VALUES ('0001', '1991', 500, '200' )

  INSERT INTO Pledge (client_no, year, ; 
    amount, account_no );
  VALUES ('0002', '1991', 2000, '100' )

  INSERT INTO Pledge (client_no, year, ; 
    amount, account_no );
  VALUES ('0002', '1991', 250, '200' )

  INSERT INTO Pledge (client_no, year, ; 
    amount, account_no );
  VALUES ('0003', '1991', 2500, '100' )

  INSERT INTO Pledge (client_no, year, ; 
    amount, account_no );
  VALUES ('0003', '1991', 1000, '200' )

  INSERT INTO Pledge (client_no, year, ; 
    amount, account_no );
  VALUES ('0001', '1992', 1200, '100' )

  INSERT INTO Pledge (client_no, year, ; 
    amount, account_no );
  VALUES ('0002', '1992', 2000, '100' )

  INSERT INTO Pledge (client_no, year, ; 
    amount, account_no );
  VALUES ('0002', '1992', 400, '200' )

  INSERT INTO Pledge (client_no, year, ; 
    amount, account_no );
  VALUES ('0003', '1992', 2700, '100' )

  INSERT INTO Pledge (client_no, year, ; 
    amount, account_no );
  VALUES ('0003', '1992', 1000, '200' )


endif  

if ! file(sys(5)+curdir()+'Accounts.DBF')
  CREATE TABLE  Accounts ;
   (account_no C(3), descript C(30) )

  INSERT INTO Accounts (account_no, descript );
  VALUES ('100', 'General Operating Fund' )

  INSERT INTO Accounts (account_no, descript );
  VALUES ('200', 'Building Fund' )

endif  

** create custom picklist
if ! file(sys(5)+curdir()+'QCLIENT.DBF')
  CREATE TABLE  QCLIENT ;
   (field_name C(20), fieldlabel C(30), field_type C(1) )

  INSERT INTO QCLIENT ;
    (field_name, fieldlabel, field_type ) ;
  VALUES ('CLIENT.CLIENT_NO','Client_Number (Client File) ','C' )

  INSERT INTO QCLIENT ;
    (field_name, fieldlabel, field_type ) ;
  VALUES ('CLIENT.TITLE','Title','C' )

  INSERT INTO QCLIENT ;
    (field_name, fieldlabel, field_type ) ;
  VALUES ('CLIENT.FNAME','First_Name','C' )

  INSERT INTO QCLIENT ;
    (field_name, fieldlabel, field_type ) ;
  VALUES ('CLIENT.LNAME','Last_Name','C' )

  INSERT INTO QCLIENT ;
    (field_name, fieldlabel, field_type ) ;
  VALUES ('CLIENT.ADDRESS','Address','C' )

  INSERT INTO QCLIENT ;
    (field_name, fieldlabel, field_type ) ;
  VALUES ('CLIENT.CITY','City','C' )

  INSERT INTO QCLIENT ;
    (field_name, fieldlabel, field_type ) ;
  VALUES ('CLIENT.STATE','State','C' )

  INSERT INTO QCLIENT ;
    (field_name, fieldlabel, field_type ) ;
  VALUES ('CLIENT.ZIP','Zipcode','C' )

  INSERT INTO QCLIENT ;
    (field_name, fieldlabel, field_type ) ;
  VALUES ('PLEDGE.CLIENT_NO','Client_Number (Pledge File) ','C' )

  INSERT INTO QCLIENT ;
    (field_name, fieldlabel, field_type ) ;
  VALUES ('PLEDGE.YEAR','Year','C' )

  INSERT INTO QCLIENT ;
    (field_name, fieldlabel, field_type ) ;
  VALUES ('PLEDGE.AMOUNT','Amount','N' )

  INSERT INTO QCLIENT ;
    (field_name, fieldlabel, field_type ) ;
  VALUES ('PLEDGE.ACCOUNT_NO','Account_Number (Pledge File)','C' )

  INSERT INTO QCLIENT ;
    (field_name, fieldlabel, field_type ) ;
  VALUES ('ACCOUNTS.ACCOUNT_NO','Account_Number (Account File)','C' )

  INSERT INTO QCLIENT ;
    (field_name, fieldlabel, field_type ) ;
  VALUES ('ACCOUNTS.DESCRIPT','Description','C' )

endif  




if used('Client')
  select Client
else
  select 0
  use Client again 
endif

set safety off
index on lname+fname tag name
set order to tag name


if used('Pledge')
  select Pledge
else
  select 0
  use Pledge Again 
endif
index on client_no tag client_no
set order to tag client_no

if used('Accounts')
  select Accounts
else
  select 0
  use Accounts Again 
endif
index on account_no tag account_no
set order to tag account_no

select pledge
set relation to account_no into accounts

select client
set relation to client_no into pledge
go top

if used('QCLIENT')
  use in qclient
endif


set safety &oldSafety

