/*  Putenv.C
    Erik McBeth
    Borland International dBASE Software Support   
    1991.03.24  Revision 2
    
    To create:
               TCC -c Putenv.C
               TLINK Putenv.OBJ
               EXE2BIN Putenv
               
    The resulting Putenv.BIN file can be called from dBASE III Plus
    or dBASE IV.  The BIN file requires two parameters, the first
    being a string of the form "<variable>=<value>" and then second
    being a string which designates which DOS environments should
    be changed:  "10" = DOS master environment
                 "20" = dBASE's DOS environment
                 "30" = Both
    Example:
             dBASE III Plus
               mstring = "USR=WAM"
               menv    = "30"
               LOAD putenv
               CALL putenv WITH mstring 
                                 
             dBASE IV
               mstring = "USR=WAM"
               menv    = "30"
               LOAD putenv
               CALL putenv WITH mstring,menv 
             
    In both cases the variable "menv" will contain a return value
    indicating which environments Putenv.BIN was able to change 
    ("10", "20", etc).  If there is not enough environment space left
    than the changes cannot take place.  You can "kill" an environment
    variable by passing a string like "USR=". 
  
*/


#include <dos.h>                /* geninterrupt()         */
#include "putenv.h"             /* protypes/macros        */
#define MK_ENV(mcb) \
       ((MCB far *)MK_FP(*((WORD far *)MK_FP(FP_SEG(mcb)+1,0x2c))-1,0))
#define NEXT_MCB(mcb) \
       (MCB far *)MK_FP(FP_SEG(mcb) + mcb->size + 1, 0)

WORD get_psp(void);  /* suggested by William Zimmerman */
       
void far main()                 /* far return required    */
{
    int pcount   = 0;           /* number of parameters   */
    BYTE dbase4  = 0;           /* if running dBASE IV    */ 
    BYTE success = 0;           /* error/success level    */
    BYTE far *envstr;           /* env string parameter   */
    BYTE far *action;           /* what env's to change   */
    BYTE far **table;           /* table of parameters    */
    WORD DS, BX,ES, DI, CX;     /* register holders       */
    MCB far *mcb,far *dbenv,far *msenv;  /* memory control
                                            blocks        */       
    int i;
    
    BX      = _BX;              /* load registers into local variables */
    CX      = _CX;
    DI      = _DI;
    DS      = _DS;
    ES      = _ES;        
    
    envstr  = (unsigned char far *)MK_FP(DS,BX); /* address of string */
    table   = (unsigned char far **)MK_FP(ES,DI);
    dbase4  = (table[0] == envstr); /* if DS:BX and the first pointer in
                                        the dBASE IV pointer table are
                                        identical then we are using dBASE IV 
                                      */
    
    if (dbase4) {
      envstr  = table[0];       /* same as DS:BX         */
      action  = table[1];
      pcount  = CX;             /* parameter count in CX */
      }
    else  
    if (envstr) {
       /* action is located at LEN(string)+2, the 2 comes from the
          null character at the end of the first string plus the byte 
          just before action which gives its length */
       action  = (unsigned char far *)MK_FP(DS,BX+fstrlen(envstr)+2);
       if (*action) 
          pcount = 2;
       }
    
    if (pcount>1) {             /* make sure we have two strings */
       for(i=0;envstr[i] && envstr[i]!='=';i++)
          envstr[i]=toupper(envstr[i]);
       
       if (envstr[i]=='=')      /* proper format used */ {
          mcb   = get_first_mcb();
          msenv = master_env_mcb(mcb);
          dbenv = dbase_env_mcb(mcb);
          if (*action=='1' || *action=='3')
             success  = change_env(msenv,envstr);
          if (*action=='2' || *action=='3')
             success += 2*change_env(dbenv,envstr);
          }   
       
       action[0] = success+'0'; /* return success code */
       action[1] = '0';
       action[2] = 0;
       }
      
}

BYTE far *search_env(MCB far *mcb,BYTE far *envstr)
{
    WORD varnamelen = get_varname_len(envstr);
    BYTE far *env   = get_mcb_env(mcb);

    while(*env) {
       if (env[varnamelen]=='=' && !fstrncmp(env,envstr,varnamelen))
          break;
       env = get_next_envstr(env);
       }
    return env;   
       
}    

BYTE change_env(MCB far *mcb,BYTE far *envstr)
{
    BYTE far *env       = get_mcb_env(mcb);
    BYTE far *envstrptr = search_env(mcb,envstr);
    BYTE far *nextenvstr;
    WORD varnamelen     = get_varname_len(envstr);
    WORD envlen         = mcb->size*16;
    WORD envstrlen      = fstrlen(envstr);
    BYTE far *string    = &envstr[varnamelen+1]; /* value after the '='  */
    WORD i,remain;
    
    if (*envstrptr) /* kill current environment variable */ {
        remain     = envlen-(envstrptr-env);
        nextenvstr = get_next_envstr(envstrptr);
        for(i=0;i<remain;i++)
           envstrptr[i] = nextenvstr[i];
        envstrptr = search_env(mcb,envstr); /* end of the environment */
        }  
    if (*string) {
        if (((envstrptr-env)+envstrlen+2) > envlen) /* no room */
           return 0;
        fstrcpy(envstrptr,envstr);
        envstrptr[envstrlen+1]=0;  /* ending environment null */
          }
    return 1;
       
}

MCB far *get_first_mcb()
{
    WORD ES,BX;
    
    _AX = 0x5200;
    geninterrupt(0x21);
    
    BX = _BX;
    ES = _ES;
    
    return (MCB far *)MK_FP(*((WORD far *)(MK_FP(ES,BX)-2)),0);
}   

MCB far *dbase_env_mcb(MCB far *mcb)
{
    MCB far *temp = MK_ENV(mcb);
    WORD psp = get_psp();
    
    /* to find dBASE's environment we retrieve the next to last MCB 
       in the MCB chain since the last MCB should be dBASE itself */ 
    while(mcb->type != 'Z') {
      mcb  = NEXT_MCB(mcb);
      if (MK_ENV(mcb)->type == 'M' && MK_ENV(mcb)->owner == psp) /* found a valid environment */
          temp = MK_ENV(mcb);
      }
    return temp;  
}

MCB far *master_env_mcb(MCB far *mcb)
{
    while(mcb->type != 'Z') {
      /* if the mcb->owner is equal to the WORD found at
         mcb->owner:0016 then we are looking at a copy of COMMAND.COM,
         in this case we look for the first COMMAND.COM we come to
         which should be the master command processor */
      if (mcb->owner == *((WORD far *)MK_FP(mcb->owner,0x16))) {
         /* this comvoluted expression will give us the MCB containing
            the master environment */
         mcb = MK_ENV(mcb);
         break;
         }
      mcb  = NEXT_MCB(mcb);
      }
    return mcb;  
}

BYTE far *fstrcpy(BYTE far *dest,BYTE far *src)
{
    BYTE far *p = dest;
    
    while((*dest++ = *src++)!=0);
    return p;
}

fstrncmp(BYTE far *str1,BYTE far *str2,WORD len)
{
    WORD i;
    int val=0;
    
    for(i=0;i<len;i++) {
       val = str1[i] - str2[i];
       if (val)
          return val;
        }  
          
    return val;
}
      
WORD fstrlen(BYTE far *str) /* length of far string */
{
    WORD len=0;
    
    while(*str++) 
       len++;
            
    return len;
}

BYTE far *fstrchr(BYTE far *str,BYTE ch) 
{
    while(1) {
       if (*str == ch)
          return str;
       if (!*str) /* this way we can check for the null character */
          break;
       str++;
       }
       
    return (BYTE far *)0;
}

WORD get_psp()
{
   _AH = 0x51;
   geninterrupt(0x21);
   
   return _BX;
}
   
