*:*****************************************************************************
*:
*: Procedure file: C:\FOXPRO\PROJECT\PRSEARCH\..\LIBRARY\TIMESTMP.PRG
*:         System: Project Search-and-Replace Utility
*:         Author: Stephen A. Sawyer
*:      Copyright (c) 1993, KarCal Company, Inc.
*:  Last modified: 04/20/93 at 11:07:18
*:
*:         Set by: SNRTABLE.PRG                      
*:               : SNRPROJ.PRG                       
*:
*:          Calls: DECTOBIN.PRG
*:               : BINTODEC.PRG
*:
*:      Documented 13:53:36                                FoxDoc version 3.00a
*:*****************************************************************************
* This function converts either the current system date and time into the
* "timestamp" format used in FoxPro Power Tools tables (.PJX/.SCX etc)
* Alternatively, you may pass two optional parameters, a date (type "D")
* and time string (type "C").  The time string must be in 12-hour 8-character
* format ("HH:MM:SS")
*
*
* This function works by first converting the current date and time into
* a 32-bit binary number which codes this information as follows:
*
* YYY YYYM MMMD DDDD HHHH HMMM MMMS SSSS
*
* Y=year, M=Month, D=Day, H=Hour, M=Minute, S=Second
*
* Note that the seconds "field" should be 6 bits, but the "field"
* is truncated to fit into a 32-bit binary number.  To convert back to the
* decimal number, or to "decode" the timestamp, the seconds value must be
* multiplied by 2d/10b to fill out the rightmost bit.
* Note also that the years "field" begins counting from 1980, all others
* begin at 0.
* The information on the format of this number was provided by Roger
* Bischoff [MSFT] on CompuServe's FOXFORUM
*
* The function DECSTAMP() performs the "decoding" operation, converting the
* timestamp field into a date-and-time character string
* These functions use the DECTOBIN() and BINTODEC() functions to perform
* the base conversions from decimal to binary and back
*******************************************************************************
PARAMETERS pdDate,pcTime
PRIVATE ldDate,lcTime
IF PARAMETERS() < 2
	ldDate=DATE()
	lcTime=TIME()
ELSE
	ldDate=pdDate
	lcTime=pcTime
ENDIF ( PARAMETERS() < 2 )
lcDecYear = YEAR(ldDate)
lcDecMonth = MONTH(ldDate)
lcDecDay = DAY(ldDate)
lcDecHr = VAL(LEFT(lcTime,2))
lcDecMin = VAL(SUBSTR(lcTime,4,2))
lcDecSec = VAL(RIGHT(lcTime,2))

lcBinYear=dectobin(lcDecYear-1980)
IF LEN(lcBinYear) < 7
	lcBinYear = REPLICATE("0",7-LEN(lcBinYear)) + lcBinYear
ELSE
	lcBinYear = RIGHT(lcBinYear,7)
ENDIF ( LEN(lcBinYear) < 7 )
lcBinMonth=dectobin(lcDecMonth)
lcBinDay = RIGHT(dectobin(lcDecDay),5)
IF LEN(lcBinDay) < 5
	lcBinDay = RIGHT("0000" + lcBinDay,5)
ELSE
	lcBinDay = RIGHT(lcBinDay,5)
ENDIF ( LEN(lcBinDay) < 5 )

lcBinHr = dectobin(lcDecHr)
IF LEN(lcBinHr) < 5
	lcBinHr = RIGHT("0000" + lcBinHr,5)
ELSE
	lcBinHr = RIGHT(lcBinHr,5)
ENDIF ( LEN(lcBinHr) < 5 )
lcBinMin = RIGHT(dectobin(lcDecMin),6)
IF LEN(lcBinMin) < 6
	lcBinMin = RIGHT("0000" + lcBinMin,6)
ELSE
	lcBinMin = RIGHT(lcBinMin,6)
ENDIF ( LEN(lcBinMin) < 6 )

lcBinSec = dectobin(lcDecSec)
IF LEN(lcBinSec) < 6
	lcBinSec = LEFT(RIGHT("0000" + lcBinSec,6),5)
ELSE
	lcBinSec = LEFT(RIGHT(lcBinSec,6),5)
ENDIF ( LEN(lcBinSec) < 6 )

lcBinTime = lcBinYear + lcBinMonth + lcBinDay + ;
	lcBinHr + lcBinMin + lcBinSec

IF MOD(LEN(lcBinTIme),4) > 0
	lcBinTime = lcBinTime + ;
		REPLICATE("0",4-MOD(LEN(lcBintime),4))
ENDIF ( MOD(LEN(lcBinTIme),4) > 0 )

lcDecTime = bintodec(lcBinTime)

RETURN lcDecTime
*: EOF: TIMESTMP.PRG
