*:*****************************************************************************
*:
*: Procedure file: C:\FOXPRO\PROJECT\PRSEARCH\SNRFILE.PRG
*:         System: Project Search-and-Replace Utility
*:         Author: Stephen A. Sawyer
*:      Copyright (c) 1993, KarCal Company, Inc.
*:  Last modified: 05/04/93 at 15:59:05
*:
*:         Set by: SNRPROJ.PRG                       
*:               : BEGPROCESS()       (function  in SNR.SPR)
*:
*:          Calls: NOPATH.PRG
*:               : FMSGBOX()          (function  in FMSGBOX.PRG)
*:               : DMSGBOX.PRG
*:               : OBJSCAN.PRG
*:               : FILEEDIT.PRG
*:
*:      Documented 13:53:31                                FoxDoc version 3.00a
*:*****************************************************************************
* Open the file in which the search string has been 
* found using Low-Level File Functions, and copy it to 
* a memvar.  Check to be certain that ALL of the file
* has been read, and inform the user of the problem
* before continuing.
******************************************************
PARAMETERS pcFile
lcCurrArea=ALIAS()
lnHandle=FOPEN((pcFile))
IF lnHandle=-1
	DO llfferor WITH FERROR(), pcFile, "OPENING"
	RETURN
ENDIF
lnFsize = FSEEK(lnHandle,0,2)
lnClosed=FCLOSE(lnHandle)
*********************************
SELECT 0
CREATE CURSOR x_dummy (name C(129),code M)
APPEND BLANK
APPEND MEMO code FROM (pcFile) OVERWRITE
REPLACE name WITH pcFile
IF LEN(code) < lnFsize 
************************************
	lcProbFile=NOPATH(pcFile)
	lcProbHdr="There is a problem with " + lcProbFile
	lcProbMsg="This file has not been " + ;
		"completely read by PRSEARCH.APP, " + ;
		"and cannot be processed" 
	?? CHR(7)
	IF _WINDOWS
		lcReply = MSGBOX(lcProbMsg,lcProbHdr,64)
	ELSE
		lcReply = DMSGBOX(lcProbMsg,lcProbHdr)
	ENDIF ( _WINDOWS )
	RELEASE lcObject
	RETURN
ENDIF ( LEN(lcObject) < lnFsize )
******************************************************
* If the user has requested a listing of the 
* occurrences only, pass control to the procedure
* OBJSCAN
* If the user is doing a search-and-replace, create
* a cursor with a memo field into which the memvar
* is copied.  This is to facilitate using the 
* MODIFY MEMO RANGE command for doing the search-and-
* replacement.  A logical variable llRecChgd is 
* initialized .F. which is set .T. by STRGREPL.
* This variable is used to determine whether the 
* program or query file must be written back to 
* disk upon return from FILEEDIT
******************************************************
IF llScan
	lcObject=x_dummy.code
	DO objscan WITH lcSrchStr,lcObject,pcFile,llWords,llCase,""
ELSE
	IF _DOS
		DEFINE WINDOW wrEdit FROM 5,3 TO WROWS("")-INT(WROWS("")/2),WCOLS("")-3 SYSTEM ;
			TITLE (pcFile) FOOTER "Alt-G Skips, Alt-E Replaces, Esc Aborts" FLOAT GROW CLOSE ZOOM COLOR SCHEME 8
	ELSE
		DEFINE WINDOW wrEdit FROM 5,3 TO WROWS("")-INT(WROWS("")/2),WCOLS("")-3 SYSTEM ;
			TITLE (pcFile) FOOTER "Alt-G Skips, Alt-E Replaces, Esc Aborts" FLOAT GROW CLOSE ZOOM COLOR SCHEME 8 FONT "Arial",12
	ENDIF ( _DOS )
	llRecChgd=.F.
	DO memoedit WITH lcSrchStr,"CODE",llWords,llCase,pcFile
	IF llRecChgd
		SELECT x_dummy
		GOTO TOP
		COPY MEMO code TO (pcFile)
	ENDIF ( llRecChgd )
	RELEASE WINDOW wrEdit
ENDIF ( llScan )
SELECT x_dummy
USE
IF ! EMPTY(lcCurrArea)
	SELECT (lcCurrArea)
ENDIF ( ! EMPTY(lcCurrArea) )

RETURN
*: EOF: SNRFILE.PRG

