*:*****************************************************************************
*:
*: Procedure file: C:\FOXPRO\PROJECT\PRSEARCH\..\LIBRARY\SHRTPATH.PRG
*:         System: Project Search-and-Replace Utility
*:         Author: Stephen A. Sawyer
*:      Copyright (c) 1993, KarCal Company, Inc.
*:  Last modified: 04/29/93 at  9:00:13
*:
*:  Procs & Fncts: SHRTPATH()
*:
*:      Documented 13:53:42                                FoxDoc version 3.00a
*:*****************************************************************************
* Syntax SHRTPATH(<fully-qualified filename>,<length>)
* Returns the fully-qualified filename shortened to no more
* than the specified length, inserting ellipsis (..) in place
* of as many directory entries as necessary to shorten as
* specified.  Directories are removed from the highest level,
* (just below the root directory), leaving the lowest level
* directories intact.
***********************************************************
*!*****************************************************************************
*!
*!       Function: SHRTPATH
*!
*!      Called by: SNR.SPR                           
*!               : _QFL0QPDH9()       (function  in SNR.SPR)
*!               : _QFL0QPFK1()       (function  in SNR.SPR)
*!
*!*****************************************************************************
FUNCTION shrtpath
PARAMETERS pcFileName,pnLength
IF LEN(TRIM(pcFileName)) > pnLength
	pcFileName=TRIM(pcFileName)
	DO WHILE LEN(pcFileName) > pnLength-3
		lnDirPos=3
		lnDirLen=AT("\",pcFileName,2)-3
		pcFileName=STUFF(pcFileName,4,lnDirLen,"")
	ENDDO ( LEN(pcFileName) > pnLength-3 )
	pcFileName=STUFF(pcFileName,4,0,"..\")
ENDIF ( LEN(TRIM(pcFileName)) > pnLength )
RETURN pcFileName
*: EOF: SHRTPATH.PRG
