*:*****************************************************************************
*:
*: Procedure file: C:\FOXPRO\PROJECT\PRSEARCH\SNRTABLE.PRG
*:         System: Project Search-and-Replace Utility
*:         Author: Stephen A. Sawyer
*:      Copyright (c) 1993, KarCal Company, Inc.
*:  Last modified: 05/04/93 at 15:59:05
*:
*:         Set by: SNRPROJ.PRG                       
*:               : BEGPROCESS()       (function  in SNR.SPR)
*:
*:          Calls: NOEXT.PRG
*:               : OBJSCAN.PRG
*:               : MEMOEDIT.PRG
*:               : TIMESTMP.PRG
*:
*:           Uses: _OBJECT.DBF        
*:
*:      CDX files: _OBJECT.CDX
*:
*:      Documented 13:53:32                                FoxDoc version 3.00a
*:*****************************************************************************
PARAMETERS pcTable
*******************************************************
* Save current work area in case called from SNRPROJ
*******************************************************
lcCurrArea=ALIAS()
SELECT 0
*******************************************************
* Establish an alias for the current table
*******************************************************
lcAlias=NOEXT(pcTable)
USE (pcTable) ALIAS &lcAlias
SELECT 0
*******************************************************
* Open the _OBJECT database which allows PRSEARCH
* to "DECODE" the ojbtype field in the power-tool
* tables, and set a filter to the type of table
* being examined, and set a relation between the 
* current table and the _OBJECT database.
*******************************************************
USE _object ORDER TAG objtype
SET FILTER TO tabletype = RIGHT(TRIM(pcTable),3)
SELECT (lcAlias)
SET RELATION TO objtype INTO _object
*******************************************************
* Restrict operation to the platform indicated by the
* user.  Note that .MNX files are excluded, because
* TYPE("PLATFORM") will evaluate to "U"
*******************************************************
IF TYPE("platform") = "C"
	DO CASE
	CASE lcPlatChoice="Windows"
		SET FILTER TO platform="WINDOWS"
	CASE lcPlatChoice="DOS"
		SET FILTER TO platform="DOS"
	ENDCASE
ENDIF ( TYPE("platform") = "C" )
GOTO TOP
***************************************
* Establish a reference date and time
* so if changing objects from all platforms,
* the timestamp for both DOS and WINDOWS will
* have the same timestamp
***************************************
ldDateRef=DATE()
lcTimeRef=TIME()
*******************************************************
* SCAN through the table, field by field on each record
* looking for memo fields.  Check memo fields for
* the occurrence of the search string, either 
* respecting case or not, as the user has indicated.
* A logical variable llRecChgd is initialized to .F.
* This variable is set .T. by the procedure STRGREPL,
* which is called from MEMOEDIT and FILEEDIT when a 
* replacement is made by the user.  SNRTABLE 
* timestamps the record if the user makes a change
* to one of the memo fields in a particular record.
* If the search string occurs, control is passed to
* the procedure "OBJSCAN", if the user
* is only compiling a list, OR if the user wants to 
* search-and-replace, define a window for editing
* and pass control to "MEMOEDIT"
*******************************************************
SCAN
	llRecChgd = .F.
	lcNameFld=lcAlias+".name"
	lcObjName= TRIM(_object.object) + " " + &lcNameFld
	FOR i=1 TO FCOUNT()
		IF TYPE(FIELD(i)) = "M" AND ;
				((llCase AND lcSrchStr $ EVALUATE(FIELD(i))) OR ;
				(! llCase AND UPPER(lcSrchStr) $ UPPER(EVALUATE(FIELD(i)))))
			lcObject=EVALUATE(FIELD(i))
			IF llScan
				DO objscan WITH lcSrchStr,lcObject,FIELD(i),llWords,llCase,lcObjName
			ELSE
				IF _DOS
					DEFINE WINDOW wrEdit FROM 5,3 TO WROWS("")-INT(WROWS("")/2),WCOLS("")-3 SYSTEM ;
						TITLE (lcObjName) ;
						FLOAT GROW CLOSE ZOOM COLOR SCHEME 8
				ELSE
					DEFINE WINDOW wrEdit FROM 5,3 TO WROWS("")-INT(WROWS("")/2),WCOLS("")-3 SYSTEM ;
						TITLE (lcObjName) ;
						FLOAT GROW CLOSE ZOOM COLOR SCHEME 8 FONT "Arial",12
				ENDIF ( _DOS )
				DO memoedit WITH lcSrchStr,FIELD(i),llWords,llCase,pcTable
				RELEASE WINDOW wrEdit
			ENDIF ( llScan )
		ENDIF ( TYPE(FIELD(i)) = "M" AND ; )
	ENDFOR ( i )
	IF llRecChgd AND TYPE("platform") = "C"
		REPLACE timestamp WITH timestmp(ldDateRef,lcTimeRef)
		llEleChgd=.T.
	ENDIF ( llRecChgd )
ENDSCAN
SELECT _object
USE
SELECT (lcAlias)
USE
IF ! EMPTY(lcCurrArea)
	SELECT &lcCurrArea
ENDIF ( ! EMPTY(lcCurrArea) )
RETURN
*: EOF: SNRTABLE.PRG
