*:*****************************************************************************
*:
*: Procedure file: C:\FOXPRO\PROJECT\PRSEARCH\SNRPROJ.PRG
*:         System: Project Search-and-Replace Utility
*:         Author: Stephen A. Sawyer
*:      Copyright (c) 1993, KarCal Company, Inc.
*:  Last modified: 05/06/93 at  8:44:26
*:
*:         Set by: BEGPROCESS()       (function  in SNR.SPR)
*:
*:          Calls: MSGBOX()           (function  in FOXTOOLS.DLL)
*:               : DMSGBOX.PRG
*:               : QUALFILE.PRG
*:               : SNRFILE.PRG
*:               : SNRTABLE.PRG
*:               : TIMESTMP.PRG
*:               : NOPATH.PRG
*:
*:        Indexes: NAME                   (tag in _OBJECT.CDX)
*:
*:      Documented 13:53:39                                FoxDoc version 3.00a
*:*****************************************************************************
PARAMETERS pcProjName
*******************************************************
* Construct lcInclType string 
* based on the user's input
*******************************************************
lcInclType = IIF(! llExScx,'"s",',"") + ;
	IIF(! llExPrg,'"P",',"") + ;
	IIF(! llExMnx,'"M",',"") + ;
	IIF(! llExQpr,'"Q",',"") + ;
	IIF(! llExFrx,'"R",',"") + ;
	IIF(! llExLbx,'"B",',"")
IF LEFT(lcInclType,1) = ","
	lcInclType=STUFF(lcInclType,1,1,"")
ENDIF ( LEFT(lcInclType,1) = "," )
IF RIGHT(lcInclType,1) = ","
	lcInclType=STUFF(lcInclType,LEN(lcInclType),1,"")
ENDIF ( RIGHT(lcInclType,1) = "," )
*******************************************************
* Open the project, get the home directory
*******************************************************
USE (pcProjName) ALIAS x_orig
GOTO TOP
lchomeDir=TRIM(homedir)

*******************************************************
* Filter on only those project elements not excluded
* by the user
*******************************************************
SET FILTER TO ;
	INLIST(x_orig.type,&lcInclType) AND ! exclude
GOTO TOP
*******************************************************
* Create a cursor to hold the names of the elements
* contained in the project, load with the element 
* filenames, and INDEX UNIQUE.
* This technique avoids repeatedly searching screen 
* files that are used in multiple screen sets
*******************************************************
SELECT 0
CREATE CURSOR x_pjxtmp (name C(100), TYPE C(1))
SELECT x_orig
SCAN
	SELECT x_pjxtmp
	APPEND BLANK
	IF CHR(0) $ x_orig.name
		REPLACE x_pjxtmp.name WITH LEFT(ALLTRIM(x_orig.name),LEN(ALLTRIM(x_orig.name))-1)
	ELSE
		REPLACE x_pjxtmp.name WITH ALLTRIM(x_orig.name)
	ENDIF ( CHR(0) $ x_orig.name )
	REPLACE x_pjxtmp.type WITH x_orig.type
	SELECT x_orig
ENDSCAN
SELECT x_pjxtmp
INDEX ON name TAG name UNIQUE
GOTO TOP
*******************************************************
* The QUALFILE() function fully-qualifies each filename 
* by using the "home" directory and determining each 
* file's "absolute" location rather than it's location 
* relative to the "home" directory, and strips off any
* terminal NULL characters
*******************************************************
REPLACE ALL x_pjxtmp.name WITH QUALFILE(lcHomeDir,x_pjxtmp.name)
GOTO TOP
*******************************************************
* Hand off control to either SNRFILE or SNRTABLE
* depending on whether current project element is
* a .QPR or .PRG file, or a power-tool table
*******************************************************
SCAN
	WAIT "Processing " + TRIM(NOPATH(x_pjxtmp.name)) WINDOW NOWAIT
	IF x_pjxtmp.type = "P" OR x_pjxtmp.type="Q"
		DO snrfile WITH TRIM(x_pjxtmp.name)
	ELSE
		DO snrtable WITH TRIM(x_pjxtmp.name)
	ENDIF ( x_pjxtmp.type = "P" OR x_pjxtmp.type="Q" )
ENDSCAN
*******************************************************
* Close project file and cursor
*******************************************************
SELECT x_pjxtmp
USE
SELECT x_orig
USE
WAIT CLEAR
*: EOF: SNRPROJ.PRG
