PARAMETERS pcHomeDir,pcFileName
********************************************
* This procedure is passed the "home" directory from
* a project file and uses it to determine a fully-
* qualified filename for any project element.
* Note that the project "element" for screen files
* must be the file indicated in the "OUTFILE" field,
* rather than the file in the NAME field.
********************************************
PRIVATE lcFile,lcHomeDir,lcHomDriv
IF SUBSTR(pcHomeDir,2,1)=":"
	lcHomeDriv=LEFT(pcHomeDir,2)
ELSE
	lcHomeDriv=SET("DEFAULT")
	IF ! ynalert("Use " + lcHomeDriv + " as HOME DRIVE?")
		CLOSE DATA
		RETURN
	ENDIF
ENDIF

IF RIGHT(pcHomeDir,1) = CHR(0)
	lcHomeDir=SUBSTR(pcHomeDir,1,LEN(pcHomeDir)-1)
ELSE
	lcHomeDir=pcHomeDir
ENDIF
IF RIGHT(lcHomeDir,1) = "\"
	lchomeDir=SUBSTR(lcHomeDir,1,LEN(lcHomeDir)-1)
ENDIF
lcFile=pcFileName
DO CASE
CASE LEFT(lcFile,1) = "\"
	* No drive spec
	lcFile=lcHomeDriv + ;
		TRIM(lcFile)
CASE ! (SUBSTR(lcFile,2,1) = ":" OR ;
		LEFT(lcFile,1) = "\"  OR ;
		LEFT(lcFile,3) = "..\")
	* Below home directory
	lcFile=lcHomeDir + "\" + ;
		TRIM(lcFile)
CASE LEFT(lcFile,3) = "..\"
	* Collateral Directory
	lcTmpName=lcFile
	lcTmpPath=lcHomeDir
	DO WHILE LEFT(lcTmpName,3) = "..\"
		lcTmpName=SUBSTR(lcTmpName,4)
		lcTmpPath=SUBSTR(lcTmpPath,1,RAT("\",lcTmpPath)-1)
	ENDDO
	IF LEFT(lcTmpName,2) # "\"
		lcTmpName="\" + lcTmpName
	ENDIF
	lcFile=lcTmpPath+lcTmpName
OTHERWISE
	* Do nothing = fully-qualified filename
ENDCASE
IF CHR(0) $ lcFile
	lcFile=STUFF(lcFile,AT(CHR(0),lcFile),1,"")
ENDIF ( CHR(0) $ lcFile )
RETURN lcFile	
	
