*:*****************************************************************************
*:
*: Procedure file: C:\FOXPRO\PROJECT\PRSEARCH\MEMOEDIT.PRG
*:         System: Project Search-and-Replace Utility
*:         Author: Stephen A. Sawyer
*:      Copyright (c) 1993, KarCal Company, Inc.
*:  Last modified: 04/29/93 at  8:32:06
*:
*:         Set by: SNRTABLE.PRG                      
*:
*:          Calls: STRGREPL.PRG
*:
*:      Documented 13:53:34                                FoxDoc version 3.00a
*:*****************************************************************************
*PROCEDURE memoedit
PARAMETERS pcSrchStr,pcField,plWords,plCase,pcTable
*******************************************************
* pcSrchStr = Search string
* pcField = memo field name
* plWords = .T. if searching for words only
* plCase = .T. if case-sensitive search
* pcTable = name of power-tool table
*******************************************************
IF plCase
	lnOccurs=OCCURS(pcSrchStr,EVALUATE(pcField))
ELSE
	lnOccurs=OCCURS(UPPER(pcSrchStr),;
		UPPER(EVALUATE(pcField)))
ENDIF ( plCase )
IF lnOccurs > 0
	llFound=.T.
	lnFound=1
	****************************************************
	* Determine position of the character preceding and
	* following the search string
	****************************************************
	IF plCase
		lnBegEdit = AT(pcSrchStr,;
			EVALUATE(pcField),lnFound)
	ELSE
		lnBegEdit = ATC(pcSrchStr,;
			EVALUATE(pcField),lnFound)
	ENDIF ( plCase )
	****************************************************
	* DO loop to repeat MODIFY MEMO command as long
	* as there are occurrences of the search string
	* left in the memo field.
	* lnBegEdit and lnEndEdit are used in the RANGE
	* clause of the MODIFY MEMO command.
	* The replacement string has been placed in 
	* _CLIPTEXT, and OKL's are set up which call
	* the STRGREPL procedure to paste _CLIPTEXT in 
	* place of the search string.  Note that STRGREPL
	* also *DECREMENTS* the lnFound memvar, as each
	* time a replacement occurs, there are one fewer
	* occurrences of the search string. Otherwise, the
	* the AT() function would fail to properly find
	* the next occurrence of the search string
	****************************************************
	DO WHILE llFound
		lnEndEdit = lnBegEdit + LEN(pcSrchStr)
		IF (plWords AND ! ;
			(ISALPHA(SUBSTR(EVALUATE(pcField),;
			lnBegEdit-1,1)) OR ;
			ISALPHA(SUBSTR(EVALUATE(pcField),;
			lnEndEdit,1)))) OR ! plWords
			ON KEY LABEL CTRL+E KEYBOARD "{ALT+E}"
			ON KEY LABEL CTRL+G KEYBOARD "{ALT+G}"
			ON KEY LABEL ALT+E DO strgrepl
			ON KEY LABEL ALT+G KEYBOARD CHR(23)
			MODIFY MEMO (pcField) RANGE ;
				lnBegEdit,lnEndEdit WINDOW wrEdit
			ON KEY LABEL ALT+E
			ON KEY LABEL ALT+G
			ON KEY LABEL CTRL+E 
			ON KEY LABEL CTRL+G 
			WAIT "Processing " + pcTable + ;
				"..." WINDOW NOWAIT
		ENDIF 
		lnFound=lnFound+1
		IF plCase
			lnBegEdit = AT(pcSrchStr,;
				EVALUATE(pcField),lnFound)
		ELSE
			lnBegEdit = ATC(pcSrchStr,;
				EVALUATE(pcField),lnFound)
		ENDIF ( plCase )
		IF lnBegEdit = 0
			llFound=.F.
		ENDIF ( lnBegEdit = 0 )
	ENDDO ( llFound )
ENDIF ( lnOccurs > 0 )
RETURN


*: EOF: MEMOEDIT.PRG
