*:*****************************************************************************
*:
*: Procedure file: C:\FOXPRO\PROJECT\LIBRARY\YNALERT.PRG
*:
*:         System: Utilities Library
*:         Author: Stephen A. Sawyer
*:      Copyright (c) 1993, KarCal Company, Inc.
*:  Last modified: 04/02/93     16:07
*:
*:  Procs & Fncts: YNALERT
*:
*:      Documented 04/02/93 at 16:15               FoxDoc  version 2.10f
*:*****************************************************************************
* Alert message allowing a yes-or-no response from the
* user -  "yes" is the default choice, and "no"
* selected with <Esc>, but can be substituted by passing
* a second numeric parameter, 1 specifies "Y" as the default, 2 specifies
* "N" as the default.  In both cases <Esc> selects the "No" option.
* Note that under FP/Win, the <Esc> key has no effect.
*
***********************************************************************
*!*****************************************************************************
*!
*!      Procedure: YNALERT
*!
*!
*!*****************************************************************************
*PROCEDURE ynalert
PARAMETERS pcMsg,pnDef
IF _DOS
	DO CASE
	CASE TYPE("pnDef")="L" OR pnDef=1
		winwidth=MAX((LEN(pcMsg) + 4),14)
		pr_strng = "*TH \!\<Yes;\?\<No"
		pb_width = 11
		ynans = 1
	CASE TYPE("pnDef")="N" AND pnDef=2
		winwidth=MAX((LEN(pcMsg) + 4),14)
		pr_strng = "*TH \<Yes;\!\?\<No"
		pb_width = 11
		ynans = 2
	ENDCASE 	
	lcol=40-INT(winwidth/2)
	rcol = lcol + winwidth
	lnMsgPos = INT((winwidth-LEN(pcMsg))/2)
	DEFINE WINDOW reply FROM 10,lcol TO 16,rcol DOUBLE COLOR SCHEME 7
	ACTIVATE WINDOW reply IN SCREEN
	@ 1,lnMsgPos SAY pcMsg
	@ 3,(winwidth-pb_width)/2 GET ynans FUNCTION EVALUATE("pr_strng")  DEFAULT ynans
	IF ynans=2
		KEYBOARD CHR(9)
	ENDIF
	READ
	IF ynans = 1
		alertreply = .T.
	ELSE
		alertreply = .F.
	ENDIF (ynans = 1)
	DEACTIVATE WINDOW reply
	RELEASE WINDOW reply
ELSE
	IF ! "FOXTOOLS" $ SET("LIBRARY")
		SET LIBRARY TO SYS(2004) + "FOXTOOLS.FLL" ADDITIVE
	ENDIF 
	DO CASE
	CASE TYPE("pnDef")="L" OR pnDef=1
		lnTypeSymbol=36 && YN and Question Mark "Yes" default
	CASE TYPE("pnDef")="N" AND pnDef=2
		lnTypeSymbol=292 && YN and Question Mark "No" default
	ENDCASE 	
	lnResult=MsgBox( pcMsg, "",lnTypeSymbol) 
	IF lnResult=6
		alertreply = .T.
	ELSE
		alertreply = .F.
	ENDIF
ENDIF
RETURN alertreply
************************************************
*: EOF: YNALERT.PRG
