*:*****************************************************************************
*:
*: Procedure file: C:\FOXPRO\PROJECT\PRSEARCH\OBJSCAN.PRG
*:         System: Project Search-and-Replace Utility
*:         Author: Stephen A. Sawyer
*:      Copyright (c) 1993, KarCal Company, Inc.
*:  Last modified: 05/06/93 at  8:52:11
*:
*:         Set by: SNRFILE.PRG                       
*:               : SNRTABLE.PRG                      
*:
*:          Calls: INDSTRIP.PRG
*:               : NOPATH.PRG
*:
*:      Documented 13:53:33                                FoxDoc version 3.00a
*:*****************************************************************************
*PROCEDURE objscan
PARAMETERS pcSrchStr,pcObject,pcFilename,plWords,;
	plCase,pcObjName
******************************************************
* pcSrchStr = search string
* pcObject = the memvar or memo field being examined
* pcFileName = the NAME of the file or memo field
*	Note that pcFileName is a file name when passed from
*	SNRFILE, but is a memo field name when passed from 
* 	SNRTABLE
* plWords = .T. if matching words, .F. otherwise
* plCase = .T. if case-sensitive search
* pcObjName = the type of power-tool object
*	(only passed from SNRTABLE)
******************************************************
lnLineCnt = 1
******************************************************
* Count total lines in pcObject
******************************************************

IF plCase
	lnOccurs=OCCURS(pcSrchStr,pcObject)
ELSE
	lnOccurs=OCCURS(UPPER(pcSrchStr),UPPER(pcObject))
ENDIF ( plCase )
IF lnOccurs # 0
	lnObjLines=MEMLINES(pcObject)
	_MLINE = 0
	lnFound=0
	lnThChg=INT(lnObjLInes/10)
	lnThCtr=0
	IF TYPE("x_pjxtmp.name")="C"
		WAIT "Processing " + TRIM(NOPATH(x_pjxtmp.name)) + SPACE(11) WINDOW NOWAIT
	ENDIF
	FOR lnLineNo = 1 TO lnObjLines
		IF lnLineNo >=lnThChg
			lnThChg=lnThChg + INT(lnObjLines/10)
			lnThCtr=lnThCtr+1
			lcTherm=PADR(REPLICATE(".",lnThCtr),10)
			IF TYPE("x_pjxtmp.name") = "C"
				WAIT "Processing " + TRIM(NOPATH(x_pjxtmp.name)) + " " +lcTherm WINDOW NOWAIT
			ENDIF
		ENDIF
		*******************************************
		* Get current line
		*******************************************
		lcLookIn = MLINE(pcObject,1,_MLINE)
		*******************************************
		* Check if first non-indenting character is
		* an asterisk - ignore comments
		*******************************************
		IF LEFT(INDSTRIP(lcLookIn),1)="*"
			LOOP
		ENDIF ( LEFT(INDSTRIP(lcLookIn),1)="*" )
		*******************************************
		* Check for occurrences in current line
		* respecting case preference
		*******************************************
		IF plCase AND pcSrchStr $ lcLookin OR ;
				(! plCase AND UPPER(pcSrchStr) $ ;
				UPPER(lcLookIn))
			***************************************
			* Increment lnFound memvar, and determine
			* position of the character preceding and
			* following the search string
			***************************************
			lnFound=lnFound+1
			lnBegEdit = AT(UPPER(pcSrchStr),;
				UPPER(pcObject),lnFound)
			lnEndEdit = lnBegEdit + LEN(pcSrchStr)
			***************************************
			* If user has requested word search only,
			* check if characters at lnBegEdit and 
			* lnEndEdit are alpha characters
			***************************************
			IF plWords
				IF ISALPHA(SUBSTR(pcObject,;
					lnBegEdit-1,1)) OR ;
					ISALPHA(SUBSTR(pcObject,;
					lnEndEdit,1))
					llMatch=.F.
				ELSE
					llMatch=.T.
				ENDIF 
			ELSE
				llMatch=.T.
			ENDIF ( plWords )
			***************************************
			* If the search string is found, record
			* information on where the string is found
			* in the array laLines, including the 
			* entire line in which the search string
			* is found (removing indenting chars),
			* the line number, the file name, the memo
			* field name and the power-tool table type
			* (if appropriate)
			***************************************
			IF llMatch
				lnLineLst = lnLineLst+1
				IF lnLineLst > ALEN(laLines,1)
					DIMENSION laLines(lnLineLst,1)
				ENDIF ( lnLineLst > ALEN(laLines,1) )
				lcLookIn=indstrip(lcLookIn)
				laLines(lnLineLst,1)=NOPATH(DBF(1)) + ;
					" " + IIF(RIGHT(NOPATH(DBF(3)),3)=;
					"TMP","",NOPATH(DBF(3)) + " ") ;
					 + TRIM(pcObjName) + " (" + ;
					 NOPATH(pcFilename) + ") " + ;
					"Line " + LTRIM(STR(lnLineNo)) + ;
					" - " + lcLookIn
			ENDIF ( llMatch )
		ENDIF ( plCase AND pcSrchStr $ lcLookin OR ; )
	NEXT ( lnLineNo )
ENDIF ( lnOccurs # 0 )
RETURN
*: EOF: OBJSCAN.PRG
