
* PROGRAM.: JOB.PRG
* Author..: Louis P. Witt,Jr.
* Date....: 06/05/88   2:49 pm
* Notice..: Copyright (c) 1988, Louis P. Witt,Jr., All Rights Reserved
* Version.: Single User FoxBase Plus 2.1
* Notes...: Setup File Maintanence Utility

* environment setup
SET EXACT OFF
SET HEADING OFF
SET BELL OFF
SET DELETED ON
SET TALK OFF
SET STATUS OFF
SET SCOREBOARD OFF
SET COLOR TO  W/N,N/W
SET ESCAPE OFF
SET DECIMALS TO 6
SET SAFETY OFF
SET PROCEDURE TO JOB
SET MENU OFF

* context detection
job_userid = GETENV('USERID')
job_pathis = GETENV('PATH')
job_userid = LEFT(LTRIM(TRIM(job_userid))+"XXXXX",5)
IF LEN(job_pathis)>0
  SET PATH TO &job_pathis
ENDIF

job_clrmon = ISCOLOR()
SET FUNCTION 2 TO CHR(23)

* COLOR CONTROL SETUP
IF job_clrmon
  * establish programmed (color) control parameters
  job_scrclr = 'R+/N,N/W'
  job_staclr = 'R+/N,N/W'
  job_winclr = 'R+/N,N/W'
  job_proclr = 'GR+/N,N/W'
  job_hilclr = 'N/W'
ELSE
  * establish monochrome substitutes
  job_scrclr = 'W+/N,N/W'
  job_staclr = 'W/N,N/W'
  job_winclr = 'W/N,N/W'
  job_proclr = 'W+/N,N/W'
  job_hilclr = 'N/W'
ENDIF

SET COLOR TO &job_scrclr
@ 0,0 CLEAR TO 24,79  && in case of color change

* show signon message
@ 3,31 SAY "JOB Setup Version"
@ 4,26 SAY "Written By Louis P. Witt,Jr."
@ 5,11 SAY "Copyright (c) 1988 Louis P. Witt,Jr., All Rights Reserved"
@ 7,0 SAY ''

* continuous status items
job_norecs  = .F.    && true if empty file
job_filsok  = .T.    && true if files okay
job_filnum  = 1      && current file number
job_filmax  = 1 && maximum file number
job_scrnum  = 0      && current screen number
job_inmemo  = .F.    && true if editing a memo

* supporting utilities
job_inhelp  = .F.    && true if inside help system
job_rtype = ''       && report type
job_rfile = ''       && report name
job_rlbry = ''       && report library filename (R&R)
job_rtail = ''       && report command tail (R&R)

* input associated items
job_readdn  = .T.    && during read, true if exit key means done
job_upkeys  =  CHR(6) && means go to lower page
job_dnkeys  =  CHR(7)+CHR(15)+CHR(16) && means go to higher page
job_exkeys  =  CHR(12)+CHR(14) && means exit read
job_giveup  = .F.    && true if user gives up edit
job_duprec  = .F.    && true if duplicate primary key
job_rvalid  = .T.    && true if data is valid
job_fltgrp  = 0      && group code for filtering

* miscellaneous items
job_number  = ''     && used to expand a number macro
job_filwas  = 0      && used in gather,slash,report
job_scrwas  = 0      && used in report system
job_scrsav  = ''     && used for windows
job_dohelp  = .F.    && trap F1 as menu input key
*  current database associated items
job_xdfnm   = ''     && file name of current
job_xdals   = ''     && alias of current
job_xllst   = ''     && field list for LIST command
job_lwas    = ''     && list save
job_xlast   = 0      && last record number positioned to
job_xfpgs   = ''     && available pages in current
job_xfpag   = 0      && current page number
job_xmenu   = ''     && menu exemptions commands
job_mwas    = ''     && menu save

* for filter
job_xfstr   = ''     && filter expression
job_xfrem   = ''     && filter remark
job_xfflg   = .T.    && true if filtered

* for primary index
job_xidxd   = .F.    && true if has primary index
job_xifnm   = ''     && file name of primary  index
job_xuniq   = .F.    && true if primary is unique
job_xfill   = .F.    && true if primary is non-blank
job_xmkey   = ''     && memvar key expander for primary
job_xfkey   = ''     && field key expander for primary
job_xnkey   = ''     && null key constant for primary
job_xckey   = ''     && trimmed job_xmkey for primary

* for current order
job_xiord   = 0      && order number of index
job_xilst   = ''     && field list of current
job_xikey   = ''     && memvar index key
job_xbkey   = ''     && blank key constant

* menu associated items
job_option  = ''     && main menu selection
job_choice  = ''     && sub menu selection
job_confrm  = ''     && sub menu confirmation
job_offerd  = ''     && menu items offered

* user variable declarations
      TODAY      = CTOD('  /  /  ')
      JDUE       = 0


* file declarations
* Static declarations
job_dfnm= .F.
job_dals= .F.
job_used= .F.
job_llst= .F.
job_last= .F.
job_fpgs= .F.
job_fpag= .F.
job_menu= .F.
job_fstr= .F.
job_frem= .F.
job_fflg= .F.
job_idxd= .F.
job_ifnm= .F.
job_uniq= .F.
job_fill= .F.
job_mkey= .F.
job_fkey= .F.
job_nkey= .F.
job_ckey= .F.
job_iord= .F.
job_ilst= .F.
job_ikey= .F.
job_bkey= .F.

DO job_FSET  && fill arrays with values
* verify and index files
DO job_FCHK WITH 1,job_filmax,.F.
CLOSE DATABASES
IF .NOT. job_filsok  && * abort if missing databases
  DO job_DSPM WITH 'Press any key'
  CLOSE DATABASES
  RETURN
ENDIF

* declare automem variables
job_filnum = 1
DO WHILE job_filnum <= 1
  DO CASE
    CASE job_filnum = 1
      JCLIENT    = SPACE(32)
      JADDR      = SPACE(32)
      JPOB       = SPACE(32)
      JCITY      = SPACE(18)
      JSTATE     = SPACE(2)
      JZIP       = SPACE(10)
      JBUSINESS  = SPACE(32)
      JHRATE     = 0.00
      JDRATE     = 0.00
      JTERMS     = SPACE(32)
      JPHONE     = SPACE(13)
      JCONT1     = SPACE(32)
      JEXT1      = SPACE(5)
      JCONT2     = SPACE(32)
      JEXT2      = SPACE(5)
      JCREM      = SPACE(32)
      JCNOTES_   = 'memo'
      JOB        = SPACE(10)
      JQUOTED    = CTOD('  /  /  ')
      JACCEPTED  = CTOD('  /  /  ')
      JSTARTED   = CTOD('  /  /  ')
      JCOMPLETED = CTOD('  /  /  ')
      JDEADLINE  = CTOD('  /  /  ')
      JQUOTE     = 0.00
      JADJUST    = 0.00
      JNET       = 0.00
      JPAID      = 0.00
      JLEFT      = 0.00
      JCOST      = 0.00
      JCASH      = 0.00
      JDRAW      = 0.00
      JCHECK     = 0.00
      JPROFIT    = 0.00
      JTASK      = SPACE(32)
      JTEXT_     = 'memo'
      JBD1       = CTOD('  /  /  ')
      JT1        = SPACE(36)
      JH1        = 0.00
      JR1        = 0.00
      JB1        = 0.00
      JC1        = 0.00
      JBD2       = CTOD('  /  /  ')
      JT2        = SPACE(36)
      JH2        = 0.00
      JR2        = 0.00
      JB2        = 0.00
      JC2        = 0.00
      JBD3       = CTOD('  /  /  ')
      JT3        = SPACE(36)
      JH3        = 0.00
      JR3        = 0.00
      JB3        = 0.00
      JC3        = 0.00
      JBD4       = CTOD('  /  /  ')
      JT4        = SPACE(36)
      JH4        = 0.00
      JR4        = 0.00
      JB4        = 0.00
      JC4        = 0.00
      JBD5       = CTOD('  /  /  ')
      JT5        = SPACE(36)
      JH5        = 0.00
      JR5        = 0.00
      JB5        = 0.00
      JC5        = 0.00
      JHOURS     = 0.00
      JBID       = 0.00
      JRATE      = 0.00
      JAMEMO_    = 'memo'
      JAD1       = CTOD('  /  /  ')
      JAOB1      = SPACE(8)
      JA1        = SPACE(45)
      JAA1       = 0.00
      JAD2       = CTOD('  /  /  ')
      JAOB2      = SPACE(8)
      JA2        = SPACE(45)
      JAA2       = 0.00
      JAD3       = CTOD('  /  /  ')
      JAOB3      = SPACE(8)
      JA3        = SPACE(45)
      JAA3       = 0.00
      JAD4       = CTOD('  /  /  ')
      JAOB4      = SPACE(8)
      JA4        = SPACE(45)
      JAA4       = 0.00
      JAD5       = CTOD('  /  /  ')
      JAOB5      = SPACE(8)
      JA5        = SPACE(45)
      JAA5       = 0.00
      JDC1       = SPACE(32)
      JOK1       = .F.
      JDD1       = CTOD('  /  /  ')
      JDA1       = 0.00
      JCK1       = SPACE(6)
      JCD1       = CTOD('  /  /  ')
      JP1        = 0.00
      JDC2       = SPACE(32)
      JOK2       = .F.
      JDD2       = CTOD('  /  /  ')
      JDA2       = 0.00
      JCK2       = SPACE(6)
      JCD2       = CTOD('  /  /  ')
      JP2        = 0.00
      JDC3       = SPACE(32)
      JOK3       = .F.
      JDD3       = CTOD('  /  /  ')
      JDA3       = 0.00
      JCK3       = SPACE(6)
      JCD3       = CTOD('  /  /  ')
      JP3        = 0.00
      JDC4       = SPACE(32)
      JOK4       = .F.
      JDD4       = CTOD('  /  /  ')
      JDA4       = 0.00
      JCK4       = SPACE(6)
      JCD4       = CTOD('  /  /  ')
      JP4        = 0.00
      JDC5       = SPACE(32)
      JOK5       = .F.
      JDD5       = CTOD('  /  /  ')
      JDA5       = 0.00
      JCK5       = SPACE(6)
      JCD5       = CTOD('  /  /  ')
      JP5        = 0.00
  ENDCASE
  job_filnum = job_filnum + 1
ENDDO


* declare help keys
  ON KEY=315 DO job_HELP

* screen boot
CLEAR
job_filnum = 1
DO job_OPEN
job_xfpag = 1
job_scrnum = ASC(job_xfpgs)
DO job_DSPS

* PROCESSING LOOP
DO WHILE job_filnum > 0
  IF EOF()
    DO job_DSPQ WITH "Scanning"
    GO TOP
  ENDIF
  DO job_FTST
  job_xlast = RECNO()
  job_norecs = EOF()
  * database is EMPTY if eof() = .T.
  IF job_norecs
    DO job_DRPS    && so we don't show old
    DO job_DSPS
    DO job_CLRF
    DO job_CLRC
  ELSE
    DO job_LDVR
    DO job_DSPR
  ENDIF
  DO job_STAT
  IF job_clrmon
    SET COLOR TO &job_staclr
    @ 22, 0 CLEAR TO 24,79
    @ 22, 0 SAY "Retrieve Order   Begin Previous Skip Next End"
    @ 22,48 SAY "Modify Add Copy  /Menu "
*   @ 22,72 SAY "... user defined #1
    @ 23, 0 SAY "Delete  Gather   Filter Tally List Write Help"
    @ 23,48 SAY "View  Zoom <Page> Quit"
*   @ 23,72 SAY "... user defined #2
  ELSE
    @ 22,0 CLEAR TO 23,79
  ENDIF
  job_offerd = ''
  SET COLOR TO &job_proclr
  IF (LEN(job_xfpgs)>1) .AND.(.NOT. (('<' $ job_xmenu) .OR. ('>' $ job_xmenu)))
    @ 23,60 SAY 'Page'
  ENDIF
job_dohelp = .T.
DO WHILE job_dohelp
    SET MESSAGE TO 24
    IF .NOT.  (job_norecs .OR. 'R' $ job_xmenu)
      @ 22, 0 PROMPT 'Retrieve';
      MESSAGE 'Retrieve a record by key value'
      job_offerd = job_offerd + 'R'
    ENDIF
    IF .NOT. (job_norecs .OR. 'O' $  job_xmenu)
      @ 22, 9 PROMPT 'Order';
      MESSAGE 'Order using another index'
      job_offerd = job_offerd + 'O'
    ENDIF
    IF .NOT. (job_norecs .OR. 'B' $ job_xmenu)
      @ 22,17 PROMPT 'Begin';
      MESSAGE 'Go to the beginning record'
      job_offerd = job_offerd + 'B'
    ENDIF
    IF .NOT. (job_norecs .OR. 'P' $ job_xmenu)
      @ 22,23 PROMPT 'Previous';
      MESSAGE 'Go to the previous record in the file'
      job_offerd = job_offerd + 'P'
    ENDIF
    IF .NOT. (job_norecs .OR. 'S' $ job_xmenu)
      @ 22,32 PROMPT 'Skip';
      MESSAGE 'Skip forward/backward by record count'
      job_offerd = job_offerd + 'S'
    ENDIF
    IF .NOT. (job_norecs .OR. 'N' $ job_xmenu)
      @ 22,37 PROMPT 'Next';
      MESSAGE 'Go to the next record in the file'
      job_offerd = job_offerd + 'N'
    ENDIF
    IF .NOT. (job_norecs .OR. 'E' $ job_xmenu)
      @ 22,42 PROMPT 'End';
      MESSAGE 'Go to the end of the file'
      job_offerd = job_offerd + 'E'
    ENDIF
    IF .NOT. (job_norecs .OR. 'M' $ job_xmenu)
      @ 22,48 PROMPT 'Modify';
      MESSAGE 'Modify the contents of this record'
      job_offerd = job_offerd + 'M'
    ENDIF
    IF .NOT. ('A' $ job_xmenu)
      @ 22,55 PROMPT 'Add';
      MESSAGE 'Add a new record to the file'
      job_offerd = job_offerd + 'A'
    ENDIF
    IF .NOT. (job_norecs .OR. 'C' $ job_xmenu)
      @ 22,59 PROMPT 'Copy';
      MESSAGE 'Copy this record to a new record and Modify'
      job_offerd = job_offerd + 'C'
    ENDIF
    IF .NOT. ('/' $ job_xmenu)
      @ 22,65 PROMPT '/Menu';
      MESSAGE 'Secondary function menu'
      job_offerd = job_offerd + '/'
    ENDIF
  * add user defined #1
    IF .NOT. (job_norecs .OR. 'D' $ job_xmenu)
      @ 23, 0 PROMPT 'Delete';
      MESSAGE 'Delete this record, or a group of records'
      job_offerd = job_offerd + 'D'
    ENDIF
    IF .NOT. ('G' $ job_xmenu)
      @ 23, 8 PROMPT 'Gather';
      MESSAGE 'Gather active data to compress files'
      job_offerd = job_offerd + 'G'
    ENDIF
    IF .NOT. (job_norecs .OR. 'F' $ job_xmenu)
      @ 23,17 PROMPT 'Filter';
      MESSAGE 'Filter the visible record set'
      job_offerd = job_offerd + 'F'
    ENDIF
    IF .NOT. (job_norecs .OR. 'T' $ job_xmenu)
      @ 23,24 PROMPT 'Tally';
      MESSAGE 'Count the number of visible records'
      job_offerd = job_offerd + 'T'
    ENDIF
    IF .NOT. (job_norecs .OR. 'L' $ job_xmenu)
      @ 23,30 PROMPT 'List';
      MESSAGE 'List records in full page mode'
      job_offerd = job_offerd + 'L'
    ENDIF
    IF .NOT. (job_norecs .OR. 'W' $ job_xmenu)
      @ 23,35 PROMPT 'Write';
      MESSAGE 'Write data to a report, the screen, or external file'
      job_offerd = job_offerd + 'W'
    ENDIF
    IF .NOT. ('H' $ job_xmenu)
      @ 23,41 PROMPT 'Help';
      MESSAGE 'Display help for this system'
      job_offerd = job_offerd + 'H'
    ENDIF
    IF job_xfpag>1  .AND. .NOT. ('<' $ job_xmenu)
      @ 23,59 PROMPT '<';
      MESSAGE 'Display the previous page of this record'
      job_offerd = job_offerd + '<'
    ENDIF
    IF job_xfpag<LEN(job_xfpgs) .AND. .NOT. ('>' $ job_xmenu)
      @ 23,64 PROMPT '>';
      MESSAGE 'Display the next page of this record'
      job_offerd = job_offerd + '>'
    ENDIF
    IF .NOT. ('Q' $ job_xmenu)
      @ 23,66 PROMPT 'Quit';
      MESSAGE 'Quit this program'
      job_offerd = job_offerd + 'Q'
    ENDIF
  * add user defined #2
    MU_ = AT(job_option,job_offerd) && default to previous
    MENU TO MU_
  job_dohelp =  (READKEY()=36 .OR. READKEY()=292)
  IF job_dohelp
    DO job_HLPL
  ENDIF
ENDDO
  job_option = SUBSTR('Q'+job_offerd,MU_+1,1)
  @ 22, 0 CLEAR TO 23,79
  DO CASE
* add user defined #1,#2 wherever
   CASE job_option = 'A'
     * add
     DO job_ADDR
   CASE job_option = 'B'
     * Beginning
     DO job_DSPQ WITH "Scanning"
     GO TOP
   CASE job_option = 'C'
     * Copy
     DO job_ADDR
   CASE job_option = 'D'
     * delete
     DO job_DELR
   CASE job_option = 'E'
     * End
     DO job_DSPQ WITH "Scanning"
     GO BOTTOM
   CASE job_option = 'F'
     * filter
     DO job_FILT
   CASE job_option = 'G'
     * gather
     DO job_GTHR
   CASE job_option = 'H'
     * Help
     DO job_HLPR
   CASE job_option = '/'
      * slash menu
      DO job_SLSH
* J available
* K available
   CASE job_option = 'L'
     * list
     DO job_LIST WITH job_xllst
   CASE job_option = 'M'
     * Modify
     DO job_ADDR
   CASE job_option = 'N'
     * Next
     DO job_DSPQ WITH "Scanning"
     SKIP
     IF EOF()
       GO BOTTOM
       DO job_DSPM WITH 'Last record'
     ENDIF
   CASE job_option = 'O'
     * Order
     DO job_ORDR
   CASE job_option = 'P'
     * Previous
     DO job_DSPQ WITH "Scanning"
     SKIP -1
     IF BOF()
       GO TOP
       DO job_DSPM WITH 'First record'
     ENDIF
   CASE job_option = 'Q'
     * Quit
     DO job_QUIT
   CASE job_option = 'R'
     * retrieve
     DO job_RETR
   CASE job_option = 'S'
     * Skip
     DO job_SKIP
   CASE job_option = 'T'
     * Tally
     DO job_TLLY
   CASE job_option = 'W'
     * write
     DO job_WRTE
* X available
* Y available
   CASE job_option = '<'
     * prev page
     DO job_PLWR
   CASE job_option = '>'
     * next page
     DO job_PHIR
  ENDCASE
  * Final Quit
  IF job_option = 'Q'
    job_filnum = 0
  ENDIF
ENDDO && WHILE job_filnum > 0
SET COLOR TO &job_winclr
CLOSE DATABASES
RETURN

* PROCEDURES - GROUPED ALPHABETICALLY

PROCEDURE job_ADDR
* Add, Copy, or Modify
job_giveup = .F.
job_rvalid = .F.
job_rloops = .F.  && indicates looping through edit
DO WHILE .NOT. (job_rvalid .OR. job_giveup)
  * edit/validate loop
  DO job_EDIT WITH job_rloops
  job_rloops = .T.   && if we come back, don't re-initialize
  job_badnum = job_scrnum && generics stay on current screen
  * validate the record
  DO job_DSPQ WITH "Validating"
  SET COLOR TO &job_proclr
  @ 22, 0 CLEAR TO 24,79    && clear the bottom
  job_rvalid  = .T.   && presume success
  IF job_xfill
    IF job_xnkey = &job_xckey
      * blank key
      @ 22,0 SAY 'Blank index keys prohibited'
      job_rvalid = .F.
    ENDIF
  ENDIF
  IF job_rvalid
    * check duplicate keys
    job_duprec   = .F.
    IF job_xuniq
      SET ORDER TO 1
      IF .NOT. job_norecs
        SEEK &job_xmkey
      ENDIF
      IF job_option = 'M'
        job_duprec = job_xlast <> RECNO() .AND. .NOT. EOF()
      ELSE
        job_duprec = .NOT. EOF()
      ENDIF
      IF .NOT. job_norecs
        GO job_xlast
      ENDIF
      SET ORDER TO job_xiord
    ENDIF && uniq checks
    IF job_duprec
      * duplicate record
      @ 22,0 SAY 'Duplicate index key prohibited'
      job_rvalid = .F.
    ELSE
      DO job_DSPC
    ENDIF && job_duprec
  ENDIF  && job_rvalid
  job_giveup  = .F.
  IF .NOT. job_rvalid
    * something failed along the way
    IF job_badnum <> job_scrnum
      * bring up the screen with the problem
      DO job_DRPS && put back current
      job_scrnum = job_badnum
      job_xfpag = AT(CHR(job_scrnum),job_xfpgs)
      DO job_DSPS
      DO job_STAT
      IF job_OPTION $ 'AC'
        DO job_CLRF
        DO job_CLRC
      ENDIF
      DO job_GFLD
    ENDIF && page switch
    SET COLOR TO &job_winclr
job_dohelp = .T.
DO WHILE job_dohelp
      @ 23, 0 CLEAR TO 24,79
      SET MESSAGE TO 24
      @ 23, 0 SAY 'Invalid entries are present. Correct them?  Yes No'
      SET COLOR TO &job_proclr
      @ 23,44 PROMPT 'Yes' MESSAGE "Yes, re-edit this"
      @ 23,48 PROMPT 'No'  MESSAGE "No, abandon this"
      MU_A = 0
      MENU TO MU_A
  job_dohelp =  (READKEY()=36 .OR. READKEY()=292)
  IF job_dohelp
    DO job_HLPL
  ENDIF
ENDDO
    job_choice = SUBSTR("YYN",MU_A+1,1)
    @ 23, 0 CLEAR TO 23,79
    IF job_choice = 'N'
      job_giveup = .T.
    ENDIF
  ENDIF && .NOT. job_rvalid
  SET COLOR TO &job_winclr
  IF job_rvalid
job_dohelp = .T.
DO WHILE job_dohelp
      SET COLOR TO &job_winclr
      @ 22, 0 CLEAR TO 24,79
      SET MESSAGE TO 23
      @ 22, 0 SAY 'Save this information?  Yes No'
      SET COLOR TO &job_proclr
      @ 22,24 PROMPT 'Yes' MESSAGE "Yes, save this information"
      @ 22,28 PROMPT 'No'  MESSAGE "No, abandon this information"
      MU_A = 0
      MENU TO MU_A
  job_dohelp =  (READKEY()=36 .OR. READKEY()=292)
  IF job_dohelp
    DO job_HLPL
  ENDIF
ENDDO
    job_choice =SUBSTR("XYN",MU_A+1,1)
    @ 22, 0 CLEAR TO 23,79
    IF job_choice = 'Y'
      job_rvalid = .T.  && so we can fall out of the loop
      IF job_option <> 'M'
        APPEND BLANK
      ENDIF
      DO job_REPR
      job_norecs = .F.
      IF job_xfflg
        * Check to see if record matches FILTER
        job_xlast = RECNO()
        SKIP
        SKIP -1
        IF RECNO() <> job_xlast
          GO TOP
          IF EOF()
            DO job_FTST
            GO job_xlast
          ENDIF && EOF()
        ENDIF && RECNO() <> job_xlast
      ENDIF && job_xfflg
    ENDIF && job_choice = 'Y'
    IF job_choice='N'
      job_giveup = .T.
      IF .NOT. job_norecs
        GO job_xlast
      ENDIF
    ENDIF && job_choice = 'N'
    IF job_choice='X'
      job_rvalid = .F.   && so we stay in loop
      job_giveup = .F.
    ENDIF && job_choice = 'X'
  ENDIF && job_rvalid
  @ 22, 0 CLEAR TO 24,79
ENDDO && .NOT. (job_rvalid .OR. job_giveup)
RETURN   && job_ADDR

PROCEDURE job_CLS1
PARAMETERS job_fnm
* close specified file, retain record context
  job_number = LTRIM(STR(job_fnm))
  IF job_used
    SELECT  &job_number
    job_used = .F.
    job_last =  RECNO() && parents will retain context
    USE
  ENDIF
RETURN

PROCEDURE job_CLSA
* close all open files, retain record positions
job_fnm = 1
DO WHILE job_fnm <= job_filmax
  DO job_CLS1 WITH job_fnm
  job_fnm = job_fnm+1
ENDDO
CLOSE DATABASES
RETURN

PROCEDURE job_CHKM
PARAMETERS job_vname
  * build a macro for brother and fields name
  job_BRO = "M->"+job_vname+"_"
  IF &job_BRO $ 'Memo memo'  && he didn't press space
    RETURN .T.               && just carry on with read
  ENDIF
  * edit the memo field within READ
  job_inmemo = .T.
  SAVE SCREEN  && so we don't screw up the screen
  * stuff keyboard to force an edit
  KEYBOARD chr(31)+CHR(23)      && force a ^pageup THEN ^W THEN 'M'
  SET COLOR TO X/X,X/X          && don't show colors
  BROWSE FIELDS &job_vname NOMENU && slick trick
  SET COLOR TO &job_winclr
  RESTORE SCREEN  && back the way it was
  KEYBOARD 'M'
  job_inmemo = .F.
RETURN .F.

PROCEDURE job_CLOS
* Close the current database
  DO job_XSAV && so we can re-open later
  DO job_CLSA && close all databases
RETURN

PROCEDURE job_CLRC
* Clear computed screen areas
SET COLOR TO &job_winclr
  DO CASE
    CASE job_scrnum =1
    CASE job_scrnum =2
      DO job_COLR WITH "N/W"
      @   8, 32 SAY SPACE(8)
      @   7, 11 SAY SPACE(8)
      @   8, 11 SAY SPACE(8)
      @  10, 11 SAY SPACE(8)
      @  11, 11 SAY SPACE(8)
      @  13, 11 SAY SPACE(8)
      @  16, 11 SAY SPACE(8)
      @  17, 11 SAY SPACE(8)
      @  19, 11 SAY SPACE(8)
      @  11, 31 SAY SPACE(8)
      @  12, 31 SAY SPACE(8)
      @  13, 31 SAY SPACE(8)
      @  16, 31 SAY SPACE(8)
      @  17, 31 SAY SPACE(8)
      @  19, 31 SAY SPACE(8)
    CASE job_scrnum =3
      DO job_COLR WITH "N/W"
      @  15, 62 SAY SPACE(7)
      @  16, 62 SAY SPACE(7)
      @  17, 62 SAY SPACE(7)
      @  18, 62 SAY SPACE(7)
      @  19, 62 SAY SPACE(7)
      @  11, 49 SAY SPACE(5)
      @  11, 61 SAY SPACE(8)
      @  11, 55 SAY SPACE(5)
      @  11, 70 SAY SPACE(8)
      @   9, 70 SAY SPACE(8)
    CASE job_scrnum =4
      DO job_COLR WITH "N/W"
      @  12, 70 SAY SPACE(8)
    CASE job_scrnum =5
      DO job_COLR WITH "N/W"
      @   8,  8 SAY SPACE(8)
      @   7, 66 SAY SPACE(13)
      @   8, 27 SAY SPACE(32)
      @   8, 66 SAY SPACE(5)
      @   9, 27 SAY SPACE(32)
      @   9, 66 SAY SPACE(5)
      @  19,  8 SAY SPACE(8)
      @  19, 21 SAY SPACE(8)
      @  19, 34 SAY SPACE(8)
      @  19, 48 SAY SPACE(8)
      @  19, 70 SAY SPACE(8)
      @   9,  8 SAY SPACE(8)
    CASE job_scrnum =6
    CASE job_scrnum =7
    CASE job_scrnum =8
  ENDCASE
RETURN

PROCEDURE job_CLRF
* Clear screen field areas
SET COLOR TO &job_winclr
  DO CASE
    CASE job_scrnum =1
      DO job_COLR WITH ",N/W"
      @   2, 47 Say Space(32)
      @   3, 47 Say Space(32)
      @   4, 47 Say Space(32)
      @   5, 47 Say Space(18)
      @   5, 66 Say Space(2)
      @   5, 69 Say Space(10)
      @   7, 47 Say Space(32)
      @   8, 47 Say Space(5)
      @   8, 65 Say Space(6)
      @   9, 47 Say Space(32)
      @  11, 60 Say Space(13)
      @  12, 41 Say Space(32)
      @  12, 74 Say Space(5)
      @  13, 41 Say Space(32)
      @  13, 74 Say Space(5)
      @  15, 41 Say Space(32)
      @  15, 75 Say Space(4)
    CASE job_scrnum =2
      DO job_COLR WITH ",N/W"
      @   2,  9 Say Space(32)
      @   4,  8 Say Space(10)
      @   4, 32 Say Space(8)
      @   5, 32 Say Space(8)
      @   6, 32 Say Space(8)
      @   7, 32 Say Space(8)
    CASE job_scrnum =3
      DO job_COLR WITH ",N/W"
      @   9,  5 Say Space(10)
      @   9, 23 Say Space(32)
      @  11,  2 Say Space(8)
      @  11, 11 Say Space(32)
      @  11, 44 Say Space(4)
      @  15,  2 Say Space(8)
      @  15, 11 Say Space(36)
      @  15, 49 Say Space(5)
      @  15, 55 Say Space(5)
      @  15, 71 Say Space(7)
      @  16,  2 Say Space(8)
      @  16, 11 Say Space(36)
      @  16, 49 Say Space(5)
      @  16, 55 Say Space(5)
      @  16, 71 Say Space(7)
      @  17,  2 Say Space(8)
      @  17, 11 Say Space(36)
      @  17, 49 Say Space(5)
      @  17, 55 Say Space(5)
      @  17, 71 Say Space(7)
      @  18,  2 Say Space(8)
      @  18, 11 Say Space(36)
      @  18, 49 Say Space(5)
      @  18, 55 Say Space(5)
      @  18, 71 Say Space(7)
      @  19,  2 Say Space(8)
      @  19, 11 Say Space(36)
      @  19, 49 Say Space(5)
      @  19, 55 Say Space(5)
      @  19, 71 Say Space(7)
    CASE job_scrnum =4
      DO job_COLR WITH ",N/W"
      @  12, 10 Say Space(10)
      @  12, 21 Say Space(4)
      @  12, 33 Say Space(32)
      @  15,  7 Say Space(8)
      @  15, 16 Say Space(8)
      @  15, 25 Say Space(45)
      @  15, 71 Say Space(7)
      @  16,  7 Say Space(8)
      @  16, 16 Say Space(8)
      @  16, 25 Say Space(45)
      @  16, 71 Say Space(7)
      @  17,  7 Say Space(8)
      @  17, 16 Say Space(8)
      @  17, 25 Say Space(45)
      @  17, 71 Say Space(7)
      @  18,  7 Say Space(8)
      @  18, 16 Say Space(8)
      @  18, 25 Say Space(45)
      @  18, 71 Say Space(7)
      @  19,  7 Say Space(8)
      @  19, 16 Say Space(8)
      @  19, 25 Say Space(45)
      @  19, 71 Say Space(7)
    CASE job_scrnum =5
      DO job_COLR WITH ",N/W"
      @   7,  6 Say Space(10)
      @   7, 27 Say Space(32)
      @  12,  2 Say Space(32)
      @  12, 35 Say Space(1)
      @  12, 37 Say Space(8)
      @  12, 46 Say Space(7)
      @  12, 55 Say Space(6)
      @  12, 62 Say Space(8)
      @  12, 71 Say Space(7)
      @  13,  2 Say Space(32)
      @  13, 35 Say Space(1)
      @  13, 37 Say Space(8)
      @  13, 46 Say Space(7)
      @  13, 55 Say Space(6)
      @  13, 62 Say Space(8)
      @  13, 71 Say Space(7)
      @  14,  2 Say Space(32)
      @  14, 35 Say Space(1)
      @  14, 37 Say Space(8)
      @  14, 46 Say Space(7)
      @  14, 55 Say Space(6)
      @  14, 62 Say Space(8)
      @  14, 71 Say Space(7)
      @  15,  2 Say Space(32)
      @  15, 35 Say Space(1)
      @  15, 37 Say Space(8)
      @  15, 46 Say Space(7)
      @  15, 55 Say Space(6)
      @  15, 62 Say Space(8)
      @  15, 71 Say Space(7)
      @  16,  2 Say Space(32)
      @  16, 35 Say Space(1)
      @  16, 37 Say Space(8)
      @  16, 46 Say Space(7)
      @  16, 55 Say Space(6)
      @  16, 62 Say Space(8)
      @  16, 71 Say Space(7)
    CASE job_scrnum =6
    CASE job_scrnum =7
    CASE job_scrnum =8
  EndCase
RETURN

PROCEDURE job_COLR
PARAMETERS job_colval
* Set a color value from within a GET
IF job_clrmon
  SET COLOR TO &job_colval
ELSE
  SET COLOR TO &job_winclr
ENDIF
RETURN

PROCEDURE job_DEL1
  DELETE
RETURN

PROCEDURE job_DELA
  DELETE ALL
RETURN

PROCEDURE job_DELR
* delete record(s)
job_dohelp = .T.
DO WHILE job_dohelp
    SET COLOR TO &job_winclr
    @ 22, 0 CLEAR TO 24,79
    SET MESSAGE TO 23
    @ 22, 0 SAY 'DELETE   This  All'
    SET COLOR TO &job_proclr
    @ 22, 9 PROMPT 'This'   MESSAGE "Delete this record"
    @ 22,15 PROMPT 'All'    MESSAGE "Delete ALL VISIBLE RECORDS"
    MU_D = 0
    MENU TO MU_D
  job_dohelp =  (READKEY()=36 .OR. READKEY()=292)
  IF job_dohelp
    DO job_HLPL
  ENDIF
ENDDO
  job_choice = SUBSTR("QTA",MU_D+1,1)
  IF job_choice = 'Q'
    RETURN
  ENDIF
  SET COLOR TO &job_winclr
  @ 23,0 CLEAR TO 24,79
  SET MESSAGE TO 24
  IF job_choice = 'T'
job_dohelp = .T.
DO WHILE job_dohelp
      @ 23, 0 SAY 'Are you sure you want to DELETE this record?  No Yes'
      SET COLOR TO &job_proclr
      @ 23,46 PROMPT 'No'  MESSAGE "No, don't delete the record"
      @ 23,49 PROMPT 'Yes' MESSAGE "Yes, delete this record"
      MU_DT = 0
      MENU TO MU_DT
  job_dohelp =  (READKEY()=36 .OR. READKEY()=292)
  IF job_dohelp
    DO job_HLPL
  ENDIF
ENDDO
    job_confrm = SUBSTR("NNY",MU_DT+1,1)
  ELSE
job_dohelp = .T.
DO WHILE job_dohelp
      @ 23, 0 SAY 'Are you sure you want to DELETE ALL records?  No Yes'
      SET COLOR TO &job_proclr
      @ 23,46 PROMPT 'No'  MESSAGE "No, don't DELETE ALL records"
      @ 23,49 PROMPT 'Yes' MESSAGE "Yes, DELETE ALL records"
      MU_DA = 0
      MENU TO MU_DA
  job_dohelp =  (READKEY()=36 .OR. READKEY()=292)
  IF job_dohelp
    DO job_HLPL
  ENDIF
ENDDO
    job_confrm = SUBSTR("NNY",MU_DA+1,1)
  ENDIF
  @ 22, 0 CLEAR TO 23,79
  IF job_confrm = 'Y'
    IF job_choice='T'
      DO job_DEL1
      * reposition to the next record
      SKIP
    ELSE
      DO job_DELA
    ENDIF
    * if last record deleted, go to beginning of database
    IF EOF()
      GO TOP
    ENDIF
    DO job_FTST
  ENDIF (job_confrm = 'Y')
RETURN

PROCEDURE job_DRPS
* drop the current screen
SET COLOR TO &job_WINCLR
  DO CASE
    CASE job_scrnum = 1
      DO job_COLR WITH "W/BU"
      @   1, 34, 16, 79 BOX 'Ŀ'
      @   1, 36 SAY "Client Information"
      job_xllst = job_lwas
    CASE job_scrnum = 2
      DO job_COLR WITH "BU/W"
      @   1,  0, 21, 41 BOX 'Ŀ'
      @   1,  2 SAY "Job Financial Worksheet"
      job_xllst = job_lwas
    CASE job_scrnum = 3
      RESTORE SCREEN FROM job_scrsav
      job_xmenu = job_mwas
      job_xllst = job_lwas
    CASE job_scrnum = 4
      RESTORE SCREEN FROM job_scrsav
      job_xmenu = job_mwas
      job_xllst = job_lwas
    CASE job_scrnum = 5
      RESTORE SCREEN FROM job_scrsav
      job_xmenu = job_mwas
      job_xllst = job_lwas
    CASE job_scrnum = 6
      RESTORE SCREEN FROM job_scrsav
    CASE job_scrnum = 7
      RESTORE SCREEN FROM job_scrsav
  ENDCASE
RETURN

PROCEDURE job_DSPC
* display calculated fields
SET COLOR TO &job_winclr
  DO CASE
    CASE job_scrnum = 1
    CASE job_scrnum = 2
      DO job_COLR WITH "N/W"
      @   8, 32 SAY          M->JDEADLINE
      @   7, 11 SAY          M->JQUOTE     PICTURE "99999.99"
      @   8, 11 SAY          M->JADJUST    PICTURE "99999.99"
      JNET       = m->JQuote+m->JAdjust
      @  10, 11 SAY          M->JNET       PICTURE "99999.99"
      @  11, 11 SAY          M->JPAID      PICTURE "99999.99"
      JLEFT      = m->Jnet-m->Jpaid
      @  13, 11 SAY          M->JLEFT      PICTURE "99999.99"
      @  16, 11 SAY          M->JPAID      PICTURE "99999.99"
      @  17, 11 SAY          M->JCOST      PICTURE "99999.99"
      JCASH      = m->jpaid-m->jcost
      @  19, 11 SAY          M->JCASH      PICTURE "99999.99"
      @  11, 31 SAY          M->JNET       PICTURE "99999.99"
      @  12, 31 SAY          M->JDRAW      PICTURE "99999.99"
      JCHECK     = m->JDRAW-m->JNET
      @  13, 31 SAY          M->JCHECK     PICTURE "99999.99"
      @  16, 31 SAY          M->JNET       PICTURE "99999.99"
      @  17, 31 SAY          M->JCOST      PICTURE "99999.99"
      JPROFIT    = m->Jnet-m->Jcost
      @  19, 31 SAY          M->JPROFIT    PICTURE "99999.99"
    CASE job_scrnum = 3
      JB1        = m->JH1*m->JR1
      DO job_COLR WITH "N/W"
      @  15, 62 SAY          M->JB1        PICTURE "9999.99"
      JB2        = m->JH2*m->JR2
      @  16, 62 SAY          M->JB2        PICTURE "9999.99"
      JB3        = m->JH3*m->JR3
      @  17, 62 SAY          M->JB3        PICTURE "9999.99"
      JB4        = m->JH4*m->JR4
      @  18, 62 SAY          M->JB4        PICTURE "9999.99"
      JB5        = m->JH5*m->JR5
      @  19, 62 SAY          M->JB5        PICTURE "9999.99"
      JHOURS     = m->JH1+m->JH2+m->JH3+m->JH4+m->JH5
      @  11, 49 SAY          M->JHOURS     PICTURE "99.99"
      JBID       = m->JB1+m->JB2+m->JB3+m->JB4+m->JB5
      @  11, 61 SAY          M->JBID       PICTURE "99999.99"
      JRATE      = job_ZDIV(m->JBID,m->JHOURS)
      @  11, 55 SAY          M->JRATE      PICTURE "99.99"
      JCOST      = m->JC1+m->JC2+m->JC3+m->JC4+m->JC5
      @  11, 70 SAY          M->JCOST      PICTURE "99999.99"
      JQUOTE     = m->JBID+m->JCOST
      @   9, 70 SAY          M->JQUOTE     PICTURE "99999.99"
    CASE job_scrnum = 4
      JADJUST    = m->JAA1+m->JAA2+m->JAA3+m->JAA4+m->JAA5
      DO job_COLR WITH "N/W"
      @  12, 70 SAY          M->JADJUST    PICTURE "99999.99"
    CASE job_scrnum = 5
      TODAY      = DATE()
      DO job_COLR WITH "N/W"
      @   8,  8 SAY          M->TODAY
      @   7, 66 SAY          M->JPHONE
      @   8, 27 SAY          M->JCONT1
      @   8, 66 SAY          M->JEXT1
      @   9, 27 SAY          M->JCONT2
      @   9, 66 SAY          M->JEXT2
      @  19,  8 SAY          M->JQUOTE     PICTURE "99999.99"
      @  19, 21 SAY          M->JADJUST    PICTURE "99999.99"
      JNET       = m->Jquote+m->Jadjust
      @  19, 34 SAY          M->JNET       PICTURE "99999.99"
      JDRAW      = m->JDA1+m->JDA2+m->JDA3+m->JDA4+m->JDA5
      @  19, 48 SAY          M->JDRAW      PICTURE "99999.99"
      JPAID      = m->JP1+m->JP2+m->JP3+m->JP4+m->JP5
      @  19, 70 SAY          M->JPAID      PICTURE "99999.99"
      JDUE       = iif(m->jok1.and.date()>=m->jdd1,m->jda1,0) +iif(m->jok2.and.date()>=m->jdd2,m->jda2,0) +iif(m->jok3.and.date()>=m->jdd3,m->jda3,0) +iif(m->jok4.and.date()>=m->jdd4,m->jda4,0) +iif(m->jok5.and.date()>=m->jdd5,m->jda5,0)-m->jpaid
      @   9,  8 SAY          M->JDUE       PICTURE "99999.99"
    CASE job_scrnum = 6
    CASE job_scrnum = 7
  ENDCASE
  CLEAR GETS
RETURN

PROCEDURE job_DSPM
PARAMETERS job_MSG
* Display at line 23 then wait
SET COLOR TO &job_proclr
@ 22,00
@ 23,00
@ 22,79
WAIT job_MSG + '...'
RETURN

PROCEDURE job_DSPQ
PARAMETERS job_MSG
* Display at line 23
SET COLOR TO &job_proclr
@ 22,00
@ 23,00
@ 23,00 SAY job_MSG + '...'
RETURN

PROCEDURE job_DSPB
* Clear message area
SET COLOR TO &job_proclr
@ 22,00
@ 23,00
RETURN

PROCEDURE job_DSPR
* Load fields from database and display record
DO job_GFLD
CLEAR GETS
DO job_DSPC
RETURN

PROCEDURE job_DSPS
* Display text stuff
SET COLOR TO &job_WINCLR
  DO CASE
    CASE job_scrnum = 1
      @ 1, 0 CLEAR TO 21,79
      DO job_COLR WITH "W/BU"
      @   1, 34, 16, 79 BOX 'ͻȺ '
      @   1, 36 SAY "Client Information"
      job_lwas = job_xmenu
      job_xllst = "JCLIENT,JPHONE,JCONT1,JEXT1"
      @   2, 40 SAY "CLIENT "
      @   3, 39 SAY "ADDRESS "
      @   4, 37 SAY "POB/SUITE "
      @   5, 35 SAY "CITY,ST,ZIP "
      @   5, 65 SAY ","
      @   5, 68 SAY ","
      @   6, 35 SAY ""
      @   7, 38 SAY "BUSINESS "
      @   8, 35 SAY "HOURLY RATE "
      @   8, 54 SAY "DAILY RATE "
      @   9, 41 SAY "TERMS "
      @  10, 35 SAY ""
      @  11, 41 SAY "CONTACTS"
      @  11, 54 SAY "PHONE "
      @  11, 74 SAY "EXT"
      @  12, 38 SAY "#1 "
      @  13, 38 SAY "#2 "
      @  14, 35 SAY ""
      @  15, 37 SAY "REM "
    CASE job_scrnum = 2
      @ 1, 0 CLEAR TO 21,79
      DO job_COLR WITH "BU/W"
      @   1,  0, 21, 41 BOX 'ͻȺ '
      @   1,  2 SAY "Job Financial Worksheet"
      job_lwas = job_xmenu
      job_xllst = "JOB,JSTARTED,JCOMPLETED,JNET,JPAID,JLEFT"
      DO job_COLR WITH "GR+/N"
      @   2,  2 SAY "CLIENT "
      DO job_COLR WITH "BU/BG"
      @   3,  1,  5, 20 BOX 'Ŀ '
      @   4,  4 SAY "JOB "
      DO job_COLR WITH "N/G"
      @   3, 21,  9, 40 BOX 'Ŀ '
      @   3, 23 SAY "Time"
      @   4, 25 SAY "QUOTED "
      @   5, 23 SAY "ACCEPTED "
      @   6, 24 SAY "STARTED "
      @   7, 22 SAY "COMPLETED "
      @   8, 23 SAY "DEADLINE "
      DO job_COLR WITH "W/GR"
      @   6,  1, 14, 20 BOX 'Ŀ '
      @   6,  3 SAY "Progress"
      @   7,  3 SAY " QUOTE $"
      @   7, 19 SAY "+"
      @   8,  3 SAY "ADJUST $"
      @   8, 19 SAY "+"
      @   9,  3 SAY "----------------"
      @  10,  3 SAY "   NET $"
      @  10, 19 SAY "="
      @  11,  3 SAY "  PAID $"
      @  11, 19 SAY "-"
      @  12,  3 SAY "----------------"
      @  13,  3 SAY "  LEFT $"
      @  13, 19 SAY "="
      DO job_COLR WITH "BG/R"
      @  15,  1, 20, 20 BOX 'Ŀ '
      @  15,  3 SAY "Cash Flow"
      @  16,  2 SAY "   PAID $"
      @  16, 19 SAY "+"
      @  17,  2 SAY "   COST $"
      @  17, 19 SAY "-"
      @  18,  2 SAY "-----------------"
      @  19,  2 SAY "   CASH $"
      @  19, 19 SAY "="
      DO job_COLR WITH "W/BU"
      @  10, 21, 14, 40 BOX 'Ŀ '
      @  10, 23 SAY "Check"
      @  11, 22 SAY "    NET $"
      @  12, 22 SAY "   DRAW $"
      @  12, 39 SAY "-"
      @  13, 22 SAY " 0 CHECK "
      @  13, 39 SAY "="
      DO job_COLR WITH "W/BR"
      @  15, 21, 20, 40 BOX 'Ŀ '
      @  15, 23 SAY "Profit"
      @  16, 22 SAY "    NET $"
      @  17, 22 SAY "   COST $"
      @  17, 39 SAY "-"
      @  18, 22 SAY " ----------------"
      @  19, 22 SAY " PROFIT $"
      @  19, 39 SAY "="
    CASE job_scrnum = 3
      DO job_COLR WITH "W/GR"
      SAVE SCREEN TO job_scrsav
      @   8,  0, 21, 79 BOX 'ͻȺ '
      @   8,  2 SAY "Bid Worksheet"
      job_mwas = job_xmenu
      job_xmenu = job_xmenu + "ACD"
      job_lwas = job_xmenu
      job_xllst = "JOB,JHOURS,JBID,JQUOTE,JCLIENT"
      @   9,  1 SAY "JOB "
      @   9, 16 SAY "CLIENT "
      @  10,  1, 12, 78 BOX 'Ŀ'
      @  10,  3 SAY "Totals"
      @  13,  1, 20, 78 BOX 'Ŀ'
      @  13,  3 SAY "Detail"
      @  14,  2 SAY "DUE DATE"
      @  14, 11 SAY "TASK"
      @  14, 49 SAY "HOURS"
      @  14, 55 SAY "RATE "
      @  14, 62 SAY "BID $"
      @  14, 71 SAY "COST $"
      @   9, 63 SAY "QUOTE $"
    CASE job_scrnum = 4
      DO job_COLR WITH "BU/BG"
      SAVE SCREEN TO job_scrsav
      @  11,  5, 21, 79 BOX 'ͻȺ '
      @  11,  7 SAY "Adjustment Worksheet"
      job_mwas = job_xmenu
      job_xmenu = job_xmenu + "ACD"
      job_lwas = job_xmenu
      job_xllst = "JOB,JCLIENT,JADJUST"
      @  12,  6 SAY "JOB "
      @  12, 26 SAY "CLIENT "
      @  13,  6, 20, 78 BOX 'Ŀ'
      @  13,  8 SAY "Detail"
      @  14,  7 SAY "ADJ DATE"
      @  14, 16 SAY "ORDER BY"
      @  14, 25 SAY "ADJUSTMENT"
      @  14, 71 SAY "ADJ $"
    CASE job_scrnum = 5
      DO job_COLR WITH "N/G"
      SAVE SCREEN TO job_scrsav
      @   6,  0, 21, 79 BOX 'ͻȺ '
      @   6,  2 SAY "Draw WorkSheet"
      job_mwas = job_xmenu
      job_xmenu = job_xmenu + "ACID"
      job_lwas = job_xmenu
      job_xllst = "JOB,JNET,JPAID,JCLIENT"
      @   7,  2 SAY "JOB "
      @   8,  1 SAY " AS OF "
      @   7, 20 SAY "CLIENT "
      @   7, 60 SAY "PHONE "
      @   8, 20 SAY "CONT 1 "
      @   8, 62 SAY "EXT "
      @   9, 20 SAY "CONT 2 "
      @   9, 62 SAY "EXT "
      @  10,  1, 17, 78 BOX 'Ŀ'
      @  10,  3 SAY "Detail"
      @  11,  2 SAY "DRAW CONDITIONS"
      @  11, 34 SAY "OK"
      @  11, 37 SAY "DRAW DUE"
      @  11, 46 SAY "DRAW $"
      @  11, 55 SAY "CHECK#"
      @  11, 62 SAY "CHK DATE"
      @  11, 71 SAY "CHECK $"
      @  18,  1, 20, 78 BOX 'Ŀ'
      @  19,  2 SAY "QUOTE "
      @  19, 16 SAY "+ADJ "
      @  19, 29 SAY "=NET "
      @  19, 42 SAY "=DRAW "
      @  19, 56 SAY " = PAID TOTAL "
      @   9,  2 SAY "DUE  $"
    CASE job_scrnum = 6
      DO job_COLR WITH "N/BG"
      SAVE SCREEN TO job_scrsav
      @  17,  0, 21, 55 BOX 'ͻȺ '
      @  17,  2 SAY "&job_XDALS Utility Menu"
      @  18,  1 SAY " DOS Command   - execute an operating system command"
      @  19,  1 SAY " Import File   - import records from an external file"
      @  20,  1 SAY " Export File   - export records to an external file"
    CASE job_scrnum = 7
      DO job_COLR WITH "BU/G"
      SAVE SCREEN TO job_scrsav
      @  17, 10, 21, 50 BOX 'ͻȺ '
      @  17, 12 SAY "Job Reports"
      @  18, 11 SAY " Client Directory   - All Client Names"
      @  19, 11 SAY " Job Directory      - All Job Names"
      @  20, 11 SAY " Mailing Labels     - 1/up for Clients"
  ENDCASE
DO job_STAT
RETURN

PROCEDURE job_EDIT
PARAMETERS job_REPT  && if repeating for validation
* edit screen set in current context
* one shot inits
SET FUNCTION 9 TO DTOC(DATE())
SET FUNCTION 10 TO LEFT(TIME(),5)
  IF job_OPTION $ 'ARF'
    IF .NOT. job_REPT
      DO job_IFLD
    ENDIF
  ENDIF
job_readdn = .F.
DO job_DSPB  && clean all but last line for messages
DO WHILE .NOT. job_readdn
  DO job_STAT
  IF job_OPTION $ 'FR'
    DO job_CLRF
    DO job_CLRC
  ENDIF
  IF job_OPTION $ 'AMC'
    DO job_DSPC
  ENDIF
  IF job_OPTION $ 'AMCF'
    DO job_GFLD
  ENDIF
  IF job_OPTION = 'R'
    DO job_GKEY
  ENDIF
  * perform the data read
  READ
  * recalculate results
  IF job_OPTION $ 'AMC'
    DO job_DSPC
  ENDIF
  * decide how to handle it
  job_thekey = READKEY()
  IF job_thekey>255
    job_thekey = CHR(job_thekey-256)
  ELSE
    job_thekey = CHR(job_thekey)
  ENDIF
  DO CASE
    CASE job_thekey $ job_exkeys
      * finished
      job_readdn = .T.
    CASE job_thekey $ job_upkeys
      * page lower (page up)
      DO job_DRPS
      job_xfpag = job_xfpag -1
      IF job_xfpag < 1
        job_xfpag = LEN(job_xfpgs)
      ENDIF
      job_scrnum = ASC(SUBSTR(job_xfpgs,job_xfpag,1))
      DO job_DSPS
    OTHERWISE
      * page higher (page down,enter,past end)
      DO job_DRPS
      job_xfpag = job_xfpag +1
      IF job_xfpag >LEN(job_xfpgs)
        job_xfpag = 1
      ENDIF
      job_scrnum = ASC(SUBSTR(job_xfpgs,job_xfpag,1))
      DO job_DSPS
  ENDCASE
ENDDO && reading
SET FUNCTION 9 TO ''
SET FUNCTION 10 TO ''
RETURN

PROCEDURE job_FCHK
* validate that dbf's exist, build/force index generation
PARAMETERS job_dfirst,job_dlast,job_force
job_filsok =.T. && assume success
CLOSE DATABASES
job_filnum = job_dfirst
DO WHILE job_filnum <= job_dlast
  job_number = LTRIM(STR(job_filnum))
  SELECT &job_number
  DO job_XLOD
  IF .NOT. FILE (job_xdfnm + '.DBF')
    ? 'File ' + job_xdfnm + ' not found'
    job_filsok = .F.
  ELSE
    USE &job_xdfnm ALIAS &job_xdals
  ENDIF
  IF job_filsok
        IF job_force .OR. .NOT. FILE ('JOB_JOB.IDX')
          ? 'Indexing JOB_JOB for ',ALIAS()
          INDEX ON UPPER(JOB) TO JOB_JOB
        ENDIF
        IF job_force .OR. .NOT. FILE ('JOB_JBYC.IDX')
          ? 'Indexing JOB_JBYC for ',ALIAS()
          INDEX ON JCLIENT+JOB TO JOB_JBYC
        ENDIF
  ENDIF
  DO job_XSAV
  USE
  job_filnum = job_filnum + 1
ENDDO && while job_filnum <= job_dlast
RETURN

PROCEDURE job_FSET
* set the file array items
* JOB Items
  job_dfnm   = 'JOB_JOB'
  job_dals   = 'JOB'
  job_used   = .F.
  job_llst   = ''
  job_last   = 0
  job_fpgs   = CHR(2)+CHR(1)+CHR(3)+CHR(4)+CHR(5)
  job_fpag   = 1
  job_menu   = "ZV"
  job_fstr   = ''
  job_frem   = ''
  job_fflg   = .F.
  job_idxd   = .T.
  job_ifnm   = 'JOB_JOB'
  job_uniq   = .T.
  job_fill   = .T.
  job_mkey   = "UPPER(m->JOB)"
  job_fkey   = "UPPER(JOB)"
  job_nkey   = SPACE(10)
  job_ckey   = "TRIM(UPPER(m->JOB))"
  job_iord   = 1
  job_ilst   = ",JOB,"
  job_ikey   = job_mkey
  job_bkey   = job_nkey
RETURN

PROCEDURE job_FILT
* Set FILTER
job_dohelp = .T.
DO WHILE job_dohelp
  SET COLOR TO &job_winclr
  @ 22, 0 CLEAR TO 24,79
  @ 24,0 SAY job_xfrem
  @ 22, 0 SAY 'Set FILTER? Yes No Cancel And Or'
  SET COLOR TO &job_proclr
  SET MESSAGE TO 23
  @ 22,12 PROMPT 'Yes'    MESSAGE "Yes, set a new FILTER"
  @ 22,16 PROMPT 'No'     MESSAGE "No, don't alter the FILTER"
  IF job_xfflg
    @ 22,19 PROMPT 'Cancel' MESSAGE "Cancel the current FILTER"
    IF LEN(job_xfstr)<250
      @ 22,26 PROMPT 'And' MESSAGE "AND a new template with the FILTER"
      @ 22,30 PROMPT 'Or'  MESSAGE "OR a new template with the filter"
    ENDIF
  ENDIF
  MU_F = 0
  MENU TO MU_F
  job_dohelp =  (READKEY()=36 .OR. READKEY()=292)
  IF job_dohelp
    DO job_HLPL
  ENDIF
ENDDO
job_choice = SUBSTR("NYNCAO",MU_F+1,1)
IF job_choice = 'N'
  RETURN
ENDIF
IF job_choice = 'C'
  job_xfstr = ''
  job_xfrem = ''
  job_xfflg = .F.
  SET FILTER TO
  DO job_XSAV
  RETURN
ENDIF (job_choice = 'C')
job_dohelp = .T.
DO WHILE job_dohelp
  SET COLOR TO &job_winclr
  @ 22, 0 CLEAR TO 23,79
  job_confrm = 'S'
  * job_choice $ 'YAO'
  @ 22, 0 CLEAR TO 23,79
  SET MESSAGE TO 23
  @ 22, 0 SAY 'What type of FILTER?  Same  Different  Above  Below  Has'
  SET COLOR TO &job_proclr
  @ 22,22 PROMPT "Same"      MESSAGE "Select records that match the template"
  @ 22,28 PROMPT "Different" MESSAGE "Select records that don't match the template"
  @ 22,39 PROMPT "Above"     MESSAGE "Select records greater than or equal to the template"
  @ 22,46 PROMPT "Below"     MESSAGE "Select records less than or equal to the template"
  @ 22,53 PROMPT "Has"       MESSAGE "Select records the contain the template"
  MU_FY = 0
  MENU TO MU_FY
  job_dohelp =  (READKEY()=36 .OR. READKEY()=292)
  IF job_dohelp
    DO job_HLPL
  ENDIF
ENDDO
IF MU_FY = 0 && escaped
  RETURN
ENDIF
job_Match = SUBSTR("SDABH",MU_FY,1)
@ 22, 0 CLEAR TO 23,79
DO CASE
  CASE job_match = 'S'
    @ 22, 0 SAY "Enter Values to include in the display"
    job_fnumop = '='
    job_fchrop = '=='
    job_frelop = '= '
    job_fltgrp = 1
  CASE job_match = 'D'
    @ 22, 0 SAY "Enter Values to exclude from the display"
    STORE '<>' TO job_fnumop,job_fchrop
    job_frelop = "<> "
    job_fltgrp = 1
   CASE job_match = 'A'
    @ 22, 0 SAY "Enter the LOW Value limits for display"
    STORE '<=' TO job_fnumop,job_fchrop
    job_frelop = "Above "
    job_fltgrp = 2
   CASE job_match = 'B'
    @ 22, 0 SAY "Enter the HIGH Value limits for display"
    STORE '>=' TO job_fnumop,job_fchrop
    job_frelop = "Below "
    job_fltgrp = 2
   CASE job_match = 'H'
    @ 22, 0 SAY "Enter SUBSTRING match values for display"
    job_fnumop = '=='
    job_fchrop = '$'
    job_frelop = 'Has '
    job_fltgrp = 3
ENDCASE
DO job_XSAV && in case no match
DO CASE
  CASE job_choice = 'Y'
    job_xfstr = ''
    job_xfrem = ''
  CASE job_choice = 'A'
    job_xfstr = job_xfstr + ' .AND.'
    job_xfrem = job_xfrem + ','
  CASE job_choice = 'O'
    job_xfstr = job_xfstr + ' .OR. '
    job_xfrem = job_xfrem + ';'
ENDCASE
DO job_EDIT WITH .F. && read the values
job_fltgrp   = 0
* cycle thru each field
job_fldnum = 1
DO WHILE job_fldnum <= FCOUNT()
  job_fldnam = FIELD(job_fldnum)
  job_memnam = 'M->'+job_fldnam
  DO CASE
    CASE TYPE(job_fldnam) = 'C'
      * char field
      IF ''<>TRIM(&job_memnam)
        IF job_match='H' .AND. LEFT(&job_memnam,1)=',' .AND. RIGHT(TRIM(&job_memnam),1)=','
          * code search
          STORE SUBSTR(LTRIM(TRIM(&job_memnam)),2,254) TO &job_fldnam
          STORE UPPER(LTRIM(TRIM(&job_memnam))) TO &job_fldnam
          job_fldval = &job_memnam
          job_xfrem=job_xfrem+'&job_fldnam '+ job_frelop + UPPER(LTRIM(TRIM('&job_fldval'))) +','
          DO WHILE ''<>&job_memnam
            * set up one filter element
            job_fldval = LEFT(&job_memnam,AT(',',&job_memnam)-1)
            &job_memnam = RIGHT(&job_memnam,LEN(&job_memnam)-AT(',',&job_memnam))
            IF ''<>job_fldval
              job_xfstr=job_xfstr+'[,&job_fldval,] &job_fchrop [,]+UPPER(LTRIM(TRIM(&job_fldnam)))+[,]'+' .AND.'
            ENDIF
          ENDDO
        ELSE
          * sub-string search
          job_fldval = &job_memnam
          job_xfrem=job_xfrem+'&job_fldnam '+ job_frelop + UPPER(LTRIM(TRIM('&job_fldval'))) +','
          STORE UPPER(LTRIM(TRIM(&job_memnam))) TO &job_fldnam
          job_fldval = &job_memnam
          job_xfstr=job_xfstr+'[&job_fldval] &job_fchrop UPPER(LTRIM(TRIM(&job_fldnam)))'+' .AND.'
        ENDIF
      ENDIF
    CASE (job_fltgrp < 3) .AND. (TYPE(job_fldnam) = 'N')
      * numeric field
      IF 0<>&job_memnam
        job_xfrem=job_xfrem+'&job_fldnam '+job_frelop+LTRIM(STR(&job_memnam))+','
        job_xfstr=job_xfstr+LTRIM(STR(&job_memnam))+' &job_fnumop &job_fldnam .AND.'
      ENDIF
    CASE (job_fltgrp < 3) .AND. (TYPE(job_fldnam) = 'D')
      * date field
      IF CTOD('  /  /  ')<>&job_memnam
        job_xfrem=job_xfrem+'&job_fldnam '+job_frelop+DTOC(&job_memnam)+','
        job_xfstr=job_xfstr+[CToD(']+DTOC(&job_memnam)+[')&job_fnumop &job_fldnam .AND.]
      ENDIF
    CASE (job_fltgrp < 2) .AND. (TYPE(job_fldnam) = 'L')
      * logical field
      IF (&job_memnam <> ' ') .AND. (&job_memnam $ 'TFYN')
        job_state=(&job_memnam $ 'TY')
        IF job_match='D'
          job_state=.NOT. job_state
        ENDIF
        IF .NOT. job_state
          job_xfrem=job_xfrem+' Not '
          job_xfstr=job_xfstr+' .NOT. '
        ENDIF
        job_xfrem=job_xfrem+'&job_fldnam,'
        job_xfstr=job_xfstr+'&job_fldnam .AND.'
      ENDIF
  ENDCASE
  job_fldnum =job_fldnum+1
ENDDO
IF '' <> TRIM(job_xfstr)   && FILTER specified
  job_xfstr = SUBSTR(job_xfstr,1,LEN(job_xfstr)-6)
  job_xfrem = SUBSTR(job_xfrem,1,LEN(job_xfrem)-1)
  IF job_xfstr == ''
    SET FILTER TO
  ELSE
    SET FILTER TO &job_xfstr
  ENDIF
  DO job_DSPQ WITH "Scanning"
  GO TOP
  IF EOF()
    DO job_DSPM WITH 'No records match the FILTER'
    DO job_XLOD
    IF job_xfstr == ''
      SET FILTER TO
    ELSE
      SET FILTER TO &job_xfstr
    ENDIF
    GO job_xlast
  ELSE && not eof() accept new
    job_xfflg = .T.
    DO job_XSAV
  ENDIF && eof()
ENDIF && '' <> TRIM(job_fstr))
RETURN

PROCEDURE job_FTST
* set filter
  IF EOF() .AND. job_xfflg
    * if no records left in FILTER, remove the FILTER
    job_xfstr = ''
    job_xfflg = .F.
    SET FILTER TO
    GO TOP
  ENDIF && EOF() .AND. job_xfflg
RETURN



PROCEDURE job_GTHR
* gather undeleted into new files
job_dohelp = .T.
DO WHILE job_dohelp
    SET COLOR TO &job_winclr
    @ 22, 0 CLEAR TO 24,79
    SET MESSAGE TO 23
    @ 22, 0 SAY 'Gather records now? No Yes'
    SET COLOR TO &job_proclr
    @ 22,20 PROMPT 'No'     MESSAGE "Don't Gather at this time"
    @ 22,23 PROMPT 'Yes'    MESSAGE "Gather records now"
    MU_G = 0
    MENU TO MU_G
  job_dohelp =  (READKEY()=36 .OR. READKEY()=292)
  IF job_dohelp
    DO job_HLPL
  ENDIF
ENDDO
  job_choice = SUBSTR("NNY",MU_G+1,1)
  IF job_choice = 'N'
    RETURN
  ENDIF
  SET COLOR TO &job_winclr
job_filwas = job_filnum
DO job_XSAV
DO job_CLOS
CLOSE DATABASES
USE &job_xdfnm ALIAS &job_xdals
IF job_xidxd
  SET INDEX TO &job_xifnm
ENDIF
GO TOP
* make work names
job_dbfid = job_xdfnm + '.DBF'
job_dbftmp = TRIM(job_userid)+'$$$.DBF'
job_dbtid = job_xdfnm + '.DBT'
job_dbttmp = TRIM(job_userid)+'$$$.DBT'
* delete temporary files
IF FILE(job_dbftmp)
  DELETE FILE &job_dbftmp
ENDIF
IF FILE(job_dbttmp)
  DELETE FILE &job_dbttmp
ENDIF
@ 24,0
@ 24,0 SAY 'Copying '+ job_xdals + '...'
COPY TO &job_dbftmp
SET FILTER TO
COUNT TO job_undel
* if the file is completely empty we force undelrecs to 1
IF job_undel= 0
  job_undel= 1
ENDIF
USE
job_filsok = .F.
IF FILE(job_dbftmp)
  USE &job_dbftmp
  GOTO BOTTOM
  job_filsok = (job_undel = RECNO())
  USE
ENDIF
IF .NOT. job_filsok
  * count or existence failure
  @ 24,0
  @ 24,0 SAY ' '+ job_xdals + ' could not be gathered!'
  IF FILE(job_dbftmp)
    DELETE FILE &job_dbftmp
  ENDIF
  IF FILE(job_dbttmp)
    DELETE FILE &job_dbttmp
  ENDIF
  WAIT
ELSE
  * delete originals and rename temporaries
  DELETE FILE &job_dbfid
  RENAME &job_dbftmp TO &job_dbfid
  IF FILE(job_dbtid)
    DELETE FILE &job_dbtid
    RENAME &job_dbttmp TO &job_dbtid
  ENDIF
  * force recreation of the indexes
  USE &job_dbfid
  DO job_FCHK WITH (job_filnum),(job_filnum),.T.
ENDIF
DO job_FCHK WITH 1,job_filmax,.F.
CLEAR
job_filnum = job_filwas
DO job_XLOD
DO job_OPEN
job_xfpag = 1
job_scrnum = ASC(job_xfpgs)
DO job_DSPS
RETURN

PROCEDURE job_GFLD
* Get field variables
SET COLOR TO &job_winclr
  DO CASE
  * file: JOB
    CASE job_scrnum = 1
      DO job_COLR WITH ",N/W"
      @   2, 47 GET M->JCLIENT    PICTURE "@!"
      @   3, 47 GET M->JADDR
      @   4, 47 GET M->JPOB
      @   5, 47 GET M->JCITY
      @   5, 66 GET M->JSTATE     PICTURE "@!"
      @   5, 69 GET M->JZIP       PICTURE "@!"
      @   7, 47 GET M->JBUSINESS
      IF job_FLTGRP < 3
        @   8, 47 GET M->JHRATE     PICTURE "99.99"
        @   8, 65 GET M->JDRATE     PICTURE "999.99"
      ENDIF
      @   9, 47 GET M->JTERMS
      @  11, 60 GET M->JPHONE
      @  12, 41 GET M->JCONT1
      @  12, 74 GET M->JEXT1
      @  13, 41 GET M->JCONT2
      @  13, 74 GET M->JEXT2
      @  15, 41 GET M->JCREM
      IF .NOT. job_option $ "ACF"
        JCNOTES_ = "Memo"
        @  15, 75 GET M->JCNOTES_   PICTURE "@R Xemo" VALID job_CHKM("JCNOTES")
      ENDIF
    CASE job_scrnum = 2
      DO job_COLR WITH ",N/W"
      @   2,  9 GET M->JCLIENT    PICTURE "@!"
      @   4,  8 GET M->JOB        PICTURE "@!"
      IF job_FLTGRP < 3
        @   4, 32 GET M->JQUOTED
        @   5, 32 GET M->JACCEPTED
        @   6, 32 GET M->JSTARTED
        @   7, 32 GET M->JCOMPLETED
      ENDIF
    CASE job_scrnum = 3
      DO job_COLR WITH ",N/W"
      @   9,  5 GET M->JOB        PICTURE "@!"
      @   9, 23 GET M->JCLIENT    PICTURE "@!"
      IF job_FLTGRP < 3
        @  11,  2 GET M->JDEADLINE
      ENDIF
      @  11, 11 GET M->JTASK
      IF .NOT. job_option $ "ACF"
        JTEXT_ = "Memo"
        @  11, 44 GET M->JTEXT_     PICTURE "@R Xemo" VALID job_CHKM("JTEXT")
      ENDIF
      IF job_FLTGRP < 3
        @  15,  2 GET M->JBD1
      ENDIF
      @  15, 11 GET M->JT1
      IF job_FLTGRP < 3
        @  15, 49 GET M->JH1        PICTURE "99.99"
        @  15, 55 GET M->JR1        PICTURE "99.99"
        @  15, 71 GET M->JC1        PICTURE "9999.99"
        @  16,  2 GET M->JBD2
      ENDIF
      @  16, 11 GET M->JT2
      IF job_FLTGRP < 3
        @  16, 49 GET M->JH2        PICTURE "99.99"
        @  16, 55 GET M->JR2        PICTURE "99.99"
        @  16, 71 GET M->JC2        PICTURE "9999.99"
        @  17,  2 GET M->JBD3
      ENDIF
      @  17, 11 GET M->JT3
      IF job_FLTGRP < 3
        @  17, 49 GET M->JH3        PICTURE "99.99"
        @  17, 55 GET M->JR3        PICTURE "99.99"
        @  17, 71 GET M->JC3        PICTURE "9999.99"
        @  18,  2 GET M->JBD4
      ENDIF
      @  18, 11 GET M->JT4
      IF job_FLTGRP < 3
        @  18, 49 GET M->JH4        PICTURE "99.99"
        @  18, 55 GET M->JR4        PICTURE "99.99"
        @  18, 71 GET M->JC4        PICTURE "9999.99"
        @  19,  2 GET M->JBD5
      ENDIF
      @  19, 11 GET M->JT5
      IF job_FLTGRP < 3
        @  19, 49 GET M->JH5        PICTURE "99.99"
        @  19, 55 GET M->JR5        PICTURE "99.99"
        @  19, 71 GET M->JC5        PICTURE "9999.99"
      ENDIF
    CASE job_scrnum = 4
      DO job_COLR WITH ",N/W"
      @  12, 10 GET M->JOB        PICTURE "@!"
      IF .NOT. job_option $ "ACF"
        JAMEMO_ = "Memo"
        @  12, 21 GET M->JAMEMO_    PICTURE "@R Xemo" VALID job_CHKM("JAMEMO")
      ENDIF
      @  12, 33 GET M->JCLIENT    PICTURE "@!"
      IF job_FLTGRP < 3
        @  15,  7 GET M->JAD1
      ENDIF
      @  15, 16 GET M->JAOB1
      @  15, 25 GET M->JA1
      IF job_FLTGRP < 3
        @  15, 71 GET M->JAA1       PICTURE "9999.99"
        @  16,  7 GET M->JAD2
      ENDIF
      @  16, 16 GET M->JAOB2
      @  16, 25 GET M->JA2
      IF job_FLTGRP < 3
        @  16, 71 GET M->JAA2       PICTURE "9999.99"
        @  17,  7 GET M->JAD3
      ENDIF
      @  17, 16 GET M->JAOB3
      @  17, 25 GET M->JA3
      IF job_FLTGRP < 3
        @  17, 71 GET M->JAA3       PICTURE "9999.99"
        @  18,  7 GET M->JAD4
      ENDIF
      @  18, 16 GET M->JAOB4
      @  18, 25 GET M->JA4
      IF job_FLTGRP < 3
        @  18, 71 GET M->JAA4       PICTURE "9999.99"
        @  19,  7 GET M->JAD5
      ENDIF
      @  19, 16 GET M->JAOB5
      @  19, 25 GET M->JA5
      IF job_FLTGRP < 3
        @  19, 71 GET M->JAA5       PICTURE "9999.99"
      ENDIF
    CASE job_scrnum = 5
      DO job_COLR WITH ",N/W"
      @   7,  6 GET M->JOB        PICTURE "@!"
      @   7, 27 GET M->JCLIENT    PICTURE "@!"
      @  12,  2 GET M->JDC1
      IF job_FLTGRP < 2
        @  12, 35 GET M->JOK1
      ENDIF
      IF job_FLTGRP < 3
        @  12, 37 GET M->JDD1
        @  12, 46 GET M->JDA1       PICTURE "9999.99"
      ENDIF
      @  12, 55 GET M->JCK1
      IF job_FLTGRP < 3
        @  12, 62 GET M->JCD1
        @  12, 71 GET M->JP1        PICTURE "9999.99"
      ENDIF
      @  13,  2 GET M->JDC2
      IF job_FLTGRP < 2
        @  13, 35 GET M->JOK2
      ENDIF
      IF job_FLTGRP < 3
        @  13, 37 GET M->JDD2
        @  13, 46 GET M->JDA2       PICTURE "9999.99"
      ENDIF
      @  13, 55 GET M->JCK2
      IF job_FLTGRP < 3
        @  13, 62 GET M->JCD2
        @  13, 71 GET M->JP2        PICTURE "9999.99"
      ENDIF
      @  14,  2 GET M->JDC3
      IF job_FLTGRP < 2
        @  14, 35 GET M->JOK3
      ENDIF
      IF job_FLTGRP < 3
        @  14, 37 GET M->JDD3
        @  14, 46 GET M->JDA3       PICTURE "9999.99"
      ENDIF
      @  14, 55 GET M->JCK3
      IF job_FLTGRP < 3
        @  14, 62 GET M->JCD3
        @  14, 71 GET M->JP3        PICTURE "9999.99"
      ENDIF
      @  15,  2 GET M->JDC4
      IF job_FLTGRP < 2
        @  15, 35 GET M->JOK4
      ENDIF
      IF job_FLTGRP < 3
        @  15, 37 GET M->JDD4
        @  15, 46 GET M->JDA4       PICTURE "9999.99"
      ENDIF
      @  15, 55 GET M->JCK4
      IF job_FLTGRP < 3
        @  15, 62 GET M->JCD4
        @  15, 71 GET M->JP4        PICTURE "9999.99"
      ENDIF
      @  16,  2 GET M->JDC5
      IF job_FLTGRP < 2
        @  16, 35 GET M->JOK5
      ENDIF
      IF job_FLTGRP < 3
        @  16, 37 GET M->JDD5
        @  16, 46 GET M->JDA5       PICTURE "9999.99"
      ENDIF
      @  16, 55 GET M->JCK5
      IF job_FLTGRP < 3
        @  16, 62 GET M->JCD5
        @  16, 71 GET M->JP5        PICTURE "9999.99"
      ENDIF
  ENDCASE
RETURN

PROCEDURE job_GKEY
* Get key variables for current index
SET COLOR TO &job_winclr
  DO CASE
  * file: JOB
    CASE job_scrnum = 1
      DO job_COLR WITH ",N/W"
      IF ",JCLIENT," $ job_xilst
        @   2, 47 GET M->JCLIENT    PICTURE "@!"
      ENDIF
    CASE job_scrnum = 2
      DO job_COLR WITH ",N/W"
      IF ",JCLIENT," $ job_xilst
        @   2,  9 GET M->JCLIENT    PICTURE "@!"
      ENDIF
      IF ",JOB," $ job_xilst
        @   4,  8 GET M->JOB        PICTURE "@!"
      ENDIF
    CASE job_scrnum = 3
      DO job_COLR WITH ",N/W"
      IF ",JOB," $ job_xilst
        @   9,  5 GET M->JOB        PICTURE "@!"
      ENDIF
      IF ",JCLIENT," $ job_xilst
        @   9, 23 GET M->JCLIENT    PICTURE "@!"
      ENDIF
    CASE job_scrnum = 4
      DO job_COLR WITH ",N/W"
      IF ",JOB," $ job_xilst
        @  12, 10 GET M->JOB        PICTURE "@!"
      ENDIF
      IF ",JCLIENT," $ job_xilst
        @  12, 33 GET M->JCLIENT    PICTURE "@!"
      ENDIF
    CASE job_scrnum = 5
      DO job_COLR WITH ",N/W"
      IF ",JOB," $ job_xilst
        @   7,  6 GET M->JOB        PICTURE "@!"
      ENDIF
      IF ",JCLIENT," $ job_xilst
        @   7, 27 GET M->JCLIENT    PICTURE "@!"
      ENDIF
  ENDCASE
RETURN

PROCEDURE job_HELP
* user pressed F1 - context help
IF job_INHELP
  RETURN && don't recurse
ENDIF
job_INHELP = .T.
job_fldnam = SYS(18)
IF "MU_" = LEFT(job_fldnam,3)
  job_INHELP = .F.
  RETURN && don't do internals
ENDIF
SET COLOR TO &job_PROCLR  && bright for context
@ 22,0
@ 23,0
    * JOB fields
    DO CASE
      CASE job_fldnam == 'JCLIENT'
        @ 22,11 SAY "Name of Client Company"
      CASE job_fldnam == 'JADDR'
        @ 22,11 SAY "First address line for client"
      CASE job_fldnam == 'JPOB'
        @ 22,11 SAY "Suite/PO Box for Client"
      CASE job_fldnam == 'JCITY'
        @ 22,11 SAY "Client city"
      CASE job_fldnam == 'JSTATE'
        @ 22,11 SAY "Client State"
      CASE job_fldnam == 'JZIP'
        @ 22,11 SAY "Client Zip Code"
      CASE job_fldnam == 'JBUSINESS'
        @ 22,11 SAY "Client Business or Industry"
      CASE job_fldnam == 'JHRATE'
        @ 22,11 SAY "Standard Hourly Rate for Client"
      CASE job_fldnam == 'JDRATE'
        @ 22,11 SAY "Standard Daily Rate for Client"
      CASE job_fldnam == 'JTERMS'
        @ 22,11 SAY "Payment terms for Client"
      CASE job_fldnam == 'JPHONE'
        @ 22,11 SAY "Phone number of client"
      CASE job_fldnam == 'JCONT1'
        @ 22,11 SAY "Name of primary contact within client company"
      CASE job_fldnam == 'JEXT1'
        @ 22,11 SAY "Phone extension for primary contact"
      CASE job_fldnam == 'JCONT2'
        @ 22,11 SAY "Name of secondary contact within client company"
      CASE job_fldnam == 'JEXT2'
        @ 22,11 SAY "Phone extension for secondary contact"
      CASE job_fldnam == 'JCREM'
        @ 22,11 SAY "Miscellaneous Remarks regarding client"
      CASE job_fldnam == 'JCNOTES'
        @ 22,11 SAY "Detailed Remarks regarding Client"
      CASE job_fldnam == 'JOB'
        @ 22,11 SAY "Code Name for the job"
      CASE job_fldnam == 'JQUOTED'
        @ 22,11 SAY "Date Job Quoted"
      CASE job_fldnam == 'JACCEPTED'
        @ 22,11 SAY "Date Job was Accepted by Client"
      CASE job_fldnam == 'JSTARTED'
        @ 22,11 SAY "Date Job Commenced"
      CASE job_fldnam == 'JCOMPLETED'
        @ 22,11 SAY "Date Job Completed"
      CASE job_fldnam == 'JDEADLINE'
        @ 22,11 SAY "Scheduled DeadLine Date"
      CASE job_fldnam == 'JQUOTE'
        @ 22,11 SAY "Quote Amount from Bid Worksheet"
      CASE job_fldnam == 'JADJUST'
        @ 22,11 SAY "Total Adjustments to Bids from Adjustment Worksheet"
      CASE job_fldnam == 'JNET'
        @ 22,11 SAY "Net job amount - Quote Plus Adjustments"
      CASE job_fldnam == 'JPAID'
        @ 22,11 SAY "Amount paid to date from Payment/Draw Schedule"
      CASE job_fldnam == 'JLEFT'
        @ 22,11 SAY "Amount Unpaid (Net less Paid)"
      CASE job_fldnam == 'JCOST'
        @ 22,11 SAY "Costs for Job from Bid Worksheet"
      CASE job_fldnam == 'JCASH'
        @ 22,11 SAY "Actual cash flow for job (Paid less Cost)"
      CASE job_fldnam == 'JDRAW'
        @ 22,11 SAY "Total amount Scheduled for Payment from Payment/Draw Schedule"
      CASE job_fldnam == 'JCHECK'
        @ 22,11 SAY "Balance of NET-DRAW (should be zero)"
      CASE job_fldnam == 'JPROFIT'
        @ 22,11 SAY "Profit for the job (Net less Costs)"
      CASE job_fldnam == 'JTASK'
        @ 22,11 SAY "Job Header"
      CASE job_fldnam == 'JTEXT'
        @ 22,11 SAY "Detailed description of Job"
      CASE job_fldnam == 'JBD1'
        @ 22,11 SAY "Item Due Date"
      CASE job_fldnam == 'JT1'
        @ 22,11 SAY "Bid Item Header"
      CASE job_fldnam == 'JH1'
        @ 22,11 SAY "Man-Hours for Bid Item"
      CASE job_fldnam == 'JR1'
        @ 22,11 SAY "Hourly Rate for Bid Item"
      CASE job_fldnam == 'JB1'
        @ 22,11 SAY "Hours*Rate for Bid Item"
      CASE job_fldnam == 'JC1'
        @ 22,11 SAY "Bid Item Non-Personel Cost"
      CASE job_fldnam == 'JBD2'
        @ 22,11 SAY "Item Due Date"
      CASE job_fldnam == 'JT2'
        @ 22,11 SAY "Bid Item Header"
      CASE job_fldnam == 'JH2'
        @ 22,11 SAY "Man-Hours for Bid Item"
      CASE job_fldnam == 'JR2'
        @ 22,11 SAY "Hourly Rate for Bid Item"
      CASE job_fldnam == 'JB2'
        @ 22,11 SAY "Hours*Rate for Bid Item"
      CASE job_fldnam == 'JC2'
        @ 22,11 SAY "Bid Item Non-Personel Cost"
      CASE job_fldnam == 'JBD3'
        @ 22,11 SAY "Item Due Date"
      CASE job_fldnam == 'JT3'
        @ 22,11 SAY "Bid Item Header"
      CASE job_fldnam == 'JH3'
        @ 22,11 SAY "Man-Hours for Bid Item"
      CASE job_fldnam == 'JR3'
        @ 22,11 SAY "Hourly Rate for Bid Item"
      CASE job_fldnam == 'JB3'
        @ 22,11 SAY "Hours*Rate for Bid Item"
      CASE job_fldnam == 'JC3'
        @ 22,11 SAY "Bid Item Non-Personel Cost"
      CASE job_fldnam == 'JBD4'
        @ 22,11 SAY "Item Due Date"
      CASE job_fldnam == 'JT4'
        @ 22,11 SAY "Bid Item Header"
      CASE job_fldnam == 'JH4'
        @ 22,11 SAY "Man-Hours for Bid Item"
      CASE job_fldnam == 'JR4'
        @ 22,11 SAY "Hourly Rate for Bid Item"
      CASE job_fldnam == 'JB4'
        @ 22,11 SAY "Hours*Rate for Bid Item"
      CASE job_fldnam == 'JC4'
        @ 22,11 SAY "Bid Item Non-Personel Cost"
      CASE job_fldnam == 'JBD5'
        @ 22,11 SAY "Item Due Date"
      CASE job_fldnam == 'JT5'
        @ 22,11 SAY "Bid Item Header"
      CASE job_fldnam == 'JH5'
        @ 22,11 SAY "Man-Hours for Bid Item"
      CASE job_fldnam == 'JR5'
        @ 22,11 SAY "Hourly Rate for Bid Item"
      CASE job_fldnam == 'JB5'
        @ 22,11 SAY "Hours*Rate for Bid Item"
      CASE job_fldnam == 'JC5'
        @ 22,11 SAY "Bid Item Non-Personel Cost"
      CASE job_fldnam == 'JHOURS'
        @ 22,11 SAY "Total Man-Hours for Job"
      CASE job_fldnam == 'JBID'
        @ 22,11 SAY "Total Personel Charge for Job"
      CASE job_fldnam == 'JRATE'
        @ 22,11 SAY "Average Rate for all Bid Items"
      CASE job_fldnam == 'JAMEMO'
        @ 22,11 SAY "Adjustment Item Detailed Description"
      CASE job_fldnam == 'JAD1'
        @ 22,11 SAY "Adjustment Item Entry Date"
      CASE job_fldnam == 'JAOB1'
        @ 22,11 SAY "Adjustment Item Ordered By"
      CASE job_fldnam == 'JA1'
        @ 22,11 SAY "Adjustment Item Header"
      CASE job_fldnam == 'JAA1'
        @ 22,11 SAY "Adjustment Item Dollar Amount"
      CASE job_fldnam == 'JAD2'
        @ 22,11 SAY "Adjustment Item Entry Date"
      CASE job_fldnam == 'JAOB2'
        @ 22,11 SAY "Adjustment Item Ordered By"
      CASE job_fldnam == 'JA2'
        @ 22,11 SAY "Adjustment Item Header"
      CASE job_fldnam == 'JAA2'
        @ 22,11 SAY "Adjustment Item Dollar Amount"
      CASE job_fldnam == 'JAD3'
        @ 22,11 SAY "Adjustment Item Entry Date"
      CASE job_fldnam == 'JAOB3'
        @ 22,11 SAY "Adjustment Item Ordered By"
      CASE job_fldnam == 'JA3'
        @ 22,11 SAY "Adjustment Item Header"
      CASE job_fldnam == 'JAA3'
        @ 22,11 SAY "Adjustment Item Dollar Amount"
      CASE job_fldnam == 'JAD4'
        @ 22,11 SAY "Adjustment Item Entry Date"
      CASE job_fldnam == 'JAOB4'
        @ 22,11 SAY "Adjustment Item Ordered By"
      CASE job_fldnam == 'JA4'
        @ 22,11 SAY "Adjustment Item Header"
      CASE job_fldnam == 'JAA4'
        @ 22,11 SAY "Adjustment Item Dollar Amount"
      CASE job_fldnam == 'JAD5'
        @ 22,11 SAY "Adjustment Item Entry Date"
      CASE job_fldnam == 'JAOB5'
        @ 22,11 SAY "Adjustment Item Ordered By"
      CASE job_fldnam == 'JA5'
        @ 22,11 SAY "Adjustment Item Header"
      CASE job_fldnam == 'JAA5'
        @ 22,11 SAY "Adjustment Item Dollar Amount"
      CASE job_fldnam == 'JDC1'
        @ 22,11 SAY "Draw Item Condition"
      CASE job_fldnam == 'JOK1'
        @ 22,11 SAY "Draw Item Condition Met?"
      CASE job_fldnam == 'JDD1'
        @ 22,11 SAY "Draw Item Due Date"
      CASE job_fldnam == 'JDA1'
        @ 22,11 SAY "Draw Item Amount"
      CASE job_fldnam == 'JCK1'
        @ 22,11 SAY "Client check number of draw payment"
      CASE job_fldnam == 'JCD1'
        @ 22,11 SAY "Date of clients payment"
      CASE job_fldnam == 'JP1'
        @ 22,11 SAY "Amount of check"
      CASE job_fldnam == 'JDC2'
        @ 22,11 SAY "Draw Item Condition"
      CASE job_fldnam == 'JOK2'
        @ 22,11 SAY "Draw Item Condition Met?"
      CASE job_fldnam == 'JDD2'
        @ 22,11 SAY "Draw Item Due Date"
      CASE job_fldnam == 'JDA2'
        @ 22,11 SAY "Draw Item Amount"
      CASE job_fldnam == 'JCK2'
        @ 22,11 SAY "Client check number of draw payment"
      CASE job_fldnam == 'JCD2'
        @ 22,11 SAY "Date of clients payment"
      CASE job_fldnam == 'JP2'
        @ 22,11 SAY "Amount of check"
      CASE job_fldnam == 'JDC3'
        @ 22,11 SAY "Draw Item Condition"
      CASE job_fldnam == 'JOK3'
        @ 22,11 SAY "Draw Item Condition Met?"
      CASE job_fldnam == 'JDD3'
        @ 22,11 SAY "Draw Item Due Date"
      CASE job_fldnam == 'JDA3'
        @ 22,11 SAY "Draw Item Amount"
      CASE job_fldnam == 'JCK3'
        @ 22,11 SAY "Client check number of draw payment"
      CASE job_fldnam == 'JCD3'
        @ 22,11 SAY "Date of clients payment"
      CASE job_fldnam == 'JP3'
        @ 22,11 SAY "Amount of check"
      CASE job_fldnam == 'JDC4'
        @ 22,11 SAY "Draw Item Condition"
      CASE job_fldnam == 'JOK4'
        @ 22,11 SAY "Draw Item Condition Met?"
      CASE job_fldnam == 'JDD4'
        @ 22,11 SAY "Draw Item Due Date"
      CASE job_fldnam == 'JDA4'
        @ 22,11 SAY "Draw Item Amount"
      CASE job_fldnam == 'JCK4'
        @ 22,11 SAY "Client check number of draw payment"
      CASE job_fldnam == 'JCD4'
        @ 22,11 SAY "Date of clients payment"
      CASE job_fldnam == 'JP4'
        @ 22,11 SAY "Amount of check"
      CASE job_fldnam == 'JDC5'
        @ 22,11 SAY "Draw Item Condition"
      CASE job_fldnam == 'JOK5'
        @ 22,11 SAY "Draw Item Condition Met?"
      CASE job_fldnam == 'JDD5'
        @ 22,11 SAY "Draw Item Due Date"
      CASE job_fldnam == 'JDA5'
        @ 22,11 SAY "Draw Item Amount"
      CASE job_fldnam == 'JCK5'
        @ 22,11 SAY "Client check number of draw payment"
      CASE job_fldnam == 'JCD5'
        @ 22,11 SAY "Date of clients payment"
      CASE job_fldnam == 'JP5'
        @ 22,11 SAY "Amount of check"
    ENDCASE
SET COLOR TO &job_WINCLR && dim for name
DO CASE
  CASE TYPE(LEFT(job_FLDNAM,LEN(job_FLDNAM)-1))= 'M'
    @ 22,0 SAY LEFT(job_FLDNAM,LEN(job_FLDNAM)-1)
    @ 23,0 SAY "Memo"
    job_INHELP = .F.
    RETURN
  CASE TYPE(job_fldnam) = 'C'
    @ 23,0 SAY "Character"
  CASE TYPE(job_fldnam) = 'N'
    @ 23,0 SAY "Numeric"
  CASE TYPE(job_fldnam) = 'L'
    @ 23,0 SAY "Logical"
  CASE TYPE(job_fldnam) = 'D'
    @ 23,0 SAY "Date"
  OTHERWISE
    @ 23,0 SAY "????"
ENDCASE
@  22,0 SAY job_fldnam
job_inhelp = .F.
RETURN

PROCEDURE job_HLPR
SAVE SCREEN TO job_hlpscr
  @ 1,0 CLEAR TO 23,79
  @ 0,0 SAY ''
  IF .NOT. ('A' $ job_xmenu)
    ? 'Add      - Add a new record to the file'
  ENDIF
  IF .NOT. (job_norecs .OR. 'B' $ job_xmenu)
    ? 'Begin    - Go to the beginning record'
  ENDIF
  IF .NOT. (job_norecs .OR. 'C' $ job_xmenu)
    ? 'Copy     - Copy this record to a new record and Modify'
  ENDIF
  IF .NOT. (job_norecs .OR. 'D' $ job_xmenu)
    ? 'Delete   - Delete this record, or a group of records'
  ENDIF
  IF .NOT. (job_norecs .OR. 'E' $ job_xmenu)
    ? 'End      - Go to the end of the file'
  ENDIF
  IF .NOT. (job_norecs .OR. 'F' $ job_xmenu)
    ? 'Filter   - Filter the visible record set'
  ENDIF
  IF .NOT. ('G' $ job_xmenu)
    ? 'Gather   - Gather active data to compress files'
  ENDIF
  IF .NOT. ('H' $ job_xmenu)
    ? 'Help     - Display command help for current view'
  ENDIF
  IF .NOT. (job_norecs .OR. 'L' $ job_xmenu)
    ? 'List     - List records in full page mode'
  ENDIF
  IF .NOT. (job_norecs .OR. 'M' $ job_xmenu)
    ? 'Modify   - Modify the contents of this record'
  ENDIF
  IF .NOT. (job_norecs .OR. 'N' $ job_xmenu)
    ? 'Next     - Go to the next record in the file'
  ENDIF
  IF .NOT. (job_norecs .OR. 'O' $  job_xmenu)
    ? 'Order    - Order using another index'
  ENDIF
  IF .NOT. (job_norecs .OR. 'P' $ job_xmenu)
    ? 'Previous - Go to the previous record in the file'
  ENDIF
  IF .NOT. ('Q' $ job_xmenu)
    ? 'Quit     - Quit this program'
  ENDIF
  IF .NOT.  (job_norecs .OR. 'R' $ job_xmenu)
    ? 'Retrieve - Retrieve a record by key value'
  ENDIF
  IF .NOT. (job_norecs .OR. 'S' $ job_xmenu)
    ? 'Skip     - Skip forward/backward by record count'
  ENDIF
  IF .NOT. (job_norecs .OR. 'T' $ job_xmenu)
    ? 'Tally    - Count the number of visible records'
  ENDIF
  IF .NOT. (job_norecs .OR. 'W' $ job_xmenu)
    ? 'Write    - Write data to a report, the screen, or external file'
  ENDIF
  IF job_xfpag>1  .AND. .NOT. ('<' $ job_xmenu)
    ? '<Page    - Display the previous page of this record'
  ENDIF
  IF job_xfpag<LEN(job_xfpgs) .AND. .NOT. ('>' $ job_xmenu)
    ? 'Page>    - Display the next page of this record'
  ENDIF
  IF .NOT. ('/' $ job_xmenu)
    ? '/Menu    - Secondary function menu'
  ENDIF
DO WHILE INKEY()=0
ENDDO
SET COLOR TO &job_proclr
RESTORE SCREEN FROM job_hlpscr
RETURN

PROCEDURE job_HLPL
* user requested F1 help from lightbar menu
SAVE SCREEN TO job_hlpscr
 DO job_COLR WITH "N/W"
 @  13, 15, 19, 63 BOX 'ͻȺ '
 @  13, 17 SAY "Menu Help"
 @  14, 20 SAY " Use "+CHR(27)+" and "+CHR(26)+" to position the Light Bar."
 @  15, 19 SAY " The bottom line will show a description."
 @  16, 20 SAY " of the function the item will perform."
 @  17, 22 SAY " Press <ENTER> to select the item."
 @  18, 24 SAY " Press <ESC> to exit the menu."
DO WHILE INKEY()=0
ENDDO
SET COLOR TO &job_proclr
RESTORE SCREEN FROM job_hlpscr
RETURN

PROCEDURE job_IMPO
* allow user to import data
DO job_XSAV
SET RELATION TO   && don't use related during import
DO job_IMPX
DO job_OPEN
RETURN

PROCEDURE job_IMPX
job_dohelp = .T.
DO WHILE job_dohelp
  SET COLOR TO &job_winclr
  @ 22, 0 CLEAR TO 24,79
  @ 22, 0 SAY 'File type:  Ascii Delimited    Fixed Field   Dbase III  Cancel'
  SET COLOR TO &job_proclr
  SET MESSAGE TO 23
  @ 22,12 PROMPT 'Ascii Delimited' MESSAGE "Quoted text, comma delimited text file"
  @ 22,31 PROMPT 'Fixed Field'     MESSAGE "Fixed Length un-delimited file"
  @ 22,45 PROMPT 'Dbase III'       MESSAGE "Standard data-base interface format file"
  @ 22,56 PROMPT 'Cancel'          MESSAGE "Cancel IMPORT"
  MU_I = 0
  MENU TO MU_I
  job_dohelp =  (READKEY()=36 .OR. READKEY()=292)
  IF job_dohelp
    DO job_HLPL
  ENDIF
ENDDO
job_Ftype = SUBSTR("CAFDC",MU_I+1,1)
IF job_Ftype = 'C'
  RETURN
ENDIF
job_FileOK = .F.
job_Fname = job_Rfile
DO WHILE .NOT. job_FileOK
  @ 22, 0 CLEAR TO 24,79
  Mu_IAX = LEFT(job_Fname+SPACE(64),64)
  SET COLOR TO &job_winclr
  @ 22,0 SAY "File Name " GET Mu_IAX PICTURE "@!"
  READ
  SET MESSAGE TO 24
  job_Fname = TRIM(Mu_IAX)
  IF LEN(job_FName)=0
    RETURN
  ENDIF
  DO CASE
   CASE job_FType $ 'AF'
        * Ascii comma delimited, or Standard delimited
    IF .NOT. ( '.' $ job_FName)
      job_FName = job_FName+'.TXT'
    ENDIF
   CASE job_FType='D'
        * database style
    IF .NOT. ( '.' $ job_FName)
      job_FName = job_FName+'.DBF'
    ENDIF
  ENDCASE
  @ 22,11 GET job_FName PICTURE "@!"
  CLEAR GETS
  job_FileOk = FILE(job_FName)
  IF .NOT. job_FileOk
job_dohelp = .T.
DO WHILE job_dohelp
      @ 23,0 SAY 'File not found,  Name  Cancel'
      SET COLOR TO &job_proclr
      @ 23,17 PROMPT 'Name'   MESSAGE 'Edit the file name and try again'
      @ 23,23 PROMPT 'Cancel' MESSAGE 'Cancel IMPORT'
      MU_IA = 0
      MENU TO MU_IA
  job_dohelp =  (READKEY()=36 .OR. READKEY()=292)
  IF job_dohelp
    DO job_HLPL
  ENDIF
ENDDO
    job_MNum = MU_IA
    IF (job_MNum = 0)  .OR. (job_MNum = 2)
      RETURN
    ENDIF
  ENDIF
ENDDO
IF job_xidxd .AND. job_xuniq
job_dohelp = .T.
DO WHILE job_dohelp
    SET COLOR TO &job_winclr
    @ 23,0 CLEAR TO 24,79
    @ 23,0 SAY 'Merge duplicates by   Update  Keep  Cancel'
    SET COLOR TO &job_proclr
    @ 23,22 PROMPT 'Update' MESSAGE 'Update old records with new records'
    @ 23,30 PROMPT 'Keep'   MESSAGE 'Keep old records and skip new records'
    @ 23,36 PROMPT 'Cancel' MESSAGE 'Cancel IMPORT'
    MU_IA = 0
    MENU TO MU_IA
  job_dohelp =  (READKEY()=36 .OR. READKEY()=292)
  IF job_dohelp
    DO job_HLPL
  ENDIF
ENDDO
  job_Mtype = SUBSTR("CUKC",MU_IA+1,1)
  IF job_Mtype = 'C'
    RETURN
  ENDIF
ELSE
  job_Mtype = 'X'
ENDIF
SET COLOR TO &job_winclr
@ 23,0 CLEAR TO 24,79
* read alien file, then merge
SET COLOR TO &job_winclr
DO job_CLRC
DO job_CLRF
@ 23,0
@ 23,0 SAY 'Reading... '
* read the records to work file then merge
DO CASE
 CASE job_FType = 'A'
  APPEND FROM &job_FName DELIMITED
 CASE job_FType = 'F'
  APPEND FROM &job_FName SDF
 CASE job_FType='D'
  APPEND FROM &job_FName
ENDCASE
IF job_Mtype $ 'UK'
  * clean up the table
  SET FILTER TO
  SET ORDER TO 1
  @ 23,0
  @ 23,0 SAY 'Merging... '
  job_MCount = 0
  DO job_IFLD  && fill with blank record initially
  GO TOP
  job_RefRec = 0   && reference record
  DO WHILE .NOT. EOF()
    job_Target = RECNO()  && target record
    job_refkey = job_xmkey  && expands to the reference key value (in vars)
    job_tgtkey = job_xfkey  && expands to the target key value (in fields)
    IF (&job_refkey) == (&job_tgtkey)
        * we have a duplicate
      job_MCount = job_MCount + 1
      IF job_MType = 'U'
          * we must DELETE the reference record
        GO job_RefRec
        DO job_DEL1
      ELSE
          * we must DELETE the current record
        DO job_DEL1
      ENDIF
    ENDIF
    GO job_Target
    IF .NOT. DELETED()
      DO job_LDVR  && refresh the memvars
      @ 23,11 SAY STR(RECNO())
      job_RefRec = RECNO()
    ENDIF
    SKIP
  ENDDO
  @ 23,0
  IF job_MCount = 0
    DO job_DSPM WITH 'No Duplicate keys Found'
  ELSE
    DO job_DSPM WITH LTRIM(STR(job_MCount))+' Duplicates DELETED'
  ENDIF
  SET ORDER TO job_xiord
  IF job_xfflg
    SET FILTER TO &job_xfstr
  ENDIF
ENDIF && Mtype $$ 'UK'
GO TOP
RETURN

PROCEDURE job_IFLD
* Clear field variables
* cycle thru each field
DO job_DSPQ WITH "Initializing"
    JCLIENT    = SPACE(32)
    JADDR      = SPACE(32)
    JPOB       = SPACE(32)
    JCITY      = SPACE(18)
    JSTATE     = SPACE(2)
    JZIP       = SPACE(10)
    JBUSINESS  = SPACE(32)
    JHRATE     = 0.00
    JDRATE     = 0.00
    JTERMS     = SPACE(32)
    JPHONE     = SPACE(13)
    JCONT1     = SPACE(32)
    JEXT1      = SPACE(5)
    JCONT2     = SPACE(32)
    JEXT2      = SPACE(5)
    JCREM      = SPACE(32)
    JCNOTES_   = 'memo'
    JOB        = SPACE(10)
    JQUOTED    = CTOD('  /  /  ')
    JACCEPTED  = CTOD('  /  /  ')
    JSTARTED   = CTOD('  /  /  ')
    JCOMPLETED = CTOD('  /  /  ')
    JDEADLINE  = CTOD('  /  /  ')
    JQUOTE     = 0.00
    JADJUST    = 0.00
    JNET       = 0.00
    JPAID      = 0.00
    JLEFT      = 0.00
    JCOST      = 0.00
    JCASH      = 0.00
    JDRAW      = 0.00
    JCHECK     = 0.00
    JPROFIT    = 0.00
    JTASK      = SPACE(32)
    JTEXT_     = 'memo'
    JBD1       = CTOD('  /  /  ')
    JT1        = SPACE(36)
    JH1        = 0.00
    JR1        = 0.00
    JB1        = 0.00
    JC1        = 0.00
    JBD2       = CTOD('  /  /  ')
    JT2        = SPACE(36)
    JH2        = 0.00
    JR2        = 0.00
    JB2        = 0.00
    JC2        = 0.00
    JBD3       = CTOD('  /  /  ')
    JT3        = SPACE(36)
    JH3        = 0.00
    JR3        = 0.00
    JB3        = 0.00
    JC3        = 0.00
    JBD4       = CTOD('  /  /  ')
    JT4        = SPACE(36)
    JH4        = 0.00
    JR4        = 0.00
    JB4        = 0.00
    JC4        = 0.00
    JBD5       = CTOD('  /  /  ')
    JT5        = SPACE(36)
    JH5        = 0.00
    JR5        = 0.00
    JB5        = 0.00
    JC5        = 0.00
    JHOURS     = 0.00
    JBID       = 0.00
    JRATE      = 0.00
    JAMEMO_    = 'memo'
    JAD1       = CTOD('  /  /  ')
    JAOB1      = SPACE(8)
    JA1        = SPACE(45)
    JAA1       = 0.00
    JAD2       = CTOD('  /  /  ')
    JAOB2      = SPACE(8)
    JA2        = SPACE(45)
    JAA2       = 0.00
    JAD3       = CTOD('  /  /  ')
    JAOB3      = SPACE(8)
    JA3        = SPACE(45)
    JAA3       = 0.00
    JAD4       = CTOD('  /  /  ')
    JAOB4      = SPACE(8)
    JA4        = SPACE(45)
    JAA4       = 0.00
    JAD5       = CTOD('  /  /  ')
    JAOB5      = SPACE(8)
    JA5        = SPACE(45)
    JAA5       = 0.00
    JDC1       = SPACE(32)
    JOK1       = .F.
    IF job_option = 'F'
      JOK1 = SPACE(1)
    ENDIF
    JDD1       = CTOD('  /  /  ')
    JDA1       = 0.00
    JCK1       = SPACE(6)
    JCD1       = CTOD('  /  /  ')
    JP1        = 0.00
    JDC2       = SPACE(32)
    JOK2       = .F.
    IF job_option = 'F'
      JOK2 = SPACE(1)
    ENDIF
    JDD2       = CTOD('  /  /  ')
    JDA2       = 0.00
    JCK2       = SPACE(6)
    JCD2       = CTOD('  /  /  ')
    JP2        = 0.00
    JDC3       = SPACE(32)
    JOK3       = .F.
    IF job_option = 'F'
      JOK3 = SPACE(1)
    ENDIF
    JDD3       = CTOD('  /  /  ')
    JDA3       = 0.00
    JCK3       = SPACE(6)
    JCD3       = CTOD('  /  /  ')
    JP3        = 0.00
    JDC4       = SPACE(32)
    JOK4       = .F.
    IF job_option = 'F'
      JOK4 = SPACE(1)
    ENDIF
    JDD4       = CTOD('  /  /  ')
    JDA4       = 0.00
    JCK4       = SPACE(6)
    JCD4       = CTOD('  /  /  ')
    JP4        = 0.00
    JDC5       = SPACE(32)
    JOK5       = .F.
    IF job_option = 'F'
      JOK5 = SPACE(1)
    ENDIF
    JDD5       = CTOD('  /  /  ')
    JDA5       = 0.00
    JCK5       = SPACE(6)
    JCD5       = CTOD('  /  /  ')
    JP5        = 0.00
  IF job_option $ 'RFI'
    RETURN
  ENDIF
      JQUOTED    = DATE()
RETURN

PROCEDURE job_LIST
PARAMETERS job_lflds
* list records beginning from current record
  SAVE SCREEN TO job_lstscr
  SET COLOR TO &job_winclr
  CLEAR
  DO job_LOOK  WITH (job_lflds) && examine in full screen mode
  IF DELETED()
    GO TOP
  ENDIF
  RESTORE SCREEN FROM job_lstscr
RETURN

PROCEDURE job_LOOK
PARAMETERS job_lflds
* do a browse
  IF LEN(job_lflds)=0
    BROWSE NOMODIFY
  ELSE
    BROWSE FIELDS &job_lflds NOMODIFY
  ENDIF
RETURN

PROCEDURE job_LDVR
* Copy fields from database record to memory variables
DO job_DSPQ WITH "Reading"
DO CASE
  CASE job_filnum = 1
    JCLIENT    = JCLIENT
    JADDR      = JADDR
    JPOB       = JPOB
    JCITY      = JCITY
    JSTATE     = JSTATE
    JZIP       = JZIP
    JBUSINESS  = JBUSINESS
    JHRATE     = JHRATE
    JDRATE     = JDRATE
    JTERMS     = JTERMS
    JPHONE     = JPHONE
    JCONT1     = JCONT1
    JEXT1      = JEXT1
    JCONT2     = JCONT2
    JEXT2      = JEXT2
    JCREM      = JCREM
    JCNOTES_   = "memo"
    JOB        = JOB
    JQUOTED    = JQUOTED
    JACCEPTED  = JACCEPTED
    JSTARTED   = JSTARTED
    JCOMPLETED = JCOMPLETED
    JDEADLINE  = JDEADLINE
    JQUOTE     = JQUOTE
    JADJUST    = JADJUST
    JNET       = JNET
    JPAID      = JPAID
    JLEFT      = JLEFT
    JCOST      = JCOST
    JCASH      = JCASH
    JDRAW      = JDRAW
    JCHECK     = JCHECK
    JPROFIT    = JPROFIT
    JTASK      = JTASK
    JTEXT_     = "memo"
    JBD1       = JBD1
    JT1        = JT1
    JH1        = JH1
    JR1        = JR1
    JB1        = JB1
    JC1        = JC1
    JBD2       = JBD2
    JT2        = JT2
    JH2        = JH2
    JR2        = JR2
    JB2        = JB2
    JC2        = JC2
    JBD3       = JBD3
    JT3        = JT3
    JH3        = JH3
    JR3        = JR3
    JB3        = JB3
    JC3        = JC3
    JBD4       = JBD4
    JT4        = JT4
    JH4        = JH4
    JR4        = JR4
    JB4        = JB4
    JC4        = JC4
    JBD5       = JBD5
    JT5        = JT5
    JH5        = JH5
    JR5        = JR5
    JB5        = JB5
    JC5        = JC5
    JHOURS     = JHOURS
    JBID       = JBID
    JRATE      = JRATE
    JAMEMO_    = "memo"
    JAD1       = JAD1
    JAOB1      = JAOB1
    JA1        = JA1
    JAA1       = JAA1
    JAD2       = JAD2
    JAOB2      = JAOB2
    JA2        = JA2
    JAA2       = JAA2
    JAD3       = JAD3
    JAOB3      = JAOB3
    JA3        = JA3
    JAA3       = JAA3
    JAD4       = JAD4
    JAOB4      = JAOB4
    JA4        = JA4
    JAA4       = JAA4
    JAD5       = JAD5
    JAOB5      = JAOB5
    JA5        = JA5
    JAA5       = JAA5
    JDC1       = JDC1
    JOK1       = JOK1
    JDD1       = JDD1
    JDA1       = JDA1
    JCK1       = JCK1
    JCD1       = JCD1
    JP1        = JP1
    JDC2       = JDC2
    JOK2       = JOK2
    JDD2       = JDD2
    JDA2       = JDA2
    JCK2       = JCK2
    JCD2       = JCD2
    JP2        = JP2
    JDC3       = JDC3
    JOK3       = JOK3
    JDD3       = JDD3
    JDA3       = JDA3
    JCK3       = JCK3
    JCD3       = JCD3
    JP3        = JP3
    JDC4       = JDC4
    JOK4       = JOK4
    JDD4       = JDD4
    JDA4       = JDA4
    JCK4       = JCK4
    JCD4       = JCD4
    JP4        = JP4
    JDC5       = JDC5
    JOK5       = JOK5
    JDD5       = JDD5
    JDA5       = JDA5
    JCK5       = JCK5
    JCD5       = JCD5
    JP5        = JP5
ENDCASE
RETURN



PROCEDURE job_OPEN
* open job_fnum with relations
DO job_clsa  && close all the current
  DO job_XLOD
  DO job_OPN1 WITH (job_filnum)
      SET INDEX TO JOB_JOB,JOB_JBYC
    SET ORDER TO job_xiord
    IF .NOT. job_option $ 'W/'
      job_scrnum = ASC(SUBST(job_xfpgs,job_xfpag,1))
      DO job_DSPS
    ENDIF
IF job_xlast <> 0
  IF job_xlast <= RECCOUNT()
    GOTO job_xlast
  ENDIF
ENDIF
IF job_xfflg
  SET FILTER TO &job_xfstr
  IF .NOT. (&job_xfstr)
    DO job_DSPQ WITH "Scanning"
    GO TOP  && we need to select something based on the FILTER
  ENDIF
ENDIF
DO job_FTST
DO job_STAT
RETURN

PROCEDURE job_OPN1
PARAMETERS job_fnm
* select and open one file, uses primary index (if any)
  job_number = LTRIM(STR(job_fnm))
  SELECT &job_number
  job_tdfnm = job_dfnm
  job_tdals = job_dals
  USE &job_tdfnm ALIAS &job_tdals
  IF job_idxd
    job_tifnm = job_ifnm
    SET INDEX TO &job_tifnm
  ENDIF
  IF job_fnm <> job_filnum
    job_number = LTRIM(STR(job_filnum))
    SELECT &job_number
  ENDIF
  job_used = .T.
RETURN

PROCEDURE job_ORDR
* offer a menu of indexes & choose
job_dohelp = .T.
DO WHILE job_dohelp
  SET COLOR TO R+/N,N/W
  @ 22,0 CLEAR TO 24,79
  SET MESSAGE TO 23
  @ 22,0 SAY 'Order:'
  SET COLOR TO GR+/N,N/W
      @ 22, 7 PROMPT "-RECNUM";
  MESSAGE "By record number order"
      @ 22,16 PROMPT "JOB";
  MESSAGE "Ordered by Job Name"
      @ 22,21 PROMPT "CLIENT";
  MESSAGE "By Client then Job"
  MU_O = job_xiord + 1
  MENU TO MU_O
  job_dohelp =  (READKEY()=36 .OR. READKEY()=292)
  IF job_dohelp
    DO job_HLPL
  ENDIF
ENDDO
@ 22, 0 CLEAR TO 23,79
IF (MU_O = 0)
  RETURN
ENDIF
DO job_OSET WITH (MU_O - 1)
RETURN

PROCEDURE job_OSET
* set search/test macros for job_xiord
PARAMETERS job_neword
job_xiord = job_neword
SET ORDER TO job_xiord
DO CASE
  CASE job_xiord =0
  job_xilst = ""
  job_xikey = ""
  job_xbkey = ""
  CASE job_filnum =1
    DO CASE
      CASE job_xiord =1
       job_xilst = ",JOB,"
       job_xikey = "UPPER(m->JOB)"
       job_xbkey = SPACE(10)
      CASE job_xiord =2
       job_xilst = ",JCLIENT,JOB,"
       job_xikey = "m->JCLIENT+m->JOB"
       job_xbkey = SPACE(32) + SPACE(10)
    ENDCASE
ENDCASE
RETURN

PROCEDURE job_PLWR
  * page lower (page up)
  DO job_DRPS
  job_xfpag = job_xfpag -1
  job_scrnum = ASC(SUBSTR(job_xfpgs,job_xfpag,1))
  DO job_DSPS
  DO job_DSPR
RETURN

PROCEDURE job_PHIR
  DO job_DRPS
  job_xfpag = job_xfpag +1
  job_scrnum = ASC(SUBSTR(job_xfpgs,job_xfpag,1))
  DO job_DSPS
  DO job_DSPR
RETURN

PROCEDURE job_QUIT
* Offer user last chance to quit
job_dohelp = .T.
DO WHILE job_dohelp
  SET COLOR TO &job_winclr
  @ 22, 0 CLEAR TO 24,79
  SET MESSAGE TO 23
  @ 22, 0 SAY 'Are you sure you want to Quit JOB?  NO  YES'
  SET COLOR TO &job_proclr
  @ 22,36  PROMPT 'No'  MESSAGE "No, don't quit the program"
  @ 22,40 PROMPT 'Yes' MESSAGE "Yes, quit the program"
  MU_Q = 0
  MENU TO MU_Q
  job_dohelp =  (READKEY()=36 .OR. READKEY()=292)
  IF job_dohelp
    DO job_HLPL
  ENDIF
ENDDO
job_confrm = MU_Q
IF job_confrm < 2
  job_option     = ''
ENDIF
@ 22, 0 CLEAR TO 23,79
RETURN

PROCEDURE job_REPR
* Replace fields with memory variables
DO job_DSPQ WITH "Writing"
DO CASE
  CASE job_filnum = 1
    REPLACE JCLIENT    WITH m->JCLIENT
    REPLACE JADDR      WITH m->JADDR
    REPLACE JPOB       WITH m->JPOB
    REPLACE JCITY      WITH m->JCITY
    REPLACE JSTATE     WITH m->JSTATE
    REPLACE JZIP       WITH m->JZIP
    REPLACE JBUSINESS  WITH m->JBUSINESS
    REPLACE JHRATE     WITH m->JHRATE
    REPLACE JDRATE     WITH m->JDRATE
    REPLACE JTERMS     WITH m->JTERMS
    REPLACE JPHONE     WITH m->JPHONE
    REPLACE JCONT1     WITH m->JCONT1
    REPLACE JEXT1      WITH m->JEXT1
    REPLACE JCONT2     WITH m->JCONT2
    REPLACE JEXT2      WITH m->JEXT2
    REPLACE JCREM      WITH m->JCREM
    REPLACE JOB        WITH m->JOB
    REPLACE JQUOTED    WITH m->JQUOTED
    REPLACE JACCEPTED  WITH m->JACCEPTED
    REPLACE JSTARTED   WITH m->JSTARTED
    REPLACE JCOMPLETED WITH m->JCOMPLETED
    REPLACE JDEADLINE  WITH m->JDEADLINE
    REPLACE JQUOTE     WITH m->JQUOTE
    REPLACE JADJUST    WITH m->JADJUST
    REPLACE JNET       WITH m->JNET
    REPLACE JPAID      WITH m->JPAID
    REPLACE JLEFT      WITH m->JLEFT
    REPLACE JCOST      WITH m->JCOST
    REPLACE JCASH      WITH m->JCASH
    REPLACE JDRAW      WITH m->JDRAW
    REPLACE JCHECK     WITH m->JCHECK
    REPLACE JPROFIT    WITH m->JPROFIT
    REPLACE JTASK      WITH m->JTASK
    REPLACE JBD1       WITH m->JBD1
    REPLACE JT1        WITH m->JT1
    REPLACE JH1        WITH m->JH1
    REPLACE JR1        WITH m->JR1
    REPLACE JB1        WITH m->JB1
    REPLACE JC1        WITH m->JC1
    REPLACE JBD2       WITH m->JBD2
    REPLACE JT2        WITH m->JT2
    REPLACE JH2        WITH m->JH2
    REPLACE JR2        WITH m->JR2
    REPLACE JB2        WITH m->JB2
    REPLACE JC2        WITH m->JC2
    REPLACE JBD3       WITH m->JBD3
    REPLACE JT3        WITH m->JT3
    REPLACE JH3        WITH m->JH3
    REPLACE JR3        WITH m->JR3
    REPLACE JB3        WITH m->JB3
    REPLACE JC3        WITH m->JC3
    REPLACE JBD4       WITH m->JBD4
    REPLACE JT4        WITH m->JT4
    REPLACE JH4        WITH m->JH4
    REPLACE JR4        WITH m->JR4
    REPLACE JB4        WITH m->JB4
    REPLACE JC4        WITH m->JC4
    REPLACE JBD5       WITH m->JBD5
    REPLACE JT5        WITH m->JT5
    REPLACE JH5        WITH m->JH5
    REPLACE JR5        WITH m->JR5
    REPLACE JB5        WITH m->JB5
    REPLACE JC5        WITH m->JC5
    REPLACE JHOURS     WITH m->JHOURS
    REPLACE JBID       WITH m->JBID
    REPLACE JRATE      WITH m->JRATE
    REPLACE JAD1       WITH m->JAD1
    REPLACE JAOB1      WITH m->JAOB1
    REPLACE JA1        WITH m->JA1
    REPLACE JAA1       WITH m->JAA1
    REPLACE JAD2       WITH m->JAD2
    REPLACE JAOB2      WITH m->JAOB2
    REPLACE JA2        WITH m->JA2
    REPLACE JAA2       WITH m->JAA2
    REPLACE JAD3       WITH m->JAD3
    REPLACE JAOB3      WITH m->JAOB3
    REPLACE JA3        WITH m->JA3
    REPLACE JAA3       WITH m->JAA3
    REPLACE JAD4       WITH m->JAD4
    REPLACE JAOB4      WITH m->JAOB4
    REPLACE JA4        WITH m->JA4
    REPLACE JAA4       WITH m->JAA4
    REPLACE JAD5       WITH m->JAD5
    REPLACE JAOB5      WITH m->JAOB5
    REPLACE JA5        WITH m->JA5
    REPLACE JAA5       WITH m->JAA5
    REPLACE JDC1       WITH m->JDC1
    REPLACE JOK1       WITH m->JOK1
    REPLACE JDD1       WITH m->JDD1
    REPLACE JDA1       WITH m->JDA1
    REPLACE JCK1       WITH m->JCK1
    REPLACE JCD1       WITH m->JCD1
    REPLACE JP1        WITH m->JP1
    REPLACE JDC2       WITH m->JDC2
    REPLACE JOK2       WITH m->JOK2
    REPLACE JDD2       WITH m->JDD2
    REPLACE JDA2       WITH m->JDA2
    REPLACE JCK2       WITH m->JCK2
    REPLACE JCD2       WITH m->JCD2
    REPLACE JP2        WITH m->JP2
    REPLACE JDC3       WITH m->JDC3
    REPLACE JOK3       WITH m->JOK3
    REPLACE JDD3       WITH m->JDD3
    REPLACE JDA3       WITH m->JDA3
    REPLACE JCK3       WITH m->JCK3
    REPLACE JCD3       WITH m->JCD3
    REPLACE JP3        WITH m->JP3
    REPLACE JDC4       WITH m->JDC4
    REPLACE JOK4       WITH m->JOK4
    REPLACE JDD4       WITH m->JDD4
    REPLACE JDA4       WITH m->JDA4
    REPLACE JCK4       WITH m->JCK4
    REPLACE JCD4       WITH m->JCD4
    REPLACE JP4        WITH m->JP4
    REPLACE JDC5       WITH m->JDC5
    REPLACE JOK5       WITH m->JOK5
    REPLACE JDD5       WITH m->JDD5
    REPLACE JDA5       WITH m->JDA5
    REPLACE JCK5       WITH m->JCK5
    REPLACE JCD5       WITH m->JCD5
    REPLACE JP5        WITH m->JP5
ENDCASE
RETURN

PROCEDURE job_RETR
* Accept key and seek record
IF job_xiord = 0
  * Move direct to record number
  Mu_RN = job_xlast
  @ 23,0  SAY ' Which record to goto? (1..'+LTRIM(STR(RECCOUNT()))+') ';
   GET Mu_RN PICTURE '@Z 9999'
  READ
  IF Mu_Rn > 1 .AND. Mu_Rn <= RECCOUNT()
    DO job_DSPQ WITH "Scanning"
    GOTO Mu_Rn
    IF DELETED()
      DO job_DSPM WITH "DELETED"
      SKIP
    ENDIF
  ELSE
    DO job_DSPM WITH "Invalid Number"
  ENDIF
  DO job_SKDN
  RETURN
ENDIF
DO job_EDIT WITH .F.
IF job_xbkey = &job_xikey
    * blank key
  RETURN
ENDIF
job_sk = &job_xikey
IF TYPE([&job_SK])='C'
  * is a character index
  * peel off format characters
  DO WHILE  LEN(job_sk)>0 .AND. RIGHT(job_sk,1) $ '0`~!@#$%^&*-+|\;:/ '
    job_sk = LEFT(job_sk,LEN(job_sk)-1)
  ENDDO
  IF LEN(job_sk)>0
    SEEK job_sk
  ELSE
    DO job_DSPM WITH 'Blank Key'
    RETURN
  ENDIF
ELSE
  * non-character index
  SEEK job_sk
ENDIF
IF EOF()
  DO job_DSPM WITH 'Not found'
  GO job_xlast
ENDIF
RETURN

PROCEDURE job_SKIP
* Move forward/backward several records
Mu_SN = 0
@ 23,0  SAY ' How many records to skip? ' GET Mu_SN PICTURE '@Z 9999'
READ
DO job_DSPQ WITH "Scanning"
SKIP Mu_sn
DO job_SKDN
RETURN

PROCEDURE job_SKDN
* check for boundary conditions
IF EOF()
  DO job_DSPQ WITH "Scanning"
  GO BOTTOM
  DO job_LDVR
  DO job_DSPR
  DO job_DSPM WITH 'Last record'
ENDIF
IF BOF()
  DO job_DSPQ WITH "Scanning"
  GO TOP
  DO job_LDVR
  DO job_DSPR
  DO job_DSPM WITH 'First record'
ENDIF
RETURN

PROCEDURE job_TLLY
* Count and display number of records
SET COLOR TO &job_winclr
@ 23,00
@ 23,00 SAY 'Counting, please wait'
COUNT TO job_number
DO job_DSPM WITH LTRIM(STR(m->job_number)) + ' records out of '+ LTRIM(STR(RECCOUNT())) + ' allocated'
GO job_xlast
RETURN

PROCEDURE job_SLSH
* produce user menu
SET MESSAGE TO 23
MU_WX = 0
job_scrwas = job_scrnum
DO CASE
  CASE job_filnum = 1
    DO job_DRPS
    SET COLOR TO &job_WINCLR
    job_scrnum = 6
    DO job_DSPS
    DO job_CLOS
    DO WHILE .T.
      DO job_OPEN
      SET COLOR TO &job_WINCLR
      @ 22,0 CLEAR TO 24,79
      @ 23,21 SAY '<Enter> to Select - <Escape> to Exit'
job_dohelp = .T.
DO WHILE job_dohelp
        DO job_COLR WITH "N/BG"
        @  18,  1 PROMPT " DOS Command   - execute an operating system command"
        @  19,  1 PROMPT " Import File   - import records from an external file"
        @  20,  1 PROMPT " Export File   - export records to an external file"
        MENU TO MU_WX
  job_dohelp =  (READKEY()=36 .OR. READKEY()=292)
  IF job_dohelp
    DO job_HLPL
  ENDIF
ENDDO
      IF MU_WX = 0
        DO job_DRPS
        job_scrnum = job_scrwas
        SET COLOR TO &job_WINCLR
        DO job_DSPS
        RETURN
      ENDIF
      SAVE SCREEN TO job_repscr
      DO CASE
        CASE MU_WX = 1
SET COLOR TO &job_WINCLR
DO MYSHELL
        CASE MU_WX = 2
          job_Rtype = "I"
          job_Rfile = ""
          DO job_IMPO
        CASE MU_WX = 3
          job_Rtype = "X"
          job_Rfile = ""
          DO job_WRTX
      ENDCASE
      RESTORE SCREEN FROM job_repscr
  ENDDO
ENDCASE
RETURN

PROCEDURE job_STAT
* update status at TOP of screen
SET COLOR TO &job_staclr
@ 0, 0
IF job_filnum > 0
  @ 0, 0 SAY ALIAS(job_filnum)
ELSE
  @ 0, 0 SAY "** NO FILE **"
ENDIF
@ 0,12 SAY CDOW(DATE())
@ 0,23 SAY DATE()
@ 0,33 SAY LEFT(TIME(),5)
@ 0,40 SAY SPACE(5)
@ 0,40 SAY "Page "+LTRIM(STR(job_xfpag))+' of '+LTRIM(STR(LEN(job_xfpgs)))
@ 0,70 SAY SPACE(9)
IF job_filnum > 0
  IF job_xfflg
    @ 0,70 SAY "FILTER ON"
  ENDIF
ENDIF
RETURN


PROCEDURE job_WRTE
* write an external report
SET MESSAGE TO 23
MU_WX = 0
job_scrwas = job_scrnum
DO CASE
  CASE job_filnum = 1
    DO job_DRPS
    SET COLOR TO &job_WINCLR
    job_scrnum = 7
    DO job_DSPS
    DO job_CLOS
    DO WHILE .T.
      DO job_OPEN
      SET COLOR TO &job_WINCLR
      @ 22,0 CLEAR TO 24,79
      @ 23,21 SAY '<Enter> to Select - <Escape> to Exit'
job_dohelp = .T.
DO WHILE job_dohelp
        DO job_COLR WITH "BU/G"
        @  18, 11 PROMPT " Client Directory   - All Client Names"
        @  19, 11 PROMPT " Job Directory      - All Job Names"
        @  20, 11 PROMPT " Mailing Labels     - 1/up for Clients"
        MENU TO MU_WX
  job_dohelp =  (READKEY()=36 .OR. READKEY()=292)
  IF job_dohelp
    DO job_HLPL
  ENDIF
ENDDO
      IF MU_WX = 0
        DO job_DRPS
        job_scrnum = job_scrwas
        SET COLOR TO &job_WINCLR
        DO job_DSPS
        RETURN
      ENDIF
      SAVE SCREEN TO job_repscr
      DO CASE
        CASE MU_WX = 1
          job_Rtype = "R"
          job_Rfile = "job_CLDY"
          DO job_WRTX
        CASE MU_WX = 2
          job_Rtype = "R"
          job_Rfile = "job_JBDY"
          DO job_WRTX
        CASE MU_WX = 3
          job_Rtype = "L"
          job_Rfile = "job_CLNT"
          DO job_WRTX
      ENDCASE
      RESTORE SCREEN FROM job_repscr
  ENDDO
ENDCASE
RETURN

PROCEDURE job_WRTX
* allow user to print/output
SET COLOR TO &job_proclr
@ 22, 0 CLEAR TO 24,79
IF job_Rtype $ 'XRL'
  job_FName = job_Rfile
ELSE
  job_FName = ''
ENDIF
IF job_Rtype = 'X'
  job_Fto = 'F'
ENDIF
IF job_rtype $ 'RLC' && report form,label form,Concentric R&R
  job_Ftype = 'T'
job_dohelp = .T.
DO WHILE job_dohelp
    SET COLOR TO &job_winclr
    SET MESSAGE TO 23
    @ 22, 0 SAY "Write To:  "
    SET COLOR TO &job_proclr
    @ 22,11 Prompt 'Screen'  MESSAGE 'Write to the Screen'
    @ 22,19 PROMPT 'Printer' MESSAGE 'Write to the Printer'
    @ 22,28 PROMPT 'File'    MESSAGE 'Write to a File'
    @ 22,34 PROMPT 'Edit'    MESSAGE 'Edit the driver file'
    MU_W = 0
    MENU TO MU_W
  job_dohelp =  (READKEY()=36 .OR. READKEY()=292)
  IF job_dohelp
    DO job_HLPL
  ENDIF
ENDDO
  job_FTo = SUBSTR("XSPFE",MU_W+1,1)
  DO CASE
    CASE job_Fto = 'X'
      RETURN
    CASE job_Fto = 'E'
      DO CASE
        CASE job_Rtype = 'R'
          IF FILE(job_Rfile+".FRM")
            MODIFY REPORT &job_Rfile
          ELSE
            CREATE REPORT &job_Rfile
          ENDIF
        CASE job_Rtype = 'L'
          IF FILE(job_Rfile+".LBL")
            MODIFY LABEL &job_Rfile
          ELSE
            CREATE LABEL &job_Rfile
          ENDIF
        CASE job_Rtype = 'C'
            RUN RR &job_Rlbry/L "&job_Rfile"/R
      ENDCASE
      RETURN
  ENDCASE
ENDIF
IF job_RType = 'X'
  * file xport
  job_Fto = 'F' && always to a file
  job_FType = 'A'        && default to ascii
  * we are going to generate a file
job_dohelp = .T.
DO WHILE job_dohelp
    @ 22,0
    SET COLOR TO &job_winclr
    @ 22, 0 SAY 'File type:   Ascii Delimited    Fixed Field   Dbase III'
    SET COLOR TO &job_proclr
    SET MESSAGE TO 23
    @ 22,13 PROMPT 'Ascii Delimited' MESSAGE "Quoted text, comma delimited text file"
    @ 22,32 PROMPT 'Fixed Field'     MESSAGE "Fixed Length un-delimited file"
    @ 22,46 PROMPT 'Dbase III'       MESSAGE "Standard data-base interface format file"
    MU_WF = 0
    MENU TO MU_WF
  job_dohelp =  (READKEY()=36 .OR. READKEY()=292)
  IF job_dohelp
    DO job_HLPL
  ENDIF
ENDDO
  job_Ftype = SUBSTR("XAFD",MU_WF+1,1)
  IF job_Ftype = 'X'
    RETURN
  ENDIF
ENDIF  && job_RType = 'F'
IF job_Fto = 'F'
  * writing to a file, get the name
  job_FileOK = .F.
  DO WHILE .NOT. job_FileOK
    @ 22, 0 CLEAR TO 24,79
    Mu_WFAX = LEFT(job_FName+SPACE(64),64)
    SET COLOR TO &job_winclr
    @ 22,0 SAY "File Name " GET Mu_WFAX PICTURE "@!"
    READ
    SET MESSAGE TO 24
    job_FName = TRIM(Mu_WFAX)
    IF LEN(job_FName)=0
      RETURN
    ENDIF
    DO CASE
      CASE job_FType $ 'TAF'
        * Ascii comma delimited, or Standard delimited
        IF .NOT. ( '.' $ job_FName)
          job_FName = job_FName+'.TXT'
        ENDIF
      CASE job_FType='D'
        * dbase III flavor
        IF .NOT. ( '.' $ job_FName)
          job_FName = job_FName+'.DBF'
        ENDIF
    ENDCASE
    @ 22,11 GET job_FName PICTURE "@!"
    CLEAR GETS
    job_FileOk = .NOT. FILE(job_FName)
    IF .NOT. job_FileOk
job_dohelp = .T.
DO WHILE job_dohelp
        @ 23,0 SAY 'File exists,  OverWrite  Name'
        SET COLOR TO &job_proclr
        @ 23,14 PROMPT 'OverWrite' MESSAGE 'Replace the file with new output'
        @ 23,25 PROMPT 'Name'      MESSAGE 'Edit the file name and try again'
        MU_WFA = 0
        MENU TO MU_WFA
  job_dohelp =  (READKEY()=36 .OR. READKEY()=292)
  IF job_dohelp
    DO job_HLPL
  ENDIF
ENDDO
      job_Choice = MU_WFA
      IF job_Choice = 0
        RETURN
      ENDIF
      IF job_Choice = 2
        LOOP
      ENDIF
      job_FileOk = .T.
    ENDIF
  ENDDO
ENDIF  && job_Fto = 'F'
SET COLOR TO &job_winclr
@ 24,0 SAY "Writing..."
DO CASE
  CASE job_FType = 'A'
    COPY TO &job_FName DELIMITED
    RETURN
  CASE job_FType = 'F'
    COPY TO &job_FName SDF
    RETURN
  CASE job_FType='D'
    COPY TO &job_FName
    RETURN
ENDCASE
* report form, label form, report writer
DO CASE
  CASE job_Rtype = 'R'
    * Report Form
    IF .NOT. FILE('&job_Rfile..FRM')
      SET MESSAGE TO 24
      @ 23,0 SAY "File not found, Create? Yes No"
      @ 23,24 PROMPT "Yes" MESSAGE "Create a report form"
      @ 23,28 PROMPT "No"  MESSAGE "Cancel the write"
      MENU TO MU_WCF
      IF MU_WCF = 1
        CREATE REPORT &job_Rfile
      ENDIF
      RETURN
    ENDIF
    DO CASE
      CASE job_Fto = 'S'
        REPORT FORM &job_Rfile
        WAIT
      CASE job_Fto = 'P'
        REPORT FORM &job_Rfile TO PRINT NOEJECT
        WAIT
      CASE job_Fto = 'F'
        REPORT FORM &job_Rfile TO FILE &job_Fname NOEJECT
        WAIT
    ENDCASE
  CASE job_Rtype = 'L'
    * Label Form
    IF .NOT. FILE('&job_Rfile..LBL')
      SET MESSAGE TO 24
      @ 23,0 SAY "File not found, Create? Yes No"
      @ 23,24 PROMPT "Yes" MESSAGE "Create a label form"
      @ 23,28 PROMPT "No"  MESSAGE "Cancel the write"
      MENU TO MU_WCF
      IF MU_WCF = 1
        CREATE LABEL &job_Rfile
      ENDIF
      RETURN
    ENDIF
    DO CASE
      CASE job_Fto = 'S'
        LABEL FORM &job_Rfile
        WAIT
      CASE job_Fto = 'P'
        LABEL FORM &job_Rfile SAMPLE TO PRINT
        WAIT
      CASE job_Fto = 'F'
        LABEL FORM &job_Rfile TO FILE &job_Fname
        WAIT
    ENDCASE
  CASE job_Rtype = 'C'
    IF .NOT. FILE('&job_Rlbry..RP1')
      SET MESSAGE TO 24
      @ 23,0 SAY "File not found, Create? Yes No"
      @ 23,24 PROMPT "Yes" MESSAGE "Create an R&R report"
      @ 23,28 PROMPT "No"  MESSAGE "Cancel the write"
      MENU TO MU_WCF
      IF MU_WCF = 1
        RUN RR &job_Rlbry/L "&job_Rfile"/R
      ENDIF
      RETURN
    ENDIF
    * Concentric R&R report
    CLOSE DATABASES
    IF .NOT. FILE("RR_PRO.DBF")
      * report driver file missing
      DO job_DSPM WITH "RR_PRO.DBF not found!"
      RETURN
    ENDIF
    USE RR_PRO      && will drive the transaction
    SET DELETED OFF
    LOCATE FOR DELETED()
    IF eof()
      APPEND BLANK
    ELSE
      RECALL
    ENDIF
    SET DELETED ON
    REPLACE ri_report  WITH job_Rfile
    REPLACE ri_library WITH job_Rlbry
    REPLACE ri_master  WITH job_xdfnm
    REPLACE ri_disperr WITH .T.
    REPLACE ri_iamat WITH job_xlast
    IF 'F' $ job_RTail
      IF job_xfflg
        * we have an active filter
        REPLACE ri_query WITH 'O'
        job_xfstra = job_xfstr
        DO WHILE '==' $ job_xfstra
          job_xfstra = STUFF(job_xfstra,AT('==',job_xfstra),1,'')
        ENDDO
        REPLACE ri_filter WITH job_xfstra
      ELSE
        REPLACE ri_query WITH 'E'
      ENDIF
    ELSE
      REPLACE ri_query WITH 'S'
    ENDIF
    DO CASE
      CASE job_FTo = 'S'
        * report to the screen
        REPLACE ri_printer WITH 'D'
        REPLACE ri_outfile WITH ''
      CASE job_FTo = 'P'
        * report to printer
        REPLACE ri_printer WITH '0'
        REPLACE ri_outfile WITH ''
      CASE job_FTo = 'F'
        * report to file
        REPLACE ri_printer WITH '0'
        REPLACE ri_outfile WITH job_FName
        REPLACE ri_outappn WITH .F.
    ENDCASE
    rr_recno = LTRIM(STR(RECNO()))
    USE
    RUN RRUNTIME RR_PRO &RR_RECNO U&RR_RECNO/I
    ERASE RR&RR_RECNO..DBF  && clean house
    USE RR_PRO      && will drive the transaction
    GOTO VAL(RR_RECNO)
    DO job_DEL1
    IF job_FTo $ 'FP'
      WAIT
    ENDIF
    RETURN
ENDCASE
RETURN

PROCEDURE job_XSAV
* save array items for job_filnum
  job_last = job_xlast
  job_fpag = job_xfpag
  job_fstr = job_xfstr
  job_frem = job_xfrem
  job_fflg = job_xfflg
  job_iord = job_xiord
  job_ilst = job_xilst
  job_ikey = job_xikey
  job_bkey = job_xbkey
RETURN

PROCEDURE job_XLOD
* get array items for job_filnum
  job_xdfnm = job_dfnm
  job_xdals = job_dals
  job_xllst = job_llst
  job_xlast = job_last
  job_xfpgs = job_fpgs
  job_xfpag = job_fpag
  job_xmenu = job_menu
  job_xfstr = job_fstr
  job_xfrem = job_frem
  job_xfflg = job_fflg
  job_xidxd = job_idxd
  job_xifnm = job_ifnm
  job_xuniq = job_uniq
  job_xfill = job_fill
  job_xmkey = job_mkey
  job_xfkey = job_fkey
  job_xnkey = job_nkey
  job_xckey = job_ckey
  job_xiord = job_iord
  job_xilst = job_ilst
  job_xikey = job_ikey
  job_xbkey = job_bkey
RETURN

PROCEDURE job_ZDIV
PARAMETERS job_OVER,job_UNDER
IF job_UNDER = 0
  RETURN 0
ENDIF
RETURN job_OVER/job_UNDER

* customizing procedures
PROCEDURE MYSHELL
* SHELL EXECUTIVE PROGRAM
STORE SPACE(60) TO CMD
@ 23,0 SAY "COMMAND :" GET CMD
READ
IF LEN(TRIM(CMD))>0
  RUN &CMD
  WAIT
ENDIF
RETURN
* Eof.: JOB.PRG
