SET TALK OFF
****Example 1*****************************************
DO defwbar WITH 4,4,"",0,30
FOR I = 1 TO 1234
 DO upd8wbar with 1234,I,30,""
ENDFOR
WAIT "Example 1: basic 30 column bar." WINDOW
DO endwbar
****Example 2*****************************************
DO defwbar WITH 7,16,"Example number 2",0,43
FOR I = 1 TO 2450
 DO upd8wbar with 2450,I,43,""
ENDFOR
WAIT "Example 2: 43 column bar, titled window." WINDOW
DO endwbar
****Example 3*****************************************
DO defwbar WITH 8,10,"Example number 3",1,55
FOR I = 1 TO 987
 DO upd8wbar with 987,I,55,"Additional text goes here."
ENDFOR
WAIT "Example 3: 55 column bar, titled window, additional text." WINDOW
DO endwbar
******************************************************
SET TALK ON

******************************************************
PROCEDURE defwbar
 PARAMETERS mycoord, mxcoord, mtitle, mtextflg, mbarlen
 * mycoord  - Y coordinate for upper left corner of window
 * mxcoord  - X coordinate for upper left corner of window
 * mtitle   - Optional title for window. Send "" for no title.
 * mtextflg - Send 1 if text line is needed, 0 otherwise.
 * mbarlen  - Length of progress bar.
 DEFINE WINDOW waitbar FROM mycoord,mxcoord TO;
        mycoord+IIF(mtextflg=0,4,5),mxcoord+mbarlen+8;
        IN SCREEN COLOR SCHEME 5;
        TITLE IIF(!EMPTY(mtitle),PADC(mtitle,LEN(mtitle)+2),"")
 RETURN
******************************************************
PROCEDURE upd8wbar
PARAMETERS mtotal, mnow, mbarlen, mtext
 * mtotal  - Total number of increments.
 * mnow    - Current value of increment counter.
 * mbarlen - Length of progress bar. Should match value sent to defwbar.
 * mtext   - Optional additional text line. Use only if 1 was sent to
 *           defwbar in mtextflg. If not needed send "".
 ACTIVATE WINDOW waitbar
 mnotdone = replicate (' ',80)
 mdone    = replicate ('',80)
 mfrac = mbarlen/mtotal
 mcut = INT(mbarlen-(mfrac*mnow))
 IF !EMPTY(mtext)
   @0,1 SAY mtext
 ENDIF
 @IIF(EMPTY(mtext),1,2),1 SAY LEFT(mdone,mbarlen-mcut)
 @IIF(EMPTY(mtext),1,2),1+LEN(LEFT(mdone,mbarlen-mcut));
      SAY LEFT(mnotdone,mcut) COLOR W+/N
 @IIF(EMPTY(mtext),1,2),1+LEN(LEFT(mdone,mbarlen-mcut)+LEFT(mnotdone,mcut));
      SAY " "+STR((mnow/mtotal)*100,3,0)+"%"
RETURN
******************************************************
PROCEDURE endwbar
 DEACTIVATE WINDOW waitbar
 RELEASE WINDOW waitbar
RETURN
