*:*********************************************************************
*:         System: PRO2EROR v. 1.03
*:         Author: Pat Adams
*:      Copyright (c) 1991, Pat Adams, DB Unlimited
*:  Last modified: 10/12/91     14:12
*:
*:  Procs & Fncts: ERORSET
*:               : NO_FILE
*:               : GO_MASTR
*:               : FILE_BUSY
*:               : GO_AGAIN
*:               : TOO_HIGH
*:               : LOWFILES
*:               : INDEX_ER
*:               : SETENVMT
*:               : SAVE_IT
*:               : QQUIT
*:               : NOMEMO
*:               : LOWMEMRY
*:               : BAD_RPT
*:               : BADMEMFL
*:               : NOSPACE
*:               : TO_PRN
*:               : KORRUPT
*:               : REC_BUSY
*:               : READONLY
*:               : BAD_DIF
*:               : BAD_SYLK
*:               : NOTRIGHT
*:               : BADLOTUS
*:               : INVALPRN
*:               : NOTREADY
*:               : SQL_INTL
*:               : SQLTRASH
*:               : NOSQLIDX
*:               : SQL_IDX
*:               : SQLABORT
*:               : BADCHAIN
*:               : BADRIGHTS
*:               : NOCREAT
*:               : READ_ERR
*:               : RITE_ERR
*:               : BADCLOSE
*:               : REALBAD
*:               : VERBOSE
*:               : NORUN
*:               : PKORRUPT
*:               : BADEXCEL
*:               : BADSYMPH
*:               : NOACCESS
*:               : NO_CDX
*:               : PROGBUG
*:               : RAZBERRY
*:               : LOGVIEW
*:               : MEMOVIEW
*:               : YES_NO
*:               : NICECHIM
*:               : A_LERT
*:               : ISLAN
*:               : KANCEL
*:
*:         Set by: ERORSET            (procedure in PRO2EROR.PRG)
*:
*:          Calls: ERORSET            (procedure in PRO2EROR.PRG)
*:               : NO_FILE            (procedure in PRO2EROR.PRG)
*:               : GO_MASTR           (procedure in PRO2EROR.PRG)
*:               : FILE_BUSY          (procedure in PRO2EROR.PRG)
*:               : GO_AGAIN           (procedure in PRO2EROR.PRG)
*:               : TOO_HIGH           (procedure in PRO2EROR.PRG)
*:               : LOWFILES           (procedure in PRO2EROR.PRG)
*:               : INDEX_ER           (procedure in PRO2EROR.PRG)
*:               : SETENVMT           (procedure in PRO2EROR.PRG)
*:               : SAVE_IT            (procedure in PRO2EROR.PRG)
*:               : QQUIT              (procedure in PRO2EROR.PRG)
*:               : NOMEMO             (procedure in PRO2EROR.PRG)
*:               : LOWMEMRY           (procedure in PRO2EROR.PRG)
*:               : BAD_RPT            (procedure in PRO2EROR.PRG)
*:               : BADMEMFL           (procedure in PRO2EROR.PRG)
*:               : NOSPACE            (procedure in PRO2EROR.PRG)
*:               : TO_PRN             (procedure in PRO2EROR.PRG)
*:               : KORRUPT            (procedure in PRO2EROR.PRG)
*:               : REC_BUSY           (procedure in PRO2EROR.PRG)
*:               : READONLY           (procedure in PRO2EROR.PRG)
*:               : BAD_DIF            (procedure in PRO2EROR.PRG)
*:               : BAD_SYLK           (procedure in PRO2EROR.PRG)
*:               : NOTRIGHT           (procedure in PRO2EROR.PRG)
*:               : BADLOTUS           (procedure in PRO2EROR.PRG)
*:               : INVALPRN           (procedure in PRO2EROR.PRG)
*:               : NOTREADY           (procedure in PRO2EROR.PRG)
*:               : SQL_INTL           (procedure in PRO2EROR.PRG)
*:               : SQLTRASH           (procedure in PRO2EROR.PRG)
*:               : NOSQLIDX           (procedure in PRO2EROR.PRG)
*:               : SQL_IDX            (procedure in PRO2EROR.PRG)
*:               : SQLABORT           (procedure in PRO2EROR.PRG)
*:               : BADCHAIN           (procedure in PRO2EROR.PRG)
*:               : BADRIGHTS          (procedure in PRO2EROR.PRG)
*:               : NOCREAT            (procedure in PRO2EROR.PRG)
*:               : READ_ERR           (procedure in PRO2EROR.PRG)
*:               : RITE_ERR           (procedure in PRO2EROR.PRG)
*:               : BADCLOSE           (procedure in PRO2EROR.PRG)
*:               : REALBAD            (procedure in PRO2EROR.PRG)
*:               : VERBOSE            (procedure in PRO2EROR.PRG)
*:               : NORUN              (procedure in PRO2EROR.PRG)
*:               : PKORRUPT           (procedure in PRO2EROR.PRG)
*:               : BADEXCEL           (procedure in PRO2EROR.PRG)
*:               : BADSYMPH           (procedure in PRO2EROR.PRG)
*:               : NOACCESS           (procedure in PRO2EROR.PRG)
*:               : NO_CDX             (procedure in PRO2EROR.PRG)
*:               : PROGBUG            (procedure in PRO2EROR.PRG)
*:
*:      Documented 10/12/91 at 14:14               FoxDoc  version 2.10
*:*********************************************************************
*   PROGRAM: PRO2EROR.PRG
*   VERSION: 1.03
*   AUTHOR:  Pat Adams, DB Unlimited  (718) 469-4032
*   DATE:    10/12/91
*
*   Special thanks to Menachem Bazian, Blaise Mitsutama, John
*   Hoffman, Jordan Powell, Jeri Rosenhaft, and Richard Plant
*   for their assistance in alpha and beta testing, bug swatting
*   and suggestions for additional features.
*
*   USE RESTRICTIONS: You may use PRO2EROR and modifications
*   thereof as part of your applications without prior authorization
*   from DB Unlimited and without payment to DB Unlimited.  PRO2EROR
*   may be freely distributed on electronic BBSes and via non-profit
*   user group disk libraries.  PRO2EROR and modifications thereof
*   may *NOT* be sold as shareware or as a commercial product.  Use of
*   the PRO2EROR routine and modifications thereof in articles and
*   books is reserved solely to DB Unlimited.
*
*   NOTE: This routine is specific to FoxPro 2.x.  Because it
*   uses commands and functions new in FoxPro 2.x it will not
*   work properly with FoxPro 1.x.  The original PROERROR.PRG
*   should be used with FoxPro 1.x.
*
*   Information is stored to the PRO2EROR.DBF file and then
*   the user is returned to master calling program if a RETRY
*   is not issued.  Please note that PRO2EROR closes all files
*   and indexes before issuing a RETURN TO MASTER.  PRO2EROR expects
*   that the MASTER level file will (re) initialize all necessary global
*   memvars, open databases and indexes, etc. as required for a
*   particular system.
*
*   When it is necessary to provide the user with the name and phone
*   number of an individual to call regarding an error the CALLWHOM
*   database is opened and the record for the appropriate individual
*   is sought.  The titles supplied in the CALLWHOM database which
*   accompanies this program should not be changed without modification
*   of the PRO2EROR program.  The information for DEVELOPER is displayed
*   if the error is the result of a programming bug or syntax error.
*   Information for APP ADMINISTRATOR is called if files are missing
*   or other errors occur which require the attention of the applications
*   administrator.  LAN ADMINISTRATOR information is displayed if the
*   errors are related to specific LAN situations such as inappropriate
*   user authorizations on the LAN.
*
*   Initializing a logical PUBLIC memvar named TESTING during test cycles
*   of your code will trigger an option in the STORE_IT module which
*   will provide you with the option of viewing the PRO2EROR file at
*   the time the error condition occurs.  This module also permits
*   exit to DOS via use of the CONTROL-Q key combination.  If the
*   interactive version of FoxPro 2.0 is in use the ESC key can be
*   used to return to the command window after viewing the error log.
*
*   Utilize the following command to set up this system to
*   respond to FoxPro 2.x errors:
*
*   ON ERROR DO PRO2EROR WITH ERROR(), MESSAGE(), MESSAGE(1), ;
*      SYS(16), LINENO(), SYS(102), SYS(100), SYS(101), LASTKEY(), ;
*       ALIAS(), SYS(18), SYS(5), SYS(12), SYS(6), SYS(2003), WONTOP(), ;
*       SYS(2011), SYS(2018)
*
*   or as an alternative:
*
*       [SET PROCEDURE TO pro2eror]
*       DO erorset
*
*  Parameters are:
*
*   xerno =    The numeric code of the number provided by ERROR()
*   xmsg =     The error message provided by MESSAGE()
*   xkode =    The contents of the line of code which
*                 triggered the error as provided by MESSAGE(1)
*   xmodul =   The name of the code module, SYS(16)
*   xline =    The number of the line of code triggering the
*                 error, LINENO()
*   xprint =    Current PRINTER setting as per SYS(102)
*   xkonsol =   Current CONSOLE setting as per SYS(100)
*   xdevice =   Current DEVICE setting as per SYS(101)
*   keypress =  LASTKEY()
*   curr_dbf =  Selected .DBF when error occurred
*   getfield =  Field of GET...READ at time error occurred
*   def_drive = Default drive at time error occurred - SYS(5)
*   run_memry = Amount of DOS memory available for RUN command - SYS(12)
*   prnt_devic= Current SET PRINTER TO setting - SYS(6)
*   cur_direc = Current directory at time error occurred - SYS(2003)
*   top_win =   Top window at time error occurred
*   xlocked =   Record or file lock status at time error occurred -
*                 SYS(2011)  NOTE: This should be removed for
*                 single user applications
*   xmissing =  Missing file, window, etc.
*
*  In addition to this information, the routine saves the information
*  from LIST MEMORY and LIST STATUS is saved into the memo field.
*
*   Modified by Pat Adams 8/30/91
*      CLEAR TYPEAHEAD statements added throughout to
*      avoid potential problems if users hold down keys
*      or mouse button too long.
*
*   Modified by Pat Adams 9/10/91
*      The ON ERROR statement was changed to substitute ALIAS()
*      for DBF().  In the August 9, 1991 patch of baseline 1
*      DBF() returns the drive designation of the file while
*      ALIAS() does not.
*
*   Modified by Pat Adams 9/20/91
*       CURS_SET memvar initialized to hold cusor setting at
*       time error occurred.  Cursor setting is then reinitalized
*       upon a RETURN TO MASTER or RETRY.
*
*   Modified by Pat Adams 10/12/91
*       Minor bug fixes
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PARAMETERS xerno, xmsg, xkode, xmodul, xline, xprint, ;
   xkonsol, xdevice, keypress, curr_dbf, getfield, def_drive, ;
   run_memry, prnt_devic, cur_direc, top_win, xlocked, xmissing
PRIVATE tryagain, lstext, lmtext, printit, curs_set
STORE SET("CURSOR") TO curs_set
SET PRINT OFF
SET DEVICE TO SCREEN
STORE .F. TO tryagain
ON ERROR ?? CHR(7)
CLEAR TYPEAHEAD

IF xerno=104 .OR. xerno=181 .OR. xerno=182 .OR. xerno=279;
      .OR. xerno=4 .OR. xerno=1107 .OR. xerno=1001
   * ===========================================================
   *$ Ignore these errors and continue with program execution
   *
   * Error #104 occurs when ON KEY LABEL calls to function keys
   * F11 and F12 are made on older keyboards which do not support
   * these keys.  It does not trap illegal SET FUNCTION x calls.
   *
   * Error #181, "MENU is already in use", occurs when an
   * attempt is made to activate a MENU which has already
   * been activated.
   *
   * Error #182, "POPUP is already in use", occurs when an
   * attempt is made to activate a POPUP which has already
   * been activated.
   *
   * Error #279, "Prompts for this popup have already been
   * defined" occurs when an attempt is made to use the BAR
   * option to define contents of a POPUP already defined
   * with PROMPT.
   *
   * Error #4 = "End of file encountered"
   *
   * Error #1107 = "Structural CDX file reference removed"
   *
   * Error #1001 = "Feature not available"  In some instances
   *               the single-user version of FoxPro 2.0 may
   *               return this error when multi-user commands
   *               are utilized.
   * ===========================================================
   SET CONSOLE &xkonsol
   * =========================================
   * &macro substitution is utilized since
   * EVALUATE() does not work with SET commands
   * =========================================
   SET DEVICE TO &xdevice
   DO erorset
   * ==================================================
   * Ignore the error and return to the line of
   * code following the one which generated the error
   * ==================================================
   RETURN
ENDIF  (xerno=104 .OR. xerno=181 .OR. xerno=182 .OR. xerno=279;)

SET TALK OFF
SET PRINT OFF
SET PRINTER TO prn
SET DEVICE TO SCREEN

DO CASE xerno
   CASE xerno = 1 .OR. xerno = 802 .OR. xerno = 1162
      * =================================================
      *$ File does not exist or can not be found.
      *  Error #1 applies to standard FoxPro file while
      *  error #802 specifically references a SQL database
      *  Error #1162 applies to an unfound PROCEDURE
      *  Pop up window to inform user
      * =================================================
      DO no_file WITH xmissing
      DO go_mastr
      
   CASE xerno = 3 .OR. xerno = 108
      * ============================================================
      *$ Advise user file is in use and provide option to try again
      *  NOTE: This case statement can be omitted for single user aps
      *        since it will only be triggered in FoxPro LAN.
      * ============================================================
      DO file_busy WITH tryagain
      
      IF tryagain
         * =============================
         *$ Retry for use of the file
         * =============================
         DO go_again
         SET CURSOR &curs_set
         RETRY
      ELSE
         * ============================================
         *$ Abort and return to the MASTER module
         *  Information is saved to PRO2EROR database
         *  to provide a log of how often LAN users can
         *  not get use of a file.  If this situation
         *  occurs frequently it may mean that others on
         *  the LAN are using files interactively with
         *  EXCLUSIVE ON, that REPROCESS needs a higher
         *  value or that the source code needs to be
         *  rewritten to avoid such frequent contentions.
         * ============================================
         DO go_mastr
      ENDIF  (tryagain)
      
   CASE xerno = 5
      * =======================================
      *$ Record is out of range
      *  Advise user & return to MASTER module
      * =======================================
      DO too_high
      DO go_mastr
      
   CASE xerno = 6
      * =====================
      *$ Too many files open
      * =====================
      DO lowfiles
      DO go_mastr
      
   CASE xerno = 19 .OR. xerno = 20 .OR. xerno = 114
      * ==============================================
      *$ Index error problems - Recreate indexes
      * ==============================================
      DO index_er
      DO setenvmt
      DO save_it
      * ==============
      *$ Quit to DOS
      * ==============
      DO qquit
      
   CASE xerno = 38
      * ==============================================
      *$ Attempt has been made to position record
      *  pointer before the first record in the file.
      *  Correct by going to top of file, skipping down
      *  one record, then retrying the same command line.
      * ==============================================
      GO TOP
      SKIP
      DO go_again
      RETRY
      
   CASE xerno = 41
      * =========================================
      *$ Missing or invalid MEMO file
      *  NOTE: Depending upon the application,
      *  it may be desirable to modify this
      *  CASE statement to return the user to DOS
      * =========================================
      DO nomemo
      DO go_mastr
      
   CASE xerno = 43 .OR. xerno = 809 .OR. xerno = ;
         845 .OR. xerno = 1149 .OR. xerno = 1150 ;
         .OR. xerno = 1151 .OR. xerno = 1600
      * ==============================
      *$ Insufficient memory
      * ==============================
      DO lowmemry
      DO setenvmt
      DO save_it
      * ==============
      *$ Quit to DOS
      * ==============
      DO qquit
      
   CASE xerno = 50 .OR. xerno = 54 .OR. xerno = 1241 ;
         .OR. xerno = 1243 .OR. xerno = 1245 .OR. ;
         xerno = 1246 .OR. xerno = 1645 .OR. ;
         xerno = 1646 .OR. xerno = 1647
      * ===============================================
      *$ Report form or label form problems
      * ===============================================
      DO bad_rpt WITH xerno
      DO go_mastr
      
   CASE xerno = 55
      * ======================
      *$ Invalid .MEM file
      * ======================
      DO badmemfl
      * ==================================
      * NOTE: If info in the .MEM file is
      * necessary for the entire application
      * this should be changed so user is
      * returned to DOS
      * =================================
      DO go_mastr
      
   CASE xerno = 56
      * =========================================
      *$ Out of disk space error.  Return to DOS
      * =========================================
      STORE .F. TO printit
      DO nospace WITH printit
      
      IF printit
         * ============================
         * Send error info to printer
         * ============================
         DO to_prn
      ENDIF  (printit)
      * ======================================
      *$ Quit to DOS - No attempt is
      *$ made to close databases since
      *$ the error condition may preclude it
      * ======================================
      SET CURSOR ON
      SET COLOR TO W/N
      CLEAR
      SET CLEAR OFF           && Suppresses "Normal Shutdown" message
      QUIT
      
   CASE xerno = 67 .OR. xerno = 1309
      * ===================================================
      *$ Expression evaluator fault.  Object file corrupted
      * ===================================================
      DO korrupt
      DO go_mastr
      
   CASE xerno = 109
      * ========================================
      *$ Record is locked by another user
      *  Inform user & provide option to retry
      * ========================================
      DO rec_busy WITH tryagain
      
      IF tryagain
         * =============================
         *$ Retry for use of the record
         * =============================
         DO go_again
         GO RECNO()
         RETRY
      ELSE
         * ============================================
         *$ Abort and return to the MASTER module
         *  Information is saved to PRO2EROR database
         *  to provide a log of how often LAN users can
         *  not get use of a record.  If this situation
         *  occurs frequently it may mean that a
         *  different methodology is required in the
         *  source code to prevent a high incidents of
         *  contentions or that REPROCESS needs to be
         *  set to a higher value
         * ============================================
         DO go_mastr
      ENDIF  (tryagain)
      
   CASE xerno = 111
      * ===============================================
      *$ Attempt was made to write to a read-only file
      * ===============================================
      DO readonly
      DO go_mastr
      
   CASE xerno = 115 .OR. xerno = 116 .OR. xerno = 117
      * =========================================
      *$ Invalid DIF file header
      *$ Invalid DIF vector/DBF field mismatch
      *$ Invalid DIF type indicator
      * =========================================
      DO bad_dif
      DO go_mastr
      
   CASE xerno = 119 .OR. xerno = 120 .OR. xerno = 121
      * ================================================
      *$ Invalid SYLK file header
      *$ Invalid SYLK file dimension bounds
      *$ Invalid SYLK file format
      * ================================================
      DO bad_sylk
      DO go_mastr
      
   CASE xerno = 255 .OR. xerno = 256
      * ===========================================
      *$ Not a valid RapidFile or Framework II file
      * ===========================================
      DO notright WITH xerno
      DO go_mastr
      
   CASE xerno = 297 .OR. xerno = 1662 .OR. xerno = 1678
      * ======================================
      *$ Invalid Lotus 1-2-3 version X file
      * ======================================
      DO badlotus WITH xerno
      DO go_mastr
      
   CASE xerno = 124
      * =============================
      *$ Invalid printer redirection
      * =============================
      DO invalprn
      DO go_mastr
      
   CASE xerno = 125
      * ===========================================
      * Printer not ready.
      * Provide user with option to retry
      * for use of printer or abort to MASTER
      * ===========================================
      DO notready WITH tryagain
      
      IF tryagain
         * =============================
         *$ Retry for use of printer
         * =============================
         DO go_again
         RETRY
      ELSE
         * ======================================
         *$ Abort and return to the MASTER module
         * ======================================
         DO go_mastr
      ENDIF  (tryagain)
      
   CASE xerno = 176 .OR. xerno = 177
      * =======================================
      *$ Error #176 - Cannot clear menu in use
      *$ Error #177 - Cannot clear popup in use
      *
      *  Attempt was made to CLEAR or RELEASE
      *  MENU or POPUP which has not been
      *  deactivated.  Simply DEACTIVATE and
      *  RETRY the command.
      * =======================================
      IF xerno = 176
         DEACTIVATE MENU
      ELSE
         DEACTIVATE POPUP
      ENDIF  (xerno = 176)
      
      DO go_again
      RETRY
      
   CASE xerno = 800
      * =======================
      *$ Internal SQL error
      * =======================
      DO sql_intl
      DO setenvmt
      DO save_it
      * =============
      *$ Quit to DOS
      * =============
      DO qquit
      
   CASE xerno = 821
      * ========================================
      *$ Temporary SQL file has been corrupted
      * ========================================
      DO sqltrash
      DO go_mastr
      
   CASE xerno = 830
      * =========================
      *$ SQL index not found
      * =========================
      DO nosqlidx
      DO go_mastr
      
   CASE xerno = 831
      * ==================================
      *$ SQL err building temporary index
      * ==================================
      STORE .F. TO printit
      DO sql_idx WITH printit
      
      IF printit
         * ============================
         * Send error info to printer
         * ============================
         DO to_prn
      ENDIF  (printit)
      * ======================================
      *$ Quit to DOS - No attempt is
      *$ made to close databases since
      *$ the error condition may preclude it
      * ======================================
      SET CURSOR ON
      SET COLOR TO W/N
      CLEAR
      SET CLEAR OFF           && Suppresses "Normal Shutdown" message
      QUIT
      
   CASE xerno = 839
      * =======================================
      *$ User pressed ESC during SQL operation
      * =======================================
      STORE .F. TO kancel
      DO sqlabort WITH kancel
      
      IF kancel
         * ============================
         *$ Return to Main Menu if user
         *$ really wants to abort
         * ============================
         DO go_mastr
      ELSE
         * ============================
         *$ Otherwise retry query
         * ============================
         DO go_again
         RETRY
      ENDIF  (kancel)
      
   CASE xerno = 1012
      * =========================================
      *$ OS free memory chain has been scrambled.
      *  The only solution is to return to DOS.
      * =========================================
      DO badchain
      DO setenvmt
      DO save_it
      * =============
      *$ Quit to DOS
      * =============
      DO qquit
      
   CASE xerno = 1101
      * ====================
      *$ Cannot open file
      * ====================
      DO badrights
      DO qquit
      
   CASE xerno = 1102 .OR. xerno = 1157 .OR. xerno = 1410
      * ==================================
      *$ Can not create file or update file
      * ==================================
      DO nocreat
      * ============================
      *$ Send error info to printer
      * ============================
      DO to_prn
      DO qquit
      
   CASE xerno = 1104
      * =====================
      *$ File read error
      * =====================
      DO read_err WITH tryagain
      
      IF tryagain
         * =============================
         *$ Retry for use of the file
         * =============================
         DO go_again
         RETRY
      ELSE
         * =======================================
         *$ Abort and return to the MASTER module
         *  Information is saved to PRO2EROR database
         * =======================================
         DO go_mastr
      ENDIF  (tryagain)
      
   CASE xerno = 1105
      * ===================
      *$ File write error
      * ===================
      DO rite_err WITH tryagain
      
      IF tryagain
         * =============================
         *$ Retry for use of the file
         * =============================
         DO go_again
         RETRY
      ELSE
         * =======================================
         *$ Abort and return to the MASTER module
         *  Information is saved to PRO2EROR database
         * =======================================
         DO go_mastr
      ENDIF  (tryagain)
      
   CASE xerno = 1112
      * =====================
      *$ File close error
      * =====================
      DO badclose WITH tryagain
      
      IF tryagain
         * =============================
         *$ Try to close the file again
         * =============================
         DO go_again
         RETRY
      ELSE
         * =======================================
         *$ Abort to DOS
         *  Information is saved to PRO2EROR database
         * =======================================
         DO setenvmt
         DO save_it
         DO qquit
      ENDIF  (tryagain)
      
   CASE xerno = 1115 .OR. xerno = 15
      * =========================
      *$ Database is trashed
      * =========================
      DO realbad
      DO go_mastr
      
   CASE xerno = 1201 .OR. xerno = 1308
      * =====================================
      *$ Too many names used (1201)
      *$ or stack overflow (1308)
      *  Since the NAMES table has been
      *  exhausted it will may not be
      *  possible to open the CALLWHOM or
      *  PRO2EROR databases to save the info
      * =====================================
      STORE .F. TO printit
      DO verbose WITH printit
      
      IF printit
         * ============================
         * Send error info to printer
         * ============================
         DO to_prn
      ENDIF  (printit)
      * ===============
      *$ Quit to DOS
      * ===============
      DO qquit
      
   CASE xerno = 1405
      * ========================
      *$ RUN/! command failed
      * ========================
      DO norun
      DO go_mastr
      
   CASE xerno = 1643 .OR. xerno = 1644
      * ========================================
      *$ Printer driver is corrupted or missing
      *  Abort & return to Master Module
      * ========================================
      DO pkorrupt
      DO go_mastr
      
   CASE xerno = 1661
      * =========================================
      *$ Invalid Excel version 2.0 file format
      * =========================================
      DO badexcel
      DO go_mastr
      
   CASE xerno = 1673 .OR. xerno = 1674
      * ========================================
      *$ Invalid Symphony version X file format
      * ========================================
      DO badsymph WITH xerno
      DO go_mastr
      
   CASE xerno = 1705 .OR. xerno = 823
      * ========================================
      *$ File access denied
      *  Abort & return to MASTER module
      *  Error 823 is generated when a SQL open
      *  of a specific file fails.
      * ========================================
      DO noaccess
      DO go_mastr
      
   CASE xerno = 1707
      * ================================================
      *$ Structural .CDX is missing & must be recreated
      * ================================================
      DO no_cdx
      DO setenvmt
      DO save_it
      * ==============
      *$ Quit to DOS
      * ==============
      DO qquit
      
   OTHERWISE
      DO progbug
      DO go_mastr
ENDCASE    xerno
* End procedure PRO2EROR



*!*********************************************************************
*!
*!      Procedure: GO_MASTR
*!
*!      Called by: PRO2EROR.PRG                      
*!
*!          Calls: SETENVMT           (procedure in PRO2EROR.PRG)
*!               : SAVE_IT            (procedure in PRO2EROR.PRG)
*!               : ERORSET            (procedure in PRO2EROR.PRG)
*!
*!*********************************************************************
PROCEDURE go_mastr
***********************************************************************
* Save info to PRO2EROR database, reset
* environmentals and return to master module
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/20/91
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
DO setenvmt
* ==============================
*$ Save info to PRO2EROR database
* ==============================
DO save_it
DO erorset
* ==================================
*$ Release all non-public memvars
* ==================================
RELEASE ALL
RELEASE lstext, lmtext
CLEAR TYPEAHEAD
SET CURSOR &curs_set
RETURN TO MASTER
* End procedure GO_MASTR



*!*********************************************************************
*!
*!      Procedure: SETENVMT
*!
*!      Called by: PRO2EROR.PRG                      
*!               : GO_MASTR           (procedure in PRO2EROR.PRG)
*!
*!*********************************************************************
PROCEDURE setenvmt
***********************************************************************
*& Change full range of environmentals
*  in anticipation of a RETURN TO MASTER
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 7/24/91
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PRIVATE disk_space
STORE DISKSPACE() TO disk_space
SET CONSOLE OFF
* =====================================
* Create a program tree 20 levels deep
* =====================================
FOR xx = 1 TO 20
   nextlevl = "PROGTREE" + ALLTRIM(TRANSFORM(xx, "@Z 99"))
   STORE SYS(16, xx) TO &nextlevl
   
   IF EMPTY(SYS(16,xx))
      EXIT
   ENDIF
ENDFOR

PUBLIC lstext, lmtext
STORE SYS(3) + ".TXT" TO lstext
LIST STATUS TO (lstext)
* ==================================================
*$ Create files which hold information from LIST STATUS
*$ and LIST MEMORY prior to closing files, etc.
* ==================================================
STORE SYS(3) + ".TXT" TO lmtext
LIST MEMORY TO (lmtext)
SET CONSOLE ON
* =================================================
* Re-initialize environment for defaults prior to
* commencing any of the following activities
* =================================================
ON KEY           && Null out hot keys
CLEAR GETS
CLEAR READ ALL
CLEAR FIELDS
CLEAR MACROS
CLEAR WINDOWS
DEACTIVATE MENUS
CLEAR MENUS
DEACTIVATE POPUPS
CLEAR POPUPS
CLEAR PROMPT
UNLOCK ALL
SET DEVICE TO SCREEN
CLOSE DATA
SET TALK OFF
SET ESCAPE OFF
SET CURSOR OFF
RETURN
* End procedure SETENVMT


*!*********************************************************************
*!
*!      Procedure: SAVE_IT
*!
*!      Called by: PRO2EROR.PRG                      
*!               : GO_MASTR           (procedure in PRO2EROR.PRG)
*!
*!          Calls: LOGVIEW            (procedure in PRO2EROR.PRG)
*!
*!           Uses: PRO2EROR.DBF       
*!
*!*********************************************************************
PROCEDURE save_it
***********************************************************************
*& Store error info to PRO2EROR database
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 7/29/91
*
*   Modified by Pat Adams 9/10/91
*       Bug fix - Corrected by adding SET CONSOLE ON
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
DEFINE WINDOW moment FROM 12,29 TO 14,51 "","","", ;
   "","","","","" COLOR W+*/R,N/W,W+*/R SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW moment
@ 0, 0 SAY REPLICATE("",21)
@ 0, 2 SAY "ONE MOMENT PLEASE"
* ==============================================
* NOTE: In a single user system running on a 386
* machine this window may flash by so rapidly that
* it can be omitted.
* ==============================================
IF NETWORK()
   * ==============================================
   * If running under FoxPro LAN the assumption is
   * that a LAN is in use.  Get LAN user log-in name.
   * ==============================================
   PRIVATE uname
   STORE GETENV("USER") TO uname
ENDIF  (NETWORK())
* ==========================
*$ Store info to error file
* ==========================
SET CONSOLE OFF
USE pro2eror
APPEND BLANK
replace er_no WITH xerno, er_msg WITH xmsg, ;
   kode WITH xkode, mmodul WITH xmodul, ddate ;
   WITH DATE(), ttime WITH TIME(), line_no WITH xline

IF TYPE("UNAME") <> "U" .AND. ! EMPTY(uname)
   replace lan_user WITH uname
ELSE
   replace lan_user WITH "NOT AVAILABL"
ENDIF  (TYPE("UNAME") <> "U" .AND. ! EMPTY(uname))
* ==================================================
*$ Put info from the files created with LIST MEMORY
*$ and LIST STATUS into the memo field and then
*$ erase the text files
* ==================================================
APPEND MEMO notes FROM (lstext)
ERASE (lstext)
APPEND MEMO notes FROM (lmtext)
SET CONSOLE ON

IF TYPE("TESTING") <> "U"
   * =================================================
   *$ If memvar TESTING has been initialized at a higher
   *$ level provide developer/programmer with option to
   *$ view error log file now
   * =================================================
   IF testing
      DO logview
   ENDIF  (testing)
ENDIF  (TYPE("TESTING") <> "U")

CLOSE DATA
ERASE (lmtext)
RELEASE WINDOW moment
RELEASE lstext, lmtext
RETURN
* End procedure save_it



*!*********************************************************************
*!
*!      Procedure: NO_FILE
*!
*!      Called by: PRO2EROR.PRG                      
*!
*!          Calls: RAZBERRY           (procedure in PRO2EROR.PRG)
*!
*!           Uses: CALLWHOM.DBF       
*!
*!*********************************************************************
PROCEDURE no_file
***********************************************************************
*& Error #1 - File does not exist or can not be found
*& Error #802 - SQL database file can not be found
*& Error #1162 - PROCEDURE can not be found
*
*     The passed parameter is the name of the missing item
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/4/91
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PARAMETERS not_there
not_there = UPPER(ALLTRIM(not_there))
DEFINE WINDOW bugbox FROM 5,19 TO 17,61 DOUBLE ;
   COLOR W+/N,N/W,W+*/R SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox
@ 0,11 SAY "   BAD NEWS   " COLOR +*W/N
* ============================================
* Open CALLWHOM.DBF to get info on appropriate
* person who should be in formed of problem.
* If application is single-user substitute info
* in the APP ADMINISTRATOR record rather than
* using the LAN ADMINISTRATOR data
* ===========================================
SELECT 0
USE callwhom
LOCATE FOR ALLTRIM(callwhom->title) == "LAN ADMINISTRATOR"
STORE ALLTRIM(callwhom->call_who) TO m_call
STORE ALLTRIM(callwhom->other) TO m_title
STORE ALLTRIM(callwhom->phone) TO m_phone
CLOSE DATA
@ 2, 5 SAY "The following file is missing:"
@ 3, 0 SAY PADC(not_there,40)
@ 4,13 SAY "Please contact:"
@ 5, 0 SAY PADC(m_call,40)
@ 6, 0 SAY PADC(m_title,40)
@ 7, 0 SAY PADC(m_phone,40)
@ 8, 9 SAY "to report this problem."
@ 10, 1 SAY "Press any key to return to main menu..." COLOR W/N
DO razberry                     && Sound Bronx cheer
= INKEY(0, "MH")                && Wait for keypress or mouse click
CLEAR TYPEAHEAD
RELEASE WINDOW bugbox
RETURN
* End procedure NO_FILE


*!*********************************************************************
*!
*!      Procedure: RAZBERRY
*!
*!      Called by: NO_FILE            (procedure in PRO2EROR.PRG)
*!               : TOO_HIGH           (procedure in PRO2EROR.PRG)
*!               : LOWFILES           (procedure in PRO2EROR.PRG)
*!               : INDEX_ER           (procedure in PRO2EROR.PRG)
*!               : NOMEMO             (procedure in PRO2EROR.PRG)
*!               : LOWMEMRY           (procedure in PRO2EROR.PRG)
*!               : BAD_RPT            (procedure in PRO2EROR.PRG)
*!               : BADMEMFL           (procedure in PRO2EROR.PRG)
*!               : NOSPACE            (procedure in PRO2EROR.PRG)
*!               : KORRUPT            (procedure in PRO2EROR.PRG)
*!               : READONLY           (procedure in PRO2EROR.PRG)
*!               : BAD_DIF            (procedure in PRO2EROR.PRG)
*!               : BAD_SYLK           (procedure in PRO2EROR.PRG)
*!               : NOTRIGHT           (procedure in PRO2EROR.PRG)
*!               : BADLOTUS           (procedure in PRO2EROR.PRG)
*!               : INVALPRN           (procedure in PRO2EROR.PRG)
*!               : NOTREADY           (procedure in PRO2EROR.PRG)
*!               : SQL_INTL           (procedure in PRO2EROR.PRG)
*!               : SQLTRASH           (procedure in PRO2EROR.PRG)
*!               : NOSQLIDX           (procedure in PRO2EROR.PRG)
*!               : SQL_IDX            (procedure in PRO2EROR.PRG)
*!               : SQLABORT           (procedure in PRO2EROR.PRG)
*!               : BADCHAIN           (procedure in PRO2EROR.PRG)
*!               : NOCREAT            (procedure in PRO2EROR.PRG)
*!               : READ_ERR           (procedure in PRO2EROR.PRG)
*!               : RITE_ERR           (procedure in PRO2EROR.PRG)
*!               : BADCLOSE           (procedure in PRO2EROR.PRG)
*!               : VERBOSE            (procedure in PRO2EROR.PRG)
*!               : NORUN              (procedure in PRO2EROR.PRG)
*!               : PKORRUPT           (procedure in PRO2EROR.PRG)
*!               : BADEXCEL           (procedure in PRO2EROR.PRG)
*!               : BADSYMPH           (procedure in PRO2EROR.PRG)
*!               : NOACCESS           (procedure in PRO2EROR.PRG)
*!               : NO_CDX             (procedure in PRO2EROR.PRG)
*!               : PROGBUG            (procedure in PRO2EROR.PRG)
*!
*!*********************************************************************
PROCEDURE razberry
***********************************************************************
*& Sound bell as a "raspberry" or Bronx Cheer
*
*     Author: Pat Adams, DB Unlimited
*   Date: 7/24/89
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
SET BELL TO 20,15
?? CHR(7)
SET BELL TO
* End Procedure Razberry


*!*********************************************************************
*!
*!      Procedure: LOGVIEW
*!
*!      Called by: SAVE_IT            (procedure in PRO2EROR.PRG)
*!
*!          Calls: YES_NO             (procedure in PRO2EROR.PRG)
*!               : MEMOVIEW           (procedure in PRO2EROR.PRG)
*!               : QQUIT              (procedure in PRO2EROR.PRG)
*!               : KANCEL             (procedure in PRO2EROR.PRG)
*!
*!*********************************************************************
PROCEDURE logview
***********************************************************************
*& View error log if user so requests
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/2/91
*
*   Modified 8/16/91 by Pat Adams
*     F2 KEY LABEL setting stored & then reinitialized
*     to original setting
*
*   Modified by Pat Adams 8/19/91
*     Existing ON KEY LABELs changed to SHIFT-Fx
*     to avoid conflicts with more commonly used
*     function keys.
*
*   Modified by Pat Adams 8/22/91
*      Use of ESC key to return to command window
*      if in interactive version of FoxPro 2.0 added
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PRIVATE do_it, scheme10, curs_set, sf2key, sf9key, cqkey, ;
   esckey, escstat, ttitle, clockset
STORE .F. TO do_it
RELEASE WINDOW moment
DEFINE WINDOW question FROM 12,12 TO 14,68 DOUBLE ;
   COLOR N/W,N/W,R+/W SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW question
@ 0, 1 SAY "Would you like to view the error " + ;
   "log file now?  (Y/N)"
DO yes_no WITH do_it
RELEASE WINDOW question

IF do_it
   STORE SCHEME(10) TO scheme10
   SET COLOR OF SCHEME 10 TO +W/N, N/W, +W/+R, R/W, R/W, N/W, N/W
   SET CURSOR ON
   * ==========================================
   *$ Store any ON KEY LABEL SHIFT-F2 setting
   *  and initialize for exit of BROWSE/MEMO
   * ==========================================
   STORE ON("KEY", "SHIFT-F2") TO sf2key
   ON KEY LABEL shift-F2 KEYBOARD CHR(23)         && Exit from BROWSE
   * ==========================================
   *$ Store any ON KEY LABEL SHIFT-F9 setting
   *  and initialize for exit of BROWSE/MEMO
   * ==========================================
   STORE ON("KEY", "SHIFT-F9") TO sf9key
   ON KEY LABEL shift-F9 DO memoview     && Open window & view memo field
   * ===========================================
   *$ Store any ON KEY LABEL CTRL-Q TO cqkey
   *  and initialize for return to DOS
   * ===========================================
   STORE ON("KEY", "CTRL-Q") TO cqkey
   ON KEY LABEL ctrl-q DO qquit
   ttitle = IIF("EXE" $ VERS(1), "", " ESC for " + ;
      "COMMAND WIN, ") + "STATS=SHIFT-F9, " + ;
      "EXIT=SHIFT-F2, CTRL-Q=EXIT TO DOS"
   DEFINE WINDOW browin FROM 0,0 TO 24,79 DOUBLE ;
      COLOR W+/N,N/W, W+/R, R/W, R/W, N/W, N/W ;
      TITLE ' &ttitle '
   DEFINE WINDOW memwin FROM 7,0 TO 21,79 DOUBLE ;
      COLOR W+/N,N/W,R+/N,R+/N,R+/N, N/W,N/W ;
      TITLE ' PRESS SHIFT-F2 TO EXIT '
   STORE SET("CLOCK") TO clockset
   SET CLOCK OFF
   
   IF ! "EXE" $ VERS(1)
      * ===============================================
      *$ If working in interactive development version
      *$ provide opportunity to press ESC to return to
      *$ command window
      * ===============================================
      STORE ON("KEY", "ESC") TO esckey
      STORE SET("ESCAPE") TO escstat
      SET ESCAPE ON
      ON KEY LABEL esc DO kancel
   ENDIF  (! "EXE" $ VERS(1))
   
   
   IF NETWORK()
      SET REFRESH TO 200
   ENDIF  (NETWORK())
   
   BROWSE NOMODIFY WINDOW browin
   * =========================================
   *$ Restore previous ON KEY LABEL settings
   * =========================================
   ON KEY LABEL F2 &sf2key
   ON KEY LABEL F9 &sf9key
   ON KEY LABEL ctrl-q &cqkey
   SET CLOCK &clockset
   CLEAR TYPEAHEAD
   
   IF ! "EXE" $ VERS(1)
      ON KEY LABEL esc &esckey
      SET ESCAPE &escstat
   ENDIF  (! "EXE" $ VERS(1))
   
   IF NETWORK()
      SET REFRESH TO 0
   ENDIF  (NETWORK())
   
   CLEAR WINDOWS
   SET STATUS OFF
   SET COLOR OF SCHEME 10 TO &scheme10
   SET CURSOR &curs_set
ENDIF  (do_it)

RETURN
* End procedure LOGVIEW


*!*********************************************************************
*!
*!      Procedure: MEMOVIEW
*!
*!      Called by: LOGVIEW            (procedure in PRO2EROR.PRG)
*!               : MEMOVIEW           (procedure in PRO2EROR.PRG)
*!
*!          Calls: MEMOVIEW           (procedure in PRO2EROR.PRG)
*!
*!*********************************************************************
PROCEDURE memoview
***********************************************************************
*& Open large window to view memo field info in error log
*
*  Routine assumes the F2 key has been enabled at a higher
*  level to exit the window and that window MEMWIN has been
*  defined at a higher level.
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/2/91
*
*   Modified 8/19/91 by Pat Adams
*       Changes made to reflect modified ON KEY LABEL usage
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
ON KEY LABEL shift-F9
SET WINDOW OF MEMO TO memwin
MODIFY MEMO notes NOEDIT
CLOSE MEMO notes
DEACTIVATE WINDOW memwin
CLEAR TYPEAHEAD
ON KEY LABEL shift-F9 DO memoview
RETURN
* End procedure MEMOVIEW



*!*********************************************************************
*!
*!      Procedure: YES_NO
*!
*!      Called by: FILE_BUSY          (procedure in PRO2EROR.PRG)
*!               : NOSPACE            (procedure in PRO2EROR.PRG)
*!               : REC_BUSY           (procedure in PRO2EROR.PRG)
*!               : NOTREADY           (procedure in PRO2EROR.PRG)
*!               : SQL_IDX            (procedure in PRO2EROR.PRG)
*!               : SQLABORT           (procedure in PRO2EROR.PRG)
*!               : READ_ERR           (procedure in PRO2EROR.PRG)
*!               : RITE_ERR           (procedure in PRO2EROR.PRG)
*!               : BADCLOSE           (procedure in PRO2EROR.PRG)
*!               : VERBOSE            (procedure in PRO2EROR.PRG)
*!               : LOGVIEW            (procedure in PRO2EROR.PRG)
*!
*!*********************************************************************
PROCEDURE yes_no
***********************************************************************
*& Get user response of Y or N and return
*
*   Passed parameter is a logical .T. or .F. and
*   is returned as a logical value.  This methodology
*   is utilized rather than a GET on a memvar or a lite
*   bar menu in order to avoid potential conflicts with
*   color settings and schemes.
*
*   Mouse response is not permitted.  User MUST
*   respond with a Y or N.
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 5/2/89
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PARAMETERS answer
PRIVATE kkey, curs_set
STORE 0 TO kkey
STORE SET("CURSOR") TO curs_set
SET CURSOR OFF

DO WHILE kkey = 0
   kkey = INKEY()
   
   IF kkey > 0
      * =============================
      * Function keys 2 thru 9 return
      * negative values.  This sets up
      * error trapping for that condition.
      * =============================
      IF CHR(kkey) $ "YyNn"
         IF CHR(kkey) $ "Yy"
            STORE .T. TO answer
         ELSE
            STORE .F. TO answer
         ENDIF  (CHR(kkey) $ "Yy")
      ELSE
         STORE 0 TO kkey
      ENDIF  (CHR(kkey) $ "YyNn")
   ELSE
      STORE 0 TO kkey
   ENDIF  (kkey > 0)
ENDDO  (kkey = 0)

* ================================
* Restore cursor to original status
* ================================
SET CURSOR &curs_set)
CLEAR TYPEAHEAD
RETURN answer
* End procedure YES_NO



*!*********************************************************************
*!
*!      Procedure: FILE_BUSY
*!
*!      Called by: PRO2EROR.PRG                      
*!
*!          Calls: NICECHIM           (procedure in PRO2EROR.PRG)
*!               : YES_NO             (procedure in PRO2EROR.PRG)
*!
*!*********************************************************************
PROCEDURE file_busy
***********************************************************************
*$ Display window informing user required file is busy
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 7/31/91
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PARAMETERS re_try
DEFINE WINDOW busy FROM 8, 8 TO 15,72 DOUBLE ;
   COLOR N/W,N/W,R+*/W SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW busy
@ 0,22 SAY "   S O R R Y   " COLOR *+R/W
@ 2, 1 SAY "Someone else was using the file required " + ;
   "at this point."
@ 3, 1 SAY "Attempting a 'retry' may find that " + ;
   "the file is now available."
@ 5, 6 SAY "Would you like to retry for use " + ;
   "of the file?  (Y/N)"
DO nicechim
DO yes_no WITH re_try
RELEASE WINDOW busy
RETURN re_try
* End procedure FILE_BUSY



*!*********************************************************************
*!
*!      Procedure: GO_AGAIN
*!
*!      Called by: PRO2EROR.PRG                      
*!
*!          Calls: ERORSET            (procedure in PRO2EROR.PRG)
*!
*!    Other Files: &PRNT_DEVIC
*!
*!*********************************************************************
PROCEDURE go_again
***********************************************************************
*& Reset environment for RETRY
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/3/91
*
*   Modified 8/19/91 by Pat Adams
*       Selection of CURR_DBF (if ! EMPTY()) added before
*       execution of the RETRY upon return
*       to calling module.  Closure of PRO2EROR
*       database added in the event it was used
*       since some modules which do a RETRY also
*       save data into the error log.
*
*   Modified 9/22/91
*       GO RECNO() added following SELECT (curr_dbf)
*       to make sure any changes in a record can be
*       viewed by user.
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
IF USED("CALLWHOM")
   SELECT callwhom
   USE
ENDIF  (USED("CALLWHOM"))

IF USED("PRO2EROR")
   SELECT pro2eror
   USE
ENDIF  (USED("PRO2EROR"))

IF ! EMPTY(curr_dbf)
   SELECT (curr_dbf)
   * =====================================
   *$ Move record pointer so user will see
   *$ any changes made by others on the LAN
   * =====================================
   GO RECNO()
ENDIF  ! empty(curr_dbf)

IF ! EMPTY(top_win)
   * ===================================
   * Note that EVALUATE() does not work
   * with ACTIVATE WINDOW so &macro is used
   * ===================================
   ACTIVATE WINDOW &top_win
ENDIF  (! EMPTY(top_win))

SET CONSOLE &xkonsol
SET DEVICE TO &xdevice
SET PRINTER TO &prnt_devic
SET PRINT &xprint
RELEASE lstext, lmtext
DO erorset
CLEAR TYPEAHEAD
SET CURSOR &curs_set
RETURN
* End procedure GO_AGAIN



*!*********************************************************************
*!
*!      Procedure: ERORSET
*!
*!      Called by: PRO2EROR.PRG                      
*!               : GO_MASTR           (procedure in PRO2EROR.PRG)
*!               : GO_AGAIN           (procedure in PRO2EROR.PRG)
*!
*!          Calls: PRO2EROR.PRG
*!
*!*********************************************************************
PROCEDURE erorset
***********************************************************************
*& Reinitialize error set statement for PRO2EROR
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 7/12/91
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
ON ERROR DO pro2eror WITH ERROR(), MESSAGE(), ;
   MESSAGE(1), SYS(16), LINENO(), SYS(102), ;
   SYS(100), SYS(101), LASTKEY(), ALIAS(), ;
   SYS(18), SYS(5), SYS(12), SYS(6), SYS(2003), ;
   WONTOP(), SYS(2011), SYS(2018)
RELEASE lstext, lmtext
RETURN
* End procedure ERORSET


*!*********************************************************************
*!
*!      Procedure: NICECHIM
*!
*!      Called by: FILE_BUSY          (procedure in PRO2EROR.PRG)
*!               : REC_BUSY           (procedure in PRO2EROR.PRG)
*!
*!*********************************************************************
PROCEDURE nicechim
***********************************************************************
* & Sound pleasant 3 part chime
*
*     Author: Pat Adams, DB Unlimited
*   Date: 7/24/89
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
SET BELL TO 2000,5
?? CHR(7)
SET BELL TO 2500,5
?? CHR(7)
SET BELL TO 3000,5
?? CHR(7)
SET BELL TO            && Return bell to normal setting
RETURN
* End Procedure NICECHIM



*!*********************************************************************
*!
*!      Procedure: QQUIT
*!
*!      Called by: PRO2EROR.PRG                      
*!               : LOGVIEW            (procedure in PRO2EROR.PRG)
*!
*!*********************************************************************
PROCEDURE qquit
***********************************************************************
*& Return user to DOS
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 7/7/91
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
CLOSE DATA
SET CURSOR ON
SET COLOR TO W/N
CLEAR
SET CLEAR OFF           && Suppresses "Normal Shutdown" message
QUIT
* End procedure QQUIT



*!*********************************************************************
*!
*!      Procedure: NOACCESS
*!
*!      Called by: PRO2EROR.PRG                      
*!
*!          Calls: RAZBERRY           (procedure in PRO2EROR.PRG)
*!
*!           Uses: CALLWHOM.DBF       
*!
*!*********************************************************************
PROCEDURE noaccess
***********************************************************************
*$ File access denied
*
*  Attempt has been made to write to a file that is
*  read only.  This may arise for several reasons:
*
*      1.  File is protected by the DOS
*          ATTRIB command as read only
*
*      2.  User rights have not been
*          configured properly for this
*          users LAN access.  Note that
*          a .DBF file may be opened  (for purposes
*          of reading or copying the file) with
*          read only rights on a LAN but
*          index files require both read and
*          write rights.
*
*      3.  Most LANs, such as Novell, utilize bytes not utilized
*          by DOS to store information about whether the LAN
*          attribute(s) for the file are read only, etc.  Something,
*          including Novell add-on utilities and menus, may
*          have changed the LAN attributes for this file to
*          read only.
*
*      4.  File is in exclusive use by another.  Error #3 should
*          be returned in this circumstance but certain versions
*          of DOS based LANs such as InvisibleNet erroneously
*          return error 1705.  If you are using a DOS based LAN
*          and get frequent recurrence of error # 1705 and you
*          are sure users have the correct LAN rights this may
*          be the culprit.
*
*     5.   Error # 823 is generated when a SQL open of a
*          specified file fails.
*
*   Author: Pat Adams, DB Unlimited
*   Date: 8/5/91
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
ACTIVATE SCREEN
DEFINE WINDOW bugbox FROM 3,18 TO 19,61 DOUBLE ;
   COLOR N/W,N/W,R+*/W SHADOW
ACTIVATE WINDOW bugbox
@ 0,10 SAY "   W H O O P S   " COLOR *+R/W
@ 2, 1 SAY "One of two problems has occurred. Either"
@ 3, 1 SAY "you do not have the appropriate user"
@ 4, 1 SAY "rights on the LAN or the file you need"
@ 5, 1 SAY "has inadvertently been flagged as read"
@ 6, 1 SAY "only."
SELECT 0
USE callwhom
* ========================================
*$ Get info on appropriate person to call
* ========================================
LOCATE FOR ALLTRIM(callwhom->title) == "LAN ADMINISTRATOR"
STORE ALLTRIM(callwhom->call_who) TO m_call
STORE ALLTRIM(callwhom->other) TO m_title
STORE ALLTRIM(callwhom->phone) TO m_phone
CLOSE DATA
@ 8,14 SAY "Please call "
@ 9,0 SAY PADC(m->m_call, 42)
@ 10,0 SAY PADC(m->m_title, 42)
@ 11,0 SAY PADC(m->m_phone, 42)
@ 12,10 SAY "to report the problem."
DO razberry
@14,1 SAY "Press any key to return to Main Menu..." COLOR +N/W
= INKEY(0, "MH")
CLEAR TYPEAHEAD
RELEASE WINDOW bugbox
RETURN
*End procedure NOACCESS



*!*********************************************************************
*!
*!      Procedure: REC_BUSY
*!
*!      Called by: PRO2EROR.PRG                      
*!
*!          Calls: NICECHIM           (procedure in PRO2EROR.PRG)
*!               : YES_NO             (procedure in PRO2EROR.PRG)
*!
*!*********************************************************************
PROCEDURE rec_busy
***********************************************************************
*& Display window informing user record is locked by another
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/1//91
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PARAMETERS re_try
DEFINE WINDOW busy FROM 7,18 TO 14,61 DOUBLE ;
   COLOR N/W,N/W,R+*/W SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW busy
@ 0,12 SAY "   S O R R Y   " COLOR *+R/W
@ 2, 1 SAY "Someone else locked the record you need."
@ 3, 1 SAY "If you try again it may now be available."
@ 5, 6 SAY "WOULD YOU LIKE TO RETRY?  (Y/N)"
DO nicechim
DO yes_no WITH re_try
RELEASE WINDOW busy
RETURN re_try
* End procedure REC_BUSY



*!*********************************************************************
*!
*!      Procedure: TOO_HIGH
*!
*!      Called by: PRO2EROR.PRG                      
*!
*!          Calls: RAZBERRY           (procedure in PRO2EROR.PRG)
*!
*!           Uses: CALLWHOM.DBF       
*!
*!*********************************************************************
PROCEDURE too_high
***********************************************************************
*& Error #5, "Record is out of range"
*
*   This error usually arises from the following conditions:
*
*     1.  Attempts to access a record number greater than
*         the actual number of records in the database.
*
*     2.  FoxPro has been installed with the demonstration
*         key instead of the activation key and the database
*         contains more records than permitted in the demo.
*
*     3.  An index is out of date and no longer matches
*         the database in use.
*
*   Inform user and have them call Application Administrator.
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/6//91
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
DEFINE WINDOW bugbox FROM 2,16 TO 21,64 DOUBLE ;
   COLOR N/W,N/W,R+*/W SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox
@ 0,12 SAY "    W H O O P S   " COLOR *+R/W
@ 2, 2 SAY "One of the following problems has occurred:"
@ 4, 2 SAY "1.  The demo version of this product is in"
@ 5, 6 SAY "use and an attempt has been made to use"
@ 6, 6 SAY "a database which contains more records"
@ 7, 6 SAY "than permitted by the demo."
@ 9, 2 SAY "2.  One of the indexes is out of date."
@11,18 SAY "Please call"
SELECT 0
USE callwhom
* ========================================
*$ Get info on appropriate person to call
* ========================================
LOCATE FOR ALLTRIM(callwhom->title) == "APP ADMINISTRATOR"
STORE ALLTRIM(callwhom->call_who) TO m_call
STORE ALLTRIM(callwhom->other) TO m_title
STORE ALLTRIM(callwhom->phone) TO m_phone
@12, 0 SAY PADC(m->m_call, 46)
@13, 0 SAY PADC(m->m_title, 46)
@14, 0 SAY PADC(m->m_phone, 46)
@15,12 SAY "to report this problem."
DO razberry
@17, 1 SAY "Press any key to return to Main Menu..."
= INKEY(0, "MH")
CLOSE DATA
RELEASE WINDOW bugbox
CLEAR TYPEAHEAD
RETURN
* End procedure TOO_HIGH



*!*********************************************************************
*!
*!      Procedure: INDEX_ER
*!
*!      Called by: PRO2EROR.PRG                      
*!
*!          Calls: RAZBERRY           (procedure in PRO2EROR.PRG)
*!
*!           Uses: CALLWHOM.DBF       
*!
*!*********************************************************************
PROCEDURE index_er
***********************************************************************
*& Index error messages
*
*   Error #19 =   "Index file does not match database"  The
*                 most likely cause is that index uses fields not
*                 in the database or relies upon memvars which are
*                 not initialized.
*
*   Error #20 =   "Record is not in index"  Most likely cause is
*                 that the database structure was changed without
*                 the index being active.
*
*   Error #114 =  "Index does not match database file"  The most
*                 likely cause is corruption within the index file
*                 or in the index file header.  Do not REINDEX but,
*                 rather, recreate index with INDEX ON...TO
*
*   Since application is not usable until the index problems
*   have been corrected the user will be returned to DOS at the
*   calling level.
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/7//91
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
DEFINE WINDOW bugbox FROM 5,17 TO 20,62 DOUBLE ;
   COLOR N/W,N/W,R+*/W SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox
@ 0,13 SAY "   BAD NEWS   " COLOR *+R/W
@ 2, 1 SAY "There is a problem with the index files"
@ 3, 1 SAY "which means they will need to be recreated."
@ 4, 1 SAY "You will not be able to use the system"
@ 5, 1 SAY "until this has been completed."
@ 7,15 SAY "Please contact"
SELECT 0
USE callwhom
* ========================================
*$ Get info on appropriate person to call
* ========================================
LOCATE FOR ALLTRIM(callwhom->title) == "APP ADMINISTRATOR"
STORE ALLTRIM(callwhom->call_who) TO m_call
STORE ALLTRIM(callwhom->other) TO m_title
STORE ALLTRIM(callwhom->phone) TO m_phone
@ 8, 0 SAY PADC(m->m_call, 44)
@ 9, 0 SAY PADC(m->m_title, 44)
@10, 0 SAY PADC(m->m_phone, 44)
@11,11 SAY "to report this problem."
@13, 1 SAY "Press any key to return to DOS..." COLOR +N/W
DO razberry
= INKEY(0, "MH")
RELEASE WINDOW bugbox
CLEAR TYPEAHEAD
RETURN
* End procedure index_er



*!*********************************************************************
*!
*!      Procedure: NO_CDX
*!
*!      Called by: PRO2EROR.PRG                      
*!
*!          Calls: RAZBERRY           (procedure in PRO2EROR.PRG)
*!
*!           Uses: CALLWHOM.DBF       
*!
*!*********************************************************************
PROCEDURE no_cdx
***********************************************************************
*& Structural .CDX file not found - Error #1707
*
*   Since application is not usable until the .CDX
*   is recreated the user will be returned to DOS at the
*   calling level.
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/7//91
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
DEFINE WINDOW bugbox FROM 5,17 TO 20,62 DOUBLE ;
   COLOR N/W,N/W,R+*/W SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox
@ 0,13 SAY "   BAD NEWS   " COLOR *+R/W
@ 2, 1 SAY "The structural index associated with the"
@ 3, 1 SAY "file you need seems to be missing.  You"
@ 4, 1 SAY "will not be able to use this system until"
@ 5, 1 SAY "the problem has been corrected."
@ 7,15 SAY "Please contact"
SELECT 0
USE callwhom
* ========================================
*$ Get info on appropriate person to call
* ========================================
LOCATE FOR ALLTRIM(callwhom->title) == "APP ADMINISTRATOR"
STORE ALLTRIM(callwhom->call_who) TO m_call
STORE ALLTRIM(callwhom->other) TO m_title
STORE ALLTRIM(callwhom->phone) TO m_phone
@ 8, 0 SAY PADC(m->m_call, 44)
@ 9, 0 SAY PADC(m->m_title, 44)
@10, 0 SAY PADC(m->m_phone, 44)
@11,11 SAY "to report this problem."
@13, 1 SAY "Press any key to return to DOS..." COLOR +N/W
DO razberry
= INKEY(0, "MH")
RELEASE WINDOW bugbox
CLEAR TYPEAHEAD
RETURN
* End procedure NO_CDX



*!*********************************************************************
*!
*!      Procedure: READONLY
*!
*!      Called by: PRO2EROR.PRG                      
*!
*!          Calls: RAZBERRY           (procedure in PRO2EROR.PRG)
*!
*!           Uses: CALLWHOM.DBF       
*!
*!*********************************************************************
PROCEDURE readonly
***********************************************************************
*& Attempt was made to write to a read-only file - Error #111
*
*   The most likely cause of this is attempting to
*   write to a file created as read-only or accessed
*   as read-only under program control.  User is in-
*   structed to call the developer because it is probably
*   a programming error.
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/7//91
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
DEFINE WINDOW bugbox FROM 4,18 TO 18,62 DOUBLE ;
   COLOR N/W,N/W,R+*/W SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox
@ 0,11 SAY "   W H O O P S  " COLOR *+R/W
@ 2, 1 SAY "There's a slight problem.  An attempt was"
@ 3, 1 SAY "made to write to a read-only file.  Your"
@ 4, 1 SAY "input can not be saved."
@ 6,14 SAY "Please contact"
SELECT 0
USE callwhom
* ========================================
*$ Get info on appropriate person to call
* ========================================
LOCATE FOR ALLTRIM(callwhom->title) == "DEVELOPER"
STORE ALLTRIM(callwhom->call_who) TO m_call
STORE ALLTRIM(callwhom->other) TO m_title
STORE ALLTRIM(callwhom->phone) TO m_phone
@ 7, 0 SAY PADC(m->m_call, 42)
@ 8, 0 SAY PADC(m->m_title, 42)
@ 9, 0 SAY PADC(m->m_phone, 42)
@10, 4 SAY "immediately to report this problem."
@12, 1 SAY "Press any key to return to Main Menu..." COLOR +N/W
DO razberry
= INKEY(0, "MH")
RELEASE WINDOW bugbox
CLEAR TYPEAHEAD
RETURN
* End procedure READONLY



*!*********************************************************************
*!
*!      Procedure: PROGBUG
*!
*!      Called by: PRO2EROR.PRG                      
*!
*!          Calls: RAZBERRY           (procedure in PRO2EROR.PRG)
*!
*!           Uses: CALLWHOM.DBF       
*!
*!*********************************************************************
PROCEDURE progbug
***********************************************************************
*& Inform user a programming bug has occurred
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/7//91
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
DEFINE WINDOW bugbox FROM 5,23 TO 19,56 DOUBLE ;
   COLOR N/W,N/W,R+*/W SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox
@ 0, 7 SAY "   BAD NEWS   " COLOR *+R/W
@ 2, 1 SAY "An error which is most likely"
@ 3, 1 SAY "a programming bug has occurred."
@ 5,11 SAY "Please call"
SELECT 0
USE callwhom
* ========================================
*$ Get info on appropriate person to call
* ========================================
LOCATE FOR ALLTRIM(callwhom->title) == "DEVELOPER"
STORE ALLTRIM(callwhom->call_who) TO m_call
STORE ALLTRIM(callwhom->other) TO m_title
STORE ALLTRIM(callwhom->phone) TO m_phone
@ 6, 0 SAY PADC(m->m_call, 32)
@ 7, 0 SAY PADC(m_title, 32)
@ 8, 0 SAY PADC(m_phone, 32)
@ 9, 3 SAY "immediately to report this."
@11, 1 SAY "Press any key" COLOR +N/W
@12, 1 SAY "to return to Main Menu..." COLOR +N/W
DO razberry
= INKEY(0, "MH")
RELEASE WINDOW bugbox
CLEAR TYPEAHEAD
RETURN
* End procedure PROGBUG



*!*********************************************************************
*!
*!      Procedure: NOCREAT
*!
*!      Called by: PRO2EROR.PRG                      
*!
*!          Calls: RAZBERRY           (procedure in PRO2EROR.PRG)
*!
*!           Uses: CALLWHOM.DBF       
*!
*!*********************************************************************
PROCEDURE nocreat
***********************************************************************
*& Can not create file
*
*   Error #1102 = "Cannot create file" <file>
*                 Memvar XMISSING provides file name
*
*   Error #1157 = "Cannot update file"
*
*&  Error #1410 - Unable to create temporary work file(s)
*                 (i.e., files required for SORT, INDEX,
*                 REINDEX or PACK
*
*   The situation is usually caused by one of the following:
*
*   1.  Insufficient disk space or, on a LAN, insufficient
*       directory space
*
*   2.  Attempted use of an invalid file name, including use
*       of a file name which already exists
*
*   3.  User does not have the correct LAN authorization to
*       create a file
*
*   4.  A hardware error has caused an inability to write to
*       the hard disk.
*
*     Because of the circumstances which may have created the
*   error condition error information output will be sent to
*   the printer and the user returned to DOS upon return to
*   the calling module.
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/8//91
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
DEFINE WINDOW bugbox FROM  3,4 TO 20,75 DOUBLE ;
   COLOR N/W,N/W,R+*/W SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox
@ 0,26 SAY "   BAD NEWS   " COLOR *+R/W
@ 2, 3 SAY "It's not possible to create a file which " + ;
   "is needed at this point."
@ 3, 3 SAY "This may be due to several problems, " + ;
   "one of which is insufficient"
@ 4, 3 SAY "disk space.  Because disk space may not " + ;
   "be available error infor-"
@ 5, 3 SAY "mation will be sent to the printer."
SELECT 0
USE callwhom
* ========================================
*$ Get info on appropriate person to call
* ========================================
LOCATE FOR ALLTRIM(callwhom->title) == "LAN ADMINISTRATOR"
STORE ALLTRIM(callwhom->call_who) TO m_call
STORE ALLTRIM(callwhom->other) TO m_title
STORE ALLTRIM(callwhom->phone) TO m_phone
@ 7,28 SAY "Please contact"
@ 8, 0 SAY PADC(m->m_call, 70)
@ 9, 0 SAY PADC(m->m_title, 70)
@10, 0 SAY PADC(m->m_phone, 70)
@11, 6 SAY "to report this problem and provide " + ;
   "a copy of the printout."
@13, 1 SAY "Make sure your printer is turned on " + ;
   "and on-line and then press any"
@14, 1 SAY "key to begin printing the error " + ;
   "information.  You will be returned"
@15, 1 SAY "to DOS once the printing has been completed."
DO razberry
= INKEY(0, "MH")
CLOSE DATA
RELEASE WINDOW bugbox
CLEAR TYPEAHEAD
RETURN
* End procedure norite


*!*********************************************************************
*!
*!      Procedure: TO_PRN
*!
*!      Called by: PRO2EROR.PRG                      
*!
*!*********************************************************************
PROCEDURE to_prn
***********************************************************************
*& Send error info to printer
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/8//91
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
SET CONSOLE OFF
LIST STATUS TO PRINT
LIST MEMORY TO PRINT
SET CONSOLE ON
RETURN
* End procedure TO_PRN


*!*********************************************************************
*!
*!      Procedure: BADRIGHTS
*!
*!      Called by: PRO2EROR.PRG                      
*!
*!*********************************************************************
PROCEDURE badrights
***********************************************************************
*& Cannot open file - Error # 1101
*
*   Assuming the name of the file has been spelled correctly and
*   the correct subdirectory has been stated, if necessary, the
*   most likely cause of this error is the user not having
*   the appropriate LAN rights.
*
*   In spite of what the FoxPro manuals may lead you to believe,
*   if the named file does not exist or if an invalid file name
*   or subdirectory has been used, Error #1 is returned, not
*   Error #1101.
*
*   User is sent to DOS after being returned to calling module.
*   Assumption is that if user does not have rights to open this
*   file user will also not have rights to open other files on
*   the LAN, therefore, no attempt is made (at the calling level)
*   to save error info to disk.  Using the same assumption, it
*   will not be possible to open the CALLWHOM file to obtain info
*   on the person who should be called.
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/8//91
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
DEFINE WINDOW bugbox FROM  5,23 TO 15,57 DOUBLE ;
   COLOR N/W,N/W,R+*/W SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox
@ 0, 7 SAY "   S O R R Y  " COLOR *+R/W
@ 2, 1 SAY "It appears you do not have the"
@ 3, 1 SAY "correct user rights on the LAN."
@ 5, 1 SAY "Please contact your LAN Admin-"
@ 6, 1 SAY "istrator to report this problem."
@ 8, 1 SAY "Press any key to quit to DOS..." COLOR +N/W
= INKEY(0, "MH")
RELEASE WINDOW bugbox
CLEAR TYPEAHEAD
RETURN
* End procedure BADRIGHTS



*!*********************************************************************
*!
*!      Procedure: REALBAD
*!
*!      Called by: PRO2EROR.PRG                      
*!
*!          Calls: A_LERT             (procedure in PRO2EROR.PRG)
*!
*!           Uses: CALLWHOM.DBF       
*!
*!*********************************************************************
PROCEDURE realbad
***********************************************************************
*& Database is trashed
*
*   Error #15 - Not a database file
*
*   Error #1115 - Database record is trashed
*                 Bad file header
*
*   Both errors can be caused by a bad .DBF file header.
*   Error # 15 can also occur is attempting to use a non-
*   .DBF file as a .DBF file.
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/9/91
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
DEFINE WINDOW bugbox FROM 5,22 TO 18,58 DOUBLE ;
   COLOR N/W,N/W,R+*/W SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox
@ 0, 6 SAY "  REALLY BAD NEWS  " COLOR *+R/W
@ 2, 1 SAY "A database file has been trashed!"
@ 4,10 SAY "Please contact"
SELECT 0
USE callwhom
* ========================================
*$ Get info on appropriate person to call
* ========================================
LOCATE FOR ALLTRIM(callwhom->title) == "APP ADMINISTRATOR"
STORE ALLTRIM(callwhom->call_who) TO m_call
STORE ALLTRIM(callwhom->other) TO m_title
STORE ALLTRIM(callwhom->phone) TO m_phone
@ 5, 0 SAY PADC(m->m_call, 35)
@ 6, 0 SAY PADC(m->m_title, 35)
@ 7, 0 SAY PADC(m->m_phone, 35)
@ 8, 6 SAY "to report this problem."
@10, 1 SAY "Press any key to" COLOR +N/W
@11, 1 SAY "return to Main Menu..." COLOR +N/W
DO a_lert            && Sound siren
= INKEY(0, "MH")
RELEASE WINDOW bugbox
CLEAR TYPEAHEAD
RETURN
* End procedure REALBAD



*!*********************************************************************
*!
*!      Procedure: A_LERT
*!
*!      Called by: REALBAD            (procedure in PRO2EROR.PRG)
*!
*!*********************************************************************
PROCEDURE a_lert
***********************************************************************
*& Sound warning siren
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/9/91
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
FOR xx = 1 TO 3
   SET BELL TO 1650-(18*xx), 3
   ?? CHR(7)
   SET BELL TO 650-(5*xx),3
   ?? CHR(7)
ENDFOR (xx)

SET BELL TO
RETURN
* End procedure a_lert


*!*********************************************************************
*!
*!      Procedure: KORRUPT
*!
*!      Called by: PRO2EROR.PRG                      
*!
*!          Calls: RAZBERRY           (procedure in PRO2EROR.PRG)
*!
*!           Uses: CALLWHOM.DBF       
*!
*!*********************************************************************
PROCEDURE korrupt
**********************************************************************
*& Corrupted object file
*
*   Error #67 - Internal consistency error
*
*   Error #1309 - Not an object file
*
*   Compiled object file has been corrupted - Recompile
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/9/91
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
DEFINE WINDOW bugbox FROM 5,22 TO 18,58 DOUBLE ;
   COLOR N/W,N/W,R+*/W SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox
@ 0, 9 SAY "  BAD NEWS  " COLOR *+R/W
@ 2, 1 SAY "An object file has been corrupted."
@ 4,10 SAY "Please contact"
SELECT 0
USE callwhom
* ========================================
*$ Get info on appropriate person to call
* ========================================
LOCATE FOR ALLTRIM(callwhom->title) == "APP ADMINISTRATOR"
STORE ALLTRIM(callwhom->call_who) TO m_call
STORE ALLTRIM(callwhom->other) TO m_title
STORE ALLTRIM(callwhom->phone) TO m_phone
@ 5, 0 SAY PADC(m->m_call, 35)
@ 6, 0 SAY PADC(m->m_title, 35)
@ 7, 0 SAY PADC(m->m_phone, 35)
@ 8, 6 SAY "to report this problem."
DO razberry
@10, 1 SAY "Press any key to" COLOR +N/W
@11, 1 SAY "return to Main Menu..." COLOR +N/W
= INKEY(0, "MH")
RELEASE WINDOW bugbox
CLEAR TYPEAHEAD
RETURN
* End procedure KORRUPT


*!*********************************************************************
*!
*!      Procedure: READ_ERR
*!
*!      Called by: PRO2EROR.PRG                      
*!
*!          Calls: RAZBERRY           (procedure in PRO2EROR.PRG)
*!               : YES_NO             (procedure in PRO2EROR.PRG)
*!
*!           Uses: CALLWHOM.DBF       
*!
*!*********************************************************************
PROCEDURE read_err
***********************************************************************
*  Error #1104 - File read error
*
*  The operating system returned an error to FoxPro
*  while FoxPro was attempting to read a file.  It could
*  just be a "hiccup" or there could be problems with the
*  disk, controller or LAN connection.  Provide user with
*  option to retry
*
*     Author: Pat Adams, DB Unlimited
*   Date: 8/9/91
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PARAMETERS rretry
DEFINE WINDOW bugbox FROM 3,14 TO 20,66 DOUBLE ;
   COLOR N/W,N/W,R+*/W SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox
@ 0,16 SAY "   BAD NEWS   " COLOR *+R/W
@ 2, 1 SAY "Your hardware and/or operating system returned an"
@ 3, 1 SAY "error while attempting to read a file.  It may be"
@ 4, 1 SAY "that this was just a minor 'hiccup' or you may be"
@ 5, 1 SAY "experiencing serious hardware problems."
@ 7, 1 SAY "If this is the first time you have received this"
@ 8, 1 SAY "error message try things again.  If not, your"
@ 9, 1 SAY "hard disk, controller and LAN connections should"
@10, 1 SAY "be checked - report the problem to:"
SELECT 0
USE callwhom
* ========================================
*$ Get info on appropriate person to call
* ========================================
LOCATE FOR ALLTRIM(callwhom->title) == "LAN ADMINISTRATOR"
STORE ALLTRIM(callwhom->call_who) TO m_call
STORE ALLTRIM(callwhom->other) TO m_title
STORE ALLTRIM(callwhom->phone) TO m_phone
@11, 0 SAY PADC(m->m_call, 51)
@12, 0 SAY PADC(m->m_title, 51)
@13, 0 SAY PADC(m->m_phone, 51)
DO razberry
@15, 9 SAY "Do you want to try again?   (Y/N)"
DO yes_no WITH rretry
RELEASE WINDOW bugbox
RETURN rretry
* End procedure READ_ERR



*!*********************************************************************
*!
*!      Procedure: RITE_ERR
*!
*!      Called by: PRO2EROR.PRG                      
*!
*!          Calls: RAZBERRY           (procedure in PRO2EROR.PRG)
*!               : YES_NO             (procedure in PRO2EROR.PRG)
*!
*!           Uses: CALLWHOM.DBF       
*!
*!*********************************************************************
PROCEDURE rite_err
***********************************************************************
*& File write error - Error # 1105
*
*   The most likely causes of this error are:
*
*   1.  An attempt to write to a floppy which is
*       write protected or a LAN subdirectory to
*       which the user does not have correct rights
*
*   2.  A problem with the operating system, hard disk,
*       controller, or LAN connections
*
*   User is provided with option to retry
*
*     Author: Pat Adams, DB Unlimited
*   Date: 8/9/91
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PARAMETERS re_try
DEFINE WINDOW bugbox FROM  3,4 TO 20,76 DOUBLE ;
   COLOR N/W,N/W,R+*/W SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox
@ 0,26 SAY "   BAD NEWS   " COLOR *+R/W
@ 2, 1 SAY "A problem has occurred while attempting " + ;
   "to write information to disk."
@ 3, 1 SAY "If you are attempting to write " + ;
   "to a floppy disk it may be that the"
@ 4, 1 SAY "disk is write protected.  If so, " + ;
   "unprotect the disk and try again."
@ 6, 1 SAY "If not, a 'hiccup' in the operating " + ;
   "system may have occurred.  You"
@ 7, 1 SAY "can simply try again.  However, if " + ;
   "this message continues to appear"
@ 8, 1 SAY "it may be that there is a problem " + ;
   "with the hard disk, controller,"
@ 9, 1 SAY "LAN connections or your LAN " + ;
   "authorization rights.  Please contact:"
SELECT 0
USE callwhom
* ========================================
*$ Get info on appropriate person to call
* ========================================
LOCATE FOR ALLTRIM(callwhom->title) == "LAN ADMINISTRATOR"
STORE ALLTRIM(callwhom->call_who) TO m_call
STORE ALLTRIM(callwhom->other) TO m_title
STORE ALLTRIM(callwhom->phone) TO m_phone
@10, 0 SAY PADC(m->m_call, 71)
@11, 0 SAY PADC(m->m_title, 71)
@12, 0 SAY PADC(m->m_phone, 71)
@13, 1 SAY "to report this problem."
DO razberry
@15,20 SAY "Do you want to try again? (Y/N)"
DO yes_no WITH re_try
RELEASE WINDOW bugbox
RETURN re_try
* End procedure RITE_ERR


*!*********************************************************************
*!
*!      Procedure: INVALPRN
*!
*!      Called by: PRO2EROR.PRG                      
*!
*!          Calls: RAZBERRY           (procedure in PRO2EROR.PRG)
*!
*!           Uses: CALLWHOM.DBF       
*!
*!*********************************************************************
PROCEDURE invalprn
************************************************************************
*
*   Error #124 - Invalid printer redirection
*
*  This normally occurs when attempts are made to share a non-
*  sharable printer on a LAN or the path to the print device
*  has not been properly defined.
*
*  User will be returned to MASTER module.
*
*     Author: Pat Adams, DB Unlimited
*   Date: 8/9/91
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
DEFINE WINDOW bugbox FROM 3,17 TO 21,62 DOUBLE ;
   COLOR N/W,N/W,R+*/W SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox
@ 0,12 SAY "   W H O O P S   "
@ 2, 1 SAY "An attempt was made to use an unavailable"
@ 3, 1 SAY "print device.  Either the printer you want"
@ 4, 1 SAY "is not sharable or the correct DOS PATH"
@ 5, 1 SAY "setting has not been made.  This latter"
@ 6, 1 SAY "problem can only be fixed by returning to"
@ 7, 1 SAY "DOS, correcting matters there and then"
@ 8, 1 SAY "entering this application again."
@10,15 SAY "Please contact"
SELECT 0
USE callwhom
* ========================================
*$ Get info on appropriate person to call
* ========================================
LOCATE FOR ALLTRIM(callwhom->title) == "LAN ADMINISTRATOR"
STORE ALLTRIM(callwhom->call_who) TO m_call
STORE ALLTRIM(callwhom->other) TO m_title
STORE ALLTRIM(callwhom->phone) TO m_phone
@11, 0 SAY PADC(m->m_call, 43)
@12, 0 SAY PADC(m->m_title, 43)
@13, 0 SAY PADC(m->m_phone, 43)
@14,11 SAY "to report this problem."
@16, 1 SAY "Press any key to return to Main Menu..." COLOR +N/W
DO razberry
= INKEY(0, "MH")
RELEASE WINDOW bugbox
CLEAR TYPEAHEAD
RETURN
* End procedure INVALPRN



*!*********************************************************************
*!
*!      Procedure: NOTREADY
*!
*!      Called by: PRO2EROR.PRG                      
*!
*!          Calls: RAZBERRY           (procedure in PRO2EROR.PRG)
*!               : YES_NO             (procedure in PRO2EROR.PRG)
*!
*!*********************************************************************
PROCEDURE notready
***********************************************************************
* Error #125 - Printer not ready
*
*   This error is triggered by a variety of problems:
*
*   1.  The printer is not turned on or plugged in.
*
*   2.  Printer is not on-line
*
*   3.  Printer out of paper or a paper jam has occurred
*
*   4.  The printer is timing out.  Changing the CONFIG.FP file
*       to include the statement:
*
*           TIME=10000000
*
*       and issuing a DOS command:
*
*           MODE LPT1,,p
*
*       to set up DOS for infinite retry of the printer will
*       usually help.
*
*   5.  The connection between the computer and the printer may
*       not be solid or the printer cable may be squashed.
*
*   Note that this error will occur infrequently, if at all, on a
*   LAN because output will normally be sent to a print spooler.
*
*   User is provided the option to try again for the printer or
*   Abort to the MASTER module.
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/13/91
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PARAMETERS re_try
DEFINE WINDOW bugbox FROM 5,9 TO 18,71 DOUBLE ;
   COLOR N/W,N/W,R+*/W SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox
@ 0,20 SAY "   W H O O P S   " COLOR *+R/W
@ 2, 1 SAY "There is a problem with your printer.  Check the following:"
@ 4, 1 SAY "1.  Is the printer turned on?"
@ 6, 1 SAY "2.  Is the printer on-line? (A green light on the printer"
@ 7, 5 SAY "usually indicates the printer is on-line.)"
@ 9, 1 SAY "3.  Is the printer out of paper or is there a paper jam?"
@11, 2 SAY "WOULD YOU LIKE TO TRY FOR USE OF THE PRINTER AGAIN?  (Y/N)"
* ====================
*$ Sound Bronx cheer
* ====================
DO razberry
DO yes_no WITH re_try
RELEASE WINDOW bugbox
RETURN re_try
* End procedure NOTREADY



*!*********************************************************************
*!
*!      Procedure: PKORRUPT
*!
*!      Called by: PRO2EROR.PRG                      
*!
*!          Calls: RAZBERRY           (procedure in PRO2EROR.PRG)
*!
*!           Uses: CALLWHOM.DBF       
*!
*!*********************************************************************
PROCEDURE pkorrupt
***********************************************************************
*& Error #1643 - Printer driver corrupted
** Error #1644 - Printer driver is missing
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/13/91
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
DEFINE WINDOW bugbox FROM 5,14 TO 18,66 DOUBLE ;
   COLOR N/W,N/W,R+*/W SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox
@ 0,17 SAY "  BAD NEWS  " COLOR *+R/W
@ 2, 1 SAY "Your printer driver has been corrupted.  Printing"
@ 3, 1 SAY "can not be done until this is corrected."
@ 5,18 SAY "Please contact"
SELECT 0
USE callwhom
* ========================================
*$ Get info on appropriate person to call
* ========================================
LOCATE FOR ALLTRIM(callwhom->title) == "APP ADMINISTRATOR"
STORE ALLTRIM(callwhom->call_who) TO m_call
STORE ALLTRIM(callwhom->other) TO m_title
STORE ALLTRIM(callwhom->phone) TO m_phone
@ 6, 0 SAY PADC(m->m_call, 50)
@ 7, 0 SAY PADC(m->m_title, 50)
@ 8, 0 SAY PADC(m->m_phone, 50)
@ 9,15 SAY "to report this problem."
@11, 1 SAY "Press any key to return to Main Menu..." COLOR +N/W
DO razberry
= INKEY(0, "MH")
RELEASE WINDOW bugbox
CLEAR TYPEAHEAD
RETURN
* End procedure PKORRUPT


*!*********************************************************************
*!
*!      Procedure: LOWFILES
*!
*!      Called by: PRO2EROR.PRG                      
*!
*!          Calls: RAZBERRY           (procedure in PRO2EROR.PRG)
*!
*!           Uses: CALLWHOM.DBF       
*!
*!*********************************************************************
PROCEDURE lowfiles
***********************************************************************
*$ Error #6 - Too many files open
*
*   FoxPro 2.0 supports 99 open file handles in FoxPro.  A FILES=
*   statement in the CONFIG.FP file is not necessary and, if
*   present will be ignored.  However, the following conditions
*   must be present on the computer, work node and file server:
*
*   1.  CONFIG.SYS must include the FILES= statement.  Although
*       different vendor editions of different versions of DOS
*       support a different FILES= maximum, in general DOS 3.3
*       and above supports a maximum of 250 file handles.  Usually
*       a CONFIG.SYS statement of FILES=105 is sufficient.
*
*   2.  Depending upon the LAN OS in use, the work node may need
*       a specific file handles statement for the LAN OS.  DOS
*       based LANs such as InvisibleNET and LANtastic use the DOS
*       CONFIG.SYS statement while LANs such as Novell require the
*       SHELL.CFG or NET.CFG file on each work station with a
*       FILE HANDLES=xxxx statement.  Otherwise Novell will default
*       to 40 file handles no matter what the CONFIG.SYS setting.
*       If both a NET.CFG and SHELL.CFG are present on the work node
*       the NET.CFG file settings take precedence.
*
*   3.  Novell LANs also require that the FILE HANDLES setting for
*       the server be adjusted upwards.  Otherwise the default will
*       be 40 file handles and this will take precedence over any
*       settings on the work node.
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/13/91
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
DEFINE WINDOW bugbox FROM 1,12 TO 22,68 DOUBLE ;
   COLOR N/W,N/W,R+*/W SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox
@ 0,19 SAY "  BAD NEWS  " COLOR *+R/W
@ 2, 9 SAY "You don't have enough 'file handles!'"
@ 4, 1 SAY "1.  Increase the FILES= statement in your CONFIG.SYS."
@ 6, 1 SAY "2.  If working on a Novell LAN increase the FILE"
@ 7, 5 SAY "HANDLES= statement in the SHELL.CFG file."
* =============================================
* NOTE: This message should be modified for
*       those working with a stand-alone system
* =============================================
@ 9, 1 SAY "3.  If you are attached to a Novell LAN the FILE"
@10, 5 SAY "HANDLES= statement on the LAN server may also"
@11, 5 SAY "need to be increased."
@13,19 SAY "Please contact"
SELECT 0
USE callwhom
* ========================================
*$ Get info on appropriate person to call
* ========================================
LOCATE FOR ALLTRIM(callwhom->title) == "LAN ADMINISTRATOR"
STORE ALLTRIM(callwhom->call_who) TO m_call
STORE ALLTRIM(callwhom->other) TO m_title
STORE ALLTRIM(callwhom->phone) TO m_phone
@14, 0 SAY PADC(m->m_call, 55)
@15, 0 SAY PADC(m->m_title, 55)
@16, 0 SAY PADC(m->m_phone, 55)
@17,16 SAY "to report this problem."
@19, 1 SAY "Press any key to return to Main Menu..."
DO razberry
= INKEY(0, "MH")
RELEASE WINDOW bugbox
CLEAR TYPEAHEAD
RETURN
* End procedure LOWFILES


*!*********************************************************************
*!
*!      Procedure: NOMEMO
*!
*!      Called by: PRO2EROR.PRG                      
*!
*!          Calls: RAZBERRY           (procedure in PRO2EROR.PRG)
*!
*!           Uses: CALLWHOM.DBF       
*!
*!*********************************************************************
PROCEDURE nomemo
***********************************************************************
*& Error #41 - MEMO file is missing/invalid
*
*   The most likely cause of this error is an attempt to
*   USE a database file whose associated memo file (either
*   .DBT or .FPT) has been erased.
*
*   Other possible causes include a trashed .DBT or .FPT file
*   or a .DBT/.FPT file which does not match the .DBF file.
*
*   User is returned to the MASTER module.  Depending upon the
*   application, it may be desirable to change this so the user
*   is returned to DOS.
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/14/91
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
DEFINE WINDOW bugbox FROM 3,16 TO 19,63 DOUBLE ;
   COLOR N/W,N/W,R+*/W SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox
@ 0,15 SAY "  BAD NEWS  " COLOR *+R/W
@ 2, 1 SAY "A 'memo field' file which contains free form"
@ 3, 1 SAY "text has been erased or does not properly"
@ 4, 1 SAY "match its corresponding database file.  It's"
@ 5, 1 SAY "not possible to continue until this has been"
@ 6, 1 SAY "corrected."
@ 8,16 SAY "Please contact"
SELECT 0
USE callwhom
* ========================================
*$ Get info on appropriate person to call
* ========================================
LOCATE FOR ALLTRIM(callwhom->title) == "APP ADMINISTRATOR"
STORE ALLTRIM(callwhom->call_who) TO m_call
STORE ALLTRIM(callwhom->other) TO m_title
STORE ALLTRIM(callwhom->phone) TO m_phone
@ 9, 0 SAY PADC(m->m_call, 46)
@10, 0 SAY PADC(m->m_title, 46)
@11, 0 SAY PADC(m->m_phone, 46)
@12,12 SAY "to report the problem."
@14, 1 SAY "Press any key to return to Main Menu..." COLOR +N/W
DO razberry
= INKEY(0, "MH")
RELEASE WINDOW bugbox
CLEAR TYPEAHEAD
RETURN
* End procedure NOMEMO



*!*********************************************************************
*!
*!      Procedure: LOWMEMRY
*!
*!      Called by: PRO2EROR.PRG                      
*!
*!          Calls: RAZBERRY           (procedure in PRO2EROR.PRG)
*!
*!           Uses: CALLWHOM.DBF       
*!
*!*********************************************************************
PROCEDURE lowmemry
***********************************************************************
*& Error #43 - Insufficient memory
*
*& Error #809 - SQL out of memory
*
*& Error #845 - SQL expression too complex
*               FoxPro ran out of memory when it
*               tried to expand the SELECT
*               statement to analyze it
*
*& Error #1149 - No memory for buffer
*
*& Error #1150 - No memory for file map
*
*& Error #1151 - No memory for file name
*
*& Error #1600 - Not enough memory to USE database
*
*   User will be returned to DOS
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/14/91
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
DEFINE WINDOW bugbox FROM 5,17 TO 17,62 DOUBLE ;
   COLOR N/W,N/W,R+*/W SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox
@ 0,14 SAY "  BAD NEWS  " COLOR *+R/W
@ 2, 1 SAY "Your computer does not have enough memory."
@ 4,15 SAY "Please contact"
SELECT 0
USE callwhom
* ========================================
*$ Get info on appropriate person to call
* ========================================
LOCATE FOR ALLTRIM(callwhom->title) == "DEVELOPER"
STORE ALLTRIM(callwhom->call_who) TO m_call
STORE ALLTRIM(callwhom->other) TO m_title
STORE ALLTRIM(callwhom->phone) TO m_phone
@ 5, 0 SAY PADC(m->m_call, 44)
@ 6, 0 SAY PADC(m->m_title, 44)
@ 7, 0 SAY PADC(m->m_phone, 44)
@ 8,11 SAY "to report the problem."
@10, 1 SAY "Press any key to return to DOS..." COLOR +N/W
DO razberry
= INKEY(0, "MH")
RELEASE WINDOW bugbox
CLEAR TYPEAHEAD
RETURN
* End procedure LOWMEMRY


*!*********************************************************************
*!
*!      Procedure: BAD_RPT
*!
*!      Called by: PRO2EROR.PRG                      
*!
*!          Calls: RAZBERRY           (procedure in PRO2EROR.PRG)
*!
*!           Uses: CALLWHOM.DBF       
*!
*!*********************************************************************
PROCEDURE bad_rpt
***********************************************************************
*& Error #50 - Report file invalid
*& Error #54 - Label file invalid
*& Error #1241 - Improper data type in group expression
*& Error #1243 - Internal error: Too many characters in report
*& Error #1245 - Error in label field definition
*& Error #1246 - Total label width exceeds maximum allowable
*& Error #1645 - Report nesting error
*& Error #1646 - Total field type in report must be numeric
*& Error #1647 - Improper data type in field expression
*
*   The most likely causes of this error are:
*
*   1.  Syntax error in the REPORT FORM .FRX file
*       or the LABEL FORM file
*
*   2.  Descriptions in the REPORT or LABEL FORM file do
*       not match the database
*
*   3.  The REPORT or LABEL file has become corrupted
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/14/91
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PARAMETERS error_no
PRIVATE which1, which2

IF error_no = 50 .OR. error_no = 1241 .OR. error_no = 1243 ;
      .OR. error_no = 1645 .OR. error_no = 1646 .OR. error_no ;
      = 1647
   STORE "report" TO which1, which2
ELSE
   STORE "label" TO which1
   STORE "labels" TO which2
ENDIF  (error_no = 50 .OR. error_no = 1241 .OR. error_no = 1243 ;)

DEFINE WINDOW bugbox FROM 5,19 TO 19,61 DOUBLE ;
   COLOR N/W,N/W,R+*/W SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox
@ 0,10 SAY "   W H O O P S  " COLOR *+R/W
@ 2, 1 SAY "There is a problem with the &which1 form"
@ 3, 1 SAY "file.  The &which2 can not be generated"
@ 4, 1 SAY "until the problem is corrected."
@ 6,13 SAY "Please contact"
SELECT 0
USE callwhom
* ========================================
*$ Get info on appropriate person to call
* ========================================
LOCATE FOR ALLTRIM(callwhom->title) == "DEVELOPER"
STORE ALLTRIM(callwhom->call_who) TO m_call
STORE ALLTRIM(callwhom->other) TO m_title
STORE ALLTRIM(callwhom->phone) TO m_phone
@ 7, 0 SAY PADC(m->m_call, 41)
@ 8, 0 SAY PADC(m->m_title, 41)
@ 9, 0 SAY PADC(m->m_phone, 41)
@10, 9 SAY "to report the problem."
@12, 1 SAY "Press any key to return to Main Menu..." COLOR +N/W
DO razberry
=INKEY(0, "MH")
RELEASE WINDOW bugbox
CLEAR TYPEAHEAD
RETURN
* End procedure BAD_RPT


*!*********************************************************************
*!
*!      Procedure: BADMEMFL
*!
*!      Called by: PRO2EROR.PRG                      
*!
*!          Calls: RAZBERRY           (procedure in PRO2EROR.PRG)
*!
*!           Uses: CALLWHOM.DBF       
*!
*!*********************************************************************
PROCEDURE badmemfl
***********************************************************************
*& Error #55 - Memory Variable file is invalid
*
*   An attempt was made to RESTORE FROM a .MEM file
*   which has been trashed.
*
*   If info in the .MEM file is necessary to the overall
*   application change this module so user is returned to DOS.
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/14/91
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
DEFINE WINDOW bugbox FROM 4,19 TO 19,61 DOUBLE ;
   COLOR N/W,N/W,R+*/W SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox
@ 0,10 SAY "   W H O O P S  " COLOR *+R/W
@ 2, 1 SAY "There is a problem with a 'memory' file"
@ 3, 1 SAY "which contains necessary information."
@ 4, 1 SAY "This option can not be used until the"
@ 5, 1 SAY "problem has been corrected."
@ 7,13 SAY "Please contact"
SELECT 0
USE callwhom
* ========================================
*$ Get info on appropriate person to call
* ========================================
LOCATE FOR ALLTRIM(callwhom->title) == "DEVELOPER"
STORE ALLTRIM(callwhom->call_who) TO m_call
STORE ALLTRIM(callwhom->other) TO m_title
STORE ALLTRIM(callwhom->phone) TO m_phone
@ 8, 0 SAY PADC(m->m_call, 41)
@ 9, 0 SAY PADC(m->m_title, 41)
@10, 0 SAY PADC(m->m_phone, 41)
@11, 9 SAY "to report the problem."
@13, 1 SAY "Press any key to return to Main Menu..." COLOR +N/W
DO razberry
= INKEY(0, "MH")
RELEASE WINDOW bugbox
CLEAR TYPEAHEAD
RETURN
* End procedure BADMEMFL



*!*********************************************************************
*!
*!      Procedure: NOSPACE
*!
*!      Called by: PRO2EROR.PRG                      
*!
*!          Calls: ISLAN              (procedure in PRO2EROR.PRG)
*!               : RAZBERRY           (procedure in PRO2EROR.PRG)
*!               : YES_NO             (procedure in PRO2EROR.PRG)
*!
*!*********************************************************************
PROCEDURE nospace
***********************************************************************
*& Error #56 - Not enough disk space
*
*   User has run out of disk space on a local hard disk,
*   a floppy disk, or in a LAN server subdirectory.
*
*   If user has a printer available send error output to
*   the printer.  An attempt is not made to USE the CALLWHOM
*   file since this error condition may preclude such activity.
*
*   Menachem Bazian reports that the "out of disk" error has
*   been erroneously reported under both Novell 2.15C and Novell
*   3.11 at times.  This has been traced to files which have no
*   "owner" but, instead, are classified as N/A under Novell.
*   Without a Novell owner the size of a file can not be
*   increased.  Theoretically it should not be possible for a
*   file to be created under Novell without an owner, however...
*
*   Fox Software indicates they are planning an enhancement
*   to FoxPro 2.0 which will also report the disk which is
*   out of disk space.  Once this is available PRO2EROR will
*   be modified to make use of this option.
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/14/91
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PARAMETERS doprint

IF islan()
   * ==========================================
   *$ Provide user with error info appropriate
   *$ to those using a LAN
   * ==========================================
   DEFINE WINDOW bugbox FROM 5,14 TO 17,66 DOUBLE ;
      COLOR N/W,N/W,R+*/W SHADOW
   ACTIVATE SCREEN
   ACTIVATE WINDOW bugbox
   @ 0,14 SAY "  REALLY BAD NEWS  " COLOR *+R/W
   @ 2, 1 SAY "You have run out of space on the LAN subdirectory"
   @ 3, 1 SAY "in use, on your local hard disk or on the floppy"
   @ 4, 1 SAY "disk if you are attempting to write to a floppy."
   @ 6, 1 SAY "Information about this problem will be send to"
   @ 7, 1 SAY "the printer before returning you to DOS.  Please"
   @ 8, 1 SAY "give a copy to your LAN administrator."
   @10, 1 SAY "Press any key to continue..." COLOR +N/W
   DO razberry
   = INKEY(0, "MH")
   * ==================================
   * Assumption is that a printer will
   * always be available on a LAN
   * ==================================
   STORE .T. TO doprint
ELSE
   * ==========================================
   *$ Otherwise display error info appropriate
   *$ to a stand-alone system
   * ==========================================
   DEFINE WINDOW nospace FROM 6,16 TO 15,64 DOUBLE ;
      COLOR N/W,N/W,R+*/W SHADOW
   ACTIVATE SCREEN
   ACTIVATE WINDOW nospace
   @ 0,12 SAY "  REALLY BAD NEWS  " COLOR *+R/W
   @ 2, 1 SAY "There is no more space on your hard disk or,"
   @ 3, 1 SAY "if you are writing to a floppy disk, on that"
   @ 4, 1 SAY "floppy disk."
   @ 6, 1 SAY "Would you like to print out error information"
   @ 7, 1 SAY "before returning to DOS?  (Y/N)"
   DO razberry
   DO yes_no WITH doprint
   
   IF doprint
      DEFINE WINDOW makesure FROM 9,10 TO 12,70 "", ;
         "","","","","","","" ;
         COLOR W+*/N,N/W,W+*/N SHADOW
      ACTIVATE SCREEN
      ACTIVATE WINDOW makesure
      @ 0, 0 SAY REPLICATE("",59)
      @ 1, 0 SAY REPLICATE("",59)
      @ 0, 2 SAY "Please make sure your printer " + ;
         "is turned on and on-line."
      @ 1,12 SAY " Press any key to begin printing..."
      = INKEY(0, "MH")
      RELEASE WINDOW makesure
   ENDIF  (doprint)
ENDIF  (islan())

RELEASE WINDOW bugbox
CLEAR TYPEAHEAD
RETURN doprint
* End procedure NOSPACE



*!*********************************************************************
*!
*!      Procedure: ISLAN
*!
*!      Called by: NOSPACE            (procedure in PRO2EROR.PRG)
*!               : SQL_IDX            (procedure in PRO2EROR.PRG)
*!               : BADCLOSE           (procedure in PRO2EROR.PRG)
*!
*!*********************************************************************
FUNCTION islan
***********************************************************************
*& Determine if LAN is in use
*
*   NOTE: GETENV("USER") is only valid if a LAN log-in
*         which initializes a DOS environmental named
*         USER has been utilized.  This is part of the
*         most commonly used Novell log-in script.
*         Alternately, the DOS environmental can be
*         established with the DOS command:
*
*             SET USER=<user name>
*
*         before entering FoxPro.
*
*         While many network boards return a number and/or
*         name for SYS(0) there are some which do not.  This
*         needs to be tested for each LAN environment.
*
* Author: Pat Adams   10/26/90
* Modified 8/1/91 by Pat Adams
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PARAMETERS if_lan

IF NETWORK()
   IF EMPTY(GETENV("USER")) .AND. ATC("# 0", node_no) >0
      STORE .F. TO if_lan
   ELSE
      * ===========================
      *$ LAN is in use
      * ==========================
      STORE .T. TO if_lan
   ENDIF  (EMPTY(GETENV("USER")) .AND. ATC("# 0", node_no) >0)
ELSE
   STORE .F. TO if_lan
ENDIF  (NETWORK())

RETURN if_lan
* End UDF ISLAN()



*!*********************************************************************
*!
*!      Procedure: BAD_DIF
*!
*!      Called by: PRO2EROR.PRG                      
*!
*!          Calls: RAZBERRY           (procedure in PRO2EROR.PRG)
*!
*!           Uses: CALLWHOM.DBF       
*!
*!*********************************************************************
PROCEDURE bad_dif
***********************************************************************
*& Error #115 - Invalid DIF file header
*& Error #116 - Invalid DIF vector-DBF field mismatch
*& Error #117 - Invalid DIF type indicator
*
*   The DIF file user is attempting to import may not
*   be in the DIF file format, the file may be corrupted,
*   or if APPEND FROM...DIF has been used the data elements
*   of the DIF file may not match the database in use.
*
* Author: Pat Adams
* Date: 8/1/91
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
DEFINE WINDOW bugbox FROM 4,12 TO 19,68 ;
   COLOR N/W,N/W,R+*/W SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox
@ 0,18 SAY "   S O R R Y   " COLOR *+R/W
@ 2, 1 SAY "There's a problem with the DIF " + ;
   "(VisiCalc) file you"
@ 3, 1 SAY "are attempting to import.  " + ;
   "It may not actually be a"
@ 4, 1 SAY "DIF file, the file header may " + ;
   "be corrupted, or the"
@ 5, 1 SAY "data elements may not match the " + ;
   "database file in use."
@ 7,20 SAY "Please contact"
SELECT 0
USE callwhom
* ========================================
*$ Get info on appropriate person to call
* ========================================
LOCATE FOR ALLTRIM(callwhom->title) == "APP ADMINISTRATOR"
STORE ALLTRIM(callwhom->call_who) TO m_call
STORE ALLTRIM(callwhom->other) TO m_title
STORE ALLTRIM(callwhom->phone) TO m_phone
@ 8, 0 SAY PADC(m->m_call, 55)
@ 9, 0 SAY PADC(m->m_title, 55)
@10, 0 SAY PADC(m->m_phone, 41)
@11,17 SAY "to report this problem."
@13, 1 SAY "Press any key to return to Main Menu..." COLOR +N/W
DO razberry
= INKEY(0, "MH")
RELEASE WINDOW bugbox
CLEAR TYPEAHEAD
RETURN
* End procedure BAD_DIF


*!*********************************************************************
*!
*!      Procedure: BAD_SYLK
*!
*!      Called by: PRO2EROR.PRG                      
*!
*!          Calls: RAZBERRY           (procedure in PRO2EROR.PRG)
*!
*!           Uses: CALLWHOM.DBF       
*!
*!*********************************************************************
PROCEDURE bad_sylk
***********************************************************************
*& Error #119 - Invalid SYLK file header -
*    File header may have been trashed
*
*& Error #120 - Invalid SYLK dimension bounds -
*    The file being imported is indicating invalid
*    rows or columns - it is 'out of bounds'
*
*& Error #121 - Invalid SYLK file format -
*    File is not a SYLK (Multiplan) file.  It may
*    be that the file is a Multiplan 4.01 file in
*    which case the MOD option should be used.
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/14/91
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
DEFINE WINDOW bugbox FROM  4,12 TO 19,68 DOUBLE ;
   COLOR N/W,N/W,R+*/W SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox
@ 0,18 SAY "   S O R R Y   " COLOR *+R/W
@ 2, 1 SAY "There's a problem with the Multiplan " + ;
   "SYLK file that"
@ 3, 1 SAY "is being imported.  The SYLK " + ;
   "file may be corrupted"
@ 4, 1 SAY "or it may be that the file is a " + ;
   "Multiplan 4.01 file"
@ 5, 1 SAY "which uses the MOD file structure " + ;
   "rather than SYLK."
@ 7,20 SAY "Please contact"
SELECT 0
USE callwhom
* ========================================
*$ Get info on appropriate person to call
* ========================================
LOCATE FOR ALLTRIM(callwhom->title) == "APP ADMINISTRATOR"
STORE ALLTRIM(callwhom->call_who) TO m_call
STORE ALLTRIM(callwhom->other) TO m_title
STORE ALLTRIM(callwhom->phone) TO m_phone
@ 8, 0 SAY PADC(m->m_call, 55)
@ 9, 0 SAY PADC(m->m_title, 55)
@10, 0 SAY PADC(m->m_phone, 55)
@11,17 SAY "to report this problem."
@13, 1 SAY "Press any key to return to Main Menu..." COLOR +N/W
DO razberry
= INKEY(0, "MH")
RELEASE WINDOW bugbox
CLEAR TYPEAHEAD
RETURN
* End procedure BAD_SYLK


*!*********************************************************************
*!
*!      Procedure: NOTRIGHT
*!
*!      Called by: PRO2EROR.PRG                      
*!
*!          Calls: RAZBERRY           (procedure in PRO2EROR.PRG)
*!
*!           Uses: CALLWHOM.DBF       
*!
*!*********************************************************************
PROCEDURE notright
***********************************************************************
*& Error #255 - Not a valid Rapidfile database
*& Error #256 - Not a valid Framework II database\spreadsheet
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/14/91
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PARAMETERS error_no
PRIVATE ftype

IF error_no = 255
   ftype = "RapidFile"
ELSE
   ftype = "Framework II"
ENDIF  (error_no = 255)

DEFINE WINDOW bugbox FROM 5,14 TO 18,65 DOUBLE ;
   COLOR N/W,N/W,R+*/W SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox
@ 0,15 SAY "   S O R R Y   " COLOR *+R/W
@ 2, 1 SAY "The file from which you are attempting to import"
@ 3, 1 SAY "data is not a valid &ftype file."
@ 5, 7 SAY "If you would like help please contact"
SELECT 0
USE callwhom
* ========================================
*$ Get info on appropriate person to call
* ========================================
LOCATE FOR ALLTRIM(callwhom->title) == "APP ADMINISTRATOR"
STORE ALLTRIM(callwhom->call_who) TO m_call
STORE ALLTRIM(callwhom->other) TO m_title
STORE ALLTRIM(callwhom->phone) TO m_phone
@ 6, 0 SAY PADC(m->m_call, 50)
@ 7, 0 SAY PADC(m->m_title, 50)
@ 8, 0 SAY PADC(m->m_phone, 50)
@ 9,14 SAY "to report this problem."
@11, 1 SAY "Press any key to return to Main Menu..."
DO razberry
= INKEY(0, "MH")
RELEASE WINDOW bugbox
CLEAR TYPEAHEAD
RETURN
* End procedure NOTRIGHT



*!*********************************************************************
*!
*!      Procedure: BADLOTUS
*!
*!      Called by: PRO2EROR.PRG                      
*!
*!          Calls: RAZBERRY           (procedure in PRO2EROR.PRG)
*!
*!           Uses: CALLWHOM.DBF       
*!
*!*********************************************************************
PROCEDURE badlotus
***********************************************************************
*& Error #297 - Invalid Lotus 1-2-3 version 2.0 file format
*& Error #1662 - Invalid Lotus 1-2-3 Version 1.0 file format
*& Error #1678 - Invalid Lotus 1-2-3 version 3.0 file format
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/16/91
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PARAMETERS error_no
PRIVATE which1

DO CASE error_no
   CASE error_no = 297
      STORE "2.0" TO which1
      
   CASE error_no = 1662
      STORE "1.0" TO which1
      
   CASE error_no = 1678
      STORE "3.0" TO which1
ENDCASE        error_no

DEFINE WINDOW bugbox FROM 4,12 TO 17,68 DOUBLE ;
   COLOR N/W,N/W,R+*/W SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox
@ 0,18 SAY "   S O R R Y   " COLOR *+R/W
@ 2, 1 SAY "The file from which you are " + ;
   "attempting to import data"
@ 3, 1 SAY "is not a valid Lotus 1-2-3 " + ;
   "version &which1 file."
@ 5, 9 SAY "If you would like help please contact"
SELECT 0
USE callwhom
* ========================================
*$ Get info on appropriate person to call
* ========================================
LOCATE FOR ALLTRIM(callwhom->title) == "APP ADMINISTRATOR"
STORE ALLTRIM(callwhom->call_who) TO m_call
STORE ALLTRIM(callwhom->other) TO m_title
STORE ALLTRIM(callwhom->phone) TO m_phone
@ 6, 0 SAY PADC(m->m_call, 54)
@ 7, 0 SAY PADC(m->m_title, 54)
@ 8, 0 SAY PADC(m->m_phone, 54)
@ 9,17 SAY "to report this problem."
@11, 1 SAY "Press any key to return to Main Menu..." COLOR +N/W
DO razberry
= INKEY(0, "MH")
RELEASE WINDOW bugbox
CLEAR TYPEAHEAD
RETURN
* End procedure BADLOTUS


*!*********************************************************************
*!
*!      Procedure: BADSYMPH
*!
*!      Called by: PRO2EROR.PRG                      
*!
*!          Calls: RAZBERRY           (procedure in PRO2EROR.PRG)
*!
*!           Uses: CALLWHOM.DBF       
*!
*!*********************************************************************
PROCEDURE badsymph
***********************************************************************
*& Error #1673 - Invalid Symphony version 1.0 file format
*& Error #1674 - Invalid Symphony version 1.1 file format
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/16/91
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PARAMETERS error_no
PRIVATE which1

DO CASE error_no
   CASE error_no = 1673
      STORE "1.0" TO which1
      
   CASE error_no = 1674
      STORE "1.1" TO which1
ENDCASE        error_no

DEFINE WINDOW bugbox FROM 4,12 TO 17,68 DOUBLE ;
   COLOR N/W,N/W,R+*/W SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox
@ 0,18 SAY "   S O R R Y   " COLOR *+R/W
@ 2, 1 SAY "The file from which you are " + ;
   "attempting to import data"
@ 3, 1 SAY "is not a valid Symphony " + ;
   "version &which1 file."
@ 5, 9 SAY "If you would like help please contact"
SELECT 0
USE callwhom
* ========================================
*$ Get info on appropriate person to call
* ========================================
LOCATE FOR ALLTRIM(callwhom->title) == "APP ADMINISTRATOR"
STORE ALLTRIM(callwhom->call_who) TO m_call
STORE ALLTRIM(callwhom->other) TO m_title
STORE ALLTRIM(callwhom->phone) TO m_phone
@ 6, 0 SAY PADC(m->m_call, 54)
@ 7, 0 SAY PADC(m->m_title, 54)
@ 8, 0 SAY PADC(m->m_phone, 54)
@ 9,17 SAY "to report this problem."
@11, 1 SAY "Press any key to return to Main Menu..." COLOR +N/W
DO razberry
= INKEY(0, "MH")
RELEASE WINDOW bugbox
CLEAR TYPEAHEAD
RETURN
* End procedure BADSYMPH


*!*********************************************************************
*!
*!      Procedure: BADEXCEL
*!
*!      Called by: PRO2EROR.PRG                      
*!
*!          Calls: RAZBERRY           (procedure in PRO2EROR.PRG)
*!
*!           Uses: CALLWHOM.DBF       
*!
*!*********************************************************************
PROCEDURE badexcel
***********************************************************************
*& Error #1661 - Invalid Excel version 2.0 file format
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/16/91
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
DEFINE WINDOW bugbox FROM 4,12 TO 17,68 DOUBLE ;
   COLOR N/W,N/W,R+*/W SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox
@ 0,18 SAY "   S O R R Y   " COLOR *+R/W
@ 2, 1 SAY "The file from which you are " + ;
   "attempting to import data"
@ 3, 1 SAY "is not a valid Excel " + ;
   "version 2.0 file."
@ 5, 9 SAY "If you would like help please contact"
SELECT 0
USE callwhom
* ========================================
*$ Get info on appropriate person to call
* ========================================
LOCATE FOR ALLTRIM(callwhom->title) == "APP ADMINISTRATOR"
STORE ALLTRIM(callwhom->call_who) TO m_call
STORE ALLTRIM(callwhom->other) TO m_title
STORE ALLTRIM(callwhom->phone) TO m_phone
@ 6, 0 SAY PADC(m->m_call, 54)
@ 7, 0 SAY PADC(m->m_title, 54)
@ 8, 0 SAY PADC(m->m_phone, 54)
@ 9,17 SAY "to report this problem."
@11, 1 SAY "Press any key to return to Main Menu..." COLOR +N/W
DO razberry
= INKEY(0, "MH")
RELEASE WINDOW bugbox
CLEAR TYPEAHEAD
RETURN
* End procedure BADEXCEL


*!*********************************************************************
*!
*!      Procedure: SQL_INTL
*!
*!      Called by: PRO2EROR.PRG                      
*!
*!          Calls: RAZBERRY           (procedure in PRO2EROR.PRG)
*!
*!           Uses: CALLWHOM.DBF       
*!
*!*********************************************************************
PROCEDURE sql_intl
***********************************************************************
*& Error #800 -SQL Internal Err
*
*   User is instructed to call developer and then is
*   returned to DOS since the internal SQL error may
*   disrupt memory management.  Developer should report
*   details of the problem to Fox Software Technical
*   Support
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/16/91
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
DEFINE WINDOW bugbox FROM 4,17 TO 19,63 DOUBLE ;
   COLOR N/W,N/W,R+*/W SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox
@ 0,12 SAY "   W H O O P S   " COLOR *+R/W
@ 2, 1 SAY "An internal SQL error has occurred.  This"
@ 3, 1 SAY "may disrupt other memory management, there-"
@ 4, 1 SAY "fore, you will be returned to DOS.  You can"
@ 5, 1 SAY "then restart the application."
@ 7,15 SAY "Please contact"
SELECT 0
USE callwhom
* ========================================
*$ Get info on appropriate person to call
* ========================================
LOCATE FOR ALLTRIM(callwhom->title) == "DEVELOPER"
STORE ALLTRIM(callwhom->call_who) TO m_call
STORE ALLTRIM(callwhom->other) TO m_title
STORE ALLTRIM(callwhom->phone) TO m_phone
@ 8, 0 SAY PADC(m->m_call, 45)
@ 9, 0 SAY PADC(m->m_title, 45)
@10, 0 SAY PADC(m->m_phone, 45)
@11, 5 SAY "immediately to report this problem."
@13, 1 SAY "Press any key to quit to DOS..." COLOR +N/W
DO razberry
= INKEY(0, "MH")
RELEASE WINDOW bugbox
CLEAR TYPEAHEAD
RETURN
*End procedure SQL_INTL


*!*********************************************************************
*!
*!      Procedure: SQL_IDX
*!
*!      Called by: PRO2EROR.PRG                      
*!
*!          Calls: ISLAN              (procedure in PRO2EROR.PRG)
*!               : RAZBERRY           (procedure in PRO2EROR.PRG)
*!               : YES_NO             (procedure in PRO2EROR.PRG)
*!
*!*********************************************************************
PROCEDURE sql_idx
***********************************************************************
*& Error #831 - SQL err building temporary index
*
*   The temporary index necessary to the SQL query
*   count not be built.  Possible causes are:
*
*   1.  Insufficient disk space on the local hard disk
*
*   2.  User may not have the necessary "rights"
*       on the LAN server
*
*   3.  Insufficient space in the LAN subdirectory
*
*   Because of the potential for insufficient disk
*   space no attempt is made to close databases or
*   save the error information except via hard copy.
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/16/91
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PARAMETERS doprint

IF islan()
   * ================================
   * Assumption is that a LAN printer
   * will always be available
   * ================================
   DEFINE WINDOW bugbox FROM 3,7 TO 20,73 DOUBLE ;
      COLOR N/W,N/W,R+*/W SHADOW
   ACTIVATE SCREEN
   ACTIVATE WINDOW bugbox
   @ 0,24 SAY "  BAD NEWS  " COLOR *+R/W
   @ 2, 1 SAY "Unable to build the temporary index " + ;
      "required for the SQL query."
   @ 3, 1 SAY "Possible causes may be:"
   @ 5, 4 SAY "a.  You have run out of disk " + ;
      "space on your local hard disk;"
   @ 7, 4 SAY "b.  You have run out of space " + ;
      "in the LAN subdirectory;"
   @ 9, 4 SAY "c.  You do not have the appropriate " + ;
      "user rights on the LAN"
   @11, 1 SAY "Information on the problem will " + ;
      "be sent to the printer.  Please"
   @12, 1 SAY "contact your LAN administrator " + ;
      "immediately and provide a copy"
   @13, 1 SAY "of the error information."
   @15, 1 SAY "Press any key to print and then " + ;
      "return to DOS..." COLOR +N/W
   DO razberry
   = INKEY(0, "MH")
   STORE .T. TO doprint
ELSE
   * ======================================
   *$ Otherwise provide info pertinent to
   *$ single user situation
   * ======================================
   DEFINE WINDOW bugbox FROM 7,13 TO 16,66 DOUBLE ;
      COLOR N/W,N/W,R+*/W SHADOW
   ACTIVATE SCREEN
   ACTIVATE WINDOW bugbox
   @ 0,15 SAY "  REALLY BAD NEWS  " COLOR *+R/W
   @ 2, 1 SAY "Unable to build the temporary index required for"
   @ 3, 1 SAY "the SQL query.  It is likely that you have run out"
   @ 4, 1 SAY "of disk space."
   DO razberry
   @ 6, 1 SAY "Do you have a printer available to print out error"
   @ 7, 1 SAY "information before returning to DOS?   (Y/N)"
   DO yes_no WITH doprint
   
   IF doprint
      DEFINE WINDOW makesure FROM 9,10 TO 12,70 "", ;
         "","","","","","","" ;
         COLOR W+*/N,N/W,W+*/N SHADOW
      ACTIVATE SCREEN
      ACTIVATE WINDOW makesure
      @ 0, 0 SAY REPLICATE("",59)
      @ 1, 0 SAY REPLICATE("",59)
      @ 0, 2 SAY "Please make sure your printer " + ;
         "is turned on and on-line."
      @ 1,12 SAY " Press any key to begin printing..."
      CLEAR TYPEAHEAD
      = INKEY(0, "MH")
      RELEASE WINDOW makesure
   ENDIF  (doprint)
ENDIF  (islan())

RELEASE WINDOW bugbox
CLEAR TYPEAHEAD
RETURN doprint
* End procedure SQL_IDX


*!*********************************************************************
*!
*!      Procedure: SQLTRASH
*!
*!      Called by: PRO2EROR.PRG                      
*!
*!          Calls: RAZBERRY           (procedure in PRO2EROR.PRG)
*!
*!           Uses: CALLWHOM.DBF       
*!
*!*********************************************************************
PROCEDURE sqltrash
***********************************************************************
*& Error #821 - SQL invalid temporary file
*
*   The temporary file created by FoxPro for the SQL
*   query has been corrupted.
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/16/91
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
DEFINE WINDOW bugbox FROM 5,18 TO 19,61 DOUBLE ;
   COLOR N/W,N/W,R+*/W SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox
@ 0,12 SAY "   S O R R Y   " COLOR *+R/W
@ 2, 1 SAY "The temporary file for the SQL query has"
@ 3, 1 SAY "been corrupted.  If this error recurs"
@ 4, 1 SAY "consistently please contact:"
SELECT 0
USE callwhom
* ========================================
*$ Get info on appropriate person to call
* ========================================
LOCATE FOR ALLTRIM(callwhom->title) == "DEVELOPER"
STORE ALLTRIM(callwhom->call_who) TO m_call
STORE ALLTRIM(callwhom->other) TO m_title
STORE ALLTRIM(callwhom->phone) TO m_phone
@ 6, 0 SAY PADC(m->m_call, 42)
@ 7, 0 SAY PADC(m->m_title, 42)
@ 8, 0 SAY PADC(m->m_phone, 42)
@10,10 SAY "to report the problem."
@12, 1 SAY "Press any key to return to Main Menu..." COLOR +N/W
DO razberry
= INKEY(0, "MH")
RELEASE WINDOW bugbox
CLEAR TYPEAHEAD
RETURN
* End procedure SQLTRASH


*!*********************************************************************
*!
*!      Procedure: NOSQLIDX
*!
*!      Called by: PRO2EROR.PRG                      
*!
*!          Calls: RAZBERRY           (procedure in PRO2EROR.PRG)
*!
*!           Uses: CALLWHOM.DBF       
*!
*!*********************************************************************
PROCEDURE nosqlidx
***********************************************************************
*& Error #830 - SQL index not found
*
*   This may be the result of an incorrect PATH setting
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/16/91
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
DEFINE WINDOW bugbox FROM 5,23 TO 19,56 DOUBLE ;
   COLOR N/W,N/W,R+*/W SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox
@ 0, 7 SAY "   S O R R Y   " COLOR *+R/W
@ 2, 1 SAY "Not able to find the SQL index"
@ 3, 1 SAY "required for this query."
@ 5, 9 SAY "Please contact"
SELECT 0
USE callwhom
* ========================================
*$ Get info on appropriate person to call
* ========================================
LOCATE FOR ALLTRIM(callwhom->title) == "DEVELOPER"
STORE ALLTRIM(callwhom->call_who) TO m_call
STORE ALLTRIM(callwhom->other) TO m_title
STORE ALLTRIM(callwhom->phone) TO m_phone
* ===========================================
* NOTE: Size of window may have to be enlarged
* if trimmed data in CALLWHOM is longer than
* the BUGBOX window
* ===========================================
@ 6, 0 SAY PADC(m->m_call, 32)
@ 7, 0 SAY PADC(m->m_title, 32)
@ 8, 0 SAY PADC(m->m_phone, 32)
@ 9, 5 SAY "to report the problem."
@11, 1 SAY "Press any key to" COLOR +N/W
@12, 1 SAY "return to Main Menu..." COLOR +N/W
DO razberry
= INKEY(o, "MH")
RELEASE WINDOW bugbox
CLEAR TYPEAHEAD
RETURN
* End procedure NOSQLIDX



*!*********************************************************************
*!
*!      Procedure: SQLABORT
*!
*!      Called by: PRO2EROR.PRG                      
*!
*!          Calls: RAZBERRY           (procedure in PRO2EROR.PRG)
*!               : YES_NO             (procedure in PRO2EROR.PRG)
*!
*!*********************************************************************
PROCEDURE sqlabort
***********************************************************************
*& Error #839 - SQL canceled operation
*
*   User pressed ESC key.  Determine if user
*   really wants to abort the query.
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/16/91
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PARAMETERS a_bort
DEFINE WINDOW bugbox FROM 10,19 TO 13,60 DOUBLE ;
   COLOR N/W,N/W,R+*/W SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox
@ 0, 1 SAY "You pressed the ESCape key.  Do you"
@ 1, 1 SAY "really want to cancel the query? (Y/N)"
DO razberry
DO yes_no WITH a_bort
RELEASE WINDOW bugbox
RETURN a_bort
* End procedure SQLABORT



*!*********************************************************************
*!
*!      Procedure: BADCLOSE
*!
*!      Called by: PRO2EROR.PRG                      
*!
*!          Calls: ISLAN              (procedure in PRO2EROR.PRG)
*!               : RAZBERRY           (procedure in PRO2EROR.PRG)
*!               : YES_NO             (procedure in PRO2EROR.PRG)
*!
*!           Uses: CALLWHOM.DBF       
*!
*!*********************************************************************
PROCEDURE badclose
***********************************************************************
*& Error #1112 - File close error
*
*   It may be that the operating system just
*   "hiccuped" or there may be a hardware problem.
*   Advise user & provide option to retry.
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/16/91
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PARAMETERS re_try
DEFINE WINDOW bugbox FROM 4,16 TO 20,67 DOUBLE ;
   COLOR N/W,N/W,R+*/W SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox
@ 0,15 SAY "   W H O O P S   " COLOR *+R/W
@ 2, 1 SAY "A problem occurred while attempting to close a"
@ 3, 1 SAY "file.  It may be that the system just didn't get"
@ 4, 1 SAY "it's coffee and was temporarily feeling grumpy."
@ 5, 1 SAY "If so, trying again will correct the problem."
@ 6, 1 SAY "However, if this message continually appears it"
@ 7, 1 SAY "may be that there is a hardware problem. In that"
@ 8, 1 SAY "case please contact:"
SELECT 0
USE callwhom
* ========================================
*$ Get info on appropriate person to call
* ========================================
IF islan()
   LOCATE FOR ALLTRIM(callwhom->title) == "LAN ADMINISTRATOR"
ELSE
   LOCATE FOR ALLTRIM(callwhom->title) == "APP ADMINISTRATOR"
ENDIF  (islan())

STORE ALLTRIM(callwhom->call_who) TO m_call
STORE ALLTRIM(callwhom->other) TO m_title
STORE ALLTRIM(callwhom->phone) TO m_phone
@ 9, 0 SAY PADC(m->m_call, 50)
@10, 0 SAY PADC(m->m_title, 50)
@11, 0 SAY PADC(m->m_phone, 50)
@12,14 SAY "to report the problem."
DO razberry
@14, 9 SAY "DO YOU WANT TO TRY AGAIN?  (Y/N)"
DO yes_no WITH re_try
RELEASE WINDOW bugbox
RETURN re_try
* End procedure BADCLOSE


*!*********************************************************************
*!
*!      Procedure: VERBOSE
*!
*!      Called by: PRO2EROR.PRG                      
*!
*!          Calls: RAZBERRY           (procedure in PRO2EROR.PRG)
*!               : YES_NO             (procedure in PRO2EROR.PRG)
*!
*!*********************************************************************
PROCEDURE verbose
***********************************************************************
*$ Error #1201 - Too many names used
*
*   The FoxPro NAME TABLE "collects" the "names" used for
*   memory variables, arrays, data base files and indexes,
*   field names, procedures, etc. as they are used.  If
*   this table is exhausted the only thing that can be done
*   on an immediate basis is to return the user to DOS and
*   then restart the application.
*
*   The developer should modify the code so that memory
*   variable names, array names, window names, etc. are not
*   all unique but, rather, are used frequently in various
*   modules.  Simply use the PRIVATE statement to make sure
*   memvars and arrays do not conflict with others in use with
*   the same name at higher levels.
*
*   An example of this is the name BUGBOX used repeatedly
*   for message windows opened by PRO2EROR.
*
*   Do not create procedures of the same name, however.
*
*   Because the name table is exhausted, it may not be
*   possible to open the CALLWHOM and PRO2EROR databases.
*   Therefore, the developer's name must be hard coded
*   in this module.
*
*
*$ Error #1308 - Stack overflow - expression too complex
*
*   Usually occurs because UDF's are nested too deeply.
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/16/91
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
PARAMETERS doprint
DEFINE WINDOW bugbox FROM 5,10 TO 19,70 DOUBLE ;
   COLOR N/W,N/W,R+*/W SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox
@ 0,19 SAY "   W H O O P S   " COLOR *+R/W
@ 2, 1 SAY "A problem has occurred that can be cured temporarily by"
@ 3, 1 SAY "returning to DOS and starting this application over again."
@ 5,13 SAY "It is important that you contact"
* @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
* NOTE: Developer's name is hard coded here for reasons stated
* above and must be changed to the appropriate name & phone #
* @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
@ 6, 0 SAY PADC("Developer Name", 58)
@ 7, 0 SAY PADC("Company Name/Title", 58)
@ 8, 0 SAY PADC("Phone Number", 58)
@ 9,18 SAY "to report the problem."
DO razberry
@11,12 SAY "DO YOU HAVE A PRINTER AVAILABLE TO"
@12,12 SAY "PRINT THE ERROR INFORMATION? (Y/N)"
DO yes_no WITH doprint

IF doprint
   DEFINE WINDOW makesure FROM 9,10 TO 12,70 "", ;
      "","","","","","","" ;
      COLOR W+*/N,N/W,W+*/N SHADOW
   ACTIVATE SCREEN
   ACTIVATE WINDOW makesure
   @ 0, 0 SAY REPLICATE("",59)
   @ 1, 0 SAY REPLICATE("",59)
   @ 0, 2 SAY "Please make sure your printer " + ;
      "is turned on and on-line."
   @ 1,12 SAY " Press any key to begin printing..."
   = INKEY(0, "MH")
   CLEAR TYPEAHEAD
   RELEASE WINDOW makesure
ENDIF  (doprint)

RELEASE WINDOW bugbox
RETURN doprint
* End procedure VERBOSE


*!*********************************************************************
*!
*!      Procedure: NORUN
*!
*!      Called by: PRO2EROR.PRG                      
*!
*!          Calls: RAZBERRY           (procedure in PRO2EROR.PRG)
*!
*!           Uses: CALLWHOM.DBF       
*!
*!*********************************************************************
PROCEDURE norun
***********************************************************************
*& Error #1405 - RUN/! command failed
*
*   Either there is insufficient free memory to execute the
*   program to be run from DOS or COMMAND.COM can not be found.
*   In the latter case make sure that the DOS COMMAND.COM is
*   accessible via the DOS environmental COMSPEC=
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/16/91
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
DEFINE WINDOW bugbox FROM 4,12 TO 20,67 DOUBLE ;
   COLOR N/W,N/W,R+*/W SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox
@ 0,18 SAY "   S O R R Y   " COLOR *+R/W
@ 2, 1 SAY "It was not possible to run a DOS program because:"
@ 4, 2 SAY "a.  Your computer does not have sufficient memory;"
@ 6, 2 SAY "b.  The DOS COMMAND.COM program could not be found."
@ 8,20 SAY "Please contact"
SELECT 0
USE callwhom
* ========================================
*$ Get info on appropriate person to call
* ========================================
LOCATE FOR ALLTRIM(callwhom->title) == "DEVELOPER"
STORE ALLTRIM(callwhom->call_who) TO m_call
STORE ALLTRIM(callwhom->other) TO m_title
STORE ALLTRIM(callwhom->phone) TO m_phone
@ 9, 0 SAY PADC(m->m_call, 54)
@10, 0 SAY PADC(m->m_title, 54)
@11, 0 SAY PADC(m->m_phone, 54)
@12,16 SAY "to report this problem."
DO razberry
@14, 1 SAY "Press any key to return to Main Menu..." COLOR +N/W
= INKEY(0, "MH")
RELEASE WINDOW bugbox
CLEAR TYPEAHEAD
RETURN
* End procedure NORUN


*!*********************************************************************
*!
*!      Procedure: BADCHAIN
*!
*!      Called by: PRO2EROR.PRG                      
*!
*!          Calls: RAZBERRY           (procedure in PRO2EROR.PRG)
*!
*!           Uses: CALLWHOM.DBF       
*!
*!*********************************************************************
PROCEDURE badchain
***********************************************************************
*& Error #1012 - OS memory error
*
*   The DOS free memory chain has been scrambled.
*   The immediate solution is to return to DOS and
*   restart the application.
*
*   If the problem persists and/or is not cured by a
*   reboot the developer should look to the EMS memory
*   manager as the probable culprit.
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/16/91
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
DEFINE WINDOW bugbox FROM 5,14 TO 19,66 DOUBLE ;
   COLOR N/W,N/W,R*/W SHADOW
ACTIVATE SCREEN
ACTIVATE WINDOW bugbox
@ 0,15 SAY "   W H O O P S   " COLOR *+R/W
@ 2, 1 SAY "Something has scrambled your computer's memory."
@ 3, 1 SAY "You will be returned to DOS and can restart the"
@ 4, 1 SAY "application.  If the problem persists try turning"
@ 5, 1 SAY "off the computer and starting it again.  If the"
@ 6, 1 SAY "problem still persists contact:"
SELECT 0
USE callwhom
* ========================================
*$ Get info on appropriate person to call
* ========================================
LOCATE FOR ALLTRIM(callwhom->title) == "DEVELOPER"
STORE ALLTRIM(callwhom->call_who) TO m_call
STORE ALLTRIM(callwhom->other) TO m_title
STORE ALLTRIM(callwhom->phone) TO m_phone
@ 8, 0 SAY PADC(m->m_call, 50)
@ 9, 0 SAY PADC(m->m_title, 50)
@10, 0 SAY PADC(m->m_phone, 50)
DO razberry
@12, 1 SAY "Press any key to return to DOS..." COLOR +N/W
RELEASE WINDOW bugbox
CLEAR TYPEAHEAD
RETURN
* End procedure BADCHAIN



*!*********************************************************************
*!
*!      Procedure: KANCEL
*!
*!      Called by: LOGVIEW            (procedure in PRO2EROR.PRG)
*!
*!*********************************************************************
PROCEDURE kancel
***********************************************************************
*& Cancel program and return to command window
*
*   Author: Pat Adams  (718) 469-4032
*   Date: 8/22/91
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
ON KEY           && Null out hot keys
CLEAR GETS
CLEAR READ ALL
CLEAR FIELDS
CLEAR MACROS
CLEAR WINDOWS
DEACTIVATE MENUS
CLEAR MENUS
DEACTIVATE POPUPS
CLEAR POPUPS
CLEAR PROMPT
SET REFRESH TO 0
SET DEVICE TO SCREEN
CLOSE DATA
* ================================================
* NOTE: Turn on/off the CLOSE PROCEDURE statement
* to suit your particular application
* ================================================
*CLOSE PROCEDURE
CLEAR MEMORY
PUBLIC testing
STORE .T. TO testing
CANCEL
* End procedure KANCEL
*: EOF: PRO2EROR.PRG
