; Program:Search.asm  Source for dBASE IV type .bin file that uses DOS'
;                     find first and find next functions for getting info
;                     about files matching a wildcard specification and
;                     possibly an attribute mask.  Can be called with up to
;                     six parameters, or at least two.  The first parameter
;                     is necessary to indicate the search mode; either to
;                     find the first file (indicated by a 1) or to find
;                     subsequent files (indicated by anything other than a 1).
;                     The second parameter is a filename or wild card string.
;
;                     parameter 1: Call type (1 for first call).
;                     parameter 2: Wildcard specification.
;                     parameter 3: Attribute mask.      (Optional)
;                     parameter 4: Receives file date.
;                     parameter 5: Receives file time.
;                     parameter 6: Receives file size.
;
;  Example:     . LOAD Search
;               . ? CALL("Search",1,"*.dbf       ")     && Two parms.
;                        0
;
;               . fspec = "SQLHOME\*.* "
;               . fattr = "D     "              && Include directories!
;               . fdate = "  /  /  "            && Avoid bug.
;               . ftime = "  :  :  "
;               . fsize = 0
;               . CALL Search WITH 1,fspec,fattr,fdate,ftime,fsize
;               . ? fspec,fsize
;               SQLDBASE.STR        194
;
; Possible directory entry attributes.

        RO      =       00000001b
        HID     =       00000010b
        SYS     =       00000100b
        VOL     =       00001000b
        DIR     =       00010000b
        ARCH    =       00100000b

dgroup  group   code

code    segment byte
        assume  cs:code,ds:dgroup
search  proc    far
        mov     ax,cs                           ; Assert local data segment.
        mov     ds,ax
        mov     word ptr [argc],cx              ; Save parameter count.
        cmp     cx,2                            ; Were at least two parameters sent?
        jge     enough
        mov     ax,-94                          ; Return "Wrong number of parameters".
        jmp     done
enough:
        call    getdta                          ; Save DTA locally.
        lea     dx,mydta
        mov     ah,1ah                          ; Set local DTA.
        int     21h                             ; Call DOS.
        lds     si,es:[di]                      ; Address first parameter.
        call    atoi
        cmp     ax,1                            ; Call for "find first"?
        mov     ah,4fh                          ; Assume "find next".
        jne     nextfile
        xor     cx,cx
        cmp     word ptr cs:[argc],3            ; Was an attribute mask specified?
        jl      nomask
        lds     si,es:[di + 8]
        call    getmask
nomask:
        lds     dx,es:[di + 4]                  ; Point to wildcard.
        mov     ah,4eh                          ; Finding first.
nextfile:
        int     21h                             ; Make DOS request.
        push    ax                              ; Save return value...
        pushf                                   ; and flags
        mov     ax,cs                           ; Reassert data segment.
        mov     ds,ax
        call    resetDTA                        ; Restore dBASE' orginal DTA.
        popf
        pop     ax
        jc      done                            ; Carry set indicates error.

        cmp     word ptr [argc],2               ; Filename sent, at least?
        jb      result
        push    es
        push    di
        les     di,es:[di + 4]
        lea     si,fname
        call    strcpy                          ; Return file found to dBASE.
        pop     di
        pop     es

        cmp     word ptr [argc],3               ; Attribute string sent?
        jb      result
        push    es
        push    di
        les     di,es:[di + 8]
        call    maskcpy                         ; Attributes to dBASE.
        pop     di
        pop     es

        cmp     word ptr [argc],4               ; Date parameter sent?
        jb      result
        push    es
        push    di
        les     di,es:[di + 12]
        call    datecpy                         ; Return file date to dBASE.
        pop     di
        pop     es

        cmp     word ptr [argc],5               ; Time parameter sent?
        jb      result
        push    es
        push    di
        les     di,es:[di + 16]
        call    timecpy                         ; Return file time.
        pop     di
        pop     es

        cmp     word ptr [argc],6               ; Parameter for file size?
        jb      result
        mov     ax,[fsize]
        mov     dx,[fsize + 2]
        push    es
        push    di
        les     di,es:[di + 20]
        call    ltoa                            ; Return it.
        pop     di
        pop     es
result:
        xor     ax,ax                           ; A - O.K. Return "no error".
done:
        cmp     word ptr [argc],1               ; Call type specified?
        jb      exit
        les     di,es:[di]
        cwd
        call    ltoa                            ; CALL() return value.
exit:
        ret                                     ; Back to dBASE we go!
search  endp

getdta  proc    near
        push    es
        mov     ah,2fh                          ; Get address of current DTA.
        int     21h                             ; Call DOS.
        mov     word ptr [olddta],bx
        mov     word ptr [olddta + 2],es
        pop     es
        ret
getdta  endp

resetDTA proc   near
        push    ds
        mov     dx,word ptr [olddta]            ; Reset original DTA.
        mov     ds,word ptr [olddta + 2]
        mov     ah,1ah
        int     21h                     ; Call DOS.
        pop     ds
        ret
resetDTA endp

;
;       Atoi: Converts a dBASE parameter to a signed integer (16-bit) 
;                value with the result left in the AX register. Conversion of
;                the dBASE parameter continues until the first non-numeric
;                character is found.
;
;       Expects: DS:SI -> dBASE parameter string.
;
atoi    proc    near
        push    di                             ; Save parameter address offset.
        xor     ax,ax                          ; AX and BX are working accumulators.
        mov     bx,ax
        mov     cx,10                          ; The divisor, ten.
        mov     di,ax                          ; Sign flag, assume positive.
        cld                                    ; Move forward.
skipwhite:
        lodsb
        cmp     al,' '                          ; Skip leading spaces.
        je      skipwhite
skipzero:
        cmp     al,'0'                          ; Skip leading zeros.
        jne     chksign
        lodsb
        jmp     skipzero
chksign:
        cmp     al,'+'                          ; Positive? (Not a likely character.)
        je      next
        cmp     al,'-'                          ; Negative?
        jne     digits
        inc     di                                      ; Flag it.
next:
        lodsb
digits:
        cmp     al,'0'                          ; Check for valid digits.
        jb      atoidone                                ; Leave if nonnumeric.
        cmp     al,'9'
        ja      atoidone                                ; Ditto.
        sub     al,'0'
        cbw                                             ; Zero out high byte.
        xchg    ax,bx
        imul    cx                                      ; Multiply by ten to shift place value.
        add     bx,ax
        lodsb
        jmp     digits
atoidone:
        mov     ax,bx
        or      di,di                           ; DI holds sign flag.
        jz      atoiexit
        neg     ax                                      ; Change sign.
atoiexit:
        pop     di                                      ; Restore this.
        ret
atoi    endp

;
;       Getmask: Convert character string representing desired search 
;                attribute to true numeric value.  Result is left in AX.
;
;       Expects: DS:SI -> Attribute string.
;
getmask proc    near
        xor     cx,cx
        cld
		jmp     short getchar
chkchar:
        and     al,11011111b                    ; Capitalize.
        cmp     al,'R'                          ; Check for read only.
        jne     hidden
        or      cx,RO
		jmp     short getchar
hidden: 
        cmp     al,'H'                          ; Hidden?
        jne     system
        or      cx,HID
		jmp     short getchar
system:
        cmp     al,'S'                          ; System?
        jne     volume
        or      cx,SYS
		jmp     short getchar
volume:
        cmp     al,'V'                          ; Volume label?
        jne     directory
        or      cx,VOL
		jmp     short getchar
directory:
        cmp     al,'D'                          ; Directory?
        jne     archive
        or      cx,DIR
		jmp     short getchar
archive:
        cmp     al,'A'                          ; Archive?
        jne     getchar
        or      cx,ARCH
getchar:
        lodsb
        or      al,al
        jnz     chkchar
        ret
getmask endp

;
;       Maskcpy: Convert file attribute to null terminated character string.
;
;       Expects: ES:DI -> dBASE parameter string.
;
maskcpy proc    near
        cmp     byte ptr es:[di],0              ; At end of string?
        je      mcexit
        mov     ah,byte ptr [attr]

        test    ah,RO                                   ; Read only?
        jz      chkHID
        mov     byte ptr es:[di],'R'
        inc     di
        cmp     byte ptr es:[di],0
        je      mcexit
chkHID:
        test    ah,HID                                  ; Hidden?
        jz      chkSYS
        mov     byte ptr es:[di],'H'
        inc     di
        cmp     byte ptr es:[di],0
        je      mcexit
chkSYS:
        test    ah,SYS                                  ; System?
        jz      chkVOL
        mov     byte ptr es:[di],'S'
        inc     di
        cmp     byte ptr es:[di],0
        je      mcexit
chkVOL:
        test    ah,VOL                                  ; Volume label?
        jz      chkDIR
        mov     byte ptr es:[di],'V'
        inc     di
        cmp     byte ptr es:[di],0
        je      mcexit
chkDIR:
        test    ah,DIR                                  ; Directory?
        jz      chkARCH
        mov     byte ptr es:[di],'D'
        inc     di
        cmp     byte ptr es:[di],0
        je      mcexit
chkARCH:
        test    ah,ARCH                                 ; Archive?
        jz      fill
        mov     byte ptr es:[di],'A'
        inc     di
        cmp     byte ptr es:[di],0
        je      mcexit
fill:
        mov     al,' '                                  ; Empty rest of string.
        call    strset
mcexit:
        ret
maskcpy endp

;
;       Datecpy: Translates and copies a DOS format date word to a dBASE
;                type time string.
;
;       Expects: ES:DI -> dBASE parameter string.
;
datecpy proc    near
        mov     ax,[date]
        mov     cl,5
        and     ax,1e0h                                 ; Mask off day and year.
        shr     ax,cl                                   ; Normalize.
        aam
        xchg    ah,al
        add     ax,3030h
        stosw
        mov     byte ptr es:[di],'/'            ; Copy date separator.
        inc     di
        mov     ax,[date]
        and     ax,1fh                                  ; Mask off month and year.
        aam
        xchg    ah,al
        add     ax,3030h
        stosw
        mov     byte ptr es:[di],'/'            ; Once again.
        inc     di
        mov     ax,[date]
        and     ax,0fe00h                               ; Mask off month and day.
        mov     cl,9
        shr     ax,cl
        add     ax,80
        cmp     ax,100                                  ; Using only two digit year.
        jl      century
        sub     ax,100
century:
        aam
        xchg    ah,al
        add     ax,3030h
        stosw
        ret
datecpy endp

;
;       Timecpy: Translates and copies a DOS format time word to a dBASE
;                type time string.
;
;       Expects: ES:DI -> dBASE parameter string.
;
timecpy proc    near
        mov     ax,[time]
        mov     cl,11
        and     ax,0f800h                                       ; Mask off minutes and seconds.
        shr     ax,cl
        aam
        xchg    ah,al
        add     ax,3030h
        stosw
        mov     byte ptr es:[di],':'                    ; Time separator.
        inc     di
        mov     ax,[time]
        mov     cl,5
        and     ax,07e0h                                ; Mask off hours and seconds.
        shr     ax,cl
        aam
        xchg    ah,al
        add     ax,3030h
        stosw
        mov     byte ptr es:[di],':'                    ; Copy second separator.
        inc     di
        mov     ax,[time]
        and     ax,1fh                                          ; Mask off hours and minutes.
        shl     ax,1
        aam
        xchg    ah,al
        add     ax,3030h
        stosw
        ret
timecpy endp

;
;       Ltoa: Converts a signed long integer (32-bit) value to a null
;                terminated string (dBASE parameter), padding unused characters
;                with spaces.  If the dBASE parameter is not large enough to
;                represent the value, the parameter is filled with asterisks
;                ('*') to represent overflow.
;
;       Calls:   Strset
;
;       Expects: ES:DI -> dBASE parameter string.
;
ltoa    proc    near
        cmp     byte ptr es:[di],0              ; At end of dBASE parameter?
        je      ltoaexit
        mov     bp,di                                   ; Save the parameter offset.
        xor     si,si                                   ; Assume non-negative or ".F."
        push    ax                                              ; Save the low word.
        mov     al,' '                                  ; Fill with spaces and move past end.
        call    strset
        pop     ax                                              ; Restore our low word.
        mov     cx,10                                   ; The divisor.
        or      dx,dx                                   ; Negative number?
        jge     positive
        inc     si                                              ; SI now holds ".T."
        not     dx                                              ; Make positive.
        neg     ax
        sbb     dx,-1
positive:
        dec     di                                              ; Move to previous char.
        mov     bx,ax
        mov     ax,dx
        xor     dx,dx
        div     cx
        xchg    bx,ax
        div     cx
        xchg    dx,bx   
        add     bl,'0'                                  ; Make character.
        mov     byte ptr es:[di],bl             ; Store the digit.
        cmp     di,bp                                   ; Are we at the front of the parameter?
        je      atfront
        or      ax,ax                                   ; Anything left to work with?
        jnz     positive
        or      si,si                                   ; Was the number negative?
        jz      ltoaexit
        dec     di                                              ; Step back once again.
        mov     byte ptr es:[di],'-'            ; Put in our minus sign.
		jmp     short ltoaexit
atfront:
        or      dx,dx                                   ; Still have stuff to write?
        jnz     oflow
        or      ax,ax
        jnz     oflow
        or      si,si                                   ; Do we need to write a negative sign?
        jnz     oflow
		jmp     short ltoaexit
oflow:
        mov     di,bp                                   ; Start back at the beginning.
        mov     al,'*'                                  ; Fill with overflow character.
        call    strset
ltoaexit:
        ret
ltoa    endp

;
;       Strcpy:  Copies a null terminated string to a dBASE parameter,

;                                padding unused characters with spaces.
;
;       Calls:   Strset
;
;       Expects: ES:DI -> dBASE parameter string.
;
strcpy  proc    near
        cld                                                     ; Move forward, just in case.
getch:
        lodsb                                           ; Get next character.
        or      al,al                                   ; End of source string?
        jz      sourceend
        cmp     byte ptr es:[di],0              ; End of dBASE parameter?
        je      scexit
        stosb                                           ; Copy the character.
        jmp     getch
sourceend:
        mov     al,' '                                  ; Fill with spaces.
        call    strset
scexit:
        ret
strcpy  endp

;
;       Strset:  Fills a null terminated string with  specified character.
;
;       Expects: ES:DI > String to be filled.
;                AL        Contains character to fill.
;
strset  proc    near
        cld
		jmp     short chknull                                 ; Let's check for a null first.
putch:
        stosb                                           ; Put it where it belongs.
chknull:
        cmp     byte ptr es:[di],0              ; Have we reached the end?
        jne     putch
        ret
strset  endp

argc    dw      0
olddta  dw      0,0

mydta   db      21 dup (0)
attr    db      0
time    dw      0
date    dw      0
fsize   dw      0,0
fname   db      13 dup (0)

code    ends
        end     search

