* PopToIt.PRG -- Relocate cursor to last bar selected in a PROMPT FIELD popup.
*       From:  John Greer (ATBBS: Augustine)   (213) 973-3656

*       Note:  Thank you, Jay Parsons, for your KeyBd.BIN utility.

* Require files:  PopToIt.PRG  -- This program.
*                 Pop_Data.DBF -- Data for the popup.
*                 KeyBd.BIN    -- Keyboard buffer stuffing module.

  SET TALK OFF
	SET MESSAGE TO "Highlight a bar, then press Enter.  (Esc to exit.)"

  PUBLIC     top_coord
  STORE 1 TO top_coord

  PUBLIC      end_coord
  STORE 12 TO end_coord

  PUBLIC                 row_offset
  STORE top_coord + 1 TO row_offset

  PUBLIC                               len_page
  STORE (end_coord - top_coord) - 1 TO len_page

  LOAD keybd
  SET TYPEAHEAD TO 128  && ********** Don't miss this! *************	
	
  SET BORDER TO SINGLE
  DEFINE POPUP pop_up FROM top_coord,1 TO end_coord,8 PROMPT FIELD pop_field
  ON SELECTION POPUP pop_up DO sub_routine

  USE pop_data
  ACTIVATE POPUP pop_up
  USE

  SET TYPEAHEAD TO 20
  RELEASE MODULE keybd
	SET MESSAGE TO
  SET TALK ON
 RETURN
 
PROCEDURE sub_routine
  PRIVATE    end_bar,pages,lines,retro
  STORE 0 TO end_bar,pages,lines,retro

  end_bar = BAR() - ROW() + row_offset + (len_page - 1)

  IF end_bar = len_page
    pages = 0
    lines = BAR() - 1
    retro = 0
  ELSE
    pages = INT(end_bar / len_page)
    lines = MOD(end_bar,len_page)
    retro = end_bar - BAR()
  ENDIF

  DO WHILE pages + lines + retro > 126
    DO CASE
      CASE retro > 0
         retro = retro - 1
      CASE lines > 0
        lines = lines - 1
      CASE pages > 0
        pages = pages - 1
    ENDCASE
  ENDDO

****************** Your routine should be inserted here. *******************

* Stuff typeahead buffer with Home + PageDn's + DownArrow's + UpArrow's. 
* Note:  Home avoids a possible empty key buffer.
  CALL keybd WITH CHR(26) + REPLICATE(CHR( 3),pages) ;
                          + REPLICATE(CHR(24),lines) ;
                          + REPLICATE(CHR( 5),retro)
 RETURN
