*-- Author  : Richard H. Price  
*-- ATBBS ID: HAMMETT
*-- Modified: 04/18/91
*-- CI$ ID  : 71157,762
*-- Procedure Library for dBASE IV ver 1.1 pick lists

FUNCTION PickFunc
   PARAMETER ll_Force
   ON KEY LABEL F3 ?? chr(7)
   PRIVATE lv_DataChk, ll_Valid, lc_Varread,;
           lc_Alias, lc_dbf, lc_Order, lc_KeyFld, ;
           ll_Kill, ll_Ck4Open
   STORE .f. to ll_Valid, ll_Kill, ll_Ck4Open
   lc_Varread=VARREAD()
   lc_Alias=ALIAS()
   lv_DataChk = &lc_Varread
   lc_dbf = lc_Alias
   lc_Order = ORDER()
   lc_KeyFld = lc_Varread
   DO PickCase WITH "ENVIRONMENT"
   IF .NOT. ll_Kill .AND. ll_Ck4Open
      ll_Kill = .NOT. CK4OPEN(lc_dbf)
   ENDIF
   IF .NOT. ll_Kill
      SELECT (lc_dbf)
      IF ""=lc_Order
         ** Procedure PickTag will choose 
         ** the logically first mdx tag for you.
         DO PickTag
      ENDIF
      SET ORDER TO (lc_Order)
   ENDIF
   ll_Valid = IIF(ll_Kill,.t.,SEEK(lv_DataChk))
   SELECT (lc_Alias)
   DO CASE
      CASE ll_Valid .and. ll_Force
         DO Pickcase WITH "COMMANDS"
      CASE .NOT. ll_Valid
         ?? CHR(7)
         DO PickList
         KEYBOARD chr(26) + IIF(ll_Force," ","") + ;
            IIF(ll_Valid, CHR(26) +CHR(25) +lv_DataChk, "");
            CLEAR
         ll_Valid = .F.
   ENDCASE
   ON KEY LABEL F3 DO PickList
RETURN IIF(ll_Force,ll_Valid,.t.)

FUNCTION CK4OPEN
   PARAMETER lc_CKDBF
   PRIVATE lc_CK4DBF, ln_X, ln_LEN, ll_RETVAL, lc_EXACT
   ll_RetVal = (""#lc_CKDBF)
   IF ll_RetVal
      lc_CK4DBF = lc_CKDBF + ".dbf"
      lc_EXACT = SET("EXACT")
      SET EXACT ON
      lc_CK4DBF = IIF(SET("FULLPATH") = "ON", "\", "") ;
         + lc_CK4DBF
      LN_LEN=LEN(lc_CK4DBF)
      ln_X = 0
      ll_RETVAL = .F.
      DO WHILE ln_X < 10 .AND. .NOT. ll_RETVAL
         X = X + 1
         ll_RETVAL = ;
         (UPPER(lc_CK4DBF) = UPPER(RIGHT(DBF(X), LN_LEN)))
      ENDDO
      SET EXACT &lc_EXACT.
      IF .NOT. ll_RetVal .AND. SELECT()#0
         ll_RetVal = .t.
         USE (lc_CKDBF) IN SELECT()
      ENDIF
   ENDIF
RETURN ll_RetVal

PROCEDURE PickList
   ON KEY LABEL F3 ?? CHR(7)
   PRIVATE ll_PopPick, ll_BrowKey, ll_Browse, ll_Popup, ;
      lc_ListArg, lc_Border, lc_Title, ln_TLRow, ln_TLCol,;
      ln_Width, ln_Scroll, ll_Compres, ll_Shadow,lc_AltSep,;
      lc_AltTop, lc_AltBot, ll_Kill, ll_Ck4Open, ll_ErrChk,;
      lc_Format1, lc_Format2, ll_ChkPop, ll_BroSeek, ;
      lc_ActWind
   PRIVATE lc_SeekClr,lc_ShadClr,;
      lc_NormClr,lc_HighClr,lc_MessClr,lc_TitlClr,;
      lc_BoxClr,lc_InfClr,lc_FldClr,;
      lc_ClrNorm,lc_ClrHigh,lc_ClrMess,lc_ClrTitl,;
      lc_ClrBox,lc_ClrInf,lc_ClrFld
   STORE .f. to ll_Kill 
   STORE "" to lc_PikList, lc_Format1, lc_Format2
   ll_IsFunc = (TYPE("LV_DATACHK")#"U")
   IF .NOT. ll_IsFunc
      ** If PickList was called via ON KEY initialize 
      ** critical memvars & set up the work area.
      PRIVATE ll_Valid, ll_IsFunc, lc_Varread, lc_Alias,;
         lc_dbf, lc_Order, lc_KeyFld, lv_DataChk
      STORE "" to lv_DataChk, lc_Varread, lc_Alias,;
         lc_dbf, lc_Order, lc_KeyFld
      ll_Valid  = .f.
      ll_Ck4Open= .f.
      lc_Varread=VARREAD()
      lc_Alias  = ALIAS()
      lc_dbf    = lc_Alias
      lv_DataChk= &lc_Varread
      lc_Order  = ORDER()
      lc_KeyFld = lc_Varread
      ll_Kill   = .f.      && Set .t. to kill 
                           && additional processing
      ll_Ck4Open= .f.      && Set .t. to verify
                           && that the named alias and
                           && index are found in an 
                           && open work area.
      DO PickCase WITH "ENVIRONMENT"
      IF .NOT. ll_Kill .AND. ll_Ck4Open
         ll_Kill = .NOT. CK4OPEN(lc_dbf)
      ENDIF
   ENDIF
   IF .NOT. ll_Kill
      SELECT (lc_dbf)
      SET ORDER TO (lc_Order)
      **********************************************
      **  Provide default pick list parameters.   **
      **********************************************
      **  NOTE: All of the following may be       **
      **        changed within procedure PickCase **
      **        for custom pick lists.            **
      **********************************************
      ** MUST INITIALIZE here! (changes allowed)  **
      **********************************************
      **  Default Colors
      lc_NormClr= "W+/R"   && NORMAL (Text in windows) 
      lc_HighClr= "N/W"    && HIGHLIGHT (Selection bar) 
      lc_MessClr= "BG+/B"  && MESSAGE  
      lc_TitlClr= "RG+/R"  && TITLE  
      lc_BoxClr = "W+/R"   && BOX 
      lc_InfClr = "W+/R"   && INFORMATION 
      lc_FldClr = "W+/b"   && FIELD 
      lc_SeekClr= "G+/N"   && Keyed highlight (PopPick6) 
      lc_ShadClr= "W/N"    && Shadow color (PopPick6) 
      ** Default Pick List Controls
      lc_PikList="PP"      && Default Pick List
                           && Options: "PP" - PopPick6
                           &&          "BR" - BROWSE
                           &&          "PU" - POPUP
      ln_TLRow  = 6        && Top Row
      ln_TLCol  = 30       && Left Column
      ln_Width  = 74       && Width of window
      ln_Scroll = 10       && Lines to scroll
      ll_Compres= .f.      && .t.= Titles as part of frame
      lc_ExpType= "CE"     && Type of exploding window
                           && "" to disable
      ln_Speed  =  6       && Exploding window's speed 
      ll_Clear  = .t.      && Clear under exploding window
      ln_RowOff =  1       && Row offset for shadows
      ln_ColOff =  2       && Column offset for shadows
      ll_Shadow = .t.      && .t./.f. = shadow/no_shadow
      lc_Border = "DOUBLE" && Pick List border definition
                           && "DOUBLE" "SINGLE" "PANEL"
      lc_Title  = ""       && Title
      ** These may be specified in PickCase to
      ** enhance pick list appearance
      lc_AltTop = ""       && Alternate Frame Top
      lc_AltSep = ""       && Alternate Title Separator
      lc_AltBot = ""       && Alternate Frame Bottom
      lc_ListArg= ""       && Pick List Argument
                           && (Fields and/or expressions)
      lc_Format1= ""       && BROWSE Format File
      lc_Format2= ""       && Default editing format file
      ll_ChkPop = .t.      && Force PopUp Field List 
                           && verification
      ll_BroSeek= .t.      && .t. = Enable ON KEY handlers 
                           && in BROWSE pick lists.
      **********************************************
      ** End of default parameters initialization **
      **********************************************
      DO PickCase WITH "OPENLIST"
   ENDIF
   lc_ListArg = ;
      IIF(TYPE("LC_LISTARG")="U","",TRIM(lc_ListArg))
   lc_PikList = IIF(TYPE("LC_PIKLIST")="U","",lc_PikList)
   IF (""=lc_Order .OR. ""=lc_ListArg) .AND. .NOT. ;
      (ll_Kill .OR. ""=lc_PikList)
      DO BLDLIST
   ENDIF
   IF .NOT. ll_Kill
      lc_ActWind = WINDOW()
      ACTIVATE SCREEN
      PRIVATE lc_Cursor
      lc_Cursor= SET("CURSOR")
      SET CURSOR OFF
      STORE "" to lc_ClrNorm, lc_ClrHigh, ;
         lc_ClrMess, lc_ClrTitl, lc_ClrBox, lc_ClrInf, ;
         lc_ClrFld
      IF ""#lc_Border
         SET BORDER TO &lc_Border
      ENDIF
      IF .NOT. ISCOLOR()
         lc_NormClr= "N/W"  && NORMAL (Text in windows)
         lc_HighClr= "W+/N" && HIGHLIGHT (Selection bar)
         lc_MessClr= "W/N"  && MESSAGE 
         lc_TitlClr= "N/W"  && TITLE 
         lc_BoxClr = "N/W"  && BOX
         lc_InfClr = "W/N"  && INFORMATION
         lc_FldClr = "W+/N" && FIELD
         lc_SeekClr= "N/W"  && Keyed highlight (PopPick6)
         lc_ShadClr= "W/N"  && Shadow color (PopPick6)
      ENDIF
      ** Get the 7 current system color settings
      DO PPSysClr WITH ;
         lc_ClrNorm, lc_ClrHigh, lc_ClrMess, lc_ClrTitl, ;
         lc_ClrBox, lc_ClrInf, lc_ClrFld
      ** Set colors to pick list colors where needed.
      ** First 7 colors are colors used with PopPick6.
      ** Second 7 colors were the entry colors.
      DO PPSetClr WITH ;
         lc_NormClr, lc_HighClr, lc_MessClr, lc_TitlClr, ;
         lc_BoxClr, lc_InfClr, lc_FldClr, ;
         lc_ClrNorm, lc_ClrHigh, lc_ClrMess, lc_ClrTitl, ;
         lc_ClrBox, lc_ClrInf, lc_ClrFld
      lc_PikList = UPPER(lc_PikList)
      DO CASE
         CASE lc_PikList = "PP"
            DO PopPick
         CASE lc_PikList = "BR"
            DO BroPick
         CASE lc_PikList = "PU"
            DO PopIt 
         OTHERWISE
            DO NoPick
      ENDCASE
      ** First 7 colors were the entry colors.
      ** Second 7 colors are colors used with PopPick6.
      ** Reset to system colors where needed.
      DO PPSetClr WITH ;
         lc_ClrNorm, lc_ClrHigh, lc_ClrMess, lc_ClrTitl, ;
         lc_ClrBox, lc_ClrInf, lc_ClrFld, ;
         lc_NormClr, lc_HighClr, lc_MessClr, lc_TitlClr, ;
         lc_BoxClr, lc_InfClr, lc_FldClr
      IF "" # lc_Border
         SET BORDER TO
      ENDIF
      lv_DataChk = IIF(ll_Valid,&lc_KeyFld,lv_DataChk)
      IF .NOT. ll_IsFunc
         SELECT (lc_Alias)
         KEYBOARD ;
            IIF(ll_Valid,CHR(26)+CHR(25)+lv_DataChk,"") ;
            CLEAR
         ON KEY LABEL F3 DO PickList
      ENDIF
      SET CURSOR &lc_Cursor
      IF ""#lc_ActWind
         ACTIVATE WINDOW &lc_ActWin
      ENDIF

   ENDIF
   SELECT (lc_Alias)
   IF .NOT. ll_IsFunc
      IF ll_Kill
         ?? chr(7)
      ENDIF
      ON KEY LABEL F3 DO PickList
   ENDIF
RETURN

PROCEDURE NOPICK
   SAVE SCREEN TO PickList
   ACTIVATE SCREEN
   DEFINE WINDOW NOPICK FROM 10,20 TO 14,60
   ACTIVATE WINDOW NOPICK
   @ 0,5 SAY "Invalid pick list specified: " + lc_PikList
   @ 1,0 TO 1,38
   @ 2,5 SAY "Press any key to continue..."
   ?? CHR(7) + CHR(7)
   PRIVATE i
   i=inkey(0)
   RELEASE WINDOW NOPICK
   RESTORE SCREEN FROM PickList
   RELEASE SCREEN PickList
   ll_Valid = .f.
   ll_Kill = .t.
RETURN

PROCEDURE PopPick
   PRIVATE lc_Head, lc_Space, ln_InKey, ;
      ln_SeekLen, ln_BarPos, ln_BarOld, ln_X ,ln_GotoRec,;
      ln_Found, ll_List, lc_Seek, ln_MaxBar, ln_Row1, ;
      ln_Row2, ln_Lines, ll_UpArrow, lc_ArgList
   SAVE SCREEN TO PickList
   ACTIVATE SCREEN
   lc_ArgList = lc_ListArg
   lc_Head  = SET("HEAD")
   SET HEAD OFF
   lc_Space = SET("SPACE")
   SET SPACE ON
   GO TOP
   Top_rec  = RECNO()
   ln_MaxList = 0
   SCAN WHILE ln_MaxList < ln_Scroll
      ln_MaxList = ln_MaxList+1
   ENDSCAN
   ll_Kill = IIF(ll_Kill,ll_Kill,(ln_MaxList = 0))
   IF ll_Kill
      RETURN
   ENDIF
   GOTO BOTT
   Bot_rec  = RECNO()
   ln_GotoRec= Top_rec
   ln_Found = ln_GotoRec
   ln_Col1  = ln_TLCol 
   ln_Row1  = ln_TLRow + IIF(ll_Compres,1,3)
   ln_Col2  = ln_TLCol + ln_Width -1
   ln_MaxCol= ln_Width - 2
   ll_List  = .F.
   lc_Seek  = ""
   STORE 0 TO ln_InKey, ln_SeekLen, ln_BarPos, ln_BarOld, ;
      ln_X
   ll_Compres= IIF(""=TRIM(lc_Title),.t.,ll_Compres)
   ln_MaxRow = ln_Scroll - 1
   ln_MaxBar = ln_MaxList -1
   ln_Row2   = ln_TLRow + ln_MaxList + IIF(ll_Compres,0,2)
   ln_Lines  = ln_MaxList
   lc_Border = UPPER(TRIM(lc_Border))
   lc_Border = ;
      IIF(lc_Border$"DOUBLEPANELSINGLE",lc_Border,"DOUBLE")
   lc_PopType = "BR"
   DO CASE
      CASE lc_Border$"DOUBLE"
         lc_SideBar = "" 
         lc_Bar     = "" + IIF("" = lc_AltSep, ;
            REPL("", ln_Width -1), lc_AltSep) + ""
      CASE lc_BORDER$"SINGLE"
         lc_Border  = ""  
         lc_SideBar = "" 
         lc_Bar     = "" + IIF("" = lc_AltSep, ;
            REPL("", ln_Width -1), lc_AltSep) + ""
      CASE lc_Border$"PANEL"
         lc_SideBar = "" 
         lc_Bar     = "" + IIF("" = lc_AltSep, ;
            REPL("", ln_Width -1), lc_AltSep) + ""
   ENDCASE                    
   DEFINE WINDOW PickList FROM ln_Row1, ln_Col1+1;
      TO ln_Row2,ln_Col2 NONE   &&;
      COLOR &lc_NormClr., &lc_HighClr., &lc_BoxClr.
   ln_RowOff = IIF(ll_Shadow,ln_RowOff,0)
   ln_ColOff = IIF(ll_Shadow,ln_ColOff,0)
   GOTO TOP
   IF "" # lc_ExpType
      DO EXPLODE WITH ln_Row1-IIF(ll_Compres,1,3), ;
         ln_Col1, ln_Row2+1, ln_Col2+1, lc_NormClr, ;
         lc_BoxClr, lc_ShadClr, ;
         lc_ExpType, ln_RowOff, ln_ColOff, ;
         lc_Border, ln_Speed, ll_Clear
   ENDIF
   SET COLOR OF NORMAL TO &lc_BoxClr
   @ ln_Row1-IIF(ll_Compres,1,3),ln_Col1 TO ;
      ln_Row2+1,ln_Col2+1 &lc_Border 
   @ ln_Row1-IIF(ll_Compres,1,3),ln_Col1+1 ;
      SAY lc_AltTop COLOR &lc_BoxClr
   SET COLOR OF NORMAL TO &lc_TitlClr
   @ ln_Row1-IIF(ll_Compres,0,2),ln_Col1+1 ;
      SAY space(ln_Width-1)
   @ ln_Row1-IIF(ll_Compres,1,2),ln_Col1+1 ;
      SAY lc_Title
   SET COLOR OF NORMAL TO &lc_BoxClr
   @ ln_Row1-IIF(ll_Compres,0,1),ln_Col1 ;
      SAY IIF(ll_Compres,"",lc_Bar) 
   ACTIVATE WINDOW PickList
   SCAN WHILE ln_X<ln_Lines
      @ ln_X,1 SAY ""
      ?? &lc_ListArg
      ln_X=ln_X+1
   ENDSCAN
   ACTIVATE SCREEN
   @ ln_Row2+1, ln_Col1+1 SAY lc_AltBot
   @ ln_Row2, ln_Col2+1 SAY ;
      IIF(RECNO()#BOT_REC .AND. .NOT. EOF(),"",lc_SideBar)
   ACTIVATE WINDOW PickList
   GOTO TOP
   DO WHILE .T.
      IF ""=lc_Seek .OR. ln_BarOld#ln_BarPos
         @ ln_BarOld,0 FILL TO ln_BarOld,ln_MaxCol ;
            COLOR &lc_NormClr
         @ ln_BarPos,0 FILL TO ln_BarPos,ln_MaxCol ;
            COLOR &lc_HighClr
      ENDIF
      IF ""#lc_Seek
         @ ln_BarPos,0 fill to ln_BarPos,ln_SeekLen ;
               COLOR &lc_SeekClr
         IF ln_SeekLen<ln_MaxCol
            @ ln_BarPos,ln_SeekLen+1 FILL TO ;
               ln_BarPos,ln_MaxCol color &lc_HighClr
         ENDIF
      ENDIF
      ln_BarOld = ln_BarPos
      @ ln_BarPos,0 SAY ""
      ln_InKey = INKEY(0)
      DO CASE
         CASE ln_InKey=-9
            ** F10 key press 
            ** 
            DO PickCase WITH "EDIT"
            LOOP
         CASE ln_InKey=-8
            ** F9 key press
            DO PickCase WITH "ADD"
            LOOP
         CASE ln_InKey=27 .OR. ln_InKey=13 .OR. ln_InKey=23
            ll_Valid = (ln_InKey=13 .OR. ln_InKey=23)
            EXIT
         CASE ln_InKey<0 .AND. ln_InKey>-400
            ?? CHR(7)
            LOOP
         CASE (ln_InKey>=32 .AND. ln_InKey<126) .OR. ;
            ((ln_InKey=19 .OR. ln_InKey=127 .OR. ;
            ln_InKey = -400) .AND. ln_SeekLen>0)
            ln_GotoRec = RECNO()
            Test_key = CHR(ln_InKey)
            IF ln_InKey=19 .OR. ln_InKey=127 .OR. ;
               ln_InKey=-400
               lc_Seek = LEFT(lc_Seek,len(lc_Seek)-1)
               Test_Key=""
            ENDIF
            lc_Seek = lc_Seek +IIF(SEEK(lc_Seek+test_key), ;
               test_key, IIF(SEEK(lc_Seek+UPPER(test_key)),;
               UPPER(test_key), IIF(SEEK(lc_Seek+ ;
               LOWER(test_key)),LOWER(test_key),"")))
            IF .NOT. FOUND()
               GOTO ln_GotoRec
               ?? CHR(7)
               ln_SeekLen = LEN(lc_Seek)
               LOOP
            ENDIF
            ln_SeekLen = LEN(lc_Seek)
            ln_Found = RECNO()
            GOTO ln_GotoRec
            SKIP -ln_BarPos
            ln_BarPos=0
            SCAN WHILE ln_BarPos < ln_MaxBar
               IF RECNO() = ln_Found
                  EXIT
               ENDIF
               ln_BarPos = ln_BarPos+1
            ENDSCAN
            IF RECNO() <> ln_Found
               ln_BarPos = 0
               GOTO ln_Found
               SKIP ln_MaxBar
               IF EOF()
                  SKIP -ln_MaxList
                  SCAN WHILE RECNO() <> ln_Found
                     ln_BarPos = ln_BarPos+1
                  ENDSCAN
                  SKIP -ln_BarPos
               ELSE
                  SKIP -ln_MaxBar
               ENDIF
               ll_List=.T.
            ENDIF
            ln_GotoRec = ln_Found
         CASE Top_rec=Bot_rec
            ?? CHR(7)
            LOOP
         CASE RECNO()=Top_rec .AND. (ln_InKey=26 ;
            .OR. ln_InKey=5 .OR. ln_InKey=18 ;
            .OR. ln_InKey=19 .OR. ln_InKey=29 ;
            .OR. ln_InKey=31 .OR. ln_InKey=127 ;
            .OR. ln_InKey=-400)
            ?? CHR(7)
            LOOP
         CASE RECNO()=Bot_rec .AND. (ln_InKey=2 ;
            .OR. ln_InKey=3 .OR. ln_InKey=4 ;
            .OR. ln_InKey=9 .OR. ln_InKey=24 ;
            .OR. ln_InKey=30 )
            ?? CHR(7)
            LOOP
         CASE ln_InKey=5 .OR. ln_InKey=19 .OR. ln_InKey=127
            lc_Seek=""
            SKIP -1
            ln_BarPos=ln_BarPos-1
            IF ln_BarPos>=0
               LOOP
            ENDIF
            ln_GotoRec = RECNO()
            ll_List=.T.
            ln_BarPos=0
         CASE ln_InKey=24 .OR. ln_InKey=4 .OR. ln_InKey= 9
            lc_Seek=""
            ln_BarPos=ln_BarPos+1
            SKIP
            IF ln_BarPos<=ln_MaxBar
               LOOP
            ENDIF
            ln_Lines = 1
            ln_BarPos = ln_MaxBar
            ln_GotoRec = RECNO()
            ll_List = .T.
         CASE ln_MaxList < ln_MaxRow .AND. (ln_InKey=3 ;
            .OR. ln_InKey=30)
            lc_Seek = ""
            GOTO BOTT
            ln_BarPos = ln_MaxBar
         CASE ln_MaxList < ln_MaxRow .AND. (ln_InKey=18 ;
            .OR. ln_InKey=31)
            lc_Seek = ""
            GOTO TOP
            ln_BarPos = 0
         CASE ln_InKey=18
            lc_Seek=""
            IF ln_BarPos>0
               SKIP -ln_BarPos
               ln_BarPos=0
               LOOP
            ENDIF
            SKIP -ln_MaxList
            ln_GotoRec = RECNO()
            ll_List=.T.
         CASE ln_InKey=3
            lc_Seek = ""
            IF ln_BarPos<ln_MaxBar
               SKIP ln_MaxBar-ln_BarPos
               ln_BarPos=ln_MaxBar
               LOOP
            ENDIF
            SKIP ln_MaxList
            ln_GotoRec = RECNO()
            IF EOF()
               SKIP -1
               ln_GotoRec = RECNO()
            ENDIF
            ll_List=.T.
            SKIP -ln_MaxBar
         CASE ln_InKey=31 .OR. ln_InKey=26
            lc_Seek = ""
            SKIP -ln_BarPos
            ll_List = IIF(RECNO() = Top_rec,.F.,.T.)
            GOTO TOP
            ln_BarPos = 0
            ln_GotoRec = RECNO()
         CASE ln_InKey=30 .OR. ln_InKey=2
            lc_Seek = ""
            SKIP (ln_MaxBar-ln_BarPos)
            ll_List = IIF(RECNO() = Bot_rec,.F.,.T.)
            GOTO BOTTOM
            ln_BarPos = ln_MaxBar
            IF ll_List
               ln_GotoRec = RECNO()
               SKIP -ln_MaxBar
            ENDIF
      ENDCASE
      IF ll_List
         ll_UpArrow = (RECNO()#TOP_REC)
         @ ln_BarOld,0 FILL TO ln_BarOld,ln_MaxCol ;
            COLOR &lc_NormClr
         @ ln_MaxList-ln_Lines, 0 SAY ""
         IF ln_Lines = 1
            ? " "
         ELSE
            ?? " "
         ENDIF
         ?? &lc_ListArg
         skip
         LIST OFF &lc_ListArg NEXT ln_Lines-1
         ACTIVATE SCREEN
         @ ln_Row1, ln_Col2+1 SAY ;
            IIF(ll_UpArrow,"",lc_SideBar) 
         GOTO ln_GotoRec
         @ ln_Row2, ln_Col2+1 SAY ;
            IIF(RECNO()#BOT_REC,"",lc_SideBar) 
         ACTIVATE WINDOW PickList
         ln_Lines = ln_MaxList
         ll_List=.F.
      ENDIF
   ENDDO
   DEACTIVATE WINDOW PickList
   RELEASE WINDOW PickList
   RESTORE SCREEN FROM PickList
   RELEASE SCREEN PickList
   SET HEAD &lc_Head
   SET SPACE &lc_Space
RETURN

* Program Name: bldlist.prg
* Author: Richard H. Price 
* Copyright (c) 1991 by Richard H. Price 
* Created: 4/10/1991 at 8:53
PROCEDURE BldList
   ** Create PopPick6 Pick List parameters from "scratch"
   ** Designed to automatically create list arguments
   ** and title headings from the dbf specified in PickCase
   ll_Kill = .t.
   IF SELECT() # 0
      PRIVATE lc_Safety
      lc_Safety = SET("SAFETY")
      SELECT (lc_dbf)
      SET SAFETY OFF
      COPY STRUCTURE EXTENDED TO TEMP_SE
      USE TEMP_SE IN SELECT()
      SELECT TEMP_SE
      IF ""=lc_Order
         LOCATE FOR FIELD_IDX = "Y"
         lc_Order = TRIM(FIELD_NAME)
         lc_KeyFld = TRIM(FIELD_NAME)
      ELSE
         LOCATE FOR TRIM(FIELD_NAME) $ lc_Order
         lc_KeyFld = TRIM(FIELD_NAME)
      ENDIF
      IF .NOT. EOF()
         ln_KeyRec = RECNO()
         ll_Kill = .f.
         ln_Width = FIELD_LEN + 2
         lc_ListArg = TRIM(FIELD_NAME)
         lc_Border = UPPER(TRIM(lc_Border))
         lc_Border = IIF(lc_Border $ "DOUBLESINGLEPANEL",;
            lc_Border,"DOUBLE")
         DO CASE
            CASE lc_Border$"DOUBLE"
               lc_Frame  = ""
               lc_SepBar = ""
               lc_TopBar = ""
               lc_SepCros= ""
               lc_SepCol = ""
               lc_BotBar = ""
            CASE lc_BORDER$"SINGLE"
               lc_Frame  = ""
               lc_SepBar = ""
               lc_TopBar = ""
               lc_SepCros= ""
               lc_SepCol = ""
               lc_BotBar = ""
            CASE lc_Border$"PANEL"
               lc_Frame  = ""
               lc_SepBar = ""
               lc_TopBar = ""
               lc_SepCros= ""
               lc_SepCol = ""
               lc_BotBar = ""
         ENDCASE                    
         PRIVATE ln_AddSp
         ln_AddSp = IIF("PU"=lc_PikList,0,1)
         lc_ListArg = TRIM(FIELD_NAME)
         lc_Title = SPACE(ln_AddSp) ;
            + IIF(LEN(FIELD_NAME)<FIELD_LEN,;
            FIELD_NAME+SPACE(FIELD_LEN-LEN(FIELD_NAME)+ln_AddSp), ;
            LEFT(FIELD_NAME,FIELD_LEN)) 
         lc_AltTop = REPL(lc_Frame, LEN(lc_Title)+ln_AddSp)
         lc_AltSep = REPL(lc_SepBar, LEN(lc_Title)+ln_AddSp)
         lc_AltBot = REPL(lc_Frame, LEN(lc_Title)+ln_AddSp)
         GO TOP
         SCAN
            IF ln_KeyRec = RECNO()
               LOOP
            ENDIF
            ln_Width = ln_Width + FIELD_LEN ;
               +IIF("PU"=lc_PikList,0,3)
            IF ln_Width > 72
               ln_Width = ln_Width - FIELD_LEN ;
                  -IIF("PU"=lc_PikList,0,3)
               EXIT
            ENDIF
            lc_ListArg = lc_ListArg + ',"' + ;
               lc_SepCol + '",' + TRIM(FIELD_NAME)
            lc_Title = lc_Title + ;
               SPACE(ln_AddSp) + lc_SepCol + ;
               SPACE(ln_AddSp) + ;
               IIF(LEN(FIELD_NAME)<FIELD_LEN, ;
               FIELD_NAME+SPACE(FIELD_LEN-LEN(FIELD_NAME)),;
               LEFT(FIELD_NAME,FIELD_LEN))
            lc_AltTop = lc_AltTop + lc_TopBar + ;
               REPL(lc_Frame, LEN(lc_Title)-LEN(lc_AltTop))
            lc_AltSep = lc_AltSep + lc_SepCros + ;
               REPL(lc_SepBar,LEN(lc_Title)-LEN(lc_AltSep);
               - IIF("PU"=lc_PikList,1,0))
            lc_AltBot = lc_AltBot + lc_BotBar + ;
               REPL(lc_Frame,LEN(lc_Title)-LEN(lc_AltBot))
         ENDSCAN
         lc_ListArg = TRIM(lc_ListArg)
         lc_Title = TRIM(lc_Title)
         ln_Width = ln_Width + IIF("PU"=lc_PikList,1,2)
         lc_AltTop = lc_AltTop + lc_Frame 
         lc_AltSep = lc_AltSep + lc_SepBar
         lc_AltBot = lc_AltBot + lc_Frame
      ENDIF
      USE
      DELETE FILE TEMP_SE.MDX
      DELETE FILE TEMP_SE.DBF
      SET SAFETY &lc_Safety.
      SELECT (lc_dbf)
      SET ORDER TO (lc_Order)
      ln_ColOff = IIF(ln_Width+ln_ColOff>79,0,ln_ColOff)
      ln_TLCol = ;
         IIF(ln_TLCol + ln_Width + ln_ColOff > 79, ;
         INT((79 - ln_Width - ln_ColOff)/2), ln_TLCol)
   ENDIF
RETURN

* Program Name: picktag.prg
* Author: Richard H. Price 
* Copyright (c) 1991 by Richard H. Price 
*----------------------------------------------------------
* Created: 4/10/1991 at 15:23
PROCEDURE PickTag
   ll_Kill = .t.
   IF SELECT() # 0
      PRIVATE lc_Safety
      lc_Safety = SET("SAFETY")
      SET SAFETY OFF
      SELECT (lc_dbf)
      COPY STRUCTURE EXTENDED TO TEMP_SE
      USE TEMP_SE IN SELECT()
      ** If the user specified an index to  use, attempt to
      ** use it and make it's associated field the first 
      ** field in the pick list. If none was specified, use 
      ** the first mdx tag found. If no tag found, fail 
      ** procedure and return.
      SELECT TEMP_SE
      LOCATE FOR FIELD_IDX = "Y"
      lc_Order = TRIM(FIELD_NAME)
      lc_KeyFld = lc_Order
      ll_Kill = EOF()
      USE
      DELETE FILE TEMP_SE.MDX
      DELETE FILE TEMP_SE.DBF
      SET SAFETY &lc_Safety.
      SELECT (lc_dbf)
      SET ORDER TO (lc_Order)
   ENDIF
RETURN

PROCEDURE BroPick 
   PRIVATE lc_NullStr, lc_Seek, lc_ArgList, lc_Compres,;
      ln_UsrPres, lc_KeyStuf, lc_BufStuf, ln_SeekLen
   SAVE SCREEN TO PickList
   ACTIVATE SCREEN
   lc_ArgList = lc_ListArg
   Store 0 to ln_UsrPres, ln_SeekLen
   STORE "" TO lc_nullstr, lc_Seek, lc_BufStuf
   ln_Row1 = ln_TLRow
   ln_Col1 = ln_TLCol
   ln_Col2 = ln_TLCol + ln_Width +1
   ln_Row2 = ln_TLRow + ln_Scroll + IIF(ll_Compres,1,3)
   ** Each of the WINDOW's FROM/TO coordinates
   ** MUST be referenced by a unique variable.
   ** (ie: Using "a" for all four isn't effective.)
   ** Without referencing them, the ON KEY handler
   ** bogs down.  Comment them out, key in a spelling,
   ** and see for yourself!
   ** NOTE: This is noticable only in deeply nested
   **       situations (Tested on a 286/12).
   PRIVATE a,b,c,d
   a=ln_Row1
   b=ln_Row2
   c=ln_Col1
   d=ln_Col2
   RELEASE a,b,c,d
   lc_HighClr= IIF(""#lc_Format1,lc_NormClr,lc_HighClr)
   SET COLOR of HIGHLIGHT TO &lc_HighClr
   DEFINE WINDOW PICKLIST ;
      FROM ln_Row1, ln_Col1 TO ln_Row2, ln_Col2
   IF "" # lc_ExpType
      ** Browse in windows do not respect border arguments.
      ** Reset lc_Border to SINGLE for exploding windows.
      lc_Border = IIF("" # lc_Border,"SINGLE","")
      DO EXPLODE WITH ln_Row1, ln_Col1, ln_Row2, ;
         ln_Col2, lc_NormClr, lc_TitlClr, ;
         lc_ShadClr, lc_ExpType, ln_RowOff, ln_ColOff, ;
         lc_Border, ln_Speed, ll_Clear
   ENDIF
   lc_Freeze = LEFT(lc_ListArg, AT(",",lc_ListArg)-1)
   lc_Freeze = IIF(""=lc_Freeze,lc_ListArg,lc_Freeze)
   lc_Compres= IIF(ll_Compress,"COMPRESS","")
   SET FORMAT TO &lc_Format1
   IF ll_BroSeek
      ** Enable seeks based on user keypresses
      ON KEY DO KeySeek
   ELSE
     ** Stick with browse's internal key routines,
     ** but allow the user to select with "ENTER".
      ON KEY LABEL CTRL-M KEYBOARD CHR(23)
   ENDIF
   BROWSE FIELDS &lc_ListArg. ;
      NOEDIT NOAPPEND NOMENU ;
      WINDOW PickList FREEZE &lc_Freeze ;
      &lc_Compres FORMAT
   SET FORMAT TO &lc_Format2
   ON KEY
   RELEASE WINDOW PICKLIST
   RESTORE SCREEN FROM PickList
   RELEASE SCREEN PickList
   ll_Valid = (READ() # 12)
RETURN

PROCEDURE KeySeek
   ** Find & hilite a record in a BROWSE based upon
   ** user key strokes.
   ON KEY
   ln_UsrPres=INKEY()
   IF ln_UsrPres>31
      User_Chr = CHR(ln_UsrPres)
      Recnum = RECNO()
      IF ln_SeekLen>0 .AND. ;
         (ln_UsrPres = 19 .OR. ln_UsrPres = 127)
         ** Backspace or Left arrow erases one character
         ln_SeekLen = LEN(lc_Seek)-1
         lc_Seek = ;
            SUBS(lc_Seek,1,IIF(ln_SeekLen>0,ln_SeekLen,0))
         SEEK lc_Seek
      ELSE
         lc_Seek = lc_Seek + ;
            IIF(SEEK(lc_Seek + User_Chr), User_Chr,;
            IIF(SEEK(lc_Seek + UPPER(User_Chr)),;
            UPPER(User_Chr), IIF(SEEK(lc_Seek + ;
            LOWER(User_Chr)), LOWER(User_Chr),"")))
         IF .NOT. FOUND()
            ?? CHR(7)
            GOTO RecNum
         ENDIF
      ENDIF
      ln_UsrPres = 26 && Used to refresh the BROWSE display.
   ELSE
      ln_UsrPres=IIF(ln_UsrPres=26,31,IIF(ln_UsrPres=2,30,;
      IIF(ln_UsrPres=13,23,ln_UsrPres)))
      lc_Seek = ""
   ENDIF
   ln_SeekLen = LEN(lc_Seek)
   IF "" = lc_Format1
      ACTIVATE SCREEN
      @ 24,0 say "Search Key = " + ;
        lc_Seek + SPACE(65 -LEN(lc_Seek))
      ACTIVATE WINDOW PICKLIST
   ENDIF
   ** Trap and re-key any key presses made during the
   ** above's processing.
   lc_KeyStuf = CHR(INKEY())
   lc_BufStuf = lc_KeyStuf
   DO WHILE "" # lc_KeyStuf
      lc_KeyStuf = CHR(INKEY())
      lc_BufStuf = lc_BufStuf + lc_KeyStuf
   ENDDO
   KEYBOARD CHR(ln_UsrPres) + lc_BufStuf
   ON KEY DO KeyReSet
RETURN

PROCEDURE KeyReSet
   ** Reset the ON KEY trap to avoid recursion.
   ON KEY DO KeySeek
RETURN

FUNCTION HILITE
   ** Create a higlight pick list bar with highlighted
   ** keyed entry for a browse window pick list.
   ** This requires the use of a BROWSE NOEDIT FORMAT where
   ** the first field uses WHEN HILITE().
   ** NOTE: This is used in conjunction with the ON KEY
   **       handlers KEYSEEK and KEYRESET (above) 
   **       Also, I opted to "hard code" the color 
   **       parameters due strictly to speed considerations.  
   **       Macro (&) substitution really slows things down!
   ln_xxx = ROW()
   ln_yyy = COL() - IIF(LAST()=19,ln_Width-1,0)
   ln_fill2 = ln_yyy + ln_Width -1
   IF ln_SeekLen>0
      @ ln_xxx,ln_yyy FILL TO ln_xxx,ln_yyy+ln_SeekLen-1 COLOR G/N
   ENDIF
   @ ln_xxx,ln_yyy+ln_SeekLen FILL TO ln_xxx,ln_fill2 COLOR W+/R
RETURN .t.

PROCEDURE PopIt
   ** Replace "," with plus signs (+) where applicable.
   SAVE SCREEN TO PickList
   ACTIVATE SCREEN
   lc_ListArg = TRIM(lc_ListArg)
   DO WHILE ","$lc_ListArg
      lc_ListArg = ;
         STUFF(lc_ListArg,AT(",", lc_ListArg),1, "+")
   ENDDO
   GOTO TOP
   ll_Kill = (""=lc_ListArg .OR. BOF() .OR. EOF())
   IF ll_ChkPop .and. .not. ll_Kill
      ** Check for non character fields in list argument,
      ** convert if found
      PRIVATE lc_TestArg, lc_CkField, ln_AtPlus, lc_Type
      lc_TestArg = lc_ListArg
      lc_ListArg = ""
      lc_TestArg = lc_TestArg+IIF("+"$lc_TestArg,"+","")
      DO WHILE "+" $ lc_TestArg 
         ln_AtPlus = AT("+",lc_TestArg)
         lc_CkField = LEFT(lc_TestArg,ln_AtPlus -1)
         lc_TestArg = RIGHT(lc_TestArg,LEN(lc_TestArg)-ln_AtPlus)
         lc_Type = TYPE([&lc_CkField])
         DO CASE
            CASE lc_Type $ "FN"
               lc_CkField = [TRAN(]+lc_CkField+[,"@R")]
            CASE lc_Type = "L"
               lc_CkField = [TRAN(]+lc_CkField+[,"@Y")]
            CASE lc_Type = "D"
               lc_CkField = [TRAN(]+lc_CkField+[,"@D")]
         ENDCASE
         lc_ListArg = lc_ListArg + ;
            IIF(""#lc_ListArg,"+","") + lc_CkField
      ENDDO
   ENDIF
   ln_Col2 = ln_TLCol + ln_Width +1
   ln_Row2 = ln_TLRow + ln_Scroll 
   DO CASE
      CASE ll_Kill
         ** Trap for an invalid condition
      CASE "+" $ lc_ListArg .or. "-"$lc_ListArg
         DEFINE POPUP PickList FROM ln_TLRow, ln_TLCol ;
            TO ln_Row2, ln_Col2
         PRIVATE X
         ll_Compres = (""=lc_Title)
         lc_Title = IIF(ll_Compres ,"",lc_Title)
         X = IIF(ll_Compres,1,3)
         IF .NOT. ll_Compres
            DEFINE BAR 1 of PickList PROMPT lc_Title SKIP
            DEFINE BAR 2 of PickList PROMPT IIF("" = ;
               lc_AltSep,REPL("",ln_Width),lc_AltSep) SKIP
         ENDIF
         SCAN
            DEFINE BAR X OF PickList PROMPT &lc_ListArg
            X=X+1
         ENDSCAN
      OTHERWISE  && Popup Prompt Field
         ll_Compres = .t.
         DEFINE POPUP PickList FROM ln_TLRow, ln_TLCol ;
            TO ln_Row2, ln_Col2 PROMPT FIELD &lc_ListArg
   ENDCASE
   ON SELECTION POPUP PickList DO PopPix
   IF "" # lc_ExpType
      DO EXPLODE WITH ln_TLRow, ln_TLCol, ln_Row2, ;
         ln_Col2, lc_NormClr, lc_BoxClr, ;
         lc_ShadClr, lc_ExpType, ln_RowOff, ln_ColOff, ;
         lc_Border, ln_Speed, ll_Clear
   ENDIF
   IF "" # lc_ListArg
      PRIVATE ln_Bar
      ln_BAR = 0
      ACTIVATE POPUP PickList
      RELEASE POPUP PickList
      GO TOP
      ll_Valid = (ln_Bar#0)
      SKIP ln_Bar -IIF(ll_Compres, 1, 3)
   ENDIF
   RESTORE SCREEN FROM PickList
   RELEASE SCREEN PickList
RETURN

PROCEDURE PopPix
   ln_BAR = BAR()
   DEACTIVATE POPUP
RETURN

* Program Name: Explode.prg
* Author: Richard H. Price
* Created: 1/20/1991 at 20:52
* Updated: 4/12/1991 at 12:50
PROCEDURE EXPLODE
   PARAMETERS ln_WinR1, ln_WinC1, ln_WinR2, ln_WinC2, ;
      lc_ClrNorm, lc_ClrBord, lc_ClrShad, ;
      lc_ExpType, ln_RowOff, ln_ColOff, ;
      lc_Border, ln_Speed, ll_Clear
   PRIVATE ln_WinR1, ln_WinC1, ln_WinR2, ln_WinC2, ;
      lc_ClrNorm, lc_ClrBord, lc_ClrShad, ;
      lc_ExpType, ln_RowOff, ln_ColOff, ;
      lc_Border, ln_Speed, ll_Clear, BegR1, BegR2, BegC1,;
      BegC2, BegMR1, BegMR2, BegMC1, BegMC2, LimR1, LimR2,;
      CBegR1, CBegR2, CBegC1, CBegC2, CBegMR1, CBegMR2, ;
      CBegMC1, CBegMC2 
   PRIVATE LimC1, LimC2, LimMR1, LimMR2, LimMC1, LimMC2, ;
      TRNo, TRYes, BRNo, BRYes, LCNo, LCYes, RCNo, RCYes,;
      SR1, SR2, SC1, SC2, SMR1, SMR2, SMC1, CMC2, ;
      ln_MidRow, ln_MidCol, ll_OKLoop, ShR1, ShR2, ShR3, ;
      ShR4, ShR5, ShR6, ShR7, ShR8, ShC1, ShC2, ShC3, ;
      ShC4, ShC5, ShC6, ShC7, ShC8, ll_Implode
   ** ln_WinR1   = Top Window Row
   ** ln_WinR2   = Bottom Window Row  
   ** ln_WinC1   = Left Window Col
   ** ln_WinC2   = Right Window Col
   ** lc_ClrNorm = Window's color of NORMAL
   ** lc_ClrBord =   "        "   "  BOX
   ** lc_ClrShad =   "        "   "  SHADOW
   ** lc_ExpType = Explosion Type <SEE CHART BELOW>
   ** ln_RowOff  = Row offset for SHADOW
   ** ln_ColOff  = Column offset for SHADOW
   ** Typical afternoon shadow -> ln_RowOff = 1
   **                          -> ln_ColOff = 2
   ** For NO SHADOW effects, use 0 for both!
   ** lc_Border  = Window border 
   ** (NONE,SINGLE,DOUBLE,PANEL,<border definition string>)
   ** ln_Speed    = Increment step (speed) value
   **               Quick explosions: LARGE numbers.
   ** ll_Clear   = .t. CLEAR area under exploding area.
   **              .f. FILL area WITH color <&lc_ClrNorm>.
   **
   ** NOTE: For quicker execution, set ll_Clear = .t.
   ********************************************************
   **                 lc_ExpType = Explosion Type        **
   **----------------------------------------------------**
   **  Pairs used to enable software to reverse effect   **
   **====================================================**
   **
   **   CH  = Explode Center Horizontal         Ŀ
   **         Center out to Top & Bottom              
   **   HC  = Shrink Horizontal to Center       
   **         Top & Bottom to Center                  
   **                                              
   **   EH  = Explode Edge to Horizontal         
   **         Top to Center/Bottom to Center          
   **   HE  = Shrink to Horizontal Edges              
   **         Center to Top/Center to Bottom     
   **         (Two windows)                  
   **                                             
   **   CV  = Explode Center Vertical           Ŀ
   **         Center out to Left & Right        
   **   VC  = Shrink Vertical Center            
   **         Left & Right collapse to center   
   **                                           
   **   EV  = Explode Vertical to Center        
   **         Left to Center/Right to Center    
   **         (Two windows)                       
   **   VE  = Shrink to Vertical Edges            
   **         Center to Left/Center to Right    
   **         (Two windows)
   **
   **   TL  = Explode Top Left to bottom right  Ŀ
   **   LT  = Shrink from BR to TL                
   **                                                
   **                                           
   **   TR  = Explode Top Right to bottom left  
   **   RT  = Shrink from BL to TR                
   **                                                
   **                                           
   **   BL  = Explode Bottom Left to top right  Ŀ
   **   LB  = Shrink from TR to BL                   
   **                                             
   **                                           
   **   BR  = Explode Bottom Right to top left  Ŀ
   **   RB  = Shrink from TL to BR                   
   **                                              
   **                                           
   **                                           Ŀ
   **   CE  = Center Explode Out                
   **   EC  = Implode (shrink) to Center        
   **                                           
   **   TD  = Explode Top Down                  
   **   DT  = Shrink Bottom to Top                  
   **                                           
   **   BU  = Explode Bottom UP                 Ŀ
   **   UB  = Shrink Top to Bottom                  
   **                                           
   **
   **   LS  = Explode Left to Right             Ŀ
   **   SL  = Shrink Right to Left              
   **                                           
   **                       
   **   RS  = Explode Right to Left             
   **   SR  = Shrink Left to Right               
   **                                           
   ** <Else>= No Explosions, window only        
   lc_Border = UPPER(LTRIM(TRIM(lc_Border)))
   SET BORDER TO &lc_Border
   lc_ClrShad = UPPER(lc_ClrShad)
   lc_Char = " "
   ** ln_Speed MUST be positive & greater than 0
   ln_Speed = ABS(ln_Speed)
   ln_Speed = IIF(ln_Speed=0,1,ln_Speed)
   SET COLOR OF NORMAL TO &lc_ClrBord 
   ** Limit shadows enablement to two sides
   ll_Shadow = (ln_RowOff#0 .AND. ln_ColOff#0)
   ACTIVATE SCREEN
   ** Filter Exploding Type Definition.
   lc_ET = lc_ExpType
   lc_ET = UPPER(lc_ET)
   lc_ET = lTRIM(TRIM(lc_ET))
   lc_ET = IIF(LEN(lc_ET)#2 .OR. "/"$lc_ET,"  ",lc_ET)
   lc_ET = IIF(lc_ET$"CH/HC/EH/HE/CV/VC/EV/VE/TL/LT/TR/RT/";
      + "BL/LB/BR/RB/CE/EC/TD/DT/BU/UB/LS/SL/RS/SR",;
      lc_ET,"  ")
   lc_ET = IIF(ll_Clear,lc_ET,;
          SUBS("EH/CH/EV/CV/BU/TD/RS/LS/"+lc_ET,;
              AT(lc_ET,"HC/HE/VC/VE/DT/UB/SL/SR/" + ;
      lc_ET),2))
   ll_Implode = (ll_Clear .AND. lc_ET $ ;
      "HC/HE/VC/VE/LT/RT/LB/RB/EC/DT/UB/SL/SR")

   ** Determine Horizontal and Vertical Motion Indexes.
   ** (Synchronizes horizontal and vertical motions)
   PRIVATE R,C,RX,CX
   R = ln_WinR2 - ln_WinR1 +1
   C = ln_WinC2 - ln_WinC1 +1
   R = IIF(lc_ET $ "CH/HC/EH/HE/CE/EC",R/2,R)
   C = IIF(lc_ET $ "CV/VC/EV/VE/CE/EC",C/2,C)
   CX = IIF(lc_ET $ "CV/VC/EV/VE/LS/SL/RS/SR", 1, ;
      IIF(C>R,1,C/R)) * ln_Speed
   RX = IIF(lc_ET $ "CH/HC/EH/HE/TD/DT/BU/UB", 1, ;
      IIF(C>R,R/C,1)) * ln_Speed
   ** Top Row Coordinate does not move WITH these:
   TRNo = ;
     "TL/LT/TR/RT/LB/RB/TD/DT/LS/SL/RS/SR/CV/VC/EH/HE/EV/VE"
   ** Bottom Row Coordinate does not move WITH these:
   BRNo = ;
      "BL/LT/RT/LB/BR/BU/UB/LS/SL/RS/SR/CV/VC/EH/HE/EV/VE"
   ** Top Row Coordinates move WITH these:
   TRYes= "BL/BR/BU/UB/CE/EC/CH/HC"
   ** Bottom Row Coordinates move WITH these:
   BRYes= "TL/TR/RB/TD/DT/CE/EC/CH/HC"
   ** Left Column Coordinates do not move WITH these:
   LCNo = "TL/RT/BL/TD/DT/BU/UB/LS/SL/CH/HC/EH/HE/EV/VE"
   ** Right Column Coordinates do not move WITH these:
   RCNo = ;
      "TR/LT/BR/RB/LB/TD/DT/BU/UB/RS/SR/CH/HC/EH/HE/EV/VE"
   ** Left Column Coordinates move WITH these:
   LCYes= "TR/LT/BR/LB/CE/EC/RS/SR/CV/VC"
   ** Right Column Coordinates move WITH these:
   RCYes= "TL/RT/BL/CE/EC/LS/SL/CV/VC"
   ** SR1 = Step Row 1  
   ** SC1 = Step Column 1 
   ** SMR1= Step Middle Row 1 
   ** SMC1= Step Middle Column 1
   SR1 = IIF(lc_ET $ TRYes, RX, 1) * ;
      IIF(lc_ET $ "CH/BL/BR/CE/BU", -1, 1)
   SR2 = IIF(lc_ET $ BRYes, RX, 1) * ;
      IIF(lc_ET $ "HC/BR/EC/DT", -1, 1)
   SC1 = IIF(lc_ET $ LCYes, CX, 1) * ;
      IIF(lc_ET $ "LT/LB/CV/TR/BR/CE/RS", -1, 1)
   SC2 = IIF(lc_ET $ RCYes, CX, 1) * ;
      IIF(lc_ET $ "VC/EC/SL", -1, 1)
   SMR1= IIF(lc_ET $ "LT/RT/EH/HE/EV/VE", RX, 1) * ;
      IIF(lc_ET $ "HE/LT/RT", -1, 1)
   SMR2= IIF(lc_ET $ "EH/HE/EV/VE/LB", RX, 1) * ;
      IIF(lc_ET = "EH", -1, 1)
   SMC1= IIF(lc_ET $ "EH/HE/EV/VE/LB/RB", CX, 1) * ;
      IIF(lc_ET = "VE", -1, 1)
   SMC2= IIF(lc_ET $ "EH/HE/EV/VE/LB/RB", CX, 1) * ;
      IIF(lc_ET $ "EV/RT/VC", -1, 1)
   ** Determine beginning positions and ending limits.
   ln_MidRow = INT((ln_WinR2-ln_WinR1)/2) + ln_WinR1
   ln_MidCol = INT((ln_WinC2-ln_WinC1)/2) + ln_WinC1
   BegR1 = IIF(lc_ET $ TRNo+"HC/RB/EC/UB/LB",ln_WinR1, ;
     IIF(lc_ET $ "BL/BU/BR", ln_WinR2, ln_MidRow))
   BegR2 = IIF(lc_ET $ BRNo+"HC/EC/DT/UB" .AND. .NOT. ;
      lc_ET="RB", ln_WinR2, IIF(lc_ET $"TL/TR/TD/RB",;
      ln_WinR1, ln_MidRow))
   BegMR1= IIF(lc_ET = "HE", ln_MidRow, ;
      IIF(lc_ET $ "EH/LB/RB",ln_WinR1, ln_WinR2))
   BegMR2= IIF(lc_ET = "HE", ln_MidRow, ;
      IIF(lc_ET $ "EH/RB/RT/LT",ln_WinR2, ln_WinR1))
   BegC1 = IIF(lc_ET $ LCNo + "CH/HC/VC/RT/RB/EC/SR", ;
      ln_WinC1, IIF(lc_ET $"TR/BR/RS/LT/LB",ln_WinC2, ;
      ln_MidCol))
   BegC2 = IIF(lc_ET $ RCNo + "CH/VC/EC/SL",ln_WinC2,;
      IIF(lc_ET $ "TL/BL/LS/RT", ln_WinC1, ln_MidCol))
   BegMC1= IIF(lc_ET = "VE", ln_MidCol, ;
      IIF(lc_ET $ "EV/LT/RT/LB/RB", ln_WinC1, ln_WinC2))
   BegMC2= IIF(lc_ET = "VE", ln_MidCol, ;
      IIF(lc_ET="RB",ln_WinC1,ln_WinC2))
   LimR1 = IIF(lc_ET $ "HC/EC", ln_MidRow, ;
      IIF(lc_ET = "UB", ln_WinR2, ln_WinR1))
   LimR2 = IIF(lc_ET $ "HC/EC", ln_MidRow, ;
      IIF(lc_ET $ "DT", ln_WinR1, ln_WinR2))
   LimMR1= IIF(lc_ET $ "EV/VE", ln_WinR2, ;
      IIF(lc_ET = "EH", ln_MidRow, ln_WinR1))
   LimMR2= IIF(lc_ET $ "EV/VE", ln_WinR1, ;
      IIF(lc_ET = "EH", ln_MidRow, ln_WinR2))
   LimC1 = IIF(lc_ET $ "VC/EC", ln_MidCol,;
      IIF(lc_ET = "SR", ln_WinC2, ln_WinC1))
   LimC2 = IIF(lc_ET $ "VC/EC", ln_MidCol, ;
      IIF(lc_ET = "SL", ln_WinC1, ln_WinC2))
   LimMC1= IIF(lc_ET $ "EH/HE", ln_WinC2, ;
      IIF(lc_ET $ "EV", ln_MidCol, ln_WinC1))
   LimMC2= IIF(lc_ET $ "EH/HE", ln_WinC1, ;
      IIF(lc_ET $ "EV/VC", ln_MidCol, ln_WinC2))
   ll_OKLOOP = "  "#lc_ET
   CBegMR1 = INT(BegMR1)
   CBegMR2 = INT(BegMR2)
   CBegMC1 = INT(BegMC1)
   CBegMC2 = INT(BegMC2)
   CBegR1  = INT(BegR1)
   CBegR2  = INT(BegR2)
   CBegC1  = INT(BegC1)
   CBegC2  = INT(BegC2)
   DO CASE
      CASE lc_ET$"EH/HE/EV/VE"
      ** Split windows
         IF ll_Shadow
            ** Determine Shadows
            ShR1 = ln_WinR1 + ln_RowOff
            ShC3 = ln_WinC1 + ln_ColOff
            ShR6 = ln_WinR2 + ln_RowOff
            ShC8 = ln_WinC2 + ln_ColOff
         ENDIF
         DO WHILE ll_OKLOOP
            ll_OKLOOP = (BegMR1#LimMR1 .OR. BegMR2#LimMR2 ;
               .OR. BegMC1#LimMC1 .OR. BegMC2#LimMC2)
            DO CASE
               CASE ll_Implode  && .AND. ll_Clear
                  @ ln_WinR1, ln_WinC1 TO BegMR1, BegMC1
                  @ BegMR2, BegMC2 TO ln_WinR2, ln_WinC2 
                  IF CBegMR1 # INT(BegMR1) .OR. ;
                     CBegMC1 # INT(BegMC1) .OR.;
                     CBegMR2 # INT(BegMR2) .OR. ;
                     CBegMC2 # INT(BegMC2)
                     IF lc_ET = "HE"
                        @ CBegMR1, ln_WinC1 ;
                           CLEAR TO CBegMR2, ln_WinC2
                     ELSE
                        @ ln_WinR1, CBegMC1 ;
                           CLEAR TO ln_WinR2, CBegMC2
                     ENDIF
                  ENDIF
                  CBegMR1 = INT(BegMR1)
                  CBegMR2 = INT(BegMR2)
                  CBegMC1 = INT(BegMC1)
                  CBegMC2 = INT(BegMC2)
               CASE ll_Clear
                  @ ln_WinR1, ln_WinC1 CLEAR TO BegMR1, BegMC1  
                  @ BegMR2, BegMC2 CLEAR TO ln_WinR2, ln_WinC2  
                  @ ln_WinR1, ln_WinC1 TO BegMR1, BegMC1
                  @ BegMR2, BegMC2 TO ln_WinR2, ln_WinC2 
               OTHERWISE
                  @ ln_WinR1, ln_WinC1 FILL TO BegMR1, BegMC1 ;
                     COLOR &lc_ClrNorm
                  @ BegMR2, BegMC2 FILL TO ln_WinR2, ln_WinC2 ;
                     COLOR &lc_ClrNorm
            ENDCASE
            IF ll_Shadow .AND. ln_WinC1#BegMC1 ;
               .AND. ln_WinR1#begMR1
               ** Determine Shadows
               ShR2 = BegMR1 + ln_RowOff
               ShR3 = IIF(ln_RowOff>0, ;
                  BegMR1 +1, ln_WinR1 +ln_RowOff)
               ShR4 = IIF(ln_RowOff>0, ;
                  BegMR1 +ln_RowOff, ln_WinR1 +1)
               ShC1 = IIF(ln_ColOff>0, ;
                  BegMC1 +1, ln_WinC1 +ln_ColOff)
               ShC2 = IIF(ln_ColOff>0, ;
                  BegMC1 +ln_ColOff, ln_WinC1-1)
               ShC4 = BegMC1 + ln_ColOff
               ShR5 = BegMR2 + ln_RowOff
               ShR7 = IIF(ln_RowOff>0, ;
                  ln_WinR2 +1, BegMR2 +ln_RowOff)
               ShR8 = IIF(ln_RowOff>0, ;
                  ln_WinR2 +ln_RowOff, BegMR2 +1)
               ShC5 = IIF(ln_ColOff>0, ;
                  ln_WinC2 +1, BegMC2 +ln_ColOff)
               ShC6 = IIF(ln_ColOff>0, ;
                  ln_WinC2 +ln_ColOff, BegMC2-1)
               ShC7 = BegMC2 + ln_ColOff
               IF lc_ClrShad = "W/N"
                  @ ShR1,ShC1 FILL TO ShR2,ShC2 COLOR W/N
                  @ ShR3,ShC3 FILL TO ShR4,ShC4 COLOR W/N
                  @ ShR5,ShC5 FILL TO ShR6,ShC6 COLOR W/N
                  @ ShR7,ShC7 FILL TO ShR8,ShC8 COLOR W/N
               ELSE
                  @ ShR1,ShC1 FILL TO ShR2,ShC2 ;
                     COLOR &lc_ClrShad
                  @ ShR3,ShC3 FILL TO ShR4,ShC4 ;
                     COLOR &lc_ClrShad
                  @ ShR5,ShC5 FILL TO ShR6,ShC6 ;
                     COLOR &lc_ClrShad
                  @ ShR7,ShC7 FILL TO ShR8,ShC8 ;
                     COLOR &lc_ClrShad
               ENDIF
            ENDIF
            BegMR1 = IIF(SMR1>0, ;
               IIF(BegMR1+SMR1<LimMR1,BegMR1+SMR1,LimMR1),;
               IIF(BegMR1+SMR1>LimMR1,BegMR1+SMR1,LimMR1))
            BegMR2 = IIF(SMR2>0, ;
               IIF(BegMR2+SMR2<LimMR2,BegMR2+SMR2,LimMR2),;
               IIF(BegMR2+SMR2>LimMR2,BegMR2+SMR2,LimMR2))
            BegMC1 = IIF(SMC1>0, ;
               IIF(BegMC1+SMC1<LimMC1,BegMC1+SMC1,LimMC1),;
               IIF(BegMC1+SMC1>LimMC1,BegMC1+SMC1,LimMC1))
            BegMC2 = IIF(SMC2>0, ;
               IIF(BegMC2+SMC2<LimMC2,BegMC2+SMC2,LimMC2),;
               IIF(BegMC2+SMC2>LimMC2,BegMC2+SMC2,LimMC2))
         ENDDO
         IF lc_ET $ "EH/EV"
            IF ll_Clear
               @ ln_WinR1, ln_WinC1 ;
                  CLEAR TO ln_WinR2, ln_WinC2
               @ ln_WinR1, ln_WinC1 TO ln_WinR2, ln_WinC2 
            ELSE
               @ ln_WinR1, ln_WinC1 ;
                  FILL TO ln_WinR2, ln_WinC2 ;
                  COLOR &lc_ClrNorm
            ENDIF
         ENDIF
      CASE lc_ET$"LT/RT/LB/RB"
         ** Shrinking from corner - no shadows used!
         ** HINT: For shrink w/shadow, use shadow colors.
         DO WHILE ll_OKLOOP
            ll_OKLOOP = (BegMR1#LimMR1 .OR. BegMR2#LimMR2 ;
               .OR. BegMC1#LimMC1 .OR. BegMC2#LimMC2 ;
               .OR. BegR1#LimR1 .OR. BegR2#LimR2 ;
               .OR. BegC1#LimC1 .OR. BegC2#LimC2)
            DO CASE
               CASE ll_Clear
                  DO CASE
                     CASE lc_ET = "LT"
                        @ BegR1,BegMC1 to BegMR1,BegC1
                     CASE lc_ET = "RT"
                        @ BegR1,BegC2 to BegMR1,BegMC2
                     CASE lc_ET = "LB"
                        @ BegMR2,BegMC1 to BegR2,BegC1
                     CASE lc_ET = "RB"
                        @ BegR2,BegMC2 to BegMR2,BegC2
                  ENDCASE
                  IF CBegR1 # INT(BegR1) .OR. ;
                     CBegR2 # INT(BegR2) .OR. ;
                     CBegC1 # INT(BegC1) .OR. ;
                     CBegC2 # INT(BegC2)
                     @ CBegR1, CBegC1  CLEAR TO CBegR2, CBegC2
                  ENDIF
                  IF CBegMR1 # INT(BegMR1) .OR. ;
                     CBegMR2 # INT(BegMR2) .OR. ;
                     CBegMC1 # INT(BegMC1) .OR. ;
                     CBegMC2 # INT(BegMC2)
                     @ CBegMR1,CBegMC1 CLEAR TO CBegMR2,CBegMC2
                  ENDIF
               OTHERWISE
                  @ BegR1, BegC1 FILL TO BegR2, BegC2 ;
                     COLOR &lc_ClrNorm
                  @ BegMR1, BegMC1 FILL TO BegMR2, BegMC2 ;
                     COLOR &lc_ClrNorm
            ENDCASE
            CBegMR1 = INT(BegMR1)
            CBegMR2 = INT(BegMR2)
            CBegMC1 = INT(BegMC1)
            CBegMC2 = INT(BegMC2)
            CBegR1  = INT(BegR1)
            CBegR2  = INT(BegR2)
            CBegC1  = INT(BegC1)
            CBegC2  = INT(BegC2)
            BegMR1 = IIF(SMR1>0, ;
               IIF(BegMR1+SMR1<LimMR1,BegMR1+SMR1,LimMR1),;
               IIF(BegMR1+SMR1>LimMR1,BegMR1+SMR1,LimMR1))
            BegMR2 = IIF(SMR2>0, ;
               IIF(BegMR2+SMR2<LimMR2,BegMR2+SMR2,LimMR2),;
               IIF(BegMR2+SMR2>LimMR2,BegMR2+SMR2,LimMR2))
            BegMC1 = IIF(SMC1>0, ;
               IIF(BegMC1+SMC1<LimMC1,BegMC1+SMC1,LimMC1),;
               IIF(BegMC1+SMC1>LimMC1,BegMC1+SMC1,LimMC1))
            BegMC2 = IIF(SMC2>0, ;
               IIF(BegMC2+SMC2<LimMC2,BegMC2+SMC2,LimMC2),;
               IIF(BegMC2+SMC2>LimMC2,BegMC2+SMC2,LimMC2))
            BegR1 = IIF(SR1>0, ;
               IIF(BegR1+SR1<LimR1,BegR1+SR1,LimR1),;
               IIF(BegR1+SR1>LimR1,BegR1+SR1,LimR1))
            BegR2 = IIF(SR2>0, ;
               IIF(BegR2+SR2<LimR2,BegR2+SR2,LimR2),;
               IIF(BegR2+SR2>LimR2,BegR2+SR2,LimR2))
            BegC1 = IIF(SC1>0, ;
               IIF(BegC1+SC1<LimC1,BegC1+SC1,LimC1),;
               IIF(BegC1+SC1>LimC1,BegC1+SC1,LimC1))
            BegC2 = IIF(SC2>0, ;
               IIF(BegC2+SC2<LimC2,BegC2+SC2,LimC2),;
               IIF(BegC2+SC2>LimC2,BegC2+SC2,LimC2))
         ENDDO
      CASE lc_ET = "EC"
         ** IMPLODE TO CENTER - no shadows used!
         DO WHILE ll_OKLOOP
            ll_OKLoop = (BegC1#LimC1 .OR. BegR1#LimR1;
               .OR. BegC1 # LimC1 .OR. BegC2#LimC2)
            DO CASE
               CASE ll_Clear
                  @ BegR1,BegC1 TO BegR2,BegC2   
                  IF CBegC1 # INT(BegC1)
                     @ ln_WinR1,ln_WinC1 CLEAR TO ln_WinR2,CBegC1
                  ENDIF
                  IF CBegR1 # INT(BegR1)
                     @ ln_WinR1,ln_WinC1 CLEAR TO CBegR1,ln_WinC2 
                  ENDIF
                  IF CBegC2 # INT(BegC2)
                     @ ln_WinR1,CBegC2 CLEAR TO ln_WinR2,ln_WinC2
                  ENDIF
                  IF CBegR2 # INT(BegR2)
                     @ CBegR2,ln_WinC1 CLEAR TO ln_WinR2,ln_WinC2   
                  ENDIF
               OTHERWISE
                  @ ln_WinR1,ln_WinC1 FILL TO ln_WinR2,BegC1 ;
                     COLOR &lc_ClrNorm
                  @ ln_WinR1,ln_WinC1 FILL TO BegR1,ln_WinC2 ;
                     COLOR &lc_ClrNorm
                  @ ln_WinR1,BegC2 FILL TO ln_WinR2,ln_WinC2 ;
                     COLOR &lc_ClrNorm
                  @ BegR2,ln_WinC1 FILL TO ln_WinR2,ln_WinC2 ;
                     COLOR &lc_ClrNorm
            ENDCASE
            CBegR1  = INT(BegR1)
            CBegR2  = INT(BegR2)
            CBegC1  = INT(BegC1)
            CBegC2  = INT(BegC2)
            BegR1 = IIF(SR1>0, ;
               IIF(BegR1+SR1<LimR1,BegR1+SR1,LimR1),;
               IIF(BegR1+SR1>LimR1,BegR1+SR1,LimR1))
            BegR2 = IIF(SR2>0, ;
               IIF(BegR2+SR2<LimR2,BegR2+SR2,LimR2),;
               IIF(BegR2+SR2>LimR2,BegR2+SR2,LimR2))
            BegC1 = IIF(SC1>0, ;
               IIF(BegC1+SC1<LimC1,BegC1+SC1,LimC1),;
               IIF(BegC1+SC1>LimC1,BegC1+SC1,LimC1))
            BegC2 = IIF(SC2>0, ;
               IIF(BegC2+SC2<LimC2,BegC2+SC2,LimC2),;
               IIF(BegC2+SC2>LimC2,BegC2+SC2,LimC2))
               @ BegR1,BegC1 TO BegR2,BegC2   
         ENDDO
      OTHERWISE
         DO WHILE ll_OKLOOP
            ll_OKLOOP = (BegR1#LimR1 .OR. BegR2#LimR2 ;
               .OR. BegC1#LimC1 .OR. BegC2#LimC2)
            DO CASE
               CASE ll_Implode  && .AND. ll_Clear
                  @ BegR1, BegC1 TO BegR2, BegC2 
                  DO CASE 
                     CASE lc_ET = "DT" .AND. CBegR2 # INT(BegR2)
                        @ CBegR2,ln_WinC1 CLEAR TO ;
                          ln_WinR2,ln_WinC2
                     CASE lc_ET = "UB".AND. CBegR1 # INT(BegR1)
                        @ ln_WinR1, ln_WinC1 CLEAR TO ;
                          CBegR1,ln_WinC2
                     CASE lc_ET = "SL".AND. CBegC2 # INT(BegC2)
                        @ ln_WinR1, CBegC2 CLEAR TO ;
                          ln_WinR2,ln_WinC2
                     CASE lc_ET = "SR".AND. CBegC1 # INT(BegC1)
                        @ ln_WinR1, ln_WinC1 CLEAR TO ;
                          ln_WinR2,CBegC1
                     CASE lc_ET = "VC".AND. ;
                          (CBegC1 # INT(BegC1) .OR.;
                          CBegC2 # INT(BegC2))
                        @ ln_WinR1, ln_WinC1 CLEAR TO ;
                          ln_WinR2,CBegC1
                        @ ln_WinR1, CBegC2 CLEAR TO ;
                          ln_WinR2,ln_WinC2
                     CASE lc_ET = "HC" .AND. ;
                          (CBegR1 # INT(BegR1) .OR. ;
                          CBegR2 # INT(BegR2))
                        @ CBegR2,ln_WinC1 CLEAR TO ;
                          ln_WinR2,ln_WinC2
                        @ ln_WinR1, ln_WinC1 CLEAR TO ;
                          CBegR1,ln_WinC2
                  ENDCASE
                  CBegR1  = INT(BegR1)
                  CBegR2  = INT(BegR2)
                  CBegC1  = INT(BegC1)
                  CBegC2  = INT(BegC2)
               CASE ll_Clear
                  @ BegR1, BegC1 CLEAR TO BegR2, BegC2  
                  @ BegR1, BegC1 TO BegR2, BegC2 
               OTHERWISE
                  @ BegR1, BegC1 FILL TO BegR2, BegC2 ;
                     COLOR &lc_ClrNorm
            ENDCASE
            IF ll_Shadow .AND. BegC1#BegC2 ;
               .AND. BegR1#BegR2
               ** Determine Shadows
               ShR1=BegR1 + ln_RowOff
               ShR2=BegR2 + ln_RowOff
               ShR3=IIF(ln_RowOff>0,BegR2+1,BegR1+ln_RowOff)
               ShR4=IIF(ln_RowOff>0,BegR2+ln_RowOff,BegR1-1)
               ShC1=IIF(ln_ColOff>0,BegC2+1,BegC1+ln_ColOff)
               ShC2=IIF(ln_ColOff>0,BegC2+ln_ColOff,BegC1-1)
               ShC3=BegC1 + ln_ColOff
               ShC4=BegC2 + ln_ColOff
               IF lc_ClrShad = "W/N"
                  @ ShR1,ShC1 FILL TO ShR2,ShC2 COLOR W/N
                  @ ShR3,ShC3 FILL TO ShR4,ShC4 COLOR W/N
               ELSE
                  @ ShR1,ShC1 FILL TO ShR2,ShC2 ;
                     COLOR &lc_ClrShad
                  @ ShR3,ShC3 FILL TO ShR4,ShC4 ;
                     COLOR &lc_ClrShad
               ENDIF
            ENDIF
            BegR1 = IIF(SR1>0, ;
               IIF(BegR1+SR1<LimR1,BegR1+SR1,LimR1),;
               IIF(BegR1+SR1>LimR1,BegR1+SR1,LimR1))
            BegR2 = IIF(SR2>0, ;
               IIF(BegR2+SR2<LimR2,BegR2+SR2,LimR2),;
               IIF(BegR2+SR2>LimR2,BegR2+SR2,LimR2))
            BegC1 = IIF(SC1>0, ;
               IIF(BegC1+SC1<LimC1,BegC1+SC1,LimC1),;
               IIF(BegC1+SC1>LimC1,BegC1+SC1,LimC1))
            BegC2 = IIF(SC2>0, ;
               IIF(BegC2+SC2<LimC2,BegC2+SC2,LimC2),;
               IIF(BegC2+SC2>LimC2,BegC2+SC2,LimC2))
         ENDDO

   ENDCASE
   IF "  "=lc_ET
      ** Single Window for invalid explosion type.
      IF ll_Shadow
         ShR1=ln_WinR1 + ln_RowOff
         ShR2=ln_WinR2 + ln_RowOff
         ShR3=IIF(ln_RowOff>0,ln_WinR2+1,ln_WinR1+ln_RowOff)
         ShR4=IIF(ln_RowOff>0,ln_WinR2+ln_RowOff,ln_WinR1+1)
         ShC1=IIF(ln_ColOff>0,ln_WinC2+1,ln_WinC1+ln_ColOff)
         ShC2=IIF(ln_ColOff>0,ln_WinC2+ln_ColOff,ln_WinC1-1)
         ShC3=ln_WinC1 + ln_ColOff
         ShC4=ln_WinC2 + ln_ColOff
      ENDIF
      IF ll_Clear .AND. lc_Border$"DOUBLESINGLEPANEL" 
         @ ln_WinR1, ln_WinC1 CLEAR TO ln_WinR2, ln_WinC2  
         @ ln_WinR1, ln_WinC1 TO ln_WinR2,ln_WinC2
      ELSE
         @ BegR1, BegC1 FILL TO BegR2, BegC2 ;
            COLOR &lc_ClrNorm
      ENDIF
      IF ll_Shadow
         IF lc_ClrShad = "W/N"
            @ ShR1,ShC1 FILL TO ShR2,ShC2 COLOR W/N
            @ ShR3,ShC3 FILL TO ShR4,ShC4 COLOR W/N
         ELSE
            @ ShR1,ShC1 FILL TO ShR2,ShC2 ;
               COLOR &lc_ClrShad
            @ ShR3,ShC3 FILL TO ShR4,ShC4 ;
               COLOR &lc_ClrShad
         ENDIF
      ENDIF
   ENDIF
   IF ll_Implode
      @ ln_WinR1,ln_WinC1 CLEAR TO ln_WinR2, ln_WinC2
   ENDIF
   SET COLOR OF NORMAL TO &lc_ClrNorm
   SET BORDER TO
RETURN

PROCEDURE PPSysClr
   ** Save current system color settings
   PARAMETERS lc_ClrN, lc_ClrH, lc_ClrM, lc_ClrT, lc_ClrB, ;
              lc_ClrI, lc_ClrF
   lc_ClrF = SET("ATTRIBUTES")
   lc_ClrN = LTRIM(TRIM(LEFT(lc_ClrF, AT(",", lc_ClrF) -1)))
   lc_ClrF = RIGHT(lc_ClrF,LEN(lc_ClrF)-AT(",",lc_ClrF))
   lc_ClrH = TRIM(LEFT(lc_ClrF, AT(",", lc_ClrF) -1))
   lc_ClrF = RIGHT(lc_ClrF, LEN(lc_ClrF)-AT("&",lc_ClrF)-2)
   lc_ClrM = TRIM(LEFT(lc_ClrF, AT(",", lc_ClrF) -1))
   lc_ClrF = RIGHT(lc_ClrF,LEN(lc_ClrF)-AT(",",lc_ClrF))
   lc_ClrT = TRIM(LEFT(lc_ClrF, AT(",", lc_ClrF) -1))
   lc_ClrF = RIGHT(lc_ClrF,LEN(lc_ClrF)-AT(",",lc_ClrF))
   lc_ClrB = TRIM(LEFT(lc_ClrF, AT(",", lc_ClrF) -1))
   lc_ClrF = RIGHT(lc_ClrF,LEN(lc_ClrF)-AT(",",lc_ClrF))
   lc_ClrI = TRIM(LEFT(lc_ClrF, AT(",", lc_ClrF) -1))
   lc_ClrF = RIGHT(lc_ClrF,LEN(lc_ClrF)-AT(",",lc_ClrF))
RETURN

PROCEDURE PPSetClr
   PARAMETERS lc_NormUse, lc_HighUse, lc_MessUse, ;
      lc_TitlUse, lc_BoxUse, lc_InfoUse, lc_FldUse,;
      lc_NormIs, lc_HighIs, lc_MessIs, lc_TitlIs, lc_BoxIs,;
      lc_InfoIs, lc_FldIs
   IF lc_NormUse # lc_NormIs 
      SET COLOR OF NORMAL TO &lc_NormUse
   ENDIF
   IF lc_HighUse # lc_HighIs
      SET COLOR OF HIGHLIGHT TO &lc_HighUse
   ENDIF
   IF lc_MessUse #lc_MessIs
      SET COLOR OF MESSAGES TO &lc_MessUse
   ENDIF
   IF lc_TitlUse # lc_TitlIs
      SET COLOR OF TITLES TO &lc_TitlUse
   ENDIF
   IF lc_BoxUse # lc_BoxIs
      SET COLOR OF BOX TO &lc_BoxUse
   ENDIF
   IF lc_InfoUse # lc_InfoIs
      SET COLOR OF INFORMATION TO &lc_InfoUse
   ENDIF
   IF lc_FldUse # lc_FldIs
      SET COLOR OF FIELDS TO &lc_FldUse
   ENDIF
RETURN


