* Program Name: DemoPik6.prg
* Author: Richard H. Price
* Copyright (c) 1991 by Richard H. Price
*----------------------------------------------------------
* Created: 4/7/1991 at 15:05
* 
* Demonstrates procedures pick list routines
* found in procedure file PopPick6

PROCEDURE DemoPik6
   CLOSE DATABASES
   SET PROCEDURE TO PopPick6
   ** Initialize environmental variables
   STORE "" TO gc_Confirm,gc_Near, gc_Stat, gc_Bell, ;
   gc_Score, gc_Talk, gc_Esc, gc_Delete, gc_Exact, ;
   gc_Delim, gc_Head, gc_Type,; 
   gc_NormClr, gc_HighClr, gc_MessClr, gc_TitlClr, ;
   gc_BoxClr, gc_InfClr, gc_FldClr, ;
   gc_ClrNorm, gc_ClrHigh, gc_ClrMess, gc_ClrTitl, ;
   gc_ClrBox, gc_ClrInf, gc_ClrFld
   *-- Set Operating Environment
   DO Set_env
   ** The dbf to edit
   USE PIKORDER in 1
   ** These are used for Pick Lists
   ** NOT REQUIRED
   USE PIKVENDR Order VENDOR_ID In 2
   USE PIKSTOCK Order STOCK_ID In 3
   USE PIKEMPL Order EMP_ID in 4
   SELECT 1
   GOTO TOP
   IF BOF()
      *-- Create a blank record if empty.
      APPEND BLANK
   ENDIF
   ch="Y"
   DO BldScr
   DO WHILE ch="Y"
      DO GetIt
      DO DoneYet
   ENDDO
   SET FORMAT TO
   *-- Reset environment 
   DO Reset_env
   SET CURSOR ON
RETURN

PROCEDURE Set_env
   gc_Confirm   = SET("CONFIRM")
   gc_Near  = SET("NEAR")
   gc_Stat  = SET("STATUS")
   gc_Bell  = SET("BELL")
   gc_Score = SET("SCOREBOARD")
   gc_Talk  = SET("TALK")
   gc_Esc   = SET("ESCAPE")
   gc_Delete= SET("DELETE")
   gc_Exact = SET("EXACT")
   gc_Delim = SET("DELIMITERS")
   gc_Head  = SET("HEADING")
   DO PPSysClr WITH ;
      gc_ClrNorm, gc_ClrHigh, gc_ClrMess, gc_ClrTitl, ;
      gc_ClrBox, gc_ClrInf, gc_ClrFld

   IF ISCOLOR()
      gc_NormClr= "W+/B"  && NORMAL 
      gc_HighClr= "RG+/R" && HIGHLIGHT 
      gc_MessClr= "W/N"   && MESSAGE  
      gc_TitlClr= "R/W"   && TITLE  
      gc_BoxClr = "W+/R"  && BOX 
      gc_InfClr = "N/W"   && INFORMATION 
      gc_FldClr = "B/W"   && FIELD 
   ELSE
      gc_NormClr= "N/W"  
      gc_HighClr= "W+/N" 
      gc_MessClr= "W/N"  
      gc_TitlClr= "N/W"  
      gc_BoxClr = "N/W"  
      gc_InfClr = "W/N"  
      gc_FldClr = "W+/N" 
   ENDIF
   DO PPSetClr WITH ;
      gc_NormClr, gc_HighClr, gc_MessClr, gc_TitlClr, ;
      gc_BoxClr, gc_InfClr, gc_FldClr, ;
      gc_ClrNorm, gc_ClrHigh, gc_ClrMess, gc_ClrTitl, ;
      gc_ClrBox, gc_ClrInf, gc_ClrFld
   SET NEAR OFF
   SET BELL OFF
   SET STAT OFF
   SET SCORE OFF
   SET TALK OFF
   SET ESCAPE OFF
   SET DELETE OFF
   SET EXACT OFF
   SET CURSOR OFF
   SET DELIMITERS OFF
   ON KEY LABEL F2 ?? CHR(7)
   ON KEY LABEL F3 DO PickList
   ON ERROR
RETURN

PROCEDURE Reset_env
   ** Housekeeping
   SET CONFIRM &gc_Confirm
   SET NEAR &gc_Near
   SET BELL &gc_Bell
   SET TALK &gc_Talk
   SET STATUS &gc_Stat
   SET SCOREBOARD &gc_Score
   SET ESCAPE &gc_Esc
   SET DELETE &gc_Delete
   SET EXACT &gc_Exact
   SET DELIMITERS &gc_Delim
   SET HEADING &gc_Head
   DO PPSetClr WITH ;
      gc_ClrNorm, gc_ClrHigh, gc_ClrMess, gc_ClrTitl, ;
      gc_ClrBox, gc_ClrInf, gc_ClrFld, ;
      gc_NormClr, gc_HighClr, gc_MessClr, gc_TitlClr, ;
      gc_BoxClr, gc_InfClr, gc_FldClr
   ON KEY LABEL F1
   ON KEY LABEL F2
   ON KEY LABEL F3
   ON KEY LABEL F4
   ON KEY LABEL F5
   ON KEY LABEL F6
   ON KEY LABEL F7
   ON KEY LABEL F8
   ON KEY LABEL F9
   ON KEY LABEL F10
   CLOSE ALL
   ON ERROR
   CLEAR
   SET CURSOR ON
RETURN

PROCEDURE BldScr
   ** Build the PopPick6 demonstration screen 
   ** using fades and exploding windows.
   DO FadeIn with CHR(177),"W+/R", gc_NormClr
   * Explode Center Vertical With Shadow
   TopRow = 1
   TopCol = 19
   BotRow = 5
   BotCol = 60
   NormClr= "N/W"
   EnhClr = "W+/R"
   BordClr= "N/W"
   ShadClr= "W/N"
   ExpType = "CV"
   ShRowOff=1
   ShColOff=2
   BordDef = "DOUBLE"  
   Speed = 3
   ClrScreen = .t.
   DO EXPLODE WITH TopRow, TopCol, BotRow, BotCol, ;
      NormClr, BordClr, ShadClr, ;
      ExpType, ShRowOff, ShColOff, BordDef, Speed, ;
      ClrScreen
   @ 2,20 SAY  ;
      "          PopPick6 Demo Screen          " COLOR r/w
   @ 3,19 SAY ;
      "Ķ" COLOR n/w
   @ 4,20 SAY  ;
      "         Press F3 for Pick List         " COLOR r/w
   * Explode Top to Bottom With Shadow)
   TopRow = 8
   TopCol = 17
   BotRow = 21
   BotCol = 63
   NormClr= "R/W"
   BordClr= "R/W"
   ExpType = "TD"
   Speed = 3
   DO EXPLODE WITH TopRow, TopCol, BotRow, BotCol, ;
      NormClr, BordClr, ShadClr, ExpType, ;
      ShRowOff, ShColOff, BordDef, Speed, ClrScreen
   @ 9,19 SAY "Customer ID:" COLOR n/w
   @ 9,40 say "Sales Agent:" color n/w
   @ 10,17 SAY ;
      "Ķ" ;
      COLOR r/w
   @ 11,19 SAY "Company:" COLOR n/w
   @ 12,19 SAY "Address:" COLOR n/w
   @ 15,19 SAY "Phone:" COLOR n/w
   @ 16,17 SAY ;
      "Ķ" ;
      COLOR r/w
   @ 18,37 TO 21,63 DOUBLE COLOR r/w
   @ 18,63 say "" COLOR r/w
   @ 21,37 SAY "" COLOR r/w
   @ 17,19 SAY "Part ID... " COLOR n/w
   @ 18,19 SAY "Each...... " COLOR n/w
   @ 19,19 SAY "Quantity.. " COLOR n/w
   @ 20,19 SAY "Extended.." COLOR n/w
   @ 19,39 SAY "Contact ID..." COLOR n/w
   @ 20,39 SAY "Alternate...." COLOR n/w
RETURN

PROCEDURE FadeIn
   PARAMETERS lc_BackDrp, lc_BackClr, lc_NormClr
   PRIVATE lc_BackDrp, lc_BackClr, lc_NormClr
   ACTI SCREEN
   CLEAR
   X=0
   SET COLOR OF NORMAL TO &lc_BackClr
   DO WHILE X<3
      @ X,0 TO X+3,79 lc_Backdrp 
      sx=x
      X=X+6
      @ X,0 TO X+3,79 lc_Backdrp
      X=X+6
      @ X,0 TO X+3,79 lc_Backdrp
      X=X+6
      @ X,0 TO X+3,79 lc_Backdrp
      x=sx+1
   ENDDO
   @ 24,0 TO 24,79 lc_Backdrp
   SET COLOR OF NORMAL to &gc_NormClr
RETURN

PROCEDURE GetIt
   @ 9,32 GET Vendor_id PICTURE "@! XXXXXX" ;
      VALID PickFunc(.t.) ;
      MESSAGE "Press F3 for Pick List" ;
      COLOR w+/r,w+/r
   ** PopPick6 will build a browse-like pick list from 
   ** scratch!  All you need to specify is the dbf to use.
   ** See PickCase / CASE lc_Varread = "AGENT"
   @ 9,53 GET AGENT PICT "!!!!!!" ;
      MESSAGE "F3 for a Pick List built from " +;
      "scratch... only the lookup dbf is defined!" ;
      COLOR w+/r,w+/r
   @ 11,28 SAY lookup(PIKVENDR->COMPANY,VENDOR_ID,;
      PIKVENDR->Vendor_ID) COLOR b/w
   @ 12,28 SAY LOOKUP(PIKVENDR->Addr_1,Vendor_ID,;
      PIKVENDR->Vendor_ID) COLOR b/w
   @ 13,28 SAY LOOKUP(PIKVENDR->Addr_2,Vendor_ID,;
      PIKVENDR->Vendor_ID) COLOR b/w
   @ 14,28 SAY TRIM(LOOKUP(PIKVENDR->City,Vendor_ID,;
      PIKVENDR->Vendor_ID))+", " + LOOKUP(PIKVENDR->ST,;
      Vendor_ID,PIKVENDR->Vendor_ID)+"  " ;
      +LOOKUP(PIKVENDR->ZIP,Vendor_ID,PikVendr->ZIP) ;
      COLOR B/W
   @ 15,28 SAY LOOKUP(PIKVENDR->PHONE,Vendor_ID,;
      PIKVENDR->Vendor_ID) COLOR b/w
   ** Provide a pick list upon entry into an invalid 
   ** <blank> field.
   ** See PickCase-> CASE lc_Varread = "STOCK_ID"
   @ 17,30 GET Stock_id PICTURE "XXXXXX" ;
      VALID PickFunc(.t.) WHEN PickFunc(.f.) ;
      MESSAGE "Press F3 for Pick List" COLOR w+/r,w+/r
   @ 17,37 SAY LOOKUP(PIKSTOCK->Desc,Stock_ID,;
      PIKSTOCK->Stock_ID) COLOR b/w
   @ 18,30 GET Unit_price PICTURE "999.99" ;
      COLOR w+/r,w+/r
   ** Demonstrate non-picklist uses for Procedure PickCase 
   ** See: Procedure PickCase CASE lc_Varread = "QTY"
   ** This time, provide a routine to calculate the 
   ** extended price for field EXTENDED.
   @ 19,30 GET Qty PICTURE "999999" ;
     VALID REQUIRED PickFunc(.t.) ;
     MESSAGE "Press F3 to recalculate extended price." ;
     COLOR w+/r,w+/r
   @ 20,29 GET Extended PICTURE "9999.99" ;
     VALID REQUIRED PickFunc(.t.) COLOR w+/r,w+/r
   ** Use PickCase to open up a keyboard sensitive BROWSE
   @ 19,53 GET CONTACT PICT "!!!!!!";
      MESSAGE "F3 for a pick list using " +;
      "BROWSE with context sensitive seek." ;
      COLOR w+/r,w+/r
   ** Bring up a PopPick6 Pick List for the same dbf
   ** as the BROWSE was for. Compare look and feel!
   @ 20,53 GET ALTERNATE PICT "!!!!!!";
      MESSAGE "F3 to compare PopPick6 with " +;
      "the previous BROWSE pick list." ;
      COLOR w+/r,w+/r
   SET CURSOR ON
   READ
RETURN

PROCEDURE DoneYet
   SET CURSOR OFF
   TopRow = 11
   TopCol = 27
   BotRow = 13
   BotCol = 52
   NormClr= "RB/RB"
   EnhClr = "RB/RB"
   BordClr= "RG+/RB"
   ShadClr= "W/N"
   ExpType = "CV"
   ShRowOff=1
   ShColOff=2
   BordDef = "DOUBLE"  
   Speed = 5
   ClrScreen = .f.
   SAVE SCREEN TO DoneYet
   ACTIVATE SCREEN
   DEFINE WINDOW DoneYet from TopRow,TopCol ;
      TO BotRow,BotCol COLOR W+/RB, RG+/RB, RG+/RB
   DO EXPLODE WITH TopRow, TopCol, BotRow, BotCol, ;
      NormClr, BordClr, ShadClr, ExpType, ;
      ShRowOff, ShColOff, BordDef, Speed, ClrScreen
   ACTIVATE WINDOW DoneYet
   @ 0,0 say " Continue Demo (Y/n) ?"
   ?? chr(7)+chr(7)
   CLEAR TYPEAHEAD
   ch = upper(chr(inkey(0)))
   ShRowOff=0
   ShColOff=0
   BotRow = 14
   BotCol = 55
   NormClr= "B/W"
   EnhClr = "B/W"
   BordClr= "B/W"
   ShadClr= "B/W"
   ExpType = "VC"
   DEAC WINDOW DoneYet
   DO EXPLODE WITH TopRow, TopCol, BotRow, BotCol, ;
      NormClr, BordClr, ShadClr, ExpType, ;
      ShRowOff, ShColOff, BordDef, Speed, ClrScreen
   RELEASE WINDOW DONEYET
   RESTORE SCREEN FROM DoneYet
   RELEASE SCREEN DoneYet
   IF ch #"Y"
      TopRow = 0
      TopCol = 0
      BotRow = 24
      BotCol = 79
      NormClr= "W+/B"
      BordClr= "B/B"
      ExpType = "CE"
      Speed = 4
      ClrScreen = .t.
      DO EXPLODE WITH TopRow, TopCol, BotRow, BotCol, ;
         NormClr, BordClr, ShadClr, ExpType, ;
         ShRowOff, ShColOff, BordDef, Speed, ClrScreen
   ENDIF
RETURN

*----------------------------------------------------------
* Program Name: PickCase.prg
* Author: Richard H. Price
* Called From PopPick6: Procedure PickList
*                       Function PickFunc
*----------------------------------------------------------
PROCEDURE PickCase
   PARAMETERS lc_Process
   PRIVATE lc_Process
   DO CASE
      CASE lc_Varread = "VENDOR_ID"
         ** This case is used for pick list and data
         ** validation for a memvar or field named
         ** "VENDOR_ID"
         DO CASE
            CASE lc_Process = "ENVIRONMENT"
               ** Set up the data validation
               ** and pick list work area memvars.
               lc_dbf     = "PIKVENDR"
               lc_Order   = "VENDOR_ID"
               lc_KeyFld  = "VENDOR_ID"
            CASE lc_Process = "OPENLIST"
               ** Customize the pick list window settings.
               ** (Details in PopPick6 Procedure PickList)
               ** Notice that you can change the ndx order
               ** to accomodate the pick list preference.
               ** Even though data validation is performed
               ** on the VENDOR_ID field, you might prefer
               ** offering pick lists showing company name,
               ** followed by city and then ID. This method 
               ** allows the user to key in the COMPANY 
               ** name to assist in locating the desired 
               ** company. When the selection is made, the 
               ** VENDOR_ID will be passed to the waiting 
               ** memver/field. (See above: lc_KeyField)
               SET ORDER TO COMPANY
               ln_TLRow   = 12
               ln_TLCol   = 5
               ln_Width   = 67
               ln_Scroll  = 6
               ll_Compres = .f.
               ll_Shadow  = .t.
               lc_Border  = "DOUBLE"
               lc_ExpType = "  " 
               ln_Speed   =  4
               ll_Clear   = .t.
               lc_NormClr = "W+/RB"
               lc_HighClr  = "G+/N"
               lc_BoxClr  = "RG+/RB"
               lc_SeekClr = "B/W"
               lc_TitlClr = "W+/RB"
               lc_ListArg = "COMPANY,CITY,VENDOR_ID"
               lc_Title   = " Company                 " +;
                  "       City                      ID"
            CASE lc_Process = "COMMANDS"
               ** Providing a "COMMANDS" case enables you
               ** to selectively place additional commands
               ** into your validation routines. These will 
               ** execute upon exit of VALID PickFunc(.t.)
               @ 11,28 SAY PIKVENDR->COMPANY color b/W
               @ 12,28 SAY PIKVENDR->Addr_1 color b/W
               @ 13,28 SAY PIKVENDR->Addr_2 color b/W
               @ 14,28 SAY SPACE(30) color b/w
               @ 14,28 SAY trim(PIKVENDR->CITY)+", " ;
                  color b/W
               @ 14,COL() SAY PIKVENDR->ST color b/W
               @ 14,COL()+2 SAY PIKVENDR->ZIP color b/W
               @ 15,28 SAY PIKVENDR->PHONE color b/W
         ENDCASE
      CASE lc_Varread = "AGENT"
         ** So, you want a pick list and you want
         ** the computer to do it all!
         ** Try this one out.  Specify a dbf to list from.
         ** As long as the first indexed field is both an
         ** mdx key field and data validation field, this 
         ** is all you need.  Defaults as set in Procedure 
         ** PickList will govern its development.
         ** You might wish to enable this auto build
         ** pik list as a BROWSE or POPUP or PopPick6
         ** To do so, activate the appropriate line:
         ** lc_PikType = "BR"
         ** lc_PikType = "PU"
         ** lc_PikType = "PP"
         lc_dbf = "PIKEMPL"
      CASE lc_Varread = "STOCK_ID"
         ** Demonstrates how to jazz up pick list
         ** displays using customized titles, borders
         ** and field separators.
         DO CASE
            CASE lc_Process = "ENVIRONMENT"
               lc_dbf     = "PIKSTOCK"
               lc_Order   = "STOCK_ID"
               lc_KeyFld  = "STOCK_ID"
            CASE lc_Process = "OPENLIST"
               ln_TLRow   = 6
               ln_TLCol   = 14
               ln_Width   = 52
               ln_Scroll  = 12
               ll_Compres = .f.
               ll_Shadow  = .t.
               lc_ExpType = "TD"
               ll_Clear   = .t.
               ln_Speed    = 4
               lc_Border  = "SINGLE"
               lc_NormClr = "w+/r"
               lc_HighClr  = "W+/bg"
               lc_BoxClr  = "W+/r"
               lc_SeekClr = "g+/n"
               ** Notice the lines ( , , , etc.., )
               ** in the list and alternative arguments.
               lc_ListArg = "STOCK_ID,'',DESC,''," +;
                  "ON_HAND,'',UNIT_PRICE"
               lc_AltTop  = "" +;
                  ""
               lc_Title   = " ID      Description " +;
                  "          On Hand  $ Each  "
               lc_AltSep  = "" +;
                  ""
               lc_AltBot  = "" +;
                  ""
            CASE lc_Process = "COMMANDS"
               KEYBOARD str(PIKSTOCK->UNIT_PRICE,6,2) ;
               CLEAR
               @ 17,37 SAY PIKSTOCK->Desc color b/W
         ENDCASE
      CASE lc_Varread = "QTY"
         ** There are no pick lists associated with
         ** QTY, however, you can use PickCase to update
         ** the screen display and the record by using
         ** Function PickFunc(.f.)
         ll_Kill = .t.
         LK=LASTKEY()
         ln_Ext = PIKORDER->QTY * ;
                  PIKORDER->UNIT_PRICE
         IF (LK=4 .or. LK=13 .or. LK=24 .or. LK=9) ;
            .and. READKEY()#512
            ** RightArrow / Enter / DownArrow / Tab
            ** Set confirm to enable the KEYBOARDED
            ** entry not to end the entry session.
            ** Post the data to the next active get, 
            ** and reposition the cursor to the
            ** begining of the field.
            ** The next field utilizes the construct
            ** of WHEN PickFunc(.f.) 
            ** There are no pick lists associated 
            ** with the next field and the only goal
            ** is to reset the CONFIRM status
            SET CONFIRM ON
            KEYBOARD STR(ln_Ext,10,2) + CHR(26) CLEAR
         ELSE
            ** Since another key was pressed,
            ** display the calculated results
            ** without keyboarding into a prior
            ** field.
            REPLACE PIKORDER->EXTENDED WITH ln_Ext
            @ 20,29 SAY ln_Ext PICTURE "9999.99" ;
               COLOR w+/r
         ENDIF
      CASE lc_Varread = "EXTENDED"
         ** WHEN PickFunc(.f.) on field "EXTENDED"
         ** Set confirm back on and kill processing!
         SET CONFIRM OFF
         ll_Kill = .t.
      CASE lc_Varread = "CONTACT"
         DO CASE
            CASE lc_Process = "ENVIRONMENT"
               lc_dbf     = "PIKEMPL"
               lc_Order   = "EMP_ID"
               lc_KeyFld  = "EMP_ID"
            CASE lc_Process = "OPENLIST"
               SET ORDER TO L_Name
               ln_TLRow  = 5
               ln_TLCol  = 10  
               ln_Scroll = 10
               lc_NormClr = "W+/BG"
               lc_HighClr= "W+/R"
               lc_MessClr= "W+/B"
               lc_FldClr = "W+/R"
               lc_BoxClr = "RG+/BG"
               lc_TitlClr = lc_BoxClr
               lc_SeekClr = "R/W"
               lc_ShadClr= "W/N"
               lc_ExpType= "EV"
               ln_RowOff = 1
               ln_ColOff = 2
               lc_Border = "SINGLE"
               ln_Speed  = 7
               ll_Clear  = .t.
               ll_Compres= .f.
               * The following CASE statements are used only
               * to assist in quickly demonstrating different 
               * types of pick lists.
               * Assign lc_PikList to your choice.
               lc_PikList= "BR"
               DO CASE
                  CASE lc_PikList = "PP"
                     ln_Width   = 52
                     lc_ListArg= "L_Name,F_Name,EMP_ID"
                     lc_Title = " Last Name            "+;
                        "First Name           ID    "
                  CASE lc_PikList = "PU"
                     ** For a POPUP PROMPT, use a single
                     ** field as the list argument.
                     ** (Enable the next 2 lines, 
                     ** disable the rest.)
*                     ln_Width =6
*                     lc_ListArg= "L_Name"
                     ** Notice the list argument is padded
                     ** with spaces for appearance sake.
                     ln_Width   = 54
                     lc_ListArg= [" ",L_Name,"  ",] + ;
                        [F_Name,"  ",EMP_ID," "]
                     lc_Title = " Last Name            "+;
                        " First Name            ID    "
                     lc_AltSep= ""+;
                        ""
                  CASE lc_PikList= "BR"
                     ln_Width   = 54  
                     lc_ListArg= "L_Name,F_Name,EMP_ID"
                     ** For a context sensitive 
                     ** BROWSE pick list WITH a full width
                     ** highlight bar, create a format file
                     ** whose first field uses WHEN HILITE()
                     ** and tell PopPick6 to use that format
                     ** with the BROWSE pick list via:
                     ** lc_Format1 = <format_file_name>
                     ** and enable context sensitive seeks
                     ** by setting ll_BroSeek = .t.
*                     lc_Format1= "PIKEMPL"
                     ll_BroSeek = .t.
                     ** Use of a the above MAY slow
                     ** the response time to an unacceptable 
                     ** level. If that is the case, but you 
                     ** prefer a full bar, set:
                     ** ll_BroSeek=.f.
                     ** If you normally have a format file
                     ** open with the dbf used for your pick 
                     ** list, specify it as: 
                     **     lc_Format2 = <format file>
                     ** PopPick6 will reopen the named 
                     ** format upon completion of pick list
                     ** routines.  Note that you MUST assign
                     ** lc_Format1 = <format file>
                     ** if you require the named format file 
                     ** open during pick list access.
               ENDCASE
         ENDCASE
      CASE lc_Varread = "ALTERNATE"
         DO CASE
            CASE lc_Process = "ENVIRONMENT"
               lc_dbf     = "PIKEMPL"
               lc_Order   = "L_NAME"
               lc_KeyFld  = "EMP_ID"
            CASE lc_Process = "OPENLIST"
               lc_NormClr = "W+/B"
               lc_HighClr = "W+/R"
               lc_BoxClr  = "W+/B"
               lc_SeekClr = "R/W"
               lc_ShadClr = "W/N"
               lc_TitlClr = "BG+/B"
               ln_TLRow   = 5
               ln_TLCol   = 10
               ln_Width   = 57
               ln_Scroll  = 10
               ll_Compres = .f.
               ll_Shadow  = .t.
               lc_Border  = "SINGLE"
               lc_ExpType = "TL"
               ln_Speed   =  7
               ll_Clear   = .t.
               lc_ListArg = "L_Name,'',F_Name," +;
                  "'',EMP_ID"
               lc_Title   = "-*- PopPick6 with PickC" +;
                  "ase....Lets YOU take control! -*-"
               lc_AltSep  = "" +;
                  ""
               lc_AltBot  = "" +;
                  ""
         ENDCASE
      OTHERWISE
         ** If the on key routine was called and there are 
         ** no associated procedures, OR PickFunc() enabled
         ** but the programmer failed to provide a CASE 
         ** above flag to halt execution and return.
         ll_Kill = .t.
   ENDCASE
RETURN

