* Program Name: browpick.prg
* Author: Richard H. Price
* Demonstrate how a BROWSE pick list can have a HILITE bar

procedure browpick
   set talk off
   set score off
   set stat off
   use pikempl order L_Name
   memvar = Space(6)
   ON KEY LABEL F3 do PickBrow
   clear
   define window tw from 5,4 to 18,70 DOUBLE
   acti wind tw
   @ 1,10 say ;
   "Demonstrate a browse table with a bar for pick lists."
   @ 3,10 say "Press F3 for Pick List List: " GET memvar
   READ
   @ 5,10 SAY "That's it!"
   ON KEY
   I=INKEY(2)
   release window tw

return

PROCEDURE PICKBROW
   save screen to tmpscr
   activate screen
   DEFINE WINDOW PICKLIST FROM 5,15 TO 15,65 ;
      COLOR N/W, N/W, B/W
   ** The window is accomodates 49 columns:
   ln_ShowLen = 49
   lc_Seek = ""
   lenMatch = 0
   SET FORMAT TO PIKEMPL
   ON KEY DO KEYSEEK
   BROWSE FIELDS L_NAME, F_NAME, EMP_ID NOEDIT NOAPPEND ;
      FREEZE L_NAME WINDOW PICKLIST FORMAT 
   ON KEY
   SET FORMAT TO
   IF READ()#12
      KEYBOARD CHR(26)+CHR(25)+EMP_ID
   ENDIF
   RELEASE WINDOW PICKLIST
   restore screen from tmpscr
   release screen tmpscr
   ON KEY LABEL F3 DO PICKBROW
   ACTIVATE WINDOW TW
RETURN

FUNCTION HILITE
   ln_xxx = ROW()
   ln_yyy = COL() - IIF(LAST()=19,ln_ShowLen-1,0)
   ln_fill2 = ln_yyy + ln_ShowLen -1
   IF lenmatch>0
      @ ln_xxx,ln_yyy fill to ln_xxx,ln_yyy+lenmatch-1 color g/n
   ENDIF
   @ ln_xxx,ln_yyy+lenmatch fill to ln_xxx,ln_fill2 color W+/r
RETURN .t.


PROCEDURE KeySeek
   ** Find & hilite a record in a BROWSE based upon
   ** user key strokes.
   ON KEY
   ln_UsrPres=INKEY()
   IF ln_UsrPres>31
      User_Chr = CHR(ln_UsrPres)
      Recnum = RECNO()
      IF lenMatch>0 .AND. (ln_UsrPres = 19 .OR. ln_UsrPres = 127)
            ** Backspace or Left arrow erases one character
            LenMatch = LEN(lc_Seek)-1
            lc_Seek = ;
               SUBS(lc_Seek,1,IIF(LenMatch>0,LenMatch,0))
            SEEK lc_Seek
      ELSE
         lc_Seek = lc_Seek + ;
            IIF(SEEK(lc_Seek + User_Chr), User_Chr,;
            IIF(SEEK(lc_Seek + UPPER(User_Chr)),;
            UPPER(User_Chr), IIF(SEEK(lc_Seek + ;
            LOWER(User_Chr)), LOWER(User_Chr),"")))
         IF .NOT. FOUND()
            ?? CHR(7)
            GOTO RecNum
         ENDIF
      ENDIF
      ln_UsrPres = 26 && Used to refresh the BROWSE display.
   ELSE
      ln_UsrPres=IIF(ln_UsrPres=26,31,IIF(ln_UsrPres=2,30,;
      IIF(ln_UsrPres=13,23,ln_UsrPres)))
      lc_Seek = ""
   ENDIF
   LenMatch = LEN(lc_Seek)
   ** Trap and re-key any key presses made during the 
   ** above's processing.
   lc_KeyStuf = CHR(INKEY())
   lc_BufStuf = lc_KeyStuf
   DO WHILE "" # lc_KeyStuf
      lc_KeyStuf = CHR(INKEY())
      lc_BufStuf = lc_BufStuf + lc_KeyStuf
   ENDDO
   KEYBOARD CHR(ln_UsrPres) + lc_BufStuf
   ON KEY DO KeyReSet
RETURN

PROCEDURE KeyReSet
   ** Reset the ON KEY trap to avoid recursion.
   ON KEY DO KeySeek
RETURN

