* Program Name: ExplodIt.prg
* Author: Richard H. Price

PROCEDURE ExplodIt
   ** Test Explosions!
   CLOSE DATABASES
   SET PROCEDURE TO PopPick6
   ** Initialize environmental variables
   STORE "" TO gc_Confirm,gc_Near, gc_Stat, gc_Bell, ;
   gc_Score, gc_Talk, gc_Esc, gc_Delete, gc_Exact, ;
   gc_Delim, gc_Head, gc_Type,;
   gc_NormClr, gc_HighClr, gc_MessClr, gc_TitlClr, ;
   gc_BoxClr, gc_InfClr, gc_FldClr, ;
   gc_ClrNorm, gc_ClrHigh, gc_ClrMess, gc_ClrTitl, ;
   gc_ClrBox, gc_ClrInf, gc_ClrFld
   STORE 0 to ln_TopRow, ln_TopCol, ln_BotRow, ln_BotCol,;
      ln_Speed, ln_RowOff, ln_ColOff
   STORE "" TO lc_NormClr, lc_BordClr, lc_ShadClr, ;
      lc_BordDef, lc_ExpType
   STORE .t. to ll_ClrScreen
   *-- Set Operating Environment
   DO Set_env
   DO BldScr
   DO CHECKIT
   *-- Reset environment
   DO Reset_env
   SET CURSOR ON
RETURN

PROCEDURE Set_env
   gc_Confirm   = SET("CONFIRM")
   gc_Near  = SET("NEAR")
   gc_Stat  = SET("STATUS")
   gc_Bell  = SET("BELL")
   gc_Score = SET("SCOREBOARD")
   gc_Talk  = SET("TALK")
   gc_Esc   = SET("ESCAPE")
   gc_Delete= SET("DELETE")
   gc_Exact = SET("EXACT")
   gc_Delim = SET("DELIMITERS")
   gc_Head  = SET("HEADING")
   DO PPSysClr WITH ;
   gc_ClrNorm, gc_ClrHigh, gc_ClrMess, gc_ClrTitl, ;
   gc_ClrBox, gc_ClrInf, gc_ClrFld
   IF ISCOLOR()
      gc_NormClr= "B/W"  && NORMAL
      gc_HighClr= "RG+/R"  && HIGHLIGHT
      gc_MessClr= "G+/N"  && MESSAGE
      gc_TitlClr= "R/W"  && TITLE
      gc_BoxClr = "W+/R"  && BOX
      gc_InfClr = "N/W"  && INFORMATION
      gc_FldClr = "W+/R"  && FIELD
   ELSE
      gc_NormClr= "N/W"
      gc_HighClr= "W+/N"
      gc_MessClr= "W/N"
      gc_TitlClr= "N/W"
      gc_BoxClr = "N/W"
      gc_InfClr = "W/N"
      gc_FldClr = "W+/N"
   ENDIF
   DO PPSetClr WITH ;
   gc_NormClr, gc_HighClr, gc_MessClr, gc_TitlClr, ;
   gc_BoxClr, gc_InfClr, gc_FldClr, ;
   gc_ClrNorm, gc_ClrHigh, gc_ClrMess, gc_ClrTitl, ;
   gc_ClrBox, gc_ClrInf, gc_ClrFld
   SET NEAR OFF
   SET BELL OFF
   SET STAT OFF
   SET SCORE OFF
   SET TALK OFF
   SET ESCAPE OFF
   SET DELETE OFF
   SET EXACT OFF
   SET CURSOR OFF
   SET DELIMITERS OFF
   ON KEY LABEL F1 ?? CHR(7)
   ON KEY LABEL F2 ?? CHR(7)
   ON KEY LABEL F3 DO PickList
   ON KEY LABEL F4 ?? CHR(7)
   ON KEY LABEL F5 ?? CHR(7)
   ON KEY LABEL F6 ?? CHR(7)
   ON KEY LABEL F7 ?? CHR(7)
   ON KEY LABEL F8 ?? CHR(7)
   ON KEY LABEL F9 ?? CHR(7)
   ON KEY LABEL F10 ?? CHR(7)
   ON ERROR
   DEFINE POPUP T FROM 10,30
   DEFINE BAR 1 OF T ;
      PROMPT "CH - Grow from Center Horizontal Out"
   DEFINE BAR 2 OF T ;
      PROMPT "HC - Shrink from Horizontal Sides to Center"
   DEFINE BAR 3 OF T ;
      PROMPT "EH - Grow from 2 Edges to Horizontal Center"
   DEFINE BAR 4 OF T ;
      PROMPT "HE - Shrink from Center to 2 Horizontal Edges"
   DEFINE BAR 5 OF T ;
      PROMPT "CV - Grow from Center Vertical Out"
   DEFINE BAR 6 OF T ;
      PROMPT "VC - Shrink from Vertical Edges to Center"
   DEFINE BAR 7 OF T ;
      PROMPT "EV - Grow from 2 Edges Vertical to Center"
   DEFINE BAR 8 OF T ;
      PROMPT "VE - Shrink from Vertical Center to 2 Edges"
   DEFINE BAR 9 OF T ;
      PROMPT "TL - Grow from Top Left to Bottom Right"
   DEFINE BAR 10 OF T ;
      PROMPT "LT - Shrink from Bottom Right"
   DEFINE BAR 11 OF T ;
      PROMPT "TR - Grow Top Right to Bottom Left"
   DEFINE BAR 12 OF T ;
      PROMPT "RT - Shrink from Bottom Left"
   DEFINE BAR 13 OF T ;
      PROMPT "BL - Grow Bottom Left to Upper Right"
   DEFINE BAR 14 OF T ;
      PROMPT "LB - Shrink from Upper Right"
   DEFINE BAR 15 OF T ;
      PROMPT "BR - Grow Bottom Right to Top Left"
   DEFINE BAR 16 OF ;
      T PROMPT "RB - Shrink from Upper Left"
   DEFINE BAR 17 OF T ;
      PROMPT "CE - Grow Center Explode Out"
   DEFINE BAR 18 OF T ;
      PROMPT "EC - Shrink to Center"
   DEFINE BAR 19 OF T ;
      PROMPT "TD - Grow Grow from Top Down"
   DEFINE BAR 20 OF T ;
      PROMPT "DT - Shrink from Bottom to Top"
   DEFINE BAR 21 OF T ;
      PROMPT "BU - Grow from Bottom to Top"
   DEFINE BAR 22 OF T ;
      PROMPT "UB - Shrink from Top to Bottom"
   DEFINE BAR 23 OF T ;
      PROMPT "LS - Grow from Left to Right"
   DEFINE BAR 24 OF T ;
      PROMPT "SL - Shrink from Right to Left"
   DEFINE BAR 25 OF T ;
      PROMPT "RS - Grow from Right to Left"
   DEFINE BAR 26 OF T ;
      PROMPT "SR - Shrink from Left to Right"
   ON SELECTION POPUP T BLANK DO PostPop
RETURN

PROCEDURE Reset_env
   ** Housekeeping
   SET CONFIRM &gc_Confirm
   SET NEAR &gc_Near
   SET BELL &gc_Bell
   SET TALK &gc_Talk
   SET STATUS &gc_Stat
   SET SCOREBOARD &gc_Score
   SET ESCAPE &gc_Esc
   SET DELETE &gc_Delete
   SET EXACT &gc_Exact
   SET DELIMITERS &gc_Delim
   SET HEADING &gc_Head
   DO PPSetClr WITH ;
   gc_ClrNorm, gc_ClrHigh, gc_ClrMess, gc_ClrTitl, ;
   gc_ClrBox, gc_ClrInf, gc_ClrFld, ;
   gc_NormClr, gc_HighClr, gc_MessClr, gc_TitlClr, ;
   gc_BoxClr, gc_InfClr, gc_FldClr
   ON KEY 
   RELEASE POPUP T
   CLOSE ALL
   ON ERROR
   CLEAR
   SET CURSOR ON
RETURN

PROCEDURE BldScr
   ACTI SCREEN
   CLEAR
   X=0
   lc_Backdrp = CHR(177)
   lc_PermClr = SET("ATTRIBUTES")
   SET COLOR OF NORMAL TO W+/R
   DO WHILE X<3
      @ X,0 TO X+3,79 lc_Backdrp
      sx=x
      X=X+6
      @ X,0 TO X+3,79 lc_Backdrp
      X=X+6
      @ X,0 TO X+3,79 lc_Backdrp
      X=X+6
      @ X,0 TO X+3,79 lc_Backdrp
      x=sx+1
   ENDDO
   @ 24,0 TO 24,79 lc_Backdrp
   SET COLOR OF NORMAL to &gc_NormClr
   * Explode Center Vertical With Shadow
   ln_TopRow = 1
   ln_TopCol = 19
   ln_BotRow = 3
   ln_BotCol = 60
   lc_NormClr= "N/W"
   lc_EnhClr = "W+/R"
   lc_BordClr= "N/W"
   lc_ShadClr= "W/N"
   lc_ExpType = "CV"
   ln_RowOff=1
   ln_ColOff=2
   lc_BordDef = "DOUBLE"
   ln_Speed = 3
   ll_ClrScreen = .t.
   DO EXPLODE WITH ln_TopRow, ln_TopCol, ln_BotRow, ;
      ln_BotCol, lc_NormClr, lc_BordClr, lc_ShadClr, ;
      lc_ExpType, ln_RowOff, ln_ColOff, lc_BordDef, ;
      ln_Speed, ll_ClrScreen
   @ 2,20 SAY  ;
   "     Procedure EXPLODE-Demo Screen      " COLOR r/w
   * Explode Top to Bottom With Shadow)
   ln_TopRow = 8
   ln_TopCol = 17
   ln_BotRow = 20
   ln_BotCol = 63
   lc_NormClr= "R/W"
   lc_BordClr= "R/W"
   lc_ExpType = "TD"
   ln_RowOff=0
   ln_ColOff=0
   DO EXPLODE WITH ln_TopRow, ln_TopCol, ln_BotRow, ;
      ln_BotCol, lc_NormClr, lc_BordClr, lc_ShadClr, ;
      lc_ExpType, ln_RowOff, ln_ColOff, lc_BordDef, ;
      ln_Speed, ll_ClrScreen
RETURN

PROCEDURE CHECKIT
   ON KEY LABEL F3 ACTIVATE POPUP t
   SET ESCAPE ON
   DO INITVAR
   lc_NormClr= "R/W    "
   lc_BordClr= "R/W    "
   lc_ShadClr= "W/N    "
   lc_BordDef = "DOUBLE"
   DEFINE WINDOW WHATNEXT FROM 2,23 TO 6,55 ;
      COLOR W+/RB,,WG+/RB
   SAVE SCREEN TO BegScrn
   DO WHILE READ()#12
      IF ll_ClrScreen
         SAVE SCREEN TO T
         ?? chr(7)
         ACTIVATE WINDOW WHATNEXT
         @ 0,1 say "    Press <ESC> to Reset     "
         @ 1,1 say "          -*-OR-*-           "
         @ 2,1 say "Press any key to continue...."
         I=INKEY(0)
         DEACTIVATE WINDOW WHATNEXT
         IF I=27
            DO INITVAR
            RESTORE SCREEN FROM BEGSCRN
         ELSE
            RESTORE SCREEN FROM T
         ENDIF
         CLEAR GETS
         RELEASE SCREEN T
         DO PAINTSCR
      ENDIF
      SET CURS ON
      READ SAVE
      SET CURS OFF
      IF READ()#12
         DO EXPLODE WITH ln_topRow, ln_topCol, ln_BotRow, ;
            ln_BotCol, lc_NormClr, lc_BordClr, lc_ShadClr,;
            lc_ExpType, ln_RowOff, ln_ColOff, lc_BordDef,;
            ln_Speed, ll_ClrScreen
      ENDIF
   ENDDO
   CLEAR GETS
   RELEASE SCREEN BERSCRN
   RELEASE WINDOW WHATNEXT
RETURN

PROCEDURE POSTPOP
   popch=LEFT(PROMPT(),2)
   IF VARREAD()="LC_EXPTYPE"
      KEYBOARD CHR(26)+CHR(25)+POPCH
   ENDIF
   DEACTIVATE POPUP
RETURN

PROCEDURE PAINTSCR
   @ ln_TopRow,ln_TopCol CLEAR TO ln_BotRow, ln_BotCol
   SET BORDER TO &lc_BordDef
   @ ln_TopRow,ln_TopCol TO ln_BotRow, ln_BotCol ;
      COLOR &lc_BordClr
   @  9,20 say "Exlode Type  : " GET lc_ExpType ;
      PICT "!!" MESSAGE "Press F3 for a Pick List"
   @ 10,20 SAY "Normal Color : " GET lc_NormClr ;
      FUNC "!" MESSAGE ""
   @ 11,20 say "Border Color : " GET lc_BordClr ;
      FUNC "!"
   @ 12,20 say "Shadow Color : " GET lc_ShadClr ;
      FUNC "!"
   @ 13,20 say "Border Def   : " GET lc_BordDef ;
      Pict "@M DOUBLE,SINGLE,PANEL ,NONE  " ;
      MESSAGE "Press SPACE bar to toggle choices."
   @ 14,20 say "Speed Factor : " GET ln_Speed ;
      PICT "99.99"
   @ 15,20 say "Clear Screen : " GET ll_ClrScreen ;
      PICT "Y"
   @ 16,20 say "Shadow RowOff: " GET ln_RowOff ;
      PICT "99"
   @ 17,20 say "Shadow ColOff: " GET ln_ColOff ;
      PICT "99"
   @ 18,20 say "From row,col : " GET ln_topRow ;
      PICT "99"
   @ 18,col() + 1 say "," GET ln_topCol PICT "99"
   @ 19,20 SAY "To row,col   : " GET ln_BotRow ;
      PICT "99"
   @ 19,col() + 1 say "," GET ln_BotCol PICT "99"
RETURN

PROCEDURE InitVar
   ln_topRow = 8
   ln_topCol = 17
   ln_BotRow = 20
   ln_BotCol = 63
   ln_Speed = 3
   ll_ClrScreen = .t.
   ln_RowOff = 1
   ln_ColOff = 2
   lc_expType = "TD"
RETURN

PROCEDURE PPSysClr
   ** Save current system color settings
   PARAMETERS lc_ClrN, lc_ClrH, lc_ClrM, lc_ClrT, lc_ClrB, ;
              lc_ClrI, lc_ClrF
   lc_ClrF = SET("ATTRIBUTES")
   lc_ClrN = LTRIM(TRIM(LEFT(lc_ClrF, AT(",", lc_ClrF) -1)))
   lc_ClrF = RIGHT(lc_ClrF,LEN(lc_ClrF)-AT(",",lc_ClrF))
   lc_ClrH = TRIM(LEFT(lc_ClrF, AT(",", lc_ClrF) -1))
   lc_ClrF = RIGHT(lc_ClrF, LEN(lc_ClrF)-AT("&",lc_ClrF)-2)
   lc_ClrM = TRIM(LEFT(lc_ClrF, AT(",", lc_ClrF) -1))
   lc_ClrF = RIGHT(lc_ClrF,LEN(lc_ClrF)-AT(",",lc_ClrF))
   lc_ClrT = TRIM(LEFT(lc_ClrF, AT(",", lc_ClrF) -1))
   lc_ClrF = RIGHT(lc_ClrF,LEN(lc_ClrF)-AT(",",lc_ClrF))
   lc_ClrB = TRIM(LEFT(lc_ClrF, AT(",", lc_ClrF) -1))
   lc_ClrF = RIGHT(lc_ClrF,LEN(lc_ClrF)-AT(",",lc_ClrF))
   lc_ClrI = TRIM(LEFT(lc_ClrF, AT(",", lc_ClrF) -1))
   lc_ClrF = RIGHT(lc_ClrF,LEN(lc_ClrF)-AT(",",lc_ClrF))
RETURN

PROCEDURE PPSetClr
   PARAMETERS lc_NormUse, lc_HighUse, lc_MessUse, ;
      lc_TitlUse, lc_BoxUse, lc_InfoUse, lc_FldUse,;
      lc_NormIs, lc_HighIs, lc_MessIs, lc_TitlIs, lc_BoxIs,;
      lc_InfoIs, lc_FldIs
   IF lc_NormUse # lc_NormIs 
      SET COLOR OF NORMAL TO &lc_NormUse
   ENDIF
   IF lc_HighUse # lc_HighIs
      SET COLOR OF HIGHLIGHT TO &lc_HighUse
   ENDIF
   IF lc_MessUse #lc_MessIs
      SET COLOR OF MESSAGES TO &lc_MessUse
   ENDIF
   IF lc_TitlUse # lc_TitlIs
      SET COLOR OF TITLES TO &lc_TitlUse
   ENDIF
   IF lc_BoxUse # lc_BoxIs
      SET COLOR OF BOX TO &lc_BoxUse
   ENDIF
   IF lc_InfoUse # lc_InfoIs
      SET COLOR OF INFORMATION TO &lc_InfoUse
   ENDIF
   IF lc_FldUse # lc_FldIs
      SET COLOR OF FIELDS TO &lc_FldUse
   ENDIF
RETURN

