SET TALK OFF
USE mkt_prc IN 1 ORDER TAG acct_date ALIAS dbf_mkt
scrnmax=24            && Bottom Row of screen..Use 42 for EGA43
macct="45005"         && Use your own procedure to find acct to plot
DO plot
RETURN

PROCEDURE plot
SAVE SCREEN TO Graph_Win
Graph_Stat=SET("ATTRIBUTES")
C_Min=5               && screen column for vertical axis
C_Max=75              && screen column for end of horizontal axis
R_Top=0               && screen row for top of vertical axis
R_Btm=ScrnMax-4       && screen row for bottom of vertical axis
R_Inc=4               && # rows between vertical axis labels
R_Ticks=(R_Btm-R_Top+1)/R_Inc     && # of vertical axis labels
SELECT dbf_mkt
SET ORDER TO acct_date
SEEK macct
IF acct=macct
  SCAN REST WHILE acct=macct     && find last record to plot
  ENDSCAN
  IF acct<>macct
    SKIP -1
  ENDIF
  Rcd_End=RECNO()
  Date_End=date
  C_End=C_Min
  c=C_Max
  d1=EOM(DATE(),-1)       && far right horizontal axis is end of last month
  DO WHILE acct=macct        && find first record to plot that will
    d2=date                  && find within horizontal axis limits
    ss=c+(YEAR(d2)-YEAR(d1))*12+MONTH(d2)-MONTH(d1)
    IF ss <= C_Min       && if date value of record is less then value
      EXIT               && of far left horizontal axis, then quit
    ENDIF
    c=ss
    C_End=MAX(C_End,c)
    d1=d2
    SKIP -1
  ENDDO
  SKIP
  Rcd_Beg=RECNO()        && first record to be plotted
  Date_Beg=d1
  C_Beg=c
  CALCULATE REST CNT(),AVG(mkt_pr),MAX(mkt_pr),MIN(mkt_pr) ;
    WHILE acct=macct TO Rcd_Cnt,Y_Avg,Y_Max,Y_Min
  SKIP -1
  Y_Sprd=ABS(Y_Max-Y_Min)
  R_Fctr=(R_Btm-R_Top)/Y_Sprd    && convert price to screen row
  t1=LOG10(Y_Sprd/R_Ticks)
  IF t1<0                        && amount to increment tick label
    Y_Inc=ROUND((Y_Sprd/R_Ticks)*10^INT(ABS(t1)+1),0)/(10^INT(ABS(t1)+1))
  ELSE
    Y_Inc=ROUND(Y_Sprd/R_Ticks,0)
  ENDIF
  t1=LOG10(Y_Max)
  IF t1>=0                      && determine picture for tick label
    pic=REPLICATE("9",INT(t1+1))
  ELSE
    pic="9"
  ENDIF
  t1=LOG10(Y_Inc)
  IF t1<0
    pic=pic+"."+REPLICATE("9",INT(ABS(t1)+1))
  ENDIF
  IF Y_Min<0
    pic="9"+pic
  ENDIF
  Y_0=IIF(Y_Min>=0,Y_Min,IIF(Y_Max<=0,Y_Max,0))    && value of y @ horiz axis
  R_0=IIF(Y_Min>=0,R_Btm,IIF(Y_Max<=0,R_top,R_Top+ROUND(Y_Max*R_Fctr,0)))
  SET COLOR TO W+/N                             && screen row at horiz axis
  CLEAR
  @ R_0,C_Min TO R_0,C_Max          && draw horiz axis
  @ R_Top,C_Min TO R_Btm,C_Min      && draw vert axis
  r=R_0
  y=Y_0
  DO WHILE y<=Y_Max
    @ r,C_Min-4 SAY y PICTURE pic   && draw vertical tick labels from 0 up
    @ $,C_Min SAY ""
    y=y+Y_Inc
    r=r-R_Inc
  ENDDO
  r=R_0+R_Inc
  y=Y_0-Y_Inc
  DO WHILE y>=Y_Min                 && draw vertical tick labels from 0 down
    @ r,C_Min-4 SAY y PICTURE pic
    @ $,C_Min SAY ""
    y=y-Y_Inc
    r=r+R_Inc
  ENDDO
  c=C_Max
  d1=EOM(DATE(),-1)
  GOTO Rcd_End
  ctr=Rcd_Cnt
  DO WHILE ctr>0                    && draw bar graph of price values
    d2=date
    c=c+(YEAR(d2)-YEAR(d1))*12+MONTH(d2)-MONTH(d1)
    IF mkt_pr>=0
      @ Y_Coord(mkt_pr),c TO R_0,c
    ELSE
      @ R_0,c TO Y_Coord(mkt_pr),c
    ENDIF
    d1=d2
    SKIP -1
    ctr=ctr-1
  ENDDO
  @ Y_Coord(Y_Avg),C_Beg TO Y_Coord(Y_Avg),C_End   && draw average line
  Mkt_Avg=Y_Avg
  @ scrnmax-2,10 SAY Date_Beg
  @ $,$+2 SAY Date_End
  @ $,$+2 SAY "Average Price ="
  @ $,$+1 SAY Mkt_Avg PICTURE "@B 999,999.999"
  ?
  WAIT
ENDIF
SET COLOR TO &Graph_Stat.
RESTORE SCREEN FROM Graph_Win
RETURN

FUNCTION Y_Coord
PARAMETER Y_Value
RETURN ROUND(R_0-(Y_Value-Y_0)*R_Fctr,0)


FUNCTION EOM
PARAMETERS date_now,months
PRIVATE mdate,yr,mo,mo_use,yr_use
IF months>=0
  yr_use=YEAR(date_now)+INT(months/12)
  mo_use=MONTH(date_now)+MOD(months,12)
ELSE
  yr=YEAR(date_now)+INT(months/12)
  mo=MONTH(date_now)-MOD(ABS(months),12)
  mo_use=IIF(mo<1,mo+12,mo)
  yr_use=IIF(mo<1,yr-1,yr)
ENDIF
RETURN CTOD(STR(mo_use+1,2)+'/01/'+STR(yr_use,4))-1

