/*
 * File......: RBPINSTL.PRG
 * Author....: Royce D. Bacon, RDB Systems, CIS:70042,1001
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 *
 * This is an original work by Royce Bacon and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */
 *
 * Compile with /W/N /DPROGRAM to generate demo program that provides
 *         ability to edit, list, install, display PRINTERS.DBF data.
 * Compile with /W/N to generate functions only
 *
 * When linking must include SCROLBAR.OBJ from SCROLBAR.PRG in Clipper
 *      5.0 samples or a library containing the equivalent.
 *
 
STATIC PTRCODES[26]
MEMVAR getlist, acolors, adbstruc, atheirstru
MEMVAR m_name, m_setup, m_confrmd
MEMVAR m_reset, m_6lpi,  m_8lpi 
MEMVAR m_10cpi, m_12cpi, m_compron 
MEMVAR m_comprof, m_dblon, m_dbloff
MEMVAR m_bdon, m_bdoff, m_ulon 
MEMVAR m_uloff, m_iton, m_itoff 
MEMVAR m_66lpp, m_51lpp, m_88lpp 
MEMVAR m_68lpp, m_prtrt, m_lndscp 
MEMVAR m_skprfon, m_skprfof
FIELD pr_name, pr_setup, pr_reset, pr_6lpi, pr_8lpi IN printers
FIELD pr_10cpi, pr_12cpi, pr_compron, pr_comprof, pr_dblon IN printers
FIELD pr_dbloff, pr_bdon, pr_bdoff, pr_ulon, pr_uloff IN printers
FIELD pr_iton, pr_itoff, pr_66lpp, pr_51lpp, pr_88lpp, pr_68lpp IN printers
FIELD pr_prtrt, pr_lndscp, pr_skprfon, pr_skprfof, pr_confrmd IN printers

// Color array subscripts
* NORMAL PANELS
#define c_bar   1           // ACTION BAR
#define c_panel   2         // DISPLAY PANEL
#define c_pnlget   3        // PANEL DURING GETS
#define c_fkeys    4        // FUNCTION KEYS
#define c_msgnote   5       // NOTIFICATION MSGS
#define c_msgwarn   6       // WARNING MSGS
#define c_msgcritl   7      // CRITICAL MSGS
*  HELP PANELS
#define c_hlpbar   8        // ACTION BAR
#define c_hlppnl   9        // DISPLAY PANEL
#define c_hlpget   10       // PANEL DURING GETS
#define c_hlpfkeys   11     // FUNCTION KEYS
#define c_hlpnote   12      // NOTIFICATION MSGS
#define c_hlpwarn   13      // WARNING MSGS
#define c_hlpcritl   14     // CRITICAL MSGS
*  POP UP WINDOWS
#define c_popbar   15       // ACTION BAR
#define c_poppnl   16       // DISPLAY PANEL
#define c_popget   17       // PANEL DURING GETS
#define c_popfkeys   18     // FUNCTION KEYS
#define c_popnote   19      // NOTIFICATION MSGS
#define c_popwarn   20      // WARNING MSGS
#define c_popcritl   21     // CRITICAL MSGS
#define c_numclrs   21      // NUMBER OF COLORS

#include 'INKEY.CH'
#include 'FTPINSTL.CH'
#include 'DBSTRUCT.CH'

#ifdef PROGRAM
   PROCEDURE PTRMAINT

   LOCAL nmsel_1, goon, lok, inputok, morecodes, ptrcode, ptrname
   LOCAL fldnames[26], ni
   PRIVATE acolors[c_numclrs]
           
   SET FUNCTION 3 TO CHR(27)    && F3 = Esc

   _FTClrinit(@acolors, Iscolor())    // Setup color array
   USE printers NEW SHARED         // Use the PRINTERS database
   INDEX ON UPPER(pr_name) TO PRINTERS      // Index on printer name
   PRIVATE adbstruc := printers->(DBSTRUCT())
   FOR ni = 1 TO 26
       fldnames[ni] := adbstruc[ni, DBS_NAME]
   NEXT
   goon := .T.
   SET MESSAGE TO 6
   DO WHILE goon
      Setcolor(acolors[c_panel])
      CLEAR
      Setcolor(acolors[c_bar])
      @ 0,0 CLEAR TO 2,79
      @ 1,4  PROMPT 'Add Printer' MESSAGE 'Add a printer to database.'
      @ 1,17 PROMPT 'Edit Printer' MESSAGE 'Edit printer data.'
      @ 1,31 PROMPT 'List Printers' MESSAGE 'List printer database.'
      @ 1,46 PROMPT 'Install Printer' MESSAGE 'Install a printer.'
      @ 1,63 PROMPT 'Display Codes' MESSAGE 'Display printer control codes.'
      @ 1,77 PROMPT 'Xit' MESSAGE 'Exit printer edit program.'
      @ 2,0 TO 2,79
      Setcolor(acolors[c_panel])
      @ 8,1 SAY 'To move between actions use the ' + CHR(27) + ' and ' + CHR(26) + ' keys.'
      @ 9,1 SAY 'To select an action press the first letter of the action or'
      @ 10,1 SAY '   press the Enter key when the desired action is highlighted'
      @ 12,1 SAY 'To move between choices in a pull-down menu use the ' + CHR(25) + ' and ' + CHR(24) + ' keys or'
      @ 13,1 SAY '   press the first letter of the choice'
      @ 14,1 SAY 'To select a choice in a pull-down menu press Enter when the choice is'
      @ 15,1 SAY '   highlighted.'
   
      Setcolor(acolors[c_fkeys])
      @ 24,2 SAY 'Esc=Cancel  F3=Exit'

      Setcolor(acolors[c_bar])
      MENU TO nmsel_1
      DO CASE
      CASE nmsel_1 == 1         // Add a printer
           m_name := SPACE (25)
           m_setup := SPACE(60)
           m_reset := m_6lpi :=  m_8lpi := SPACE(40)
           m_10cpi := m_12cpi := m_compron := SPACE(40)
           m_comprof := m_dblon := m_dbloff := SPACE(40)
           m_bdon := m_bdoff := m_ulon := SPACE(40)
           m_uloff := m_iton := m_itoff := SPACE(40)
           m_66lpp := m_51lpp := m_88lpp := SPACE(40)
           m_68lpp := m_prtrt := m_lndscp := SPACE(40)
           m_skprfon := m_skprfof := SPACE(40)
           m_confrmd := .F.
           inputok := _FTGetPtr()             // Get input data
     
           IF inputok                      // Was input OK?
              SELECT printers
              SEEK m_name                  // Check for duplicate printer
              IF !FOUND()                  // Not dup
                 APPEND BLANK              // Add new printer
                 REPLACE pr_name WITH m_name
                 _FTReplPtr()
              ELSE
                 TONE(261.7, 9)            // Sound bell
                 FT_Dispmsg( {{ 'This printer name is already present!' , ;
                                'Press any key to continue.' }  , ;
                               { acolors[c_msgcritl], acolors[c_msgcritl], ;
                                 acolors[c_msgcritl] } }, 'C' )
              ENDIF
           ENDIF
      CASE nmsel_1 == 2       // Edit printer
           lok := .T.
           DO WHILE lok
              // Select and edit printer
              lok := _FTPbrowse({||_FTUpdtPtr()}, ;
                             { acolors[c_hlppnl], acolors[c_hlpbar] }, ;
                             4, 5, 23, 75)
           ENDDO                             

      CASE nmsel_1 == 3             // List printer information
           _FTListPtr()
      CASE nmsel_1 == 4             // Install a printer
           _FTInstPtr()
      CASE nmsel_1 == 5             // Display codes
           ptrname := FT_Ptrsel()       // Select the printer
           IF ptrname <> NIL
              morecodes := .T.
              DO WHILE morecodes
                 Setcolor(acolors[c_poppnl])
                 _FTShdwbox(2, 61, 23, 79, acolors[c_poppnl])
                 ptrcode := ACHOICE(3, 63, 22, 78, fldnames, .T.)
                 IF ptrcode > 0
                    FT_Dispmsg( {{ TRIM(fldnames[ptrcode]) + '=' + ;
                            FT_Codeesc(FT_Ptrcode(ptrcode)), ;
                            'Press any key to continue.' }, ;
                       { acolors[c_msgcritl], acolors[c_msgcritl], acolors[c_msgcritl] } }, ;
                            'C' )
                 ELSE
                    morecodes := .F.
                 ENDIF                            
              ENDDO
           ENDIF
                    
      OTHERWISE
           goon := .F.
      ENDCASE
   ENDDO

   ERASE printers.ntx       // Delete index file until next time
   RETURN

   ***************************************************************
   STATIC FUNCTION _FTReplPtr()
   IF Rlock()
      REPLACE pr_name      WITH m_name
      REPLACE pr_setup     WITH FT_Esccode(m_setup)
      REPLACE pr_reset     WITH FT_Esccode(m_reset)
      REPLACE pr_6lpi      WITH FT_Esccode(m_6lpi)
      REPLACE pr_8lpi      WITH FT_Esccode(m_8lpi)
      REPLACE pr_10cpi     WITH FT_Esccode(m_10cpi)
      REPLACE pr_12cpi     WITH FT_Esccode(m_12cpi)
      REPLACE pr_compron   WITH FT_Esccode(m_compron)
      REPLACE pr_comprof   WITH FT_Esccode(m_comprof)
      REPLACE pr_dblon     WITH FT_Esccode(m_dblon)
      REPLACE pr_dbloff    WITH FT_Esccode(m_dbloff)
      REPLACE pr_bdon      WITH FT_Esccode(m_bdon)
      REPLACE pr_bdoff     WITH FT_Esccode(m_bdoff)
      REPLACE pr_ulon      WITH FT_Esccode(m_ulon)
      REPLACE pr_uloff     WITH FT_Esccode(m_uloff)
      REPLACE pr_iton      WITH FT_Esccode(m_iton)
      REPLACE pr_itoff     WITH FT_Esccode(m_itoff)
      REPLACE pr_66lpp     WITH FT_Esccode(m_66lpp)
      REPLACE pr_51lpp     WITH FT_Esccode(m_51lpp)
      REPLACE pr_88lpp     WITH FT_Esccode(m_88lpp)
      REPLACE pr_68lpp     WITH FT_Esccode(m_68lpp)
      REPLACE pr_prtrt     WITH FT_Esccode(m_prtrt)
      REPLACE pr_lndscp    WITH FT_Esccode(m_lndscp)
      REPLACE pr_skprfon   WITH FT_Esccode(m_skprfon)
      REPLACE pr_skprfof   WITH FT_Esccode(m_skprfof)
      REPLACE pr_confrmd   WITH m_confrmd
      RETURN(.T.)
   ENDIF
   RETURN(.F.)


   ************************************************************
   STATIC FUNCTION _FTGetPtr()
   LOCAL nkey
   Setcolor(acolors[c_panel])
   @  3,0 CLEAR
   @  3,5 SAY 'Printer Name ' GET m_name
   @  4,5 SAY 'Setup........' GET m_setup
   @  5,5 SAY 'Reset........' GET m_reset
   @  6,5 SAY '6 Lines/Inch ' GET m_6lpi
   @  7,5 SAY '8 Lines/Inch ' GET m_8lpi
   @  8,5 SAY '10 Chars/Inch' GET m_10cpi
   @  9,5 SAY '12 Chars/Inch' GET m_12cpi
   @ 10,5 SAY 'Compress On  ' GET m_compron
   @ 11,5 SAY 'Compress Off ' GET m_comprof
   @ 12,5 SAY 'Double On....' GET m_dblon
   @ 13,5 SAY 'Double Off...' GET m_dbloff
   @ 14,5 SAY 'Bold On......' GET m_bdon
   @ 15,5 SAY 'Bold Off.....' GET m_bdoff
   @ 16,5 SAY 'Underline On ' GET m_ulon
   @ 17,5 SAY 'Underline Off' GET m_uloff
   @ 18,5 SAY 'Italics On...' GET m_iton
   @ 19,5 SAY 'Italics Off..' GET m_itoff

   @ 21,5 SAY 'Control characters may be entered as \nnn, regular characters'
   @ 22,5 SAY 'may be entered in normal format, e.g. \027E'

   READ

   @  4,0 CLEAR TO 19,79
   @  4,5 SAY '66 Lines/Page' GET m_66lpp
   @  5,5 SAY '51 Lines/Page' GET m_51lpp
   @  6,5 SAY '88 Lines/Page' GET m_88lpp
   @  7,5 SAY '68 Lines/Page' GET m_68lpp
   @  8,5 SAY 'Portrait.....' GET m_prtrt
   @  9,5 SAY 'Landscape....' GET m_lndscp
   @ 10,5 SAY 'Skip Perf On.' GET m_skprfon
   @ 11,5 SAY 'Skip Perf Off' GET m_skprfof
   @ 12,5 SAY 'Confirmed OK ' GET m_confrmd PICTURE 'Y'

   READ
   nkey := LastKey()
   IF nkey == K_ESC
      RETURN(.F.)
   ENDIF
   RETURN(.T.)


   ********************************************************************
   STATIC FUNCTION _FTListPtr()
   LOCAL lc := 66, page_cnt := 0, col, line, nfld, maxflds, label
   LOCAL fld_name := { 'NAME', 'SETUP', 'RESET', '6 LPI', '8LPI', '10 CPI', ;
          '12 CPI', 'COMPRESSED ON', 'COMPRESSED OFF', 'DOUBLE WIDE ON', ;
          'DOUBLE WIDE OFF', 'BOLD ON', 'BOLD OFF', 'UNDERLINE ON', ;
          'UNDERLINE OFF','ITALICS ON', 'ITALICS OFF', '66 LPP', ;
          '51 LPP', '88 LPP', '68 LPP', 'PORTRAIT', 'LANDSCAPE', ;
          'SKIP PERF ON', 'SKIP PERF OFF' }

   Setcolor(acolors[c_msgnote])          
   _FTShdwbox(10, 10, 15, 70, acolors[c_msgnote])
   @ 12,22 SAY 'Listing Printer Control Database...'
   @ 13,28 SAY 'Press Esc to interrupt.'
   SET DEVICE TO PRINTER
   SELECT printers
   GO TOP
   DO WHILE !EOF()
      IF lc > 55
         EJECT
         @ 6,5 SAY DATE()
         @ 6,24 SAY 'PRINTER CONTROL DATABASE LISTING'
         @ 6,70 SAY 'Page'
         page_cnt++
         @ 6,75 SAY page_cnt PICTURE '999'
         lc := 8
      ENDIF
      @ lc,5 SAY pr_name
      @ lc,40 SAY 'Confirmed Correct & Complete?'
      @ lc,70 SAY pr_confrmd PICTURE 'Y'
      lc++
      col := 10
      line := ''
      maxflds := FCOUNT() - 1
      FOR nfld := 2 TO maxflds
         label := fld_name[nfld] + '=' + FT_Codeesc(TRIM(FIELDGET(nfld))) + ', '
         IF col + LEN(label) > 80
            @ lc,10 SAY line
            lc++
            col := 10
            line := ''
         ENDIF
         line += label
         col += LEN(label)
      NEXT
      @ lc,10 SAY line
      lc++

      SKIP
      
      IF INKEY() == K_ESC
         GO BOTTOM
         SKIP
         lc++
         @ lc,24 SAY '***** PRINTING INTERRUPTED *****'
      ENDIF
   ENDDO

   EJECT   
   SET DEVICE TO SCREEN
   RETURN(NIL)

   ********************************************************************
   STATIC FUNCTION _FTInstPtr()
   LOCAL afldnames[0], cdbname := SPACE(8), nfld, lc, prflds[0], dbflds[0]
   LOCAL fldformat := 'C', nodbname := .T., nkey, filename
   LOCAL prfld1, prfld2, prfld3, prfld4, prfld5, dbfld, lok

   Setcolor(acolors[c_panel])
   @ 3,0 CLEAR
   DO WHILE nodbname
      @ 4,5 SAY 'Name of database to receive printer control characters' GET cdbname
      READ
      nkey := LASTKEY()
      IF nkey == K_ESC .OR. cdbname == SPACE(8)
         RETURN(.F.)
      ENDIF
      filename := TRIM(cdbname) + '.DBF'
      IF FILE(filename)
         nodbname := .F.
      ELSE
         TONE(261.7, 9)                   // Sound bell tone
         FT_Dispmsg({ { 'Database not found!', ;
                     'Press any key to reenter.' }  , ;
                   { acolors[c_msgcritl], acolors[c_msgcritl], acolors[c_msgcritl] } }, ;
                   'C')
      ENDIF
   ENDDO         

   USE (cdbname) NEW SHARED READONLY    // Use their database
   PRIVATE atheirstru := (DBSTRUCT())   // Save it's structure
   USE                                  // Close their database

   @ 6,5 SAY ' DATABASE  FORMAT'
   @ 7,5 SAY '   FIELD     C/D  ************* PRINTERS DATABASE FIELD(S) *************'
   @ 8,5 SAY '========== ====== ========== ========== ========== ========== =========='
   FOR nfld = 1 TO 14
       dbfld := prfld1 := prfld2 := prfld3 := prfld4 := prfld5 := SPACE(10)
       lc := 8 + nfld
       @ lc,1  SAY STR(nfld, 2) + '.'
       @ lc,5  GET dbfld VALID _FTValdbfl(dbfld)
       @ lc,18 GET fldformat VALID _FTValfrmt(fldformat)
       @ lc,23 GET prfld1 VALID _FTValprfl(prfld1)
       @ lc,34 GET prfld2 VALID _FTValprfl(prfld2)
       @ lc,45 GET prfld3 VALID _FTValprfl(prfld3)
       @ lc,56 GET prfld4 VALID _FTValprfl(prfld4)
       @ lc,67 GET prfld5 VALID _FTValprfl(prfld5)
       READ
       nkey := LASTKEY()
       IF nkey == K_ESC .OR. dbfld == SPACE(10)
          nfld := 14
          LOOP
       ENDIF
       ASIZE(prflds, 0)
       IF prfld1 <> SPACE(10)
          AADD(prflds, TRIM(prfld1))
       ENDIF
       IF prfld2 <> SPACE(10)
          AADD(prflds, TRIM(prfld2))
       ENDIF
       IF prfld3 <> SPACE(10)
          AADD(prflds, TRIM(prfld3))
       ENDIF
       IF prfld4 <> SPACE(10)
          AADD(prflds, TRIM(prfld4))
       ENDIF
       IF prfld5 <> SPACE(10)
          AADD(prflds, TRIM(prfld5))
       ENDIF
       AADD(afldnames, { TRIM(dbfld), fldformat, prflds })
           
   NEXT

   lok := FT_Pinstl(cdbname, afldnames, ;
                    { acolors[c_hlppnl], acolors[c_hlpbar] } )

   RETURN(NIL)
   
   ********************************************************************
   STATIC FUNCTION _FTUpdtPtr()
   LOCAL lok
   m_name      := pr_name
   m_setup     := FT_Codeesc(pr_setup)
   m_reset     := FT_Codeesc(pr_reset)
   m_6lpi      := FT_Codeesc(pr_6lpi)
   m_8lpi      := FT_Codeesc(pr_8lpi)
   m_10cpi     := FT_Codeesc(pr_10cpi)
   m_12cpi     := FT_Codeesc(pr_12cpi)
   m_compron   := FT_Codeesc(pr_compron)
   m_comprof   := FT_Codeesc(pr_comprof)
   m_dblon     := FT_Codeesc(pr_dblon)
   m_dbloff    := FT_Codeesc(pr_dbloff)
   m_bdon      := FT_Codeesc(pr_bdon)
   m_bdoff     := FT_Codeesc(pr_bdoff)
   m_ulon      := FT_Codeesc(pr_ulon)
   m_uloff     := FT_Codeesc(pr_uloff)
   m_iton      := FT_Codeesc(pr_iton)
   m_itoff     := FT_Codeesc(pr_itoff)
   m_66lpp     := FT_Codeesc(pr_66lpp)
   m_51lpp     := FT_Codeesc(pr_51lpp)
   m_88lpp     := FT_Codeesc(pr_88lpp)
   m_68lpp     := FT_Codeesc(pr_68lpp)
   m_prtrt     := FT_Codeesc(pr_prtrt)
   m_lndscp    := FT_Codeesc(pr_lndscp)
   m_skprfon   := FT_Codeesc(pr_skprfon)
   m_skprfof   := FT_Codeesc(pr_skprfof)
   m_confrmd   := pr_confrmd
   
   lok := _FTGetPtr()          // Get new values

   IF lok
      _FTReplPtr()             // Replace with new values
   ENDIF
   RETURN(lok)

   ********************** FUNCTION _FTClrinit *****************************
   STATIC FUNCTION _FTClrinit(acolors, usecolor)
   **********
   *
   * PURPOSE: Defines and sets color variables to normal IBM SAA colors
   * PARAMETERS:
   *    acolors - array to receive the color settings - must be passed by
   *              reference
   *    usecolor - logical variable indicating if we should use
   *               color mode - .T. = use color, .F. = use black & white
   * RETURN VALUE:
   *    The colors are placed in the acolors array
   *
   ***********

   IF usecolor
      *  COLOR DISPLAYS
      *  NORMAL PANELS
      acolors[c_bar] := 'N/BG,BG/N,,,BG/N' && ACTION BAR
      acolors[c_panel] := 'B/W,W/GR,,,W/N' && DISPLAY PANEL
      acolors[c_pnlget] := 'N/W,W/GR,,,W/N' && PANEL DURING GETS
      acolors[c_fkeys] := 'N/W,W/N'        && FUNCTION KEYS
      acolors[c_msgnote] := 'N/W,W/N'      && NOTIFICATION MSGS
      acolors[c_msgwarn] := 'N/GR+,GR+/N'  && WARNING MSGS
      acolors[c_msgcritl] := 'W/R,R/W'     && CRITICAL MSGS
      *  HELP PANELS
      acolors[c_hlpbar] := 'N/BG,BG/N,,,N/BG' && ACTION BAR
      acolors[c_hlppnl] := 'BG/B,B/GR+,,,B/BG' && DISPLAY PANEL
      acolors[c_hlpget] := 'W/B,B/GR+,,,B/W' && PANEL DURING GETS
      acolors[c_hlpfkeys] := 'W/B,B/W'     && FUNCTION KEYS
      acolors[c_hlpnote] := 'N/W,W/N'      && NOTIFICATION MSGS
      acolors[c_hlpwarn] := 'N/GR+,GR+/N'  && WARNING MSGS
      acolors[c_hlpcritl] := 'W/R,R/W'     && CRITICAL MSGS
      *  POP UP WINDOWS
      acolors[c_popbar] := 'N/W,W/N,,,N/W' && ACTION BAR
      acolors[c_poppnl] := 'B/BG,BG/CR+,,,BG/B' && DISPLAY PANEL
      acolors[c_popget] := 'N/BG,BG/CR+,,,BG/N' && PANEL DURING GETS
      acolors[c_popfkeys] := 'N/BG,BG/N'   && FUNCTION KEYS
      acolors[c_popnote] := 'N/W,W/N'      && NOTIFICATION MSGS
      acolors[c_popwarn] := 'N/GR+,GR+/N'  && WARNING MSGS
      acolors[c_popcritl] := 'W/R,R/W'     && CRITICAL MSGS
   ELSE
      *  MONOCHROME DISPLAYS
      *  NORMAL PANELS
      acolors[c_bar] := 'N/W,W/N,,,N/W'    && ACTION BAR
      acolors[c_panel] := 'W/N,N/W+,,,N/W' && DISPLAY PANEL
      acolors[c_pnlget] := 'W/N,N/W+,,,N/W' && PANEL DURING GETS
      acolors[c_fkeys] := 'W/N,N/W'        && FUNCTION KEYS
      acolors[c_msgnote] := 'W/N,N/W'      && NOTIFICATION MSGS
      acolors[c_msgwarn] := 'W+/N,N/W+'    && WARNING MSGS
      acolors[c_msgcritl] := 'N/W,W/N'     && CRITICAL MSGS
      *  HELP PANELS
      acolors[c_hlpbar] := 'N/W,W/N,,,N/W' && ACTION BAR
      acolors[c_hlppnl] := 'W/N,N/W+,,,N/W' && DISPLAY PANEL
      acolors[c_hlpget] := 'W/N,N/W+,,,N/W' && PANEL DURING GETS
      acolors[c_hlpfkeys] := 'W/N,N/W'     && FUNCTION KEYS
      acolors[c_hlpnote] := 'W/N,N/W'      && NOTIFICATION MSGS
      acolors[c_hlpwarn] := 'W+/N,N/W+'    && WARNING MSGS
      acolors[c_hlpcritl] := 'N/W,W/N'     && CRITICAL MSGS
      *  POP UP WINDOWS
      acolors[c_popbar] := 'N/W,W/N,,,N/W' && ACTION BAR
      acolors[c_poppnl] := 'N/W,W+/N,,,N/W' && DISPLAY PANEL
      acolors[c_popget] := 'N/W,W+/N,,,N/W' && PANEL DURING GETS
      acolors[c_popfkeys] := 'N/W,W/N'     && FUNCTION KEYS
      acolors[c_popnote] := 'N/W,W/N'      && NOTIFICATION MSGS
      acolors[c_popwarn] := 'N/W+,W+/N'    && WARNING MSGS
      acolors[c_popcritl] := 'W/N,N/W'     && CRITICAL MSGS
   ENDIF

   RETURN(nil)

   ***************************************************************
   STATIC FUNCTION _FTValfrmt(fldformat)
   IF fldformat $ 'CDL'
      RETURN(.T.)
   ELSE
      TONE(261.7, 9)                   // Sound bell tone
      FT_Dispmsg({ { 'Format must be Character, Decimal, or Lotus', ;
                     'Press any key to reenter.' }  , ;
                   { acolors[c_msgcritl], acolors[c_msgcritl], acolors[c_msgcritl] } }, ;
                   'C')
      RETURN(.F.)
   ENDIF                   

   ***************************************************************
   STATIC FUNCTION _FTValprfl(prfldname)
   LOCAL nfld
   IF prfldname == SPACE(10)
      RETURN(.T.)
   ENDIF
   FOR nfld = 1 TO LEN(adbstruc)
       IF TRIM(UPPER(prfldname)) == adbstruc[nfld, DBS_NAME]
          RETURN(.T.)
       ENDIF
   NEXT      

   TONE(261.7, 9)                   // Sound bell tone
   FT_Dispmsg({ { 'Printer database field name invalid!', ;
                  'Press any key to reenter.' }  , ;
                { acolors[c_msgcritl], acolors[c_msgcritl], acolors[c_msgcritl] } }, ;
                'C')
   RETURN(.F.)
                                     
   ***************************************************************
   STATIC FUNCTION _FTValdbfl(dbfld)
   LOCAL nfld
   IF dbfld == SPACE(10)
      RETURN(.T.)
   ENDIF
   FOR nfld = 1 TO LEN(atheirstru)
       IF TRIM(UPPER(dbfld)) == atheirstru[nfld, DBS_NAME]
          RETURN(.T.)
       ENDIF
   NEXT      

   TONE(261.7, 9)                   // Sound bell tone
   FT_Dispmsg({ { 'Your database field name invalid!', ;
                  'Press any key to reenter.' }  , ;
                { acolors[c_msgcritl], acolors[c_msgcritl], acolors[c_msgcritl] } }, ;
                'C')
   RETURN(.F.)
                                     

#endif
 *
/*  $DOC$                                         
 *  $FUNCNAME$
 *     FT_Pinstl
 *  $CATEGORY$
 *     To be assigned
 *  $ONELINER$
 *     Installs printer control characters from PRINTERS.DBF
 *  $SYNTAX$
 *     FT_Pinstl( <cdbname>, <afldnames>, <acolor>, 
 *                [,<ntop>] [,<nleft>] [,<nbot>] [,<nright>]) -> <lok>
 *  $ARGUMENTS$
 *     <cdbname> contains the name of the database that is to receive
 *               the printer control characters.
 *     <afldnames> is a multi-dimensional array that equates the names
 *               of the fields in the <cdbname> database to the fields
 *               from the PRINTERS database that fill that field.  The
 *               first field in each entry is the name of a field in
 *               the database named in <cdbname>.  The second entry is
 *               a character indicating the format of the field (C for
 *               character e.g. E; "D" indicates decimal format, 
 *               e.g. 27/48; "L" indicates Lotus 1-2-3 format, e.g. 
 *               \027E.  The third entry is an array of field names from
 *               the PRINTERS database that will be used to fill this field.
 *     <acolor> is an array containing the color for the pop-up screen
 *               indicating the printers available, and the color of the
 *               scroll bar.
 *     <ntop> is an optional numeric value specifying the top row of the
 *               pop-up screen for selecting the desired printer.
 *     <nleft> is an optional numeric value specifying the left col of the
 *               pop-up screen for selecting the desired printer.
 *     <nbot> is an optional numeric value specifying the bottom row of the
 *               pop-up screen for selecting the desired printer.
 *     <nright> is an optional numeric value specifying the right col of the
 *               pop-up screen for selecting the desired printer.
 *  $RETURNS$
 *     <lok> is True if the printer was installed ok or False
 *           if an error occurred or the user pressed Esc to exit the
 *           install process.
 *  $DESCRIPTION$
 *     FT_Pinstal installs the printer control characters for a selected
 *         printer in the specified database fields.  It displays a list
 *         of the available printers and allows the user to select one
 *         of the specified printers.  It then replaces the fields in
 *         the specified database with the specified fields from the
 *         PRINTERS database.
 *  $EXAMPLES$
 *     afldnames[1] := { 'co_p1_name', 'C', {'pr_name'} }
 *     afldnames[2] := { 'co_p1_set1', 'D', { 'pr_lndscp', 'pr_51lpp' } }
 *     afldnames[3] := { 'co_p1_set2', 'D', { 'pr_8lpi'} }
 *     c_hlppnl := 'BG/B,B/GR+,,,B/BG'
 *     c_hlpnote := 'N/W,W/N'
 *     acolors := { c_hlppnl, c_hlpnote }
 *     FT_Pinstal('CONTROL', afldnames, acolors, 5, 5, 20, 75)
 *  $SEEALSO$
 *     FT_Ptrsel FT_Ptrcodes
 *  $INCLUDE$
 *     INKEY.CH
 *     FTPINSTL.CH
 *     DBSTRUCT.CH
 *  $END$
 */

FUNCTION FT_Pinstl
PARAMETERS p_cdbname, p_afldnames, p_acolor,  ;
           p_ntop, p_nleft, p_nbot, p_nright
LOCAL lok           
MEMVAR p_cdbname, p_afldnames, p_acolor, p_ntop, p_nleft, p_nbot, p_nright

lok := _FTPbrowse({||_FTPrepl(p_cdbname, p_afldnames)}, p_acolor, ;
            p_ntop, p_nleft, p_nbot, p_nright)

RETURN(lok)

*******************************************************************
STATIC FUNCTION _FTPbrowse
PARAMETERS p_bsel, p_acolor, ;
           p_ntop, p_nleft, p_nbot, p_nright, p_key

MEMVAR p_acolor, p_ntop, p_nleft, p_nbot, p_nright, p_bsel, p_key

#define my_hsep         ""

LOCAL sv_area, sv_color, lmore, pb, sb, cheading1, cheading2
LOCAL sv_screen, column1, column2
LOCAL search_key, lok := .T., tofld, fromfld, nkey, nrelrec
LOCAL sv_recno, ni, ni2, openedhere
IF p_key == NIL
   search_key := ''
ELSE
   search_key := p_key
ENDIF      

IF p_acolor[1] == NIL              // If color of panel isn't specified
   IF Iscolor()                    // Default
      *  Color displays
      p_acolor[1] = 'BG/B,B/GR+,,,B/BG'
   ELSE
      *  Monochrome displays
      p_acolor[1] = 'W/N,N/W+,,,N/W'
   ENDIF
ENDIF
IF p_acolor[2] == NIL          // If color of scroll bar isn't specified
   IF Iscolor()                // Default
      *  Color displays
      p_acolor[2] = 'N/W,W/N'
   ELSE
      *  Monochrome displays
      p_acolor[2] = 'W/N,N/W'
   ENDIF
ENDIF
// If location of panel not specified default to 5, 5, 20, 75
IF p_ntop == NIL
   p_ntop := 5
ENDIF
IF p_nleft == NIL
   p_nleft := 5
ENDIF
IF p_nbot == NIL
   p_nbot := 20
ENDIF
IF p_nright == NIL
   p_nright := 75
ENDIF

sv_color = SETCOLOR(p_acolor[1])         // Save current colors & reset
sv_area = SELECT()                // Save last selected area
sv_screen := _FTShdwbox(p_ntop, p_nleft, p_nbot, p_nright, p_acolor[1])

IF Select('printers') == 0
   openedhere := .T.
   USE printers NEW SHARED           // Use the PRINTERS database
   INDEX ON UPPER(printers->pr_name) TO PRINTERS      // Index on printer names
ELSE
   openedhere := .F.
   SELECT printers
   SET INDEX TO printers
ENDIF   

IF search_key == ''   
   GO TOP
ELSE
   SEEK search_key
ENDIF      
nrelrec := 1                       // Relative rec num for scrollbar
cheading1 := 'PRINTER TYPE'         // Column heading
cheading2 := 'COMPLETE'
@ p_ntop + 1,p_nleft + 1 SAY ;
     LEFT(' Use ' + CHR(24) + ', ' + CHR(25) + ', PgUp, or PgDn to move through printers.', p_nright - p_nleft)
@ p_ntop + 2,p_nleft + 1 SAY ;
     LEFT(' Press letter(s) to search, Enter to select printer.', p_nright - p_nleft)
@ p_ntop + 3,p_nleft + 1 TO p_ntop + 3,p_nright -1 DOUBLE

// Get and display the scroll bar
sb := scrollbarnew(p_ntop+5, p_nright-1, p_nbot-1, p_acolor[2])
scrollbardisplay(sb)

// Get and display the Tbrowse object session
pb := Tbrowsedb(p_ntop+4, p_nleft+1, p_nbot-1, p_nright-2)       // Set up TBrowse object
pb:headsep := my_hsep               // Heading seperators
column1 := Tbcolumnnew(cheading1, {|| printers->pr_name} )
pb:Addcolumn(column1)                // Add column for printer name
column2 := Tbcolumnnew(cheading2, {|| printers->pr_confrmd} )
pb:Addcolumn(column2)                // Add column for confirmed/complete
lmore = .T.
DO WHILE lmore
   /* stabilize the Display */
   DO WHILE ( !pb:stabilize() )
   ENDDO

   IF ( pb:stable )
      /* Display is stable */
      IF ( pb:hittop .OR. pb:hitbottom )
         Tone(261.7, 9)                   // Sound bell tone
      ENDIF

      // Display new Scroll bar
      scrollbarupdate(sb, nrelrec, Lastrec(), .T.)

      /* everything's done; just wait for a key */
      nkey := INKEY(0)

   ENDIF

   /* process KEY */
   DO CASE
   CASE ( nkey == K_DOWN )
      pb:Down()
      nrelrec++
      IF nrelrec > LastRec()
         nrelrec := LastRec()
      ENDIF

   CASE ( nkey == K_UP )
      pb:Up()
      nrelrec--
      IF nrelrec < 1
         nrelrec := 1
      ENDIF

   CASE ( nkey == K_PGDN )
      pb:Pagedown()
      nrelrec += ((p_nbot - 1) - (p_ntop + 4) - 2)
      IF nrelrec > LastRec()
         nrelrec := LastRec()
      ENDIF

   CASE ( nkey == K_PGUP )
      pb:Pageup()
      nrelrec -= ((p_nbot - 1) - (p_ntop + 4) - 2)
      IF nrelrec < 1
         nrelrec := 1
      ENDIF

   CASE ( nkey == K_CTRL_PGUP )
      pb:Gotop()
      nrelrec := 1

   CASE ( nkey == K_CTRL_PGDN )
      pb:Gobottom()
      nrelrec := LastRec()

   CASE ( nkey == K_HOME )
      pb:Gotop()
      nrelrec := 1

   CASE ( nkey == K_END )
      pb:Gobottom()
      nrelrec := LastRec()

   CASE ( nkey == K_ESC )
      lmore := .F.
      lok := .F.

   CASE ( nkey == K_ENTER )
      // Printer selected
      EVAL(p_bsel)
      lmore := .F.

   OTHERWISE
      // If backspace take a letter off of the search key
      IF nkey == K_BS
         IF LEN(search_key) > 1
            search_key := LEFT(search_key, LEN(search_key) -1)
         ELSE
            search_key := ''
         ENDIF
      ELSE
         search_key = search_key + UPPER(CHR(nkey))   // Add letter to search key
      ENDIF

      SEEK search_key      // Search for specified key
      // Determine relative record number for scrollbar
      sv_recno := RECNO()             // Save record num found
      GO TOP
      nrelrec := 1           // Count records until found correct record
      DO WHILE RECNO() <> sv_recno
         SKIP
         nrelrec++
      ENDDO
      pb:refreshall()     // Force redisplay at current record
   ENDCASE
ENDDO

IF openedhere
   USE                       // Close PRINTER database
   ERASE printers.ntx        // Erase index file
ENDIF   
SELECT (sv_area)          // Select previous area
SETCOLOR(sv_color)        // Reset color to original
Restscreen(p_ntop, p_nleft, p_nbot+1, p_nright+1, sv_screen)  // Restore original screen

RETURN(lok)

******************************************************************
STATIC FUNCTION _FTPrepl(p_cdbname, p_afldnames)
LOCAL ni, tofld, ni2, fromfld
USE (p_cdbname) NEW EXCLUSIVE   // Use their database
ni := 1
DO WHILE ni <= LEN(p_afldnames)    // Do for all fields specified
    tofld := p_afldnames[ni, 1]    // Get name of field to replace
    ni2 := 1
    fromfld := ''
    // Build fields to replace with from the array
    DO WHILE ni2 <= LEN(p_afldnames[ni, 3])
       fromfld += 'TRIM(printers->' + TRIM(p_afldnames[ni, 3, ni2]) + ')+'
       ni2++
    ENDDO
    fromfld := LEFT(fromfld, LEN(fromfld) - 1)  // Drop final +
    DO CASE
    CASE p_afldnames[ni, 2] = 'C'
       REPLACE &tofld WITH &fromfld
    CASE p_afldnames[ni, 2] = 'D'
       REPLACE &tofld WITH _FTStr2Dec(&fromfld)
    CASE p_afldnames[ni, 2] = 'L'
       REPLACE &tofld WITH FT_Codeesc(&fromfld)
    ENDCASE
    ni++
ENDDO
USE           // Close their database
SELECT printers
RETURN(.T.)

****************** FUNCTION _FTShdwBox ******************************
STATIC FUNCTION _FTShdwbox( top_row, col_left, bot_row, col_right, box_color)
**********
*
* PURPOSE: Draws a shadow box in color box_color
* PARAMETERS:
*    top_row - upper row of box
*    col_left - left-most column of box
*    bot_row - lower row of box (shadow extends one line below)
*    col_right - right-most column of box (shadow extends on column
*                to the right)
*    box_color - The color settings for the box
* RETURN VALUE:
*    The saved screen area displaced by the box
*
***********

LOCAL s_top_row, s_col_left, s_bot_row, s_col_right
LOCAL sv_color, sv_screen, dblbox
s_top_row := top_row + 1
s_col_left := col_left + 1
s_bot_row := bot_row + 1
s_col_right := col_right + 1
IF s_bot_row > maxrow()
   s_bot_row := maxrow()
ENDIF
IF s_col_right > maxcol()
   s_col_right := maxcol()
ENDIF
sv_screen = Savescreen(top_row, col_left, s_bot_row, s_col_right)
sv_color := SETCOLOR(box_color)   && Save old color and reset to box color

Restscreen( s_bot_row, col_left+1, s_bot_row, s_col_right,;
   TRANSFORM( Savescreen(s_bot_row, col_left+1, s_bot_row, s_col_right),;
   REPLICATE("X", s_col_right - col_left ) ) )

Restscreen( top_row+1, s_col_right, s_bot_row, s_col_right,;
   TRANSFORM( Savescreen(top_row+1, s_col_right , s_bot_row, s_col_right),;
   REPLICATE("X", s_bot_row - top_row ) ) )

dblbox := CHR(201) + CHR(205) + CHR(187) + CHR(186) + CHR(188) + ;
   CHR(205) + CHR(200) + CHR(186) + ' '
SETCOLOR(box_color)
@ top_row, col_left, bot_row, col_right BOX dblbox
SETCOLOR(sv_color)

RETURN(sv_screen)


****************** FUNCTION _FTStr2Dec *****************************
STATIC FUNCTION _FTStr2Dec(cstring)
**********
*
* PURPOSE: Converts a character string to a string of decimal values
*          of form nnn/nnn/...
* PARAMETERS:
*    cstring - character string to be converted
* RETURN VALUE:
*    cnewstring - a character string of decimal values in form
*                 nnn/nnn/...
*
***********

LOCAL cnewstring := '', ni

FOR ni = 1 TO LEN(cstring)
   cnewstring += LTRIM(STR(ASC(SUBSTR(cstring, ni, 1)),3)) + '/'
   ni++
NEXT

RETURN(cnewstring)

********************************************************************
FUNCTION FT_Codeesc(cstring)
 *
/*  $DOC$                                         
 *  $FUNCNAME$
 *     FT_Codeesc
 *  $CATEGORY$
 *     To be assigned
 *  $ONELINER$
 *     Converts string to Lotus style escape codes
 *  $SYNTAX$
 *     FT_Codeesc( <cstring> ) -> <cnewstring>
 *  $ARGUMENTS$
 *     <cstring> contains the character string that is to be converted
 *  $RETURNS$
 *     <cnewstring> contains the new string with Lotus style escape codes
 *  $DESCRIPTION$
 *     FT_Codeesc converts a character string that contains control chars
 *     into a string with Lotus style escape codes.  It converts any 
 *     character with a ASC value of < 32 or > 126 to a Lotus style 
 *     escape sequence, e.g. \027.  It does the reverse of FT_Esccode.
 *  $EXAMPLES$
 *     string := CHR(27) + 'E'
 *     ? FT_Codeesc(string)   // Will display \027E
 *  $SEEALSO$
 *     FT_Esccode
 *  $INCLUDE$
 *
 *  $END$
 */

LOCAL cnewstring := '', ni, cchar
FOR ni = 1 TO LEN(cstring)
   cchar := SUBSTR(cstring, ni, 1)
   IF ASC(cchar) < 32 .OR. ASC(cchar) > 126
      cnewstring += '\' + RIGHT(STR(ASC(cchar) + 1000, 4), 3)  // \nnn
   ELSE
      cnewstring += cchar
   ENDIF
NEXT
RETURN(cnewstring)

********************************************************************
FUNCTION FT_Ptrsel()
 *
/*  $DOC$                                         
 *  $FUNCNAME$
 *     FT_Ptrsel
 *  $CATEGORY$
 *     To be assigned
 *  $ONELINER$
 *     Selects a printer from the list of printers in PRINTERS.DBF
 *  $SYNTAX$
 *     FT_Ptrsel() -> <cptrname>
 *  $ARGUMENTS$
 *     none
 *  $RETURNS$
 *     <cptrname> equals the name of the printer selected
 *                It will equal NIL if no printer was selected
 *  $DESCRIPTION$
 *     FT_Ptrsel is used to select a printer from the PRINTERS database
 *     This function must be used before the FT_Ptrcode function is used.
 *  $EXAMPLES$
 *     ? FT_Ptrsel()   
 *  $SEEALSO$
 *     FT_Ptrcode
 *  $INCLUDE$
 *     INKEY.CH
 *  $END$
 */

LOCAL lok
PRIVATE acolors[c_numclrs]
_FTClrinit(@acolors, Iscolor())    // Setup color array
lok := _FTPbrowse({||_FTSvPtr()}, ;
                  { acolors[c_hlppnl], acolors[c_hlpbar] }, ;
                  4, 5, 23, 75)
IF lok
   RETURN(ptrcodes[PR_NAME])
ENDIF

RETURN(NIL)                     


********************************************************************
STATIC FUNCTION _FTSvPtr()
// Save printer codes in the prtcodes array

LOCAL ni

FOR ni = 1 TO 26
    ptrcodes[ni] := FIELDGET(ni)
NEXT
RETURN(NIL)

********************************************************************    
FUNCTION FT_Ptrcode(ptrcode)
 *
/*  $DOC$                                         
 *  $FUNCNAME$
 *     FT_Ptrcode
 *  $CATEGORY$
 *     To be assigned
 *  $ONELINER$
 *     Retrieves the specified printer control sequence
 *  $SYNTAX$
 *     FT_Ptrcode( <nptrcode> ) -> <cctrlseq>
 *  $ARGUMENTS$
 *     <nptrcode> the number of the printer code to be retrieved
 *                Use the manfest constants in FTPRINSTL.CH.
 *  $RETURNS$
 *     <cctrlseq> the printer control character sequence to perform
 *                the function indicated by nptrcode.
 *  $DESCRIPTION$
 *     FT_Ptrcode is used to obtain the control character sequence for
 *     a specific printer function.  Use the manifest constants in
 *     FTPRINSTL.CH to specify what function is desired.  Before useing
 *     FT_Ptrcode you must use FT_Ptrsel to select a printer from the 
 *     PRINTERS database.
 *  $EXAMPLES$
 *     FT_Ptrsel()
 *     ? FT_Ptrcode[PR_NAME]
 *  $SEEALSO$
 *     FT_Ptrsel
 *  $INCLUDE$
 *     FTPRINSTL.CH
 *  $END$
 */

RETURN(ptrcodes[ptrcode])
    


