******************************************************************************
*   Name: DEMO1.PRG                                                          *
*   Date: 1-5-91                                                             *
* Author: Todd W. Lindley                                                    *
*    Use: The folowing source code is placed in the public domain. Any or    *
*         all may be used as desired.                                        *  
*   Desc: A dbf editing program that demonstrates the use                    *
*         of PICKLIST.  This is by no means a sophisticated editing utility. *
*         In fact I don't even recommend using the program on your own       *
*         .dbf files.  This sample code was a means to demonstrate the use   *
*         of PICKLIST in a custom editing program.                           *
*                                                                            *
*   What does PICKLIST do in this application?                               *
*        If the user enters a partial lastname followed by enter, a          *
*        picklist appears and allows the user to highlight a record.  If     *
*        the record is selected by pressing the enter key, the record        *
*        pointer is moved to the selected record and re-displayed on the     *
*        screen for editing.                                                 *
*                                                                            *
*        IF the user presses the F2 key the picklist will also appear.       *
******************************************************************************      

SET ESCAPE OFF
SET EXACT ON
SET NEAR ON
SET AUTOSAVE ON
SET TALK OFF
old_colr=SET("ATTRIBUTES")
null=""
SET COLOR OF NORMAL TO BG+/B
SET COLOR OF MESSAGE TO BG+/B
SET STAT OFF
SET SCOR OFF
SET COLOR OF FIELDS TO W+/N
SET FUNCTION F2 TO ""
SET FUNCTION F3 TO ""
SET FUNCTION F4 TO ""
** "HOT KEY" FOR PICKLIST
ON KEY LABEL F2 DO look
**  WHICH KEYS MOVE RECORD POINTER
ON KEY LABEL F3 DO nextrec
ON KEY LABEL F4 DO prevrec
CLEAR
** FILL SCREEN BACKGROUND
x=1
line=REPLICATE(CHR(176),80)
DO WHILE x=<23
  @x,0 SAY line COLOR R+/N
  x=x+1
ENDDO
@6,12 CLEAR TO 18,68
@ 6,12 TO 18,68 DOUBLE
@17,13 SAY "Esc" COLOR W+/B
@17,16 SAY "Exit" COLOR N/BG
@17,22 SAY "F2" COLOR W+/B
@17,24 SAY "List Names" COLOR N/BG
@17,36 SAY "F3" COLOR W+/B
@17,38 SAY "Next Record" COLOR N/BG
@17,51 SAY "F4" COLOR W+/B
@17,53 SAY "Previous Record" COLOR N/BG
@6,28 SAY " Edit Address Information " COLOR N/W

@20,9 SAY "CAUTION: You must press [Enter] after any field is changed" COLOR RG+/B
@21,9 SAY "otherwise the new information will be written to the next record" COLOR RG+/B

USE NAMES ORDER LAST
key=last
CLEAR TYPE

DO WHILE .T.
  @8,13 SAY "Last name:" GET key PICT "!!!!!!!!!!!!!!!!!!!!";
                          VALID search();
                          ERROR "Must select a name"
  @8,46 SAY "First name:" GET first PICT "!!!!!!!!!!"
  @10,13 SAY "Address:" GET add1
  @11,22 GET add2
  @13,13 SAY "City:" GET city
  @13,36 SAY "State:" GET state
  @13,47 SAY "Zip:" GET zip
  @15,13 SAY "Phone:" GET phone
READ
IF LASTKEY()=27
  EXIT
ENDIF
ENDDO

SET COLOR TO &old_colr
RELEASE ALL
CLOSE DATA
SET ESCAPE ON
SET STAT ON
SET SCOR ON
SET TALK ON
SET SCOREBOARD ON
RETURN

FUNCTION search
  was_pick=.F.
  SEEK TRIM(key)
  IF .NOT. FOUND()
** IF MATCH IS CLOSE THEN DO PICKLIST
    DO picklist WITH "LAST","PHONE","null",3,36,7,was_pick
  ELSE
** AN EXACT MATCH WAS FOUND SO RETURN A TRUE TO THE VALID CLAUSE
    was_pick=.T.
  ENDIF
  key=last
  IF was_pick
** IF OK THEN UPDATE DISPLAY.  OTHERWISE DO NOTHING
      ENDIF
KEYBOARD CHR(18) 

RETURN (was_pick)

PROCEDURE look
  was_pick=.F.
  DO picklist WITH "LAST","PHONE","null",3,36,7,was_pick
  key=last
  IF was_pick
** IF OK THEN UPDATE DISPLAY.  OTHERWISE DO NOTHING
    KEYBOARD CHR(18)
  ENDIF
RETURN

PROCEDURE nextrec
SET CURS OFF
** SAVE CURRENT INFORMATION BECAUSE IF WE DON'T, CHANGED INFO WILL BE LOST
  REPLACE first WITH first,add1 WITH add1,add2 WITH add2,city WITH city,;
        state WITH state,zip WITH zip,phone WITH phone
  SKIP
** IF END OF FILE CYCLE AROUND TO TOP RECORD
  IF EOF()
    GO TOP
  ENDIF
  key=last
** UPDATE SCREEN
  KEYBOARD CHR(18)
SET CURS ON
RETURN

PROCEDURE prevrec
SET CURS OFF
** SAVE CURRENT INFORMATION BECAUSE IF WE DON'T, CHANGED INFO WILL BE LOST
  REPLACE first WITH first,add1 WITH add1,add2 WITH add2,city WITH city,;
        state WITH state,zip WITH zip,phone WITH phone
  SKIP -1
** IF TOP OF FILE CYCLE AROUND TO LAST RECORD
  IF BOF()
    GO BOTT
  ENDIF
  key=last
** UPDATE SCREEN
  KEYBOARD CHR(18)
SET CURS ON
RETURN
