* Program.: PK_JP.PRG
* Author..: Charles Alan Butler    
* Date....: 03/16/90
* Notice..: Copyright (c) 1990,MIS Consulting, All Rights Reserved
* Notes...: Template Ver(9.1) 3/11/90 *CAB*     Menu Code : MCT
* Notes...: Target Language is FoxPro.
* Notes...: Database Pick List.  SPACE and ENTER will tag records.
* Notes...: Multiple choice, Ctrl-End causes an exit from list.
* Notes...: Multiple lines per record

** -- Save some of the calling environment
PickSch1=SCHEME(1)  &&  SAVE Colors   [FoxPro]
PickSch2=SCHEME(2)  &&  SAVE Colors   [FoxPro]
WorkArea=CHR(64+SELECT())    &&  Save the work area

* ---Open the database file--- *
SELECT 0
USE JOBFILE INDEX JOB_NO ALIAS JOB
SELECT JOB
SET ORDER TO  1          &&  set up for index
SELECT JOB

**  --  Test Main DBF for records  --  **
*====================================================================
*  Can not use RECCOUNT()  in case a filter is on or a filtered index
*  is being used,  this is slower than RECCOUNT(), so You may want to
*  delete the COUNT TO line and replace all 'DbfRec' occurrences with
*  RECCOUNT(), if you are not using a Filter or filtered index.
COUNT TO DbfRec
*====================================================================
IF DbfRec = 0
   PkError='Main DBF is empty..'
ELSE
   PkError = ''    &&  Used as a fall through error flag
ENDIF

**  --  Open PK.DBF to hold record pointers of marked records
IF .NOT. (FILE('PK_LIST.DBF').AND.FILE('PK_LIST.IDX'))
   PkError='ERROR!! Can not find PK_LIST.DBF or PK_LIST.IDX!'
ELSE
   SELECT 0
   USE PK_LIST INDEX PK_LIST ALIAS PK   &&   DBF to store selected items
   ZAP             &&  empty file
   SELECT JOB
   SET RELATION TO RECNO() INTO PK ADDITIVE
   PkArea=SELECT()    &&  used as a pointer - RECNO(PkArea)
ENDIF

IF PkError == ''   &&  Used as a fall through error flag
   **  ---  set up local variables  ---  **
   ScrollDir = 0      &&  Scroll Flag
   KeyCode=90         &&  Key code; set up for a new page
   NewPage=.T.        &&  Flag to display a new page
   PageTest = .F.     &&  Flag to test for a full page
   RecPoint=RECNO()   &&  Absolute record number
   PageTop=RecPoint   &&  Top of Page record pointer
   MouseMove = .F.    &&  Mouse Flag to move the highlite
   MouseTime = 0      &&  Time keeper for mouse repeats
   MouseDelay = 0.4   &&  Delay before the first repeat
   LastCode = 0       &&  code of last key pressed
   ScrnTop=2          &&  Top Window Row used to display a record
   WindowTop=2        &&  Top Window Row used to display a record
   ScrnLeft= 1        &&  Left Window Column
   ScrnRight=67       &&  Right Window Column
   zBotIn=16          &&  'IN' Bottom Window Row used to display a record
   zwBotIn=20         &&  'IN' Bottom Window Row of the window on the screen
   * Set Out window Bottom according to the Display size
   zBotOut=WROWS('')-2  &&  'OUT' Bottom Window Row used to display a record
   zIn = .T.            &&  Force small window

   ** --  Correction for record counts less than window 'OUT' length  --  **
   RecPerPage=INT((zBotOut-WindowTop+1)/3)      &&  Records per page
   IF DbfRec < RecPerPage
      RecPerPage = DbfRec
   ENDIF
   zBotOut = RecPerPage*3+WindowTop-1

   ** --  Correction for record counts less than window 'IN' length  --  **
   RecPerPage=INT((zBotIn-ScrnTop+1)/3)   &&  Records per page
   IF DbfRec < RecPerPage
      RecPerPage = DbfRec
   ENDIF
   zBotIn = RecPerPage*3+ScrnTop-1
   zwBotIn=zBotIn + 4

   **  --  Test for a target to seek and a return value  --  **
   TmpVar = SYS(14,1)   &&  the Key expression
   IF TYPE('Target') # TYPE('&TmpVar')  &&  Type mismatch or undefined
      RELEASE Target
      PUBLIC Target
      Target = &TmpVar     &&  Set up to start pick list at current record
   ENDIF

   SET EXACT OFF
   SEEK Target
   SET EXACT ON
   IF  EOF()              &&  no match was found
      IF RECNO(0)=0       &&  no close match
         GOTO TOP
      ELSE
         GOTO RECNO(0)    &&  nearest match
      ENDIF
   ENDIF
   PageTest = .T.         &&  full page test needed
   **  --  Set Size of Display Windows  --  **
   define window ZoomIn FROM 3,4 TO zwBotIn,72 none
   define window ZoomOut FROM 0,4 TO zBotOut+1,72 none

   **  ================  get & process commands  ======================
   DO WHILE .T.

      DO CASE
      CASE KeyCode=90.OR.KeyCode=122                           &&  [Zz] Zoom
         NewPage=.T.
         IF zIn                     &&  Zoom In
            zIn = .NOT. zIn
            ScrnBot=zBotIn          &&  Bottom Screen Row
            Hide window ZoomOut
            activate window ZoomIn
         ELSE                       &&  Zoom Out
            zIn = .NOT. zIn
            ScrnBot=zBotOut         &&  Bottom Screen Row
            Hide window ZoomIn
            activate window ZoomOut
         ENDIF
         RecPerPage=(ScrnBot-ScrnTop+1)/3      &&  Records per page
         RecPoint=RECNO()
         PageTest = .T.         &&  full page test needed

         wThumb = INT((ScrnBot-WindowTop)/2)+WindowTop

         **  --  Display Window  --  **
         SET COLOR TO BR/N
         @ 0,0,ScrnBot+1,ScrnRight+1 BOX " "
         SET COLOR TO W+/BR
         @ 0,0 SAY CHR(254)                   &&  Close window
         @ 0,ScrnRight+1 SAY CHR(240)         &&  Zoom
         @ 1,ScrnRight+1 SAY CHR(30)          &&  Up
         @ ScrnBot,ScrnRight+1 SAY CHR(31)    &&  Down
         @ ScrnBot+1,ScrnRight+1 SAY "H"      &&  Help
         @ wThumb,ScrnRight+1 SAY CHR(4)       &&  Thumb
         SET COLOR TO BG+/BR
         @ 0,23 SAY "[  J O B   F I L E  ]"
         @ ScrnBot+1,4 SAY "F1-Help"
         @ ScrnBot+1,23 SAY "[ Press ENTER to Select ]"
         SET COLOR TO BG+/N
         @ 1,2 SAY "Job#"
         @ 1,7 SAY "Gc"
         @ 1,10 SAY "Bid#"
         @ 1,24 SAY "Street"
         @ 1,31 SAY "Address"
         @ 1,15 SAY "  Price "
         @ 1,52 SAY "Subdivision"
         SET COLOR TO G/N
         @ 3,7 SAY "Owners Name "
         @ 3,46 SAY "Phone "
         SET COLOR TO BG+/N
         @ 4,2 SAY ""
         SET COLOR TO G+/N

      CASE KeyCode=32.OR.KeyCode=13          &&  [Space] or [Enter] to tag / untag
         SELECT PK
         IF EOF()          &&  item is not tagged so tag it
            SEEK 0
            IF EOF()       &&  use any records set to 0 before appending
               APPEND BLANK
            ENDIF
            REPLACE Rec_no WITH RECNO(PkArea)
         ELSE              &&  record was tagged so untag it
            REPLACE Rec_no WITH 0
         ENDIF
         SELECT JOB
         IF PK->Rec_no#0     &&  Record is tagged so display pointers
            @ CurRow,ScrnLeft SAY CHR(16)    &&  Left tag Pointer
            @ CurRow,ScrnRight SAY CHR(17)    &&  Right tag Pointer
         ELSE     &&  Untag so remove pointers
            @ CurRow,ScrnLeft SAY ' '
            @ CurRow,ScrnRight SAY ' '
         ENDIF
         KeyCode=24
         LOOP

      CASE KeyCode=84.OR.KeyCode=116               &&  [Tt] to tag ALL
         NewPage=.T.
         GO TOP
         DO WHILE .T.
            SELECT PK
            IF EOF()       &&  item is not tagged so tag it
               SEEK 0      &&  use any records set to 0 before appending
               IF EOF()    &&  none found, so add one
                  APPEND BLANK
               ENDIF
               REPLACE Rec_no WITH RECNO(PkArea)
            ENDIF
            SELECT JOB
            SKIP
            IF EOF()
               EXIT
            ENDIF
         ENDDO
         GO TOP   &&  Reset pointer

      CASE KeyCode=67.OR.KeyCode=99                &&  [Cc] to Clear ALL
         SELECT PK
         ZAP
         SELECT JOB
         @ ScrnTop,ScrnLeft TO ScrnBot,ScrnLeft CLEAR  &&  marks
         @ ScrnTop,ScrnRight TO ScrnBot,ScrnRight CLEAR  &&  marks

      CASE KeyCode=77.OR.KeyCode=109              &&  [Mm] Tag/Untag Matching
         DEFINE WINDOW PkWindow FROM 9,14 TO 13,66 DOUBLE TITLE  "[ Tag/Untag Matching Records ]"
         ACTIVATE WINDOW PkWindow
         TagAll=.T.    &&  T = Tag     U = Untag
         Tmp='T'
         PkMatch = 0
         @ ROW(),2 SAY 'Tag or Untag matching records. (T/U):' GET Tmp PICTURE '!' Valid Tmp$'TU'
         PkMatch2 = 0
         @ ROW()+1,2 SAY 'Tag ALL starting with :' GET PkMatch  PICTURE '9999'
         @ ROW(),COL()+2 SAY '0 = Start of file.'
         @ ROW()+1,2 SAY '      and ending with :' GET PkMatch2 PICTURE '9999'
         @ ROW(),COL()+2 SAY '0 = End of file.'
         READ
         TagAll = (Tmp='T')    &&  T = Tag     U = Untag
         IF READKEY()=12 .OR. READKEY()=268 ;
               .OR.(PkMatch = 0 .AND. PkMatch2 = 0)
         ELSE
            OldPoint=RECNO()
            IF PkMatch2 = 0    &&  Get end of range
               Go Bottom
               PkMatch2 = JOB_NO
            ENDIF
            if PkMatch = 0
               GO TOP
               PkMatch = JOB_NO
            else
               SEEK PkMatch
            endif
            IF EOF()
               CLEAR
               @ ROW(),2 SAY '****  No matching records!  ****'
               GOTO OldPoint
               ans=INKEY(0,'M')   &&  Wait for key press
            ELSE
               NewPage=.T.
               DO WHILE JOB_NO>=PkMatch .AND. JOB_NO<=PkMatch2 .AND..NOT. EOF()
                  SELECT PK
                  IF TagAll  &&  Matching Records
                     IF EOF()   &&  item is not tagged
                        SEEK 0
                        IF EOF()    &&  use any records set to 0 before appending
                           APPEND BLANK
                        ENDIF
                        REPLACE Rec_no WITH RECNO(PkArea)
                     ENDIF
                  ELSE  &&  Untag Matching Records
                     IF .NOT. EOF()   &&  item was tagged
                        REPLACE Rec_no WITH 0
                     ENDIF
                  ENDIF
                  SELECT JOB
                  SKIP
               ENDDO
               SEEK PkMatch           &&  reposition pointer
               PageTest = .T.         &&  full page test needed
            ENDIF
         ENDIF eof()
         RELEASE WINDOW PkWindow

      CASE KeyCode=83.OR.KeyCode=115                       &&  [Ss]   Search
         DEFINE WINDOW PkWindow FROM 9,21 TO 13,59 DOUBLE TITLE  "[ Tag/Untag Matching Records ]"
         ACTIVATE WINDOW PkWindow
         PkMatch = 0
         @ ROW()+1,2 SAY 'Enter Search Key :' GET PkMatch PICTURE '9999'
         READ
         IF READKEY()=12 .OR. READKEY()=268
            **  --  Search Aborted
         ELSE
            NewPage=.T.
            PageTest = .T.         &&  full page test needed
            SEEK PkMatch
            IF EOF()
               CLEAR
               @ ROW(),2 SAY 'No match!'
               IF RECNO(0)=0       &&  no close match
                  @ ROW()+1,2 SAY 'Returning to top of file.'
                  GOTO TOP
               ELSE
                  @ ROW()+1,2 SAY 'Returning to nearest match.'
                  GOTO RECNO(0)    &&  nearest match
               ENDIF
               ans=INKEY(0,'M')   &&  Wait for key press
            ELSE     &&  Found
               RecPoint=recno()
            ENDIF
         ENDIF eof()
         RELEASE WINDOW PkWindow

      CASE KeyCode=3.OR.KeyCode=51                               &&  [PgDn]
         IF CurRow = ScrnBot-2  &&  at last row, so go to next page
            NewPage=.T.
            SKIP 1         &&  test to see if at last record
            IF EOF()       &&  yes, so wrap to top of file
               GO TOP
            ELSE           &&  test for full page
               SKIP RecPerPage-1
               IF EOF()               &&  last page is not a full one,
                  GO BOTTOM           &&  so make last page full
               ENDIF
               RecPoint=RECNO()
               SKIP -RecPerPage +1    &&  to top of page
            ENDIF
         ELSE                &&  move to last row of page then skip
            SKIP (ScrnBot - CurRow)/3
            CurRow = ScrnBot-2
         ENDIF

      CASE KeyCode=18.OR.KeyCode=57                              &&   [PgUp]
         IF CurRow = ScrnTop  &&  at first row, so go to previous page
            NewPage=.T.
            SKIP -1        &&  test to see if at 1st record
            IF BOF()       &&  yes, so wrap to bottom
               GO BOTTOM
               RecPoint=RECNO()
               SKIP -(RecPerPage-1)
            ELSE           &&  test for full page
               SKIP -(RecPerPage-1)
               IF BOF()       &&  first page is not a full one,
                  GO TOP      &&  so make first page full
               ENDIF
               RecPoint=RECNO()
            ENDIF
         ELSE                 &&  move to first row of page then skip
            SKIP -(CurRow - ScrnTop)/3
            CurRow = ScrnTop
         ENDIF

      CASE KeyCode=1.OR.KeyCode=55                               &&  [Home]
         GO TOP               &&  cursor to beginning of file
         NewPage=.T.

      CASE KeyCode=6.OR.KeyCode=49                               &&  [End]
         GO BOTTOM
         RecPoint=RECNO()
         SKIP -(RecPerPage-1)
         NewPage=.T.

      CASE KeyCode=5.OR.KeyCode=56.OR.KeyCode=19.OR.KeyCode=52   &&  [Up]  [Left]
         IF CurRow=ScrnTop    &&  at top of page, so scroll
            ScrollDir = -1
         ELSE                 && move HighLite up one row
            CurRow=CurRow -3
            SKIP -1           && move pointer up one record
         ENDIF

      CASE KeyCode=24.OR.KeyCode=50.OR.KeyCode=4.OR.KeyCode=54   &&  [Down]  [Right]
         IF CurRow=ScrnBot-2    &&  at bottom of page, so scroll
            ScrollDir = 1
         ELSE                 && move HighLite down one row
            CurRow=CurRow +3
            SKIP 1            && move pointer up one record
         ENDIF

      CASE KeyCode=27                                     &&  [ESC]  -- Abort
         SELECT PK
         ZAP             &&  Remove any picks from the database
         EXIT

      CASE KeyCode=23                                  &&  [Ctrl] [End] -- Exit
         EXIT

      CASE KeyCode=74.OR.KeyCode=106                          &&  [Jj]  --  Jump
         DEFINE WINDOW PkWindow FROM 10,15 TO 12,61 DOUBLE
         ACTIVATE WINDOW PkWindow
         JumpVal=0
         @ 0,2 SAY 'Enter the number of records to jump:' GET JumpVal PICTURE '99999'
         READ
         IF JumpVal # 0
            NewPage = .T.
            SKIP JumpVal     &&  test to see if at 1st record
            DO CASE
            CASE EOF()       &&  at bottom of file, so position for last page
               GO BOTTOM
               RecPoint=RECNO()
               SKIP -(RecPerPage-1)
            CASE BOF()       &&  at top of file, so position for first page
               GO TOP
            OTHERWISE        &&  test for full page
               RecPoint=RECNO()
               PageTest = .T.
            ENDCASE
         ENDIF JumpVal # 0
         RELEASE WINDOW PkWindow

      CASE KeyCode=28.OR.KeyCode=72.OR.KeyCode=104      &&  [F1] [Hh]  Help
         SET COLOR TO RB+/N
         DEFINE WINDOW brHelp FROM 2,10 TO 22,66  ;
                TITLE '[  HELP WINDOW  ]' DOUBLE ;
                COLOR G+/N,RB+/N,RB+/N
         ACTIVATE WINDOW brHelp
         @ ROW(),2 SAY '----KEY-------------ACTION--------------------------'
         @ ROW()+1,2 SAY '  [ESC]    Exit list without selecting an item.'
         @ ROW()+1,2 SAY '[Ctrl][End] Save select items and exit.'
         @ ROW()+1,2 SAY '  [Enter]  Tag or Untag a record.'
         @ ROW()+1,2 SAY '  [Space]  Tag or Untag a record.'
         @ ROW()+1,2 SAY '  [C]      Clear ALL tagged records.'
         @ ROW()+1,2 SAY '  [T]      Tag ALL records.'
         @ ROW()+1,2 SAY '  [M]      Tag/Untag Matching Records.'
         @ ROW()+1,2 SAY '  [J]      Jump a number of records.'
         @ ROW()+1,2 SAY '  [S]      Search on key field.'
         @ ROW()+1,2 SAY '  Arrows   Cursor keys move the selection pointer.'
         @ ROW()+1,2 SAY '  [PgDn]   To page bottom or to the next page.'
         @ ROW()+1,2 SAY '  [PgUp]   To page top or to the previous page.'
         @ ROW()+1,2 SAY '  [Home]   Display the first page.'
         @ ROW()+1,2 SAY '  [End]    Display the last page.'
         @ ROW()+1,2 SAY '  [Z]      Zoom window in and out.'
         @ ROW()+1,2 SAY '  [F1] [H] Displays this screen.'
         @ ROW()+1,2 SAY ' <  Press Key for Command, Any Other To Return  >'
         @ ROW()+1,2 SAY ' <Click on a row for Command, Any Other To Return>'
         KeyCode=INKEY(0,'HM')
         IF KeyCode=151                                      &&  Mouse was clicked
            IF MCOL()>=0 .AND. MROW()>0 .AND. MROW()<=18     &&  within window
               KeyCode=VAL(SUBSTR('0  23 13 32 67 84 77 74 83 0  3  18 1  6  90 0  ',(MROW()-1)*3+1,3))
            ENDIF
         ENDIF
         RELEASE WINDOWS brHelp
         IF zIn
            ACTIVATE WINDOW ZoomOut
         ELSE
            ACTIVATE WINDOW ZoomIn
         ENDIF
         SET COLOR TO G+/N
         IF KeyCode#27     &&  Do not abort from this window
            LOOP
         ENDIF

      ENDCASE

      *=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
      **          Window display routines
      *=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

      IF ScrollDir # 0     &&  Scroll screen Up or Down
         SKIP ScrollDir    &&  Move record pointer
         DO CASE
         CASE EOF()    &&  Wrap to top of file
            GO TOP
            NewPage=.T.
         CASE BOF()    &&  Wrap to Bottom of file
            GO BOTTOM
            RecPoint=RECNO()
            SKIP -(RecPerPage-1)
            NewPage=.T.
         OTHERWISE      &&  Scroll one line
            Scroll ScrnTop,ScrnLeft,ScrnBot,ScrnRight,ScrollDir*3   &&  [Fox 2.1]
            CurRow = IIF(ScrollDir=-1,ScrnTop,ScrnBot-2)   && position cursor
         ENDCASE
         ScrollDir = 0
      ENDIF ScrollDir # 0

      IF NewPage                 &&  display a new page
         NewPage=.F.             &&  reset flag
         IF RecPoint=0
            RecPoint = RECNO()  &&  reposition record pointer
         ENDIF
         IF PageTest      &&  Test for full page to display
            SKIP RecPerPage-1
            IF EOF()               &&  last page is not a full one,
               GO BOTTOM           &&  so make last page full
            ENDIF
            SKIP -RecPerPage +1    &&  to top of page
            PageTest = .F.
         ENDIF PageTest

         **  --  display a new page  ---------------------
         SET COLOR TO G+/N
         @ ScrnTop,ScrnLeft TO ScrnBot,ScrnRight CLEAR  &&  window
         cnt=0
         DO WHILE cnt<RecPerPage
            rw=cnt*3+ScrnTop
            IF PK->Rec_no#0     &&  Record is tagged so display pointers
               @ rw,ScrnLeft SAY CHR(16)    &&  Left tag Pointer
               @ rw,ScrnRight SAY CHR(17)    &&  Right tag Pointer
            ENDIF
            @ rw,2 SAY Job_no PICTURE "9999"
            @ rw,7 SAY Gc_no PICTURE "99"
            @ rw,10 SAY Job_bid_no PICTURE "9999"
            @ rw,24 SAY Job_no_adr PICTURE "999999"
            @ rw,31 SAY Job_st_adr PICTURE "XXXXXXXXXXXXXXXXXXXX"
            SET COLOR TO R+/N
            @ rw,15 SAY Job_price PICTURE "99999.99"
            SET COLOR TO G+/N
            @ rw,52 SAY Subdiv PICTURE "XXXXXXXXXXXXXXX"
            @ rw+1,19 SAY Cust_first PICTURE "XXXXXXXXXX"
            @ rw+1,30 SAY Cust_last PICTURE "XXXXXXXXXXXXXXX"
            @ rw+1,52 SAY Cust_hm_ph PICTURE "9999999"
            @ rw+1,60 SAY Cust_wk_ph PICTURE "9999999"
            SET COLOR TO G/N
            @ rw+1,7 SAY "Owners Name "
            @ rw+1,46 SAY "Phone "
            SET COLOR TO BG+/N
            @ rw+2,2 SAY ""
            SET COLOR TO G+/N
            IF RecPoint=RECNO()          &&  Cursor record number to top of page
               CurRow = ScrnTop + cnt*3    &&  Place Cursor pointer
            ENDIF
            cnt=cnt+1
            SKIP
         ENDDO while cnt<RecPerPage

         GOTO RecPoint       &&  reposition record pointer to top of page
         RecPoint=0
      ENDIF  NewPage=.T.

      SET COLOR TO w+/r           &&  Turn High Lite On
      @ CurRow,ScrnLeft TO CurRow+2,ScrnRight CLEAR
      IF PK->Rec_no#0     &&  Record is tagged so display pointers
         @ CurRow,ScrnLeft SAY CHR(16)    &&  Left tag Pointer
         @ CurRow,ScrnRight SAY CHR(17)    &&  Right tag Pointer
      ENDIF
      @ CurRow,2 SAY Job_no PICTURE "9999"
      @ CurRow,7 SAY Gc_no PICTURE "99"
      @ CurRow,10 SAY Job_bid_no PICTURE "9999"
      @ CurRow,24 SAY Job_no_adr PICTURE "999999"
      @ CurRow,31 SAY Job_st_adr PICTURE "XXXXXXXXXXXXXXXXXXXX"
      @ CurRow,15 SAY Job_price PICTURE "99999.99"
      @ CurRow,52 SAY Subdiv PICTURE "XXXXXXXXXXXXXXX"
      @ CurRow+1,19 SAY Cust_first PICTURE "XXXXXXXXXX"
      @ CurRow+1,30 SAY Cust_last PICTURE "XXXXXXXXXXXXXXX"
      @ CurRow+1,52 SAY Cust_hm_ph PICTURE "9999999"
      @ CurRow+1,60 SAY Cust_wk_ph PICTURE "9999999"
      @ CurRow+1,7 SAY "Owners Name "
      @ CurRow+1,46 SAY "Phone "
      @ CurRow+2,2 SAY ""

      DO WHILE MDOWN() .AND. MouseTime > SECONDS() - MouseDelay
         **  --  Keeps the mouse button from repeating too quickley
      ENDDO
      DO WHILE .T.
         IF MDOWN()      &&  mouse button is still down
            KeyCode=151
         ELSE
            KeyCode=INKEY(0,'HM')          &&  get KEY COMMAND  ******************
            LastCode = 0
            MouseDelay = 0.4   &&  reset the mouse debounce delay
         ENDIF
         MouseTime = SECONDS()  &&  Time allowed between repeats

         IF KeyCode=151   &&  Mouse Clicked
            DO CASE
            CASE MCOL()=ScrnRight+1    && Mouse is in Right Border
               DO CASE
               CASE MROW()=1              &&  Up
                  KeyCode=5
               CASE MROW()=ScrnBot        &&  Down
                  KeyCode=24
               CASE MROW()=0              &&  Zoom
                  KeyCode=90
              * CASE MROW()=ScrnBot+1      &&  Help is lower right corner
              *    KeyCode=28
               CASE MROW()>1 .AND. MROW()< wThumb         &&  PgUp
                  KeyCode=18   &&  PgUp
               CASE MROW()<ScrnBot .AND. MROW()> wThumb   &&  PgDn
                  KeyCode=3    &&  PgDn
               ENDCASE
            CASE MROW()=ScrnBot+1      &&  Help is all of last line
               KeyCode=28
            CASE MCOL()=0 .AND. MROW()=0    &&  Close Window
               KeyCode=27   &&  ESC
            CASE MCOL()>=ScrnLeft  .AND. MCOL()<=ScrnRight .AND. ;
                  MROW()>=WindowTop .AND. MROW()<=ScrnBot
               MouseMove=.T.  &&  Mouse is within the window so move HighLite
               EXIT
            **  --  OTHERWISE Mouse Click has no meaning
            ENDCASE

            IF KeyCode#151 &&  Press was translated to a key press code
               IF LastCode = KeyCode
                  MouseDelay = 0.0     &&  No delay for mouse repeate
               ELSE  && reset delay and keypress
                  MouseDelay = 0.4     &&  delay for 1st click
                  LastCode = KeyCode
               ENDIF
               EXIT
            ENDIF

         ELSE
            EXIT
         ENDIF
      ENDDO

      SET COLOR TO G+/N         &&  Turn Highlite Off
      @ CurRow,ScrnLeft TO CurRow+2,ScrnRight CLEAR
      IF PK->Rec_no#0     &&  Record is tagged so display pointers
         @ CurRow,ScrnLeft SAY CHR(16)    &&  Left tag Pointer
         @ CurRow,ScrnRight SAY CHR(17)    &&  Right tag Pointer
      ENDIF
      @ CurRow,2 SAY Job_no PICTURE "9999"
      @ CurRow,7 SAY Gc_no PICTURE "99"
      @ CurRow,10 SAY Job_bid_no PICTURE "9999"
      @ CurRow,24 SAY Job_no_adr PICTURE "999999"
      @ CurRow,31 SAY Job_st_adr PICTURE "XXXXXXXXXXXXXXXXXXXX"
      SET COLOR TO R+/N
      @ CurRow,15 SAY Job_price PICTURE "99999.99"
      SET COLOR TO G+/N
      @ CurRow,52 SAY Subdiv PICTURE "XXXXXXXXXXXXXXX"
      @ CurRow+1,19 SAY Cust_first PICTURE "XXXXXXXXXX"
      @ CurRow+1,30 SAY Cust_last PICTURE "XXXXXXXXXXXXXXX"
      @ CurRow+1,52 SAY Cust_hm_ph PICTURE "9999999"
      @ CurRow+1,60 SAY Cust_wk_ph PICTURE "9999999"
      SET COLOR TO G/N
      @ CurRow+1,7 SAY "Owners Name "
      @ CurRow+1,46 SAY "Phone "
      SET COLOR TO BG+/N
      @ CurRow+2,2 SAY ""
      SET COLOR TO G+/N
      IF MouseMove         &&  move highlite to mouse row
         MouseMove = .F.
         SKIP INT((MROW()-ScrnTop)/3)-INT((CurRow-ScrnTop)/3)
         CurRow=ScrnTop+INT((MROW()-ScrnTop)/3)*3
         KeyCode=32     &&  Tag/Untag
      ENDIF
      *-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
   ENDDO         while .T.         Main Loop
   *=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
   RELEASE window ZoomIn
   RELEASE window ZoomOut
ELSE  &&  Fatal error
   SET COLOR TO W+/R
   ?? CHR(7)
   DEFINE WINDOW PkWindow FROM 10,20 TO 13,24+LEN(PkError) DOUBLE ;
      TITLE '[ FATAL ERROR ]'
   ACTIVATE WINDOW PkWindow
   @ 0,2 SAY PkError
   @ 1,3 SAY '< Press any key >'
   ans=INKEY(0,'M')
   RELEASE WINDOW PkWindow
ENDIF PkError = ''
*
* ---Closing operations.
SET COLOR OF SCHEME 1 TO &PickSch1  &&  Restore Colors   [FoxPro]
SET COLOR OF SCHEME 2 TO &PickSch2  &&  Restore Colors   [FoxPro]
SELECT JOB
USE
IF LEFT(PkError,3)#'ERR'
  SELECT PK   &&  Close Pick file
  USE
ENDIF
SELECT &WorkArea          &&  restore the work area
RETURN
* EOF: PK_JP.PRG
