* Program.: PK_J1.PRG
* Author..: Charles Alan Butler    
* Date....: 03/16/90
* Notice..: Copyright (c) 1990,MIS Consulting, All Rights Reserved
* Notes...: Template Ver(9.1) 3/11/90 *CAB*     Menu Code : MCT
* Notes...: Target Language is FoxBase Version 2.1 .
* Notes...: Database Pick List.  SPACE and ENTER will tag records.
* Notes...: Multiple choice, Ctrl-End causes an exit from list.
* Notes...: Multiple lines per record

** -- Save some of the calling environment
SAVE SCREEN TO PickScrn
PickColor=SYS(2001,"COLOR")  &&  SAVE Colors   [Fox 2.1]
WorkArea=CHR(64+SELECT())    &&  Save the work area

* ---Open the database file--- *
SELECT 0
USE JOBFILE INDEX JOB_NO ALIAS JOB
SELECT JOB
SET ORDER TO  1          &&  set up for index
SELECT JOB

**  --  Test Main DBF for records  --  **
*====================================================================
*  Can not use RECCOUNT()  in case a filter is on or a filtered index
*  is being used,  this is slower than RECCOUNT(), so You may want to
*  delete the COUNT TO line and replace all 'DbfRec' occurrences with
*  RECCOUNT(), if you are not using a Filter or filtered index.
COUNT TO DbfRec
*====================================================================
IF DbfRec = 0
   PkError='Main DBF is empty..'
ELSE
   PkError = ''    &&  Used as a fall through error flag
ENDIF

**  --  Open PK.DBF to hold record pointers of marked records
IF .NOT. (FILE('PK_LIST.DBF').AND.FILE('PK_LIST.IDX'))
   PkError='ERROR!! Can not find PK_LIST.DBF or PK_LIST.IDX!'
ELSE
   SELECT 0
   USE PK_LIST INDEX PK_LIST ALIAS PK   &&   DBF to store selected items
   ZAP             &&  empty file
   SELECT JOB
   SET RELATION TO RECNO() INTO PK ADDITIVE
   PkArea=SELECT()    &&  used as a pointer - RECNO(PkArea)
ENDIF

IF PkError == ''   &&  Used as a fall through error flag
   **  ---  set up local variables  ---  **
   ScrollDir = 0      &&  Scroll Flag
   KeyCode=90         &&  Key code; set up for a new page
   NewPage=.T.        &&  Flag to display a new page
   PageTest = .F.     &&  Flag to test for a full page
   RecPoint=RECNO()   &&  Absolute record number
   PageTop=RecPoint   &&  Top of Page record pointer
   ScrnTop=5          &&  Top Window Row used to display a record
   WindowTop=2        &&  Top Window Row used to display a record
   ScrnLeft= 5        &&  Left Window Column
   ScrnRight=71       &&  Right Window Column
   zBotIn=19          &&  'IN' Bottom Window Row used to display a record
   zwBotIn=20         &&  'IN' Bottom Window Row of the window on the screen
   * Set Out window Bottom according to the Display size
   zBotOut=23           &&  'OUT' Bottom Window Row used to display a record
   zIn = .T.            &&  Force small window

   ** --  Correction for record counts less than window 'OUT' length  --  **
   RecPerPage=INT((zBotOut-WindowTop+1)/3)      &&  Records per page
   IF DbfRec < RecPerPage
      RecPerPage = DbfRec
   ENDIF
   zBotOut = RecPerPage*3+WindowTop-1

   ** --  Correction for record counts less than window 'IN' length  --  **
   RecPerPage=INT((zBotIn-ScrnTop+1)/3)   &&  Records per page
   IF DbfRec < RecPerPage
      RecPerPage = DbfRec
   ENDIF
   zBotIn = RecPerPage*3+ScrnTop-1
   zwBotIn=zBotIn + 4

   **  --  Test for a target to seek and a return value  --  **
   TmpVar = SYS(14,1)   &&  the Key expression
   IF TYPE('Target') # TYPE('&TmpVar')  &&  Type mismatch or undefined
      RELEASE Target
      PUBLIC Target
      Target = &TmpVar     &&  Set up to start pick list at current record
   ENDIF

   SET EXACT OFF
   SEEK Target
   SET EXACT ON
   IF  EOF()              &&  no match was found
      IF RECNO(0)=0       &&  no close match
         GOTO TOP
      ELSE
         GOTO RECNO(0)    &&  nearest match
      ENDIF
   ENDIF
   PageTest = .T.         &&  full page test needed
   Null = SYS(2002)   &&  Turn the cursor off   [Fox 2.1]

   **  ================  get & process commands  ======================
   DO WHILE .T.

      DO CASE
      CASE KeyCode=90.OR.KeyCode=122                           &&  [Zz] Zoom
         NewPage=.T.
         IF zIn                     &&  Zoom In
            zIn = .NOT. zIn
            ScrnBot=zBotIn          &&  Bottom Screen Row
            ScrnTop=5                   &&  Top Window Row used to display a record
            WindowTop=3             &&  Top Window Row used to display a record
         ELSE                       &&  Zoom Out
            zIn = .NOT. zIn
            ScrnBot=zBotOut         &&  Bottom Screen Row
            ScrnTop=2              &&  Top Window Row used to display a record
            WindowTop=0
         ENDIF
         RecPerPage=(ScrnBot-ScrnTop+1)/3      &&  Records per page
         RecPoint=RECNO()
         PageTest = .T.         &&  full page test needed

         wThumb = INT((ScrnBot-WindowTop)/2)+WindowTop

         **  --  Display Window  --  **
         RESTORE SCREEN FROM PickScrn
         SET COLOR TO BR/N
         @ WindowTop+0,4,ScrnBot+1,72 BOX " "
         SET COLOR TO BG+/BR
         @ WindowTop+0,27 SAY "[  J O B   F I L E  ]"
         @ ScrnBot+1,8 SAY "F1-Help"
         @ ScrnBot+1,27 SAY "[ Press ENTER to Select ]"
         SET COLOR TO BG+/N
         @ WindowTop+1,6 SAY "Job#"
         @ WindowTop+1,11 SAY "Gc"
         @ WindowTop+1,14 SAY "Bid#"
         @ WindowTop+1,28 SAY "Street"
         @ WindowTop+1,35 SAY "Address"
         @ WindowTop+1,19 SAY "  Price "
         @ WindowTop+1,56 SAY "Subdivision"
         SET COLOR TO G/N
         @ WindowTop+3,11 SAY "Owners Name "
         @ WindowTop+3,50 SAY "Phone "
         SET COLOR TO BG+/N
         @ WindowTop+4,6 SAY ""
         SET COLOR TO G+/N

      CASE KeyCode=32.OR.KeyCode=13          &&  [Space] or [Enter] to tag / untag
         SELECT PK
         IF EOF()          &&  item is not tagged so tag it
            SEEK 0
            IF EOF()       &&  use any records set to 0 before appending
               APPEND BLANK
            ENDIF
            REPLACE Rec_no WITH RECNO(PkArea)
         ELSE              &&  record was tagged so untag it
            REPLACE Rec_no WITH 0
         ENDIF
         SELECT JOB
         IF PK->Rec_no#0     &&  Record is tagged so display pointers
            @ CurRow,ScrnLeft SAY CHR(16)    &&  Left tag Pointer
            @ CurRow,ScrnRight SAY CHR(17)    &&  Right tag Pointer
         ELSE     &&  Untag so remove pointers
            @ CurRow,ScrnLeft SAY ' '
            @ CurRow,ScrnRight SAY ' '
         ENDIF
         KeyCode=24
         LOOP

      CASE KeyCode=84.OR.KeyCode=116               &&  [Tt] to tag ALL
         NewPage=.T.
         GO TOP
         DO WHILE .T.
            SELECT PK
            IF EOF()       &&  item is not tagged so tag it
               SEEK 0      &&  use any records set to 0 before appending
               IF EOF()    &&  none found, so add one
                  APPEND BLANK
               ENDIF
               REPLACE Rec_no WITH RECNO(PkArea)
            ENDIF
            SELECT JOB
            SKIP
            IF EOF()
               EXIT
            ENDIF
         ENDDO
         GO TOP   &&  Reset pointer

      CASE KeyCode=67.OR.KeyCode=99                &&  [Cc] to Clear ALL
         SELECT PK
         ZAP
         SELECT JOB
         @ ScrnTop,ScrnLeft TO ScrnBot,ScrnLeft CLEAR  &&  marks
         @ ScrnTop,ScrnRight TO ScrnBot,ScrnRight CLEAR  &&  marks

      CASE KeyCode=77.OR.KeyCode=109              &&  [Mm] Tag/Untag Matching
         Null = SYS(2002,1)        &&  Turn the cursor on       [Fox 2.1]
         SAVE SCREEN TO PksScrn
         @ 09,14,13,66 BOX "ͻȺ "
         @ 09,25 SAY "[ Tag/Untag Matching Records ]"
         @ 10,27 SAY ""
         TagAll=.T.    &&  T = Tag     U = Untag
         Tmp='T'
         PkMatch = 0
         @ ROW(),17 SAY 'Tag or Untag matching records. (T/U):' GET Tmp PICTURE '!' Valid Tmp$'TU'
         PkMatch2 = 0
         @ ROW()+1,17 SAY 'Tag ALL starting with :' GET PkMatch  PICTURE '9999'
         @ ROW(),COL()+2 SAY '0 = Start of file.'
         @ ROW()+1,17 SAY '      and ending with :' GET PkMatch2 PICTURE '9999'
         @ ROW(),COL()+2 SAY '0 = End of file.'
         READ
         TagAll = (Tmp='T')    &&  T = Tag     U = Untag
         IF READKEY()=12 .OR. READKEY()=268 ;
               .OR.(PkMatch = 0 .AND. PkMatch2 = 0)
         ELSE
            OldPoint=RECNO()
            IF PkMatch2 = 0    &&  Get end of range
               Go Bottom
               PkMatch2 = JOB_NO
            ENDIF
            if PkMatch = 0
               GO TOP
               PkMatch = JOB_NO
            else
               SEEK PkMatch
            endif
            IF EOF()
         @ 09,14,13,66 BOX "ͻȺ "
               @ 10,27 SAY ''
               @ ROW(),17 SAY '****  No matching records!  ****'
               GOTO OldPoint
               ans=INKEY(0)   &&  Wait for key press
            ELSE
               NewPage=.T.
               DO WHILE JOB_NO>=PkMatch .AND. JOB_NO<=PkMatch2 .AND..NOT. EOF()
                  SELECT PK
                  IF TagAll  &&  Matching Records
                     IF EOF()   &&  item is not tagged
                        SEEK 0
                        IF EOF()    &&  use any records set to 0 before appending
                           APPEND BLANK
                        ENDIF
                        REPLACE Rec_no WITH RECNO(PkArea)
                     ENDIF
                  ELSE  &&  Untag Matching Records
                     IF .NOT. EOF()   &&  item was tagged
                        REPLACE Rec_no WITH 0
                     ENDIF
                  ENDIF
                  SELECT JOB
                  SKIP
               ENDDO
               SEEK PkMatch           &&  reposition pointer
               PageTest = .T.         &&  full page test needed
            ENDIF
         ENDIF eof()
         Null = SYS(2002)   &&  Turn the cursor off   [Fox 2.1]
         RESTORE SCREEN FROM PksScrn

      CASE KeyCode=83.OR.KeyCode=115                       &&  [Ss]   Search
         SAVE SCREEN TO PksScrn
         @ 09,21,13,59 BOX "ͻȺ "
         @ 09,25 SAY "[ Search for Matching Records ]"
         @ 10,27 SAY ""
         Null = SYS(2002,1)        &&  Turn the cursor on       [Fox 2.1]
         PkMatch = 0
         @ ROW()+1,24 SAY 'Enter Search Key :' GET PkMatch PICTURE '9999'
         READ
         IF READKEY()=12 .OR. READKEY()=268
            **  --  Search Aborted
         ELSE
            NewPage=.T.
            PageTest = .T.         &&  full page test needed
            SEEK PkMatch
            IF EOF()
               @ 09,21,13,59 BOX "ͻȺ "
               @ 10,27 SAY ''
               @ ROW(),24 SAY 'No match!'
               IF RECNO(0)=0       &&  no close match
                  @ ROW()+1,24 SAY 'Returning to top of file.'
                  GOTO TOP
               ELSE
                  @ ROW()+1,24 SAY 'Returning to nearest match.'
                  GOTO RECNO(0)    &&  nearest match
               ENDIF
               ans=INKEY(0)   &&  Wait for key press
            ELSE     &&  Found
               RecPoint=recno()
            ENDIF
         ENDIF eof()
         Null = SYS(2002)   &&  Turn the cursor off   [Fox 2.1]
         RESTORE SCREEN FROM PksScrn

      CASE KeyCode=3.OR.KeyCode=51                               &&  [PgDn]
         IF CurRow = ScrnBot-2  &&  at last row, so go to next page
            NewPage=.T.
            SKIP 1         &&  test to see if at last record
            IF EOF()       &&  yes, so wrap to top of file
               GO TOP
            ELSE           &&  test for full page
               SKIP RecPerPage-1
               IF EOF()               &&  last page is not a full one,
                  GO BOTTOM           &&  so make last page full
               ENDIF
               RecPoint=RECNO()
               SKIP -RecPerPage +1    &&  to top of page
            ENDIF
         ELSE                &&  move to last row of page then skip
            SKIP (ScrnBot - CurRow)/3
            CurRow = ScrnBot-2
         ENDIF

      CASE KeyCode=18.OR.KeyCode=57                              &&   [PgUp]
         IF CurRow = ScrnTop  &&  at first row, so go to previous page
            NewPage=.T.
            SKIP -1        &&  test to see if at 1st record
            IF BOF()       &&  yes, so wrap to bottom
               GO BOTTOM
               RecPoint=RECNO()
               SKIP -(RecPerPage-1)
            ELSE           &&  test for full page
               SKIP -(RecPerPage-1)
               IF BOF()       &&  first page is not a full one,
                  GO TOP      &&  so make first page full
               ENDIF
               RecPoint=RECNO()
            ENDIF
         ELSE                 &&  move to first row of page then skip
            SKIP -(CurRow - ScrnTop)/3
            CurRow = ScrnTop
         ENDIF

      CASE KeyCode=1.OR.KeyCode=55                               &&  [Home]
         GO TOP               &&  cursor to beginning of file
         NewPage=.T.

      CASE KeyCode=6.OR.KeyCode=49                               &&  [End]
         GO BOTTOM
         RecPoint=RECNO()
         SKIP -(RecPerPage-1)
         NewPage=.T.

      CASE KeyCode=5.OR.KeyCode=56.OR.KeyCode=19.OR.KeyCode=52   &&  [Up]  [Left]
         IF CurRow=ScrnTop    &&  at top of page, so scroll
            ScrollDir = -1
         ELSE                 && move HighLite up one row
            CurRow=CurRow -3
            SKIP -1           && move pointer up one record
         ENDIF

      CASE KeyCode=24.OR.KeyCode=50.OR.KeyCode=4.OR.KeyCode=54   &&  [Down]  [Right]
         IF CurRow=ScrnBot-2    &&  at bottom of page, so scroll
            ScrollDir = 1
         ELSE                 && move HighLite down one row
            CurRow=CurRow +3
            SKIP 1            && move pointer up one record
         ENDIF

      CASE KeyCode=27                                     &&  [ESC]  -- Abort
         SELECT PK
         ZAP             &&  Remove any picks from the database
         EXIT

      CASE KeyCode=23                                  &&  [Ctrl] [End] -- Exit
         EXIT

      CASE KeyCode=74.OR.KeyCode=106                          &&  [Jj]  --  Jump
         SAVE SCREEN TO PksScrn
         @ 10,15,12,61 BOX "ͻȺ "
         JumpVal=0
         Null = SYS(2002,1)        &&  Turn the cursor on       [Fox 2.1]
         @ 11,17 SAY 'Enter the number of records to jump:' GET JumpVal PICTURE '99999'
         READ
         IF JumpVal # 0
            NewPage = .T.
            SKIP JumpVal     &&  test to see if at 1st record
            DO CASE
            CASE EOF()       &&  at bottom of file, so position for last page
               GO BOTTOM
               RecPoint=RECNO()
               SKIP -(RecPerPage-1)
            CASE BOF()       &&  at top of file, so position for first page
               GO TOP
            OTHERWISE        &&  test for full page
               RecPoint=RECNO()
               PageTest = .T.
            ENDCASE
         ENDIF JumpVal # 0
         Null = SYS(2002)   &&  Turn the cursor off   [Fox 2.1]
         RESTORE SCREEN FROM PksScrn

      CASE KeyCode=28.OR.KeyCode=72.OR.KeyCode=104      &&  [F1] [Hh]  Help
         SAVE SCREEN TO PksScrn
         SET COLOR TO G+/N          &&  put up the window
         @ 2,10,21,66 BOX "ͻȺ "
         @ 2,30 SAY '[  HELP WINDOW  ]'
         @ 3,30 SAY ''
         @ ROW(),12 SAY '----KEY-------------ACTION--------------------------'
         @ ROW()+1,12 SAY '  [ESC]    Exit list without selecting an item.'
         @ ROW()+1,12 SAY '[Ctrl][End] Save select items and exit.'
         @ ROW()+1,12 SAY '  [Enter]  Tag or Untag a record.'
         @ ROW()+1,12 SAY '  [Space]  Tag or Untag a record.'
         @ ROW()+1,12 SAY '  [C]      Clear ALL tagged records.'
         @ ROW()+1,12 SAY '  [T]      Tag ALL records.'
         @ ROW()+1,12 SAY '  [M]      Tag/Untag Matching Records.'
         @ ROW()+1,12 SAY '  [J]      Jump a number of records.'
         @ ROW()+1,12 SAY '  [S]      Search on key field.'
         @ ROW()+1,12 SAY '  Arrows   Cursor keys move the selection pointer.'
         @ ROW()+1,12 SAY '  [PgDn]   To page bottom or to the next page.'
         @ ROW()+1,12 SAY '  [PgUp]   To page top or to the previous page.'
         @ ROW()+1,12 SAY '  [Home]   Display the first page.'
         @ ROW()+1,12 SAY '  [End]    Display the last page.'
         @ ROW()+1,12 SAY '  [Z]      Zoom window in and out.'
         @ ROW()+1,12 SAY '  [F1] [H] Displays this screen.'
         @ ROW()+1,12 SAY ' <  Press Key for Command, Any Other To Return  >'
         KeyCode=INKEY(0)
         SET COLOR TO G+/N
         RESTORE SCREEN FROM PksScrn
         IF KeyCode#27     &&  Do not abort from this window
            LOOP
         ENDIF

      ENDCASE

      *=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
      **          Window display routines
      *=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

      IF ScrollDir # 0     &&  Scroll screen Up or Down
         SKIP ScrollDir    &&  Move record pointer
         DO CASE
         CASE EOF()    &&  Wrap to top of file
            GO TOP
            NewPage=.T.
         CASE BOF()    &&  Wrap to Bottom of file
            GO BOTTOM
            RecPoint=RECNO()
            SKIP -(RecPerPage-1)
            NewPage=.T.
         OTHERWISE      &&  Scroll one line
            Scroll ScrnTop,ScrnLeft,ScrnBot,ScrnRight,ScrollDir*3   &&  [Fox 2.1]
            CurRow = IIF(ScrollDir=-1,ScrnTop,ScrnBot-2)   && position cursor
         ENDCASE
         ScrollDir = 0
      ENDIF ScrollDir # 0

      IF NewPage                 &&  display a new page
         NewPage=.F.             &&  reset flag
         IF RecPoint=0
            RecPoint = RECNO()  &&  reposition record pointer
         ENDIF
         IF PageTest      &&  Test for full page to display
            SKIP RecPerPage-1
            IF EOF()               &&  last page is not a full one,
               GO BOTTOM           &&  so make last page full
            ENDIF
            SKIP -RecPerPage +1    &&  to top of page
            PageTest = .F.
         ENDIF PageTest

         **  --  display a new page  ---------------------
         SET COLOR TO G+/N
         @ ScrnTop,ScrnLeft TO ScrnBot,ScrnRight CLEAR  &&  window
         cnt=0
         DO WHILE cnt<RecPerPage
            rw=cnt*3+ScrnTop
            IF PK->Rec_no#0     &&  Record is tagged so display pointers
               @ rw,ScrnLeft SAY CHR(16)    &&  Left tag Pointer
               @ rw,ScrnRight SAY CHR(17)    &&  Right tag Pointer
            ENDIF
            @ rw,6 SAY Job_no PICTURE "9999"
            @ rw,11 SAY Gc_no PICTURE "99"
            @ rw,14 SAY Job_bid_no PICTURE "9999"
            @ rw,28 SAY Job_no_adr PICTURE "999999"
            @ rw,35 SAY Job_st_adr PICTURE "XXXXXXXXXXXXXXXXXXXX"
            SET COLOR TO R+/N
            @ rw,19 SAY Job_price PICTURE "99999.99"
            SET COLOR TO G+/N
            @ rw,56 SAY Subdiv PICTURE "XXXXXXXXXXXXXXX"
            @ rw+1,23 SAY Cust_first PICTURE "XXXXXXXXXX"
            @ rw+1,34 SAY Cust_last PICTURE "XXXXXXXXXXXXXXX"
            @ rw+1,56 SAY Cust_hm_ph PICTURE "9999999"
            @ rw+1,64 SAY Cust_wk_ph PICTURE "9999999"
            SET COLOR TO G/N
            @ rw+1,11 SAY "Owners Name "
            @ rw+1,50 SAY "Phone "
            SET COLOR TO BG+/N
            @ rw+2,6 SAY ""
            SET COLOR TO G+/N
            IF RecPoint=RECNO()          &&  Cursor record number to top of page
               CurRow = ScrnTop + cnt*3    &&  Place Cursor pointer
            ENDIF
            cnt=cnt+1
            SKIP
         ENDDO while cnt<RecPerPage

         GOTO RecPoint       &&  reposition record pointer to top of page
         RecPoint=0
      ENDIF  NewPage=.T.

      SET COLOR TO w+/r           &&  Turn High Lite On
      @ CurRow,ScrnLeft TO CurRow+2,ScrnRight CLEAR
      IF PK->Rec_no#0     &&  Record is tagged so display pointers
         @ CurRow,ScrnLeft SAY CHR(16)    &&  Left tag Pointer
         @ CurRow,ScrnRight SAY CHR(17)    &&  Right tag Pointer
      ENDIF
      @ CurRow,6 SAY Job_no PICTURE "9999"
      @ CurRow,11 SAY Gc_no PICTURE "99"
      @ CurRow,14 SAY Job_bid_no PICTURE "9999"
      @ CurRow,28 SAY Job_no_adr PICTURE "999999"
      @ CurRow,35 SAY Job_st_adr PICTURE "XXXXXXXXXXXXXXXXXXXX"
      @ CurRow,19 SAY Job_price PICTURE "99999.99"
      @ CurRow,56 SAY Subdiv PICTURE "XXXXXXXXXXXXXXX"
      @ CurRow+1,23 SAY Cust_first PICTURE "XXXXXXXXXX"
      @ CurRow+1,34 SAY Cust_last PICTURE "XXXXXXXXXXXXXXX"
      @ CurRow+1,56 SAY Cust_hm_ph PICTURE "9999999"
      @ CurRow+1,64 SAY Cust_wk_ph PICTURE "9999999"
      @ CurRow+1,11 SAY "Owners Name "
      @ CurRow+1,50 SAY "Phone "
      @ CurRow+2,6 SAY ""

      KeyCode=INKEY(0)          &&  get KEY COMMAND  ******************

      SET COLOR TO G+/N         &&  Turn Highlite Off
      @ CurRow,ScrnLeft TO CurRow+2,ScrnRight CLEAR
      IF PK->Rec_no#0     &&  Record is tagged so display pointers
         @ CurRow,ScrnLeft SAY CHR(16)    &&  Left tag Pointer
         @ CurRow,ScrnRight SAY CHR(17)    &&  Right tag Pointer
      ENDIF
      @ CurRow,6 SAY Job_no PICTURE "9999"
      @ CurRow,11 SAY Gc_no PICTURE "99"
      @ CurRow,14 SAY Job_bid_no PICTURE "9999"
      @ CurRow,28 SAY Job_no_adr PICTURE "999999"
      @ CurRow,35 SAY Job_st_adr PICTURE "XXXXXXXXXXXXXXXXXXXX"
      SET COLOR TO R+/N
      @ CurRow,19 SAY Job_price PICTURE "99999.99"
      SET COLOR TO G+/N
      @ CurRow,56 SAY Subdiv PICTURE "XXXXXXXXXXXXXXX"
      @ CurRow+1,23 SAY Cust_first PICTURE "XXXXXXXXXX"
      @ CurRow+1,34 SAY Cust_last PICTURE "XXXXXXXXXXXXXXX"
      @ CurRow+1,56 SAY Cust_hm_ph PICTURE "9999999"
      @ CurRow+1,64 SAY Cust_wk_ph PICTURE "9999999"
      SET COLOR TO G/N
      @ CurRow+1,11 SAY "Owners Name "
      @ CurRow+1,50 SAY "Phone "
      SET COLOR TO BG+/N
      @ CurRow+2,6 SAY ""
      SET COLOR TO G+/N
      *-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
   ENDDO         while .T.         Main Loop
   *=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
ELSE  &&  Fatal error
   SET COLOR TO W+/R
   ?? CHR(7)
   @ 10,20,12,24+LEN(PkError) BOX "ͻȺ "
   @ 11,22 SAY PkError
   @ 12,32 SAY '< Press any key >'
   ans=INKEY(0)
ENDIF PkError = ''
*
* ---Closing operations.
SET COLOR TO &PickColor
RESTORE SCREEN FROM PickScrn
Null = SYS(2002,1)        &&  Turn the cursor on       [Fox 2.1]
SELECT JOB
USE
IF LEFT(PkError,3)#'ERR'
  SELECT PK   &&  Close Pick file
  USE
ENDIF
SELECT &WorkArea          &&  restore the work area
RETURN
* EOF: PK_J1.PRG
