<<* PickMain.INC *>>
<<**Start Comment**
            FOXCODE TEMPLATE VARIABLES
-=< string >=-
fuser             User field from the Box object in the FoxView table
HighLite          Color to set the highlited records
Temp              Many uses
ReturnField       Name of the field to return from the picklist
box               Box string characters
DbfAlias          Name of the alias of the main database
VersionName       The template version name and date
SkipMenuFlag      Holds the skip menu character flags
prgname           Used to retrieve the program name, etc.
fpath             Used to retrieve the program name, etc.
fname             Used to retrieve the program name, etc.
fext              Used to retrieve the program name, etc.
fieldcolor        Color to set the fields (not highlited)
MouseCodes        Help window Key codes string used for mouse row decoding
IndexPicture      Index picture from user field for the Tag Matching Records routine
DefIndexValue     Default index value from user field, used by Matching Records
IndexType         Index type from FoxView for the Tag Matching Records routine
IndexExpression   Index key expression
OmitFeatureFlag   Feature to omit from the prg generated

-=< integer >=-
IndexOrder        Holds the Fox index order number from the user
LinesPerRec       User flag for the lines per record in the display
Tmp               Many uses
RowOffset         Top row of the window; 0 in FoxPro, relative to screen in FoxBase
TopRowBox         Top row of the window relative to the screen
LastHelpLine      Number of lines in the help window
ScrnOfSet         Window col offset used in the help window
WindowBot         Rows in the window including borders
RightMarg         Used in tag list to clear the margin properly
BaseLine          First line in the window to hold field data
ColOffset         Left col of the window; 0 in FoxPro, relative to screen in FoxBase
WindowBotABS      Bottom of window relative to the screen
indent            Number of tabs to indent the output code
lasthue           Last color of the last SET COLOR
BoxWidth          Tag Matching routine input box width

-=< logical >=-
FoxPro            True if target language is FoxPro
ENTER_Exit        True if the ENTER key causes an exit
TagOnly           True if the pick list is a tag only
MultiPick         True if more than one pick is allowed
MultiLine         True if more than one line per record
ColorIsOk         Flag used to suppress the SET COLOR statement
MatchingIsOk      Flags missing index info for Tag Matching routine
ReturnFunction    Flag to return a value only

**End Comment**>>

<<#
procedure GenColorAtrSay
<<*  special version of GenColorAtr, no SAY/GET test *>>
integer lastatr
begin
lastatr := forecolor
if (fldatr <> lastatr)
   gen( 'SET COLOR TO ' )
   genln( AtrCode(fldatr) )
   forecolor := fldatr
endif
end    <<*GenColorAtr*>>


Procedure AtSay (RowStr : string)
<<*  generate the SAY statements for the record display  *>>
begin
SetIndent(2)
if MultiPick 
   genln('IF PK->Rec_no#0     &&  Record is tagged so display pointers')
   genln('   @ ',RowStr,',ScrnLeft SAY CHR(16)    &&  Left tag Pointer')
   genln('   @ ',RowStr,',ScrnRight SAY CHR(17)    &&  Right tag Pointer')
   genln('ENDIF')
endif
<<*  Generate the SAYs needed to display the records  *>>
select all
forall (fldtyp $ 'CDLN') and (fldals = 'M') and not fldnap
   if ColorIsOk  <<*  Color is Ok for text objects in MultiLines *>>
      GenColorAtrSay      <<*  Test for color change *>>
   endif
   gen( '@ ',RowStr,',',fldcol-ColOffset,' SAY ')
   if ('PK_QUAN'=upper(fldnam))
     gen( 'PK->'+ ljust( fldnam,10 ))
   else
     gen( 'M->' + ljust( fldnam,10 ))
   endif
   GenPicture
   genln  <<*Send CR/LF*>>
endfor
forall databases
   forall (fldtyp $ 'CDLN') and not fldnap
      if ColorIsOk  <<*  Color is Ok for text objects in MultiLines *>>
         GenColorAtrSay      <<*  Test for color change *>>
      endif
      if MultiLine
         if (fldrow = BaseLine-1) and not fldsid
            gen( '@ ',RowStr,',')
         elseif (fldrow = BaseLine) and fldsid
            gen( '@ ',RowStr,',')
         else
            gen( '@ ',RowStr,'+',fldrow-BaseLine,',')
         endif
      else
         gen( '@ ',RowStr,',')
      endif
      if fldsid
         gen(len(fldlab)+fldcol-ColOffset)
      else
         gen(fldcol-ColOffset)
      endif
      gen(' SAY ')
      if fldals = 'A'  <<* PRIMARY workarea *>>
         gen(fldnam)
      elseif dbfals 
         gen( dbfals + '->' + ljust( fldnam,10 ))
      else
         filespec( dbfnam,fpath,fname,fext )
         gen( fname + '->' + ljust( fldnam,10 ))
      endif
      GenPicture
      genln  <<*Send CR/LF*>>
   endfor
endfor

<<*if MultiLine   <<*  Display text objects and labels  *>>
   lasthue := 0  <<* force SET COLOR *>>
   forall (fldtyp $ 'CDLNT') and not fldnap
      if fldlab and (fldrow>BaseLine-1) and (fldrow<>WindowBotABS)
         if ColorIsOk  <<*  Color is Ok for text objects in MultiLines *>>
            GenColorHue      <<*  Test for color change *>>
         endif
         genln( '@ ',RowStr,'+',fldrow-BaseLine,',',fldcol-ColOffset,' SAY "',fldlab,'"')
      endif
   endfor
   if ColorIsOk  <<*  Color is Ok for text objects in MultiLines *>>
      genln( 'SET COLOR TO ',fieldcolor)
   endif
<<*endif  debug  *>>

RestoreIndent(2)
end   <<*  Procedure AtSay  *>>

<<*===================================================================*>>
procedure ProgramBody( procfile : string )
<<*===================================================================*>>
string  fuser,HighLite,Temp,ReturnField,box,DbfAlias,IndexPicture
string  VersionName,SkipMenuFlag,MouseCodes,DefIndexValue,IndexType
string  IndexExpression,OmitFeatureFlag
integer IndexOrder,LinesPerRec,Tmp,RowOffset,TopRowBox,BoxWidth
integer LastHelpLine,ScrnOfSet,WindowBot,RightMarg
logical FoxPro,ENTER_Exit,TagOnly,MatchingIsOk,ReturnFunction


begin
VersionName := 'Ver(9.1) 3/11/90 *CAB*'
select all
select fields on fldtyp = 'B'
<<* Assumes the first box object is the window *>>
if fldtyp <> 'B'
   WAIT 'No Box defined!! Generation terminated.'
   HALT  
endif
SkipMenuFlag := Upper(GetUser(6,fldusr))
<<**Start Comment**
     Skip Menu Flag allows using preset menu choices.  ;PMET;

     Menu 1         Menu 2            Menu 3             Menu 4
   ------------------------------------------------------------------
    Language      Menu Type         Exit Key             Tag Type
   P = foxPro   S = Single pick  E = ENTER exit     T = Tag only pick
   B = foxBase  M = Multi pick   C = CTRL-END exit  Q = Quantity tag 

   If both characters in a pair are included, the first in each pair 
   will take precedence. Pairs = PB SM EC TQ     If both are missing, 
   the menu is activated. If 'S' is included, menus 3 & 4 are ignored.
**End Comment**>>
OmitFeatureFlag := Upper(GetUser(7,fldusr))
if upper(left(OmitFeatureFlag,4)) = 'OFF-'    <<*  valadation key  *>>
   OmitFeatureFlag := upper(OmitFeatureFlag)
else
   OmitFeatureFlag := ' '   <<*  disable flag  *>>
endif
<<**Start Comment**
   Fearures to omit from the prg being generated   ;OFF-JSCTMH;

      J = Jump (Skip) Records
      S = Search on key field
      C = Clear ALL tagged records
      T = Tag ALL records
      M = Tag/Untag Matching Records
      H = Help window

**End Comment**>>
select all
Tmp := 1
if 'P'$SkipMenuFlag
   <<* default to FoxPro Target language *>>
elseif 'B'$SkipMenuFlag
   Tmp := 2   <<*  FoxBase+ 2.1 *>>
else
   INITMENU('[ TARGET LANGUAGE ]')
   '1. FoxPro':'Generate code for FoxPro.'
   '2. FoxBase+':'Generate code for FoxBase+ Version 2.1'
   END
   MENU TO Tmp
   if Tmp = 0
      HALT
   endif
endif
FoxPro := (Tmp=1)
Tmp := 1
if 'S'$SkipMenuFlag
   <<* default to Select *>>
elseif 'M'$SkipMenuFlag
   Tmp := 2
else
   INITMENU('[ PICK LIST TYPE ]')
   '1. Single selection list.':'Allows only one selection from the list.'
   '2. Multi selection list.':'Allows selecting multiple records from the list.'
   END
   MENU TO Tmp
   if Tmp = 0
      HALT
   endif
endif
MultiPick := (Tmp=2)
ENTER_Exit  := True   <<*  ENTER = true *>>
IF MultiPick
   Tmp := 1       <<*  Get Key Press to Exit On  *>>
   if 'E'$SkipMenuFlag
      <<* default to first choice *>>
   elseif 'C'$SkipMenuFlag
      Tmp := 2
   else
      INITMENU('[ EXIT LIST VIA ]')
      '1. [ENTER] key.':'Pressing ENTER will cause and exit from the list.'
      '2. [Ctrl] [End] key.':'Pressing ENTER or SPACE will tag records.'
      END
      MENU TO Tmp
      if Tmp = 0
         HALT
      endif
   endif
   ENTER_Exit := Tmp=1  <<*  ENTER = true *>>
   Tmp := 1       <<*  Select 'Tag or Quantity' Pick Type  *>>
   if 'T'$SkipMenuFlag
      <<* default to first choice *>>
   elseif 'Q'$SkipMenuFlag
      Tmp := 2
   else
      INITMENU('[ TAG LIST TYPE ]')
      '1. Tag Item Only.':'Pressing SPACE will tag an item in the list.'
      '2. Quantity Tag.':'Tag records with a quantity via numeric input.'
      END
      MENU TO Tmp
      if Tmp = 0
         HALT
      endif
   endif
   TagOnly := Tmp=1  
   if not TagOnly
      select fields on (upper(fldnam) = 'PK_QUAN')
      if eof()
         wait 'Can not locate the field PK_QUAN to use as a quantity input.'
         wait 'Can not continue!!  Press any key.' to temp
         HALT
      endif
      if fldtyp <> 'N'
         wait 'Field PK_QUAN must be numeric.'
         wait 'Can not continue!!  Press any key.' to temp
         HALT
      endif
      select all
   endif
ENDIF
#>>
<<* ====================================================================
                        xBASE PROGRAM START
    ====================================================================*>>
<<* The "program" label returns the current program filename being generated *>>
<<filespec( program,fpath,fname,fext )>>
<<*---Rebuild the program filename without the PATH---*>>
<<prgname := fname + '.' + fext>>
* Program.: {prgname}
* Author..: {Author}
* Date....: {date}
* Notice..: Copyright (c) 1990, <<gen(Rtrim(Copyright))>>, All Rights Reserved
* Notes...: Template {VersionName}     Menu Code : {SkipMenuFlag}
<<# pragma
if FoxPro
   genln('* Notes...: Target Language is FoxPro.')
else
   genln('* Notes...: Target Language is FoxBase Version 2.1 .')
endif
if MultiPick  <<* Annotate the generated prg as to what options were chosen *>>
   gen('* Notes...: Database Pick List.  ')
   if TagOnly
      if ENTER_Exit
         genln('SPACE will tag records.')
      else
         genln('SPACE and ENTER will tag records.')
      endif
   else
      genln('Number keys select quantity.')
   endif
   if ENTER_Exit
      genln('* Notes...: Multiple choice, ENTER causes an exit from list.')
   else
      genln('* Notes...: Multiple choice, Ctrl-End causes an exit from list.')
   endif
else
      genln('* Notes...: Database Pick List.  One choice, ENTER selects.')
endif
lasthue := 0     <<*  Color test variable *>>
<<* Get Field Colors and the primary row *>>
forall  (fldtyp $ 'CDLN') and not fldnap
   if not fieldcolor    <<* from the first non text object field  *>>
      fieldcolor := AtrCode( fldatr )
      forecolor := fldatr
      if fldsid
         BaseLine := fldrow  <<* should be the top field row *>>
      else
         BaseLine := fldrow +1  <<* should be the top field row *>>
      endif
   endif
endfor
<<**Start Comment**
                  Get User Area of Box
     <HighLite Color>;<Close/Open>;<Index Order>;<FieldName>;<LinesPerRec>;;;
     Example:   GR+/N;Open;1;;;
     *Open* causes the Dbf to be selected as it is assumes to be open. 
     *Close* causes the Dbf to be opened and closed.
     *Index Order* may be a valid index number (0-7) or null  
     *ReturnFieldName* field to get return value from, may be RECNO()
     *Lines Per Record, default is one
     *[PMCT] Skip menu flag
     *[OFF-J] Omit Features Flag  
**End Comment**>>
Forall fldtyp = 'B'
  if not fuser      <<*  from the first box object *>>
    fuser := fldusr
  end
endfor
if ltrim(fuser)=''   <<*  user area not defined, so create defaults *>>
   fuser := 'W+/R;CLOSE;;'
endif
<<* Get HighLite Color from User Area *>>
HighLite := GetUser(1,fuser)
if HighLite = ""       <<*  get field color from box object *>>
   HighLite := AtrCode( fldatr )
endif
<<* Get the index order from User Area *>>
IndexOrder := VAL(GetUser(3,fuser))
<<* Get MultiLines Flag from User Area *>>
LinesPerRec := VAL(GetUser(5,fuser))
MultiLine := (LinesPerRec>1)
if not MultiLine
   LinesPerRec := 1
else
   genln('* Notes...: Multiple lines per record')
endif

genln
genln('** -- Save some of the calling environment')
if FoxPro
   genln('PickSch1=SCHEME(1)  &&  SAVE Colors   [FoxPro]')
   genln('PickSch2=SCHEME(2)  &&  SAVE Colors   [FoxPro]')
else
   genln('SAVE SCREEN TO PickScrn')
   genln('PickColor=SYS(2001,"COLOR")  &&  SAVE Colors   [Fox 2.1]')
endif
genln('WorkArea=CHR(64+SELECT())    &&  Save the work area')

<<*  Get the name of the field to return when picked  *>>
ReturnField := GetUser(4,fuser) 
if Upper(left(ReturnField,4)) = 'FUN-'
   ReturnField := stuff(ReturnField,1,4,'')  <<* remove FUN- *>>
   ReturnFunction := True     <<*  return a value only  *>>
endif
<<*========== Start of OPEN or SELECT the Database ===============*>>
select all
if 'CLOSE' = UPPER(GetUser(2,fuser))  <<* DBF is not open yet *>>
   genln
   genln('* ---Open the database file--- *')
   forall databases   <<* Create ->  USE dbf INDEX idx ALIAS alias *>>
      genln('SELECT 0')
      filespec( dbfnam,fpath,fname,fext )
      gen('USE ',fname)
      if dbfcount=1
         DbfAlias := fname
      endif
      if ndxnam
         filespec( ndxnam,fpath,fname,fext )
         gen(' INDEX ',fname)
      endif
      if dbfals
         gen(' ALIAS ',dbfals)
         if dbfcount=1
            DbfAlias := dbfals
         endif
      endif
      genln
   endfor
else                       <<* DBF is open, so select it *>>
   select database 1
   if dbfals
      genln('SELECT ',dbfals,'         &&  DBF was Open')
      if dbfcount=1
         DbfAlias := dbfals
      endif
   else
      filespec( dbfnam,fpath,fname,fext )
      genln('SELECT ',fname,'         &&  DBF was Open')
      if dbfcount=1
         DbfAlias := fname
      endif
   endif
   genln('rSave=RECNO()           &&  Save pointer from calling prg')
endif
select all
select database 1
if IndexOrder
 if ndxnam
   genln('SELECT ',DbfAlias)   <<*  Main Dbf  *>>
   genln('SET ORDER TO '+str(IndexOrder,2)+'          &&  set up for index')
 endif
endif
forall databases
   if relkey
      gen('SELECT ')
      if dbfals
         genln(dbfals)
      else
         filespec( dbfnam,fpath,fname,fext )
         genln(fname)
      endif
      forall relations
         genln('SET RELATION TO '+relkey+' INTO '+relals+' ADDITIVE')
      endfor
   endif
endfor
genln('SELECT ',DbfAlias)   <<*  Main Dbf  *>>
<<*========== End of OPEN or SELECT the Database ===============*>>
#>>

**  --  Test Main DBF for records  --  **
*====================================================================
*  Can not use RECCOUNT()  in case a filter is on or a filtered index
*  is being used,  this is slower than RECCOUNT(), so You may want to 
*  delete the COUNT TO line and replace all 'DbfRec' occurrences with
*  RECCOUNT(), if you are not using a Filter or filtered index.
COUNT TO DbfRec     
*====================================================================
IF DbfRec = 0
   PkError='Main DBF is empty..'
ELSE
   PkError = ''    &&  Used as a fall through error flag
ENDIF

<<IF MultiPick>> <<* Activate the Dbf to hold the selected records pointers *>>
**  --  Open PK.DBF to hold record pointers of marked records
IF .NOT. (FILE('PK_LIST.DBF').AND.FILE('PK_LIST.IDX'))
   PkError='ERROR!! Can not find PK_LIST.DBF or PK_LIST.IDX!'
ELSE
   SELECT 0
   USE PK_LIST INDEX PK_LIST ALIAS PK   &&   DBF to store selected items
   ZAP             &&  empty file
   SELECT {DbfAlias}
   SET RELATION TO RECNO() INTO PK ADDITIVE
   PkArea=SELECT()    &&  used as a pointer - RECNO(PkArea)
ENDIF
<<ENDIF>>

IF PkError == ''   &&  Used as a fall through error flag
   **  ---  set up local variables  ---  **
   ScrollDir = 0      &&  Scroll Flag
   KeyCode=90         &&  Key code; set up for a new page
   NewPage=.T.        &&  Flag to display a new page
   PageTest = .F.     &&  Flag to test for a full page
   RecPoint=RECNO()   &&  Absolute record number
   PageTop=RecPoint   &&  Top of Page record pointer
   <<# pragma
   <<* Get window parameters from BOX *>>
   SELECT FIELDS ON fldtyp = 'B'
   <<* Assumes the first box object is the window *>>
   if fldtyp <> 'B'
      WAIT 'No Box defined!! Generation terminated.'
      HALT  
   endif
   if FoxPro
      genln('   MouseMove = .F.    &&  Mouse Flag to move the highlite')
      genln('   MouseTime = 0      &&  Time keeper for mouse repeats')
      genln('   MouseDelay = 0.4   &&  Delay before the first repeat')
      genln('   LastCode = 0       &&  code of last key pressed')
      ColOffset := fldcol
      RowOffset := fldrow
   else
      ColOffset := 0
      RowOffset := 0
   endif
   TopRowBox := fldrow  <<*  Offset needed for Zooming *>>
   genln('   ScrnTop=',BaseLine-RowOffset,'          &&  Top Window Row used to display a record')
   genln('   WindowTop=',BaseLine-fldrow,'        &&  Top Window Row used to display a record')

   IF MultiPick         <<* This controls the window SCROLL & CLEAR area so    *>>
      RightMarg := 1    <<* that the tag symbol will scroll and clear properly *>>
   else                 <<* and nontag prgs can make use of the columns next   *>>
      RightMarg := 2    <<* to the border if needed.                           *>>
   endif
   genln('   ScrnLeft=',Str(fldcol -ColOffset +RightMarg,2),'        &&  Left Window Column')
   genln('   ScrnRight=',fldcol +fldwid -ColOffset -RightMarg,'       &&  Right Window Column')

   WindowBot := flddec   <<*  rows in the window including borders  *>>
   WindowBotABS := fldrow+WindowBot  <<*  bottom of window relative to the screen  *>>
   genln("   zBotIn=",fldrow+WindowBot-1-RowOffset,"          &&  'IN' Bottom Window Row used to display a record")
   genln("   zwBotIn=",fldrow+WindowBot,"         &&  'IN' Bottom Window Row of the window on the screen")

   genln('   * Set Out window Bottom according to the Display size')
   if FoxPro
      genln("   zBotOut=WROWS('')-2  &&  'OUT' Bottom Window Row used to display a record")
   else
      genln("   zBotOut=23           &&  'OUT' Bottom Window Row used to display a record")
   endif
   genln('   zIn = .T.            &&  Force small window')

   select all
   select database 1
   #>>
   <<*  Because of the alogrythem used to move the cursor and display the 
      pages, the window must be full. Therefore the following correction
      routine is required. *>>
           
   ** --  Correction for record counts less than window 'OUT' length  --  **
   RecPerPage=INT((zBotOut-WindowTop+1)/{LinesPerRec})      &&  Records per page
   IF DbfRec < RecPerPage
      RecPerPage = DbfRec
   ENDIF
   zBotOut = RecPerPage*{LinesPerRec}+WindowTop-1
   
   ** --  Correction for record counts less than window 'IN' length  --  **
   RecPerPage=INT((zBotIn-ScrnTop+1)/{LinesPerRec})   &&  Records per page
   IF DbfRec < RecPerPage
      RecPerPage = DbfRec
   ENDIF
   zBotIn = RecPerPage*{LinesPerRec}+ScrnTop-1
   <<Tmp := fldrow+1>>
   zwBotIn=zBotIn + {Tmp}
   
<<if ndxnam>>     <<*  Only valid if an index exist  *>>
   <<IndexPicture := GetUser(1,ndxusr)>>    <<* user must add quotes *>>
   <<DefIndexValue := GetUser(2,ndxusr)>>
   <<IndexType := ndxtyp>>
   <<IndexExpression := ndxkey>>
   <<if (ltrim(IndexPicture) = '') or (ltrim(DefIndexValue) = '')>>
      <<MatchingIsOk := false>>
      <<Tmp := 1>>
      <<initmenu('')>>     <<* this menu is a message only *>>
      <<' ==< WARNING >==< WARNING >==< WARNING >==< WARNING >=='>>
      <<'"Tag Matching Records" & "Search" will not be generated.'>>
      <<'The USER field in the first index of the first database'>>
      <<'should contain the index picture and the default index '>>
      <<'value. Examples are: '>>
      <<'  '>>
      <<' Character field index key which allows only upper case'>>
      <<'    with 6 characters is:    USER = "!!!!!!";"      ";'>>
      <<' Numeric key of 4 digits:    USER = "9999";0;'>>
      <<'  '>>
      <<'The entries must be in quotes and separated by semicolons.'>>
      <<'  '>>
      <<'Note also that FoxView does not set the index type, so'>>
      <<'you must change it to Numeric or Date. The Tag Matching'>>
      <<'records routine depends on this information.'>>
      <<end>>
      <<menu to Tmp>>   <<* this menu is a message only *>>
   <<else>>
      <<MatchingIsOk := true>>
   <<endif>>
   **  --  Test for a target to seek and a return value  --  **
   <<if IndexOrder>>
   TmpVar = SYS(14,{IndexOrder})   &&  the Key expression
   <<else>>
   TmpVar = SYS(14,1)            &&  the Key expression
   <<endif>>
   IF TYPE('Target') # TYPE('&TmpVar')  &&  Type mismatch or undefined
      RELEASE Target 
      PUBLIC Target 
      Target = &TmpVar     &&  Set up to start pick list at current record
   ENDIF
<<else>>
   <<if ReturnFunction>>  <<*  return a value only  *>>
   PRIVATE Target 
   <<else>>
   **  --  Test for a target to seek and a return value  --  **
   IF TYPE('Target') = 'U'
      PUBLIC Target           &&  Target was undefined, so set up to 
   ENDIF
   <<endif>>
<<endif>>
   
<<if ndxnam>>     <<*  Only valid if an index exist  *>>
   SET EXACT OFF
   SEEK Target      
   SET EXACT ON
   IF  EOF()              &&  no match was found
      IF RECNO(0)=0       &&  no close match
         GOTO TOP
      ELSE
         GOTO RECNO(0)    &&  nearest match
      ENDIF
   ENDIF
   PageTest = .T.         &&  full page test needed
<<endif>>
<<if FoxPro>>
   <<tmp := fldcol + fldwid>>
   **  --  Set Size of Display Windows  --  **
   define window ZoomIn FROM {fldrow},{fldcol} TO zwBotIn,{tmp} none
   define window ZoomOut FROM 0,{fldcol} TO zBotOut+1,{tmp} none 
<<else>>
   Null = SYS(2002)   &&  Turn the cursor off   [Fox 2.1]
<<endif>>
   
   **  ================  get & process commands  ======================
   DO WHILE .T.
<<if TagOnly>>
   <<*  do not generate this segment  *>>
<<else>>       <<*  convert [ENTER] and/or [SPACE] to [DOWN ARROW]  *>>
   <<if not MultiPick>>
      IF KeyCode=32                 &&  [SPACE]
   <<elseif ENTER_Exit and not TagOnly>>
      IF KeyCode=32                 &&  [SPACE]
   <<else>>   <<*  not ENTER_Exit and  not TagOnly  *>>
      IF KeyCode=13.OR.KeyCode=32   &&  [ENTER] or [SPACE]
   <<endif>>
          KeyCode = 24     &&  change to down arrow
      ENDIF
<<endif>>

      DO CASE
      CASE KeyCode=90.OR.KeyCode=122                           &&  [Zz] Zoom
         NewPage=.T.
         IF zIn                     &&  Zoom In
            zIn = .NOT. zIn
            ScrnBot=zBotIn          &&  Bottom Screen Row 
<<if FoxPro>>
            Hide window ZoomOut
            activate window ZoomIn 
<<else>>
   <<genln('            ScrnTop=',BaseLine-RowOffset,'                   &&  Top Window Row used to display a record')>>
   <<genln('            WindowTop=',fldrow,'             &&  Top Window Row used to display a record')>>
<<endif>>
         ELSE                       &&  Zoom Out
            zIn = .NOT. zIn
            ScrnBot=zBotOut         &&  Bottom Screen Row
<<if FoxPro>>
            Hide window ZoomIn
            activate window ZoomOut
<<else>>
   <<genln('            ScrnTop=',BaseLine-fldrow,'              &&  Top Window Row used to display a record')>>
            WindowTop=0
<<endif>>
         ENDIF
         RecPerPage=(ScrnBot-ScrnTop+1)/{LinesPerRec}      &&  Records per page
         RecPoint=RECNO()
         PageTest = .T.         &&  full page test needed
         
         wThumb = INT((ScrnBot-WindowTop)/2)+WindowTop

         **  --  Display Window  --  **
<<#
SetIndent(3)
select all
if FoxPro
   forall fldlab
      if not fldnap
         GenColorHue      <<*  Test for color change *>>
         if fldtyp = 'B'  <<*BOX Type*>>
            box := fldlab  <<*Used to swap chars for Character box*>>
            gen( '@ 0,0,ScrnBot+1,ScrnRight+',RightMarg,' BOX "' )
            genln( substr(box,1,3),box[5],box[8],box[7],box[6],box[4],' "' )
            <<*  use FIELD Color of BOX for Lexicons  *>>
            genln( 'SET COLOR TO ',AtrCode( fldatr ) )
            lasthue := fldatr
            genln('@ 0,0 SAY CHR(254)                   &&  Close window')
            genln('@ 0,ScrnRight+',RightMarg,' SAY CHR(240)         &&  Zoom')
            genln('@ 1,ScrnRight+',RightMarg,' SAY CHR(30)          &&  Up')
            genln('@ ScrnBot,ScrnRight+',RightMarg,' SAY CHR(31)    &&  Down')
            genln('@ ScrnBot+1,ScrnRight+',RightMarg,' SAY "H"      &&  Help')
            genln('@ wThumb,ScrnRight+',RightMarg,' SAY CHR(4)       &&  Thumb')
         else  <<*All Fields and Text Objects*>>
            if fldrow = WindowBotABS  <<*  text is in the bottom border  *>>
               <<*  needed because the bottom border is adjusted in the prg  *>>
               genln( '@ ScrnBot+1,',fldcol-ColOffset,' SAY "',fldlab,'"' )
            else
               genln( '@ ',fldrow-RowOffset,',',fldcol-ColOffset,' SAY "',fldlab,'"' )
            endif
         endif
      endif not fldnap
   endfor
else
   genln('RESTORE SCREEN FROM PickScrn')
   forall fldlab
      if not fldnap
         GenColorHue      <<*  Test for color change *>>
         if fldtyp = 'B'  <<*BOX Type*>>
            box := fldlab  <<*Used to swap chars for Character box*>>
            gen( '@ WindowTop+',fldrow-TopRowBox,',',fldcol,',' )
            gen( 'ScrnBot+1,',fldcol+fldwid,' BOX "' )
            genln( substr(box,1,3),box[5],box[8],box[7],box[6],box[4],' "' )
         else  <<*All Fields and Text Objects*>>
            if fldrow = WindowBotABS  <<*  text is in the bottom border  *>>
               <<*  needed because the bottom border is adjusted in the prg  *>>
               genln( '@ ScrnBot+1,',fldcol,' SAY "',fldlab,'"' )
            else
               genln( '@ WindowTop+',fldrow-TopRowBox,',',fldcol,' SAY "',fldlab,'"' )
            endif
         endif
      endif not fldnap
   endfor
endif
RestoreIndent(3)
#>>
         SET COLOR TO {fieldcolor}

<<*--------------- Start of Tag Record Process -------------------*>>
<<if MultiPick>>
   <<if TagOnly>>         <<*  No quantities allowed  *>>
      <<if ENTER_Exit>>
      CASE KeyCode=32                        &&  [Space] to tag / untag 
      <<else>> <<*  ENTER key will also select *>>
      CASE KeyCode=32.OR.KeyCode=13          &&  [Space] or [Enter] to tag / untag 
      <<endif>>
         SELECT PK
         IF EOF()          &&  item is not tagged so tag it
            SEEK 0
            IF EOF()       &&  use any records set to 0 before appending
               APPEND BLANK
            ENDIF
            REPLACE Rec_no WITH RECNO(PkArea)
         ELSE              &&  record was tagged so untag it
            REPLACE Rec_no WITH 0
         ENDIF
         SELECT {DbfAlias}
         IF PK->Rec_no#0     &&  Record is tagged so display pointers
            @ CurRow,ScrnLeft SAY CHR(16)    &&  Left tag Pointer
            @ CurRow,ScrnRight SAY CHR(17)    &&  Right tag Pointer
         ELSE     &&  Untag so remove pointers
            @ CurRow,ScrnLeft SAY ' '
            @ CurRow,ScrnRight SAY ' '
         ENDIF
         KeyCode=24
         LOOP
  <<else>>      <<*  Allow quantity entries  *>>
      CASE ( KeyCode>47 .AND. KeyCode<58 )  ;
            .OR.KeyCode=45 .OR. KeyCode=45   &&  Numeric Entry ( 0-9 or -. )
         SELECT PK
         M->PK_Quan = PK_Quan    &&  get quantity from record
      <<if not FoxPro>>
         Null = SYS(2002,1)        &&  Turn the cursor on       [Fox 2.1]
      <<endif>>
      <<select all>>
      <<select fields on ('PK_QUAN'=upper(fldnam))>>
      <<gen( '         @ CurRow,',fldcol,' GET M->',fldnam)>>
      <<GenPicture>>
      <<if fldran>>
         <<gen('  RANGE ',fldran)>>
      <<endif>>
      <<if fldval>>     <<* may need to check line length and use ; *>>
         <<gen('  VALID ',fldval)>>
      <<endif>>
      <<genln>>
         KEYBOARD CHR(KeyCode)    &&  Force number entered
         READ  
      <<if not FoxPro>>
         Null = SYS(2002)   &&  Turn the cursor off   [Fox 2.1]
      <<endif>>
         IF READKEY() = 12 .OR. READKEY() = 268  &&  ESC, so restore quantity
      <<gen( '             @ CurRow,',fldcol,' SAY PK_Quan')>>
      <<GenPicture>>
      <<genln>>
      <<select all>>
         ELSE
            DO CASE
            CASE EOF() .AND. M->PK_Quan # 0  &&  item is not tagged so tag it
               SEEK 0
               IF EOF()    &&  use any records set to 0 before appending
                  APPEND BLANK
               ENDIF
               REPLACE Rec_no WITH RECNO(PkArea)
               REPLACE PK_Quan WITH M->PK_Quan
            CASE EOF() .AND. M->PK_Quan = 0  &&  item is not tagged 
               **  item tag record does not exist, no action needed
            CASE M->PK_Quan # 0  &&  item quantity is changed
               REPLACE PK_Quan WITH M->PK_Quan
            OTHERWISE    &&  M->PK_Quan = 0  record was tagged so untag it
               REPLACE Rec_no WITH 0
               REPLACE PK_Quan WITH 0
            ENDCASE
            KEYBOARD CHR(24)    &&  Force a down arrow
         ENDIF
         SELECT {DbfAlias}
   <<endif>>    <<* if TagOnly *>>

   <<if not ('T' $ OmitFeatureFlag)>>   <<*  do not generate  *>>
      CASE KeyCode=84.OR.KeyCode=116               &&  [Tt] to tag ALL
      <<if not TagOnly>>         <<*  Quantities are allowed  *>>
         <<if FoxPro>>
         DEFINE WINDOW PkWindow FROM 10,15 TO 12,61 DOUBLE
         ACTIVATE WINDOW PkWindow
         M->PK_Quan = 0
         @ 0,2 SAY 'Enter the Quantity to tag with      :' GET M->PK_Quan PICTURE '999'
         <<else>>
         SAVE SCREEN TO PksScrn
         @ 10,15,12,61 BOX "ͻȺ "
         Null = SYS(2002,1)        &&  Turn the cursor on       [Fox 2.1]
         M->PK_Quan = 0
         @ 11,17 SAY 'Enter the Quantity to tag with      :' GET M->PK_Quan PICTURE '999'
         <<endif>>
         READ
         IF READKEY()=12 .OR. READKEY()=268 .OR. M->PK_Quan=0
            **  --  Process aborted
         ELSE
         <<SetIndent(1)>>
      <<endif>>
         NewPage=.T.
         GO TOP
         DO WHILE .T.
            SELECT PK
            IF EOF()       &&  item is not tagged so tag it
               SEEK 0      &&  use any records set to 0 before appending
               IF EOF()    &&  none found, so add one
                  APPEND BLANK
               ENDIF
               REPLACE Rec_no WITH RECNO(PkArea)
            ENDIF
      <<if not TagOnly>>         <<*  Quantities are allowed  *>>
            REPLACE PK_Quan WITH M->PK_Quan
      <<endif>>
            SELECT {DbfAlias}
            SKIP
            IF EOF()
               EXIT
            ENDIF
         ENDDO
         GO TOP   &&  Reset pointer
      <<if not TagOnly>>         <<*  Quantities are allowed  *>>
         <<RestoreIndent(1)>>
         ENDIF
         <<if FoxPro>>
         RELEASE WINDOW PkWindow
         <<else>>
         Null = SYS(2002)   &&  Turn the cursor off   [Fox 2.1]
         RESTORE SCREEN FROM PksScrn
         <<endif>>
      <<endif>>
   <<endif>>    <<*  do not generate  Tag ALL*>>

   <<if not('C' $ OmitFeatureFlag)>>   <<*  do not generate  *>>
      CASE KeyCode=67.OR.KeyCode=99                &&  [Cc] to Clear ALL
         SELECT PK
         ZAP
         SELECT {DbfAlias}
      <<if TagOnly>>         <<* No Quantities are allowed  *>>
         @ ScrnTop,ScrnLeft TO ScrnBot,ScrnLeft CLEAR  &&  marks
         @ ScrnTop,ScrnRight TO ScrnBot,ScrnRight CLEAR  &&  marks
      <<else>>
         NewPage=.T.
         PageTest = .T.         &&  full page test needed
      <<endif>>
   <<endif>>    <<*  do not generate Clear ALL *>>
   <<**>>
   <<select all>>
   <<select database 1>>
   <<if not('M' $ OmitFeatureFlag)>>   <<*  generate  *>>
      <<if ndxnam and MatchingIsOk and (IndexType $ 'CDN')>>
         <<*  Only valid if an index exist, user field exist, and not a Logical key  *>>

      CASE KeyCode=77.OR.KeyCode=109              &&  [Mm] Tag/Untag Matching
         <<Tmp := 12>>  <<*  screen setup  *>>
         <<if not TagOnly>>
            <<Tmp := Tmp +1>>
            <<select all>>  <<* set up quantity field info *>>
            <<select fields on (upper(fldnam) = 'PK_QUAN')>>
         <<endif>>
         <<if IndexType <> 'C'>>
            <<Tmp := Tmp +1>>
         <<endif>>
         <<if IndexType = 'C'>>     <<*  dertrmin the box width  *>>
            <<BoxWidth := 43 + len(IndexPicture)>>
         <<elseif IndexType = 'N'>>
            <<BoxWidth := 47 + len(IndexPicture)>>
         <<elseif IndexType = 'D'>>
            <<BoxWidth := 62>>
         <<endif>>
         <<if (BoxWidth < 41+fldwid) and not TagOnly>>
                 <<BoxWidth := 41+fldwid>>   <<* fldwid of Pk-Quan *>>
         <<endif>>
         <<if (BoxWidth > 78)>>
            <<wait 'Error: "Matching Records" tag box is too large.'>>
         <<endif>>
         <<BoxWidth := BoxWidth/2>>  <<* get half of the box width  *>>
         <<SetIndent(3)>>
         <<if FoxPro>>
            <<ScrnOfSet := 2>>
            <<gen('DEFINE WINDOW PkWindow FROM 9,',40-BoxWidth,' TO ',Tmp,',')>>
            <<genln(40+BoxWidth,' DOUBLE TITLE  "[ Tag/Untag Matching Records ]"')>>
            <<genln('ACTIVATE WINDOW PkWindow')>>
         <<else>>
            <<genln('Null = SYS(2002,1)        &&  Turn the cursor on       [Fox 2.1]')>>
            <<ScrnOfSet := 43-BoxWidth>>
            <<genln('SAVE SCREEN TO PksScrn')>>
            <<genln('@ 09,',40-BoxWidth,',',Tmp,',',40+BoxWidth,' BOX "ͻȺ "')>>
            <<genln('@ 09,25 SAY "[ Tag/Untag Matching Records ]"')>>
            <<genln('@ 10,27 SAY ""')>>
         <<endif>>
         <<RestoreIndent(3)>>
         TagAll=.T.    &&  T = Tag     U = Untag
         Tmp='T'
         PkMatch = {DefIndexValue}
         @ ROW(),{ScrnOfSet} SAY 'Tag or Untag matching records. (T/U):' GET Tmp PICTURE '!' Valid Tmp$'TU'
         <<if IndexType = 'C'>>
         @ ROW()+1,{ScrnOfSet} SAY 'Enter the first characters to match :' GET PkMatch PICTURE {IndexPicture}
         <<elseif IndexType = 'N'>>
         PkMatch2 = 0
         @ ROW()+1,{ScrnOfSet} SAY 'Tag ALL starting with :' GET PkMatch  PICTURE {IndexPicture}
         @ ROW(),COL()+2 SAY '0 = Start of file.'
         @ ROW()+1,{ScrnOfSet} SAY '      and ending with :' GET PkMatch2 PICTURE {IndexPicture}
         @ ROW(),COL()+2 SAY '0 = End of file.'
         <<elseif IndexType = 'D'>>
         PkMatch2 = CTOD('  /  /  ')
         @ ROW()+1,{ScrnOfSet} SAY 'Tag ALL starting with :' GET PkMatch  
         @ ROW(),COL()+2 SAY ' /  /  = Start of file.'
         @ ROW()+1,{ScrnOfSet} SAY '      and ending with :' GET PkMatch2
         @ ROW(),COL()+2 SAY ' /  /  = End of file.'
         <<endif>>
         <<if not TagOnly>>         <<*  Quantities are allowed  *>>
         M->PK_Quan = 0
            <<gen('         @ ROW()+1,',ScrnOfSet," SAY 'Enter the Quantity to tag with      :' GET M->PK_Quan ")>>
            <<GenPicture>>
            <<genln>>
            <<select all>>
         <<endif>>
         READ
         TagAll = (Tmp='T')    &&  T = Tag     U = Untag
         IF READKEY()=12 .OR. READKEY()=268 ;
         <<if IndexType = 'C'>>
               .OR. PkMatch={DefIndexValue} .OR. (M->PK_Quan=0 .AND. TagAll)
            **  --  Process aborted
         <<elseif IndexType = 'N'>>
               .OR.(PkMatch = 0 .AND. PkMatch2 = 0)
         <<elseif IndexType = 'D'>>
               .OR.(PkMatch = CTOD('  /  /  ') .AND. PkMatch2 = CTOD('  /  /  '))
         <<endif>>
         ELSE
            OldPoint=RECNO()
         <<if IndexType = 'C'>>
            ExactOn = (SYS(2002,'EXACT')='ON')   &&  Get EXACT status
            SET EXACT Off
            PkMatch=RTRIM(PkMatch)
            SEEK PkMatch
         <<elseif IndexType = 'N'>>
            IF PkMatch2 = 0    &&  Get end of range
               Go Bottom
               PkMatch2 = {IndexExpression}
            ENDIF
            if PkMatch = 0
               GO TOP
               PkMatch = {IndexExpression}
            else
               SEEK PkMatch
            endif
         <<elseif IndexType = 'D'>>
            IF PkMatch2 = CTOD('  /  /  ')    &&  Get end of range
               Go Bottom
               PkMatch2 = {IndexExpression}
            ENDIF
            if PkMatch = CTOD('  /  /  ')
               GO TOP
               PkMatch = {IndexExpression}
            else
               SEEK PkMatch
            endif
         <<endif>>
            IF EOF()
         <<if FoxPro>>
               CLEAR
         <<else>>
            <<SetIndent(3)>>
            <<genln('@ 09,',40-BoxWidth,',',Tmp,',',40+BoxWidth,' BOX "ͻȺ "')>>
            <<RestoreIndent(4)>>
               @ 10,27 SAY ''
         <<endif>>
               @ ROW(),{ScrnOfSet} SAY '****  No matching records!  ****'
               GOTO OldPoint
         <<if FoxPro>>
               ans=INKEY(0,'M')   &&  Wait for key press
         <<else>>
               ans=INKEY(0)   &&  Wait for key press
         <<endif>>
            ELSE
               NewPage=.T.
         <<if IndexType = 'C'>>
               DO WHILE {IndexExpression}=PkMatch .AND..NOT. EOF()
         <<else>>
               DO WHILE {IndexExpression}>=PkMatch .AND. {IndexExpression}<=PkMatch2 .AND..NOT. EOF()
         <<endif>>
                  SELECT PK
                  IF TagAll  &&  Matching Records
                     IF EOF()   &&  item is not tagged 
                        SEEK 0
                        IF EOF()    &&  use any records set to 0 before appending
                           APPEND BLANK
                        ENDIF
                        REPLACE Rec_no WITH RECNO(PkArea)
                     ENDIF
         <<if not TagOnly>>         <<*  Quantities are allowed  *>>
                     REPLACE PK_Quan WITH M->PK_Quan
         <<endif>>
                  ELSE  &&  Untag Matching Records
                     IF .NOT. EOF()   &&  item was tagged 
                        REPLACE Rec_no WITH 0
         <<if not TagOnly>>         <<*  Quantities are allowed  *>>
                        REPLACE PK_Quan WITH 0
         <<endif>>
                     ENDIF
                  ENDIF
                  SELECT {DbfAlias}
                  SKIP
               ENDDO
               SEEK PkMatch           &&  reposition pointer
               PageTest = .T.         &&  full page test needed
            ENDIF
         <<if IndexType = 'C'>>
            IF ExactOn     &&  True if Exact was on
               SET EXACT ON
            ENDIF
         <<endif>>
         ENDIF eof()
         <<if FoxPro>>
         RELEASE WINDOW PkWindow
         <<else>>
         Null = SYS(2002)   &&  Turn the cursor off   [Fox 2.1]
         RESTORE SCREEN FROM PksScrn
         <<endif>>
      <<endif>>     <<*  Only valid if an index exist  *>>
   <<endif>>    <<*  do not generate Matching  *>>
<<endif>>     <<* MultiPick *>>
<<*------------------- End of Tag Record Process -------------------*>>
   <<**>>
<<*------------------- Start of Search Process -------------------*>>
<<select all>>
<<select database 1>>
<<if not('S' $ OmitFeatureFlag)>>   <<*  generate  *>>
   <<if ndxnam and MatchingIsOk and (IndexType $ 'CDN')>>
      <<*  Only valid if an index exist, user field exist, and not a Logical key  *>>

      CASE KeyCode=83.OR.KeyCode=115                       &&  [Ss]   Search
         <<if IndexType = 'D'>>     <<*  dertrmin the box width  *>>
            <<BoxWidth := 40>>
         <<else>>
            <<BoxWidth := 32 + len(IndexPicture)>>
         <<endif>>
         <<if (BoxWidth > 78)>>
            <<wait 'Error: "Search Key" input box is too large.'>>
         <<endif>>
         <<BoxWidth := BoxWidth/2>>  <<* get half of the box width  *>>
         <<SetIndent(3)>>
         <<if FoxPro>>
            <<ScrnOfSet := 2>>
            <<gen('DEFINE WINDOW PkWindow FROM 9,',40-BoxWidth,' TO 13,')>>
            <<genln(40+BoxWidth,' DOUBLE TITLE  "[ Tag/Untag Matching Records ]"')>>
            <<genln('ACTIVATE WINDOW PkWindow')>>
         <<else>>
            <<ScrnOfSet := 43-BoxWidth>>
            <<genln('SAVE SCREEN TO PksScrn')>>
            <<genln('@ 09,',40-BoxWidth,',13,',40+BoxWidth,' BOX "ͻȺ "')>>
            <<genln('@ 09,25 SAY "[ Search for Matching Records ]"')>>
            <<genln('@ 10,27 SAY ""')>>
            <<genln('Null = SYS(2002,1)        &&  Turn the cursor on       [Fox 2.1]')>>
         <<endif>>
         <<RestoreIndent(3)>>
         PkMatch = {DefIndexValue}
         @ ROW()+1,{ScrnOfSet} SAY 'Enter Search Key :' GET PkMatch PICTURE {IndexPicture}
         READ
         IF READKEY()=12 .OR. READKEY()=268 
            **  --  Search Aborted
         ELSE
            NewPage=.T.
            PageTest = .T.         &&  full page test needed
         <<if IndexType = 'C'>>
            ExactOn = (SYS(2002,'EXACT')='ON')   &&  Get EXACT status
            SET EXACT Off
            PkMatch=RTRIM(PkMatch)
            SEEK PkMatch
         <<else>>
            SEEK PkMatch
         <<endif>>
            IF EOF()
         <<if FoxPro>>
               CLEAR
         <<else>>
            <<SetIndent(5)>>
            <<genln('@ 09,',40-BoxWidth,',13,',40+BoxWidth,' BOX "ͻȺ "')>>
            <<RestoreIndent(5)>>
               @ 10,27 SAY ''
         <<endif>>
               @ ROW(),{ScrnOfSet} SAY 'No match!'
               IF RECNO(0)=0       &&  no close match
                  @ ROW()+1,{ScrnOfSet} SAY 'Returning to top of file.'
                  GOTO TOP
               ELSE
                  @ ROW()+1,{ScrnOfSet} SAY 'Returning to nearest match.'
                  GOTO RECNO(0)    &&  nearest match
               ENDIF
         <<if FoxPro>>
               ans=INKEY(0,'M')   &&  Wait for key press
         <<else>>
               ans=INKEY(0)   &&  Wait for key press
         <<endif>>
            ELSE     &&  Found
               RecPoint=recno()
            ENDIF
         <<if IndexType = 'C'>>
            IF ExactOn     &&  True if Exact was on
               SET EXACT ON
            ENDIF
         <<endif>>
         ENDIF eof()
         <<if FoxPro>>
         RELEASE WINDOW PkWindow
         <<else>>
         Null = SYS(2002)   &&  Turn the cursor off   [Fox 2.1]
         RESTORE SCREEN FROM PksScrn
         <<endif>>
   <<endif>>    <<*  do not generate Matching  *>>
<<endif>>     <<* MultiPick *>>
<<*------------------- End of Search Process -------------------*>>

      CASE KeyCode=3.OR.KeyCode=51                               &&  [PgDn]
<<if MultiLine>>
   <<genln('         IF CurRow = ScrnBot-',LinesPerRec-1,'  &&  at last row, so go to next page')>>
<<else>>
         IF CurRow = ScrnBot  &&  at last row, so go to next page
<<endif>>
            NewPage=.T.
            SKIP 1         &&  test to see if at last record
            IF EOF()       &&  yes, so wrap to top of file
               GO TOP
            ELSE           &&  test for full page
               SKIP RecPerPage-1
               IF EOF()               &&  last page is not a full one,
                  GO BOTTOM           &&  so make last page full
               ENDIF
               RecPoint=RECNO()
               SKIP -RecPerPage +1    &&  to top of page
            ENDIF
         ELSE                &&  move to last row of page then skip
<<if MultiLine>>
            SKIP (ScrnBot - CurRow)/{LinesPerRec}
   <<genln('            CurRow = ScrnBot-',LinesPerRec-1)>>
<<else>>
            SKIP ScrnBot - CurRow
            CurRow = ScrnBot
<<endif>>
         ENDIF
         
      CASE KeyCode=18.OR.KeyCode=57                              &&   [PgUp]
         IF CurRow = ScrnTop  &&  at first row, so go to previous page
            NewPage=.T.
            SKIP -1        &&  test to see if at 1st record
            IF BOF()       &&  yes, so wrap to bottom
               GO BOTTOM
               RecPoint=RECNO()
               SKIP -(RecPerPage-1)
            ELSE           &&  test for full page
               SKIP -(RecPerPage-1)
               IF BOF()       &&  first page is not a full one,
                  GO TOP      &&  so make first page full
               ENDIF
               RecPoint=RECNO()
            ENDIF
         ELSE                 &&  move to first row of page then skip
<<if MultiLine>>
            SKIP -(CurRow - ScrnTop)/{LinesPerRec}
            CurRow = ScrnTop
<<else>>
            SKIP -(CurRow - ScrnTop)
            CurRow = ScrnTop
<<endif>>
         ENDIF
         
      CASE KeyCode=1.OR.KeyCode=55                               &&  [Home]
         GO TOP               &&  cursor to beginning of file
         NewPage=.T.
         
      CASE KeyCode=6.OR.KeyCode=49                               &&  [End]
         GO BOTTOM
         RecPoint=RECNO()
         SKIP -(RecPerPage-1)
         NewPage=.T.
         
      CASE KeyCode=5.OR.KeyCode=56.OR.KeyCode=19.OR.KeyCode=52   &&  [Up]  [Left]
         IF CurRow=ScrnTop    &&  at top of page, so scroll
            ScrollDir = -1
         ELSE                 && move HighLite up one row
            CurRow=CurRow -{LinesPerRec}
            SKIP -1           && move pointer up one record
         ENDIF
         
      CASE KeyCode=24.OR.KeyCode=50.OR.KeyCode=4.OR.KeyCode=54   &&  [Down]  [Right]
<<if MultiLine>>
   <<genln('         IF CurRow=ScrnBot-',LinesPerRec-1,'    &&  at bottom of page, so scroll')>>
<<else>>
         IF CurRow=ScrnBot    &&  at bottom of page, so scroll
<<endif>>
            ScrollDir = 1
         ELSE                 && move HighLite down one row
            CurRow=CurRow +{LinesPerRec}
            SKIP 1            && move pointer up one record
         ENDIF
         
      CASE KeyCode=27                                     &&  [ESC]  -- Abort
<<if MultiPick>>
         SELECT PK
         ZAP             &&  Remove any picks from the database
<<else>>
   <<if 'CLOSE' <> UPPER(GetUser(2,fuser))>>    <<* DBF will remain open *>>
         GO BOTTOM
         SKIP        &&  Force EOF() 
      <<if ReturnField>>
         Target = {ReturnField}    &&  get empty field to return
      <<elseif ndxnam>>     <<*  Only valid if an index exist  *>>
         TmpVar = SYS(14,1)        &&  return the Key expression
         Target = &TmpVar          &&  return an empty Key Value 
      <<else>>
         Target = 0                &&  no active index 
      <<endif>>
   <<endif>>
<<endif>>
         EXIT
         
<<select all>>
<<select database 1>>
<<if ENTER_Exit>>
      CASE KeyCode=13 .OR. KeyCode=23      &&  [Return] or [Ctrl] [End] -- Select
   <<IF MultiPick>>
      <<* no variables are set *>>
   <<elseif ReturnField>>
         ** --  You may want to return a record number or a field value
         Target = {ReturnField}    &&  get value to return
   <<elseif ndxnam>>     <<*  Only valid if an index exist  *>>
         TmpVar = SYS(14,1)        &&  return the Key expression
         Target = &TmpVar          &&  return the Key Value
   <<else>>
         Target = RECNO()          &&  no active index 
   <<endif>>
<<else>> <<*  ENTER key will select *>>
      CASE KeyCode=23                                  &&  [Ctrl] [End] -- Exit
<<endif>>
<<if MultiPick and not TagOnly>>  <<*  code to remove 0 quan records  *>>
         SELECT PK
         DELETE FOR PK_QUAN = 0     &&  Remove 0 quantity records
         PACK
         ** if Packing is too slow you may want to deal with the 0 quantity elsewhere
<<endif>>
         EXIT
         
<<if not('J' $ OmitFeatureFlag)>>   <<*  generate  *>>
      CASE KeyCode=74.OR.KeyCode=106                          &&  [Jj]  --  Jump
   <<if FoxPro>>
         DEFINE WINDOW PkWindow FROM 10,15 TO 12,61 DOUBLE
         ACTIVATE WINDOW PkWindow
         JumpVal=0
         @ 0,2 SAY 'Enter the number of records to jump:' GET JumpVal PICTURE '99999'
   <<else>>
         SAVE SCREEN TO PksScrn
         @ 10,15,12,61 BOX "ͻȺ "
         JumpVal=0
         Null = SYS(2002,1)        &&  Turn the cursor on       [Fox 2.1]
         @ 11,17 SAY 'Enter the number of records to jump:' GET JumpVal PICTURE '99999'
   <<endif>>
         READ
         IF JumpVal # 0
            NewPage = .T.
            SKIP JumpVal     &&  test to see if at 1st record
            DO CASE
            CASE EOF()       &&  at bottom of file, so position for last page
               GO BOTTOM
               RecPoint=RECNO()
               SKIP -(RecPerPage-1)
            CASE BOF()       &&  at top of file, so position for first page
               GO TOP
            OTHERWISE        &&  test for full page
               RecPoint=RECNO()
               PageTest = .T.
            ENDCASE
         ENDIF JumpVal # 0
   <<if FoxPro>>
         RELEASE WINDOW PkWindow
   <<else>>
         Null = SYS(2002)   &&  Turn the cursor off   [Fox 2.1]
         RESTORE SCREEN FROM PksScrn
   <<endif>>
<<endif>>    <<*  do not generate Skip *>>
         
<<if not('H' $ OmitFeatureFlag)>>   <<*  generate  *>>
      CASE KeyCode=28.OR.KeyCode=72.OR.KeyCode=104      &&  [F1] [Hh]  Help
   <<if MultiPick>>
      <<if TagOnly and not Enter_Exit>>
         <<LastHelpLine := 20>>
      <<else>>
         <<LastHelpLine := 19>>
      <<endif>>
      <<if 'T' $ OmitFeatureFlag>>
         <<LastHelpLine := LastHelpLine -1>>
      <<endif>>
      <<if 'C' $ OmitFeatureFlag>>
         <<LastHelpLine := LastHelpLine -1>>
      <<endif>>
      <<if MatchingIsOk and not ('M' $ OmitFeatureFlag)>>
         <<LastHelpLine := LastHelpLine +1>>
      <<endif>>
   <<else>>
      <<LastHelpLine := 16>>
   <<endif>>
   <<if 'J' $ OmitFeatureFlag>>
      <<LastHelpLine := LastHelpLine -1>>
   <<endif>>
   <<if 'S' $ OmitFeatureFlag>>
      <<LastHelpLine := LastHelpLine -1>>
   <<endif>>
   <<if FoxPro>>
      <<LastHelpLine := LastHelpLine +1>>
         SET COLOR TO RB+/N
         DEFINE WINDOW brHelp FROM 2,10 TO {LastHelpLine},66  ;
                TITLE '[  HELP WINDOW  ]' DOUBLE ;
                COLOR G+/N,RB+/N,RB+/N
         ACTIVATE WINDOW brHelp
      <<ScrnOfSet := 2>>
   <<else>>
         SAVE SCREEN TO PksScrn
         SET COLOR TO G+/N          &&  put up the window
         @ 2,10,{LastHelpLine},66 BOX "ͻȺ "
         @ 2,30 SAY '[  HELP WINDOW  ]'
         @ 3,30 SAY ''
      <<ScrnOfSet := 12>>
   <<endif>>
         @ ROW(),{ScrnOfSet} SAY '----KEY-------------ACTION--------------------------'
         @ ROW()+1,{ScrnOfSet} SAY '  [ESC]    Exit list without selecting an item.'
         <<MouseCodes := '0  '>>   <<* ESC form prg from help is not allowed *>>
   <<if MultiPick>>
      <<if ENTER_Exit>>
         @ ROW()+1,{ScrnOfSet} SAY '  [Enter]  Save select items and exit.'
         <<MouseCodes := MouseCodes + '13 '>>
      <<else>>
         @ ROW()+1,{ScrnOfSet} SAY '[Ctrl][End] Save select items and exit.'
         <<MouseCodes := MouseCodes + '23 '>>
         <<if TagOnly>>
         @ ROW()+1,{ScrnOfSet} SAY '  [Enter]  Tag or Untag a record.'
            <<MouseCodes := MouseCodes + '13 '>>
         <<endif>>
      <<endif>>
      <<if TagOnly>>
         @ ROW()+1,{ScrnOfSet} SAY '  [Space]  Tag or Untag a record.'
         <<MouseCodes := MouseCodes + '32 '>>
      <<else>>
         @ ROW()+1,{ScrnOfSet} SAY '  [0 - 9]  Enter quantity to tag a record.'
         <<MouseCodes := MouseCodes + '48 '>>
      <<endif>>
      <<if not ('C' $ OmitFeatureFlag)>>   <<*  generate  *>>
         @ ROW()+1,{ScrnOfSet} SAY '  [C]      Clear ALL tagged records.'
         <<MouseCodes := MouseCodes + '67 '>>
      <<endif>>
      <<if not ('T' $ OmitFeatureFlag)>>   <<*  generate  *>>
         @ ROW()+1,{ScrnOfSet} SAY '  [T]      Tag ALL records.'
         <<MouseCodes := MouseCodes + '84 '>>
      <<endif>>
      <<if MatchingIsOk and not ('M' $ OmitFeatureFlag)>>
         @ ROW()+1,{ScrnOfSet} SAY '  [M]      Tag/Untag Matching Records.'
         <<MouseCodes := MouseCodes + '77 '>>
      <<endif>>
   <<else>>
         @ ROW()+1,{ScrnOfSet} SAY '  [Enter]  Select the highlited item.'
         <<MouseCodes := MouseCodes + '13 '>>
   <<endif>>
   <<if not ('J' $ OmitFeatureFlag)>>   <<*  generate  *>>
         @ ROW()+1,{ScrnOfSet} SAY '  [J]      Jump a number of records.'
         <<MouseCodes := MouseCodes + '74 '>>
   <<endif>>
   <<if not ('S' $ OmitFeatureFlag)>>   <<*  generate  *>>
         @ ROW()+1,{ScrnOfSet} SAY '  [S]      Search on key field.'
         <<MouseCodes := MouseCodes + '83 '>>
   <<endif>>
         @ ROW()+1,{ScrnOfSet} SAY '  Arrows   Cursor keys move the selection pointer.'
         <<MouseCodes := MouseCodes + '0  '>>  <<* no action taken *>>
         @ ROW()+1,{ScrnOfSet} SAY '  [PgDn]   To page bottom or to the next page.'
         <<MouseCodes := MouseCodes + '3  '>>
         @ ROW()+1,{ScrnOfSet} SAY '  [PgUp]   To page top or to the previous page.'
         <<MouseCodes := MouseCodes + '18 '>>
         @ ROW()+1,{ScrnOfSet} SAY '  [Home]   Display the first page.'
         <<MouseCodes := MouseCodes + '1  '>>
         @ ROW()+1,{ScrnOfSet} SAY '  [End]    Display the last page.'
         <<MouseCodes := MouseCodes + '6  '>>
         @ ROW()+1,{ScrnOfSet} SAY '  [Z]      Zoom window in and out.'
         <<MouseCodes := MouseCodes + '90 '>>
         @ ROW()+1,{ScrnOfSet} SAY '  [F1] [H] Displays this screen.'
         <<MouseCodes := MouseCodes + '0  '>>
         @ ROW()+1,{ScrnOfSet} SAY ' <  Press Key for Command, Any Other To Return  >'
   <<if FoxPro>>
      <<Tmp := LastHelpLine -4>>
         @ ROW()+1,{ScrnOfSet} SAY ' <Click on a row for Command, Any Other To Return>'
         KeyCode=INKEY(0,'HM')
         IF KeyCode=151                                      &&  Mouse was clicked
            IF MCOL()>=0 .AND. MROW()>0 .AND. MROW()<={Tmp}     &&  within window
               KeyCode=VAL(SUBSTR({'}{MouseCodes}{'},(MROW()-1)*3+1,3))
            ENDIF
         ENDIF
         RELEASE WINDOWS brHelp
         IF zIn
            ACTIVATE WINDOW ZoomOut
         ELSE
            ACTIVATE WINDOW ZoomIn
         ENDIF
         SET COLOR TO {fieldcolor}
   <<else>>
         KeyCode=INKEY(0)
         SET COLOR TO {fieldcolor}
         RESTORE SCREEN FROM PksScrn
   <<endif>>
         IF KeyCode#27     &&  Do not abort from this window
            LOOP
         ENDIF
<<endif>>    <<*  do not generate  Help *>>

      ENDCASE
      
      *=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
      **          Window display routines
      *=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
      
      IF ScrollDir # 0     &&  Scroll screen Up or Down
         SKIP ScrollDir    &&  Move record pointer
         DO CASE
         CASE EOF()    &&  Wrap to top of file
            GO TOP
            NewPage=.T.
         CASE BOF()    &&  Wrap to Bottom of file
            GO BOTTOM
            RecPoint=RECNO()
            SKIP -(RecPerPage-1)
            NewPage=.T.
         OTHERWISE      &&  Scroll one line
            Scroll ScrnTop,ScrnLeft,ScrnBot,ScrnRight,ScrollDir*{LinesPerRec}   &&  [Fox 2.1]
<<if MultiLine>>
   <<genln('            CurRow = IIF(ScrollDir=-1,ScrnTop,ScrnBot-',LinesPerRec-1,')   && position cursor')>>
<<else>>
            CurRow = IIF(ScrollDir=-1,ScrnTop,ScrnBot)   && position cursor
<<endif>>
         ENDCASE
         ScrollDir = 0
      ENDIF ScrollDir # 0
   
      IF NewPage                 &&  display a new page
         NewPage=.F.             &&  reset flag
         IF RecPoint=0
            RecPoint = RECNO()  &&  reposition record pointer
         ENDIF
         IF PageTest      &&  Test for full page to display
            SKIP RecPerPage-1
            IF EOF()               &&  last page is not a full one,
               GO BOTTOM           &&  so make last page full
            ENDIF
            SKIP -RecPerPage +1    &&  to top of page
            PageTest = .F.
         ENDIF PageTest

         **  --  display a new page  ---------------------
         SET COLOR TO {fieldcolor}
         @ ScrnTop,ScrnLeft TO ScrnBot,ScrnRight CLEAR  &&  window
         cnt=0
         DO WHILE cnt<RecPerPage 
            rw=cnt*{LinesPerRec}+ScrnTop
<<*---Generate the SAY lines needed to display records on the screen---*>>
<<SetIndent(2)>>
<<ColorIsOk := True>>  <<*  Color is Ok for text objects in MultiLines *>>
<<AtSay('rw')>>
<<RestoreIndent(2)>>
            IF RecPoint=RECNO()          &&  Cursor record number to top of page
<<if MultiLine>>
               CurRow = ScrnTop + cnt*{LinesPerRec}    &&  Place Cursor pointer
<<else>>
               CurRow = ScrnTop + cnt    &&  Place Cursor pointer
<<endif>>
            ENDIF
            cnt=cnt+1
            SKIP
         ENDDO while cnt<RecPerPage
         
         GOTO RecPoint       &&  reposition record pointer to top of page
         RecPoint=0  
      ENDIF  NewPage=.T.
      
      SET COLOR TO {HighLite}           &&  Turn High Lite On
<<if MultiLine>>
   <<genln('      @ CurRow,ScrnLeft TO CurRow+',LinesPerRec-1,',ScrnRight CLEAR')>>  <<* make bar solid *>>
<<else>>
      @ CurRow,ScrnLeft TO CurRow,ScrnRight CLEAR  <<* make bar solid *>>
<<endif>>
<<*---Generate the SAY lines needed to display records on the screen---*>>
<<ColorIsOk := False>>  <<*  Suppress Color for text objects in MultiLines *>>
<<AtSay('CurRow')>>
   
<<if FoxPro>>          <<**  Get user key press  **>>
      DO WHILE MDOWN() .AND. MouseTime > SECONDS() - MouseDelay
         **  --  Keeps the mouse button from repeating too quickley
      ENDDO
      DO WHILE .T.
         IF MDOWN()      &&  mouse button is still down
            KeyCode=151
         ELSE
            KeyCode=INKEY(0,'HM')          &&  get KEY COMMAND  ******************
            LastCode = 0
            MouseDelay = 0.4   &&  reset the mouse debounce delay
         ENDIF
         MouseTime = SECONDS()  &&  Time allowed between repeats

         IF KeyCode=151   &&  Mouse Clicked
            DO CASE
            CASE MCOL()=ScrnRight+{RightMarg}    && Mouse is in Right Border
               DO CASE
               CASE MROW()=1              &&  Up
                  KeyCode=5
               CASE MROW()=ScrnBot        &&  Down
                  KeyCode=24
               CASE MROW()=0              &&  Zoom
                  KeyCode=90
              * CASE MROW()=ScrnBot+1      &&  Help is lower right corner
              *    KeyCode=28
               CASE MROW()>1 .AND. MROW()< wThumb         &&  PgUp
                  KeyCode=18   &&  PgUp
               CASE MROW()<ScrnBot .AND. MROW()> wThumb   &&  PgDn
                  KeyCode=3    &&  PgDn
               ENDCASE
            CASE MROW()=ScrnBot+1      &&  Help is all of last line
               KeyCode=28
            CASE MCOL()=0 .AND. MROW()=0    &&  Close Window
               KeyCode=27   &&  ESC
            CASE MCOL()>=ScrnLeft  .AND. MCOL()<=ScrnRight .AND. ;
                  MROW()>=WindowTop .AND. MROW()<=ScrnBot
               MouseMove=.T.  &&  Mouse is within the window so move HighLite
               EXIT
            **  --  OTHERWISE Mouse Click has no meaning
            ENDCASE

            IF KeyCode#151 &&  Press was translated to a key press code
               IF LastCode = KeyCode
                  MouseDelay = 0.0     &&  No delay for mouse repeate
               ELSE  && reset delay and keypress
                  MouseDelay = 0.4     &&  delay for 1st click
                  LastCode = KeyCode
               ENDIF
               EXIT
            ENDIF

         ELSE
            EXIT
         ENDIF
      ENDDO
<<else>>       <<*  FoxBase  *>>
      KeyCode=INKEY(0)          &&  get KEY COMMAND  ******************
<<endif>>
      
      SET COLOR TO {fieldcolor}         &&  Turn Highlite Off
<<if MultiLine>>
   <<genln('      @ CurRow,ScrnLeft TO CurRow+',LinesPerRec-1,',ScrnRight CLEAR')>>  <<* make bar solid *>>
<<else>>
      @ CurRow,ScrnLeft TO CurRow,ScrnRight CLEAR  <<* make bar solid *>>
<<endif>>
<<*---Generate the SAY lines needed to display records on the screen---*>>
<<ColorIsOk := True>>  <<*  Color is Ok for text objects in MultiLines *>>
<<AtSay('CurRow')>>
<<if FoxPro>>
      IF MouseMove         &&  move highlite to mouse row
         MouseMove = .F.
         SKIP INT((MROW()-ScrnTop)/{LinesPerRec})-INT((CurRow-ScrnTop)/{LinesPerRec})
         CurRow=ScrnTop+INT((MROW()-ScrnTop)/{LinesPerRec})*{LinesPerRec}
   <<if TagOnly>>
         KeyCode=32     &&  Tag/Untag
   <<endif>>
      ENDIF
<<endif>>
      *-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
   ENDDO         while .T.         Main Loop
   *=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
<<if FoxPro>>
   RELEASE window ZoomIn
   RELEASE window ZoomOut
<<endif>>
ELSE  &&  Fatal error
   SET COLOR TO W+/R
   ?? CHR(7)
<<if FoxPro>>
   DEFINE WINDOW PkWindow FROM 10,20 TO 13,24+LEN(PkError) DOUBLE ;
      TITLE '[ FATAL ERROR ]'
   ACTIVATE WINDOW PkWindow
   @ 0,2 SAY PkError
   @ 1,3 SAY '< Press any key >'
   ans=INKEY(0,'M')
   RELEASE WINDOW PkWindow
<<else>>
   @ 10,20,12,24+LEN(PkError) BOX "ͻȺ "
   @ 11,22 SAY PkError
   @ 12,32 SAY '< Press any key >'
   ans=INKEY(0)
<<endif>>
ENDIF PkError = ''
*
* ---Closing operations.
<<#
if FoxPro
   genln('SET COLOR OF SCHEME 1 TO &PickSch1  &&  Restore Colors   [FoxPro]')
   genln('SET COLOR OF SCHEME 2 TO &PickSch2  &&  Restore Colors   [FoxPro]')
else
   genln('SET COLOR TO &PickColor')
   genln('RESTORE SCREEN FROM PickScrn')
   genln('Null = SYS(2002,1)        &&  Turn the cursor on       [Fox 2.1]')
endif
IF 'CLOSE' = UPPER(GetUser(2,fuser))    <<* DBF was not open, so close it *>>
   forall databases  
      if dbfnam
         gen('SELECT ')
         if dbfals
            genln(dbfals)
         else
            filespec( dbfnam,fpath,fname,fext )
            genln(fname)
         endif
         genln('USE')
      endif
   endfor
else                         <<* DBF was open *>>
   genln('IF KeyCode=27 .AND. rSave#0 .AND. rSave < DbfRec')
   genln('   GOTO rSave')
   genln('ENDIF')
endif
if MultiPick
   genln("IF LEFT(PkError,3)#'ERR'")
   genln('  SELECT PK   &&  Close Pick file')
   genln('  USE')
   genln('ENDIF')
endif
#>>
SELECT &WorkArea          &&  restore the work area
<<if ReturnFunction>>      <<*  return a value only  *>>
RETURN Target
<<else>>
RETURN
<<endif>>
* EOF: {prgname}
<<end>> <<*ProgramBody*>>

<<* PickMAIN.INC *>>
