FUNCTION PARSE
parameters string,piece_num,delim

priv c,piece,str_len,piece_cnt,char,pars_cntr

* -- Be very cautious about passing 'double macros'
*    e.g. the NAME of a char. variable is stored in a
*    variable called X. The VALUE of X is what I wnat to PARSE
*    PARSE(&X.,...,...) does not pass the value of X, but the string
*    which is the name of X! Why? I don't know yet!

set talk off
string = ltrim(trim(string))
if type('delim') = 'U'
  delim = ' '
else
  delim = left(delim,1)
endif
if delim = ' ' .and.  at('  ',string) <> 0
  string = singspac(string)
endif
str_len = len(string)
piece = ''
piece_cnt = 0
pars_cntr = 1

* -- Funtion may want to know only the count of pieces
if piece_num = 0
  return chrcount(delim,iif(right(string,1)<>delim,string+delim,string))
endif

* -- Routine to extract a piece
do while pars_cntr <= str_len
 char = substr(string,pars_cntr,1)
 if  char <> delim
   piece = piece + char
   if pars_cntr = str_len
     piece_cnt = piece_cnt + 1
     exit
   endif
 else
   piece_cnt = piece_cnt + 1
   if piece_cnt = piece_num
     exit
   endif
   piece = ''
 endif
 pars_cntr = pars_cntr + 1
enddo
RETURN iif(piece_cnt = piece_num,piece,'')
*
FUNCTION NAMEPARS
parameters name_var, salu_var, fname_var, lname_var
private c, subscr

str = ltrim(rtrim(name_var))
if 'U' $ type('salu_var')+type('fname_var')+type('lname_var')
  store 'tmp_salu' to salu_var
  store 'tmp_fname' to fname_var
  store 'tmp_lname' to lname_var
  public &salu_var.,&fname_var.,&lname_var.
  store '' to &salu_var.,&fname_var.,&lname_var.
else
  store '' to &salu_var.,&fname_var.,&lname_var.
endif

if len(trim(str)) = 0 .or. 'M' = uppe(trim(str))
  return ''
endif

* -- Count the pieces
c = 1
do while len(trim(parse((str),(c),' '))) > 0
  c = c + 1
enddo
pc_cnt = c-1

* -- If there is only one piece, put it in the first name
if pc_cnt = 1
  store '' to &salu_var., &lname_var.
  store trim(parse((str),1,' ')) to &fname_var.
  return ''
endif

* -- Put the pieces into an array
declare  pieces[pc_cnt]
declare pc_done[pc_cnt]
c = 1
do while c <= pc_cnt
  subscr = ltrim(str(c))
  pieces[c] = parse((str),(c),' ')
  pc_done[c] = .f.
  c = c + 1
enddo

* -- Try an easy test first
if pc_cnt = 3
  if issalu(pieces[1])
    store pieces[1] to &salu_var.
    if .not. isinitial(pieces[3])
      store pieces[2] to &fname_var.
      store pieces[3] to &lname_var.
    else
      store pieces[2] + ' ' + pieces[3] to &fname_var.
    endif
  else
    if .not. isinitial(pieces[3]) .and. .not. ishonorif(pieces[3])
      store pieces[1] + ' ' + pieces[2] to &fname_var.
      store pieces[3] to &lname_var.
    else
      store pieces[1] to &fname_var.
      store pieces[2] + ' ' + pieces[3] to &lname_var.
    endif
  endif
else
  * -- Attack honorifics
  c = pc_cnt
  do while (ishonorif(pieces[c]) .or. ;
    (right(pieces[iif(c>1,c-1,1)],1)=',') .and. c >= 2)
    store pieces[c] + iif(len(trim(&lname_var.))>0,' ','') + &lname_var. to &lname_var.
    pc_done[c] = .t.
    c = c - 1
  enddo

  * -- Honorifics are out of the way. I'll allow for the last name
  *    to consist of up to 2 pieces.
  if .not. isinitial(pieces[c])
    store pieces[c] + iif(len(trim(&lname_var.))>0,' ','') + &lname_var. to &lname_var.
    pc_done[c] = .t.
    c = c - 1
    if pieces[c] = '-'
      store pieces[c] + iif(len(trim(&lname_var.))>0,' ','') + &lname_var. to &lname_var.
      pc_done[c] = .t.
      c = c - 1
      if .not. isinitial(pieces[c])
        store pieces[c] + iif(len(trim(&lname_var.))>0,' ','') + &lname_var. to &lname_var.
        pc_done[c] = .t.
      endif
    endif
  endif

  * -- Work on first piece.
  if issalu(pieces[1])
    store pieces[1] to &salu_var.
    pc_done[1] = .t.
    if uppe(pieces[2]) $ 'AND/&'
      store &salu_var. + ' ' + pieces[2] to &salu_var.
      pc_done[2] = .t.
      if issalu(pieces[3])
        store &salu_var. + ' ' + pieces[3] to &salu_var.
        pc_done[3] = .t.
      endif
    endif
  else
    store pieces[1] to &fname_var.
    pc_done[1] = .t.
  endif

  * -- FNAME 'Cleanup'
  c = 1
  do while c <= pc_cnt
    if .not. pc_done[c]
      store &fname_var. + iif(len(trim(&fname_var.))>0,' ','') + pieces[c] to &fname_var.
    endif
    c = c + 1
  enddo
endif
rele pieces
rele pc_done
RETURN ''
*
FUNCTION ISHONORIF
parameters c_string
c_string = uppe(trim(c_string))
return iif( (at('.',c_string) > 0 .and. at('.',c_string) <> len(c_string)) .or. ;
(c_string $ uppe('Ph.D/M.D./III/IV/D.ED./JR/SR')),.t.,.f.)
*
FUNCTION ISINITIAL
parameters c_string
s_string = uppe(trim(c_string))
return iif(len(c_string)=1 .or. (len(c_string)=2.and.right(c_string,1)='.'),.t.,.f.)
*
FUNCTION ISSALU
parameters c_string
priv ret_val
c_string=uppe(trim(c_string))
if len(c_string) <= 4
  ret_val = iif(at('.',c_string)=len(c_string),.t.,(c_string $ uppe('Mr/Ms/Sr/Rev/Dr/Capt/Lt')))
else
  ret_val = .f.
endif
RETURN ret_val
*
FUNCTION NOTHE
parameters str
set talk off
priv ret_val
ret_val = iif(uppe(left(str,4))="THE ",substr(str,5,len(str)-3),str)
RETURN ret_val
*
FUNCTION GRANDOM
parameters highest

clear
set talk off
do while .t.
 x = int(rand()*100)
 if x <= highest
   exit
 endif
enddo
set talk on
return x
*
PROCEDURE INKEY
set cons off
priv lc_talk
lc_talk = set('talk')
set talk off
set cons on
x = 0
do while x = 0
  x = inkey()
enddo
? x
set talk &lc_talk.
RETURN
*
PROCEDURE RKIKVALS
** ---------------------
* Program: RKIKVALS.PRG
* Author : Gordon W. Rose
* Date   : July 26, 1987
** ---------------------

* -- READKEY values
*rk_bakchr  =    0     && -- CTRL-H or -S    No        8,19  Back one char.
*rk_forchr  =    1     && -- CTRL-D          No        4     Forward one char.
*rk_home     =   2     && -- CTRL-A          No        1     Back one word
*rk_end      =   3     && -- CTRL-F          No        6     Frwrd. one word
*rk_uparrow  =   4     && -- CTRL-E          No        5     Back one Fld.
*rk_dnarrow  =   5     && -- CTRL-J          No       24     Frwrd. one Fld.
*rk_pageup   =   6     && -- CTRL-R         Yes       18     Screen
*rk_pagedn   =   7     && -- CTRL-C         Yes        3     "
*rk_bakpan   =   8     && -- CTRL-Z          No       26     Pan left
*rk_forpan   =   9     && -- CTRL-B          No        2     Pan Right
*rk_delete   =  10     && -- CTRL-U          No       21     Delete something
*rk_insert   =  11     && -- CTRL-N          No       14     Insert something
*rk_escape   =  12     && -- CTRL-Q         Yes       27
*rk_ctr_end  =  14     && -- CTRL-W         Yes       23     Terminate with save
*rk_filled   = 15      && - CTRL-M          Yes       13     Filled past end
*rk_return = 16        && - <-|             Yes       13     Filled past end
*rk_ctr_hom  =  33     && -- CTRL-HOME       No       29     Menu Display toggle
*rk_ctr_pgu  =  34     && -- CTRL-PgUp       No       30     Zoom out
*rk_ctr_pgd  =  35     && -- CTRL-PgDn       No       31     Zoom in
*rk_help     =  36     && -- F1              No       28     Help

************    No.         Key Pressed     Clipper Inkey() Meaning
public rk_bakchr
rk_bakchr  =    0     && -- CTRL-H or -S    No           Back one char.
                      &&    Backspace               127
public rk_update
rk_update = 256

public rk_forchr
rk_forchr  =    1     && -- CTRL-D          No        4  Forward one char.
                      &&        -L                   12
public rk_home
rk_home     =   2     && -- CTRL-A          No        1  Back one word
                      &&

public rk_end
rk_end      =   3     && -- CTRL-F          No        6   Frwrd. one word
                      &&
public rk_uparrow
rk_uparrow  =   4     && -- CTRL-E          No        5   Back one Fld.

public rk_dnarrow
rk_dnarrow  =   5     && -- CTRL-J          No       24   Frwrd. one Fld.
* --------------->    &&        -X

public rk_pageup
rk_pageup   =   6     && -- CTRL-R         Yes       18    Screen

public rk_pagedn
rk_pagedn   =   7     && -- CTRL-C         Yes        3    "

public rk_bakpan
rk_bakpan   =   8     && -- CTRL-Z          No       26     Pan left
* --------------->    &&        - <-

public rk_forpan
rk_forpan   =   9     && -- CTRL-B          No        2     Pan Right
* --------------->    &&        - ->

public rk_delete
rk_delete   =  10     && -- CTRL-U          No       21     Delete something

public rk_insert
rk_insert   =  11     && -- CTRL-N          No       14     Insert something

public rk_escape
rk_escape   =  12     && -- CTRL-Q         Yes       27

public rk_ctr_end
rk_ctr_end  =  14     && -- CTRL-W         Yes       23     Terminate with save

public rk_filled
rk_filled   = 15      && - CTRL-M          Yes       13     Filled past end

public rk_return
rk_return = 16        && - <-|             Yes       13     Filled past end

public rk_ctr_hom
rk_ctr_hom  =  33     && -- CTRL-HOME       No       23     Menu Display toggle

public rk_ctr_pgu
rk_ctr_pgu  =  34     && -- CTRL-PgUp       No       30     Zoom out

public rk_ctr_pgd
rk_ctr_pgd  =  35     && -- CTRL-PgDn       No       31     Zoom in

public rk_help
rk_help     =  36     && -- F1              No       28     Help

* -- INKEY values
public ik_uparrow
ik_uparrow  =   5

public ik_dnarrow
ik_dnarrow  =  24

public ik_left
ik_left     =  19

public ik_right
ik_right     =  4

public arrow_keys
arrow_keys = chr(ik_uparrow)+chr(ik_dnarrow)+chr(ik_left)+chr(ik_right)

public ik_ctr_pgu
ik_ctr_pgu  =  31

public ik_ctr_pgd
ik_ctr_pgd  =  30

public ik_pageup
ik_pageup   =  18

public ik_pagedn
ik_pagedn   =   3

public ik_ctr_hom
ik_ctr_hom  =  29

public ik_ctr_end
ik_ctr_end  =  23

public ik_ctr_y
ik_ctr_y = 25

public ik_return
ik_return = 13

public ik_escape
ik_escape  = 27

public ik_end
ik_end      =   6

public ik_home
ik_home     =   1

public ik_tab
ik_tab      =   9

public curs_keys
curs_keys = arrow_keys+chr(ik_ctr_pgu)+chr(ik_ctr_pgd)+ ;
chr(ik_pageup)+chr(ik_pagedn)+chr(ik_ctr_hom)+chr(ik_ctr_end)+ ;
chr(ik_end)+chr(ik_home)+chr(ik_tab)

public ik_delete
ik_delete   =   7

public ik_help
ik_help     =  36

* -- Inkey values for SHIFT_F?, CTRL_F?, and ALT_F? keys
z = 1
do while z <= 2  && -- can be 3 if I want to use ALT_F? keys
  do case
    case z = 1
      fkey_var = 'SHIFT_F'
    case z = 2
      fkey_var = 'CTRL_F'
    case z = 3
      fkey_var = 'ALT_F'
  endcase
  x = 1
  do while x <=10
    fkey_tmp = fkey_var + ltrim(str(x,2))
    public &fkey_tmp
    if .not. 'FOX' $ uppe(version())
      temp = ((z * -10)-(x-1))
      store temp to &fkey_tmp
    else
      temp = 83 + ((z-1)+10) + x
      store temp to &fkey_tmp
    endif
    x = x + 1
  enddo
  z = z + 1
enddo

* -- ALT- key combinations for HOT_KEYS
*    Create public vars first
c = 0
asc_a = 65
do while c <= 25
  alt_var = 'alt_' + chr(asc_a + c)
  public &alt_var
  store 0 to &alt_var
  c = c + 1
enddo

* -- Assign INKEY values to function key variables
public f1
f1 = 28           && -- F1 has a unique value. Don't ask me why.
c1 = -1
c2 = 2
do while c2 <=10
  fkey_var = "f" + ltrim(str(c2))
  public &fkey_var
  store c1 to &fkey_var
  c1 = c1 - 1
  c2 = c2 + 1
enddo
RETURN
* EOF: key_var.prg

RETURN
*
PROCEDURE CHOICE
parameters row,col,string,c_line,draw_box

if 'U' $ type('front')+type('yes')+type('no')+type('choice')
  public front,choice,yes,no
endif
if type('draw_box') <> 'L'
  draw_box = .f.
endif
set cursor off
save screen to choice_scr
store .f. to Yes,No
col = iif(col = 0,39-((len(c_line)+4)/2),col)
row_offset = iif(draw_box,1,0)
col_offset = iif(draw_box,2,0)
@ row - row_offset, col - col_offset clear to ;
row + row_offset, col + len(c_line) + 6
if draw_box
  @ row - row_offset, col - col_offset to ;
  row + row_offset, col + len(c_line) + 6 double
endif
@ row , col say c_line + " [ ]"
set cons off
key = 0
do while .not. (upper(chr(iif(key>=0,key,0))) $ upper(string))
  key = inkey(0)
  clear typeahead
enddo
choice = upper(chr(key))
Yes    = iif(choice = "Y",.t.,.f.)
No     = iif(choice = "N",.t.,.f.)
set cons on
restore screen from choice_scr
set cursor on
RETURN
*



