FUNCTION POPCALEN
*
*	ANTONIO CORDOBA ( 3/93 )
*	compuserve 71764, 2234
*
*	Function POPCALEN()
*
*	This function is used to display a popup calendar from which a date
*	can be selected.  
*
*	SYNTAX   : POPCALEN( [<expD>] )
*
*           Where <expD> is an optional parameter that establishes the 
*           default date to be highlighted by the function upon entry.
*           If no parameter is passed, the date from the system clock
*           is used as default.
*
*	EXAMPLES : my_date = POPCALEN()
*             ? POPCALEN( {12/03/91} )
*             _D_Day = POPCALEN( _D_Day )
*             
*           In any case the function returns a value type <date> according
*           to the user selection.  To select a date use the arrow keys
*           and press enter.  If <escape> is used to exit, the default date
*           is returned.  To select a date with the mouse use the left 
*           button to highlight and the right button to select.
*
*           This function uses to foxpro built in calendar/diary.  To keep
*           existing diary entries from showing up when this routine 
*           executes, a different resource file must be set up.  The files
*           DIARY.DBF and DIARY.FPT contain an empty resource file that
*           can be used for this purpose.  If the routine is used over a 
*           network the file DIARY.DBF has to be set as read only at DOS 
*           level.  ( use ATTRIB +r DIARY.DBF or the FILER utility )
*
*
PARAMETERS d_ddate

*	Define private variables
PRIVATE d_ddate, d_odate, d_savereso, d_saverfil, d_savetalk, ;
        d_poprow, d_popcol 

*	Save current talk status and set it to off
IF SET("TALK") = "ON"
	SET TALK OFF
	d_savetalk = "ON"
ELSE
	d_savetalk = "OFF"
ENDIF

*	Define popup location
d_poprow = 1
d_popcol = 1

*	Define window to contain calendar window
*	( to prevent user access to calendar window panel )
DEFINE WINDOW popcapsule ;
   FROM d_poprow, d_popcol ;
   TO d_poprow + 15,  d_popcol + 21 ;
   FLOAT GROW NOZOOM NOCLOSE SHADOW

*	Test for passed parameter type
IF TYPE("d_ddate") # "D"
   *	If not date, set default date from system
	d_ddate = DATE()
ENDIF

*	Save current diary date
d_odate = _DIARYDATE

*	Save current resource status
d_savereso = SET("RESOURCE")

*	Test for existence of alternate resource file
IF FILE("diary.dbf")
   *	If exists, save current resource name and set to alternate
	d_saverfil = SET("RESOURCE",1)
	SET RESOURCE TO ("DIARY.DBF")
ELSE
	*	Otherwise just shut resource off
	SET RESOURCE OFF
ENDIF

*	Save and clear current key definitions
PUSH KEY CLEAR

*	Define keys to exit popup calendar 
*	( any of these will exit the foundation read below )
ON KEY LABEL ENTER DO OUT
ON KEY LABEL ESC DO OUT
ON KEY LABEL RIGHTMOUSE DO OUT

*	Turn tab key off
ON KEY LABEL TAB =0

*	Store default date to diary date
_DIARYDATE = d_ddate

*	Activate calendar
ACTIVATE WINDOW CALENDAR IN WINDOW popcapsule

*	Push the panel outside the container window
MOVE WINDOW CALENDAR BY -2, -1

*	Activate container window
ACTIVATE WINDOW popcapsule

*	Foundation read to give user chance to select date
READ ACTIVATE TEST() VALID !WONTOP("CALENDAR") WITH popcapsule

*	( This point is reached only after one of the exit keys was hit )
*	Restore previous diary date
_DIARYDATE = d_odate

*	Test if a resource file name was saved
IF TYPE ("d_saverfil") = "C"
   *	If so, use it.
   SET RESOURCE TO (d_saverfil)
ENDIF

*	Restore resouce and talk statuses
SET RESOURCE &d_savereso
SET TALK &d_savetalk

*	Restore key definitions
POP KEY

*	Return resulting date
RETURN d_ddate



*
*	Procedure to exit calendar window.  ( Triggered by exit keys )
*
PROCEDURE OUT

*	Release container window ( and calendar )
RELEASE WINDOW popcapsule

*	Test for escape key used
IF LASTKEY() # 27
	*	If not, get selected date
   d_ddate = _DIARYDATE
ENDIF

*	Trigger foundation read valid clause
CLEAR READ

*	Return to caller module
RETURN 
