***************************************************
** PACKER.PRG                        Version 1.0 **
**                                               **
** Randy Rinker                         08/30/93 **
**                                               **
**  This program builds a popup of all open      **
** tables and allows the user to select one or   **
** all for packing.                              **
**                                               **
** Parameters: None                              **
**                                               **
***************************************************

PRIVATE m.choice, openfiles, x, c
SET TALK OFF
DIMENSION openfiles(225,2)                          && Array to store aliases
x = 1
FOR c = 1 to 225
    IF USED(c)
        openfiles(x,1) = ALIAS(c)
        openfiles(x,2) = c
        x = x + 1
    ENDIF
ENDFOR
IF x > 1                                         && If there is at least 1 file..
    IF x > 2                                     && If there are two or more..
        DIMENSION openfiles(x,2)
        openfiles(x,1) = " Pack ALL Files "      && Choice to do all files
        =ASORT(openfiles,1)
    ELSE
        x = 1
        DIMENSION openfiles(x,2)
    ENDIF	
    @ 4,2 GET m.choice;
        FROM openfiles;
        PICTURE "@&T";
        DEFAULT 1;
        SIZE x,22;
        MESSAGE "Select file to Pack, or ESC to Cancel"
    READ 
ELSE
    WAIT WINDOW "No files open to pack" NOWAIT   && No files to process!
ENDIF
IF !(LASTKEY() = 27 .OR. X = 1)                  && If a selection was made
    IF yesno("Are you sure")
        IF m.choice = x
            FOR c = 1 to (x - 1)                 && Pack all files
                SELECT(openfiles(c,2))
                PACK
            ENDFOR
        ELSE
            SELECT(m.choice)                     && Pack selected file
            PACK
        ENDIF
    ENDIF
ENDIF
CLEAR
SET TALK ON
RETURN
***************************************************

***************************************************
** YESNO Function                    Version 1.0 **
**                                               **
** Randy Rinker                         08/11/93 **
**                                               **
**  From a function originally published in PC   **
** Magazine, YESNO displays a character string   **
** prompt and waits for the user to select Y for **
** Yes or N for No.  The functions returns .T.   **
** to the calling routine if the user selected   **
** Yes.                                          **
**                                               **
** Parameters: question <expc>                   **
**                                               **
***************************************************
FUNCTION yesno	
	PARAMETER question
	PRIVATE c
	c = ""
	DO WHILE "" = c
		WAIT WINDOW question + "? (Y/N)" TO c
	ENDDO
RETURN UPPER(c) = "Y"
***************************************************
**:EOF - packer.prg